----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    18:54:08 04/19/2011 
-- Design Name: 
-- Module Name:    RAM_64 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: SYNTHESE d'une RAM 64 octet par inferation
-- la ram possde un port d'criture et un port de lecture
-- le port primaire est  lecture et ecrite et le port secondaire  lecture seule
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
Library NocLib;
use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity RAM_64 is
    Port ( clka, clkb : in std_logic;
			  wea : in std_logic;
			  ena, enb : in std_logic;
			  addra, addrb : in std_logic_vector(5 downto 0);
			  dia : in std_logic_vector(Word-1 downto 0);
			  dob : out std_logic_vector(Word-1 downto 0));
end RAM_64;

architecture Behavioral of RAM_64 is
	type ram_type is array (63 downto 0) of std_logic_vector (Word-1 downto 0);
	signal RAM: ram_type;
begin
 process (clka)
	begin
		if clka'event and clka = '1' then
			if ena = '1' then
				if wea = '1' then
					RAM(conv_integer(addra)) <= dia;
				end if;
			end if;
		 end if;
 end process;
 
 process (clkb)
	begin
		if clkb'event and clkb = '1' then
			if enb = '1' then
				--dob <= RAM(conv_integer(addrb)) ;
			end if;
		end if;
 end process;
	dob <= RAM(conv_integer(addrb)) ;
end Behavioral;

