--	Package File Template
--
--	Purpose: This package defines the size of NoC ports and the number
-- of hardware tasks to create with the Mpi HCL environment.
-- The NoC_size parameter may vary from 2 to 16
-- The STATIC_HT parameter must be less or equal to the NoC_Size parameter
-- The DYN_ALLOWED authorize the binding of HT template environment to all the Noc Ports

library IEEE;
use IEEE.STD_LOGIC_1164.all;

package Hcl_Arch_conf is

  
  
-- Declare constants

  constant NOC_SIZE		: integer :=4; --(2 to 16)indicates the number of NoC port to instantiate
  constant STATIC_HT		: integer := 2;--(2 to NOC_SIZE)gives the the number of HT to Hardwire
  constant DYN_ALLOWED	: std_logic:='1'; --allow the creation of dynamic hardware tasks
-- Declare functions and procedure

end Hcl_Arch_conf;


package body Hcl_Arch_conf is


 
end Hcl_Arch_conf;
