----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    17:58:09 04/07/2014 
-- Design Name: 
-- Module Name:    Def_Request - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Def_Request is
generic (NB_IO :positive:=4);
    Port ( Req : in  STD_LOGIC_VECTOR (NB_IO**2 downto 1);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  fifo_full : in STD_LOGIC_VECTOR (NB_IO downto 1);
           priority_rotation : in  STD_LOGIC_VECTOR (NB_IO downto 1);
           grant : in  STD_LOGIC_VECTOR (NB_IO**2 downto 1);
           request : out  STD_LOGIC_VECTOR (NB_IO**2 downto 1));
end Def_Request;

architecture Behavioral of Def_Request is
constant NB_IO2 :positive:=NB_IO**2; -- le carr du nombre de ports d'E/S
 Signal Fifo_out_full :  STD_LOGIC_VECTOR (NB_IO downto 1);
 signal grant_latch : std_logic_vector(NB_IO2 downto 1); 
 signal priority_rotation_en : std_logic; 
signal req_grant,Grant_bak :  std_logic_vector(NB_IO2 downto 1):=(others=>'0');
 signal Mreq :  std_logic_vector(NB_IO2 downto 1):=(others=>'1');

begin
 Req_grant<=(req and grant );
 priority_rotation_en <= '1' when   unsigned(priority_rotation) = 2**NB_IO-1 else 	'0'; 
 request<=req and mreq;
--latch  qui memorise le signal grant pendant la transmission 
 grant_latch_process : process(clk)
  begin 
  if rising_edge(clk) then 
   if reset = '1' then 
 		grant_latch <= (others => '0');
 		Fifo_out_full<=(others => '0');
 	 elsif priority_rotation_en = '1' or unsigned(req_grant)=0 then 
	   grant_latch <= Grant;
	   Fifo_out_full<=fifo_full;
  else
    	 grant_latch <= Grant; 
    	 Fifo_out_full<=fifo_full; 
   end if; 
   end if; 

 end process; 
 def_mreq: process(grant_latch,fifo_full)

variable t:std_logic_vector(NB_IO2 downto 1):=(others=>'0');
begin 
    
  for i in 0 to NB_IO2-1 loop
    t(i+1):='0';
    --sur le front montant de fifo_full sauver l'tat Grant courant 
    if fifo_full(i mod NB_IO+1)='1' and  fifo_out_full(i mod NB_IO+1)='0' then
      Grant_bak(i+1)<= grant_latch(i+1);
    elsif fifo_full(i mod NB_IO+1)='0' and  fifo_out_full(i mod NB_IO+1)='0'  then
      Grant_bak(i+1)<='0';
    end if;
  for j in 0 to NB_IO-1 loop
    t(i+1):=t(i+1) or grant_latch(j*NB_IO+1+i mod NB_IO) or fifo_out_full(i mod NB_IO+1);
    
  end loop;
      mreq(i+1)<=not(t(i+1) ) or grant_latch(i+1)or grant_bak(i+1);    
  end loop;
end process;

end Behavioral;

