----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    14:00:24 08/01/2013 
-- Design Name: 
-- Module Name:    Ex5_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Ex5_FSM is
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
				
			  SpawnOn : in  STD_LOGIC;
           NocPortFree : in  STD_LOGIC;
           InterCSet : in  STD_LOGIC;
           TaskLoaded : in  STD_LOGIC;
           TaskInit : in  STD_LOGIC;
           TaskOn : in  STD_LOGIC;
           TimeOut : out  STD_LOGIC;
           DataReceived : in  STD_LOGIC_VECTOR (7 downto 0);
           DataToSend : out  STD_LOGIC_VECTOR (7 downto 0));
end Ex5_FSM;

architecture Behavioral of Ex5_FSM is
type Spawn_type is (Init,CheckFree,LoadTask,CountTask,StartTask,WaitTaskInit,SetGroup,SetInterCom,RetInterCom,ErrSpawn,EndSpawn); 
   signal spawn_st, next_spawn : spawn_type; 
begin
--Insert the following in the architecture after the begin keyword
   SYNC_spawn: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (reset = '1') then
            spawn_st <= init;
            
         else
           spawn_st <= next_spawn;
            --<output> <= <output>_i;
         -- assign other outputs to internal signals
         end if;        
      end if;
   end process;
 
   --MOORE State-Machine - Outputs based on state only
   OUTPUT_DECODE: process (Spawn_st)
   begin
      --insert statements to decode internal output signals
      --below is simple example
      case (spawn_st) is
         when init =>
            
         when CheckFree =>
            
         when LoadTask =>
           
			when StartTask =>
			
			when CountTask =>		
			
			 when WaitAllTaskInit =>
			 
			 when SetGroup =>
			 
			 when SetInterCom =>
			 
			 when RetInterCom =>
			 
			 when EndSpawn =>
			 
         when others =>
            
      end case;      
   end process;
 
   NEXT_STATE_DECODE: process (spawn_st, spawnOn,Datareceived)
   begin
      --declare default state for next_state to avoid latches
      next_spawn <= spawn_st;  --default is to stay in current state
      --insert statements to decode next_state
      --below is a simple example
      case (spawn_st) is
         when init =>
            if spawnOn = '1' then
               next_spawn <= Checkfree;
            end if;
         when CheckFree =>
            if NoCPortFree = '1' then
               next_spawn<= LoadTask;
            end if;
         when LoadTask =>
           next_spawn <= CountTask;
			when StartTask =>
				 if TaskInit = '1' then
           next_spawn <= WaitAllTaskInit;
			  end if;
			 when WaitAllTaskInit =>
			 if InterComSet = '1' then
           next_spawn <= SetGroup;
			 end if;
			 when SetGroup =>
			 if InterComSet = '1' then
           next_spawn <= SetInterCom ;
			 end if;
			 when SetInterCom =>
			 if InterComSet = '1' then
           next_spawn <= RetInterCom ;
			 end if;
			 when RetInterCom =>
			 if AppAck = '1' then
				next_spawn <= EndSpawn;
			end if;
         when others =>
            next_spawn <= init;
      end case;      
   end process;


end Behavioral;

