----------------------------------------------------------------------------------
-- Company: 
-- Engineer:  GAMOM NGOUNOU 
-- 
-- Create Date:    18:33:31 03/05/2012 
-- Design Name: 
-- Module Name:    RAM_32_32 - Behavioral 
-- Project Name: MPI_Core
-- Target Devices: 
-- Tool versions: 
-- Description: permet de stocker les donnes locales de la librairie MPI
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity RAM_v is
generic(width : positive:=32; Size:positive:=16);
Port ( clka, clkb : in std_logic;
				reset: in std_logic;
			  wea : in std_logic;
			  ena, enb : in std_logic;
			  addra, addrb : in std_logic_vector(size-1 downto 0); --cinq lignes d'adresse
			  dia : in std_logic_vector(width-1 downto 0);
			  dob : out std_logic_vector(width-1 downto 0));
end RAM_v;

architecture Behavioral of RAM_v is
	attribute RAM_STYLE : string;
	signal Lra,Lrb :std_logic:='0';
	signal doado,dobdo:std_logic_vector(15 downto 0);
	signal DOPBDOP : std_logic_vector(1 downto 0);
	signal ADDRAWRADDR,ADDRBRDADDR :std_logic_vector(13 downto 0);
	signal REGCEA:std_logic;
	signal  DIADI :std_logic_vector(15 downto 0);  -- 16-bit input: A port data/LSB data input
   signal  DIPADIP :std_logic_vector(1 downto 0);  -- 2-bit input: A port parity/LSB parity input
	signal REGCEBREGCE :std_logic ; -- 1-bit input: B port register enable/Register enable input
   signal  RSTBRST :std_logic ;         -- 1-bit input: B port set/reset input
   signal  WEBWEU :std_logic_vector(1 downto 0):=(others=>'0') ;          -- 2-bit input: B port write enable input
      -- Port B Data: 16-bit (each) input: Port B data
   signal   DIBDI :std_logic_vector(15 downto 0):=(others=>'1');             -- 16-bit input: B port data/MSB data input
   signal    DIPBDIP :std_logic_vector(1 downto 0):=(others=>'1');         -- 2-bit input: B port parity/MSB parity input
	signal sel : std_logic_vector(1 downto 0);
	signal doa,dout : std_logic_vector(width-1 downto 0);
	type ram_type is array (2**(size-3)-1 downto 0) of std_logic_vector (width-1 downto 0);
	signal RAM: ram_type;
	attribute RAM_STYLE of RAM: signal is "BLOCK";
begin
 -- RAMB8BWER: 8k-bit Data and 1k-bit Parity Configurable Synchronous Block RAM
   --            Spartan-6
   -- Xilinx HDL Language Template, version 13.3

   RAMB8BWER_inst : RAMB8BWER
   generic map (
      -- DATA_WIDTH_A/DATA_WIDTH_B: 'If RAM_MODE="TDP": 0, 1, 2, 4, 9 or 18; If RAM_MODE="SDP": 36'
      DATA_WIDTH_A => 9,
      DATA_WIDTH_B => 9,
      -- DOA_REG/DOB_REG: Optional output register (0 or 1)
      DOA_REG => 0,
      DOB_REG => 0,
      -- EN_RSTRAM_A/EN_RSTRAM_B: Enable/disable RST
      EN_RSTRAM_A => TRUE,
      EN_RSTRAM_B => TRUE,
      -- INITP_00 to INITP_03: Initial memory contents.
      INITP_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INITP_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INITP_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INITP_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
      -- INIT_00 to INIT_1F: Initial memory contents.
      INIT_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_07 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_08 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_09 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0A => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0B => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0C => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0D => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0E => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0F => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_10 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_11 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_12 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_13 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_14 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_15 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_16 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_17 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_18 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_19 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_1A => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_1B => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_1C => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_1D => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_1E => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_1F => X"0000000000000000000000000000000000000000000000000000000000000000",
      -- INIT_A/INIT_B: Initial values on output port
      INIT_A => X"00000",
      INIT_B => X"00000",
      -- INIT_FILE: Not Supported
      INIT_FILE => "NONE",                                                             -- Do not modify
      -- RAM_MODE: "SDP" or "TDP" 
      RAM_MODE => "TDP",
      -- RSTTYPE: "SYNC" or "ASYNC" 
      RSTTYPE => "SYNC",
      -- RST_PRIORITY_A/RST_PRIORITY_B: "CE" or "SR" 
      RST_PRIORITY_A => "CE",
      RST_PRIORITY_B => "CE",
      -- SIM_COLLISION_CHECK: Collision check enable "ALL", "WARNING_ONLY", "GENERATE_X_ONLY" or "NONE" 
      SIM_COLLISION_CHECK => "ALL",
      -- SRVAL_A/SRVAL_B: Set/Reset value for RAM output
      SRVAL_A => X"00000",
      SRVAL_B => X"00000",
      -- WRITE_MODE_A/WRITE_MODE_B: "WRITE_FIRST", "READ_FIRST", or "NO_CHANGE" 
      WRITE_MODE_A => "WRITE_FIRST",
      WRITE_MODE_B => "WRITE_FIRST" 
   )
   port map (
      -- Port A Data: 16-bit (each) output: Port A data
      DOADO => DOADO,             -- 16-bit output: A port data/LSB data output
      DOPADOP => DOPADOP,         -- 2-bit output: A port parity/LSB parity output
      -- Port B Data: 16-bit (each) output: Port B data
      DOBDO => DOBDO,             -- 16-bit output: B port data/MSB data output
      DOPBDOP => DOPBDOP,         -- 2-bit output: B port parity/MSB parity output
      -- Port A Address/Control Signals: 13-bit (each) input: Port A address and control signals (write port
      -- when RAM_MODE="SDP")
      ADDRAWRADDR => ADDRAWRADDR, -- 13-bit input: A port address/Write address input
      CLKAWRCLK => CLKA,     -- 1-bit input: A port clock/Write clock input
      ENAWREN => ENA,         -- 1-bit input: A port enable/Write enable input
      REGCEA => REGCEA,           -- 1-bit input: A port register enable input
      RSTA => Reset,               -- 1-bit input: A port set/reset input
      WEAWEL => WEA,           -- 2-bit input: A port write enable input
      -- Port A Data: 16-bit (each) input: Port A data
      DIADI => DIADI,             -- 16-bit input: A port data/LSB data input
      DIPADIP => DIPADIP,         -- 2-bit input: A port parity/LSB parity input
      -- Port B Address/Control Signals: 13-bit (each) input: Port B address and control signals (read port
      -- when RAM_MODE="SDP")
      ADDRBRDADDR => ADDRBRDADDR, -- 13-bit input: B port address/Read address input
      CLKBRDCLK => clkb,     -- 1-bit input: B port clock/Read clock input
      ENBRDEN => ENB,         -- 1-bit input: B port enable/Read enable input
      REGCEBREGCE => REGCEBREGCE, -- 1-bit input: B port register enable/Register enable input
      RSTBRST => reset,         -- 1-bit input: B port set/reset input
      WEBWEU => WEBWEU,           -- 2-bit input: B port write enable input
      -- Port B Data: 16-bit (each) input: Port B data
      DIBDI => DIBDI,             -- 16-bit input: B port data/MSB data input
      DIPBDIP => DIPBDIP          -- 2-bit input: B port parity/MSB parity input
   );
 
 DIADI(width-1 downto 0)<=dia;
 ADDRAWRADDR <=addra(10 downto 0);
 ADDRBRDADDR <=addrb(10 downto 0);
 doa<=DOADO(width-1 downt0 0);
 dout<=DOBDO(width-1 downt0 0);
 process (clka)
	begin
		if clka'event and clka = '1' then
			if ena = '1' then
				if wea = '1' then
				  if conv_integer(addra)>8191 then
				      report  "Erreur d'adresse";
				  else
          					--RAM(conv_integer(addra)) <= dia;
					end if;
				end if;
				if conv_integer(addrb)>8191 then
				      report  "Erreur d'adresse";
				  else	
				--doa<=RAM(conv_integer(addrb));
			   end if;
				Lra<='1';
			else 
				if lrb='1' then
						Lra<='0';
				end if;
			end if;
		 end if;
 end process;

 
 process (clkb)	
 begin
		if clkb'event and clkb = '1' then
			if enb = '1' then
				Lrb<='1';	
				if conv_integer(addrb)>8191 then
				      report  "Erreur d'adresse";
				  else	
				  --dout <= RAM(conv_integer(addrb)) ;
				end if;
			else
				if Lra='1' then
					Lrb<='0';
				end if;
			end if;
		end if;
 end process;
 
 sel<=(Lra,Lrb);
 With  sel select
 dob <=dout when "11",
      doa  when "10",
		dout when "01",
		dout when "00",
		dout when others;
		
end Behavioral;

