LIBRARY ieee  ; 
LIBRARY unisim  ; 
LIBRARY work  ; 
USE ieee.std_logic_1164.all  ; 
USE ieee.std_logic_arith.all  ; 
USE ieee.STD_LOGIC_UNSIGNED.all  ; 
USE unisim.VCOMPONENTS.all  ; 
USE work.CoreTypes.all  ; 
ENTITY fifo_256_fwft_tb  IS 
END ; 
 
ARCHITECTURE fifo_256_fwft_tb_arch OF fifo_256_fwft_tb IS
  SIGNAL dout   :  std_logic_vector (7 downto 0)  ; 
  SIGNAL srst   :  STD_LOGIC  ; 
  SIGNAL rd_en   :  STD_LOGIC  ; 
  SIGNAL clk   :  STD_LOGIC:='0'  ; 
  SIGNAL full   :  STD_LOGIC  ; 
  SIGNAL empty   :  STD_LOGIC  ; 
  SIGNAL wr_en   :  STD_LOGIC  ; 
  SIGNAL din   :  std_logic_vector (7 downto 0)  ; 
  COMPONENT FIFO_256_FWFT  
    PORT ( 
      dout  : out std_logic_vector (7 downto 0) ; 
      srst  : in STD_LOGIC ; 
      rd_en  : in STD_LOGIC ; 
      clk  : in STD_LOGIC ; 
      full  : out STD_LOGIC ; 
      empty  : out STD_LOGIC ; 
      wr_en  : in STD_LOGIC ; 
      din  : in std_logic_vector (7 downto 0) ); 
  END COMPONENT ; 
BEGIN
  DUT  : FIFO_256_FWFT  
    PORT MAP ( 
      dout   => dout  ,
      srst   => srst  ,
      rd_en   => rd_en  ,
      clk   => clk  ,
      full   => full  ,
      empty   => empty  ,
      wr_en   => wr_en  ,
      din   => din   ) ; 
 


clk <= not clk after 5 ns;
srst<='0','1' after 10 ns,'0' after 100 ns;

input_data:process
begin
  
  wr_en<='0';
  wait for 10 ns;
  srst<='0';
  wr_en<='1';
  for i in 0 to 10 loop
  din<=conv_std_logic_vector(i,8);
  wait for 10 ns;
end loop;
  wr_en<='0';
  wait for 10 ns;
  
  for i in 11 to 20 loop
   wr_en<='1'; 
  din<=conv_std_logic_vector(i,8);
  wait for 10 ns;
  wr_en<='0';
  wait for 10 ns;
end loop;
  --wait;
end process;

output_data:process(clk,empty)
begin
 -- if rising_edge(clk) then
  if empty='0' then 
        rd_en<='1';
else
  rd_en<='0';
end if;
    
--end if;
end process;

end fifo_256_fwft_tb_arch;