----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    17:03:41 10/22/2012 
-- Design Name: 
-- Module Name:    Proto_receiv - ReceiveProto 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
USE ieee.numeric_std.ALL;
use work.CoreTypes.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Proto_receiv is
 generic (sizemem : natural := 64);
 port (
 clk,reset : in std_logic;
 fifo_empty,fifo_full : in std_logic;
 rcv_start : in std_logic; --dbut de la rception
 rcv_ack :in std_logic;   -- acquittement de la rception
 rcv_comp : out std_logic; -- fin de la rception
  pop : out std_logic:='0';
 fifo_out : in std_logic_vector(Word-1 downto 0);
 mem :out memory(0 to sizemem-1));
end Proto_receiv;

architecture ReceiveProto of Proto_receiv is
type typ_receiv is (r_wait,r_head,r_len,r_glen,r_data,r_pulse,r_end);

			 signal spush,spop :  std_logic:='0';
          SIGNAL data_in:  std_logic_vector(7 downto 0);
			 signal etrec :typ_receiv;
begin

proc_receiv : process (clk,reset)
variable dlen,i: natural range 0 to 255 :=0;

	begin
	if reset='1' then 
				 etrec<=r_wait;
				 
				else  
						if rising_edge(clk) then -- le process s'excute sur chaque front 
															-- montant de l'horloge
						case etrec is
						when r_wait  =>
							
							i:=0;
							if fifo_empty='0' and rcv_start='1' then
							
							etrec<=r_head;
							mem(0)<=fifo_out;
							
							end if;
						when r_head  =>
							mem(0)<=fifo_out;  --l'en-tte
							
							etrec<=r_len;
							
						
						when r_len =>
								dlen:=to_integer(unsigned(fifo_out));
								mem(1)<=fifo_out; -- la longueur
								
								if dlen>2 then
									etrec<=r_data;
								else
									etrec<=r_end;
								end if;
								i:=1;
								
						when r_data  =>
								if fifo_empty='0' then
									if i<dlen-2 then
										i:=i+1;
										mem(i)<=fifo_out;
										
										
									else
										etrec<=r_pulse;
										
										mem(i+1)<=fifo_out;
									end if;
									-- time out  prvoir ici
								end if;
						when r_pulse =>
								etrec<=r_end;
								
						when r_end  =>
								if rcv_ack='1' then
									etrec<=r_wait;
								end if;
								
						when others =>
								
								
								etrec<=r_wait;
						end case;
						end if;
				end if;
	end process;
	
	pop<=spop;
	
rec_value : process (etrec)
begin
case etrec is
					when r_wait  =>
						spop<='0';
						rcv_comp<='0';
					when r_head  =>
							
							spop<='1';
							rcv_comp<='0';
--					when r_sync =>
--							spop<='1';
--							rcv_comp<='0';
					when r_len =>
							spop<='1';
					when r_data =>
							spop<='1';
					when r_pulse =>
								spop<='0';
								rcv_comp<='1';
					when r_end =>
							spop<='0';
							rcv_comp<='1';
					when others =>
							spop<='0';
							rcv_comp<='0';
				end case;
	end process;
end ReceiveProto;

