----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    04:35:05 10/15/2012 
-- Design Name: 
-- Module Name:    FIfo_mem - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------


library IEEE; 
use IEEE.std_logic_1164.all; 
use IEEE.std_logic_unsigned.all; 
entity FIFO is 
 generic (N: integer := 6; -- number of address bits for 2**N address locations 
M: integer := 8);  -- number of data bits to/from FIFO 
 port (CLK, PUSH, POP, INIT: in std_logic; 
  DIN: in std_logic_vector(N-1 downto 0); 
DOUT: out std_logic_vector(N-1 downto 0); 
  FULL, EMPTY, NOPUSH, NOPOP: out std_logic; 
  clk: IN std_logic;
	
	rd_en: IN std_logic;
	srst: IN std_logic;
	wr_en: IN std_logic;
	
	empty: OUT std_logic;
	full: OUT std_logic);
end entity FIFO; 
architecture TOP_HIER of FIFO is 
signal WE: std_logic; 
signal A: std_logic_vector(N-1 downto 0); 
signal  PUSH, POP, INIT:  std_logic; 
 
signal NOPUSH, NOPOP:  std_logic;

component FIFO_LOGIC is 
 generic (N: integer); -- number of address bits 
 port (CLK, PUSH, POP, INIT: in std_logic; 
  ADD: out std_logic_vector(N-1 downto 0); 
  FULL, EMPTY, WE, NOPUSH, NOPOP: buffer std_logic); 
end component FIFO_LOGIC; 

COMPONENT RAM_256
	PORT(
		clka : IN std_logic;
		clkb : IN std_logic;
		wea : IN std_logic;
		ena : IN std_logic;
		enb : IN std_logic;
		addra : IN std_logic_vector(Word-1 downto 0);
		addrb : IN std_logic_vector(Word-1 downto 0);
		dia : IN std_logic_vector(Word-1 downto 0);          
		dob : OUT std_logic_vector(Word-1 downto 0)
		);
END COMPONENT;
begin 
-- example of component instantiation using positional notation 
FL: FIFO_LOGIC generic map (N) 
 port map (CLK, PUSH, POP, INIT, A, FULL, EMPTY, WE, NOPUSH, NOPOP);  
Push<=wr_en;
pop<=rd_en;
nopush<=nopush;
nopop<=nopop;
init<=srst;
-- example of component instantiation using keyword notation 
--R: RAM generic map (W => N, K => M) 
-- port map (DIN => DIN, ADDR => A, WR => WE, DOUT => DOUT); 
R: RAM_256 PORT MAP(
		clka => clk,
		clkb => clk,
		wea => we,
		ena => '1',
		enb => '1',
		addra => A,
		addrb => A,
		dia => din,
		dob => dout
	);
end architecture TOP_HIER;