----------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM Roland Christian
-- 
-- Create Date:    19:16:34 05/23/2014 
-- Design Name: 
-- Module Name:    Fifo2Mem - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: ce module permet de lire une fifo et d'crire le rsultat dans la mmoire Ram
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
Library NocLib;
use NoCLib.CoreTypes.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Fifo2Mem is
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  wr_start : in STD_LOGIC;
           fifo_data_out : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           fifo_data_available : in  STD_LOGIC;
			  datalen : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           fifo_data_out_en : out  STD_LOGIC;
           fifo_empty : in  STD_LOGIC;
			  ram_busy : in  STD_LOGIC;
           ram_addr_start : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
			  ram_addr : out  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           ram_data_in : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           ram_wr : out  STD_LOGIC;
           ram_en : out  STD_LOGIC;
			  wr_comp :out STD_LOGIC
          
    );
end Fifo2Mem;

architecture Behavioral of Fifo2Mem is
type typ_wr_mem is(start,write_mem,stop);
signal et_wr_mem , next_et_wr_mem: typ_wr_mem;
signal data_to_ram,Data_to_ram_i :  std_logic_vector(Word-1 downto 0):=(others=>'0');
signal P_len_i,P_len : std_logic_vector(Word-1 downto 0);
signal dma_rd,dma_wr,rd_ok ,wr_ok:std_logic:='0';
signal n,n_i : natural range 0 to 15:=0;
signal dest_address,dest_address_i,ack_address : std_logic_vector(ADRLEN-1 downto 0):=(others=>'0');
begin
wr_mem_sync:process(clk)
begin
if rising_edge(clk) then
if reset='1' then
 n<=0;
 P_len<=(others=>'0');
 dest_address<=(others=>'0');
 data_to_ram<=(others=>'0'); 
else
dest_address<=dest_address_i;
P_len<=P_len_i;
Data_to_ram<=data_to_ram_i;
et_wr_mem<=next_et_wr_mem;
n<=n_i;
end if;
end if;
end process;
wr_mem_next:process(et_wr_mem,Fifo_data_available,P_len,wr_start,datalen,fifo_data_out,
ram_addr_start,ram_busy,dest_address)
variable delai :natural range 0 to 1;
begin
		
		next_et_wr_mem<=et_wr_mem;
		P_len_i<=P_len;
		dest_address_i<=dest_address;
		case et_wr_mem is

when start =>if wr_start='1' then
		next_et_wr_mem<=write_mem;
		P_len_i<=datalen;
		dest_address_i<=ram_addr_start;
	end if;

when write_mem=>		rd_ok<='0';
			                
			               
			               if unsigned( P_len)>0 and wr_start='1'  then 
												
											if fifo_data_available = '1' and delai=0  then
													   delai:=1; --une donn lue
														 P_len_i <= P_len - 1;
														 next_et_wr_mem<=write_mem;
														 rd_ok<='1';
														 data_to_ram_i<=fifo_data_out;
											end if;
											if  ram_busy='0' and delai=1 then
													  wr_ok<='1';
													  dest_address_i <= dest_address + 1;
													  delai:=0;--une donne crite
														 
												else
												  dest_address_i<=dest_address;
												  wr_ok<='0';
												 
												end if;
											
													next_et_wr_mem<=stop;
										
										else 
										  rd_ok<='0';
										  Wr_ok<='0';

											if ram_busy='0' and wr_start='1' then 

												 next_et_wr_mem<=stop;
											end if;
										
									    end if;
		when stop =>if wr_Start='0' then --attendre que le signal start soit ramener  0
							next_et_wr_mem<=start;
						end if;
	end case;
		end process;

process(et_wr_mem,rd_ok,wr_ok,data_to_ram,ram_addr_start,fifo_data_out)
begin
case et_wr_mem is 
when start =>Ram_wr<='0';
			Ram_en<='0';
			Ram_data_in<=data_to_ram;
			fifo_data_out_en<='0';
			wr_comp<='0';
			Ram_addr<=Ram_addr_start;
when write_mem=>
				fifo_data_out_en <=rd_ok;
				if rd_ok = '1' then
										
					Ram_data_in<=fifo_data_out;
				else
					Ram_data_in<=data_to_ram;
				end if;
			ram_addr<=dest_address;
			Ram_wr<=wr_ok;
			Ram_en<=wr_ok;
			wr_comp<='0';
when stop =>
			Ram_wr<='0';
			Ram_en<='0';
			ram_addr<=dest_address;
			Ram_data_in<=data_to_ram;
			fifo_data_out_en<='0';
			wr_comp<='1';
			
	end case;
end process;
end Behavioral;

