--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions
-- package definissant le codage des fonctions MPI 
-- dans le champs packet type des instructions MPI 

-- Ce fichier dfinit les trames des instruction MPI qui sont utilisables
library IEEE;
use IEEE.STD_LOGIC_1164.all;

package Packet_type is
	
 constant ADRLEN1										:natural:=16;
 constant MPI_COMM_WORLD							:natural:=1;
 constant MPI_DEFAULT								:natural:=0;
 constant MPI_INT										:natural:=1;
 constant MPI_INFO_NULL								:natural:=0;
 constant Default_Win								:natural:=1;
 constant MPI_GET_RANK								: std_logic_vector(3 downto 0) := "0000";
 constant MPI_GET_SIZE								: std_logic_vector(3 downto 0) := "0001";
 constant MPI_BARRIER								: std_logic_vector(3 downto 0) := "0010";
 constant MPI_BARRIER_REACHED						: std_logic_vector(3 downto 0) := "0011";
 constant MPI_BARRIER_COMPLETED					: std_logic_vector(3 downto 0) := "1110";
 constant MPI_ACK  	                : std_logic_vector(3 downto 0) := "0100"; 
 constant MPI_PUT   									: std_logic_vector(3 downto 0) := "0101";
 constant MPI_GET  									: std_logic_vector(3 downto 0) := "0110";
 constant MPI_BROADCAST								: std_logic_vector(3 downto 0) := "0111";
 constant MPI_INIT     								: std_logic_vector(3 downto 0) := "1000";
 constant MPI_SPAWN									: std_logic_vector(3 downto 0) := "1001";
 
 constant MPI_WIN_CREATE								: std_logic_vector(3 downto 0) := "1010";
 constant MPI_WIN_SYNC       :std_logic_vector(3 downto 0):="1011";
 constant MPI_WIN_COMPLETE							: std_logic_vector(3 downto 0) := "1100";
 constant MPI_WIN_POST								: std_logic_vector(3 downto 0) := "1101";
 constant MPI_WIN_WAIT								: std_logic_vector(3 downto 0) := "1110";
 
 
 
 constant MPI_WTIME									: std_logic_vector(3 downto 0) := "1110";
 constant MPI_WTICK 									: std_logic_vector(3 downto 0) := "1111";
 constant MPI_CONFIG								   : std_logic_vector(3 downto 0) := "1101";
 --paramtres des commandes
 Constant INIT_SEEKMAIN								: std_logic_vector(3 downto 0) := "0001";
 Constant INIT_SETRANK								: std_logic_vector(3 downto 0) := "0011";
 Constant INIT_REGISTER								: std_logic_vector(3 downto 0) := "0010";
 Constant INIT_STAT									: std_logic_vector(3 downto 0) := "0100";
 Constant INIT_SPAWN									: std_logic_vector(3 downto 0) := "0101";

 Constant SPAWN_LOAD									: std_logic_vector(3 downto 0) := "1001";
 Constant SPAWN_START								: std_logic_vector(3 downto 0) := "1010";
 Constant SPAWN_COMP									: std_logic_vector(3 downto 0) := "1011";
 Constant SPAWN_ERR									: std_logic_vector(3 downto 0) := "1110";

Constant SYNC_WSTART									: std_logic_vector(3 downto 0) := "0001";
 Constant SYNC_WPOST								: std_logic_vector(3 downto 0) := "0010";
 Constant SYNC_WCOMP									: std_logic_vector(3 downto 0) := "0011";
 Constant SYNC_WWAIT									: std_logic_vector(3 downto 0) := "0100";
-- constantes pour le NoC								
 Constant NOC_GETPORTID								: std_logic_vector(7 downto 0) := "00000001";
--constante pour les Ptr
constant W_Status :natural:=0; --position relative des champs dans la mmoire
constant W_Id :natural:=2;   -- pour le type MPI_Win
constant W_GStart :natural:=3;
constant W_GPost :natural:=5;
constant W_Addr :natural:=7;
constant W_Size :natural:=9;
constant W_comm :natural:=10;

Type MPI_Datatype is (MPI_BYTE,MPI_INTEGER,MPI_REAL,MPI_PACKET, MPI_pointer);
SUBType MPI_COMM is  natural range 0 to 2**ADRLEN1-1 ; --pointeur sur la structure du communicateur
subType Mpi_AInt is natural range 0 to 2**ADRLEN1-1 ;
--subType Mpi_win is natural range 0 to 2**ADRLEN1-1 ;
Type MPI_COMM_struc is record
   id : natural range 0 to 3; -- id du communicateur
	grp : std_logic_vector(15 downto 0);     --groupe associ au communicateur
	nproc : natural range 0 to 15;   -- nombre de membres du groupe de ce communicateur
	AddrLib : std_logic_vector(15 downto 0); -- adresse dans la mmoire de la Lib 
														  -- des registres GStart et GPost
	ParentId:natural range 0 to 3; --Id du communicateur parent si Intercomm=1
	C_open,C_close,InterComm : std_logic;  -- tat du communciateur (Inistialis ou finalis)
end record;

Type Mpi_Win is record 
	status : std_logic_vector(7 downto 0); --tat de la fentre (create,Start,Complete,Post,WaitSync, etc.)
	id : natural range 0 to 15 ; -- numro de la fentre
	
	Addr : std_logic_vector(15 downto 0); -- adresse dans la mmoire locale du PE
	Size : natural range 0 to 65535; -- taille de la fentre en octets 
	GPost : std_logic_vector(15 downto 0);--registres de synchronisation en cible
	GStart : std_logic_vector(15 downto 0);-- registre de synchronisation source
	comm : MPI_COMM; -- Ptr sur communicateur associ  la fentre
end record;
Type Mpi_group is record  --normalement sous-goupe d'un communicateur
	grp : std_logic_vector(15 downto 0); --( vecteur de la liste des processus du groupe)
	nb : natural range 0 to 15; -- nombre de membres(processus du groupe)
	comm_id : natural range 0 to 3; -- refrence du communicateur
end record;
 
type typ_mae is (start,Fillmem,NextFill,InitApp,GetRank,WInCreate,WinPost,WinStart,
  putdata,getdata,WinWait,WinCompleted,GetCmd,MpiSpawn,finalize,st_timeout);
end Packet_type; 	
package body Packet_type is


end Packet_type;
