----------------------------------------------------------------------------------
-- Company: 
-- Engineer:  GAMOM NGOUNOU 
-- 
-- Create Date:    18:33:31 03/05/2012 
-- Design Name: 
-- Module Name:    RAM_32_32 - Behavioral 
-- Project Name: MPI_Core
-- Target Devices: 
-- Tool versions: 
-- Description: permet de stocker les donnes locales de la librairie MPI
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity RAM_v is
generic(width : positive:=32; Size:positive:=16);
Port ( clka, clkb : in std_logic;
			  wea : in std_logic;
			  ena, enb : in std_logic;
			  addra, addrb : in std_logic_vector(size-1 downto 0); --cinq lignes d'adresse
			  dia : in std_logic_vector(width-1 downto 0);
			  dob : out std_logic_vector(width-1 downto 0));
end RAM_v;

architecture Behavioral of RAM_v is
	attribute RAM_STYLE : string;
	signal Lra,Lrb :std_logic:='0';
	signal sel : std_logic_vector(1 downto 0);
	signal read_addr:std_logic_vector(12 downto 0);
	signal doa,dout : std_logic_vector(width-1 downto 0);
	type ram_type is array (2**(size-3)-1 downto 0) of std_logic_vector (width-1 downto 0);
	signal RAM1,RAM2: ram_type;
	attribute RAM_STYLE of RAM1: signal is "BLOCK";
	attribute RAM_STYLE of RAM2: signal is "BLOCK";
begin
 process (clka)
	begin
		if clka'event and clka = '1' then
			if ena = '1' then
				if wea = '1' then
				  
          					RAM1(conv_integer(addra(12 downto 0))) <= dia;
          				--	RAM2(conv_integer(addra(12 downto 0))) <= dia;
					end if;
				end if;
				--if conv_integer(addrb)>8191 then
--				      report  "Erreur d'adresse";
--				  else	
--				doa<=RAM1(conv_integer(addrb));
--			   end if;
		--		Lra<='1';
--			else 
--				if lrb='1' then
--						Lra<='0';
--				end if;
--			end if;
		 if conv_integer(addra)>8191 then
				      report  "Erreur adresse Ecriture > 8191"
				      severity warning;
			end if;
	end if;		
 end process;

 
 process (clkb)	
 begin
		if clkb'event and clkb = '1' then
		  
			if enb = '1' and ena='1' and addra=addrb then
			  --dout <= dia; --la sortie est gale  l'entre
			  report "Collision R/W  l'adresse " & integer'image(conv_integer(addra))
			  severity note;
			  read_addr<=addrb(12 downto 0);
			  Lra<='1';
			 elsif enb='1' then
			   read_addr<=addrb(12 downto 0);
				Lrb<='1';	
				 -- dout <= RAM2(conv_integer(addrb(12 downto 0)));
			else
				if Lra='1' then
					Lrb<='0';
				end if;
			end if;
				if conv_integer(addrb)>8191 then
				      report  "Erreur adresse de lecture > 8191"
				      severity warning;
			end if;
		end if;
 end process;
 --dob<=dout;
 dob <= RAM1(conv_integer(read_addr));
 --sel<=(Lra,Lrb);
-- With  sel select
-- dob <=dout when "11",
--      doa  when "10",
--		dout when "01",
--		dout when "00",
--		dout when others;
		
end Behavioral;

