--------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM Roland Christian
--
-- Create Date:   16:44:13 08/01/2012
-- Design Name:   
-- Module Name:   C:/Core MPI/CORE_MPI/MultiMPITest.vhd
-- Project Name:  MPI_CORE_COMPONENTS
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: MPI_NOC
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- 
-- 
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
library NocLib ;

use NocLib.CoreTypes.all;
LIbrary MPI_HCL;
use MPI_HCL.Packet_type.all;
use work.Hcl_Arch_conf.all;
USE ieee.numeric_std.ALL;
 
ENTITY Mpi_template IS
--simulation translate_off
port (clkm : in std_logic;
reset : in std_logic;
sw : in std_logic_vector(3 downto 0); --bouton bascule
Led : out std_logic_vector(Word-1 downto 0));
--simulation translate_on
END MPi_template;
 
ARCHITECTURE behavior OF MPI_Template IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT MPI_NOC
	 generic (NPROC: natural:=2);
    PORT(
         MPI_Node_in : IN   Ar_MPIPort_in(1 to NPROC);
         MPI_Node_Out : OUT   Ar_MPIPort_out(1 to NPROC)
        );
    END COMPONENT;
	 component proto_send is
generic (sizemem : natural := 64);
 port (
 clk,reset : in std_logic;
 fifo_in_empty,fifo_in_full : in std_logic; --signaux pour le fifo d'entre
 fifo_out_empty,fifo_out_full : in std_logic; --signaux pour le fifo de sortie
 fifo_out_wr_en : out std_logic:='0'; --criture autorise dans la fifo de sortie
 fifo_in_rd_en : out std_logic:='0'; --lecture autorise dans la fifo d'entre
 fifo_in_data_out : in std_logic_vector(Word-1 downto 0);
 fifo_out_data_in : out std_logic_vector(Word-1 downto 0);
 packet_len : in std_logic_vector(Word-1 downto 0); --la longueur du paquet
 copy_mode : in std_logic; --Fifo_to_mem ou Fifo_to_fifo
 snd_start : in std_logic; --dbut de la rception
 snd_ack :in std_logic;   -- acquittement de la rception
 snd_comp : out std_logic; -- fin de la rception
 mem :in memory(0 to sizemem-1)); --donnes  copier vers le fifo
 end component proto_send;
Component Fifo2mem is
Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  wr_start : in STD_LOGIC;
           fifo_data_out : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           fifo_data_available : in  STD_LOGIC;
			  datalen :   STD_LOGIC_VECTOR (Word-1 downto 0);
           fifo_data_out_en : out  STD_LOGIC;
           fifo_empty : in  STD_LOGIC;
			  ram_busy : in  STD_LOGIC;
           ram_addr_start : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
			  ram_addr : out  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           ram_data_in : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           ram_wr : out  STD_LOGIC;
           ram_en : out  STD_LOGIC;
			  wr_comp :out STD_LOGIC);
end component fifo2mem;
 Component PE
  generic(destid : natural;
				use_dyn:natural);
  Port ( Instruction : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : out  STD_LOGIC;
			  Core_PushOut : in STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  CE : in  STD_LOGIC;
           Core_RAM_Data_Out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_In : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_WE : in  STD_LOGIC;
           Core_RAM_EN : in  STD_LOGIC;
           --Core_RAM_ENB : in  STD_LOGIC;
           Core_RAM_ADDRESS_WR : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_RAM_ADDRESS_RD : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_Hold_req : in  STD_LOGIC;
           Core_Hold_Ack : out  STD_LOGIC);
end Component;  
 
 	constant clk_period : time := 15 ns;
   constant PROC : positive :=NOC_SIZE; --4
-- synthesis translate_off
--===================signaux pour l'horloge ==============================
--signal reset,clkm : std_logic := '0';
--========================================================================
-- synthesis translate_on
 --signaux pour la gestion de la MAE
 type typ_mae is (start,Fillmem,NextFill,InitApp,InitCompleted,writeptr,InstrCopy, 
 putdata,putdata2,putcompleted,getdata,getdata2,getcompleted,terminate,st_timeout);

--groupe de signaux utilis pour communiquer avec l'extrieur de la plateforme
type arDpRam is array (natural range <>) of typ_dpRam;
type typ_Pconsole is(idle,get_bus,get_ht_mem,rd_ht_mem,wr_ht_mem,et_end);
signal et_Pconsole,Next_et_Pconsole : typ_pconsole;
signal Pcons_ram :typ_dpram; --signaux pour accs  la ram par la console
signal pcons_hold_req,pcons_hold_ack: std_logic;--pour accs  la Ram du HT
signal pcons_wr_comp,pcons_wr_start : std_logic;--pour contrler l'criture dans la Ram du HT
signal pcons_rd_comp,pcons_rd_start :std_logic;
signal pcons_ram_busy : std_logic:='0';
signal pcons_ht : natural range 0 to 15;--le numro du HT qui est sollicit
signal mux_hold_req,dmux_hold_ack: std_logic_vector(1 to PROC); --multiplexer les signaux d'accs RAM HT entre Core_MPI et console 
signal mux_ram : Ar_DpRam(1 to PROC); 
signal pcons_sel:std_logic_vector(1 to PROC);--tat de la slection du MUX entre Console et Core MPI
--
--signaux pour le module de communication RS232C
signal rs_cmd,rs_rw,rs_comp:std_logic;
signal rs_addr_start:std_logic_vector(adrlen-1 downto 0);
signal rs_plen :std_logic_vector(word-1 downto 0);
signal rs_fifo_data_out_en:std_logic;
signal rs_fifo_data_available : std_logic;
signal rs_fifo_data_out :std_logic_vector(word-1 downto 0);
--
signal dcount : natural range 0 to 255:=0; --permet de compter le packet de donnes envoyes
signal count,count_i : natural range 0 to 15:=0;

signal MPI_Node_in : Ar_MPIPort_in(1 to PROC) ;
signal MPI_Node_Out : Ar_MPIPort_out(1 to PROC);

 

 
BEGIN
SysMPI: MPI_NOC GENERIC MAP (NPROC=>NOC_SIZE)
		PORT MAP (
          MPI_Node_in => MPI_Node_in,
          MPI_Node_Out => MPI_Node_Out
        );

res_Led_sw:process (MPi_Node_out(1).PushOut,MPi_Node_out(1).PushOut)
variable p:natural range 0 to 15:=0;
begin
p:=to_integer(unsigned(sw)); --rcuprer les switchs pour dfinir les entres
Led<=MPi_Node_out(p).PushOut;
end process;

S_Grp:for i in 1 to STATIC_HT generate
S: PE 	Generic map (DestId=>i-1,
							 use_dyn=>0)
			Port Map (
				Instruction => MPi_Node_in(i).Instruction,
           Instruction_en => MPi_Node_in(i).Instruction_en,
			  Core_PushOut => MPi_Node_out(i).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '1',
				Core_RAM_Data_Out =>mux_ram(i).i.Data_out,
           Core_RAM_Data_IN => mux_ram(i).o.data_in,
           Core_RAM_WE => mux_ram(i).o.we,
           Core_RAM_EN => mux_ram(i).o.enb,
           Core_RAM_Address_Wr => mux_ram(i).o.addr_wr,
           Core_RAM_Address_Rd => mux_ram(i).o.addr_rd,
           Core_Hold_req => mux_hold_req(i),
           Core_Hold_Ack => dmux_hold_ack(i)			  
--           Core_RAM_Data_Out =>MPi_Node_in(i).Ram_Data_out,
--           Core_RAM_Data_IN => MPI_Node_out(i).ram_data_in,
--           Core_RAM_WE => MPI_Node_out(i).ram_we,
--           Core_RAM_EN => MPI_Node_out(i).ram_en,
--           --Core_RAM_ENB => MPI_Node_out(2).ram_en,
--           Core_RAM_Address_Wr => MPI_Node_out(i).ram_address_wr,
--           Core_RAM_Address_Rd => MPI_Node_out(i).ram_address_rd,
--           Core_Hold_req => MPI_Node_out(i).hold_req,
--           Core_Hold_Ack => MPI_Node_in(i).hold_ack
);
MPI_Node_in(i).reset<=reset;	
MPI_Node_in(i).clk<=clkm;
end generate S_Grp;
dyn_mod: if dyn_allowed='1' generate
D_Grp:for i in STATIC_HT+1 to NOC_SIZE generate
D: PE 	Generic map (DestId=>i-1,
						use_dyn=>1)
			Port Map (
				Instruction => MPi_Node_in(i).Instruction,
           Instruction_en => MPi_Node_in(i).Instruction_en,
			  Core_PushOut => MPi_Node_out(i).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '0',
           Core_RAM_Data_Out =>mux_ram(i).i.Data_out,
           Core_RAM_Data_IN => mux_ram(i).o.data_in,
           Core_RAM_WE => mux_ram(i).o.we,
           Core_RAM_EN => mux_ram(i).o.enb,
           Core_RAM_Address_Wr => mux_ram(i).o.addr_wr,
           Core_RAM_Address_Rd => mux_ram(i).o.addr_rd,
           Core_Hold_req => mux_hold_req(i),
           Core_Hold_Ack => dmux_hold_ack(i)
);
MPI_Node_in(i).reset<=reset;	
MPI_Node_in(i).clk<=clkm;
end generate D_Grp;
end generate dyn_mod;

--lecture de la mmoire de communication de chaque tche et envoie des donnes
-- sur le port srie
Pcons_sync:process(clkm)
begin
if rising_edge(clkm) then
if reset='1' then
Et_Pconsole<=idle;
else
et_Pconsole<=next_et_Pconsole;

end if;
end if;
end process;
Pcons_next : process(et_Pconsole,rs_cmd)
variable bus_free:std_logic:='0';
begin
case et_pconsole is
when idle => if rs_cmd='1' then
		next_et_pconsole<=get_bus;
		end if;
when get_bus => 
bus_free:='0';
for i in 1 to PROC loop
	if MPI_Node_out(i).Hold_req='0' then
		Pcons_sel(i)<='1';
		bus_free:='1';
	else
		Pcons_sel(i)<='0';
	end if;
end loop;
if bus_free='1' then
	next_et_pconsole<=get_ht_mem;
end if;
when get_ht_mem => if rs_rw='1' then
								next_et_pconsole<=rd_ht_mem;
						 else --if rs_rw='1' then
								next_et_pconsole<=wr_ht_mem;
						 end if;
when rd_ht_mem => if pcons_rd_comp='0' then
						next_et_pconsole<=et_end;
					end if;
when wr_ht_mem=> if pcons_wr_comp='1' then
					next_et_pconsole<=et_end;
					
					end if;
when et_end =>
	for i in 1 to PROC loop
	Pcons_sel(i)<='0';
	end loop;
	if rs_cmd='0' then --atendre la fin de la cmd
	next_et_pconsole<=idle;
	end if;
end case;
end process;
Pcons_val : process(et_Pconsole)
begin
pcons_rd_start<='0';
pcons_wr_start<='0';
rs_comp<='0';
case et_pconsole is
when idle =>
when get_bus =>
when get_ht_mem => 
when rd_ht_mem => pcons_rd_start<='1';
when wr_ht_mem=> pcons_wr_start<='1';
when et_end=>rs_comp<='1';
		pcons_wr_start<='0';
end case;
end process;
--Multiplexeur de la console pour l'accs  la RAM de chaque HT.
Ram_mux: process (clkm,MPI_Node_out,pcons_sel	)
 begin 
for i in 1 to PROC loop 
 case Pcons_sel(i) is
	

	when '1' =>
			mux_ram(i).o.addr_wr<=pcons_ram.o.addr_wr;
			mux_ram(i).o.addr_rd<=pcons_ram.o.addr_rd ; 
			mux_ram(i).o.we<=pcons_ram.o.we;
			mux_ram(i).o.enb<=pcons_ram.o.enb;
			mux_ram(i).o.data_in<=pcons_ram.o.data_in;
			mux_hold_req(i)<=Pcons_Hold_req;
	when others =>
			mux_ram(i).o.addr_wr<=MPI_Node_out(i).Ram_address_wr;
			mux_ram(i).o.addr_rd<=MPI_Node_out(i).Ram_address_rd ; 
			mux_ram(i).o.we<=MPI_Node_out(i).Ram_we;
			mux_ram(i).o.enb<=MPI_Node_out(i).Ram_en;
			mux_ram(i).o.data_in<=MPI_Node_out(i).Ram_data_in;
			mux_hold_req(i)<=MPI_Node_out(i).Hold_req;		
end case ;
end loop;
end process ;
--criture dans la mmoire d'une tche matrielle
Inst_Fifo2Mem: Fifo2Mem PORT MAP(
		clk =>clkm ,
		reset =>reset ,
		wr_start =>pcons_wr_start ,
		fifo_data_out => rs_fifo_data_out,
		fifo_data_available =>rs_fifo_data_available ,
		datalen =>rs_plen ,
		fifo_data_out_en =>rs_fifo_data_out_en ,
		fifo_empty =>'0' ,
		ram_busy => pcons_ram_busy, --not pcons_sel(pcons_ht) ,
		ram_addr_start =>rs_addr_start ,
		ram_addr =>pcons_ram.o.addr_wr,
		ram_data_in =>pcons_ram.o.data_in ,
		ram_wr =>pcons_ram.o.we ,
		ram_en =>pcons_ram.o.enb ,
		wr_comp =>pcons_wr_comp 
	);
--dmultiplexeurs de la console pour accs  la RAM de chaque Tche matrielle.
Ram_dmux : process(MPI_node_in,mux_ram,PCons_sel,pcons_ht)
variable Tram_out:std_logic_vector(Word-1 downto 0):=(others=>'0');
begin
for i in 1 to PROC loop
case PCons_sel(i) is

when '1' => 	if pcons_ht=i then 
						Pcons_hold_ack<=dmux_hold_ack(i);
					end if;
					--Pcons_ram.I.data_out<=mux_ram(i).i.data_out;
					if i=pcons_ht then
					Pcons_ram.I.data_out<=mux_ram(i).i.data_out;
					else
					TRam_out:=Tram_out or mux_ram(i).i.data_out;
					end if;
					MPI_Node_in(i).hold_ack<='0';
					MPI_Node_in(i).Ram_data_out<=(others=>'-');
when others => Pcons_hold_ack<='0';
					--Pcons_ram.I.data_out<=(others=>'-');
					TRam_out:=(others=>'-');
					MPI_Node_in(i).hold_ack<=dmux_hold_ack(i);
					MPI_Node_in(i).Ram_data_out<=mux_ram(i).i.data_out;				  
end case;
end loop;

end process;
END;
