library ieee;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity com_icap is
        generic ( hexmode : boolean := true; -- false is for faster binary mode, but will not work on all machines/boards
		            ComRate : integer := 217); -- ComRate = f_CLK / Boud_rate (e.g., 25 MHz/115200 Boud = 217)
        port (
        CLK:           in  std_logic;
        Rx:            in  std_logic; --entre srie des donnes
        Tx:            out std_logic;
        RxErr:         out std_logic; --erreur de rception
        debug0:     		out std_logic_vector(19 downto 0);
        debug1:     		out std_logic_vector(19 downto 0);
        debug2:     		out std_logic_vector(19 downto 0);
		  bs_load_start : in std_logic; --dbut de rception bitstream
		  bs_load_comp :	out std_logic; --fin de rception
		  bs_load_ack 	:	in std_logic; --acquitement bistream
		  bs_load_data : out std_logic_vector(31 downto 0);
		   rxWord   	: out std_logic_vector(7 downto 0); -- mot reu
			RxRdy     	: out std_logic; --donnes reues		  
        WriteData:     out std_logic_vector(31 downto 0);
        ComActive:     out std_logic;
        WriteStrobe:   out std_logic; --valide l'criture sur l'ICAP
        ReceiveLED:    out std_logic);
end com_icap;

architecture a_com_icap of com_icap is

constant TimeToSendValue : integer := 16777216-1; --200000000;  
constant CRC_InitValue : std_logic_vector(15 downto 0) := "1111111111111111";
constant TestFileChecksum : std_logic_vector(19 downto 0) := x"40351"; -- changer en fonction du bitstream

function ASCII2HEX(ASCII: std_logic_vector(7 downto 0)) return std_logic_vector is
begin
  case ASCII is
    when x"30" => return "00000";	-- 0
    when x"31" => return "00001";
    when x"32" => return "00010";
    when x"33" => return "00011";
    when x"34" => return "00100";
    when x"35" => return "00101";
    when x"36" => return "00110";
    when x"37" => return "00111";
    when x"38" => return "01000";
    when x"39" => return "01001";
    when x"41" => return "01010";  -- A
    when x"61" => return "01010";  -- a
    when x"42" => return "01011";  -- B
    when x"62" => return "01011";  -- b
    when x"43" => return "01100";  -- C
    when x"63" => return "01100";  -- c
    when x"44" => return "01101";  -- D
    when x"64" => return "01101";  -- d
    when x"45" => return "01110";  -- E
    when x"65" => return "01110";  -- e
    when x"46" => return "01111";  -- F
    when x"66" => return "01111";  -- f
    when others =>return "1----";   -- The MSB encodes if there was an unknown code -> error
  end case; 
end;

type ReceiveStateType is (HighNibble, LowNibble);
signal ReceiveState : ReceiveStateType;
signal HighReg : std_logic_vector(3 downto 0);
signal HexValue : std_logic_vector(4 downto 0); -- a '0' MSB indicates a valid value on [3..0]
signal HexData : std_logic_vector(7 downto 0); -- the received byte in hexmode mode
signal HexWriteStrobe : std_logic; -- we received two hex nibles and have a result byte
signal Stop_Err,rec_ok :std_logic:='0';
signal ComCount : integer range 0 to 4095;
signal ComTick : std_logic;
type ComStateType is (WaitForStartBit, DelayAfterStartBit, GetBit0, GetBit1, GetBit2,
                      GetBit3, GetBit4, GetBit5, GetBit6, GetBit7, GetStopBit);
type loadbs_Type is(idle,read_word0,read_word1,read_word2,read_word3,check_sync,reset_reg,write_icap,end_loadbs);
signal ComState,Next_ComState : ComStateType;
signal et_loadbs,Next_et_loadbs:loadbs_Type;
signal ReceivedWord,receivedSwap : std_logic_vector(7 downto 0);
signal RxLocal : std_logic;

--signal W0, W1, W2, W3, W4, W5, W6, W7 : std_logic_vector(7 downto 0);

signal ID_Reg : std_logic_vector(23 downto 0);
signal fifo_reg,fifo_reg_i : std_logic_vector(31 downto 0); --registre de dtection de dbut du bitstream
signal sync_ok,desync_ok,cmd_detected:std_logic;
signal sync_ok_i,desync_ok_i,cmd_detected_i:std_logic;
signal reading : std_logic:='0';
constant  sync_reg  : std_logic_vector(31 downto 0):=x"AA995566";
constant desync_cmd : std_logic_vector(31 downto 0) :=x"30008001";
constant desync_word : std_logic_vector(31 downto 0):=x"0000000D";
signal Start_Reg : std_logic_vector(31 downto 0);
signal Size_Reg : std_logic_vector(31 downto 0);
signal CRC_Reg : std_logic_vector(15 downto 0);
signal Command_Reg : std_logic_vector(7 downto 0);
signal Data_Reg : std_logic_vector(7 downto 0);

signal TimeToSend : std_logic;
signal TimeToSendCounter : integer range 0 to TimeToSendValue;

type PresentType is (Idle, GetID_00, GetID_AA, GetID_FF, 
                     GetSize3, GetSize2, GetSize1, GetSize0,
                     GetCommand, EvalCommand,
                     GetData, GetFinish);
signal PresentState : PresentType;

signal scan_count : integer range 0 to 63;
constant tast_entprell : integer := 2000000; -- 100 ms;
signal tast_count : integer range 0 to tast_entprell;
signal tast_trigger, tast_trigger_delay : std_logic;

signal feedback_mode : std_logic := '0';
signal swap_mode : std_logic := '0';

signal LocalWriteStrobe : std_logic;

signal local_scan_control, local_scan_control_delay : std_logic := '0';
signal scan_shift_strobe_from_receiver : std_logic;
signal tx_write_strobe_from_receiver : std_logic;
signal tx_write_strobe : std_logic;

signal state_counter : integer range 0 to 127 := 0;
signal com_en: std_logic;
signal com_en_counter : natural range 0 to 511;
signal com_active_counter : natural range 0 to 40000;
signal TxOut: std_logic;  

signal Word_Count : std_logic_vector(31 downto 0);                        
--signal ADR_Reg : std_logic_vector(31 downto 0);                        

signal CRCReg,b_counter : std_logic_vector(19 downto 0) := TestFileChecksum;
signal ReceivedWordDebug : std_logic_vector(7 downto 0);
signal blink : std_logic_vector(22 downto 0) := (others => '0');

begin

P_sync:process(clk)
begin
  if clk'event AND clk='1' then
    RxLocal <= Rx;
    Tx <= TxOUT;
  end if; -- clk;
end process;

P_com_en:process(clk)	
begin
  if clk'event AND clk='1' then
    if ComState=WaitForStartBit then
      ComCount <= ComRate/2;  -- @ 25 MHz --vrifier le demi-bit
       ComTick <= '0';
    elsif ComCount=0 then
       ComCount <= ComRate;   
       ComTick <= '1';
    else
       ComCount <= ComCount - 1;
       ComTick <= '0';
    end if;
  end if; -- clk
end process;

P_COM:process(clk)
begin
  if clk'event AND clk='1' then
  Rec_Ok<='0';
  case ComState is
    when WaitForStartBit =>
      if RxLocal='0' then
        ComState <= DelayAfterStartBit;
        ReceivedWord <= (others => '0');
        ReceivedSwap<= (others => '0');
        Stop_Err<='0';
      end if;
    when DelayAfterStartBit =>
      if ComTick='1' then
        if rxLocal='0' then
          ComState <= GetBit0;
          Stop_Err<='0';
        else
          Stop_Err<='1';
          ComState <=WaitForStartBit; --Erreur de stop trame incorrecte !
        end if;
      end if;
    when GetBit0 =>
      if ComTick='1' then
        ComState <= GetBit1;
        ReceivedWord(0) <= RxLocal;
        ReceivedSwap(7) <= RxLocal;
      end if;
    when GetBit1 =>
      if ComTick='1' then
        ComState <= GetBit2;
        ReceivedWord(1) <= RxLocal;
        ReceivedSwap(6) <= RxLocal;
      end if;
    when GetBit2 =>
      if ComTick='1' then
        ComState <= GetBit3;
        ReceivedWord(2) <= RxLocal;
        ReceivedSwap(5) <= RxLocal;
      end if;
    when GetBit3 =>
      if ComTick='1' then
        ComState <= GetBit4;
        ReceivedWord(3) <= RxLocal;
        ReceivedSwap(4) <= RxLocal;
      end if;
    when GetBit4 =>
      if ComTick='1' then
        ComState <= GetBit5;
        ReceivedWord(4) <= RxLocal;
        ReceivedSwap(3) <= RxLocal;
      end if;
    when GetBit5 =>
      if ComTick='1' then
        ComState <= GetBit6;
        ReceivedWord(5) <= RxLocal;
        ReceivedSwap(2) <= RxLocal;
      end if;
    when GetBit6 =>
      if ComTick='1' then
        ComState <= GetBit7;
        ReceivedWord(6) <= RxLocal;
        ReceivedSwap(1) <= RxLocal;
      end if;
    when GetBit7 =>
      if ComTick='1' then
        ComState <= GetStopBit;
        ReceivedWord(7) <= RxLocal;
        ReceivedSwap(0) <= RxLocal;
      end if;
    when GetStopBit =>
      if ComTick='1' then
        ComState <= WaitForStartBit;
      end if;
		Rec_Ok<='1';
  end case;
  end if; --clk
end process P_COM;

--Get_header:process(comState,presentState,ReceivedWord,ComTick) 
--begin
--
--    if ComState=GetStopBit AND ComTick='1' then
--       case PresentState is
--         when GetID_00 => ID_Reg(23 downto 16) <= ReceivedWord;
--         when GetID_AA => ID_Reg(15 downto 8) <= ReceivedWord;
--         when GetID_FF => ID_Reg(7 downto 0) <= ReceivedWord;
--         when GetSize0 => Size_Reg(31 downto 24) <= ReceivedWord;
--         when GetSize1 => Size_Reg(23 downto 16) <= ReceivedWord;
--         when GetSize2 => Size_Reg(15 downto 8) <= ReceivedWord;
--         when GetSize3 => Size_Reg(7 downto 0) <= ReceivedWord;
----         when GetStart3 => Start_Reg(31 downto 24) <= ReceivedWord;
----         when GetStart2 => Start_Reg(23 downto 16) <= ReceivedWord;
----         when GetStart1 => Start_Reg(15 downto 8) <= ReceivedWord;
----         when GetStart0 => Start_Reg(7 downto 0) <= ReceivedWord;
----         when GetSize3 => Size_Reg(31 downto 24) <= ReceivedWord;
----         when GetSize2 => Size_Reg(23 downto 16) <= ReceivedWord;
----         when GetSize1 => Size_Reg(15 downto 8) <= ReceivedWord;
----         when GetSize0 => Size_Reg(7 downto 0) <= ReceivedWord;
----         when GetCRC_H => CRC_Reg(15 downto 8) <= ReceivedWord;
----         when GetCRC_L => CRC_Reg(7 downto 0) <= ReceivedWord;
--         when GetCommand => Command_Reg <= ReceivedWord;   
--         when GetData => Data_Reg <= ReceivedWord;
--         when others => 
--       end case;
--    end if;
--end process get_header ;

--P_FSM:process(clk)
--begin
--  if clk'event AND clk='1' then
--    case PresentState is
--      when Idle =>
--        if ComState=WaitForStartBit AND RxLocal='0' then PresentState <= GetID_00; end if;
--      when GetID_00 =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetID_AA; end if;
--      when GetID_AA =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetID_FF; end if;
--      when GetID_FF =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetSize3; end if;
--      when GetSize3 =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetSize2; end if;
--      when GetSize2 =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetSize1; end if;
--      when GetSize1 =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetSize0; end if;
--      when GetSize0 =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetCommand; end if;
--      when GetCommand =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= EvalCommand; end if;
--      when EvalCommand =>
--        if ID_Reg=x"00AAFF" AND (Command_Reg=x"01" OR Command_Reg=x"02")then 
--              PresentState <= GetData; 
--         else  
--              PresentState <= Idle; 
--        end if;
--      when GetData =>
--        if TimeToSend='1' then PresentState<=Idle;
--        elsif Word_Count=0 AND LocalWriteStrobe='1' then
--              PresentState <= GetFinish;
----        elsif ComState=GetStopBit AND ComTick='1' then PresentState <= GetData2; 
--        end if;
----      when GetData0 =>
----        if TimeToSend='1' then PresentState<=Idle;
----        elsif ComState=GetStopBit AND ComTick='1' then 
----           if Word_Count /= 0 then
----              PresentState <= GetData3; 
----           else
----              PresentState <= GetFinish; 
----           end if;
----        end if;
--      when GetFinish =>
--        PresentState <= Idle;
--    end case;
--  end if;--clk
--end process;
--Command <= Command_Reg;

--L_hexmode : if (hexmode=true) generate
--
--	HexValue <=  ASCII2HEX(ReceivedWord);
--
--	process(clk)
--	begin
--	  if CLK'event AND CLK='1' then
--		 if PresentState/=GetData then
--			ReceiveState <= HighNibble;
--		 elsif ComState=GetStopBit AND ComTick='1' AND HexValue(HexValue'high)='0' then
--			if(ReceiveState=HighNibble) then
--			  ReceiveState <= LowNibble;
--			else
--			  ReceiveState <= HighNibble;
--			end if;
--		 end if;
--	  end if; -- CLK
--	end process;
--
--	process(clk)
--	begin
--	  if CLK'event AND CLK='1' then
--		 if ComState=GetStopBit AND ComTick='1' AND HexValue(HexValue'high)='0' then
--			if(ReceiveState=HighNibble) then
--			  HighReg <= HexValue(3 downto 0);
--			  HexWriteStrobe <= '0';
--			else			-- LowNibble
--			  HexData  <= HighReg & HexValue(3 downto 0);
--			  HexWriteStrobe <= '1';
--			end if;
--		 else
--			HexWriteStrobe <= '0';
--		 end if;
--	  end if; -- CLK
--	end process;
--	
--end generate;
debug0 <=  CRCReg;
--debug1(7 downto 0) <= ID_Reg(15 downto 8);
--debug2(7 downto 0) <= ID_Reg(7 downto 0);
--debug0 <=  CRCReg;
debug1(8 downto 0) <=  Rec_ok & ReceivedWord ;
debug2 <= HexValue(3 downto 0) & ReceivedWordDebug & ReceivedWord ;

--P_checksum:process(clk)
--begin
--  if clk'event AND clk='1' then          
--    if PresentState=GetCommand then    -- init before data arrives 
--      CRCReg       <= (others => '0');
--      b_counter       <= (others => '0');
--	 elsif hexmode=true then
--        if ComState=GetStopBit AND ComTick='1' AND HexValue(HexValue'high)='0' AND PresentState=GetData AND ReceiveState=LowNibble then
--          CRCReg <= CRCReg + (HighReg & HexValue(3 downto 0));
--	  	    b_counter <= b_counter +1;
--		  end if;
--	 else -- binary mode
--        if ComState=GetStopBit AND ComTick='1' AND (PresentState=GetData) then
--          CRCReg <= CRCReg + ReceivedWord;
--		    b_counter <= b_counter +1;
--		  end if;
--    end if; -- checksum computation
--    
--    if (PresentState=GetData) then
--      ReceiveLED <= '1';  -- receive process in progress
--    elsif (PresentState=Idle) and (CRCReg/=TestFileChecksum) then
--      ReceiveLED <= blink(blink'high);
--    else
--      ReceiveLED <= '0';  -- receive process was OK
--    end if;
--    
--  blink <= blink -1;
--    
--  end if; --clk
--end process;                                                                 

--P_bus:process(clk)
--begin
--  if clk'event AND clk='1' then
----    if PresentState=EvalCommand then
----      ADR_Reg <= Start_Reg;
----    elsif PresentState=GetData AND ComState=GetStopBit AND ComTick='1' then
----      ADR_Reg <= ADR_Reg + 1;
----    end if;
--    
----    if PresentState=EvalCommand then
----      Word_Count <= Size_Reg;
----      LocalWriteStrobe <= '0';
----    elsif PresentState=GetData AND ComState=GetStopBit AND ComTick='1' AND Word_Count /= 0 then
----      Word_Count <= Word_Count - 1;
----      LocalWriteStrobe <= '1'; 
----    else
----      Word_Count <= Word_Count;
----      LocalWriteStrobe <= '0';
----    end if;
--
--	if hexmode=false then
--		WriteStrobe <= LocalWriteStrobe ;  -- delay Strobe to ensure that data is valid when applying clk
--													  -- should further prevent glitches in ICAP clk
--	else
--		WriteStrobe <= HexWriteStrobe ;  
--	end if;
--	
--  end if; -- clk
--end process;

--      ComLoaderActive <= '0';
--WriteData <= Data_Reg when (hexmode=false) else HexData;
ReceivedWordDebug <= Data_Reg when (hexmode=false) else HexData;
--ComActive <= '1' when (PresentState=GetData OR PresentState=GetFinish) else '0';
ComActive <= '1' when (et_loadbs=read_word0 OR 
								et_loadbs=read_word1 or 
								et_loadbs=read_word2 or 
								et_loadbs=read_word3 or
								et_loadbs=end_loadbs ) else '0';
WriteStrobe <= LocalWriteStrobe;
--P_OutReg:process(clk)
--begin
--  if clk'event AND clk='1' then
--    if PresentState=GetFinish AND D_Reg=b"0000_0000_1010_1010_1111_1111" then
--      scan_shift_strobe_from_receiver <= '1';
--      if W7(4)='1' then
--        tx_write_strobe_from_receiver <= '1';
--      else
--        tx_write_strobe_from_receiver <= '0';
--      end if;
--    else
--      scan_shift_strobe_from_receiver <= '0';
--      tx_write_strobe_from_receiver <= '0';
--    end if; -- new Package
--  end if; --clk
--end process;
--
P_TimeOut:process(clk)
-- im Moment einmal dafr benutzt rauszufinden, ob ComState 'verhungert' und
-- damit die ganze Maschine stehen bleibt
begin
  if clk'event AND clk='1' then
--    if (PresentState=Idle AND ComState=WaitForStartBit AND RxLocal='0') OR
    if (et_loadbs=Idle) OR 
        ComState=GetStopBit then
         --      Init TimeOut wenn neue Eingangs-Sequenz startet 
         --      oder wenn wieder ein Byte empfangen wurde
         --      um missglckten Empfangsvorgang abzubrechen
      TimeToSendCounter <= TimeToSendValue;
      TimeToSend <= '0';
    elsif TimeToSendCounter>0 then
      TimeToSendCounter <= TimeToSendCounter - 1;
      TimeToSend <= '0';
    else
      TimeToSendCounter <= TimeToSendCounter;
      TimeToSend <= '1'; -- force FSM to go back to idle when inactive
    end if;
  end if; --clk
end process;
loadbs_sync:process(clk)
begin
if rising_edge(clk) then 
et_loadbs<=next_et_loadbs;
fifo_reg<=fifo_reg_i;
sync_ok<=sync_ok_i;
desync_ok<=desync_ok_i;
cmd_detected<=cmd_detected_i;
 blink <= blink -1;
end if;
end process;
--==================================================================
--**afectation des sorties de la MAE LAOD BITSTREAM
--==================================================================
next_loadbs:process(et_loadbs,fifo_reg,comstate,comtick,RxLocal,
cmd_detected,sync_ok,desync_ok,Timetosend,bs_load_start,bs_load_ack)
begin
next_et_loadbs<=et_loadbs;

sync_ok_i<=sync_ok;
desync_ok_i<=desync_ok;
cmd_detected_i<=cmd_detected;
bs_load_comp<='0';
case et_loadbs is
when idle =>

 if ComState=WaitForStartBit AND RxLocal='0' and bs_load_start='1' then 
 next_et_loadbs <= check_sync;
sync_ok_i<='1'; 
 end if;
when check_sync=>

if fifo_reg=sync_reg then
next_et_loadbs<=write_icap;
end if;
if TimeToSend='1' then -- false alerte ?
 next_et_loadbs<=idle;
 end if;
 
when write_icap =>


if fifo_reg=desync_word and cmd_detected='1' then
desync_ok_i<='1';
cmd_detected_i<='1';
elsif desync_ok='1' then
 desync_ok_i<='1';
cmd_detected_i<='1'; 
elsif fifo_reg=desync_cmd then
cmd_detected_i<='1';
desync_ok_i<='0';
else
cmd_detected_i<='0';
desync_ok_i<='0';
end if;
next_et_loadbs<=reset_reg;
when reset_reg=>
next_et_loadbs<=read_word0;
when read_word0=> if ComState=GetStopBit AND ComTick='1'  then

								next_et_loadbs<=read_word1;
						end if;
				if TimeToSend='1' then 
						next_et_loadbs<=end_loadbs;
			 end if;
 when read_word1=> if ComState=GetStopBit AND ComTick='1'  then
						next_et_loadbs<=read_word2;
				else 
						if TimeToSend='1' then 
							next_et_loadbs<=end_loadbs;
						end if;
			end if;
 when read_word2=> if ComState=GetStopBit AND ComTick='1'  then
 							 next_et_loadbs<=read_word3;
						else 
								 if TimeToSend='1' then 
									next_et_loadbs<=end_loadbs;
								 end if;
						end if;
 when read_word3=> if ComState=GetStopBit AND ComTick='1'  then
				next_et_loadbs<=write_icap;
					 if TimeToSend='1' then 
							next_et_loadbs<=end_loadbs;
					 end if;
				end if;
 when end_loadbs=>
		if bs_load_ack='1' then
			next_et_loadbs<=Idle;
		end if;
		bs_load_comp<='1';
 end case;

end process;
--==========================================================
--**
--==========================================================
val_loadbs:process(et_loadbs,receivedWord,Comstate,ComTick,fifo_reg,blink,
desync_ok)
begin
fifo_reg_i<=fifo_reg;
localwritestrobe<='0';
case et_loadbs is
when idle =>
ReceiveLED <= '0';
when check_sync=>
ReceiveLED <= '0';
if ComState=GetStopBit AND ComTick='1' then
fifo_reg_i(31 downto 8)<=fifo_reg(23 downto 0);
fifo_reg_i(7 downto 0)<=Receivedword;
end if;
when write_icap=>
localWritestrobe<='1';
bs_load_data<=fifo_reg;
when reset_reg=>
fifo_reg_i<=(others=>'0'); --remise  zero du registre d'criture
when read_word0=>fifo_reg_i(31 downto 24)<=ReceivedWord;
ReceiveLED <= '1';
when read_word1=>fifo_reg_i(23 downto 16)<=ReceivedWord;
ReceiveLED <= '1';
when read_word2=>fifo_reg_i(15 downto 8)<=ReceivedWord;
ReceiveLED <= '1';
when read_word3=>fifo_reg_i(7 downto 0)<=ReceivedWord;
ReceiveLED <= '1';
when end_loadbs=>fifo_reg_i<=(others=>'1');
if desync_ok='0' then
      ReceiveLED <= blink(blink'high);
    else
      ReceiveLED <= '0';  -- receive process was OK
    end if;
end case;

    
 
end process;
----------------------------------------------------------------------------------
--               the Tx Send-Process

--tx_write_strobe <= tx_write_strobe_from_receiver OR (tast_trigger AND (NOT tast_trigger_delay));

--P_com_en2:process(clk, com_en_counter)
--begin
--        
--  if clk'event AND clk='1' then
--    
--    
--    if (tx_write_strobe='1') OR (tx_write_strobe='0' AND com_en_counter = 0) then
--      com_en_counter <= 433; --433 @ 50 MHz ######
--    else
--      com_en_counter <= com_en_counter - 1;
--    end if;
--    
--  end if;
--
--  if com_en_counter = 0 then
--    com_en <= '1';
--  else
--    com_en <= '0';
--  end if; 
--end process;
--
--P_SendCounter:process(clk, com_en)
--begin
--  if clk'event AND clk='1' then     
--      if tx_write_strobe='1' then  -- send_to_com_strobe 10 Hz so we send new values 10 times a second
--        state_counter <= 80;
--      elsif state_counter>0 then
--        if com_en_counter=0 then
--          state_counter <= state_counter - 1 ;
--        end if;
--      else
--        state_counter <= state_counter ;
--      end if;
--  end if; -- clk
--end process;

-- P_SendMux:process(state_counter, TxOut, clk)
-- begin
--   if clk'event AND clk='1' then
--     case state_counter is
--       when 80  => TxOut <= '0'; -- send start bit
--       when 79  => TxOut <= W0(0);
--       when 78  => TxOut <= W0(1);
--       when 77  => TxOut <= W0(2);
--       when 76  => TxOut <= W0(3);
--       when 75  => TxOut <= W0(4);
--       when 74  => TxOut <= W0(5);
--       when 73  => TxOut <= W0(6);
--       when 72  => TxOut <= W0(7);
--       when 71  => TxOut <= '1'; -- send stop bit
--   
--       when 70  => TxOut <= '0'; -- send start bit
--       when 69  => TxOut <= W1(0);
--       when 68  => TxOut <= W1(1);
--       when 67  => TxOut <= W1(2);
--       when 66  => TxOut <= W1(3);
--       when 65  => TxOut <= W1(4);
--       when 64  => TxOut <= W1(5);
--       when 63  => TxOut <= W1(6);
--       when 62  => TxOut <= W1(7);
--       when 61  => TxOut <= '1'; -- send stop bit
--   
--       when 60  => TxOut <= '0'; -- send start bit
--       when 59  => TxOut <= W2(0);
--       when 58  => TxOut <= W2(1);
--       when 57  => TxOut <= W2(2);
--       when 56  => TxOut <= W2(3);
--       when 55  => TxOut <= W2(4);
--       when 54  => TxOut <= W2(5);
--       when 53  => TxOut <= W2(6);
--       when 52  => TxOut <= W2(7);
--       when 51  => TxOut <= '1'; -- send stop bit
--   
--       when 50  => TxOut <= '0'; -- send start bit
--       when 49  => TxOut <= W3(0);
--       when 48  => TxOut <= W3(1);
--       when 47  => TxOut <= W3(2);
--       when 46  => TxOut <= W3(3);
--       when 45  => TxOut <= W3(4);
--       when 44  => TxOut <= W3(5);
--       when 43  => TxOut <= W3(6);
--       when 42  => TxOut <= W3(7);
--       when 41  => TxOut <= '1'; -- send stop bit
--   
--       when 40  => TxOut <= '0'; -- send start bit
--       when 39  => TxOut <= W4(0);
--       when 38  => TxOut <= W4(1);
--       when 37  => TxOut <= W4(2);
--       when 36  => TxOut <= W4(3);
--       when 35  => TxOut <= W4(4);
--       when 34  => TxOut <= W4(5);
--       when 33  => TxOut <= W4(6);
--       when 32  => TxOut <= W4(7);
--       when 31  => TxOut <= '1'; -- send stop bit
--   
--       when 30  => TxOut <= '0'; -- send start bit
--       when 29  => TxOut <= W5(0);
--       when 28  => TxOut <= W5(1);
--       when 27  => TxOut <= W5(2);
--       when 26  => TxOut <= W5(3);
--       when 25  => TxOut <= W5(4);
--       when 24  => TxOut <= W5(5);
--       when 23  => TxOut <= W5(6);
--       when 22  => TxOut <= W5(7);
--       when 21  => TxOut <= '1'; -- send stop bit
--   
--       when 20  => TxOut <= '0'; -- send start bit
--       when 19  => TxOut <= W6(0);
--       when 18  => TxOut <= W6(1);
--       when 17  => TxOut <= W6(2);
--       when 16  => TxOut <= W6(3);
--       when 15  => TxOut <= W6(4);
--       when 14  => TxOut <= W6(5);
--       when 13  => TxOut <= W6(6);
--       when 12  => TxOut <= W6(7);
--       when 11  => TxOut <= '1'; -- send stop bit
--   
--       when 10  => TxOut <= '0'; -- send start bit
--       when 9   => TxOut <= W7(0);
--       when 8   => TxOut <= '1'; -- finally the command ID sequence
--       when 7   => TxOut <= '1';
--       when 6   => TxOut <= '0';
--       when 5   => TxOut <= swap_mode;
--       when 4   => TxOut <= '0';
--       when 3   => TxOut <= '1';
--       when 2   => TxOut <= '1';
--                               
--       when others => TxOut <= '1'; -- send stop bit
--      end case;                
--   end if; -- clk;
-- end process;
-- 
TxOut<=Rx;
RxErr<=Stop_err;
end architecture;





