----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    18:01:21 10/23/2012 
-- Design Name: 
-- Module Name:    proto_send - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
USE ieee.numeric_std.ALL;
use work.CoreTypes.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity proto_send is
generic (sizemem : natural := 64);
 port (
 clk,reset : in std_logic;
 fifo_in_empty,fifo_in_full : in std_logic; --signaux pour le fifo d'entre
 fifo_out_empty,fifo_out_full : in std_logic; --signaux pour le fifo de sortie
 fifo_out_wr_en : out std_logic:='0'; --criture autorise dans la fifo de sortie
 fifo_in_rd_en : out std_logic:='0'; --lecture autorise dans la fifo d'entre
 fifo_in_data_out : in std_logic_vector(Word-1 downto 0);
 fifo_out_data_in : out std_logic_vector(Word-1 downto 0);
 packet_len : in std_logic_vector(Word-1 downto 0); --la longueur du paquet
 copy_mode : in std_logic; --Fifo_to_mem ou Fifo_to_fifo
 snd_start : in std_logic; --dbut de la rception
 snd_ack :in std_logic;   -- acquittement de la rception
 snd_comp : out std_logic; -- fin de la rception
 mem :in memory(0 to sizemem-1)); --donnes  copier vers le fifo

end proto_send;

architecture Behavioral of proto_send is
type typ_send is (s_head,s_len,s_len2,s_data,s_pulse,s_end);
 signal etsnd : typ_send;
 signal snd_state,next_snd_state:natural range 0 to 7:=0;
 signal p_len,p_len_i : natural range 0 to 255;
 signal n,n_i:natural range 0 to 7;
 signal wr_ok,rd_ok:std_logic:='0';
 signal wr_ok_i,rd_ok_i:std_logic:='0';
 signal sfifo_in,Data_to_send,Data_to_send_i  : std_logic_vector(Word-1 downto 0);
 signal spush : std_logic:='0';
 signal err : std_logic_vector(Word-1 downto 0):=(others =>'0');
begin

Fifo_copy_sync:process(clk,reset)

begin


  if reset='1' then
  n<=0;
  Snd_state<=0;
  P_len<=0;
  Data_to_send<=(others=>'0');
else
	if rising_edge(clk) then
  Snd_state<=Next_Snd_state;
  n<=n_i;	
  p_len<=P_len_i;
  Data_to_send<=Data_to_send_i;
  wr_ok<=wr_ok_i;
  rd_ok<=rd_ok_i;
end if;
end if;
end process fifo_copy_sync;
	-- affectation concurentes
	 Fifo_copy_val:process (Snd_state,Etsnd,copy_mode,data_to_send,rd_ok,wr_ok,spush)
begin
	fifo_out_wr_en<='0';
	fifo_in_rd_en<='0';
	fifo_out_data_in<=data_to_send;
	if copy_mode='0' then 
	  fifo_out_wr_en<=wr_ok;
	  fifo_out_data_in<=data_to_send;
	  fifo_in_rd_en<='0';
else
    if (Snd_state=1) or (snd_state=2) then
	    	  fifo_out_wr_en<=wr_ok;
	    	  fifo_in_rd_en<=rd_ok;
	    	  fifo_out_data_in<=data_to_send;
	  end if;
end if;
end process fifo_copy_val;
	-- process qui envoie des donnes en provenance d'un Fifo vers un Fifo
	FIfo_to_fifo:process(snd_state,copy_mode,snd_start,snd_ack,fifo_in_empty,
	fifo_out_full,Fifo_in_data_out,Data_to_send,p_len,n,mem,wr_ok,rd_ok,packet_len)
	variable onepop:std_logic:='0';
	begin
	  	  Next_snd_state<=snd_state; --valeur par defaut
	  	  Data_To_Send_i<=Data_to_send;
	  	  wr_ok_i<=wr_ok;
	  	  rd_ok_i<=rd_ok;
		  n_i<=n;
		  p_len_i<=p_len;
		  snd_comp<='0';
	  case snd_state is

	  when 0 => if snd_start='1' then
	               P_len_i<=to_integer(unsigned(packet_len));
	                 next_snd_state<=1;
	                 n_i<=0;
	             end if;
	             wr_ok_i<='0';rd_ok_i<='0';onepop:='0';
	             snd_comp<='0';
	 when 1=>         --placer la premire donne sur le bus  
										    if copy_mode='1' then 
    												  if  fifo_in_empty='0'  then
    														  data_to_send_i <=fifo_in_data_out ;		
    												  end if;
												else
												  data_to_send_i<=mem(n);
												 end if;
												 next_snd_state<=2;	
	  when 2=>         if P_len>0 then  
										    if copy_mode='1' then 
    												  if  fifo_in_empty='0' and onepop='0' then
    														  data_to_send_i <=fifo_in_data_out ;
    														  rd_Ok_i<='1';
    															onepop:='1'; --une donne lue il faut arrter de dpiler
    															
    												  else
    															rd_Ok_i<='0';
    												  end if;
												else
												  onepop:='1';rd_ok_i<='0'; --pas besoin de signal de lecture ici
												  data_to_send_i<=mem(n);
												 end if;

											  if (fifo_out_full = '0') and onepop='1'   then	 							
											  			wr_ok_i<='1';
													 onepop:='0';
													 p_len_i<=p_len-1;
													 n_i<=n+1;													
												else
														wr_Ok_i<='0';													
												end if;
											else
											 rd_ok_i<='0';
											 wr_ok_i<='0';
											 next_snd_state<=3;
											 snd_comp<='1';
											end if; 
		when 3 =>  --fin de la copie
												if  snd_ack='1' then 
												
												    next_snd_state<=4;
												end if;
												wr_ok_i<='0';rd_ok_i<='0';
												snd_comp<='1';		
														
	when 4 =>next_snd_state<=0;
	         snd_comp<='0';
															
when others => next_snd_state<=0;
                  snd_comp<='0';
                  rd_ok_i<='0';
                  wr_ok_i<='0';
                  data_to_send_i <=(others=>'U');
  end case;
	end process FIfo_to_fifo;
	
end Behavioral;

