----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL / GAMOM NGOUNOU
-- 
-- Create Date:    11:48:18 06/19/2011 
-- Design Name: 
-- Module Name:    Crossbar - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: module implmentant les crossbar
-- ce module instacie les crossbar 1 bit du fichier crossbit.vhd
--  
-- CROSSBAR GENERIQUE
-- Revision: 1.0
-- a t retir les signaux inutilises comme fp, port_source, etc...
-- Revision 0.01 - File Created
-- Revision 0.02 Ajout des signaux clk et reset
-- Additional Comments: pour la gestion du pipeline
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library NocLib ;
use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Crossbar is
    generic
	      (
			  number_of_crossbar_ports: positive := 8
			);
    Port ( clk : in  STD_LOGIC;
			  reset : in  STD_LOGIC; --pour grer le pipeline
			  Port1_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port2_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port3_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port4_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			  Port5_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port6_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port7_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port8_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			  Port9_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port10_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port11_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port12_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			  Port13_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port14_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port15_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port16_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			  
			  Port1_pulse_in : in std_logic;
			  Port2_pulse_in : in std_logic;
			  Port3_pulse_in : in std_logic;
			  Port4_pulse_in : in std_logic;
			  Port5_pulse_in : in std_logic;
			  Port6_pulse_in : in std_logic;
			  Port7_pulse_in : in std_logic;
			  Port8_pulse_in : in std_logic;
			  Port9_pulse_in : in std_logic;
			  Port10_pulse_in : in std_logic;
			  Port11_pulse_in : in std_logic;
			  Port12_pulse_in : in std_logic;
			  Port13_pulse_in : in std_logic;
			  Port14_pulse_in : in std_logic;
			  Port15_pulse_in : in std_logic;
			  Port16_pulse_in : in std_logic;
			  
			  Port1_pulse_out : out std_logic;
			  Port2_pulse_out : out std_logic;
			  Port3_pulse_out : out std_logic;
			  Port4_pulse_out : out std_logic;
			  Port5_pulse_out : out std_logic;
			  Port6_pulse_out : out std_logic;
			  Port7_pulse_out : out std_logic;
			  Port8_pulse_out : out std_logic;
			  Port9_pulse_out : out std_logic;
			  Port10_pulse_out : out std_logic;
			  Port11_pulse_out : out std_logic;
			  Port12_pulse_out : out std_logic;
			  Port13_pulse_out : out std_logic;
			  Port14_pulse_out : out std_logic;
			  Port15_pulse_out : out std_logic;
			  Port16_pulse_out : out std_logic;
			  
			  Port1_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port2_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port3_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port4_out : out  STD_LOGIC_VECTOR (Word-1 downto 0); 
			  Port5_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port6_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port7_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port8_out : out  STD_LOGIC_VECTOR (Word-1 downto 0); 
			  Port9_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port10_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port11_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port12_out : out  STD_LOGIC_VECTOR (Word-1 downto 0); 
			  Port13_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port14_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port15_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Port16_out : out  STD_LOGIC_VECTOR (Word-1 downto 0); 
			  
           Ctrl : in  STD_LOGIC_VECTOR (number_of_crossbar_ports*number_of_crossbar_ports downto 1)
            );        
end Crossbar;

architecture Behavioral of Crossbar is

-- declaration du crossbar un bit instancis pour former les crossbars
COMPONENT Crossbit
	generic
	      (
			  number_of_ports : positive := 4
			);
    Port ( clk,reset : in std_logic;
			  Control : in  STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1);
           Data_In : in  STD_LOGIC_VECTOR (number_of_ports downto 1);
           Data_out : out  STD_LOGIC_VECTOR (number_of_ports downto 1));
	END COMPONENT;	
signal ctrl_buf:	STD_LOGIC_VECTOR (number_of_crossbar_ports*number_of_crossbar_ports downto 1):=(others=>'0');
--signal ctrl_chg:std_logic:='0';
begin
-- La matrice interconnectee
-- le circuit genere depend du parametre generique nombre de ports
--ctrl_chg<=all_zeros(ctrl_buf xor ctrl); --sur chaque changement du mot de contrle, mettre  jour ce registre
--ctrl_proc:process(ctrl)
--	begin
	ctrl_buf<=ctrl;
--	end process;
--======================crossbar 2 ports=======================

crossbar2x2 : if number_of_crossbar_ports = 2 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(
		reset => reset,
		clk =>clk,
      
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(
		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(
		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(
		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(

		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7)

           );
-- crossbit du pulse_out 2 ports 

   Pulse_out_Crossbit2: Crossbit 
      GENERIC MAP(number_of_ports => 2)
      PORT MAP(
		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out 

           );
end generate crossbar2x2;


--======================crossbar 3 ports=======================

crossbar3x3 : if number_of_crossbar_ports = 3 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(

		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(
		reset => reset,
		clk =>clk,
      
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(
		reset => reset,
		clk =>clk,
      
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(

		reset => reset,
		clk =>clk,
      
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(
		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7)

           );
-- crossbit du pulse_out 3 ports 

   Pulse_out_Crossbit3: Crossbit 
      GENERIC MAP(number_of_ports => 3)
      PORT MAP(
		reset => reset,
		clk =>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out 

           );
end generate crossbar3x3;


--======================crossbar 4 ports=======================

crossbar4x4 : if number_of_crossbar_ports = 4 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7)

           );
-- crossbit du pulse_out 4 ports 

   Pulse_out_Crossbit4: Crossbit 
      GENERIC MAP(number_of_ports => 4)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out 

           );
end generate crossbar4x4;


--======================crossbar 5 ports=======================

crossbar5x5 : if number_of_crossbar_ports = 5 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7)

           );
-- crossbit du pulse_out 5 ports 

   Pulse_out_Crossbit5: Crossbit 
      GENERIC MAP(number_of_ports => 5)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out 

           );
end generate crossbar5x5;


--======================crossbar 6 ports=======================

crossbar6x6 : if number_of_crossbar_ports = 6 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7)

           );
-- crossbit du pulse_out 6 ports 

   Pulse_out_Crossbit6: Crossbit 
      GENERIC MAP(number_of_ports => 6)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out 

           );
end generate crossbar6x6;


--======================crossbar 7 ports=======================

crossbar7x7 : if number_of_crossbar_ports = 7 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7)

           );
-- crossbit du pulse_out 7 ports 

   Pulse_out_Crossbit7: Crossbit 
      GENERIC MAP(number_of_ports => 7)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out 

           );
end generate crossbar7x7;


--======================crossbar 8 ports=======================

crossbar8x8 : if number_of_crossbar_ports = 8 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,
    
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,
      
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,
      
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,
 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7)

           );
-- crossbit du pulse_out 8 ports 

   Pulse_out_Crossbit8: Crossbit 
      GENERIC MAP(number_of_ports => 8)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out 

           );
end generate crossbar8x8;


--======================crossbar 9 ports=======================

crossbar9x9 : if number_of_crossbar_ports = 9 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
    
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
     
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7)

           );
-- crossbit du pulse_out 9 ports 

   Pulse_out_Crossbit9: Crossbit 
      GENERIC MAP(number_of_ports => 9)
      PORT MAP(
		clk =>clk,
		reset =>reset,
   
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out 

           );
end generate crossbar9x9;


--======================crossbar 10 ports=======================

crossbar10x10 : if number_of_crossbar_ports = 10 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7)

           );
-- crossbit du pulse_out 10 ports 

   Pulse_out_Crossbit10: Crossbit 
      GENERIC MAP(number_of_ports => 10)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out 

           );
end generate crossbar10x10;


--======================crossbar 11 ports=======================

crossbar11x11 : if number_of_crossbar_ports = 11 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_In(11) => Port11_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0),
       Data_out(11)=> Port11_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_In(11) => Port11_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1),
       Data_out(11)=> Port11_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_In(11) => Port11_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2),
       Data_out(11)=> Port11_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_In(11) => Port11_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3),
       Data_out(11)=> Port11_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_In(11) => Port11_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4),
       Data_out(11)=> Port11_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_In(11) => Port11_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5),
       Data_out(11)=> Port11_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_In(11) => Port11_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6),
       Data_out(11)=> Port11_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_In(11) => Port11_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7),
       Data_out(11)=> Port11_out(7)

           );
-- crossbit du pulse_out 11 ports 

   Pulse_out_Crossbit11: Crossbit 
      GENERIC MAP(number_of_ports => 11)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_In(11) => Port11_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out,
       Data_out(11) => Port11_pulse_out 

           );
end generate crossbar11x11;


--======================crossbar 12 ports=======================

crossbar12x12 : if number_of_crossbar_ports = 12 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_In(11) => Port11_in(0),
       Data_In(12) => Port12_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0),
       Data_out(11)=> Port11_out(0),
       Data_out(12)=> Port12_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_In(11) => Port11_in(1),
       Data_In(12) => Port12_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1),
       Data_out(11)=> Port11_out(1),
       Data_out(12)=> Port12_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_In(11) => Port11_in(2),
       Data_In(12) => Port12_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2),
       Data_out(11)=> Port11_out(2),
       Data_out(12)=> Port12_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_In(11) => Port11_in(3),
       Data_In(12) => Port12_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3),
       Data_out(11)=> Port11_out(3),
       Data_out(12)=> Port12_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_In(11) => Port11_in(4),
       Data_In(12) => Port12_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4),
       Data_out(11)=> Port11_out(4),
       Data_out(12)=> Port12_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_In(11) => Port11_in(5),
       Data_In(12) => Port12_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5),
       Data_out(11)=> Port11_out(5),
       Data_out(12)=> Port12_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_In(11) => Port11_in(6),
       Data_In(12) => Port12_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6),
       Data_out(11)=> Port11_out(6),
       Data_out(12)=> Port12_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_In(11) => Port11_in(7),
       Data_In(12) => Port12_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7),
       Data_out(11)=> Port11_out(7),
       Data_out(12)=> Port12_out(7)

           );
-- crossbit du pulse_out 12 ports 

   Pulse_out_Crossbit12: Crossbit 
      GENERIC MAP(number_of_ports => 12)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_In(11) => Port11_pulse_in,
       Data_In(12) => Port12_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out,
       Data_out(11) => Port11_pulse_out,
       Data_out(12) => Port12_pulse_out 

           );
end generate crossbar12x12;


--======================crossbar 13 ports=======================

crossbar13x13 : if number_of_crossbar_ports = 13 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_In(11) => Port11_in(0),
       Data_In(12) => Port12_in(0),
       Data_In(13) => Port13_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0),
       Data_out(11)=> Port11_out(0),
       Data_out(12)=> Port12_out(0),
       Data_out(13)=> Port13_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,

 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_In(11) => Port11_in(1),
       Data_In(12) => Port12_in(1),
       Data_In(13) => Port13_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1),
       Data_out(11)=> Port11_out(1),
       Data_out(12)=> Port12_out(1),
       Data_out(13)=> Port13_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_In(11) => Port11_in(2),
       Data_In(12) => Port12_in(2),
       Data_In(13) => Port13_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2),
       Data_out(11)=> Port11_out(2),
       Data_out(12)=> Port12_out(2),
       Data_out(13)=> Port13_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_In(11) => Port11_in(3),
       Data_In(12) => Port12_in(3),
       Data_In(13) => Port13_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3),
       Data_out(11)=> Port11_out(3),
       Data_out(12)=> Port12_out(3),
       Data_out(13)=> Port13_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_In(11) => Port11_in(4),
       Data_In(12) => Port12_in(4),
       Data_In(13) => Port13_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4),
       Data_out(11)=> Port11_out(4),
       Data_out(12)=> Port12_out(4),
       Data_out(13)=> Port13_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_In(11) => Port11_in(5),
       Data_In(12) => Port12_in(5),
       Data_In(13) => Port13_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5),
       Data_out(11)=> Port11_out(5),
       Data_out(12)=> Port12_out(5),
       Data_out(13)=> Port13_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_In(11) => Port11_in(6),
       Data_In(12) => Port12_in(6),
       Data_In(13) => Port13_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6),
       Data_out(11)=> Port11_out(6),
       Data_out(12)=> Port12_out(6),
       Data_out(13)=> Port13_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_In(11) => Port11_in(7),
       Data_In(12) => Port12_in(7),
       Data_In(13) => Port13_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7),
       Data_out(11)=> Port11_out(7),
       Data_out(12)=> Port12_out(7),
       Data_out(13)=> Port13_out(7)

           );
-- crossbit du pulse_out 13 ports 

   Pulse_out_Crossbit13: Crossbit 
      GENERIC MAP(number_of_ports => 13)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_In(11) => Port11_pulse_in,
       Data_In(12) => Port12_pulse_in,
       Data_In(13) => Port13_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out,
       Data_out(11) => Port11_pulse_out,
       Data_out(12) => Port12_pulse_out,
       Data_out(13) => Port13_pulse_out 

           );
end generate crossbar13x13;


--======================crossbar 14 ports=======================

crossbar14x14 : if number_of_crossbar_ports = 14 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_In(11) => Port11_in(0),
       Data_In(12) => Port12_in(0),
       Data_In(13) => Port13_in(0),
       Data_In(14) => Port14_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0),
       Data_out(11)=> Port11_out(0),
       Data_out(12)=> Port12_out(0),
       Data_out(13)=> Port13_out(0),
       Data_out(14)=> Port14_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_In(11) => Port11_in(1),
       Data_In(12) => Port12_in(1),
       Data_In(13) => Port13_in(1),
       Data_In(14) => Port14_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1),
       Data_out(11)=> Port11_out(1),
       Data_out(12)=> Port12_out(1),
       Data_out(13)=> Port13_out(1),
       Data_out(14)=> Port14_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_In(11) => Port11_in(2),
       Data_In(12) => Port12_in(2),
       Data_In(13) => Port13_in(2),
       Data_In(14) => Port14_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2),
       Data_out(11)=> Port11_out(2),
       Data_out(12)=> Port12_out(2),
       Data_out(13)=> Port13_out(2),
       Data_out(14)=> Port14_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_In(11) => Port11_in(3),
       Data_In(12) => Port12_in(3),
       Data_In(13) => Port13_in(3),
       Data_In(14) => Port14_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3),
       Data_out(11)=> Port11_out(3),
       Data_out(12)=> Port12_out(3),
       Data_out(13)=> Port13_out(3),
       Data_out(14)=> Port14_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_In(11) => Port11_in(4),
       Data_In(12) => Port12_in(4),
       Data_In(13) => Port13_in(4),
       Data_In(14) => Port14_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4),
       Data_out(11)=> Port11_out(4),
       Data_out(12)=> Port12_out(4),
       Data_out(13)=> Port13_out(4),
       Data_out(14)=> Port14_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_In(11) => Port11_in(5),
       Data_In(12) => Port12_in(5),
       Data_In(13) => Port13_in(5),
       Data_In(14) => Port14_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5),
       Data_out(11)=> Port11_out(5),
       Data_out(12)=> Port12_out(5),
       Data_out(13)=> Port13_out(5),
       Data_out(14)=> Port14_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_In(11) => Port11_in(6),
       Data_In(12) => Port12_in(6),
       Data_In(13) => Port13_in(6),
       Data_In(14) => Port14_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6),
       Data_out(11)=> Port11_out(6),
       Data_out(12)=> Port12_out(6),
       Data_out(13)=> Port13_out(6),
       Data_out(14)=> Port14_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_In(11) => Port11_in(7),
       Data_In(12) => Port12_in(7),
       Data_In(13) => Port13_in(7),
       Data_In(14) => Port14_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7),
       Data_out(11)=> Port11_out(7),
       Data_out(12)=> Port12_out(7),
       Data_out(13)=> Port13_out(7),
       Data_out(14)=> Port14_out(7)

           );
-- crossbit du pulse_out 14 ports 

   Pulse_out_Crossbit14: Crossbit 
      GENERIC MAP(number_of_ports => 14)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_In(11) => Port11_pulse_in,
       Data_In(12) => Port12_pulse_in,
       Data_In(13) => Port13_pulse_in,
       Data_In(14) => Port14_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out,
       Data_out(11) => Port11_pulse_out,
       Data_out(12) => Port12_pulse_out,
       Data_out(13) => Port13_pulse_out,
       Data_out(14) => Port14_pulse_out 

           );
end generate crossbar14x14;


--======================crossbar 15 ports=======================

crossbar15x15 : if number_of_crossbar_ports = 15 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_In(11) => Port11_in(0),
       Data_In(12) => Port12_in(0),
       Data_In(13) => Port13_in(0),
       Data_In(14) => Port14_in(0),
       Data_In(15) => Port15_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0),
       Data_out(11)=> Port11_out(0),
       Data_out(12)=> Port12_out(0),
       Data_out(13)=> Port13_out(0),
       Data_out(14)=> Port14_out(0),
       Data_out(15)=> Port15_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_In(11) => Port11_in(1),
       Data_In(12) => Port12_in(1),
       Data_In(13) => Port13_in(1),
       Data_In(14) => Port14_in(1),
       Data_In(15) => Port15_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1),
       Data_out(11)=> Port11_out(1),
       Data_out(12)=> Port12_out(1),
       Data_out(13)=> Port13_out(1),
       Data_out(14)=> Port14_out(1),
       Data_out(15)=> Port15_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_In(11) => Port11_in(2),
       Data_In(12) => Port12_in(2),
       Data_In(13) => Port13_in(2),
       Data_In(14) => Port14_in(2),
       Data_In(15) => Port15_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2),
       Data_out(11)=> Port11_out(2),
       Data_out(12)=> Port12_out(2),
       Data_out(13)=> Port13_out(2),
       Data_out(14)=> Port14_out(2),
       Data_out(15)=> Port15_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_In(11) => Port11_in(3),
       Data_In(12) => Port12_in(3),
       Data_In(13) => Port13_in(3),
       Data_In(14) => Port14_in(3),
       Data_In(15) => Port15_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3),
       Data_out(11)=> Port11_out(3),
       Data_out(12)=> Port12_out(3),
       Data_out(13)=> Port13_out(3),
       Data_out(14)=> Port14_out(3),
       Data_out(15)=> Port15_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_In(11) => Port11_in(4),
       Data_In(12) => Port12_in(4),
       Data_In(13) => Port13_in(4),
       Data_In(14) => Port14_in(4),
       Data_In(15) => Port15_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4),
       Data_out(11)=> Port11_out(4),
       Data_out(12)=> Port12_out(4),
       Data_out(13)=> Port13_out(4),
       Data_out(14)=> Port14_out(4),
       Data_out(15)=> Port15_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_In(11) => Port11_in(5),
       Data_In(12) => Port12_in(5),
       Data_In(13) => Port13_in(5),
       Data_In(14) => Port14_in(5),
       Data_In(15) => Port15_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5),
       Data_out(11)=> Port11_out(5),
       Data_out(12)=> Port12_out(5),
       Data_out(13)=> Port13_out(5),
       Data_out(14)=> Port14_out(5),
       Data_out(15)=> Port15_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_In(11) => Port11_in(6),
       Data_In(12) => Port12_in(6),
       Data_In(13) => Port13_in(6),
       Data_In(14) => Port14_in(6),
       Data_In(15) => Port15_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6),
       Data_out(11)=> Port11_out(6),
       Data_out(12)=> Port12_out(6),
       Data_out(13)=> Port13_out(6),
       Data_out(14)=> Port14_out(6),
       Data_out(15)=> Port15_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_In(11) => Port11_in(7),
       Data_In(12) => Port12_in(7),
       Data_In(13) => Port13_in(7),
       Data_In(14) => Port14_in(7),
       Data_In(15) => Port15_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7),
       Data_out(11)=> Port11_out(7),
       Data_out(12)=> Port12_out(7),
       Data_out(13)=> Port13_out(7),
       Data_out(14)=> Port14_out(7),
       Data_out(15)=> Port15_out(7)

           );
-- crossbit du pulse_out 15 ports 

   Pulse_out_Crossbit15: Crossbit 
      GENERIC MAP(number_of_ports => 15)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_In(11) => Port11_pulse_in,
       Data_In(12) => Port12_pulse_in,
       Data_In(13) => Port13_pulse_in,
       Data_In(14) => Port14_pulse_in,
       Data_In(15) => Port15_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out,
       Data_out(11) => Port11_pulse_out,
       Data_out(12) => Port12_pulse_out,
       Data_out(13) => Port13_pulse_out,
       Data_out(14) => Port14_pulse_out,
       Data_out(15) => Port15_pulse_out 

           );
end generate crossbar15x15;


--======================crossbar 16 ports=======================

crossbar16x16 : if number_of_crossbar_ports = 16 generate

-- crossbit du bit 0 de donne

   Data0_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(0),
       Data_In(2) => Port2_in(0),
       Data_In(3) => Port3_in(0),
       Data_In(4) => Port4_in(0),
       Data_In(5) => Port5_in(0),
       Data_In(6) => Port6_in(0),
       Data_In(7) => Port7_in(0),
       Data_In(8) => Port8_in(0),
       Data_In(9) => Port9_in(0),
       Data_In(10) => Port10_in(0),
       Data_In(11) => Port11_in(0),
       Data_In(12) => Port12_in(0),
       Data_In(13) => Port13_in(0),
       Data_In(14) => Port14_in(0),
       Data_In(15) => Port15_in(0),
       Data_In(16) => Port16_in(0),
       Data_out(1)=> Port1_out(0),
       Data_out(2)=> Port2_out(0),
       Data_out(3)=> Port3_out(0),
       Data_out(4)=> Port4_out(0),
       Data_out(5)=> Port5_out(0),
       Data_out(6)=> Port6_out(0),
       Data_out(7)=> Port7_out(0),
       Data_out(8)=> Port8_out(0),
       Data_out(9)=> Port9_out(0),
       Data_out(10)=> Port10_out(0),
       Data_out(11)=> Port11_out(0),
       Data_out(12)=> Port12_out(0),
       Data_out(13)=> Port13_out(0),
       Data_out(14)=> Port14_out(0),
       Data_out(15)=> Port15_out(0),
       Data_out(16)=> Port16_out(0)

           );
-- crossbit du bit 1 de donne

   Data1_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(1),
       Data_In(2) => Port2_in(1),
       Data_In(3) => Port3_in(1),
       Data_In(4) => Port4_in(1),
       Data_In(5) => Port5_in(1),
       Data_In(6) => Port6_in(1),
       Data_In(7) => Port7_in(1),
       Data_In(8) => Port8_in(1),
       Data_In(9) => Port9_in(1),
       Data_In(10) => Port10_in(1),
       Data_In(11) => Port11_in(1),
       Data_In(12) => Port12_in(1),
       Data_In(13) => Port13_in(1),
       Data_In(14) => Port14_in(1),
       Data_In(15) => Port15_in(1),
       Data_In(16) => Port16_in(1),
       Data_out(1)=> Port1_out(1),
       Data_out(2)=> Port2_out(1),
       Data_out(3)=> Port3_out(1),
       Data_out(4)=> Port4_out(1),
       Data_out(5)=> Port5_out(1),
       Data_out(6)=> Port6_out(1),
       Data_out(7)=> Port7_out(1),
       Data_out(8)=> Port8_out(1),
       Data_out(9)=> Port9_out(1),
       Data_out(10)=> Port10_out(1),
       Data_out(11)=> Port11_out(1),
       Data_out(12)=> Port12_out(1),
       Data_out(13)=> Port13_out(1),
       Data_out(14)=> Port14_out(1),
       Data_out(15)=> Port15_out(1),
       Data_out(16)=> Port16_out(1)

           );
-- crossbit du bit 2 de donne

   Data2_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(2),
       Data_In(2) => Port2_in(2),
       Data_In(3) => Port3_in(2),
       Data_In(4) => Port4_in(2),
       Data_In(5) => Port5_in(2),
       Data_In(6) => Port6_in(2),
       Data_In(7) => Port7_in(2),
       Data_In(8) => Port8_in(2),
       Data_In(9) => Port9_in(2),
       Data_In(10) => Port10_in(2),
       Data_In(11) => Port11_in(2),
       Data_In(12) => Port12_in(2),
       Data_In(13) => Port13_in(2),
       Data_In(14) => Port14_in(2),
       Data_In(15) => Port15_in(2),
       Data_In(16) => Port16_in(2),
       Data_out(1)=> Port1_out(2),
       Data_out(2)=> Port2_out(2),
       Data_out(3)=> Port3_out(2),
       Data_out(4)=> Port4_out(2),
       Data_out(5)=> Port5_out(2),
       Data_out(6)=> Port6_out(2),
       Data_out(7)=> Port7_out(2),
       Data_out(8)=> Port8_out(2),
       Data_out(9)=> Port9_out(2),
       Data_out(10)=> Port10_out(2),
       Data_out(11)=> Port11_out(2),
       Data_out(12)=> Port12_out(2),
       Data_out(13)=> Port13_out(2),
       Data_out(14)=> Port14_out(2),
       Data_out(15)=> Port15_out(2),
       Data_out(16)=> Port16_out(2)

           );
-- crossbit du bit 3 de donne

   Data3_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(3),
       Data_In(2) => Port2_in(3),
       Data_In(3) => Port3_in(3),
       Data_In(4) => Port4_in(3),
       Data_In(5) => Port5_in(3),
       Data_In(6) => Port6_in(3),
       Data_In(7) => Port7_in(3),
       Data_In(8) => Port8_in(3),
       Data_In(9) => Port9_in(3),
       Data_In(10) => Port10_in(3),
       Data_In(11) => Port11_in(3),
       Data_In(12) => Port12_in(3),
       Data_In(13) => Port13_in(3),
       Data_In(14) => Port14_in(3),
       Data_In(15) => Port15_in(3),
       Data_In(16) => Port16_in(3),
       Data_out(1)=> Port1_out(3),
       Data_out(2)=> Port2_out(3),
       Data_out(3)=> Port3_out(3),
       Data_out(4)=> Port4_out(3),
       Data_out(5)=> Port5_out(3),
       Data_out(6)=> Port6_out(3),
       Data_out(7)=> Port7_out(3),
       Data_out(8)=> Port8_out(3),
       Data_out(9)=> Port9_out(3),
       Data_out(10)=> Port10_out(3),
       Data_out(11)=> Port11_out(3),
       Data_out(12)=> Port12_out(3),
       Data_out(13)=> Port13_out(3),
       Data_out(14)=> Port14_out(3),
       Data_out(15)=> Port15_out(3),
       Data_out(16)=> Port16_out(3)

           );
-- crossbit du bit 4 de donne

   Data4_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(4),
       Data_In(2) => Port2_in(4),
       Data_In(3) => Port3_in(4),
       Data_In(4) => Port4_in(4),
       Data_In(5) => Port5_in(4),
       Data_In(6) => Port6_in(4),
       Data_In(7) => Port7_in(4),
       Data_In(8) => Port8_in(4),
       Data_In(9) => Port9_in(4),
       Data_In(10) => Port10_in(4),
       Data_In(11) => Port11_in(4),
       Data_In(12) => Port12_in(4),
       Data_In(13) => Port13_in(4),
       Data_In(14) => Port14_in(4),
       Data_In(15) => Port15_in(4),
       Data_In(16) => Port16_in(4),
       Data_out(1)=> Port1_out(4),
       Data_out(2)=> Port2_out(4),
       Data_out(3)=> Port3_out(4),
       Data_out(4)=> Port4_out(4),
       Data_out(5)=> Port5_out(4),
       Data_out(6)=> Port6_out(4),
       Data_out(7)=> Port7_out(4),
       Data_out(8)=> Port8_out(4),
       Data_out(9)=> Port9_out(4),
       Data_out(10)=> Port10_out(4),
       Data_out(11)=> Port11_out(4),
       Data_out(12)=> Port12_out(4),
       Data_out(13)=> Port13_out(4),
       Data_out(14)=> Port14_out(4),
       Data_out(15)=> Port15_out(4),
       Data_out(16)=> Port16_out(4)

           );
-- crossbit du bit 5 de donne

   Data5_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(5),
       Data_In(2) => Port2_in(5),
       Data_In(3) => Port3_in(5),
       Data_In(4) => Port4_in(5),
       Data_In(5) => Port5_in(5),
       Data_In(6) => Port6_in(5),
       Data_In(7) => Port7_in(5),
       Data_In(8) => Port8_in(5),
       Data_In(9) => Port9_in(5),
       Data_In(10) => Port10_in(5),
       Data_In(11) => Port11_in(5),
       Data_In(12) => Port12_in(5),
       Data_In(13) => Port13_in(5),
       Data_In(14) => Port14_in(5),
       Data_In(15) => Port15_in(5),
       Data_In(16) => Port16_in(5),
       Data_out(1)=> Port1_out(5),
       Data_out(2)=> Port2_out(5),
       Data_out(3)=> Port3_out(5),
       Data_out(4)=> Port4_out(5),
       Data_out(5)=> Port5_out(5),
       Data_out(6)=> Port6_out(5),
       Data_out(7)=> Port7_out(5),
       Data_out(8)=> Port8_out(5),
       Data_out(9)=> Port9_out(5),
       Data_out(10)=> Port10_out(5),
       Data_out(11)=> Port11_out(5),
       Data_out(12)=> Port12_out(5),
       Data_out(13)=> Port13_out(5),
       Data_out(14)=> Port14_out(5),
       Data_out(15)=> Port15_out(5),
       Data_out(16)=> Port16_out(5)

           );
-- crossbit du bit 6 de donne

   Data6_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(6),
       Data_In(2) => Port2_in(6),
       Data_In(3) => Port3_in(6),
       Data_In(4) => Port4_in(6),
       Data_In(5) => Port5_in(6),
       Data_In(6) => Port6_in(6),
       Data_In(7) => Port7_in(6),
       Data_In(8) => Port8_in(6),
       Data_In(9) => Port9_in(6),
       Data_In(10) => Port10_in(6),
       Data_In(11) => Port11_in(6),
       Data_In(12) => Port12_in(6),
       Data_In(13) => Port13_in(6),
       Data_In(14) => Port14_in(6),
       Data_In(15) => Port15_in(6),
       Data_In(16) => Port16_in(6),
       Data_out(1)=> Port1_out(6),
       Data_out(2)=> Port2_out(6),
       Data_out(3)=> Port3_out(6),
       Data_out(4)=> Port4_out(6),
       Data_out(5)=> Port5_out(6),
       Data_out(6)=> Port6_out(6),
       Data_out(7)=> Port7_out(6),
       Data_out(8)=> Port8_out(6),
       Data_out(9)=> Port9_out(6),
       Data_out(10)=> Port10_out(6),
       Data_out(11)=> Port11_out(6),
       Data_out(12)=> Port12_out(6),
       Data_out(13)=> Port13_out(6),
       Data_out(14)=> Port14_out(6),
       Data_out(15)=> Port15_out(6),
       Data_out(16)=> Port16_out(6)

           );
-- crossbit du bit 7 de donne

   Data7_Crossbit: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_in(7),
       Data_In(2) => Port2_in(7),
       Data_In(3) => Port3_in(7),
       Data_In(4) => Port4_in(7),
       Data_In(5) => Port5_in(7),
       Data_In(6) => Port6_in(7),
       Data_In(7) => Port7_in(7),
       Data_In(8) => Port8_in(7),
       Data_In(9) => Port9_in(7),
       Data_In(10) => Port10_in(7),
       Data_In(11) => Port11_in(7),
       Data_In(12) => Port12_in(7),
       Data_In(13) => Port13_in(7),
       Data_In(14) => Port14_in(7),
       Data_In(15) => Port15_in(7),
       Data_In(16) => Port16_in(7),
       Data_out(1)=> Port1_out(7),
       Data_out(2)=> Port2_out(7),
       Data_out(3)=> Port3_out(7),
       Data_out(4)=> Port4_out(7),
       Data_out(5)=> Port5_out(7),
       Data_out(6)=> Port6_out(7),
       Data_out(7)=> Port7_out(7),
       Data_out(8)=> Port8_out(7),
       Data_out(9)=> Port9_out(7),
       Data_out(10)=> Port10_out(7),
       Data_out(11)=> Port11_out(7),
       Data_out(12)=> Port12_out(7),
       Data_out(13)=> Port13_out(7),
       Data_out(14)=> Port14_out(7),
       Data_out(15)=> Port15_out(7),
       Data_out(16)=> Port16_out(7)

           );
-- crossbit du pulse_out 16 ports 

   Pulse_out_Crossbit16: Crossbit 
      GENERIC MAP(number_of_ports => 16)
      PORT MAP(

      reset => reset,
 	 	 clk=>clk,
 	 	 Control => Ctrl_buf,
       Data_In(1) => Port1_pulse_in,
       Data_In(2) => Port2_pulse_in,
       Data_In(3) => Port3_pulse_in,
       Data_In(4) => Port4_pulse_in,
       Data_In(5) => Port5_pulse_in,
       Data_In(6) => Port6_pulse_in,
       Data_In(7) => Port7_pulse_in,
       Data_In(8) => Port8_pulse_in,
       Data_In(9) => Port9_pulse_in,
       Data_In(10) => Port10_pulse_in,
       Data_In(11) => Port11_pulse_in,
       Data_In(12) => Port12_pulse_in,
       Data_In(13) => Port13_pulse_in,
       Data_In(14) => Port14_pulse_in,
       Data_In(15) => Port15_pulse_in,
       Data_In(16) => Port16_pulse_in,
       Data_out(1) => Port1_pulse_out,
       Data_out(2) => Port2_pulse_out,
       Data_out(3) => Port3_pulse_out,
       Data_out(4) => Port4_pulse_out,
       Data_out(5) => Port5_pulse_out,
       Data_out(6) => Port6_pulse_out,
       Data_out(7) => Port7_pulse_out,
       Data_out(8) => Port8_pulse_out,
       Data_out(9) => Port9_pulse_out,
       Data_out(10) => Port10_pulse_out,
       Data_out(11) => Port11_pulse_out,
       Data_out(12) => Port12_pulse_out,
       Data_out(13) => Port13_pulse_out,
       Data_out(14) => Port14_pulse_out,
       Data_out(15) => Port15_pulse_out,
       Data_out(16) => Port16_pulse_out 

           );
end generate crossbar16x16;

end Behavioral;

