----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL/GAMOM Roland CHristian
-- 
-- Create Date:    03:47:50 04/24/2011 
-- Design Name: 
-- Module Name:    INPUT_PORT_MODULE - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- Module de gestion des entres des ports du switch crossbar
-- il supose qu'une donne est empile  chaque cycle d'horloge
-- Dependencies: 
-- FIFO_64_FWFT.vhd
-- RAM_64.vhd
-- Revision: 1
-- remplacement du fifo ordinaire par un fifo fwft
-- Revision 1.01 - File Created
-- Additional Comments: 
-- modifi le 14/05/20011  pour eviter une criture multiple dans le FIFO de sortie
-- si le FIFO d'entre vient a se vider pendant le transfert d'un packet
-- le machine a tat on t re modeliser et sont maintenant du type FSMD
-- remodliation pour plus de vitesse
--inclusion du signal priority rotation pour eviter la perte du grant pendant une transmission
--02-08-2012 :Prise en compte du signal Port_Granted dans un process
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
USE ieee.numeric_std.ALL;
use work.Coretypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;


entity INPUT_PORT_MODULE is
    generic(number_of_ports : positive := 4;
	 
	 Port_num: natural:=1);  -- port_num est l'id du port
    Port ( data_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           data_in_en : in  STD_LOGIC; -- signaler la prsence des donnes en entre
			  cmd_in_en :in STD_LOGIC;    --permet d'identifier les donnes qui sont dans le tampon
           reset : in  STD_LOGIC;
			  clk   : in  STD_LOGIC;
			  request : out  STD_LOGIC_VECTOR (number_of_ports downto 1); --demande de canal de transmission
           grant : in  STD_LOGIC_VECTOR (number_of_ports  downto 1);	 -- autorisation de transmission		  
           fifo_full : out  STD_LOGIC; -- signaler que les donnes ne peuvent plus tre acceptes en entre
			  fifo_empty : out  STD_LOGIC; -- le tampon d'entre est vide
			  priority_rotation : out std_logic;  -- reserver le canal de transmission
           data_out : out  STD_LOGIC_VECTOR (Word-1 downto 0); --donnes vers le rseau crossbar
			  data_out_pulse : out std_logic); -- permet de ...
       
end INPUT_PORT_MODULE;

architecture Behavioral of INPUT_PORT_MODULE is

-- declaration du fifo 64 octet utilis pour chaque port
component FIFO_256_FWFT
	port (
	clk: IN std_logic;
	din: IN std_logic_VECTOR(Word-1 downto 0);
	rd_en: IN std_logic;
	srst: IN std_logic;
	wr_en: IN std_logic;
	dout: OUT std_logic_VECTOR(Word-1 downto 0);
	empty: OUT std_logic;
	full: OUT std_logic);
end component;

--definition du type etat pour les fsm
type fsm_states is (state0, CmdOn, WaitGrant, ReqPort, state1, state2,strecover,stpulse,stateErr, state3);-- definition du type etat pour le codage des etats des fsm
type fsm_states2 is(cmdstart,cmdwait,cmdread,cmdSetDest,cmdSetCount,cmdSetId,cmdpulse,CmdEnd);
signal pop_state : fsm_states;
signal cmdstate : fsm_states2;
signal cmd_exec : std_logic:='0';  --indique que le port est en train d'excuter une commande
signal dat_exec :std_logic:='0'; -- indique le port est en train de transfrer des donnes
signal dat_Err :std_logic:='0'; -- signal une erreur pendant l'excution 
signal wrok,readOk,CmdReadOk : std_logic:='0'; --indique s'il est possible de lire les donnes
-- signaux utiliss dans les fsm
signal request_decoder,req_grant : STD_LOGIC_VECTOR(number_of_ports  downto 1);
signal request_decoder_en : std_logic;
signal request_latch : STD_LOGIC_VECTOR(4 downto 1):=(others=>'0');   -- pourquoi pas 3 downto 0 ?
signal request_latch_en : std_logic;
signal pipeline_latch : std_logic_vector(Word-1 downto 0);
signal pipeline_latch_en : std_logic;
signal request_word :  std_logic_vector(5 downto 1);
signal port_granted : std_logic;
signal rd_en_signal : std_logic;
--signaux utiliss dans la MAE de gestion des commandes
signal cmd_request_latch_en :std_logic;
signal cmd_pipeline_latch_en :std_logic;
signal cmd_fifo_read_signal :std_logic;
signal cmd_request_decoder_en :std_logic;
signal cmd_data_out_pulse :std_logic;
signal cmd_priority_rotation :std_logic;
--signaux utiliss dans la MAE de transfert des donnes
signal dat_request_latch_en :std_logic;
signal dat_pipeline_latch_en :std_logic;
signal dat_fifo_read_signal :std_logic;
signal dat_request_decoder_en :std_logic;
signal dat_data_out_pulse :std_logic;
signal dat_priority_rotation :std_logic;
-- signaux utiliss pour les connections entre composants
signal clk_signal : std_logic;
signal reset_signal : std_logic;
signal fifo_empty_signal : std_logic;
signal fifo_read_signal : std_logic;
signal fifo_out_signal,cmd_data_signal : std_logic_vector(Word-1 downto 0);
signal push_dout : std_logic_vector(Word-1 downto 0);
signal empty_latch : std_logic ;
signal PORT_ID :std_logic_vector(Word-1 downto 0):=STD_LOGIC_VECTOR(to_unsigned(number_of_ports-1,4))& STD_LOGIC_VECTOR(to_unsigned(port_num-1,4));
-- signaux du compteur de donnes
signal data_counter : std_logic_vector(Word-1 downto 0);

begin
-- instantiation du FIFO_256
 INPUT_PORT_FIFO : FIFO_256_FWFT
		port map (
			clk => clk_signal,
			din => data_in,
			rd_en => fifo_read_signal,
			srst => reset_signal,
			wr_en => data_in_en,
			dout => fifo_out_signal,
			empty => fifo_empty_signal,
			full => fifo_full);
-- connections avec les ports de l'entit

data_out <= pipeline_latch ;--when cmd_exec='0' else cmd_data_signal;
fifo_empty <= empty_latch;
reset_signal <= reset;
grant_proc:process(req_grant)
begin
--if rising_edge(clk) then
--	if unsigned(grant)> 0 then
	if unsigned(req_grant) > 0 then
		port_granted <= '1';   		--il faut veiller  ce que ce port soit vraiment autoris
	else 
		Port_granted<='0'; 	 		--ceci prsuppose que la valeur qu'il reoit est forcment la sienne
	end if;
--end if;		
end process;			 
rd_en_signal <= not(fifo_empty_signal);--not(empty_latch) ;
request <= request_decoder;
reg_grant:process (request_decoder,grant)
begin
req_grant<=request_decoder and grant;
end process reg_grant;
request_word <=  request_latch & request_decoder_en;
clk_signal <= clk;



WITH cmd_exec SELECT
    request_latch_en <=  dat_request_latch_en   WHEN '0',
								  cmd_request_latch_en  WHEN others;
								  
WITH cmd_exec SELECT
		pipeline_latch_en  <=  dat_pipeline_latch_en   WHEN '0',
								    cmd_pipeline_latch_en  WHEN others;
								      
WITH cmd_exec SELECT    
		fifo_read_signal <=dat_fifo_read_signal WHEN '0', 
		
								cmd_fifo_read_signal WHEN others;
WITH cmd_exec SELECT
		request_decoder_en <=dat_request_decoder_en WHEN '0',
									cmd_request_decoder_en WHEN others; 
WITH cmd_exec SELECT
		data_out_pulse <=dat_data_out_pulse WHEN '0',
							  cmd_data_out_pulse WHEN others;
WITH cmd_exec SELECT
		priority_rotation<=dat_priority_rotation WHEN '0',
								 cmd_priority_rotation WHEN others;


--processus permettant de latcher le signal empty
-- evite une perte de donnes en cas d'arret au cours d'une transmission
empty_latch_process : process(clk)
begin
 if rising_edge(clk) then
	if reset_signal = '1' then
	    empty_latch <= '1';
	else
	 empty_latch <= fifo_empty_signal;
   end if;
 end if;	

end process;
-- decodeur de requete en fonction de l'adresse destination
-- le circuit genere depend du parametre generique nombre de ports
-- switch 2 ports
switch2x2 : if number_of_ports = 2 generate

with request_word select
      request_decoder <="01" when "00001",
                        "10" when "00011",
                        "00" when others;

end generate switch2x2;


-- switch 3 ports
switch3x3 : if number_of_ports = 3 generate

with request_word select
      request_decoder <="001" when "00001",
                        "010" when "00011",
                        "100" when "00101",
                        "000" when others;

end generate switch3x3;


-- switch 4 ports
switch4x4 : if number_of_ports = 4 generate

with request_word select
      request_decoder <="0001" when "00001",
                        "0010" when "00011",
                        "0100" when "00101",
                        "1000" when "00111",
                        "0000" when others;

end generate switch4x4;


-- switch 5 ports
switch5x5 : if number_of_ports = 5 generate

with request_word select
      request_decoder <="00001" when "00001",
                        "00010" when "00011",
                        "00100" when "00101",
                        "01000" when "00111",
                        "10000" when "01001",
                        "00000" when others;

end generate switch5x5;


-- switch 6 ports
switch6x6 : if number_of_ports = 6 generate

with request_word select
      request_decoder <="000001" when "00001",
                        "000010" when "00011",
                        "000100" when "00101",
                        "001000" when "00111",
                        "010000" when "01001",
                        "100000" when "01011",
                        "000000" when others;

end generate switch6x6;


-- switch 7 ports
switch7x7 : if number_of_ports = 7 generate

with request_word select
      request_decoder <="0000001" when "00001",
                        "0000010" when "00011",
                        "0000100" when "00101",
                        "0001000" when "00111",
                        "0010000" when "01001",
                        "0100000" when "01011",
                        "1000000" when "01101",
                        "0000000" when others;

end generate switch7x7;


-- switch 8 ports
switch8x8 : if number_of_ports = 8 generate

with request_word select
      request_decoder <="00000001" when "00001",
                        "00000010" when "00011",
                        "00000100" when "00101",
                        "00001000" when "00111",
                        "00010000" when "01001",
                        "00100000" when "01011",
                        "01000000" when "01101",
                        "10000000" when "01111",
                        "00000000" when others;

end generate switch8x8;


-- switch 9 ports
switch9x9 : if number_of_ports = 9 generate

with request_word select
      request_decoder <="000000001" when "00001",
                        "000000010" when "00011",
                        "000000100" when "00101",
                        "000001000" when "00111",
                        "000010000" when "01001",
                        "000100000" when "01011",
                        "001000000" when "01101",
                        "010000000" when "01111",
                        "100000000" when "10001",
                        "000000000" when others;

end generate switch9x9;


-- switch 10 ports
switch10x10 : if number_of_ports = 10 generate

with request_word select
      request_decoder <="0000000001" when "00001",
                        "0000000010" when "00011",
                        "0000000100" when "00101",
                        "0000001000" when "00111",
                        "0000010000" when "01001",
                        "0000100000" when "01011",
                        "0001000000" when "01101",
                        "0010000000" when "01111",
                        "0100000000" when "10001",
                        "1000000000" when "10011",
                        "0000000000" when others;

end generate switch10x10;


-- switch 11 ports
switch11x11 : if number_of_ports = 11 generate

with request_word select
      request_decoder <="00000000001" when "00001",
                        "00000000010" when "00011",
                        "00000000100" when "00101",
                        "00000001000" when "00111",
                        "00000010000" when "01001",
                        "00000100000" when "01011",
                        "00001000000" when "01101",
                        "00010000000" when "01111",
                        "00100000000" when "10001",
                        "01000000000" when "10011",
                        "10000000000" when "10101",
                        "00000000000" when others;

end generate switch11x11;


-- switch 12 ports
switch12x12 : if number_of_ports = 12 generate

with request_word select
      request_decoder <="000000000001" when "00001",
                        "000000000010" when "00011",
                        "000000000100" when "00101",
                        "000000001000" when "00111",
                        "000000010000" when "01001",
                        "000000100000" when "01011",
                        "000001000000" when "01101",
                        "000010000000" when "01111",
                        "000100000000" when "10001",
                        "001000000000" when "10011",
                        "010000000000" when "10101",
                        "100000000000" when "10111",
                        "000000000000" when others;

end generate switch12x12;


-- switch 13 ports
switch13x13 : if number_of_ports = 13 generate

with request_word select
      request_decoder <="0000000000001" when "00001",
                        "0000000000010" when "00011",
                        "0000000000100" when "00101",
                        "0000000001000" when "00111",
                        "0000000010000" when "01001",
                        "0000000100000" when "01011",
                        "0000001000000" when "01101",
                        "0000010000000" when "01111",
                        "0000100000000" when "10001",
                        "0001000000000" when "10011",
                        "0010000000000" when "10101",
                        "0100000000000" when "10111",
                        "1000000000000" when "11001",
                        "0000000000000" when others;

end generate switch13x13;


-- switch 14 ports
switch14x14 : if number_of_ports = 14 generate

with request_word select
      request_decoder <="00000000000001" when "00001",
                        "00000000000010" when "00011",
                        "00000000000100" when "00101",
                        "00000000001000" when "00111",
                        "00000000010000" when "01001",
                        "00000000100000" when "01011",
                        "00000001000000" when "01101",
                        "00000010000000" when "01111",
                        "00000100000000" when "10001",
                        "00001000000000" when "10011",
                        "00010000000000" when "10101",
                        "00100000000000" when "10111",
                        "01000000000000" when "11001",
                        "10000000000000" when "11011",
                        "00000000000000" when others;

end generate switch14x14;


-- switch 15 ports
switch15x15 : if number_of_ports = 15 generate

with request_word select
      request_decoder <="000000000000001" when "00001",
                        "000000000000010" when "00011",
                        "000000000000100" when "00101",
                        "000000000001000" when "00111",
                        "000000000010000" when "01001",
                        "000000000100000" when "01011",
                        "000000001000000" when "01101",
                        "000000010000000" when "01111",
                        "000000100000000" when "10001",
                        "000001000000000" when "10011",
                        "000010000000000" when "10101",
                        "000100000000000" when "10111",
                        "001000000000000" when "11001",
                        "010000000000000" when "11011",
                        "100000000000000" when "11101",
                        "000000000000000" when others;

end generate switch15x15;


-- switch 16 ports
switch16x16 : if number_of_ports = 16 generate

with request_word select
      request_decoder <="0000000000000001" when "00001",
                        "0000000000000010" when "00011",
                        "0000000000000100" when "00101",
                        "0000000000001000" when "00111",
                        "0000000000010000" when "01001",
                        "0000000000100000" when "01011",
                        "0000000001000000" when "01101",
                        "0000000010000000" when "01111",
                        "0000000100000000" when "10001",
                        "0000001000000000" when "10011",
                        "0000010000000000" when "10101",
                        "0000100000000000" when "10111",
                        "0001000000000000" when "11001",
                        "0010000000000000" when "11011",
                        "0100000000000000" when "11101",
                        "1000000000000000" when "11111",
                        "0000000000000000" when others;

end generate switch16x16;									
--latch du fifo de sortie ??
pipeline_latch_process : process(clk)
begin
	if rising_edge(clk) then 
	  if reset_signal = '1' then 
	   pipeline_latch <= (others => '0');
		 elsif pipeline_latch_en = '1' and cmd_exec='0' then
		  pipeline_latch <= push_dout;
		  elsif pipeline_latch_en = '1' and cmd_exec='1' then
		  pipeline_latch <= cmd_data_signal;
	  end if;
	end if;
end process;

--latch qui memorise l'adresse de destination du packet

request_latch_process : process(clk)
begin
	if rising_edge(clk) then
		if reset_signal = '1' then
		  request_latch <= (others => '0');
		  elsif request_latch_en = '1' and cmd_in_en='0' then  --si la lecture de la destination est autorise
		  request_latch <=fifo_out_signal(3 downto 0); --fifo_out_signal(3) & fifo_out_signal(2) & fifo_out_signal(1) & fifo_out_signal(0);
		assert (unsigned(fifo_out_signal(3 downto 0))<number_of_ports) 
	report "Input_port_module n " & integer'image(port_num) & " Le port sollicit n'existe pas le NoC va tre bloqu !"
	severity failure;
		  elsif cmd_in_en='1' and request_latch_en='1' then  --c'est une commande le port de dest est le mme que le port d'entre
		   request_latch<=Port_ID(3 downto 0);  --car les ports commencent  0
		end if;
	
	end if;
end process;

-- machine  etat de mealy qui depile les donnees dans le fifo
--
-- processus determinant l'etat futur
pop_fsm_nsl : process(clk)
begin 
	if rising_edge(clk) then 
	 if reset_signal = '1' then
		pop_state <= state0;
		data_counter <= (others => '0');
	  elsif cmd_exec='0' then  --il ne faut pas excuter cette MAE
										-- lorsque l'autre est en cours 
	    wrok<='0';
		  case pop_state is
			when state0 => if cmd_in_en='0'  then --il ne faut pas excuter les deux MAE ...
									if empty_latch  ='0' then -- pile pas vide on doit dpiler									
										pop_state <= WaitGrant;
									end if;
								else
									pop_state <= CmdOn;
								end if;
			when CmdOn => if empty_latch='1' and cmd_in_en='0' then
								pop_state <= state0;
								elsif empty_latch='0' and cmd_in_en='1' then
								pop_state <= CmdOn;
								elsif empty_latch='1' and cmd_in_en='1' then
								pop_state <= state0;
								else -- empty_latch='0' and cmd_in_en='0'
								pop_state <= WaitGrant;
								end if;
								
			when WaitGrant => if port_granted = '1' then
										--
										pop_state <= ReqPort;
								end if;					
								
			when ReqPort => --if port_granted = '1' then
										--
										pop_state <= state1;
										
								--end if;
		
			when state1 => if port_granted ='1' then --lecture de la longueur des donnes
										data_counter <= fifo_out_signal;
										if unsigned(fifo_out_signal)<=3 then 
												ReadOk<='1';
										else
												readOk<='1';
										end if;
										pop_state <= state2;
										wrok<='1';
										else
										  wrok<='0';
							      end if;
										
			when state2 => if port_granted='1' then 
			               wrok<='1';
										if fifo_empty_signal ='0'  then
										  if rd_en_signal ='1' and unsigned(data_counter)<= 3 then
											data_counter <= data_counter - 1;
											pop_state <= stpulse;
											ReadOk<='1';
										elsif rd_en_signal ='1' then
										  data_counter <= data_counter - 1;
										  pop_state <= state2;
										  ReadOk<='1';
										else --fifo_empty_signal='1' fin prmature de la lecture
											ReadOk<='0';
											wrok<='0';
											--pop_state<=stateErr;
											--data_counter<=(others => '0');
										end if;
										else
										 pop_state<=strecover;
										 data_counter <= data_counter + 1;
										 report "Input_port_module : Le fifo d'entre du port " & integer'image(to_integer(unsigned(Port_id(3 downto 0))+1)) & " est  vide !!!";
										 wrok<='0';
										 readok<='0'; 
										 end if;
									else
										wrOk<='0';
										readok<='0';
										report "Input_port_module : Le fifo de rception du port " & integer'image(to_integer(unsigned(request_latch)+1)) & " est probablement plein !!!";
										pop_state<=strecover;
										data_counter <= data_counter + 1;
									end if;
			when strecover => if fifo_empty_signal='0' and port_granted='1' then
			             pop_state<=state2;
			             readok<='0';
			             wrok<='0';
			             else
			              readok<='0';
			              wrok<='0'; 
			             end if;
			             
			            
			when stpulse =>	if port_granted='1' then 
											pop_state <= state3;		--pousser la dernire donne dehors		
											data_counter <= data_counter - 1;
											wrok<='1';
									end if;
			                 wrok<='0';
			when state3 => 	wrok<='0';
										data_counter <= data_counter - 1;
										pop_state <= state0;
			when stateErr => wrok<='0';	 
										data_counter <= data_counter;
										pop_state <= stateErr;
										report "Error in the NoC when sending data "	;											
			when others => pop_state <= state0;
			               wrok<='0';
		   end case;
	 end if;
	end if;
end process;

-- actions associes  chaque etat de la fsm de mealy
pop_fsm_action : process(pop_state, PORT_ID,fifo_out_signal,empty_latch, rd_en_signal,readok,wrok, port_granted )
  begin   
-- code fonctionnel	
	case pop_state is
		when state0 =>    dat_request_latch_en <= '0';  
								dat_pipeline_latch_en <= '0';
								dat_fifo_read_signal <='0';
								dat_request_decoder_en <= '0';
								dat_data_out_pulse <= '0';
								dat_priority_rotation <= '1';
								dat_exec<='0';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
								
		when CmdOn =>		dat_request_latch_en <= '0';  
								dat_pipeline_latch_en <= '0';
								dat_fifo_read_signal <='0';
								dat_request_decoder_en <= '0';
								dat_data_out_pulse <= '0';
								dat_priority_rotation <= '1';
								dat_exec<='0';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
		when WaitGrant =>	
								dat_request_latch_en <='1'; --autoriser l'identification du port de destination
								dat_pipeline_latch_en <= '0'; --pour le transmettre  travers le rseau
								dat_fifo_read_signal <= '0';
								dat_request_decoder_en <= '1';          --autoriser le decodeur activer le dernier bit de request
								dat_data_out_pulse <= '0';     --transmettre le signal pour le dernier mot
								dat_priority_rotation <= Port_granted; --ds qu'on a la priorit on la garde
								dat_exec<='1';
								dat_Err<='0';
								push_dout<=fifo_out_signal(7 downto 4) & PORT_ID(3 downto 0);
		when ReqPort =>	
								dat_request_latch_en <='1'; --autoriser l'identification du port de destination
								dat_pipeline_latch_en <= '1'; --pour le transmettre  travers le rseau
								dat_fifo_read_signal <= '1';
								dat_request_decoder_en <= '1';          --autoriser le decodeur activer le dernier bit de request
								dat_data_out_pulse <= '0';     --transmettre le signal pour le dernier mot
								dat_priority_rotation <= '0';
								dat_exec<='1';
								dat_Err<='0';
								push_dout<=fifo_out_signal(7 downto 4) & PORT_ID(3 downto 0);
							
		when state1 =>    dat_request_latch_en <= '0';
								dat_pipeline_latch_en <= rd_en_signal and port_granted;   
								dat_fifo_read_signal <= rd_en_signal and port_granted;
								dat_request_decoder_en <= '1';
								dat_data_out_pulse <= port_granted;
								dat_priority_rotation <= '0';
								dat_exec<='1';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
								
	  when state2 |strecover =>    dat_request_latch_en <= '0';
								dat_pipeline_latch_en <= port_granted and wrok and not(fifo_empty_signal);  --autoriser la lecture du fifo en sortie
								dat_fifo_read_signal <= port_granted and readok;   
								dat_request_decoder_en <= '1';          --autoriser le decodeur activer le dernier bit de request
								dat_data_out_pulse <= port_granted and wrOk and not(fifo_empty_signal);
								dat_priority_rotation <= '0';
								dat_exec<='1';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
								
	  when stpulse =>    dat_request_latch_en <= '0'; --pousser la dernire donne 
								dat_pipeline_latch_en <= '0';  --autoriser la lecture du fifo en sortie
								dat_fifo_read_signal <='0';   
								dat_request_decoder_en <= '1';          --autoriser le decodeur activer le dernier bit de request
								dat_data_out_pulse <= '1';  -- pousser le dernier mot
								dat_priority_rotation <= '0';
								dat_exec<='1';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
								
		when state3 =>    dat_request_latch_en <= '0';
								dat_pipeline_latch_en <= '0';
								dat_priority_rotation <= '1';    -- librer la priorit
								dat_fifo_read_signal <= '0';
								dat_request_decoder_en <= '0';   --librer le dcodeur
								dat_data_out_pulse <= '0';
								dat_exec<='0';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
		when stateErr =>    dat_request_latch_en <= '0';
								dat_pipeline_latch_en <= '0';
								dat_priority_rotation <= '1';    -- librer la priorit
								dat_fifo_read_signal <= '0';
								dat_request_decoder_en <= '0';   --librer le dcodeur
								dat_data_out_pulse <= '0';
								dat_exec<='1';
								dat_Err<='1';
								push_dout<=fifo_out_signal;
		when others =>    dat_request_latch_en <= '0';
								dat_pipeline_latch_en <= '0';
								dat_priority_rotation <= '1';
								dat_fifo_read_signal <= '0';
								dat_request_decoder_en <= '0';
								dat_data_out_pulse <= '0';
								dat_exec<='0';
								dat_Err<='0';
								push_dout<=fifo_out_signal;
										
		end case;
 end process; 
 -- traitement des commandes reues par le switch
fsm_cmd:process(clk,cmd_in_en)
variable timeout : natural:=0;
variable cmdcode : natural range 0 to 255;
begin
if rising_edge(clk) then
   if reset_signal = '1' then
	   cmdstate<=cmdstart;
	else -- il ne faut pas traiter les cmdes et les donnes en mme temps 
	case cmdstate is
	
	   when cmdstart  =>
				if cmd_in_en='1' and dat_exec='0' and empty_latch='0' then 
				cmdstate<=cmdread;
				end if;
				cmdReadOk<='0';
		when cmdwait => if port_granted='1' then  -- demande du port de sortie
								
									cmdstate<=cmdsetdest;
							elsif cmd_in_en='1' then
								cmdstate<=cmdwait;
							else 
								cmdstate<=cmdstart;
							end if;
							cmdReadOk<='0';
		when cmdread =>
--				if port_granted ='1'then -- ne pas modifier l'tat des priorits si on ne l'avait pas
					cmdcode:= to_integer(unsigned(fifo_out_signal));
					if cmdcode=1 then --code de getportid
							cmdstate<=cmdwait;
							cmdReadOk<='1';
					else
						        --ne pas prendre le code inconnu en compte
							cmdstate<=cmdend; -- la commande n'a pas t reconnu
						
						cmdReadOk<='0';
					end if;
--				end if;
		when cmdsetdest =>
				if port_granted='1' then
					cmdstate<=cmdsetcount;
				end if;
				cmdReadOk<='0';
		when cmdsetcount =>
				if port_granted='1' then
					cmdstate<=cmdsetID;
				else
					cmdstate<=cmdsetdest;
				end if;
				cmdReadOk<='0';
		when cmdsetID=>
			if port_granted='1' then
			cmdstate <=cmdpulse;
			end if;
			cmdReadOk<='0';
		when cmdpulse =>
			if port_granted='1' then
			cmdstate <=cmdEnd;
			end if;
			cmdReadOk<='0';
		when cmdend  =>
			if cmd_in_en='0' then --viter l'excution en boucle
				cmdstate<=cmdstart; 
			end if;
			cmdReadOk<='0';	
	  
	end case;
  	end if;		
end if;
end process fsm_cmd;

cmdaffect:process (cmdstate,fifo_empty_signal, port_granted, PORT_ID)
begin
case cmdstate is

	when cmdstart =>
						cmd_exec<='0';
						cmd_pipeline_latch_en <='0';
						cmd_priority_rotation <= '1';
						cmd_request_latch_en<='0';
						cmd_fifo_read_signal <= '0';
						cmd_request_decoder_en <= '0';
						cmd_data_signal<=(others=>'0');
						cmd_data_out_pulse <= '0';

	when cmdread =>
						cmd_exec<='1';
						cmd_pipeline_latch_en <= '0';
						cmd_fifo_read_signal <= '1'; -- vider le tampon d'entre
						cmd_request_latch_en<='1';    --mmoriser l'adresse de destination
						cmd_request_decoder_en <= '1';                   --demande d'mission
						cmd_data_out_pulse <= '0';
						cmd_priority_rotation <= '1';                    --sans priorit
						cmd_data_signal<=Port_ID;  
		when cmdwait =>
						cmd_exec<='1';
						cmd_pipeline_latch_en <='0';
						cmd_fifo_read_signal <= '0';
						cmd_request_latch_en<='1';
						cmd_priority_rotation <= '0';    --avec priorit
						cmd_request_decoder_en <= '1';   --demande d'mission
						cmd_data_signal<=Port_ID;
						cmd_data_out_pulse <= '0';					
	when cmdsetdest  =>
						--cmd_request_decoder_en <= '1';
						cmd_exec<='1';
						cmd_pipeline_latch_en <='1'; --empiler dans le tampon de sortie la donne
						cmd_fifo_read_signal <='0';
						cmd_request_latch_en<='0';
						cmd_request_decoder_en <= '1';          --autoriser le decodeur  activer le dernier bit de request
						cmd_data_out_pulse <= '0';
						cmd_priority_rotation <= '0';
						cmd_data_signal<=Port_ID;    -- le numro du port et le nombre total des ports est envoy
	when cmdsetcount =>
								 
						cmd_exec<='1';   
						cmd_pipeline_latch_en <='1'; -- empiler dans le tampon de sortie les donnes
						cmd_fifo_read_signal <='0';
						cmd_request_latch_en<='0';  --enregistrer l'adresse de destination
						cmd_request_decoder_en <= '1';          --autoriser le decodeur activer le dernier bit de request
						cmd_data_out_pulse <= port_granted;
						cmd_priority_rotation <= '0';
						cmd_data_signal<=STD_LOGIC_VECTOR(to_unsigned(3,8));					
	when cmdSetId =>
						--cmd_request_decoder_en <= '1';
						cmd_exec<='1';
						cmd_pipeline_latch_en <='1';
						cmd_fifo_read_signal <='0';
						cmd_request_latch_en<='0';			--enregistrer l'adresse de destination
						cmd_request_decoder_en <= '1';          --autoriser le decodeur  activer le dernier bit de request
						cmd_data_out_pulse <= port_granted;
						cmd_priority_rotation <= '0';
						cmd_data_signal<=Port_ID;    -- le numro du port et le nombre total des ports est envoy
											
	when cmdpulse =>	cmd_exec<='1';
						cmd_pipeline_latch_en <='0';
						cmd_fifo_read_signal <='0';
						cmd_request_latch_en<='0';
						cmd_request_decoder_en <= '1';          --autoriser le decodeur activer le dernier bit de request
						cmd_data_out_pulse <= '1';--port_granted;     --s'assurer que la dernire donne est bien lue
						cmd_priority_rotation <= '0';
								--cmd_data_signal<=Port_ID ;
						cmd_data_signal<=Port_ID; 
						
	when cmdend =>
								cmd_exec<='0';
								cmd_request_latch_en <= '0';
								cmd_pipeline_latch_en <= '0';
								cmd_fifo_read_signal <= '0';
								cmd_request_latch_en<='0';
								cmd_request_decoder_en <= '0';
								cmd_data_out_pulse <= '0';
								cmd_priority_rotation <= '1';
								cmd_data_signal<=(others=>'0');
								
								
end case ;
end process cmdaffect;

end Behavioral;


