----------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM NGOUNOU ROland Christian
-- 
-- Create Date:    12:49:02 02/02/2012 
-- Design Name: 
-- Module Name:    Portdata - arch_portdata 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use ieee.numeric_std.all;
--USE ieee.std_logic_arith.all;


entity Portdata is
generic (N:Natural:=8);
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           wr_en : in  STD_LOGIC;
           rd_en : in  STD_LOGIC;
           datain : in  STD_LOGIC_VECTOR (N-1 downto 0);
           dataout : out  STD_LOGIC_VECTOR (N-1 downto 0);
           address : in  STD_LOGIC_VECTOR (3 downto 0));
end Portdata;

architecture arch_portdata of Portdata is

Type Ram_type is array (0 to 3) of std_logic_vector (N-1 downto 0);
constant zero : integer :=0;
constant Zero_log:STD_LOGIC_VECTOR:=STD_LOGIC_VECTOR(to_unsigned(zero,N));
constant portid:STD_LOGIC_VECTOR:="00000001";
signal RAM : Ram_type;

constant max_address : natural:=15;
signal address_counter : natural := 0;
begin

dataout <= RAM(address_counter);
process (clk)
  begin
     if rising_edge(clk) then
        if reset = '1' then
            address_counter <= 0;
				for address_counter in 1 to max_address 			--la mmoire d'adresse 0 contient 
				loop															-- l'ID du port
					RAM(address_counter)<=(others=>'0');
				end loop;
				RAM(0)<=portid;                                -- portid est une valeur fix par le gnrateur de port
        elsif rd_en='1' and wr_en='0' then 
		     
			  RAM(to_integer(unsigned(address)))<=datain;
		  
		  elsif rd_en='0' and wr_en='1' then
			 dataout <= RAM(to_integer(unsigned(address)));
			  
		  end if;
    end if;
  end process;
end arch_portdata;

