---------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    03:56:34 05/06/2011 
-- Design Name: 
-- Module Name:    Sheduler - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Module de l'ordonnanceur du switch crossbar
-- l'algorithme utilise est le DPA (diagonal propagation arbiter)
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use Work.Sheduler_package.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity Scheduler3_3 is
    Port ( Request : in  STD_LOGIC_VECTOR (9 downto 1);
		   Fifo_full : in STD_LOGIC_VECTOR (3 downto 1);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
            priority_rotation : in  STD_LOGIC_VECTOR (3 downto 1);
           port_grant : out  STD_LOGIC_VECTOR (9 downto 1));
end Scheduler3_3;

architecture Behavioral of Scheduler3_3 is
--Declaration du types
--tableau de signaux de connexion des cellules arbitres
TYPE C_Bar_Signal_Array IS ARRAY(5 downto 1) of STD_LOGIC_VECTOR(3 downto 1);
-- declaration du composant cellule d'arbitrage
Component Arbiter 
  PORT (P, Fifo_full,Request, West,North : in  STD_LOGIC;
        Grant,East,South : out  STD_LOGIC );
End Component;--Signaux de connexion des cellues
SIGNAL south_2_north :  C_Bar_Signal_Array; -- connexion south north 
SIGNAL east_2_west   :  C_Bar_Signal_Array; -- connexion east west 
SIGNAL Signal_mask      : C_Bar_Signal_Array;-- connexion des masques de priorit
SIGNAL Signal_grant     : C_Bar_Signal_Array;-- connexion des signaux de validation
SIGNAL Signal_priority  : STD_LOGIC_VECTOR (5 DOWNTO 1);--signal pour la connection des vecteur de priorit
SIGNAL High         : std_logic;--niveau pour les cellules des extremits nord et ouest 
 signal grant_latch : std_logic_vector(9 downto 1); 
 signal priority_rotation_en : std_logic; 
 signal Grant,req_grant :  std_logic_vector(9 downto 1);
 begin

--validation de la rotation de priorit lorsque aucun port n'emet 
 req_grant<=(request and grant_latch);
 priority_rotation_en <= '1' when unsigned(priority_rotation) = 7 else 	'0'; 
--latch servant qui memorise le signal grant pendant a transmission 
grant_latch_process : process(clk)
 begin 
  if rising_edge(clk) then 
   if reset = '1' then 
 		grant_latch <= (others => '0'); 
 	 elsif priority_rotation_en = '1' then 
	   grant_latch <= Grant; 
   end if; 
   end if; 
 end process; 
 port_grant <= grant_latch; 
 Grant(1)  <= Signal_grant(1)(1) or Signal_grant(4)(1); --  Grant(1,1)
Grant(2)  <= Signal_grant(2)(2) or Signal_grant(5)(2); --  Grant(1,2)
Grant(3)  <= Signal_grant(3)(3) ;                      --  Grant(1,3)
Grant(4)  <= Signal_grant(2)(1) or Signal_grant(5)(1); --  Grant(2,1)
Grant(5)  <= Signal_grant(3)(2) ;                      --  Grant(2,2)
Grant(6)  <= Signal_grant(1)(3) or Signal_grant(4)(3); --  Grant(2,3)
Grant(7)  <= Signal_grant(3)(1) ;                      --  Grant(3,1)
Grant(8)  <= Signal_grant(1)(2) or Signal_grant(4)(2); --  Grant(3,2)
Grant(9)  <= Signal_grant(2)(3) or Signal_grant(5)(3); --  Grant(3,3)
High <= '1';

----instantiations des cellules arbitres et interconnection

-------------------------- Diagonale n 1 


Arbiter_1_1 : Arbiter

PORT MAP (Request => Request(1), North => High, West => High, P => Signal_priority(5), Fifo_full => Fifo_full(1),  
South => south_2_north(1)(1), East => east_2_west(1)(1) , Grant => Signal_grant(1)(1)); 

Arbiter_1_2 : Arbiter

PORT MAP (Request => Request(8), North => High, West => High, P => Signal_priority(5), Fifo_full => Fifo_full(2),  
South => south_2_north(1)(2), East => east_2_west(1)(2) , Grant => Signal_grant(1)(2)); 

Arbiter_1_3 : Arbiter

PORT MAP (Request => Request(6), North => High, West => High, P => Signal_priority(5), Fifo_full => Fifo_full(3),  
South => south_2_north(1)(3), East => east_2_west(1)(3) , Grant => Signal_grant(1)(3)); 

-------------------------- Diagonale n 2 


Arbiter_2_1 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(1)(1), West => east_2_west(1)(3), P => Signal_priority(4), Fifo_full => Fifo_full(1),  
South => south_2_north(2)(1), East => east_2_west(2)(1) , Grant => Signal_grant(2)(1)); 

Arbiter_2_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(1)(2), West => east_2_west(1)(1), P => Signal_priority(4), Fifo_full => Fifo_full(2),  
South => south_2_north(2)(2), East => east_2_west(2)(2) , Grant => Signal_grant(2)(2)); 

Arbiter_2_3 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(1)(3), West => east_2_west(1)(2), P => Signal_priority(4), Fifo_full => Fifo_full(3),  
South => south_2_north(2)(3), East => east_2_west(2)(3) , Grant => Signal_grant(2)(3)); 

-------------------------- Diagonale n 3 


Arbiter_3_1 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(2)(1), West => east_2_west(2)(3), P => Signal_priority(3), Fifo_full => Fifo_full(1),  
South => south_2_north(3)(1), East => east_2_west(3)(1) , Grant => Signal_grant(3)(1)); 

Arbiter_3_2 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(2)(2), West => east_2_west(2)(1), P => Signal_priority(3), Fifo_full => Fifo_full(2),  
South => south_2_north(3)(2), East => east_2_west(3)(2) , Grant => Signal_grant(3)(2)); 

Arbiter_3_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(2)(3), West => east_2_west(2)(2), P => Signal_priority(3), Fifo_full => Fifo_full(3),  
South => south_2_north(3)(3), East => east_2_west(3)(3) , Grant => Signal_grant(3)(3)); 

-------------------------- Diagonale n 4 


Arbiter_4_1 : Arbiter

PORT MAP (Request => Request(1), North => south_2_north(3)(1), West => east_2_west(3)(3), P => Signal_priority(2), Fifo_full => Fifo_full(1),  
South => south_2_north(4)(1), East => east_2_west(4)(1) , Grant => Signal_grant(4)(1)); 

Arbiter_4_2 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(3)(2), West => east_2_west(3)(1), P => Signal_priority(2), Fifo_full => Fifo_full(2),  
South => south_2_north(4)(2), East => east_2_west(4)(2) , Grant => Signal_grant(4)(2)); 

Arbiter_4_3 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(3)(3), West => east_2_west(3)(2), P => Signal_priority(2), Fifo_full => Fifo_full(3),  
South => south_2_north(4)(3), East => east_2_west(4)(3) , Grant => Signal_grant(4)(3)); 

-------------------------- Diagonale n 5 


Arbiter_5_1 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(4)(1), West => east_2_west(4)(3), P => Signal_priority(1), Fifo_full => Fifo_full(1),  
South => south_2_north(5)(1), East => east_2_west(5)(1) , Grant => Signal_grant(5)(1)); 

Arbiter_5_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(4)(2), West => east_2_west(4)(1), P => Signal_priority(1), Fifo_full => Fifo_full(2),  
South => south_2_north(5)(2), East => east_2_west(5)(2) , Grant => Signal_grant(5)(2)); 

Arbiter_5_3 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(4)(3), West => east_2_west(4)(2), P => Signal_priority(1), Fifo_full => Fifo_full(3),  
South => south_2_north(5)(3), East => east_2_west(5)(3) , Grant => Signal_grant(5)(3)); 


--processus permettant de roter la priorit des diagonales  chaque front d'horloge
 -- rotation round robin
	 round_robin : process(clk)
	begin
		if rising_edge(clk) then
		 if reset ='1' then
		    Signal_priority <= "11100";
		  elsif priority_rotation_en = '1' then 
 		    case Signal_priority is
		       when "11100" => Signal_priority <= "01110";
		       when "01110" => Signal_priority <= "00111";
		       when "00111" => Signal_priority <= "11100";
		       when others    => Signal_priority <= "11100";
		  end case;
		 end if;
	     end if;
	 end process;

end Behavioral;

