
----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:29:48 04/18/2011 
-- Design Name: 
-- Module Name:    OUTPUT_PORT_MODULE - Behavioral_description 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:
-- cette version du module de sortie se limite  une instance du fifo ordinaire 
-- les donnes son emise en sortie  chaque cycle d'horloge
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity OUTPUT_PORT_MODULE is
    Port ( data_in : in  STD_LOGIC_VECTOR (7 downto 0);
           reset : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           wr_en : in  STD_LOGIC;
           data_out : out  STD_LOGIC_VECTOR (7 downto 0);
			  fifo_full : out std_logic;
			  data_avalaible : out std_logic;
			  rd_out_en : in  STD_LOGIC);
end OUTPUT_PORT_MODULE;

architecture Behavioral_description of OUTPUT_PORT_MODULE is
-- declaration du FIFO 64 octets
component FIFO_256_FWFT
	port (
	clk: IN std_logic;
	din: IN std_logic_VECTOR(7 downto 0);
	rd_en: IN std_logic;
	srst: IN std_logic;
	wr_en: IN std_logic;
	dout: OUT std_logic_VECTOR(7 downto 0);
	empty: OUT std_logic;
	full: OUT std_logic);
end component;
--definition du type etat pour les fsm
signal empty_signal : std_logic;	
begin
-- instantiation du FIFO_64
 OUTPUT_PORT_FIFO : FIFO_256_FWFT
		port map (
			clk => clk,
			din => data_in,
			rd_en => rd_out_en,
			srst => reset,
			wr_en => wr_en,
			dout => data_out,
			empty => empty_signal,
			full => fifo_full);
			
data_avalaible <= not empty_signal;

end Behavioral_description;

