----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    12:04:21 04/22/2013 
-- Design Name: 
-- Module Name:    HT_process - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
USE ieee.numeric_std.ALL;
library NocLib ;

use std.textio.all;
use NocLib.CoreTypes.all;
Library MPI_HCL;
use MPI_HCL.Packet_type.all;
use MPI_HCL.MPI_RMA.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity HT_dyn is
		generic (Task_id : natural:=0);
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  en : in std_logic; -- active la tche
           Interf_i : in  core_i; --signaux pour l'interface IO
			  Interf_o : out  core_o; --signaux pour l'interface IO
           mem_o : out typ_dpram_o; -- signaux pour l'accs  la mmoire
			  mem_i : in typ_dpram_i; -- signaux pour l'accs  la mmoire
			  ct_out : out unsigned(7 downto 0);
			  ht_state : out typ_mae;
			 PE_in : in STD_LOGIC_VECTOR (Word-1 downto 0); --port GPIO pour le PE
				PE_out : out STD_LOGIC_VECTOR (Word-1 downto 0) --port GPIO pour le PE
			  );
end HT_dyn;

architecture Behavioral of HT_dyn is
	  constant simres : time :=1 ps; --simulation resolution
		  constant realres : real :=1.0e-3; --ramener le temps en ns

  --type typ_mae is (start,Fillmem,NextFill,InitApp,GetRank,WInCreate,WinPost,WinStart,
  --putdata,getdata,getcmd,WinWait,WinCompleted,MpiSpawn,finalize,st_timeout);
	signal sram : typ_dpram;
	signal MyGroup:mpi_group;
	signal MyWin : mpi_win;
	signal MyRank :std_logic_vector(3 downto 0);
	signal intercomm,array_of_errcodes : natural;
	signal ct_state:natural:=0;
	signal compteur:natural:=4321;
signal Libr : Core_io;  --regroupe tous les signaux IO de la bibliothque
signal RunState : typ_mae;
signal load :  std_logic;
signal 		start1 :  std_logic;
signal 		loadval :  std_logic_vector(31 downto 0);          
signal 		outval :  std_logic_vector(31 downto 0);
signal 		zero :  std_logic;
COMPONENT IP_Timer
	PORT(
		clk : IN std_logic;
		reset : IN std_logic;
		upDn : IN std_logic;
		load : IN std_logic;
		start : IN std_logic;
		loadval : IN std_logic_vector(31 downto 0);          
		outval : OUT std_logic_vector(31 downto 0);
		zero : OUT std_logic
		);
	END COMPONENT;
begin
Inst_IP_Timer: IP_Timer PORT MAP(
		clk =>clk ,
		reset => reset,
		upDn => '0',
		load => load,
		start => start1,
		loadval => loadval,
		outval => outval,
		zero => zero
	);

--MAE du PE
--=======================================================================
-- Interf<=Libr;


 pPutGet:process(clk,reset,en)
 
	constant DATAPTR : natural :=256;
	variable nb_rma:natural range 0 to 15:=0;
	variable bfill,destrank,pid,mport : natural range 0 to 15;
	variable fsrc,ret : natural range 0 to 15:=0;
	variable timeout,ct,dlen,dcount : natural range 0 to 511;
	variable adrToset,SrcAdr,DestAdr : std_logic_vector(ADRLEN-1 downto 0);
	variable mywin : Mpi_win;
	variable command , argv , maxprocs , info , root : natural:=0; --variable pour le spawn 
	variable comm : natural :=0;  
	variable iack,spawn : std_logic:='0';
	variable  adresse,adresse_rd :natural range 0 to 65536;
	variable status_reg,config_reg,param :std_logic_vector(Word-1 downto 0):=(others=>'0');

	--=======================================================
	--variables pour la cration du fichier de rsultats
		-- synthesis translate_off 
		type char_file is file of character;
        file f: text;
        variable status :file_open_status ;
        variable char_count: integer range 0 to 65536 := 0;
		  variable str: string (1 to 79) ;
		  variable L: line; 
		  variable fopened: std_logic:='0';
		  
		 -- constant simres : time :=1 ps; --simulation resolution
		--  constant realres : real :=1.0e-3; --ramener le temps en ns
		  -- returns real value of time parameter using pure VHDL
	     function rt(t : time) return real is
	       begin
	           --if (simres=0) then
		        return real(t/1 ns) * realres;
		       -- else
		       --   return 0.0;
		       --  end if;
	     end;
		 -- synthesis translate_on
--======================================================
	begin
	--=== Partie combinatoire du process ===================================
			
	--=== Fin de la partie combinatoire du process ==========================	
		
		    
           
        --end loop;
        
	if (clk'event and clk='1') and en='1' then 
			
			
		if reset='1' then
					RunState<=start;
					bfill:=0;
					ct:=0;
					ct_state<=0;
					dcount:=0;
					sram<=init_dpram;
					Libr<=init_Core_io;
					spawn:='0';nb_rma:=0;
		else
			--==========================================================
			--affectation des entres sorties mmoires
			sram.i.data_out<=mem_I.data_out;
			mem_o.addr_wr<=sram.O.addr_wr;
			mem_o.addr_rd<=sram.O.addr_rd ; 
			mem_o.we<=sram.O.we;
			mem_o.ena<=sram.O.ena;
			mem_o.enb<=sram.O.enb;
			mem_o.data_in<=sram.O.data_in;
			--affectation des entres sorties MPI_HCL
			Interf_o.Instr_EN<=Libr.O.instr_en;
			Interf_o.Membusy<=Libr.O.MemBusy;
			Interf_o.Instruction<=Libr.O.Instruction;
			Libr.i.Instr_ack<=Interf_i.Instr_ack;
			Libr.i.InitOk<=Interf_i.InitOk;
			Libr.i.Hold_Req<=Interf_i.Hold_req;
			Libr.I.Spawned<=Interf_i.Spawned;
			--Libr.i.Hold_Ack<=Interf_i.Hold_Ack;
			Libr.i.RamSel<=Interf_i.RamSel;
			--ct_state<=ct; --pour dbogage
			--============================================================
			
			case  RunState is
			when start =>
				--Dcount<=0;
				if bfill=0 then -- si le nombre de bloc de mmoire remplis est vide
						--RunState<=InitApp;
						runstate<=fillmem;
				 end if;
				 --Ram_busy<='0';
				 Libr.O.MemBusy<='0';
				 Libr.O.Instr_En<='0';
				iack:='0';
				adresse:=10;--DATAPTR;
				
				adresse_rd:=0;
				timeout:=0;
				--dcount<=0;
				sram.O.we<='0';
					sram.O.ena<='0';
					sram.O.enb<='0';
			-- synthesis translate_off 
			if fopened='0' then 
			file_open(status,f, integer'image(Task_Id) & "test_file0.txt", APPEND_MODE);
        --while not endfile(c_file_handle) loop
			--end if;
		
				--write (l,string'("Ce fichier contient des resultats de la simulation ; ;" & " started at time ; " & time'image(now)));
				--report l.all;
           -- writeline (f, l) ;
				fopened:='1';
			end if;
			 -- synthesis translate_on
			 when Fillmem =>
	--				sram.O.we<='1';
--					sram.O.ena<='1';
--					sram.O.enb<='1';
--				if Libr.I.Ramsel='0' then 
--      					sram.O.addr_rd<=std_logic_vector(to_unsigned(adresse,ADRLEN));
--					sram.O.addr_wr<=std_logic_vector(to_unsigned(adresse,ADRLEN));
--					sram.O.data_in<=std_logic_vector(to_unsigned(dcount,8)); -- x"0f";
					Libr.O.Instr_En<='0';
					Writemem(ct,Libr,SRam,std_logic_vector(to_unsigned(adresse,ADRLEN)),std_logic_vector(to_unsigned(Task_id+1,8)));
					if ct=0 then
					dcount:=dcount+1;
					timeout:=0;
					if dcount=250 then
						 bfill:=bfill+1;
						 
						 if bfill=4 then
						  --RunState<=WinCreate;
						  Runstate<=InitApp;
						 else
							RunState<=nextfill;
						end if;
					else
						adresse:=adresse+1;
						--sram.O.addr_wr<=std_logic_vector(to_unsigned(adresse,ADRLEN));
						RunState<=Fillmem;
					end if;
					end if;
			--else -- attente de la libraion de la mmoire
--			        timeout:=timeout+1;
--					  if timeout=500 then
--						RunState<=st_timeout;
--					  end if;
							
--			end if;
		when nextfill  =>   --prpare le prochain bloc mmoire qui sera rempli
				adresse:=250*bfill+10;
				
				dcount:=0;
				ct:=0;
				RunState<=Fillmem;
				Libr.O.Instr_En<='0';
					sram.O.we<='1';
					sram.O.ena<='1';
					sram.O.enb<='0';
		when InitApp =>
				--code pour Init 
				dlen:=100;
				if ct=0 then
				-- synthesis translate_off 
				write (l,string'("Dlen; ;INIT1 " &  integer'image(Dlen)& "; " & image(MyRank) & "; started at ; " & real'image(rt(now))));
				
				report l.all;
            writeline (f, l) ;
				-- synthesis translate_on
				end if;
				pMPI_Init(ct,Libr,Clk,SRam);
				
				adresse:=to_integer(unsigned(sram.O.addr_wr));
				adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
				
				--if Libr.InitOk='1' then 
				if ct=0 then 
					RunState<=GetRank;
					-- synthesis translate_off 
					write (l,string'("Dlen;" & integer'image(Dlen) & ";INIT2 " &  integer'image(Dlen) & ";" & image(MyRank) & ";  ended at  ; " & real'image(rt(now))));
					report l.all;
					writeline (f, l) ;  
					-- synthesis translate_on
				end if;
				
		
		
		when GetRank =>
		if ct=0 then
				-- synthesis translate_off 
				write (l,string'("Dlen;" & integer'image(Dlen)& ";Rank1 " &  integer'image(Dlen) & "; ; started  ; " & real'image(rt(now))));
				report l.all;
            writeline (f, l) ;  
				-- synthesis translate_on
			end if;
			pMPI_Comm_rank(ct,Libr,sram,MPI_COMM_WORLD,MyRank);
			adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
			
			
			if ct=0 then
				RunState<=Fillmem;
				RunState<=Wincreate;
				-- synthesis translate_off
				write (l,string'("Dlen;"& integer'image(dlen) & ";Rank2 " &  integer'image(Dlen) & ";" & image(MyRank) & "; ended at  ; " & real'image(rt(now))));
				report l.all;
            writeline (f, l) ; 
				-- synthesis translate_on
			end if;
			
		
		when Wincreate => --par dfaut la fentre 0 est utilise !
		  case MyRank is
		    when x"0"=>
		      Mygroup.grp<=x"0002";-- rank 1
		      MyGroup.nb<=2;
		      destRank:=1;
		      DestAdr:=X"043F";
		      nb_rma:=1;
		    when x"1" =>
		      		      Mygroup.grp<=x"0001";-- rank 0
		      		      destRank:=0;
		      		      DestAdr:=X"0440";
		    when x"2" =>
		      		      Mygroup.grp<=x"0000";-- aucun rank 
		      		      destRank:=0;
		      		      DestAdr:=X"0473";
		    when x"3" =>
		      		      Mygroup.grp<=x"0000";-- aucun rank 
		      		      destRank:=0;
		      		      DestAdr:=X"04A5";
		    when others =>   --cas des processus spawn
		      		      Mygroup.grp<=x"0000";-- rank 0
		      		      DestAdr:=X"022F";
		      		      destRank:=0;
		 end case;
          		 RunState<=WinPost;
		when WinPost =>
			if ct=0 then
				-- synthesis translate_off 
				write (l,string'("Dlen;"& integer'image(dlen) & ";WPost1 " &  integer'image(Dlen) & "; ; started  ; " & real'image(rt(now))));
				report l.all;
            writeline (f, l) ;  
				-- synthesis translate_on
			end if;
			
				pMPI_Win_Post(ct,Libr,sram,MyGroup,0,MyWin);
			
			if ct=0 then
				RunState<=WinStart;
				-- synthesis translate_off
				write (l,string'("Dlen;"& integer'image(dlen) & ";WPost2 " &  integer'image(Dlen) & ";" & image(MyRank) & "; ended at  ; " & real'image(rt(now))));
				report l.all;
            writeline (f, l) ; 
				-- synthesis translate_on
			end if;
			
		when WinStart =>
			if ct=0 then
				-- synthesis translate_off 
				write (l,string'("Dlen;" & integer'image(dlen) & ";WStart1 " &  integer'image(Dlen) & "; ; started  ; " & real'image(rt(now))));
				report l.all;
            writeline (f, l) ;  
				-- synthesis translate_on
			end if;
				pMPI_Win_start(ct,Libr,sram,MyGroup,0,MyWin);
					adresse:=to_integer(unsigned(sram.O.addr_wr));
					adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
					
					dcount:=ct;
			
			if ct=0 then
			  if spawn='0' then
				RunState<=PutData;
				else
				 RunState<=WinCompleted;
				end if;
				-- synthesis translate_off
				write (l,string'("Dlen;" & integer'image(dlen) & ";WStart2 " &  integer'image(Dlen) & ";" & image(MyRank) & "; ended at  ; " & real'image(rt(now))));
				report l.all;
            writeline (f, l) ; 
				-- synthesis translate_on
			end if;
			
		
		when putdata => --construire le packet pour le Put
				
					--dlen:=251; ---
					if ct=0 then
					-- synthesis translate_off 
					write (l,string'("Dlen;" & integer'image(dlen) & ";PUT1 " & integer'image(dlen) & ";" & image(MyRank) & "; started at ; " & real'image(rt(now))));
					report l.all;
					writeline (f, l) ; 
					-- synthesis translate_on
					end if;
					 
					SrcAdr:=X"0105";--std_logic_vector(to_unsigned(DATAPTR,ADRLEN));
					--DestAdr:=X"033F";
					pMPI_put(ct,Libr,Clk,Sram,SrcAdr,Dlen,MPI_int,destrank,DestAdr,Dlen,Mpi_int,Default_win);
					
					adresse:=to_integer(unsigned(sram.O.addr_wr));
					adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
					
					dcount:=ct;
					
					if ct=0 then
						RunState<=GetData;
					-- synthesis translate_off 
					report "Put of Process n; " & image(MyRank) & "; ended at ; " & real'image(rt(now));
					write (l,string'("Dlen;" & integer'image(dlen) & ";PUT2 " & integer'image(dlen) & ";" & image(MyRank) & "; ended at time ; " & real'image(rt(now))));
					report l.all;
					writeline (f, l) ;
					-- synthesis translate_on
					end if;
					
				
			when getdata =>   --positionnement du mot de longueur des donnes
					--dlen:=251; --- 
					if ct=0 then
					-- synthesis translate_off 
					write (l,string'("Dlen;" & integer'image(dlen) & ";GET1; " & image(MyRank) & "; started at ; " & real'image(rt(now))));
					report l.all;
					writeline (f, l) ; 
					-- synthesis translate_on
					end if;
					
					SrcAdr:=X"0104";
					DestAdr:=X"1400";
					if unsigned(MyRank) = 0 then 
				  	--pMPI_GET(ct,Libr,Clk,Sram,SrcAdr,Dlen,MPI_int,destrank,DestAdr,Dlen,Mpi_int,Default_win);
					else
					  
						--pMPI_GET(ct,Libr,Clk,Sram,SrcAdr,Dlen,MPI_int,destrank,DestAdr,Dlen,Mpi_int,Default_win);
					end if;
					adresse:=to_integer(unsigned(sram.O.addr_wr));
					adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
					
					dcount:=ct;
					
					if ct=0 then
					  if unsigned(MyRank)/=0 then
						RunState<=wincompleted;
						else
						  nb_rma:=nb_rma+1;
						  if nb_rma=2 then 
						    RunState<=wincompleted;
						    nb_rma:=0;
						   end if;
						end if;
						-- synthesis translate_off 
						assert ct/=0 report "GET_END " & integer'image(destrank)
								severity Warning ;
						write (l,string'("Dlen ;" & integer'image(dlen) & ";GET2 " & integer'image(dlen) & ";" & image(MyRank) & "; ended at ; " & real'image(rt(now))));
					report l.all;
					
					writeline (f, l) ; 
						-- synthesis translate_on
					end if;
				
				when WinCompleted =>
				if ct=0 then
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";Compl1 " & integer'image(dlen) & ";" & image(MyRank) & "; started at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ; 
						-- synthesis translate_on 
					end if;	
					 pMPI_Win_Complete(ct,Libr,sram,MyWin );
					 adresse:=to_integer(unsigned(sram.O.addr_wr));
					adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
					
					if ct=0 then
						RunState<=WinWait;	
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";Compl2 " & integer'image(dlen) & ";" & image(MyRank) & "; ended at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ;
						-- synthesis translate_on
						
					end if;	  
			when WinWait =>
				if ct=0 then
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";WAIT1 " & integer'image(dlen) & ";" & image(MyRank) & "; started at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ; 
						-- synthesis translate_on 
					end if;	
					 pMPI_Win_wait(ct,Libr,sram,MyWin );
					 adresse:=to_integer(unsigned(sram.O.addr_wr));
					adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
					
					if ct=0 then
					  if unsigned(Myrank)>1 or spawn='1' then
						RunState<=Finalize;	
						else
					  RunState<=MpiSpawn;	
						end if;
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";WAIT2 " & integer'image(dlen) & ";" & image(MyRank) & "; ended at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ;
						-- synthesis translate_on
						
					end if;	  
			when GetCmd=>	
					adresse:=4; --adresse des paramtres			
						readmem(ct,Libr,SRam,std_logic_vector(to_unsigned(adresse,ADRLEN)),param);
					if ct=0 then
					if unsigned(MyRank)=0 then
						if unsigned(param)=5 then 
							Runstate<=MPISpawn;
						end if;
					else
						Runstate<=MPISpawn;
					end if;
					
					end if;
			when MpiSpawn =>
				if ct=0 then
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";Spawn1 " & integer'image(dlen) & ";" & image(MyRank) & "; started at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ; 
						-- synthesis translate_on 
					end if;	
					--(NextCtx : inout natural;signal Interf:inout Core_io;signal SysRam :inout typ_dpram;  

						maxprocs:=2;
					 pMPI_Comm_Spawn(ct,Libr,sram,command,argv,maxprocs,info,root,comm,intercomm,array_of_errcodes);
					 adresse:=to_integer(unsigned(sram.O.addr_wr));
					adresse_rd:=to_integer(unsigned(sram.O.addr_rd));
					
					if ct=0 then
					  if unsigned(Myrank)=0 and spawn='0' then
					    MyGroup.Grp<=x"000C";
					    spawn:='1';
					    Runstate<=WinPost;
					   else
						RunState<=Finalize;	
					end if;
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";Spawn2 " & integer'image(dlen) & ";" & image(MyRank) & "; ended at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ;
						-- synthesis translate_on
						
					end if;	  			
			when finalize =>
					if ct=0 then
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";FINALIZE1 " & integer'image(dlen) & ";" & image(MyRank) & "; started at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ; 
						-- synthesis translate_on
					end if;	
					 sram.O.we<='0';
					sram.O.ena<='0';
					sram.O.enb<='0';
					if ct=0 then
						RunState<=start;	
						-- synthesis translate_off 
						write (l,string'("Dlen ;" & integer'image(dlen) & ";FINALIZE2 " & integer'image(dlen) & ";" & image(MyRank) & "; ended at ; " & real'image(rt(now))));
						report l.all;
						writeline (f, l) ;
						file_close(f);
						fopened:='0';	
						-- synthesis translate_on 
					end if;	  
		
			when st_timeout =>
			  
					sram.O.we<='0';
					sram.O.ena<='0';
					sram.O.enb<='0';
		
			  RunState<=start;
			end case;
			ct_state<=ct; --pour dbogage
			--ct_out<=ct;
		end if;
	end if;
--ct_out<=ct_state;
ht_state<=runstate;
  end process pPutGet;	
out_proc:process(clk)

begin

if rising_edge(clk) then
 if Pe_in(0)='1' then 
   ct_out<=x"00";
   compteur<=0;
elsif compteur>=5000000 then
  compteur<=0;
  ct_out<=to_unsigned(ct_state,8);
elsif compteur<=2500000 then
  ct_out<=to_unsigned(ct_state+128,8);
  compteur<=compteur+1;
else
  ct_out<=to_unsigned(ct_state,8);
  compteur<=0;
end if;
end if;
end process;
end Behavioral;

