--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   07:29:14 03/26/2013
-- Design Name:   
-- Module Name:   C:/Core MPI/CORE_MPI/mpi_test.vhd
-- Project Name:  MPI_CORE_COMPONENTS
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: MultiMPITest
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
use std.textio.all;
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE  ieee.std_logic_textio.ALL; 
 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
USE ieee.numeric_std.ALL;
library NocLib ;

use NocLib.CoreTypes.all; 
ENTITY mpi_test IS
END mpi_test;
 
ARCHITECTURE behavior OF mpi_test IS 
 signal clk,reset : std_logic:='0';
 signal led : std_logic_vector(15 downto 0);
 signal sw : std_logic_vector(15 downto 0);
 signal COM_RX : std_logic := '0';
 signal COM_TX : std_logic := '0';
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT MPI_template is
    
	 port (clk100Mhz : in std_logic;
		rstN : in std_logic;
		sw : in std_logic_vector(15 downto 0);
		Led : out std_logic_vector(15 downto 0);
		RsRX      : in  STD_LOGIC;
		RsTX     : out STD_LOGIC);
    END COMPONENT;
    
  
 type memory is array( integer range <>) of std_logic_vector(7 downto 0);
 constant period  : time := 68 ns ;
 constant   BITperiod :  time := 4340 ns ; -- 10ns*100Mhz/115200 ; 9600--
  signal  RSData :std_logic_vector (7 downto 0):=x"00";

 signal n,m : natural:=0;
   constant clk_period : time := 10 ns;
   CONSTANT DSIZE :NATURAL:=8000;
   CONSTANT RSIZE :NATURAL:=1023;
 function init_mem(size : natural) return memory is
variable dt: memory(0 to size-1);
 begin
 for i in 0 to size-1 loop
 if i<32 then
 dt(i):=std_logic_vector(to_unsigned(i+32,WORD));
 else
 dt(i):=std_logic_vector(to_unsigned(i,WORD));
 end if;
 end loop;
 return dt;
 end function;
  signal Data_to_send :memory(0 to DSIZE-1);--:=init_mem(DSIZE);
  signal Data_receiv : memory(0 to RSIZE);
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: MPI_template PORT MAP (
		clk100Mhz=>clk,
		rstN=>reset, --RESET NEGATIF
		led=>led,
		sw=>sw,
		RsRX => Com_rx,    
		RsTX    => Com_tx
        );

   -- Clock process definitions
   clk_process :process
   begin
		clk <= '0';
		wait for clk_period/2;
		clk <= '1';
		wait for clk_period/2;
   end process;
 
  --reset
  res_proc:process --test du reset
  begin		
      -- hold reset state for 100 ns.
      --reset<='1';
     -- wait for 100 us;
      reset<='0';
      wait for 250 ns;
      reset<='1';
--      wait for 1 ms;
--      reset<='0';
--      wait for 150 ns;
--      reset<='1';
--      wait for 100 us;
--      reset<='0';
--      wait for 150 ns;
--      reset<='1';
      wait;
end process;
   -- Stimulus process
  sw_proc: process --test des switch
   begin		

      sw<=x"0000"; --application s'excute
      wait for 100 us;
		  sw<=x"000b"; --envoie des donnes sur le port srie
		  wait for 100 ns;
		  sw<=x"001a";--fin de la commande d'envoie des donnes
		  wait for 50 ns;
		  sw<=x"002b"; --activation de la commande pour spawn
		   wait for 300 ns;
		  sw<=x"005a";--
		  wait for 50 ns;
		 		  sw<=x"006b"; --activation de la commande pour spawn
		   wait for 3 us;
		  		  sw<=x"005a";--
		  wait for 50 ns;
		  		  sw<=x"004b"; --activation de la commande pour spawn
		   wait for 5 us;
		  		  sw<=x"005a";--
      wait for 50 ns;--
		  		  sw<=x"005b"; --envoie des donnes  travers le port srie
		  wait for  3 us;
		  sw<=x"0008";
		  wait for 5 ms;
		  sw<=x"0000";
		  wait;
	end process;
   stim_proc: process
   begin		
     wait for 10 ns;
    if led(14)='1' then --attendre le dbut de spawn
		loop  
      Com_Rx <= '1'; -- Idle
             if n<Dsize then
            RsData<=Data_to_send(n);
          else
            wait; ---fin de l'envoie !
         end if; 
       
 wait for 100 * period;
	com_Rx <= '0'; -- Start bit
 wait for BITperiod;
 for i in 0 to 7 loop
 com_Rx <= RSData(i);  wait for BITperiod ;
 end loop;
 com_Rx <= '1'; -- Stop bit
  n<=n+1;
 wait for BITperiod;
end loop;
end if;
   end process;
recv_p:process
 Variable L : line;
 Variable MOT : std_logic_vector (7 downto 0);

begin
loop
 wait until com_Tx ='0'; -- get falling edge ='0'; -- get falling edge
 wait for (0.5 * BITperiod); -- Middle of Start bit ;
 assert  com_Tx ='0'
 report "Start Bit Error ???" severity warning;
 wait for BITperiod ; -- First Data Bit
 for i in 0 to 7 loop -- Get word
 MOT(i):= com_Tx ; wait for BITperiod;--last wait is for stop bit
 end loop;
-- wait for BITperiod ;--stop bit
 Data_receiv(m)<=Mot;--stocker le mot reu en mmoire
 m<=m+1;
 if m=RSize then 
    m<=0;
end if;
 assert com_Tx ='1'
 report "Stop bit Error ???" severity warning;
 WRITE (L,string'("Character received (hex) = "));
 HWRITE (L,MOT); -- trace :
 WRITELINE (output,L); -- char -> transcript
 end loop;
end process recv_p;

END;
