--------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM Roland Christian
--
-- Create Date:   16:44:13 08/01/2012
-- Design Name:   
-- Module Name:   C:/Core MPI/CORE_MPI/MultiMPITest.vhd
-- Project Name:  MPI_CORE_COMPONENTS
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- Template d'untilisation de MPI - HCL
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- 
-- 
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
library NocLib ;

use NocLib.CoreTypes.all;
LIbrary MPI_HCL;
use MPI_HCL.Packet_type.all;
use work.Hcl_Arch_conf.all;
USE ieee.numeric_std.ALL;
 Library UNISIM;
use UNISIM.vcomponents.all;
ENTITY Mpi_template IS
--rem simulation translate_off
port (clk100MHz : in std_logic;
rstn : in std_logic;
sw : in std_logic_vector(15 downto 0); --bouton bascule
Led : out std_logic_vector(15 downto 0);
--rem simulation translate_on
RsRX      : in  STD_LOGIC;
RsTX     : out STD_LOGIC);
END MPi_template;
 
ARCHITECTURE behavior OF MPI_Template IS 
 
    -- Composant pour le diviseur d'horloge
 component CLKDIV
port
 (-- Clock in ports
  SysCLK100           : in     std_logic;
  -- Clock out ports
  CLK100          : out    std_logic;
  CLK50          : out    std_logic;
  CLK25          : out    std_logic;
  -- Status and control signals
  RST             : in     std_logic;
  LOCKED            : out    std_logic
 );
end component;
---------------------------------------------------------------------
  --
  --  ICON component declaration
  --
  ---------------------------------------------------------------------

  component chipscope_icon
    port (
      CONTROL0	: inout std_logic_vector(35 downto 0)
    
      );
  end component;

   ---------------------------------------------------------------------
  --
  --  VIO component declaration  
  --
  ---------------------------------------------------------------------

  component chipscope_vio
    port (
      CONTROL	: inout std_logic_vector(35 downto 0);
      CLK	:  in  std_logic;
      SYNC_IN	:  in  std_logic_vector(7 downto 0)
      );
  end component;

  ---------------------------------------------------------------------
  -- 
  --  ILA component declaration
  --
  ---------------------------------------------------------------------

  component chipscope_ila
    port (
      CONTROL	: inout std_logic_vector(35 downto 0);
      CLK	:  in  std_logic;
      TRIG0	:  in std_logic_vector(7 downto 0);
      TRIG1	:  in std_logic_vector(7 downto 0);
      TRIG2	:  in std_logic_vector(7 downto 0);
      TRIG3	:  in std_logic_vector(7 downto 0);
      TRIG4	:  in std_logic_vector(7 downto 0);
      TRIG5	:  in std_logic_vector(7 downto 0);
      TRIG6	:  in std_logic_vector(7 downto 0);
      TRIG7	:  in std_logic_vector(7 downto 0);
      TRIG_OUT	:  out std_logic
      );
  end component;
    COMPONENT MPI_NOC
	 generic (NPROC: natural:=2);
    PORT(
         MPI_Node_in : IN   Ar_MPIPort_in(1 to NPROC);
         MPI_Node_Out : OUT   Ar_MPIPort_out(1 to NPROC)
        );
    END COMPONENT;
	 component proto_send is
generic (sizemem : natural := 64);
 port (
 clk,reset : in std_logic;
 fifo_in_empty,fifo_in_full : in std_logic; --signaux pour le fifo d'entre
 fifo_out_empty,fifo_out_full : in std_logic; --signaux pour le fifo de sortie
 fifo_out_wr_en : out std_logic:='0'; --criture autorise dans la fifo de sortie
 fifo_in_rd_en : out std_logic:='0'; --lecture autorise dans la fifo d'entre
 fifo_in_data_out : in std_logic_vector(Word-1 downto 0);
 fifo_out_data_in : out std_logic_vector(Word-1 downto 0);
 packet_len : in std_logic_vector(Word-1 downto 0); --la longueur du paquet
 copy_mode : in std_logic; --Fifo_to_mem ou Fifo_to_fifo
 snd_start : in std_logic; --dbut de la rception
 snd_ack :in std_logic;   -- acquittement de la rception
 snd_comp : out std_logic; -- fin de la rception
 mem :in memory(0 to sizemem-1)); --donnes  copier vers le fifo
 end component proto_send;
Component Fifo2mem is
Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  wr_start : in STD_LOGIC;
           fifo_data_out : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           fifo_data_available : in  STD_LOGIC;
			  datalen :   STD_LOGIC_VECTOR (Word-1 downto 0);
           fifo_data_out_en : out  STD_LOGIC;
           fifo_empty : in  STD_LOGIC;
			  ram_busy : in  STD_LOGIC;
           ram_addr_start : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
			  ram_addr : out  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           ram_data_in : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           ram_wr : out  STD_LOGIC;
           ram_en : out  STD_LOGIC;
			  wr_comp :out STD_LOGIC);
end component fifo2mem;

COMPONENT mem2fifo_a is --copy from memory to fifo
 port (
 clk,reset : in std_logic;
 copy_mode : in std_logic; --Fifo_to_mem ou Fifo_to_fifo
 snd_start : in std_logic; --dbut de la rception
 snd_ack :in std_logic;   -- acquittement de la rception
 datalen : in std_logic_vector(Word-1 downto 0); --la longueur du paquet
 ram_busy : in  STD_LOGIC;
 ram_addr_start :in std_logic_vector(ADRLEN-1 downto 0); --addresse de dbut du bloc de donne  copier
 fifo_out_empty,fifo_out_full : in std_logic; --signaux pour le fifo de sortie
 fifo_out_wr_en : out std_logic:='0'; --criture autorise dans la fifo de sortie
 ram_in_rd_en : out std_logic:='0'; --lecture autorise dans la fifo d'entre
 ram_in_data_out : in std_logic_vector(Word-1 downto 0);
 ram_in_addr_rd :out std_logic_vector(ADRLEN-1 downto 0); --addresse de la donne  copier
 fifo_out_data_in : out std_logic_vector(Word-1 downto 0);
 snd_comp : out std_logic); -- fin de la rception

END COMPONENT mem2fifo_a;

COMPONENT UART_TX_CTRL generic (ComRate : natural:=217);
	PORT(
		SEND : IN std_logic;
		DATA : IN std_logic_vector(7 downto 0);
		CLK : IN std_logic;          
		READY : OUT std_logic;
		UART_TX : OUT std_logic
		);
	END COMPONENT;
component com_icap is
  generic ( hexmode : boolean := true; -- false is for faster binary mode, but will not work on all machines/boards
            ComRate : integer := 217); -- ComRate = f_CLK / Boud_rate (e.g., 25 MHz/115200 Boud = 217)
  port (CLK         : in  std_logic;
        Rx          : in  std_logic;
        Tx          : out std_logic;
		  RxErr:         out std_logic;
        debug0:     out std_logic_vector(19 downto 0);
        debug1:     out std_logic_vector(19 downto 0);
        debug2:     out std_logic_vector(19 downto 0);
		  bs_load_start : in std_logic; --dbut de rception bitstream
		  bs_load_comp :out std_logic; --fin de rception
		  bs_load_ack :in std_logic; --acquitement bistream
		  bs_load_data : out std_logic_vector(31 downto 0);
		   rxWord   : out std_logic_vector(7 downto 0); -- mot reu
			RxRdy     : out std_logic; --donnes reues
        ComActive   : out std_logic;
        WriteStrobe : out std_logic;
        ReceiveLED  : out std_logic);
end component com_icap;
 Component PE
  generic(destid : natural;
				use_dyn:natural);
  Port ( Instruction : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : out  STD_LOGIC;
			  Core_PushOut : in STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			     CE : in  STD_LOGIC;
			     ct_out : out unsigned(7 downto 0);
				  PE_in : in STD_LOGIC_VECTOR (Word-1 downto 0);
				  PE_out : out STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_Out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_Out2: out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_In : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_WE : in  STD_LOGIC;
           Core_RAM_EN : in  STD_LOGIC;
           --Core_RAM_ENB : in  STD_LOGIC;
           Core_RAM_ADDRESS_WR : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_RAM_ADDRESS_RD : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_Hold_req : in  STD_LOGIC;
           Core_Hold_Ack : out  STD_LOGIC);
end Component;  
 component FIFO_256_FWFT
	port (
	clk: IN std_logic;
	din: IN std_logic_VECTOR(Word-1 downto 0);
	rd_en: IN std_logic;
	srst: IN std_logic;
	wr_en: IN std_logic;
	dout: OUT std_logic_VECTOR(Word-1 downto 0);
	empty: OUT std_logic;
	full: OUT std_logic);
end component;
 	constant clk_period : time := 15 ns;
   constant PROC : positive :=NOC_SIZE; --4

--===================signaux pour l'horloge ==============================
signal CLK100,CLK50,CLK25,reset,locked : std_logic := '0';
signal CLK200,Clkm,RST : std_logic := '0';
--========================================================================

 --signaux pour la gestion de la MAE
 type typ_rs_send is (snd_wait,snd_read,snd_sendBit,snd_lf,snd_cr);
type typ_mem is array (natural range <>) of std_logic_vector(Word-1 downto 0);
type typ_tab is array (natural range <>) of unsigned(7 downto 0);
--groupe de signaux utilis pour communiquer avec l'extrieur de la plateforme
type arDpRam is array (natural range <>) of typ_dpRam;
type typ_Pconsole is(idle,get_bus,get_ht_mem,rd_ht_mem,wr_ht_mem,
Write_cmd,Cmd_To_fifo,et_end);
signal et_send :typ_rs_send;
signal et_Pconsole,Next_et_Pconsole : typ_pconsole;
signal Pcons_ram :typ_dpram; --signaux pour accs  la ram par la console
signal pcons_hold_req,pcons_hold_ack: std_logic;--pour accs  la Ram du HT
signal pcons_cmd : natural range 0 to 15; -- la  commande qui est sollicite depuis le clavier
signal pcons_wr_comp,pcons_wr_start : std_logic;--pour contrler l'criture dans la Ram du HT
signal pcons_fifo_wr:std_logic;--contrle l'criture des donnes dans le FIFO de sortie
signal pcons_rd_comp,pcons_rd_start,pcons_rd_ack :std_logic;
signal pcons_ram_busy : std_logic:='0';
signal pcons_data:std_logic_vector(Word-1 downto 0); --une donnes fournie par la console aux HTs
signal pcons_ht : natural range 0 to 15:=0;--le numro du HT qui est sollicit
signal mux_hold_req,dmux_hold_ack: std_logic_vector(1 to PROC); --multiplexer les signaux d'accs RAM HT entre Core_MPI et console 
signal dmux_instruction : typ_mem(1 to PROC);
signal dmux_instruction_en : std_logic_vector(1 to PROC);
signal mux_ram,mux_ram_s,mux_ram_d : Ar_DpRam(1 to PROC); --signaux pour rcuprer les donnes de la RAM
signal pcons_sel,pcons_sel_i:std_logic_vector(1 to PROC):=(others=>'0');--tat de la slection du MUX entre Console et Core MPI
signal pcons_fin_rd_en:std_logic;
signal wr_ok,rd_ok:std_logic:='0';
signal presence : std_logic_vector(1 to 4); --signale les modules actifs
signal ct_tab : typ_tab(1 to 4); --etat des sorties des MAE
--signal PE_out : std_logic_vector(Word-1 downto 0);
signal Sys_in : typ_mem(1 to PROC);
signal Sys_Out : typ_mem(1 to PROC);
--
--signaux pour le module de communication RS232C
signal rs_cmd,rs_rw,rs_comp:std_logic;
signal rs_addr_start:std_logic_vector(adrlen-1 downto 0);
signal rs_plen :std_logic_vector(word-1 downto 0);
signal rs_fifo_in_data_out_en:std_logic;
signal rs_fifo_in_data_available : std_logic;
signal rs_fifo_in_data_out :std_logic_vector(word-1 downto 0);
signal rs_fifo_out_data_out_en:std_logic;
signal rsin_fifo_data_available : std_logic;
signal rs_fifo_out_data_out :std_logic_vector(word-1 downto 0);
signal rs_fifo_out_empty:std_logic;
--
signal dcount : natural range 0 to 255:=0; --permet de compter le packet de donnes envoyes
signal count,count_i : natural range 0 to 15:=0;

signal MPI_Node_in : Ar_MPIPort_in(1 to PROC) ;
signal MPI_Node_Out : Ar_MPIPort_out(1 to PROC);
--=========================================================
--signaux pour la communication srie
	constant period  : time := 68 ns ;
	constant   BITperiod :  time := 8680 ns ; -- 115.200 ; -- 115.200
	signal COM_RX : std_logic := '0';
	signal COM_TX : std_logic := '0';
	signal  RSData :std_logic_vector (7 downto 0):=x"00";
	signal Data_to_send :memory(0 to 8000);
	signal n : natural:=0; 
	--
type UART_STATE_TYPE is (RST_REG, LD_INIT_STR, SEND_CHAR, RDY_LOW, WAIT_RDY, WAIT_BTN, LD_BTN_STR);
type CHAR_ARRAY is array (integer range<>) of std_logic_vector(7 downto 0);
constant MAX_STR_LEN : integer := 27;

signal counter : std_logic_vector(25 downto 0) := (others => '0');
signal rxWord : std_logic_vector(7 downto 0);
signal ComCommand : std_logic_vector(7 downto 0);
signal comWriteStrobe :std_logic;
signal ComActive, NotComActive : std_logic;
signal RxRdy : std_logic;
signal Local_COM_RX : std_logic;
signal Local_COM_TX : std_logic;
signal uartState : UART_STATE_TYPE := RST_REG;
--UART_TX_CTRL control signals
signal uartRdy : std_logic;
signal uartSend : std_logic := '0';
signal uartData : std_logic_vector (7 downto 0):= "00000000";
signal uartTX : std_logic;
--signale une erreur en cas de mauvaise rception
signal Recv_Err_led : std_logic:='0';
--===============================================================+
--signaux pour les fifo d'entre et de sortie

signal rsin_fifo_rd_en:std_logic;--(ADRLEN-1 downto 0);
signal rsin_fifo_wr_en : std_logic;
signal rsin_fifo_empty : std_logic;
signal rsin_fifo_full : std_logic;
signal rsin_fifo_dout : std_logic_vector(WORD-1 downto 0);
signal rsin_fifo_din : std_logic_vector(WORD-1 downto 0);
signal rsout_fifo_rd_en:std_logic;--(ADRLEN-1 downto 0);
signal rsout_fifo_wr_en : std_logic;
signal rsout_fifo_empty : std_logic;
signal rsout_fifo_full : std_logic;
signal rsout_fifo_dout : std_logic_vector(WORD-1 downto 0);
signal rsout_fifo_din : std_logic_vector(WORD-1 downto 0);
--===============================================================
  signal trigout	: std_logic;
  signal syncin	: std_logic_vector(7 downto 0);
  signal control_0             : std_logic_vector (35 downto 0);
  signal control_1	: std_logic_vector(35 downto 0);
  -----------------------------------------------------------------------
  --  Constant Declaration
  -----------------------------------------------------------------------
  constant C_NUM_OF_TRIGPORTS   : integer := 8;
  constant C_TRIG0_SIZE         : integer	:= 8;
  constant C_TRIG1_SIZE         : integer	:= 8;
  constant C_TRIG2_SIZE         : integer	:= 8;
  constant C_TRIG3_SIZE         : integer	:= 8;
  constant C_TRIG4_SIZE         : integer	:= 8;
  constant C_TRIG5_SIZE         : integer	:= 8;
  constant C_TRIG6_SIZE         : integer	:= 8;
  constant C_TRIG7_SIZE         : integer	:= 8;
--===============================================================
  signal trig_0	: std_logic_vector(C_TRIG0_SIZE-1 downto 0);
  signal trig_1	: std_logic_vector(C_TRIG1_SIZE-1 downto 0);
  signal trig_2	: std_logic_vector(C_TRIG2_SIZE-1 downto 0);
  signal trig_3	: std_logic_vector(C_TRIG3_SIZE-1 downto 0);
  signal trig_4	: std_logic_vector(C_TRIG4_SIZE-1 downto 0);
  signal trig_5	: std_logic_vector(C_TRIG5_SIZE-1 downto 0);
  signal trig_6	: std_logic_vector(C_TRIG6_SIZE-1 downto 0);
  signal trig_7	: std_logic_vector(C_TRIG7_SIZE-1 downto 0);

---===============================================================
--signaux pour le port ICAP
	signal swap_reg : std_logic_vector(31 downto 0) := (others=>'0');
	type RegStateType is (getHigh, getNib1,getNib2,getLow);
	signal RegState : RegStateType;
	signal IcapCLK_trigger, IcapCLK_trigger_reg, IcapCLK : std_logic;
	signal Icapi, IcapO : std_logic_vector(31 downto 0);
	signal IcapBUSY : std_logic;
	signal IcapCE : std_logic;
	Signal RdWrB : std_logic:='0'; --contrle la lecture ou l'criture du port ICAP
	signal icap_COM_RX,icap_COM_TX:std_logic; --conversion serie/ICAP
	-- Signaux pour le port Srie qui reoit le fichier *.Bit
	signal debug0: std_logic_vector(19 downto 0);
signal debug1: std_logic_vector(19 downto 0);
signal debug2: std_logic_vector(19 downto 0);
signal receiveLed :std_logic; --led qui clignote au rithme des rceptions.
signal bs_load_start :  std_logic; --dbut de rception bitstream
signal bs_load_comp : std_logic; --fin de rception
signal bs_load_ack : std_logic; --acquitement bistream
signal bs_load_data:  std_logic_vector(31 downto 0);
--signal rxWord   :  std_logic_vector(7 downto 0); -- mot reu
--signal RxRdy     :  std_logic; 
--=================================================================
 
BEGIN
SysMPI: MPI_NOC GENERIC MAP (NPROC=>NOC_SIZE)
		PORT MAP (
          MPI_Node_in => MPI_Node_in,
          MPI_Node_Out => MPI_Node_Out
        );
--
---port ICAP srie ====================================================================
instcomicap:com_icap 		-- instantiate the UART receiving the configuration data
  generic map(
    hexmode => false,  -- false is for faster binary mode, but will not work on all PCs
    ComRate => 108)   -- ComRate = f_CLK / Boud_rate (e.g., 25 MHz/115200 Boud = 217)
	                   -- 1302 @ 19200 Boud 108 @ 230400/25 MHz
  port map (
    clk            => CLK25,
    rx             => icap_COM_RX,
    tx             => icap_COM_TX,
	 rxerr			=> Recv_Err_led,
	 rxRdy			=> RxRdy,
	 --rxWord			=> RxWord,
	 debug0         => debug0,
	 debug1         => debug1,
	 debug2         => debug2,
    RxWord       => rxWord,
	 bs_load_data		=> bs_load_data,
    comactive      => ComActive,
    writestrobe    => ComWritestrobe,
    bs_load_start  => bs_load_start,
	 bs_load_comp	=>bs_load_comp,
	 bs_load_ack	=>bs_load_ack,
    receiveled     => receiveled  );
	 
--========================================================

res_Led_sw:process (MPi_Node_out,sw,bs_load_start,CLK25,uartTX,rsRX,
pcons_sel,receiveLed,presence)
variable p:natural range 0 to 255:=1;
begin
p:=to_integer(unsigned(sw)); --rcuprer les switchs pour dfinir les entres
if p>0 then
Led(7 downto 0)<=MPi_Node_out(1).PushOut;
else
 Led(7 downto 0)<=MPi_Node_out(2).PushOut;
end if;
led(8)<=sw(4);
led(9)<=CLK25;
led(10)<=uartTx;
led(11)<=rsRX;
led(12)<=ReceiveLed;
led(13)<=pcons_sel(1);
led(14)<=bs_load_start;
led(8)<=presence(1);
led(9)<=presence(2);
led(15)<=presence(3);
end process;
--===========================================================
--diviseur d'horloge
process(CLK100Mhz)
begin
  if CLK100Mhz'event AND CLK100Mhz='1' then
    counter <= std_logic_vector(unsigned(counter) + 1);
  end if;
end process;
inst_CLKDIV : CLKDIV
  port map
   (-- Clock in ports
    SysCLK100 => CLK100Mhz,
    -- Clock out ports
    CLK100 => CLK100,
    CLK50 => CLK50,
    CLK25 => CLK25,
    -- Status and control signals
    RST  => Rst,
    LOCKED => LOCKED);
--CLKm<=counter(0);--horloge  50 MHz
CLKm<=CLK50;--counter(0);--horloge  50 MHz
--CLK25<=counter(1); --CLK10 est une horloge  100 MHZ sur NEXSYS 4! 
reset<= not locked; --inversion de l'tat de reset pour les composant du montage
RST<= not rstn;
--===========================================================

--===========================================================
S_Grp:for i in 1 to STATIC_HT generate
S: PE 	Generic map (DestId=>i-1,
							 use_dyn=>0)
			Port Map (
				Instruction => dmux_instruction(i),
           Instruction_en =>dmux_instruction_en(i),
			  Core_PushOut => MPi_Node_out(i).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '1',
			  ct_out=>ct_tab(i),
			  PE_Out=>Sys_out(i),
			  PE_In=>sys_In(i),
				Core_RAM_Data_Out =>mux_ram_d(i).i.Data_out,
				Core_RAM_Data_Out2=>mux_ram_s(i).i.Data_out,
           Core_RAM_Data_IN => mux_ram(i).o.data_in,
           Core_RAM_WE => mux_ram(i).o.we,
           Core_RAM_EN => mux_ram(i).o.enb,
           Core_RAM_Address_Wr => mux_ram(i).o.addr_wr,
           Core_RAM_Address_Rd => mux_ram(i).o.addr_rd,
           Core_Hold_req => mux_hold_req(i),
           Core_Hold_Ack => dmux_hold_ack(i)			  

);

end generate S_Grp;
dyn_mod: if dyn_allowed='1' generate
D_Grp:for i in STATIC_HT+1 to NOC_SIZE generate
D: PE 	Generic map (DestId=>i-1,
						use_dyn=>1)
			Port Map (
				Instruction => dmux_instruction(i),--MPi_Node_in(i).Instruction,
           Instruction_en =>dmux_instruction_en(i),-- MPi_Node_in(i).Instruction_en,
			  Core_PushOut => MPi_Node_out(i).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '0',
			  ct_out=>ct_tab(i),
			  PE_Out=>Sys_out(i),
			  PE_In=>sys_In(i),
           Core_RAM_Data_Out2 =>mux_ram_s(i).i.Data_out,
           Core_RAM_Data_Out =>mux_ram_d(i).i.Data_out,
           Core_RAM_Data_IN => mux_ram(i).o.data_in,
           Core_RAM_WE => mux_ram(i).o.we,
           Core_RAM_EN => mux_ram(i).o.enb,
           Core_RAM_Address_Wr => mux_ram(i).o.addr_wr,
           Core_RAM_Address_Rd => mux_ram(i).o.addr_rd,
           Core_Hold_req => mux_hold_req(i),
           Core_Hold_Ack => dmux_hold_ack(i)
);

end generate D_Grp;
end generate dyn_mod;

trig_0(3 downto 0)<= x"0";
trig_0(7)<=MPi_Node_out(1).PushOut(0);
trig_0(6)<=MPi_Node_out(2).PushOut(0);
trig_0(5)<=MPi_Node_out(3).PushOut(0);
trig_0(4)<=MPi_Node_out(4).PushOut(0);
trig_1<=dmux_instruction(1);
trig_2<=dmux_instruction(2);
trig_3<=dmux_instruction(3);
trig_4<=dmux_instruction(4);
trig_5<=std_logic_vector(ct_tab(1));
trig_6<=std_logic_vector(ct_tab(2));
trig_7<=std_logic_vector(ct_tab(3));

--(7 => '0', 6 downto 5 => '1',others => '0')
--affect_process
affec_pres:process(ct_tab)
begin
  for i in 1 to 4 loop
presence(i)<=ct_tab(i)(7);
end loop;
end process;
affec_PE:process(sw)
begin
for i in 1 to 4 loop
sys_in(i)<=(0=>sw(i+7),others=>'1');
end loop;
end process;
 --instantiation du FIFO_256 pour le port srie
 RS_INPUT_FIFO : FIFO_256_FWFT
		port map (
			clk => clkm,
			din => rsin_fifo_din,
			rd_en => rsin_fifo_rd_en,
			srst => reset,
			wr_en => rsin_fifo_wr_en,
			dout => rsin_fifo_dout,
			empty => rsin_fifo_empty,
			full => rsin_fifo_full);
	 RS_OutPut_FIFO : FIFO_256_FWFT
		port map (
			clk => clkm,
			din => rsout_fifo_din,
			rd_en => rsout_fifo_rd_en,
			srst => reset,
			wr_en => rsout_fifo_wr_en,
			dout => rsout_fifo_dout,
			empty => rsout_fifo_empty,
			full => rsout_fifo_full);

-------------------------------------------------------------------
  --
  --  ICON Pro core instance
  --
  -------------------------------------------------------------------
  -- Icon core with two control ports is instantiated to connect to ILA and VIO cores.
  ICON_inst : chipscope_icon  
    port map(
      CONTROL0 => control_0 -- INOUT BUS [35:0]

      );
			
--VIO_inst : chipscope_vio
--    port map (
--      CONTROL	=> control_1,	-- INOUT BUS (35:0)
--      CLK	=> clk50,	-- IN
--      SYNC_IN	=>MPi_Node_out(1).PushOut 	-- IN (7:0)
--      );

ILA_inst : chipscope_ila
    port map (
      CONTROL	=> control_0,	-- INOUT BUS (35:0)
      CLK	=> clk50,	-- IN
      TRIG0	=> trig_0,	-- IN BUS (7:0) 
      TRIG1	=> trig_1,	-- IN BUS (7:0) 
      TRIG2	=> trig_2,	-- IN BUS (7:0) 
      TRIG3	=> trig_3,	-- IN BUS (7:0) 
      TRIG4	=> trig_4,	-- IN BUS (7:0) 
      TRIG5	=> trig_5,	-- IN BUS (7:0) 
      TRIG6	=> trig_6,	-- IN BUS (7:0) 
      TRIG7	=> trig_7,	-- IN BUS (7:0) 
      TRIG_OUT	=> trigout	-- OUT
      );


rsin_fifo_data_available<= not rsin_fifo_empty;
-- Merge two bytes or four bytes if ICAPE2 from the UART to one 16/32 bit word for the Spartan-6 ICAP/ARTIX-7 ICAPE2
-- Note that we have to permute the bits within each byte...
inversion_byte:process(bs_load_data)
begin
	   for i in 0 to 7 loop --inversion des bits octet par octet
	     for j in 0 to 3 loop
	       swap_reg(j*8+i)<= bs_load_data(j*8+7-i);
	       end loop;
	      end loop;
end process;

--- controle de la reconfiguration du FPGA
process(CLKM)
begin
  if rising_edge(clkm) then
	 if ComWritestrobe='1' then
	   IcapCLK_trigger <= '1';
	 else
	   IcapCLK_trigger <= '0';
	 end if;
	 IcapCLK_trigger_reg <= IcapCLK_trigger;
  end if; 
end process;
--Component used to send a byte of data over a UART line.
Inst_UART_TX_CTRL: UART_TX_CTRL generic map(ComRate => 217)
port map(
		SEND => uartSend,
		DATA => uartData,
		CLK => CLKm,
		READY => uartRdy,
		UART_TX => uartTX 
	);
	rsTX<=UartTX;
-- connect ICAP signals
--icap_signal:process (Et_Icap,bs_load_data,writestrobe,
--bs_load_start,bs_load_comp)
--begin
--  
--  case et_icap is
--  when icap_idle =>
--    IcapCE <= '1';
--    RDWRB<='1';
--	 IcapI <= bs_load_data;
--	when icap_writting =>
--	 IcapCE <= '1';
--    RDWRB<='1';
--	 IcapI <= bs_load_data;
--	when icap_idle =>
      IcapCLK<=clkm;--IcapCLK_trigger_reg
	  IcapCE <= not comWritestrobe;--Not(bs_load_start);
    RDWRB<='0';
  	 IcapI <= swap_reg;
--	end case;
 -- ICAPE2: Internal Configuration Access Port
   --         Artix-7 ID=X3631093 Voir UG470 pour les autres devices
   -- Xilinx HDL Language Template, version 14.7
		
   ICAPE2_inst : ICAPE2
   generic map (
      DEVICE_ID => X"03631093",     -- Specifies the pre-programmed Device ID value to be used for simulation
                                   -- purposes.
      ICAP_WIDTH => "X32",         -- Specifies the input and output data width.
      SIM_CFG_FILE_NAME => "None"  -- Specifies the Raw Bitstream (RBT) file to be parsed by the simulation
                                   -- model.
   )
   port map (
      O => IcapO,         -- 32-bit output: Configuration data output bus
      CLK => IcapCLK,     -- 1-bit input: Clock Input
      CSIB => IcapCE,   -- 1-bit input: Active-Low ICAP Enable
      I => IcapI,         -- 32-bit input: Configuration data input bus
      RDWRB => RDWRB  -- 1-bit input: Read/Write Select input
   );

   -- End of ICAPE2_inst instantiation


--******************************************
--** Gestion des switchs et de la rception des donnes
--********************************************
process(clkm,sw,rsRX,bs_load_comp)
begin
if rising_edge(clkm) then
if sw(0)='1' then
	rs_cmd<='1';
else
	rs_cmd<='0';
end if;

if sw(1)='1' then
	rs_rw<='1';
else
	rs_rw<='0';
	
end if;

--if sw(2)='1' or sw(3)='1' then
--pcons_ht<=to_integer(unsigned(sw(3 downto 2))+1); --choix du HT  contrler
--else
pcons_ht<=1; --choix du HT  contrler
--end if;
if sw(3)='1' then
  icap_COM_RX<=rsRX;
  bs_load_start<='1';
  bs_load_ack<=bs_load_comp;
else
  icap_COM_RX<='1';
  bs_load_start<='0';
  bs_load_ack<='0';
end if;
pcons_cmd<=to_integer(unsigned(sw(7 downto 4)));
end if;
end process;
--************************************************************
--MAE de lecture de la mmoire de communication de chaque tche et envoie des donnes
-- sur le port srie
Pcons_sync:process(clkm)
begin
if rising_edge(clkm) then
if reset='1' then
Et_Pconsole<=idle;
pcons_sel<=(others=>'0');
else
et_Pconsole<=next_et_Pconsole;
pcons_sel<=pcons_sel_i;
end if;
end if;
end process;
--*********************************************************
Pcons_next : process(et_Pconsole,pcons_rd_comp,pcons_wr_comp,dmux_hold_ack,rs_cmd,
rs_rw,rsin_fifo_empty,pcons_ht,MPI_Node_out,pcons_cmd,pcons_sel)

variable bus_free:std_logic:='0';
begin
next_et_pconsole<=et_Pconsole; --valeur par dfaut
pcons_sel_i<=pcons_sel;
wr_ok<='0';
rd_ok<='0';
case et_pconsole is
when idle => if rs_cmd='1' then
		next_et_pconsole<=get_bus;
		end if;
		pcons_sel_i<=(others=>'0');
when get_bus => 
bus_free:='0';
for i in 1 to PROC loop
	if pcons_ht=i then
	if MPI_Node_out(i).Hold_req='0' then
		Pcons_sel_i(i)<='1';
		bus_free:='1';
	else
		Pcons_sel_i(i)<='0';
	end if;
	else
		Pcons_sel_i(i)<='0';
	end if;
end loop;
if bus_free='1' then
	next_et_pconsole<=get_ht_mem;
end if;
when get_ht_mem => if dmux_hold_ack(pcons_ht)='1' then 
							if pcons_cmd>0 then 
							next_et_pconsole<=Cmd_to_fifo;
							else
							if rs_rw='1' then
											next_et_pconsole<=rd_ht_mem;
									 else --if rs_rw='1' then
											next_et_pconsole<=wr_ht_mem;
									 end if;
						 end if;
						 end if;
when cmd_to_fifo=> if rsin_fifo_empty='1' then
							wr_ok<='1';
							next_et_pconsole<=Write_cmd;
							else
							 rd_ok<='1'; --vider le fifo
						end if;
when Write_cmd => --crire la commande dans la mmoire du HT
									if pcons_wr_comp='1' then
									if rs_rw='1' then
											next_et_pconsole<=rd_ht_mem;
									 else --if rs_rw='1' then
											next_et_pconsole<=wr_ht_mem;
									 end if;
									 end if;
when rd_ht_mem => if pcons_rd_comp='1' then
						
						next_et_pconsole<=et_end;
					end if;
when wr_ht_mem=> if pcons_wr_comp='1' then
					next_et_pconsole<=et_end;
					
					end if;
when et_end =>
	for i in 1 to PROC loop
	Pcons_sel_i(i)<='0';
	end loop;
	if rs_cmd='0' then --atendre la fin de la cmd
	next_et_pconsole<=idle;
	end if;
end case;
end process;
--*************************************************
Pcons_val : process(et_Pconsole,pcons_cmd,pcons_rd_comp,wr_ok,rd_ok,
rxRdy,rxWord,pcons_fin_rd_en)
begin
pcons_rd_start<='0';
pcons_rd_ack<='0';
pcons_wr_start<='0';
Pcons_Hold_req<='0';
rs_comp<='0';
rs_addr_start<=x"0100";
rs_plen<=x"FA"; --taille des donnes  copier (250)
rsin_fifo_wr_en<=RxRdy;
rsin_fifo_din<=RxWord;
rsin_fifo_rd_en<=pcons_fin_rd_en;
case et_pconsole is
when idle =>
when get_bus =>
when get_ht_mem => Pcons_Hold_req<='1';
WHEN Write_cmd=>rs_addr_start<=x"0004"; --adresse dans la mmoire pour les commandes
rs_plen<=x"01"; --un seul octet
pcons_wr_start<='1';
Pcons_Hold_req<='1';
when Cmd_to_fifo =>
rsin_fifo_wr_en<=wr_ok;
rsin_fifo_rd_en<=rd_ok;
rsin_fifo_din<=std_logic_vector(to_unsigned(pcons_cmd,WoRD));
Pcons_Hold_req<='1';
when rd_ht_mem => pcons_rd_start<='1';
  Pcons_Hold_req<='1';
 if pcons_cmd=1 then
  rs_addr_start<=x"1000";
elsif pcons_cmd=2 then
rs_addr_start<=x"1200";
elsif pcons_cmd=3 then
rs_addr_start<=x"0104";
elsif pcons_cmd=4 then
rs_addr_start<=x"0004";
elsif pcons_cmd=5 then
  rs_addr_start<=x"0440";
end if;
pcons_rd_ack<=pcons_rd_comp;
when wr_ht_mem=> pcons_wr_start<='1';
  Pcons_Hold_req<='1';
rs_addr_start<=x"0100";
when et_end=>rs_comp<='1';
		pcons_wr_start<='0';
		Pcons_Hold_req<='0';
end case;
end process;
--Multiplexeur de la console pour l'accs  la RAM de chaque HT.
Ram_mux: process (MPI_Node_out,pcons_sel,pcons_ram.o,
pcons_rd_start,pcons_wr_start,pcons_hold_req	)
 begin 
for i in 1 to PROC loop 
 case Pcons_sel(i) is
	

	when '1' =>
			mux_ram(i).o.addr_wr<=pcons_ram.o.addr_wr;
			mux_ram(i).o.addr_rd<=pcons_ram.o.addr_rd ; 
			mux_ram(i).o.we<=pcons_ram.o.we;
			if pcons_rd_start='1' then
			mux_ram(i).o.enb<=pcons_ram.o.enb;
			elsif pcons_wr_start='1' then
			  mux_ram(i).o.enb<=pcons_ram.o.ena;
			else
			  mux_ram(i).o.enb<='0';
			 end if;
			mux_ram(i).o.data_in<=pcons_ram.o.data_in;
			mux_hold_req(i)<=Pcons_Hold_req;
	when others =>
			mux_ram(i).o.addr_wr<=MPI_Node_out(i).Ram_address_wr;
			mux_ram(i).o.addr_rd<=MPI_Node_out(i).Ram_address_rd ; 
			mux_ram(i).o.we<=MPI_Node_out(i).Ram_we;
			mux_ram(i).o.enb<=MPI_Node_out(i).Ram_en;
			mux_ram(i).o.data_in<=MPI_Node_out(i).Ram_data_in;
			mux_hold_req(i)<=MPI_Node_out(i).Hold_req;		
end case ;
end loop;
end process ;
--criture dans la mmoire d'une tche matrielle
Inst_Fifo2Mem: Fifo2Mem PORT MAP(
		clk =>clkm ,
		reset =>reset ,
		wr_start =>pcons_wr_start ,
		fifo_data_out => rsin_fifo_dout,
		fifo_data_available =>rsin_fifo_data_available,
		datalen =>rs_plen ,
		fifo_data_out_en =>pcons_fin_rd_en,--rsin_fifo_rd_en ,
		fifo_empty =>'0' ,
		ram_busy => pcons_ram_busy, --not pcons_sel(pcons_ht) ,
		ram_addr_start =>rs_addr_start ,
		ram_addr =>pcons_ram.o.addr_wr,
		ram_data_in =>pcons_ram.o.data_in ,
		ram_wr =>pcons_ram.o.we ,
		ram_en =>pcons_ram.o.ena,
		wr_comp =>pcons_wr_comp 
	);
-- Lecture des donnes dans la RAM d'une tche
--ce process lit les donnes de la RAM et les charge dans le FIFO
 --copy from memory to fifo
Inst_Mem2fifo: entity mpi_hcl.Mem2fifo_a PORT MAP(
		clk =>clkm ,
		reset =>reset ,
 copy_mode =>'0', 
 snd_start=>pcons_rd_start, --dbut de la lecture
 snd_ack =>pcons_rd_ack,   -- acquittement de la lecture
 datalen => rs_plen, --la longueur du paquet
 ram_busy => pcons_ram_busy,
 ram_addr_start => rs_addr_start, --addresse de dbut du bloc de donne  copier
 fifo_out_empty=> rsout_fifo_empty,
 fifo_out_full => rsout_fifo_full,   --signaux pour le fifo de sortie
 fifo_out_wr_en => rsout_fifo_wr_en,  --criture autorise dans la fifo de sortie
 ram_in_rd_en => pcons_ram.o.enb, --lecture autorise dans la fifo d'entre
 ram_in_data_out=> pcons_ram.i.data_out,
 ram_in_addr_rd => pcons_ram.O.addr_rd, --addresse de la donne  copier
 fifo_out_data_in => rsout_fifo_din,
 snd_comp => pcons_rd_comp    -- fin de la lecture
 );


--dmultiplexeurs de la console pour accs  la RAM de chaque Tche matrielle.
Ram_dmux : process(mux_ram_d,dmux_hold_ack,PCons_sel,pcons_ht,clkm,reset,
dmux_instruction,dmux_instruction_en)
variable Tram_out:std_logic_vector(Word-1 downto 0):=(others=>'0');
begin
for i in 1 to PROC loop
case PCons_sel(i) is

when '1' => 	if pcons_ht=i then 
						Pcons_hold_ack<=dmux_hold_ack(i);
					end if;
					--Pcons_ram.I.data_out<=mux_ram(i).i.data_out;
					if pcons_ht=i then
					Pcons_ram.I.data_out<=mux_ram_d(i).i.data_out;
					else
					TRam_out:=Tram_out or mux_ram_d(i).i.data_out;
					Pcons_ram.I.data_out<=Pcons_ram.I.data_out;
					end if;
					MPI_Node_in(i).hold_ack<='0';
					MPI_Node_in(i).Ram_data_out<=(others=>'-');
when others => Pcons_hold_ack<='0';
					--Pcons_ram.I.data_out<=(others=>'-');
					TRam_out:=(others=>'-');
					MPI_Node_in(i).hold_ack<=dmux_hold_ack(i);
					MPI_Node_in(i).Ram_data_out<=mux_ram_d(i).i.data_out;				  
end case;
MPI_Node_in(i).reset<=reset;	
MPI_Node_in(i).clk<=clkm;
MPI_Node_in(i).instruction<=dmux_instruction(i);
MPI_Node_in(i).instruction_en<=dmux_instruction_en(i);
end loop;

end process;

sendrs232c_proc: process(clkm,reset,rsout_fifo_empty,rsout_fifo_dout,
uartrdy)
variable nib:natural range 0 to 1:=0;
variable rs_crlf : natural range 0 to 3:=0; --compte les derniers mots
   begin		
     
     if rising_edge(clkm) then
	  rsout_fifo_rd_en<='0';
	  uartSend<='0';
	  --UartData<=rsout_fifo_dout or x"AA";
	  if reset='1' then 
		et_send<=snd_wait;
		--rs_crlf:=0;
	  else
		case et_send is
		
			when snd_wait => --attente
			  --rs_crlf:=0;
			  if rsout_fifo_empty='0' then
				et_send<=snd_read;
				--rs_crlf:=2; --deux caractres  envoyer
				end if;
				
--			when snd_read =>  --lecture du mot
--				if unsigned(rsout_fifo_dout)>31 then 
--				  UartData<=rsout_fifo_dout ;
--				 else --rendre les codes observables en ASCII
--				  UartData<=rsout_fifo_dout or x"20";
--				end if;
--				
--				
--				rsout_fifo_rd_en<='1';
--				et_send<=snd_sendBit;
				
			when snd_sendbit=> --envoie du mot
			  
				UartSend<='1';
				if Uartrdy='1' and rsout_fifo_empty='0' then
					et_send<=snd_read;
				elsif UartRdy='1' then
					et_send<=snd_Cr; --fin de l'envoi
				end if;
			when snd_read =>
			if Nib=0 then --envoi du code ascii en mode hexa dcimal texte (Intel Hex)
				UartData<=Hex_to_ascii(rsout_fifo_dout(7 downto 4));
				nib:=1;
				rsout_fifo_rd_en<='0';
				et_send<=snd_sendBit;
			else
				UartData<=Hex_to_ascii(rsout_fifo_dout(3 downto 0));
				nib:=0;
				rsout_fifo_rd_en<='1';
				et_send<=snd_sendBit;
			end if;
			et_send<=snd_sendbit;
			When snd_Cr =>UartSend<='1';
				if UartRdy='1' then
					et_send<=snd_lf;
				end if;
				UartData<=x"0D";
			When snd_Lf =>UartSend<='1';
			if UartRdy='1' then
					et_send<=snd_wait;
				end if;
			UartData<=x"0A";
			when others =>

		end case;
	end if;
	end if;
end process;
-------------------------------------------------------------------
  --
  --  If Trigout port is selected
  --
  -------------------------------------------------------------------
  -- Trigger output logic triggers external test equipment and other logic.
  -- In this example, TRIG_OUT is used to view shift operation on VIO core.
  process (clk50)
  begin
    if (clk50'event and clk50='1') then
      if(trigout = '1') then
        syncin <= trig_0;
      end if;
    end if;
  end process;

END;