----------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM Roland Christian
-- 
-- Create Date:    21:20:54 07/16/2012 
-- Design Name: 
-- Module Name:    PE - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Ce module permet d'encapsuler une tche matrielle 
-- et lui donne la possiblit de communiquer  l'aide des fonctions MPI-2 RMA
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library NocLib ;
library Std;
--use IEEE.STD_LOGIC_ARITH.ALL;
--use IEEE.STD_LOGIC_UNSIGNED.ALL;
Library MPI_HCL;
use NocLib.CoreTypes.all;
use MPI_HCL.Packet_type.all;
use MPI_HCL.MPI_RMA.all;

-- synthesis translate_off 
use std.textio.all;
-- synthesis translate_on
use IEEE.NUMERIC_STD.ALL;


entity PE is
	Generic (DestId : natural:=0; --utiliser pour identifier la tche
				Use_dyn : natural:=0); --dtermine si le module est statique =0 ou reconfigurable =1
    Port ( Instruction : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : out  STD_LOGIC;
			  Core_PushOut : in STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			     CE : in STD_LOGIC; -- Active le  PE aprs sa synthse
				PE_in : in STD_LOGIC_VECTOR (Word-1 downto 0); --port GPIO pour le PE
				PE_out : out STD_LOGIC_VECTOR (Word-1 downto 0); --port GPIO pour le PE
           Core_RAM_Data_Out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_Out2: out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_In : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_WE : in  STD_LOGIC;
           Core_RAM_EN : in  STD_LOGIC;
           --Core_RAM_ENB : in  STD_LOGIC;
           Core_RAM_ADDRESS_WR : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_RAM_ADDRESS_RD : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_Hold_req : in  STD_LOGIC;
      			  ct_out : out  unsigned(7 downto 0);
			  ht_state : out typ_mae;
           Core_Hold_Ack : out  STD_LOGIC);
end PE;

architecture Behavioral of PE is
COMPONENT RAM_v
  generic (width : positive;size :positive);
	Port ( clka, clkb : in std_logic;
			  wea : in std_logic;
			  ena, enb : in std_logic;
			  addra, addrb : in std_logic_vector(size-1 downto 0); --cinq lignes d'adresse
			  dia : in std_logic_vector(width-1 downto 0);
			  dob : out std_logic_vector(width-1 downto 0));
	END COMPONENT;
COMPONENT memo8k8
  PORT (
    clka : IN STD_LOGIC;
    ena : IN STD_LOGIC;
    wea : IN STD_LOGIC_VECTOR(0 DOWNTO 0);
    addra : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
    dina : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
    clkb : IN STD_LOGIC;
    enb : IN STD_LOGIC;
    addrb : IN STD_LOGIC_VECTOR(12 DOWNTO 0);
    doutb : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)
  );
END COMPONENT;
COMPONENT HT_dyn is
		generic (Task_Id : natural);
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  en : in std_logic; -- active la tche
           Interf_i : in  core_i; --signaux pour l'interface I
           Interf_o : out  core_o; --signaux pour l'interface IO
           mem_i : in typ_dpram_i; -- signaux pour l'accs  la mmoire
           mem_o : out typ_dpram_o; -- signaux pour l'accs  la mmoire
			  ct_out : out unsigned(7 downto 0);
			  ht_state : out typ_mae;
				PE_in : in STD_LOGIC_VECTOR (Word-1 downto 0); --port GPIO pour le PE
				PE_out : out STD_LOGIC_VECTOR (Word-1 downto 0) --port GPIO pour le PE
			  );
end COMPONENT HT_dyn;
COMPONENT HT_stat is
		generic (Task_Id : natural);
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  en : in std_logic; -- active la tche
           Interf_i : in  core_i; --signaux pour l'interface I
           Interf_o : out  core_o; --signaux pour l'interface IO
           mem_i : in typ_dpram_i; -- signaux pour l'accs  la mmoire
           mem_o : out typ_dpram_o; -- signaux pour l'accs  la mmoire
			  ct_out :out unsigned(7 downto 0);
			  ht_state : out typ_mae;
			  PE_in : in STD_LOGIC_VECTOR (Word-1 downto 0); --port GPIO pour le PE
				PE_out : out STD_LOGIC_VECTOR (Word-1 downto 0) --port GPIO pour le PE
			  
			  );
end COMPONENT HT_stat;

COMPONENT Hold_FSM is
	
    Port ( Hold_Req : in  STD_LOGIC;
           Ram_busy : in  STD_LOGIC;
           Clk : in  STD_LOGIC;
           Reset : in  STD_LOGIC;
           Ramsel : out  STD_LOGIC;
           Hold_Ack : out  STD_LOGIC);
end COMPONENT Hold_FSM;
--donnes du programme PE
	   --signaux pour l'interconnexionsignal datain :std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_we ,ram_ena,ram_enb,ramsel_i: std_logic:='0';
	signal pe_ram_we ,pe_ram_ena,pe_ram_enb: std_logic;
	signal pe_instr_en,pe_hold_ack: std_logic:='0';
	signal ram_do,ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal pe_ram_do,pe_ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_addra,ram_addrb :std_logic_vector(ADRLEN-1 downto 0);
	signal pe_ram_addra,pe_ram_addrb :std_logic_vector(ADRLEN-1 downto 0);
	signal CRAM_DO : STD_LOGIC_VECTOR (Word-1 downto 0);
	signal sram : typ_dpram;
	signal clk_ht : std_logic;
	signal MyGroup:mpi_group;
	signal MyWin : mpi_win;
	signal SrcAdr0,SrcAdr1,destAdr0,destAdr1,Datalen:std_logic_vector(word-1 downto 0);
	--signal PE_out_i:std_logic_vector(Word-1 downto 0);
	signal dpid,dpid_i : natural range 0 to 15:=DestId;
	signal MyRank :std_logic_vector(3 downto 0);
	signal Libr : Core_io;  --regroupe tous les signaux IO de la bibliothque
	signal Lib_Ready:std_logic; --indique que l'excution de la fonction est termine
	signal Lib_instr_ack : std_logic; -- l'instruction est copie dans le tampon FIFO
	signal Lib_Init : std_logic; -- l'initialisation est termine 
	signal Lib_Enable : std_logic:='0';
	signal Ex1_run,Ex4_run : std_logic:='0'; --indique que ces modules sont en fin d'excution
	signal Hold_Ack : std_logic;
	signal en_task : std_logic;
	signal ht_reset :std_logic;
	signal raz_en:std_logic;--signal pour l'activation de la RAZ RAM
	signal m_count : natural:= 0;
 --signaux pour la gestion de la MAE
 type typ_Ht_ena is (ht_lock,ht_raz,ht_stop,ht_on);
 type typ_mae is (start,Fillmem,NextFill,InitApp,GetRank,WInCreate,WinStart, putdata,getdata,WinCompleted,finalize,st_timeout);
	type typ_Hld is (Ht_Lock,Core_Lock,Ht_free);
signal dcount : natural range 0 to 255:=0; 
signal wea : std_logic_vector (0 downto 0);
signal count,count_i : natural range 0 to 15:=0;
signal et_ht_ena : typ_ht_ena;

		signal RunState : typ_mae;
		signal Hld_state :typ_hld;
		signal Ram_busy :std_logic:='0';
begin
Ram8_k8: RAM_v generic map(width=>word,size=>ADRLEN)
	PORT MAP(
		clka =>clk ,
		clkb => clk ,
		wea => ram_we,
		ena => ram_ena,
		enb => ram_enb,
		addra => ram_addra,
		addrb =>ram_addrb,
		dia => ram_din,
		dob => ram_do 
	);
	--wea(0)<=ram_we;
--	Ram8_k8 : memo8k8
--  PORT MAP (
--    clka => clk,
--    ena => ram_ena,
--    wea => wea,
--    addra => ram_addra(12 downto 0),
--    dina => ram_din,
--    clkb => clk,
--    enb => ram_enb,
--    addrb => ram_addrb(12 downto 0),
--    doutb => ram_do
--  );
 ts: if use_dyn=0  generate
	HT_task:HT_stat generic map(Task_id =>DestId)
	port map (
	clk=>clk,
	reset=>ht_reset,
	en=>en_task,
   Interf_i =>Libr.i,
   Interf_o=>Libr.o,
  mem_i =>sram.i,
  
   mem_o =>sram.o,	
	ct_out=>ct_out,
	pe_in=>pe_in,
	pe_out=>pe_out,
	ht_state=>ht_state);
	
	end generate;
  td: if use_dyn=1 generate
	HT_task:HT_dyn generic map(Task_id =>DestId)
	port map (
	clk=>clk,
	reset=>ht_reset,
	en=>en_task,
   Interf_i =>Libr.i,
   Interf_o=>Libr.o,
  mem_i =>sram.i,
   mem_o =>sram.o,	
	ct_out=>ct_out,
	pe_in=>pe_in,
	pe_out=>pe_out,
	ht_state=>ht_state);
	
	end generate;
--================================================================
	--MUX de la RAM
                             	
Ram_mux: process (ramsel_i,pe_ram_addra,pe_ram_addrb,Core_ram_address_rd,Core_ram_address_wr,
						Core_ram_en,Core_ram_we,Core_ram_data_in,pe_ram_ena,pe_ram_enb,Ram_do,
						Pe_ram_din,Pe_ram_we	)
 begin 				
 case ramsel_i is
	
	when '1' =>
		ram_addra <= Core_ram_address_wr ;
		ram_addrb <= Core_ram_address_rd ;
		ram_ena <= Core_ram_en;
		ram_enb <= Core_ram_en;
		ram_we<= Core_ram_we;
		ram_din <= Core_ram_data_in;
		pe_ram_do<=(others=>'U');
		CRAM_DO<=ram_do;
		
	when others =>
		ram_addra <=  pe_ram_addra;
		ram_addrb <=  pe_ram_addrb;
		ram_ena <= pe_ram_ena;
		ram_enb <= pe_ram_enb;
		ram_we<= pe_ram_we;
		ram_din <=pe_ram_din;
		CRAM_DO<=(others=>'0');
		pe_ram_do<=ram_do;
end case ;

end process ;

process(CRAM_DO)
  begin
CORE_RAM_DATA_OUT<=CRAM_DO; 
end process;
CORE_RAM_DATA_OUT2<=CRAM_DO;
--Instruction_En<=PE_instr_EN; -- Libr.Instr_en; --********A changer **********
--=== !!!!! attention la suppression de la ligne ci-dessous empche ce 
-- composant de bien fonctionner !!! !!!!!!!!!!!!!!!!!!!!!!!
--instruction<=std_logic_vector(to_unsigned(Core_upper_adr,8));

dpid<=dpid_i;
Lib_Instr_ack<=Core_Pushout(0); --l'instruction a t copi
Lib_init<=Core_Pushout(4); -- Initialized
Lib_Enable<=Core_Pushout(6);-- HT active par la Librairie.
Ex1_Run<=Core_Pushout(5);  -- fin de l'excution de Ex1
Ex4_Run<=Core_pushout(7); -- fin de l'excution de Ex4 pour Spawn
horloge_ht:process (reset,en_task,clk)
begin
if reset='1' then
clk_ht<='0';
count<=0;
Ht_reset<='1';
else
if en_task='1' then
  clk_ht<=clk;
  if count=10 then --circuit de reset pour la  HT
    ht_reset<='0';
  else
  if rising_edge(clk) then
  count<=count+1;
  end if;
  ht_reset<='1';
  end if;
else
  count<=0;
  clk_ht<='0';
  Ht_reset<='1';
end if;
end if;
end process horloge_ht;

Hold1: Hold_fsm port map (
clk=>clk ,
reset =>reset,
Ram_Busy=>Ram_busy,
Hold_Ack=>Hold_Ack,
Hold_req =>Core_Hold_Req,
RamSel => RamSel_i);
Core_Hold_Ack<=Hold_Ack;

--================RAM signals ======================					
sram.I.data_out<=PE_ram_do;
--pe_Ram_addra<=sram.O.addr_wr;
--pe_Ram_addrb<=sram.O.addr_rd ; 
--PE_Ram_we<=sram.O.we;
--PE_Ram_ena<=sram.O.ena;
--PE_Ram_enb<=sram.O.enb;
--PE_ram_din<=sram.O.data_in;
--==========MPI HCL signals ============================
--RAZ de la RAM de communication
raz_ram: process(et_ht_ena,m_count,lib_enable,sram,reset,raz_en,
en_task,Core_hold_req,RamSel_i,Core_pushout,Libr.O)
--valeurs par dfaut !
begin
pe_Ram_addra<=sram.O.addr_wr;
pe_Ram_addrb<=sram.O.addr_rd ; 
PE_Ram_we<=sram.O.we;
PE_Ram_ena<=sram.O.ena;
PE_Ram_enb<=sram.O.enb;
PE_ram_din<=sram.O.data_in;

Instruction<=Libr.O.Instruction;		
Instruction_en<=Libr.O.Instr_en;	
Libr.I.Instr_ack<=Core_pushout(0);
Libr.I.InitOk<=Core_pushout(4);
Libr.I.Spawned<=Lib_enable;
Libr.I.Hold_Req<=Core_Hold_req;
Libr.I.RamSel<=RamSel_i;	
en_task<='0';
raz_en<='0';
--************************************
case et_ht_ena is
when ht_lock=>

--si le HT n'est pas activ ces valeurs sont  0 !
 Instruction<=(others=>'0');			
	Ram_busy<='0';
  PE_Instr_EN<='0'; 
when ht_raz =>
  
pe_Ram_addra<=std_logic_vector(to_unsigned(m_count,ADRLEN));
pe_Ram_addrb<=std_logic_vector(to_unsigned(m_count,ADRLEN)) ; 
PE_Ram_we<='1';
PE_Ram_ena<='1';
PE_Ram_enb<='1';
PE_ram_din<=(others=>'0');
raz_en<='1';
Libr.I.Instr_ack<='0';
Libr.I.InitOk<='0';
Libr.I.Spawned<=Lib_enable;
Libr.I.Hold_Req<='1';
Libr.I.RamSel<='1';	
when ht_stop =>
 en_task<='0'; 		
Instruction_en<='0';	
when ht_on=>
en_task<= '1'; --l'activation d'une HT peut tre directe ou commande

  Instruction<=Libr.O.Instruction;		
Instruction_en<=Libr.O.Instr_en;	
	Ram_busy<=Libr.O.membusy;
PE_Instr_EN<=Libr.O.instr_en;
pe_Ram_addra<=sram.O.addr_wr;
pe_Ram_addrb<=sram.O.addr_rd ; 
PE_Ram_we<=sram.O.we;
PE_Ram_ena<=sram.O.ena;
PE_Ram_enb<=sram.O.enb;
PE_ram_din<=sram.O.data_in;

assert not(Lib_enable='1')
report "Spawn Activ"
severity WARNING ;

end case;

end process;

ht_ena_proc:process (clk,reset)
begin
if (clk'event and clk='1') then 
case et_ht_ena is
when ht_lock=>
if CE='1' then
  et_ht_ena<=ht_raz;
elsif Lib_enable='1' then
  et_ht_ena<=ht_raz;
else 
  et_ht_ena<=ht_lock;
end if;

m_count<=core_base_adr; --adresse de base du Core MPI-HCL
when ht_raz=>
  if m_count<core_base_adr+1023 then
  m_count<=m_count+1;
else
  raz_en<='0';
  m_count<=core_base_adr;
  et_ht_ena<=ht_on;
end if;
When ht_stop =>
    if reset='1' then
        et_ht_ena<=ht_raz;
    elsif  CE='1' or Lib_enable='1' then
        et_ht_ena<=ht_on;
  end if;
when ht_on=>
   if reset='1' then 
     et_ht_ena<=ht_lock;
  elsif  CE='0' and Lib_enable='0' then
    et_ht_ena<=ht_stop;

  end if;
end case;
end if;
end process ht_ena_proc;
--=======================================================================
--MAE du PE
--=======================================================================

 
end Behavioral;

