----------------------------------------------------------------------------------
-- Company: 
-- Engineer: Kiegaing Emmanuel GEL EN5
-- 
-- Create Date:    18:18:09 03/19/2011 
-- Design Name: 
-- Module Name:    Arbiter - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- cellule d'arbitrage de l'ordonnanceur du crossbar
-- Dependencies: 
--
-- Revision: 1.0
-- a t ajout le signal fifo_full pour inclure la codition buffer pas plein dans
-- la cellules d'arbitrage
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Arbiter is
    Port ( P: in  STD_LOGIC;--vecteur de priorit
			  Fifo_full : in STD_LOGIC;
           Request : in  STD_LOGIC;-- demande de permission
           West : in  STD_LOGIC;-- verouillage ouest
           North : in  STD_LOGIC;--etc
           Grant : out  STD_LOGIC;-- validation de la transition
           East : out  STD_LOGIC;
           South : out  STD_LOGIC);
end Arbiter;

architecture Behavioral of Arbiter is
-- modelisation comportementale 3 LUT aprs synthse
-- ce module peut aussi facilement s'implmenter en flot de donnes
signal grant_signal : STD_LOGIC; 
--signal not_fifo_full : STD_LOGIC;
signal Mask : STD_LOGIC;
begin
--Grant<=grant_signal; -- Grant n'a pas t dclare InOut
Mask <= P AND (not Fifo_full);
process(Mask, Request, North, West)-- genere de la logique purement combinatoire
begin
if Mask ='0' then --cellule inactive
Grant <= '0';-- pas d'autorisation
South <= '1';
East <= '1';
   else
	Grant <= Request And North And West;
	South <= (North) And (Not (Request And North And West));	
	East  <= (West)  And (Not (Request And North And West));
end if;
end process;

end Behavioral;
--modlidation flot de donnes elle semble plus efficace 3 LUT
--architecture Behavioral of Arbiter is
--signal x, x1, x2, x3, x4, x5: STD_LOGIC; 
--begin
----equations logiques de la cellule
--x  <= Mask And Request;
--x1 <= North;
--x2 <= West;
--x3 <= x And x1 And x2;
--x4 <= x1 And (Not x3);
--x5 <= x2 And (Not x3);
--South <= x4 Or (Not Mask);
--East  <= x5 Or (Not Mask);
--Grant <= x3;
--
--end Behavioral;


