--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 


library IEEE;
use IEEE.STD_LOGIC_1164.all;

package conversions is

  
 -- type <new_type> is
  --  record
    --    <type_name>        : std_logic_vector( 7 downto 0);
      --  <type_name>        : std_logic;
    --end record;

-- Declare constants

  --constant <constant_name>		: time := <time_unit> ns;
  --constant <constant_name>		: integer := <value>;
 
-- Declare functions and procedure

  function to_uint ( a: in std_ulogic_vector) return integer;
  function to_vector (size: integer; val: integer) return std_ulogic_vector;
  
end conversions;


package body conversions is
  
    -- Convert a std_ulogic_vector to an unsigned integer
    --
    function to_uint (a: std_ulogic_vector) return integer is
        alias av: std_ulogic_vector (1 to a'length) is a;
        variable val: integer := 0;
        variable b: integer := 1;
    begin
        for i in a'length downto 1 loop
            if (av(i) = '1') then    -- if LSB is '1',
                val := val + b;       -- add value for current bit position
            end if;
            b := b * 2;    -- Shift left 1 bit
        end loop;
 
        return val;
    end to_uint;
 
-------------------------------------------------------- 
    -- Convert an integer to a std_ulogic_vector
    --
    function to_vector (size: integer; val: integer) return std_ulogic_vector is
        variable vec: std_ulogic_vector (1 to size);
        variable a: integer;
    begin
        a := val;
        for i in size downto 1 loop
            if ((a mod 2) = 1) then
                vec(i) := '1';
            else 
                vec(i) := '0';
            end if;
            a := a / 2;
        end loop;
        return vec;
    end to_vector;
 

 
end conversions;
