---------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    03:56:34 05/06/2011 
-- Design Name: 
-- Module Name:    Sheduler - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Module de l'ordonnanceur du switch crossbar
-- l'algorithme utilise est le DPA (diagonal propagation arbiter)
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use Work.Sheduler_package.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity Scheduler9_9 is
    Port ( Request : in  STD_LOGIC_VECTOR (81 downto 1);
		   Fifo_full : in STD_LOGIC_VECTOR (9 downto 1);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
            priority_rotation : in  STD_LOGIC_VECTOR (9 downto 1);
           port_grant : out  STD_LOGIC_VECTOR (81 downto 1));
end Scheduler9_9;

architecture Behavioral of Scheduler9_9 is
--Declaration du types
--tableau de signaux de connexion des cellules arbitres
TYPE C_Bar_Signal_Array IS ARRAY(17 downto 1) of STD_LOGIC_VECTOR(9 downto 1);
-- declaration du composant cellule d'arbitrage
Component Arbiter 
  PORT (P, Fifo_full,Request, West,North : in  STD_LOGIC;
        Grant,East,South : out  STD_LOGIC );
End Component;--Signaux de connexion des cellues
SIGNAL south_2_north :  C_Bar_Signal_Array; -- connexion south north 
SIGNAL east_2_west   :  C_Bar_Signal_Array; -- connexion east west 
SIGNAL Signal_mask      : C_Bar_Signal_Array;-- connexion des masques de priorit
SIGNAL Signal_grant     : C_Bar_Signal_Array;-- connexion des signaux de validation
SIGNAL Signal_priority  : STD_LOGIC_VECTOR (17 DOWNTO 1);--signal pour la connection des vecteur de priorit
SIGNAL High         : std_logic;--niveau pour les cellules des extremits nord et ouest 
 signal grant_latch : std_logic_vector(81 downto 1); 
 signal priority_rotation_en : std_logic; 
 signal Grant :  std_logic_vector(81 downto 1);
 begin

--validation de la rotation de priorit lorsque aucun port n'emet 
 priority_rotation_en <= '1' when unsigned(priority_rotation) = 511 else 	'0'; 
--latch servant qui memorise le signal grant pendant a transmission 
grant_latch_process : process(clk)
 begin 
  if rising_edge(clk) then 
   if reset = '1' then 
 		grant_latch <= (others => '0'); 
 	 elsif priority_rotation_en = '1' then 
	   grant_latch <= Grant; 
   end if; 
   end if; 
 end process; 
 port_grant <= Grant and grant_latch; 
 Grant(1)  <= Signal_grant(1)(1) or Signal_grant(10)(1); --  Grant(1,1)
Grant(2)  <= Signal_grant(2)(2) or Signal_grant(11)(2); --  Grant(1,2)
Grant(3)  <= Signal_grant(3)(3) or Signal_grant(12)(3); --  Grant(1,3)
Grant(4)  <= Signal_grant(4)(4) or Signal_grant(13)(4); --  Grant(1,4)
Grant(5)  <= Signal_grant(5)(5) or Signal_grant(14)(5); --  Grant(1,5)
Grant(6)  <= Signal_grant(6)(6) or Signal_grant(15)(6); --  Grant(1,6)
Grant(7)  <= Signal_grant(7)(7) or Signal_grant(16)(7); --  Grant(1,7)
Grant(8)  <= Signal_grant(8)(8) or Signal_grant(17)(8); --  Grant(1,8)
Grant(9)  <= Signal_grant(9)(9) ;                      --  Grant(1,9)
Grant(10)  <= Signal_grant(2)(1) or Signal_grant(11)(1); --  Grant(2,1)
Grant(11)  <= Signal_grant(3)(2) or Signal_grant(12)(2); --  Grant(2,2)
Grant(12)  <= Signal_grant(4)(3) or Signal_grant(13)(3); --  Grant(2,3)
Grant(13)  <= Signal_grant(5)(4) or Signal_grant(14)(4); --  Grant(2,4)
Grant(14)  <= Signal_grant(6)(5) or Signal_grant(15)(5); --  Grant(2,5)
Grant(15)  <= Signal_grant(7)(6) or Signal_grant(16)(6); --  Grant(2,6)
Grant(16)  <= Signal_grant(8)(7) or Signal_grant(17)(7); --  Grant(2,7)
Grant(17)  <= Signal_grant(9)(8) ;                      --  Grant(2,8)
Grant(18)  <= Signal_grant(1)(9) or Signal_grant(10)(9); --  Grant(2,9)
Grant(19)  <= Signal_grant(3)(1) or Signal_grant(12)(1); --  Grant(3,1)
Grant(20)  <= Signal_grant(4)(2) or Signal_grant(13)(2); --  Grant(3,2)
Grant(21)  <= Signal_grant(5)(3) or Signal_grant(14)(3); --  Grant(3,3)
Grant(22)  <= Signal_grant(6)(4) or Signal_grant(15)(4); --  Grant(3,4)
Grant(23)  <= Signal_grant(7)(5) or Signal_grant(16)(5); --  Grant(3,5)
Grant(24)  <= Signal_grant(8)(6) or Signal_grant(17)(6); --  Grant(3,6)
Grant(25)  <= Signal_grant(9)(7) ;                      --  Grant(3,7)
Grant(26)  <= Signal_grant(1)(8) or Signal_grant(10)(8); --  Grant(3,8)
Grant(27)  <= Signal_grant(2)(9) or Signal_grant(11)(9); --  Grant(3,9)
Grant(28)  <= Signal_grant(4)(1) or Signal_grant(13)(1); --  Grant(4,1)
Grant(29)  <= Signal_grant(5)(2) or Signal_grant(14)(2); --  Grant(4,2)
Grant(30)  <= Signal_grant(6)(3) or Signal_grant(15)(3); --  Grant(4,3)
Grant(31)  <= Signal_grant(7)(4) or Signal_grant(16)(4); --  Grant(4,4)
Grant(32)  <= Signal_grant(8)(5) or Signal_grant(17)(5); --  Grant(4,5)
Grant(33)  <= Signal_grant(9)(6) ;                      --  Grant(4,6)
Grant(34)  <= Signal_grant(1)(7) or Signal_grant(10)(7); --  Grant(4,7)
Grant(35)  <= Signal_grant(2)(8) or Signal_grant(11)(8); --  Grant(4,8)
Grant(36)  <= Signal_grant(3)(9) or Signal_grant(12)(9); --  Grant(4,9)
Grant(37)  <= Signal_grant(5)(1) or Signal_grant(14)(1); --  Grant(5,1)
Grant(38)  <= Signal_grant(6)(2) or Signal_grant(15)(2); --  Grant(5,2)
Grant(39)  <= Signal_grant(7)(3) or Signal_grant(16)(3); --  Grant(5,3)
Grant(40)  <= Signal_grant(8)(4) or Signal_grant(17)(4); --  Grant(5,4)
Grant(41)  <= Signal_grant(9)(5) ;                      --  Grant(5,5)
Grant(42)  <= Signal_grant(1)(6) or Signal_grant(10)(6); --  Grant(5,6)
Grant(43)  <= Signal_grant(2)(7) or Signal_grant(11)(7); --  Grant(5,7)
Grant(44)  <= Signal_grant(3)(8) or Signal_grant(12)(8); --  Grant(5,8)
Grant(45)  <= Signal_grant(4)(9) or Signal_grant(13)(9); --  Grant(5,9)
Grant(46)  <= Signal_grant(6)(1) or Signal_grant(15)(1); --  Grant(6,1)
Grant(47)  <= Signal_grant(7)(2) or Signal_grant(16)(2); --  Grant(6,2)
Grant(48)  <= Signal_grant(8)(3) or Signal_grant(17)(3); --  Grant(6,3)
Grant(49)  <= Signal_grant(9)(4) ;                      --  Grant(6,4)
Grant(50)  <= Signal_grant(1)(5) or Signal_grant(10)(5); --  Grant(6,5)
Grant(51)  <= Signal_grant(2)(6) or Signal_grant(11)(6); --  Grant(6,6)
Grant(52)  <= Signal_grant(3)(7) or Signal_grant(12)(7); --  Grant(6,7)
Grant(53)  <= Signal_grant(4)(8) or Signal_grant(13)(8); --  Grant(6,8)
Grant(54)  <= Signal_grant(5)(9) or Signal_grant(14)(9); --  Grant(6,9)
Grant(55)  <= Signal_grant(7)(1) or Signal_grant(16)(1); --  Grant(7,1)
Grant(56)  <= Signal_grant(8)(2) or Signal_grant(17)(2); --  Grant(7,2)
Grant(57)  <= Signal_grant(9)(3) ;                      --  Grant(7,3)
Grant(58)  <= Signal_grant(1)(4) or Signal_grant(10)(4); --  Grant(7,4)
Grant(59)  <= Signal_grant(2)(5) or Signal_grant(11)(5); --  Grant(7,5)
Grant(60)  <= Signal_grant(3)(6) or Signal_grant(12)(6); --  Grant(7,6)
Grant(61)  <= Signal_grant(4)(7) or Signal_grant(13)(7); --  Grant(7,7)
Grant(62)  <= Signal_grant(5)(8) or Signal_grant(14)(8); --  Grant(7,8)
Grant(63)  <= Signal_grant(6)(9) or Signal_grant(15)(9); --  Grant(7,9)
Grant(64)  <= Signal_grant(8)(1) or Signal_grant(17)(1); --  Grant(8,1)
Grant(65)  <= Signal_grant(9)(2) ;                      --  Grant(8,2)
Grant(66)  <= Signal_grant(1)(3) or Signal_grant(10)(3); --  Grant(8,3)
Grant(67)  <= Signal_grant(2)(4) or Signal_grant(11)(4); --  Grant(8,4)
Grant(68)  <= Signal_grant(3)(5) or Signal_grant(12)(5); --  Grant(8,5)
Grant(69)  <= Signal_grant(4)(6) or Signal_grant(13)(6); --  Grant(8,6)
Grant(70)  <= Signal_grant(5)(7) or Signal_grant(14)(7); --  Grant(8,7)
Grant(71)  <= Signal_grant(6)(8) or Signal_grant(15)(8); --  Grant(8,8)
Grant(72)  <= Signal_grant(7)(9) or Signal_grant(16)(9); --  Grant(8,9)
Grant(73)  <= Signal_grant(9)(1) ;                      --  Grant(9,1)
Grant(74)  <= Signal_grant(1)(2) or Signal_grant(10)(2); --  Grant(9,2)
Grant(75)  <= Signal_grant(2)(3) or Signal_grant(11)(3); --  Grant(9,3)
Grant(76)  <= Signal_grant(3)(4) or Signal_grant(12)(4); --  Grant(9,4)
Grant(77)  <= Signal_grant(4)(5) or Signal_grant(13)(5); --  Grant(9,5)
Grant(78)  <= Signal_grant(5)(6) or Signal_grant(14)(6); --  Grant(9,6)
Grant(79)  <= Signal_grant(6)(7) or Signal_grant(15)(7); --  Grant(9,7)
Grant(80)  <= Signal_grant(7)(8) or Signal_grant(16)(8); --  Grant(9,8)
Grant(81)  <= Signal_grant(8)(9) or Signal_grant(17)(9); --  Grant(9,9)
High <= '1';

----instantiations des cellules arbitres et interconnection

-------------------------- Diagonale n 1 


Arbiter_1_1 : Arbiter

PORT MAP (Request => Request(1), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(1),  
South => south_2_north(1)(1), East => east_2_west(1)(1) , Grant => Signal_grant(1)(1)); 

Arbiter_1_2 : Arbiter

PORT MAP (Request => Request(74), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(2),  
South => south_2_north(1)(2), East => east_2_west(1)(2) , Grant => Signal_grant(1)(2)); 

Arbiter_1_3 : Arbiter

PORT MAP (Request => Request(66), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(3),  
South => south_2_north(1)(3), East => east_2_west(1)(3) , Grant => Signal_grant(1)(3)); 

Arbiter_1_4 : Arbiter

PORT MAP (Request => Request(58), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(4),  
South => south_2_north(1)(4), East => east_2_west(1)(4) , Grant => Signal_grant(1)(4)); 

Arbiter_1_5 : Arbiter

PORT MAP (Request => Request(50), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(5),  
South => south_2_north(1)(5), East => east_2_west(1)(5) , Grant => Signal_grant(1)(5)); 

Arbiter_1_6 : Arbiter

PORT MAP (Request => Request(42), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(6),  
South => south_2_north(1)(6), East => east_2_west(1)(6) , Grant => Signal_grant(1)(6)); 

Arbiter_1_7 : Arbiter

PORT MAP (Request => Request(34), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(7),  
South => south_2_north(1)(7), East => east_2_west(1)(7) , Grant => Signal_grant(1)(7)); 

Arbiter_1_8 : Arbiter

PORT MAP (Request => Request(26), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(8),  
South => south_2_north(1)(8), East => east_2_west(1)(8) , Grant => Signal_grant(1)(8)); 

Arbiter_1_9 : Arbiter

PORT MAP (Request => Request(18), North => High, West => High, P => Signal_priority(17), Fifo_full => Fifo_full(9),  
South => south_2_north(1)(9), East => east_2_west(1)(9) , Grant => Signal_grant(1)(9)); 

-------------------------- Diagonale n 2 


Arbiter_2_1 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(1)(1), West => east_2_west(1)(9), P => Signal_priority(16), Fifo_full => Fifo_full(1),  
South => south_2_north(2)(1), East => east_2_west(2)(1) , Grant => Signal_grant(2)(1)); 

Arbiter_2_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(1)(2), West => east_2_west(1)(1), P => Signal_priority(16), Fifo_full => Fifo_full(2),  
South => south_2_north(2)(2), East => east_2_west(2)(2) , Grant => Signal_grant(2)(2)); 

Arbiter_2_3 : Arbiter

PORT MAP (Request => Request(75), North => south_2_north(1)(3), West => east_2_west(1)(2), P => Signal_priority(16), Fifo_full => Fifo_full(3),  
South => south_2_north(2)(3), East => east_2_west(2)(3) , Grant => Signal_grant(2)(3)); 

Arbiter_2_4 : Arbiter

PORT MAP (Request => Request(67), North => south_2_north(1)(4), West => east_2_west(1)(3), P => Signal_priority(16), Fifo_full => Fifo_full(4),  
South => south_2_north(2)(4), East => east_2_west(2)(4) , Grant => Signal_grant(2)(4)); 

Arbiter_2_5 : Arbiter

PORT MAP (Request => Request(59), North => south_2_north(1)(5), West => east_2_west(1)(4), P => Signal_priority(16), Fifo_full => Fifo_full(5),  
South => south_2_north(2)(5), East => east_2_west(2)(5) , Grant => Signal_grant(2)(5)); 

Arbiter_2_6 : Arbiter

PORT MAP (Request => Request(51), North => south_2_north(1)(6), West => east_2_west(1)(5), P => Signal_priority(16), Fifo_full => Fifo_full(6),  
South => south_2_north(2)(6), East => east_2_west(2)(6) , Grant => Signal_grant(2)(6)); 

Arbiter_2_7 : Arbiter

PORT MAP (Request => Request(43), North => south_2_north(1)(7), West => east_2_west(1)(6), P => Signal_priority(16), Fifo_full => Fifo_full(7),  
South => south_2_north(2)(7), East => east_2_west(2)(7) , Grant => Signal_grant(2)(7)); 

Arbiter_2_8 : Arbiter

PORT MAP (Request => Request(35), North => south_2_north(1)(8), West => east_2_west(1)(7), P => Signal_priority(16), Fifo_full => Fifo_full(8),  
South => south_2_north(2)(8), East => east_2_west(2)(8) , Grant => Signal_grant(2)(8)); 

Arbiter_2_9 : Arbiter

PORT MAP (Request => Request(27), North => south_2_north(1)(9), West => east_2_west(1)(8), P => Signal_priority(16), Fifo_full => Fifo_full(9),  
South => south_2_north(2)(9), East => east_2_west(2)(9) , Grant => Signal_grant(2)(9)); 

-------------------------- Diagonale n 3 


Arbiter_3_1 : Arbiter

PORT MAP (Request => Request(19), North => south_2_north(2)(1), West => east_2_west(2)(9), P => Signal_priority(15), Fifo_full => Fifo_full(1),  
South => south_2_north(3)(1), East => east_2_west(3)(1) , Grant => Signal_grant(3)(1)); 

Arbiter_3_2 : Arbiter

PORT MAP (Request => Request(11), North => south_2_north(2)(2), West => east_2_west(2)(1), P => Signal_priority(15), Fifo_full => Fifo_full(2),  
South => south_2_north(3)(2), East => east_2_west(3)(2) , Grant => Signal_grant(3)(2)); 

Arbiter_3_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(2)(3), West => east_2_west(2)(2), P => Signal_priority(15), Fifo_full => Fifo_full(3),  
South => south_2_north(3)(3), East => east_2_west(3)(3) , Grant => Signal_grant(3)(3)); 

Arbiter_3_4 : Arbiter

PORT MAP (Request => Request(76), North => south_2_north(2)(4), West => east_2_west(2)(3), P => Signal_priority(15), Fifo_full => Fifo_full(4),  
South => south_2_north(3)(4), East => east_2_west(3)(4) , Grant => Signal_grant(3)(4)); 

Arbiter_3_5 : Arbiter

PORT MAP (Request => Request(68), North => south_2_north(2)(5), West => east_2_west(2)(4), P => Signal_priority(15), Fifo_full => Fifo_full(5),  
South => south_2_north(3)(5), East => east_2_west(3)(5) , Grant => Signal_grant(3)(5)); 

Arbiter_3_6 : Arbiter

PORT MAP (Request => Request(60), North => south_2_north(2)(6), West => east_2_west(2)(5), P => Signal_priority(15), Fifo_full => Fifo_full(6),  
South => south_2_north(3)(6), East => east_2_west(3)(6) , Grant => Signal_grant(3)(6)); 

Arbiter_3_7 : Arbiter

PORT MAP (Request => Request(52), North => south_2_north(2)(7), West => east_2_west(2)(6), P => Signal_priority(15), Fifo_full => Fifo_full(7),  
South => south_2_north(3)(7), East => east_2_west(3)(7) , Grant => Signal_grant(3)(7)); 

Arbiter_3_8 : Arbiter

PORT MAP (Request => Request(44), North => south_2_north(2)(8), West => east_2_west(2)(7), P => Signal_priority(15), Fifo_full => Fifo_full(8),  
South => south_2_north(3)(8), East => east_2_west(3)(8) , Grant => Signal_grant(3)(8)); 

Arbiter_3_9 : Arbiter

PORT MAP (Request => Request(36), North => south_2_north(2)(9), West => east_2_west(2)(8), P => Signal_priority(15), Fifo_full => Fifo_full(9),  
South => south_2_north(3)(9), East => east_2_west(3)(9) , Grant => Signal_grant(3)(9)); 

-------------------------- Diagonale n 4 


Arbiter_4_1 : Arbiter

PORT MAP (Request => Request(28), North => south_2_north(3)(1), West => east_2_west(3)(9), P => Signal_priority(14), Fifo_full => Fifo_full(1),  
South => south_2_north(4)(1), East => east_2_west(4)(1) , Grant => Signal_grant(4)(1)); 

Arbiter_4_2 : Arbiter

PORT MAP (Request => Request(20), North => south_2_north(3)(2), West => east_2_west(3)(1), P => Signal_priority(14), Fifo_full => Fifo_full(2),  
South => south_2_north(4)(2), East => east_2_west(4)(2) , Grant => Signal_grant(4)(2)); 

Arbiter_4_3 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(3)(3), West => east_2_west(3)(2), P => Signal_priority(14), Fifo_full => Fifo_full(3),  
South => south_2_north(4)(3), East => east_2_west(4)(3) , Grant => Signal_grant(4)(3)); 

Arbiter_4_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(3)(4), West => east_2_west(3)(3), P => Signal_priority(14), Fifo_full => Fifo_full(4),  
South => south_2_north(4)(4), East => east_2_west(4)(4) , Grant => Signal_grant(4)(4)); 

Arbiter_4_5 : Arbiter

PORT MAP (Request => Request(77), North => south_2_north(3)(5), West => east_2_west(3)(4), P => Signal_priority(14), Fifo_full => Fifo_full(5),  
South => south_2_north(4)(5), East => east_2_west(4)(5) , Grant => Signal_grant(4)(5)); 

Arbiter_4_6 : Arbiter

PORT MAP (Request => Request(69), North => south_2_north(3)(6), West => east_2_west(3)(5), P => Signal_priority(14), Fifo_full => Fifo_full(6),  
South => south_2_north(4)(6), East => east_2_west(4)(6) , Grant => Signal_grant(4)(6)); 

Arbiter_4_7 : Arbiter

PORT MAP (Request => Request(61), North => south_2_north(3)(7), West => east_2_west(3)(6), P => Signal_priority(14), Fifo_full => Fifo_full(7),  
South => south_2_north(4)(7), East => east_2_west(4)(7) , Grant => Signal_grant(4)(7)); 

Arbiter_4_8 : Arbiter

PORT MAP (Request => Request(53), North => south_2_north(3)(8), West => east_2_west(3)(7), P => Signal_priority(14), Fifo_full => Fifo_full(8),  
South => south_2_north(4)(8), East => east_2_west(4)(8) , Grant => Signal_grant(4)(8)); 

Arbiter_4_9 : Arbiter

PORT MAP (Request => Request(45), North => south_2_north(3)(9), West => east_2_west(3)(8), P => Signal_priority(14), Fifo_full => Fifo_full(9),  
South => south_2_north(4)(9), East => east_2_west(4)(9) , Grant => Signal_grant(4)(9)); 

-------------------------- Diagonale n 5 


Arbiter_5_1 : Arbiter

PORT MAP (Request => Request(37), North => south_2_north(4)(1), West => east_2_west(4)(9), P => Signal_priority(13), Fifo_full => Fifo_full(1),  
South => south_2_north(5)(1), East => east_2_west(5)(1) , Grant => Signal_grant(5)(1)); 

Arbiter_5_2 : Arbiter

PORT MAP (Request => Request(29), North => south_2_north(4)(2), West => east_2_west(4)(1), P => Signal_priority(13), Fifo_full => Fifo_full(2),  
South => south_2_north(5)(2), East => east_2_west(5)(2) , Grant => Signal_grant(5)(2)); 

Arbiter_5_3 : Arbiter

PORT MAP (Request => Request(21), North => south_2_north(4)(3), West => east_2_west(4)(2), P => Signal_priority(13), Fifo_full => Fifo_full(3),  
South => south_2_north(5)(3), East => east_2_west(5)(3) , Grant => Signal_grant(5)(3)); 

Arbiter_5_4 : Arbiter

PORT MAP (Request => Request(13), North => south_2_north(4)(4), West => east_2_west(4)(3), P => Signal_priority(13), Fifo_full => Fifo_full(4),  
South => south_2_north(5)(4), East => east_2_west(5)(4) , Grant => Signal_grant(5)(4)); 

Arbiter_5_5 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(4)(5), West => east_2_west(4)(4), P => Signal_priority(13), Fifo_full => Fifo_full(5),  
South => south_2_north(5)(5), East => east_2_west(5)(5) , Grant => Signal_grant(5)(5)); 

Arbiter_5_6 : Arbiter

PORT MAP (Request => Request(78), North => south_2_north(4)(6), West => east_2_west(4)(5), P => Signal_priority(13), Fifo_full => Fifo_full(6),  
South => south_2_north(5)(6), East => east_2_west(5)(6) , Grant => Signal_grant(5)(6)); 

Arbiter_5_7 : Arbiter

PORT MAP (Request => Request(70), North => south_2_north(4)(7), West => east_2_west(4)(6), P => Signal_priority(13), Fifo_full => Fifo_full(7),  
South => south_2_north(5)(7), East => east_2_west(5)(7) , Grant => Signal_grant(5)(7)); 

Arbiter_5_8 : Arbiter

PORT MAP (Request => Request(62), North => south_2_north(4)(8), West => east_2_west(4)(7), P => Signal_priority(13), Fifo_full => Fifo_full(8),  
South => south_2_north(5)(8), East => east_2_west(5)(8) , Grant => Signal_grant(5)(8)); 

Arbiter_5_9 : Arbiter

PORT MAP (Request => Request(54), North => south_2_north(4)(9), West => east_2_west(4)(8), P => Signal_priority(13), Fifo_full => Fifo_full(9),  
South => south_2_north(5)(9), East => east_2_west(5)(9) , Grant => Signal_grant(5)(9)); 

-------------------------- Diagonale n 6 


Arbiter_6_1 : Arbiter

PORT MAP (Request => Request(46), North => south_2_north(5)(1), West => east_2_west(5)(9), P => Signal_priority(12), Fifo_full => Fifo_full(1),  
South => south_2_north(6)(1), East => east_2_west(6)(1) , Grant => Signal_grant(6)(1)); 

Arbiter_6_2 : Arbiter

PORT MAP (Request => Request(38), North => south_2_north(5)(2), West => east_2_west(5)(1), P => Signal_priority(12), Fifo_full => Fifo_full(2),  
South => south_2_north(6)(2), East => east_2_west(6)(2) , Grant => Signal_grant(6)(2)); 

Arbiter_6_3 : Arbiter

PORT MAP (Request => Request(30), North => south_2_north(5)(3), West => east_2_west(5)(2), P => Signal_priority(12), Fifo_full => Fifo_full(3),  
South => south_2_north(6)(3), East => east_2_west(6)(3) , Grant => Signal_grant(6)(3)); 

Arbiter_6_4 : Arbiter

PORT MAP (Request => Request(22), North => south_2_north(5)(4), West => east_2_west(5)(3), P => Signal_priority(12), Fifo_full => Fifo_full(4),  
South => south_2_north(6)(4), East => east_2_west(6)(4) , Grant => Signal_grant(6)(4)); 

Arbiter_6_5 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(5)(5), West => east_2_west(5)(4), P => Signal_priority(12), Fifo_full => Fifo_full(5),  
South => south_2_north(6)(5), East => east_2_west(6)(5) , Grant => Signal_grant(6)(5)); 

Arbiter_6_6 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(5)(6), West => east_2_west(5)(5), P => Signal_priority(12), Fifo_full => Fifo_full(6),  
South => south_2_north(6)(6), East => east_2_west(6)(6) , Grant => Signal_grant(6)(6)); 

Arbiter_6_7 : Arbiter

PORT MAP (Request => Request(79), North => south_2_north(5)(7), West => east_2_west(5)(6), P => Signal_priority(12), Fifo_full => Fifo_full(7),  
South => south_2_north(6)(7), East => east_2_west(6)(7) , Grant => Signal_grant(6)(7)); 

Arbiter_6_8 : Arbiter

PORT MAP (Request => Request(71), North => south_2_north(5)(8), West => east_2_west(5)(7), P => Signal_priority(12), Fifo_full => Fifo_full(8),  
South => south_2_north(6)(8), East => east_2_west(6)(8) , Grant => Signal_grant(6)(8)); 

Arbiter_6_9 : Arbiter

PORT MAP (Request => Request(63), North => south_2_north(5)(9), West => east_2_west(5)(8), P => Signal_priority(12), Fifo_full => Fifo_full(9),  
South => south_2_north(6)(9), East => east_2_west(6)(9) , Grant => Signal_grant(6)(9)); 

-------------------------- Diagonale n 7 


Arbiter_7_1 : Arbiter

PORT MAP (Request => Request(55), North => south_2_north(6)(1), West => east_2_west(6)(9), P => Signal_priority(11), Fifo_full => Fifo_full(1),  
South => south_2_north(7)(1), East => east_2_west(7)(1) , Grant => Signal_grant(7)(1)); 

Arbiter_7_2 : Arbiter

PORT MAP (Request => Request(47), North => south_2_north(6)(2), West => east_2_west(6)(1), P => Signal_priority(11), Fifo_full => Fifo_full(2),  
South => south_2_north(7)(2), East => east_2_west(7)(2) , Grant => Signal_grant(7)(2)); 

Arbiter_7_3 : Arbiter

PORT MAP (Request => Request(39), North => south_2_north(6)(3), West => east_2_west(6)(2), P => Signal_priority(11), Fifo_full => Fifo_full(3),  
South => south_2_north(7)(3), East => east_2_west(7)(3) , Grant => Signal_grant(7)(3)); 

Arbiter_7_4 : Arbiter

PORT MAP (Request => Request(31), North => south_2_north(6)(4), West => east_2_west(6)(3), P => Signal_priority(11), Fifo_full => Fifo_full(4),  
South => south_2_north(7)(4), East => east_2_west(7)(4) , Grant => Signal_grant(7)(4)); 

Arbiter_7_5 : Arbiter

PORT MAP (Request => Request(23), North => south_2_north(6)(5), West => east_2_west(6)(4), P => Signal_priority(11), Fifo_full => Fifo_full(5),  
South => south_2_north(7)(5), East => east_2_west(7)(5) , Grant => Signal_grant(7)(5)); 

Arbiter_7_6 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(6)(6), West => east_2_west(6)(5), P => Signal_priority(11), Fifo_full => Fifo_full(6),  
South => south_2_north(7)(6), East => east_2_west(7)(6) , Grant => Signal_grant(7)(6)); 

Arbiter_7_7 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(6)(7), West => east_2_west(6)(6), P => Signal_priority(11), Fifo_full => Fifo_full(7),  
South => south_2_north(7)(7), East => east_2_west(7)(7) , Grant => Signal_grant(7)(7)); 

Arbiter_7_8 : Arbiter

PORT MAP (Request => Request(80), North => south_2_north(6)(8), West => east_2_west(6)(7), P => Signal_priority(11), Fifo_full => Fifo_full(8),  
South => south_2_north(7)(8), East => east_2_west(7)(8) , Grant => Signal_grant(7)(8)); 

Arbiter_7_9 : Arbiter

PORT MAP (Request => Request(72), North => south_2_north(6)(9), West => east_2_west(6)(8), P => Signal_priority(11), Fifo_full => Fifo_full(9),  
South => south_2_north(7)(9), East => east_2_west(7)(9) , Grant => Signal_grant(7)(9)); 

-------------------------- Diagonale n 8 


Arbiter_8_1 : Arbiter

PORT MAP (Request => Request(64), North => south_2_north(7)(1), West => east_2_west(7)(9), P => Signal_priority(10), Fifo_full => Fifo_full(1),  
South => south_2_north(8)(1), East => east_2_west(8)(1) , Grant => Signal_grant(8)(1)); 

Arbiter_8_2 : Arbiter

PORT MAP (Request => Request(56), North => south_2_north(7)(2), West => east_2_west(7)(1), P => Signal_priority(10), Fifo_full => Fifo_full(2),  
South => south_2_north(8)(2), East => east_2_west(8)(2) , Grant => Signal_grant(8)(2)); 

Arbiter_8_3 : Arbiter

PORT MAP (Request => Request(48), North => south_2_north(7)(3), West => east_2_west(7)(2), P => Signal_priority(10), Fifo_full => Fifo_full(3),  
South => south_2_north(8)(3), East => east_2_west(8)(3) , Grant => Signal_grant(8)(3)); 

Arbiter_8_4 : Arbiter

PORT MAP (Request => Request(40), North => south_2_north(7)(4), West => east_2_west(7)(3), P => Signal_priority(10), Fifo_full => Fifo_full(4),  
South => south_2_north(8)(4), East => east_2_west(8)(4) , Grant => Signal_grant(8)(4)); 

Arbiter_8_5 : Arbiter

PORT MAP (Request => Request(32), North => south_2_north(7)(5), West => east_2_west(7)(4), P => Signal_priority(10), Fifo_full => Fifo_full(5),  
South => south_2_north(8)(5), East => east_2_west(8)(5) , Grant => Signal_grant(8)(5)); 

Arbiter_8_6 : Arbiter

PORT MAP (Request => Request(24), North => south_2_north(7)(6), West => east_2_west(7)(5), P => Signal_priority(10), Fifo_full => Fifo_full(6),  
South => south_2_north(8)(6), East => east_2_west(8)(6) , Grant => Signal_grant(8)(6)); 

Arbiter_8_7 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(7)(7), West => east_2_west(7)(6), P => Signal_priority(10), Fifo_full => Fifo_full(7),  
South => south_2_north(8)(7), East => east_2_west(8)(7) , Grant => Signal_grant(8)(7)); 

Arbiter_8_8 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(7)(8), West => east_2_west(7)(7), P => Signal_priority(10), Fifo_full => Fifo_full(8),  
South => south_2_north(8)(8), East => east_2_west(8)(8) , Grant => Signal_grant(8)(8)); 

Arbiter_8_9 : Arbiter

PORT MAP (Request => Request(81), North => south_2_north(7)(9), West => east_2_west(7)(8), P => Signal_priority(10), Fifo_full => Fifo_full(9),  
South => south_2_north(8)(9), East => east_2_west(8)(9) , Grant => Signal_grant(8)(9)); 

-------------------------- Diagonale n 9 


Arbiter_9_1 : Arbiter

PORT MAP (Request => Request(73), North => south_2_north(8)(1), West => east_2_west(8)(9), P => Signal_priority(9), Fifo_full => Fifo_full(1),  
South => south_2_north(9)(1), East => east_2_west(9)(1) , Grant => Signal_grant(9)(1)); 

Arbiter_9_2 : Arbiter

PORT MAP (Request => Request(65), North => south_2_north(8)(2), West => east_2_west(8)(1), P => Signal_priority(9), Fifo_full => Fifo_full(2),  
South => south_2_north(9)(2), East => east_2_west(9)(2) , Grant => Signal_grant(9)(2)); 

Arbiter_9_3 : Arbiter

PORT MAP (Request => Request(57), North => south_2_north(8)(3), West => east_2_west(8)(2), P => Signal_priority(9), Fifo_full => Fifo_full(3),  
South => south_2_north(9)(3), East => east_2_west(9)(3) , Grant => Signal_grant(9)(3)); 

Arbiter_9_4 : Arbiter

PORT MAP (Request => Request(49), North => south_2_north(8)(4), West => east_2_west(8)(3), P => Signal_priority(9), Fifo_full => Fifo_full(4),  
South => south_2_north(9)(4), East => east_2_west(9)(4) , Grant => Signal_grant(9)(4)); 

Arbiter_9_5 : Arbiter

PORT MAP (Request => Request(41), North => south_2_north(8)(5), West => east_2_west(8)(4), P => Signal_priority(9), Fifo_full => Fifo_full(5),  
South => south_2_north(9)(5), East => east_2_west(9)(5) , Grant => Signal_grant(9)(5)); 

Arbiter_9_6 : Arbiter

PORT MAP (Request => Request(33), North => south_2_north(8)(6), West => east_2_west(8)(5), P => Signal_priority(9), Fifo_full => Fifo_full(6),  
South => south_2_north(9)(6), East => east_2_west(9)(6) , Grant => Signal_grant(9)(6)); 

Arbiter_9_7 : Arbiter

PORT MAP (Request => Request(25), North => south_2_north(8)(7), West => east_2_west(8)(6), P => Signal_priority(9), Fifo_full => Fifo_full(7),  
South => south_2_north(9)(7), East => east_2_west(9)(7) , Grant => Signal_grant(9)(7)); 

Arbiter_9_8 : Arbiter

PORT MAP (Request => Request(17), North => south_2_north(8)(8), West => east_2_west(8)(7), P => Signal_priority(9), Fifo_full => Fifo_full(8),  
South => south_2_north(9)(8), East => east_2_west(9)(8) , Grant => Signal_grant(9)(8)); 

Arbiter_9_9 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(8)(9), West => east_2_west(8)(8), P => Signal_priority(9), Fifo_full => Fifo_full(9),  
South => south_2_north(9)(9), East => east_2_west(9)(9) , Grant => Signal_grant(9)(9)); 

-------------------------- Diagonale n 10 


Arbiter_10_1 : Arbiter

PORT MAP (Request => Request(1), North => south_2_north(9)(1), West => east_2_west(9)(9), P => Signal_priority(8), Fifo_full => Fifo_full(1),  
South => south_2_north(10)(1), East => east_2_west(10)(1) , Grant => Signal_grant(10)(1)); 

Arbiter_10_2 : Arbiter

PORT MAP (Request => Request(74), North => south_2_north(9)(2), West => east_2_west(9)(1), P => Signal_priority(8), Fifo_full => Fifo_full(2),  
South => south_2_north(10)(2), East => east_2_west(10)(2) , Grant => Signal_grant(10)(2)); 

Arbiter_10_3 : Arbiter

PORT MAP (Request => Request(66), North => south_2_north(9)(3), West => east_2_west(9)(2), P => Signal_priority(8), Fifo_full => Fifo_full(3),  
South => south_2_north(10)(3), East => east_2_west(10)(3) , Grant => Signal_grant(10)(3)); 

Arbiter_10_4 : Arbiter

PORT MAP (Request => Request(58), North => south_2_north(9)(4), West => east_2_west(9)(3), P => Signal_priority(8), Fifo_full => Fifo_full(4),  
South => south_2_north(10)(4), East => east_2_west(10)(4) , Grant => Signal_grant(10)(4)); 

Arbiter_10_5 : Arbiter

PORT MAP (Request => Request(50), North => south_2_north(9)(5), West => east_2_west(9)(4), P => Signal_priority(8), Fifo_full => Fifo_full(5),  
South => south_2_north(10)(5), East => east_2_west(10)(5) , Grant => Signal_grant(10)(5)); 

Arbiter_10_6 : Arbiter

PORT MAP (Request => Request(42), North => south_2_north(9)(6), West => east_2_west(9)(5), P => Signal_priority(8), Fifo_full => Fifo_full(6),  
South => south_2_north(10)(6), East => east_2_west(10)(6) , Grant => Signal_grant(10)(6)); 

Arbiter_10_7 : Arbiter

PORT MAP (Request => Request(34), North => south_2_north(9)(7), West => east_2_west(9)(6), P => Signal_priority(8), Fifo_full => Fifo_full(7),  
South => south_2_north(10)(7), East => east_2_west(10)(7) , Grant => Signal_grant(10)(7)); 

Arbiter_10_8 : Arbiter

PORT MAP (Request => Request(26), North => south_2_north(9)(8), West => east_2_west(9)(7), P => Signal_priority(8), Fifo_full => Fifo_full(8),  
South => south_2_north(10)(8), East => east_2_west(10)(8) , Grant => Signal_grant(10)(8)); 

Arbiter_10_9 : Arbiter

PORT MAP (Request => Request(18), North => south_2_north(9)(9), West => east_2_west(9)(8), P => Signal_priority(8), Fifo_full => Fifo_full(9),  
South => south_2_north(10)(9), East => east_2_west(10)(9) , Grant => Signal_grant(10)(9)); 

-------------------------- Diagonale n 11 


Arbiter_11_1 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(10)(1), West => east_2_west(10)(9), P => Signal_priority(7), Fifo_full => Fifo_full(1),  
South => south_2_north(11)(1), East => east_2_west(11)(1) , Grant => Signal_grant(11)(1)); 

Arbiter_11_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(10)(2), West => east_2_west(10)(1), P => Signal_priority(7), Fifo_full => Fifo_full(2),  
South => south_2_north(11)(2), East => east_2_west(11)(2) , Grant => Signal_grant(11)(2)); 

Arbiter_11_3 : Arbiter

PORT MAP (Request => Request(75), North => south_2_north(10)(3), West => east_2_west(10)(2), P => Signal_priority(7), Fifo_full => Fifo_full(3),  
South => south_2_north(11)(3), East => east_2_west(11)(3) , Grant => Signal_grant(11)(3)); 

Arbiter_11_4 : Arbiter

PORT MAP (Request => Request(67), North => south_2_north(10)(4), West => east_2_west(10)(3), P => Signal_priority(7), Fifo_full => Fifo_full(4),  
South => south_2_north(11)(4), East => east_2_west(11)(4) , Grant => Signal_grant(11)(4)); 

Arbiter_11_5 : Arbiter

PORT MAP (Request => Request(59), North => south_2_north(10)(5), West => east_2_west(10)(4), P => Signal_priority(7), Fifo_full => Fifo_full(5),  
South => south_2_north(11)(5), East => east_2_west(11)(5) , Grant => Signal_grant(11)(5)); 

Arbiter_11_6 : Arbiter

PORT MAP (Request => Request(51), North => south_2_north(10)(6), West => east_2_west(10)(5), P => Signal_priority(7), Fifo_full => Fifo_full(6),  
South => south_2_north(11)(6), East => east_2_west(11)(6) , Grant => Signal_grant(11)(6)); 

Arbiter_11_7 : Arbiter

PORT MAP (Request => Request(43), North => south_2_north(10)(7), West => east_2_west(10)(6), P => Signal_priority(7), Fifo_full => Fifo_full(7),  
South => south_2_north(11)(7), East => east_2_west(11)(7) , Grant => Signal_grant(11)(7)); 

Arbiter_11_8 : Arbiter

PORT MAP (Request => Request(35), North => south_2_north(10)(8), West => east_2_west(10)(7), P => Signal_priority(7), Fifo_full => Fifo_full(8),  
South => south_2_north(11)(8), East => east_2_west(11)(8) , Grant => Signal_grant(11)(8)); 

Arbiter_11_9 : Arbiter

PORT MAP (Request => Request(27), North => south_2_north(10)(9), West => east_2_west(10)(8), P => Signal_priority(7), Fifo_full => Fifo_full(9),  
South => south_2_north(11)(9), East => east_2_west(11)(9) , Grant => Signal_grant(11)(9)); 

-------------------------- Diagonale n 12 


Arbiter_12_1 : Arbiter

PORT MAP (Request => Request(19), North => south_2_north(11)(1), West => east_2_west(11)(9), P => Signal_priority(6), Fifo_full => Fifo_full(1),  
South => south_2_north(12)(1), East => east_2_west(12)(1) , Grant => Signal_grant(12)(1)); 

Arbiter_12_2 : Arbiter

PORT MAP (Request => Request(11), North => south_2_north(11)(2), West => east_2_west(11)(1), P => Signal_priority(6), Fifo_full => Fifo_full(2),  
South => south_2_north(12)(2), East => east_2_west(12)(2) , Grant => Signal_grant(12)(2)); 

Arbiter_12_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(11)(3), West => east_2_west(11)(2), P => Signal_priority(6), Fifo_full => Fifo_full(3),  
South => south_2_north(12)(3), East => east_2_west(12)(3) , Grant => Signal_grant(12)(3)); 

Arbiter_12_4 : Arbiter

PORT MAP (Request => Request(76), North => south_2_north(11)(4), West => east_2_west(11)(3), P => Signal_priority(6), Fifo_full => Fifo_full(4),  
South => south_2_north(12)(4), East => east_2_west(12)(4) , Grant => Signal_grant(12)(4)); 

Arbiter_12_5 : Arbiter

PORT MAP (Request => Request(68), North => south_2_north(11)(5), West => east_2_west(11)(4), P => Signal_priority(6), Fifo_full => Fifo_full(5),  
South => south_2_north(12)(5), East => east_2_west(12)(5) , Grant => Signal_grant(12)(5)); 

Arbiter_12_6 : Arbiter

PORT MAP (Request => Request(60), North => south_2_north(11)(6), West => east_2_west(11)(5), P => Signal_priority(6), Fifo_full => Fifo_full(6),  
South => south_2_north(12)(6), East => east_2_west(12)(6) , Grant => Signal_grant(12)(6)); 

Arbiter_12_7 : Arbiter

PORT MAP (Request => Request(52), North => south_2_north(11)(7), West => east_2_west(11)(6), P => Signal_priority(6), Fifo_full => Fifo_full(7),  
South => south_2_north(12)(7), East => east_2_west(12)(7) , Grant => Signal_grant(12)(7)); 

Arbiter_12_8 : Arbiter

PORT MAP (Request => Request(44), North => south_2_north(11)(8), West => east_2_west(11)(7), P => Signal_priority(6), Fifo_full => Fifo_full(8),  
South => south_2_north(12)(8), East => east_2_west(12)(8) , Grant => Signal_grant(12)(8)); 

Arbiter_12_9 : Arbiter

PORT MAP (Request => Request(36), North => south_2_north(11)(9), West => east_2_west(11)(8), P => Signal_priority(6), Fifo_full => Fifo_full(9),  
South => south_2_north(12)(9), East => east_2_west(12)(9) , Grant => Signal_grant(12)(9)); 

-------------------------- Diagonale n 13 


Arbiter_13_1 : Arbiter

PORT MAP (Request => Request(28), North => south_2_north(12)(1), West => east_2_west(12)(9), P => Signal_priority(5), Fifo_full => Fifo_full(1),  
South => south_2_north(13)(1), East => east_2_west(13)(1) , Grant => Signal_grant(13)(1)); 

Arbiter_13_2 : Arbiter

PORT MAP (Request => Request(20), North => south_2_north(12)(2), West => east_2_west(12)(1), P => Signal_priority(5), Fifo_full => Fifo_full(2),  
South => south_2_north(13)(2), East => east_2_west(13)(2) , Grant => Signal_grant(13)(2)); 

Arbiter_13_3 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(12)(3), West => east_2_west(12)(2), P => Signal_priority(5), Fifo_full => Fifo_full(3),  
South => south_2_north(13)(3), East => east_2_west(13)(3) , Grant => Signal_grant(13)(3)); 

Arbiter_13_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(12)(4), West => east_2_west(12)(3), P => Signal_priority(5), Fifo_full => Fifo_full(4),  
South => south_2_north(13)(4), East => east_2_west(13)(4) , Grant => Signal_grant(13)(4)); 

Arbiter_13_5 : Arbiter

PORT MAP (Request => Request(77), North => south_2_north(12)(5), West => east_2_west(12)(4), P => Signal_priority(5), Fifo_full => Fifo_full(5),  
South => south_2_north(13)(5), East => east_2_west(13)(5) , Grant => Signal_grant(13)(5)); 

Arbiter_13_6 : Arbiter

PORT MAP (Request => Request(69), North => south_2_north(12)(6), West => east_2_west(12)(5), P => Signal_priority(5), Fifo_full => Fifo_full(6),  
South => south_2_north(13)(6), East => east_2_west(13)(6) , Grant => Signal_grant(13)(6)); 

Arbiter_13_7 : Arbiter

PORT MAP (Request => Request(61), North => south_2_north(12)(7), West => east_2_west(12)(6), P => Signal_priority(5), Fifo_full => Fifo_full(7),  
South => south_2_north(13)(7), East => east_2_west(13)(7) , Grant => Signal_grant(13)(7)); 

Arbiter_13_8 : Arbiter

PORT MAP (Request => Request(53), North => south_2_north(12)(8), West => east_2_west(12)(7), P => Signal_priority(5), Fifo_full => Fifo_full(8),  
South => south_2_north(13)(8), East => east_2_west(13)(8) , Grant => Signal_grant(13)(8)); 

Arbiter_13_9 : Arbiter

PORT MAP (Request => Request(45), North => south_2_north(12)(9), West => east_2_west(12)(8), P => Signal_priority(5), Fifo_full => Fifo_full(9),  
South => south_2_north(13)(9), East => east_2_west(13)(9) , Grant => Signal_grant(13)(9)); 

-------------------------- Diagonale n 14 


Arbiter_14_1 : Arbiter

PORT MAP (Request => Request(37), North => south_2_north(13)(1), West => east_2_west(13)(9), P => Signal_priority(4), Fifo_full => Fifo_full(1),  
South => south_2_north(14)(1), East => east_2_west(14)(1) , Grant => Signal_grant(14)(1)); 

Arbiter_14_2 : Arbiter

PORT MAP (Request => Request(29), North => south_2_north(13)(2), West => east_2_west(13)(1), P => Signal_priority(4), Fifo_full => Fifo_full(2),  
South => south_2_north(14)(2), East => east_2_west(14)(2) , Grant => Signal_grant(14)(2)); 

Arbiter_14_3 : Arbiter

PORT MAP (Request => Request(21), North => south_2_north(13)(3), West => east_2_west(13)(2), P => Signal_priority(4), Fifo_full => Fifo_full(3),  
South => south_2_north(14)(3), East => east_2_west(14)(3) , Grant => Signal_grant(14)(3)); 

Arbiter_14_4 : Arbiter

PORT MAP (Request => Request(13), North => south_2_north(13)(4), West => east_2_west(13)(3), P => Signal_priority(4), Fifo_full => Fifo_full(4),  
South => south_2_north(14)(4), East => east_2_west(14)(4) , Grant => Signal_grant(14)(4)); 

Arbiter_14_5 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(13)(5), West => east_2_west(13)(4), P => Signal_priority(4), Fifo_full => Fifo_full(5),  
South => south_2_north(14)(5), East => east_2_west(14)(5) , Grant => Signal_grant(14)(5)); 

Arbiter_14_6 : Arbiter

PORT MAP (Request => Request(78), North => south_2_north(13)(6), West => east_2_west(13)(5), P => Signal_priority(4), Fifo_full => Fifo_full(6),  
South => south_2_north(14)(6), East => east_2_west(14)(6) , Grant => Signal_grant(14)(6)); 

Arbiter_14_7 : Arbiter

PORT MAP (Request => Request(70), North => south_2_north(13)(7), West => east_2_west(13)(6), P => Signal_priority(4), Fifo_full => Fifo_full(7),  
South => south_2_north(14)(7), East => east_2_west(14)(7) , Grant => Signal_grant(14)(7)); 

Arbiter_14_8 : Arbiter

PORT MAP (Request => Request(62), North => south_2_north(13)(8), West => east_2_west(13)(7), P => Signal_priority(4), Fifo_full => Fifo_full(8),  
South => south_2_north(14)(8), East => east_2_west(14)(8) , Grant => Signal_grant(14)(8)); 

Arbiter_14_9 : Arbiter

PORT MAP (Request => Request(54), North => south_2_north(13)(9), West => east_2_west(13)(8), P => Signal_priority(4), Fifo_full => Fifo_full(9),  
South => south_2_north(14)(9), East => east_2_west(14)(9) , Grant => Signal_grant(14)(9)); 

-------------------------- Diagonale n 15 


Arbiter_15_1 : Arbiter

PORT MAP (Request => Request(46), North => south_2_north(14)(1), West => east_2_west(14)(9), P => Signal_priority(3), Fifo_full => Fifo_full(1),  
South => south_2_north(15)(1), East => east_2_west(15)(1) , Grant => Signal_grant(15)(1)); 

Arbiter_15_2 : Arbiter

PORT MAP (Request => Request(38), North => south_2_north(14)(2), West => east_2_west(14)(1), P => Signal_priority(3), Fifo_full => Fifo_full(2),  
South => south_2_north(15)(2), East => east_2_west(15)(2) , Grant => Signal_grant(15)(2)); 

Arbiter_15_3 : Arbiter

PORT MAP (Request => Request(30), North => south_2_north(14)(3), West => east_2_west(14)(2), P => Signal_priority(3), Fifo_full => Fifo_full(3),  
South => south_2_north(15)(3), East => east_2_west(15)(3) , Grant => Signal_grant(15)(3)); 

Arbiter_15_4 : Arbiter

PORT MAP (Request => Request(22), North => south_2_north(14)(4), West => east_2_west(14)(3), P => Signal_priority(3), Fifo_full => Fifo_full(4),  
South => south_2_north(15)(4), East => east_2_west(15)(4) , Grant => Signal_grant(15)(4)); 

Arbiter_15_5 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(14)(5), West => east_2_west(14)(4), P => Signal_priority(3), Fifo_full => Fifo_full(5),  
South => south_2_north(15)(5), East => east_2_west(15)(5) , Grant => Signal_grant(15)(5)); 

Arbiter_15_6 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(14)(6), West => east_2_west(14)(5), P => Signal_priority(3), Fifo_full => Fifo_full(6),  
South => south_2_north(15)(6), East => east_2_west(15)(6) , Grant => Signal_grant(15)(6)); 

Arbiter_15_7 : Arbiter

PORT MAP (Request => Request(79), North => south_2_north(14)(7), West => east_2_west(14)(6), P => Signal_priority(3), Fifo_full => Fifo_full(7),  
South => south_2_north(15)(7), East => east_2_west(15)(7) , Grant => Signal_grant(15)(7)); 

Arbiter_15_8 : Arbiter

PORT MAP (Request => Request(71), North => south_2_north(14)(8), West => east_2_west(14)(7), P => Signal_priority(3), Fifo_full => Fifo_full(8),  
South => south_2_north(15)(8), East => east_2_west(15)(8) , Grant => Signal_grant(15)(8)); 

Arbiter_15_9 : Arbiter

PORT MAP (Request => Request(63), North => south_2_north(14)(9), West => east_2_west(14)(8), P => Signal_priority(3), Fifo_full => Fifo_full(9),  
South => south_2_north(15)(9), East => east_2_west(15)(9) , Grant => Signal_grant(15)(9)); 

-------------------------- Diagonale n 16 


Arbiter_16_1 : Arbiter

PORT MAP (Request => Request(55), North => south_2_north(15)(1), West => east_2_west(15)(9), P => Signal_priority(2), Fifo_full => Fifo_full(1),  
South => south_2_north(16)(1), East => east_2_west(16)(1) , Grant => Signal_grant(16)(1)); 

Arbiter_16_2 : Arbiter

PORT MAP (Request => Request(47), North => south_2_north(15)(2), West => east_2_west(15)(1), P => Signal_priority(2), Fifo_full => Fifo_full(2),  
South => south_2_north(16)(2), East => east_2_west(16)(2) , Grant => Signal_grant(16)(2)); 

Arbiter_16_3 : Arbiter

PORT MAP (Request => Request(39), North => south_2_north(15)(3), West => east_2_west(15)(2), P => Signal_priority(2), Fifo_full => Fifo_full(3),  
South => south_2_north(16)(3), East => east_2_west(16)(3) , Grant => Signal_grant(16)(3)); 

Arbiter_16_4 : Arbiter

PORT MAP (Request => Request(31), North => south_2_north(15)(4), West => east_2_west(15)(3), P => Signal_priority(2), Fifo_full => Fifo_full(4),  
South => south_2_north(16)(4), East => east_2_west(16)(4) , Grant => Signal_grant(16)(4)); 

Arbiter_16_5 : Arbiter

PORT MAP (Request => Request(23), North => south_2_north(15)(5), West => east_2_west(15)(4), P => Signal_priority(2), Fifo_full => Fifo_full(5),  
South => south_2_north(16)(5), East => east_2_west(16)(5) , Grant => Signal_grant(16)(5)); 

Arbiter_16_6 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(15)(6), West => east_2_west(15)(5), P => Signal_priority(2), Fifo_full => Fifo_full(6),  
South => south_2_north(16)(6), East => east_2_west(16)(6) , Grant => Signal_grant(16)(6)); 

Arbiter_16_7 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(15)(7), West => east_2_west(15)(6), P => Signal_priority(2), Fifo_full => Fifo_full(7),  
South => south_2_north(16)(7), East => east_2_west(16)(7) , Grant => Signal_grant(16)(7)); 

Arbiter_16_8 : Arbiter

PORT MAP (Request => Request(80), North => south_2_north(15)(8), West => east_2_west(15)(7), P => Signal_priority(2), Fifo_full => Fifo_full(8),  
South => south_2_north(16)(8), East => east_2_west(16)(8) , Grant => Signal_grant(16)(8)); 

Arbiter_16_9 : Arbiter

PORT MAP (Request => Request(72), North => south_2_north(15)(9), West => east_2_west(15)(8), P => Signal_priority(2), Fifo_full => Fifo_full(9),  
South => south_2_north(16)(9), East => east_2_west(16)(9) , Grant => Signal_grant(16)(9)); 

-------------------------- Diagonale n 17 


Arbiter_17_1 : Arbiter

PORT MAP (Request => Request(64), North => south_2_north(16)(1), West => east_2_west(16)(9), P => Signal_priority(1), Fifo_full => Fifo_full(1),  
South => south_2_north(17)(1), East => east_2_west(17)(1) , Grant => Signal_grant(17)(1)); 

Arbiter_17_2 : Arbiter

PORT MAP (Request => Request(56), North => south_2_north(16)(2), West => east_2_west(16)(1), P => Signal_priority(1), Fifo_full => Fifo_full(2),  
South => south_2_north(17)(2), East => east_2_west(17)(2) , Grant => Signal_grant(17)(2)); 

Arbiter_17_3 : Arbiter

PORT MAP (Request => Request(48), North => south_2_north(16)(3), West => east_2_west(16)(2), P => Signal_priority(1), Fifo_full => Fifo_full(3),  
South => south_2_north(17)(3), East => east_2_west(17)(3) , Grant => Signal_grant(17)(3)); 

Arbiter_17_4 : Arbiter

PORT MAP (Request => Request(40), North => south_2_north(16)(4), West => east_2_west(16)(3), P => Signal_priority(1), Fifo_full => Fifo_full(4),  
South => south_2_north(17)(4), East => east_2_west(17)(4) , Grant => Signal_grant(17)(4)); 

Arbiter_17_5 : Arbiter

PORT MAP (Request => Request(32), North => south_2_north(16)(5), West => east_2_west(16)(4), P => Signal_priority(1), Fifo_full => Fifo_full(5),  
South => south_2_north(17)(5), East => east_2_west(17)(5) , Grant => Signal_grant(17)(5)); 

Arbiter_17_6 : Arbiter

PORT MAP (Request => Request(24), North => south_2_north(16)(6), West => east_2_west(16)(5), P => Signal_priority(1), Fifo_full => Fifo_full(6),  
South => south_2_north(17)(6), East => east_2_west(17)(6) , Grant => Signal_grant(17)(6)); 

Arbiter_17_7 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(16)(7), West => east_2_west(16)(6), P => Signal_priority(1), Fifo_full => Fifo_full(7),  
South => south_2_north(17)(7), East => east_2_west(17)(7) , Grant => Signal_grant(17)(7)); 

Arbiter_17_8 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(16)(8), West => east_2_west(16)(7), P => Signal_priority(1), Fifo_full => Fifo_full(8),  
South => south_2_north(17)(8), East => east_2_west(17)(8) , Grant => Signal_grant(17)(8)); 

Arbiter_17_9 : Arbiter

PORT MAP (Request => Request(81), North => south_2_north(16)(9), West => east_2_west(16)(8), P => Signal_priority(1), Fifo_full => Fifo_full(9),  
South => south_2_north(17)(9), East => east_2_west(17)(9) , Grant => Signal_grant(17)(9)); 


--processus permettant de roter la priorit des diagonales  chaque front d'horloge
 -- rotation round robin
	 round_robin : process(clk)
	begin
		if rising_edge(clk) then
		 if reset ='1' then
		    Signal_priority <= "11111111100000000";
		  elsif priority_rotation_en = '1' then 
 		    case Signal_priority is
		       when "11111111100000000" => Signal_priority <= "01111111110000000";
		       when "01111111110000000" => Signal_priority <= "00111111111000000";
		       when "00111111111000000" => Signal_priority <= "00011111111100000";
		       when "00011111111100000" => Signal_priority <= "00001111111110000";
		       when "00001111111110000" => Signal_priority <= "00000111111111000";
		       when "00000111111111000" => Signal_priority <= "00000011111111100";
		       when "00000011111111100" => Signal_priority <= "00000001111111110";
		       when "00000001111111110" => Signal_priority <= "00000000111111111";
		       when "00000000111111111" => Signal_priority <= "11111111100000000";
		       when others    => Signal_priority <= "11111111100000000";
		  end case;
		 end if;
	     end if;
	 end process;

end Behavioral;

