-- GENERATEUR DE STIMILUS POUR LE TEST DU SWITCH CROSSBAR

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use IEEE.STD_LOGIC_ARITH.ALL;

entity stimuli45 is 
port (clk : in std_logic;
      reset : in std_logic;
       wr_en : out std_logic;
      data : out std_logic_vector(7 downto 0));
end stimuli45;

architecture behavioral of stimuli45 is
type rom_type is array (0 to 69) of std_logic_vector (7 downto 0);
signal ROM : rom_type:= (
						X"55", X"28", X"00" ,X"01" ,X"02" ,X"03" ,
						X"04" ,X"05" ,X"06" ,X"07" ,X"08" ,X"09" ,
						X"0a" ,X"0b" ,X"0c" ,X"0d" ,X"0e" ,X"0f" ,
						X"10" ,X"11" ,X"12" ,X"13" ,X"14" ,X"15" ,
						X"16" ,X"17" ,X"18" ,X"19" ,X"1a" ,X"1b" ,
						X"1c" ,X"1d" ,X"1e" ,X"1f" ,X"20" ,X"21" ,
						X"22" ,X"23" ,X"24" ,X"25" ,X"52", X"1e", 
						X"00" ,X"01" ,X"02" ,X"03" ,X"04" ,X"05" ,
						X"06" ,X"07" ,X"08" ,X"09" ,X"0a" ,X"0b" ,
						X"0c" ,X"0d" ,X"0e" ,X"0f" ,X"10" ,X"11" ,
						X"12" ,X"13" ,X"14" ,X"15" ,X"16" ,X"17" ,
						X"18" ,X"19" ,X"1a" ,X"1b" );

constant max_address : std_logic_vector(6 downto 0) :="1000101";
signal address_counter : std_logic_vector(6 downto 0) := (others => '0');
begin

data <= ROM(conv_integer(address_counter));
process (clk)
  begin
     if rising_edge(clk) then
        if reset = '1' then
            wr_en <='1';
            address_counter <= (others=>'0');
        elsif address_counter < max_address then
             wr_en <='1';
              address_counter <= address_counter +1;
             else
             wr_en <='0';
             end if;
    end if;
  end process;
end behavioral;