---------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    03:56:34 05/06/2011 
-- Design Name: 
-- Module Name:    Sheduler - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Module de l'ordonnanceur du switch crossbar
-- l'algorithme utilise est le DPA (diagonal propagation arbiter)
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use Work.Sheduler_package.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity Scheduler4_4 is
    Port ( Request : in  STD_LOGIC_VECTOR (16 downto 1);
		   Fifo_full : in STD_LOGIC_VECTOR (4 downto 1);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
            priority_rotation : in  STD_LOGIC_VECTOR (4 downto 1);
           port_grant : out  STD_LOGIC_VECTOR (16 downto 1));
end Scheduler4_4;

architecture Behavioral of Scheduler4_4 is
--Declaration du types
--tableau de signaux de connexion des cellules arbitres
TYPE C_Bar_Signal_Array IS ARRAY(7 downto 1) of STD_LOGIC_VECTOR(4 downto 1);
-- declaration du composant cellule d'arbitrage
Component Arbiter 
  PORT (P, Fifo_full,Request, West,North : in  STD_LOGIC;
        Grant,East,South : out  STD_LOGIC );
End Component;--Signaux de connexion des cellues
SIGNAL south_2_north :  C_Bar_Signal_Array; -- connexion south north 
SIGNAL east_2_west   :  C_Bar_Signal_Array; -- connexion east west 
SIGNAL Signal_mask      : C_Bar_Signal_Array;-- connexion des masques de priorit
SIGNAL Signal_grant     : C_Bar_Signal_Array;-- connexion des signaux de validation
SIGNAL Signal_priority  : STD_LOGIC_VECTOR (7 DOWNTO 1);--signal pour la connection des vecteur de priorit
SIGNAL High         : std_logic;--niveau pour les cellules des extremits nord et ouest 
 signal grant_latch,req_grant: std_logic_vector(16 downto 1); 
 signal priority_rotation_en : std_logic; 
 signal Grant :  std_logic_vector(16 downto 1);
 begin

--validation de la rotation de priorit lorsque aucun port n'emet 
req_grant<=(request and grant_latch);
 priority_rotation_en <= '1' when unsigned(req_grant) = 0 or unsigned(priority_rotation) = 15 else 	'0'; 

--latch  qui memorise le signal grant pendant la transmission 
grant_latch_process : process(clk)
 begin 
  if rising_edge(clk) then 
   if reset = '1' then 
 		grant_latch <= (others => '0'); 
 	 elsif priority_rotation_en = '1' then 
	   grant_latch <= Grant; 
   end if; 
   end if; 
 end process; 
 port_grant <=  grant_latch; 
 Grant(1)  <= Signal_grant(1)(1) or Signal_grant(5)(1); --  Grant(1,1)
Grant(2)  <= Signal_grant(2)(2) or Signal_grant(6)(2); --  Grant(1,2)
Grant(3)  <= Signal_grant(3)(3) or Signal_grant(7)(3); --  Grant(1,3)
Grant(4)  <= Signal_grant(4)(4) ;                      --  Grant(1,4)
Grant(5)  <= Signal_grant(2)(1) or Signal_grant(6)(1); --  Grant(2,1)
Grant(6)  <= Signal_grant(3)(2) or Signal_grant(7)(2); --  Grant(2,2)
Grant(7)  <= Signal_grant(4)(3) ;                      --  Grant(2,3)
Grant(8)  <= Signal_grant(1)(4) or Signal_grant(5)(4); --  Grant(2,4)
Grant(9)  <= Signal_grant(3)(1) or Signal_grant(7)(1); --  Grant(3,1)
Grant(10)  <= Signal_grant(4)(2) ;                      --  Grant(3,2)
Grant(11)  <= Signal_grant(1)(3) or Signal_grant(5)(3); --  Grant(3,3)
Grant(12)  <= Signal_grant(2)(4) or Signal_grant(6)(4); --  Grant(3,4)
Grant(13)  <= Signal_grant(4)(1) ;                      --  Grant(4,1)
Grant(14)  <= Signal_grant(1)(2) or Signal_grant(5)(2); --  Grant(4,2)
Grant(15)  <= Signal_grant(2)(3) or Signal_grant(6)(3); --  Grant(4,3)
Grant(16)  <= Signal_grant(3)(4) or Signal_grant(7)(4); --  Grant(4,4)
High <= '1';

----instantiations des cellules arbitres et interconnection

-------------------------- Diagonale n 1 


Arbiter_1_1 : Arbiter

PORT MAP (Request => Request(1), North => High, West => High, P => Signal_priority(7), Fifo_full => Fifo_full(1),  
South => south_2_north(1)(1), East => east_2_west(1)(1) , Grant => Signal_grant(1)(1)); 

Arbiter_1_2 : Arbiter

PORT MAP (Request => Request(14), North => High, West => High, P => Signal_priority(7), Fifo_full => Fifo_full(2),  
South => south_2_north(1)(2), East => east_2_west(1)(2) , Grant => Signal_grant(1)(2)); 

Arbiter_1_3 : Arbiter

PORT MAP (Request => Request(11), North => High, West => High, P => Signal_priority(7), Fifo_full => Fifo_full(3),  
South => south_2_north(1)(3), East => east_2_west(1)(3) , Grant => Signal_grant(1)(3)); 

Arbiter_1_4 : Arbiter

PORT MAP (Request => Request(8), North => High, West => High, P => Signal_priority(7), Fifo_full => Fifo_full(4),  
South => south_2_north(1)(4), East => east_2_west(1)(4) , Grant => Signal_grant(1)(4)); 

-------------------------- Diagonale n 2 


Arbiter_2_1 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(1)(1), West => east_2_west(1)(4), P => Signal_priority(6), Fifo_full => Fifo_full(1),  
South => south_2_north(2)(1), East => east_2_west(2)(1) , Grant => Signal_grant(2)(1)); 

Arbiter_2_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(1)(2), West => east_2_west(1)(1), P => Signal_priority(6), Fifo_full => Fifo_full(2),  
South => south_2_north(2)(2), East => east_2_west(2)(2) , Grant => Signal_grant(2)(2)); 

Arbiter_2_3 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(1)(3), West => east_2_west(1)(2), P => Signal_priority(6), Fifo_full => Fifo_full(3),  
South => south_2_north(2)(3), East => east_2_west(2)(3) , Grant => Signal_grant(2)(3)); 

Arbiter_2_4 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(1)(4), West => east_2_west(1)(3), P => Signal_priority(6), Fifo_full => Fifo_full(4),  
South => south_2_north(2)(4), East => east_2_west(2)(4) , Grant => Signal_grant(2)(4)); 

-------------------------- Diagonale n 3 


Arbiter_3_1 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(2)(1), West => east_2_west(2)(4), P => Signal_priority(5), Fifo_full => Fifo_full(1),  
South => south_2_north(3)(1), East => east_2_west(3)(1) , Grant => Signal_grant(3)(1)); 

Arbiter_3_2 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(2)(2), West => east_2_west(2)(1), P => Signal_priority(5), Fifo_full => Fifo_full(2),  
South => south_2_north(3)(2), East => east_2_west(3)(2) , Grant => Signal_grant(3)(2)); 

Arbiter_3_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(2)(3), West => east_2_west(2)(2), P => Signal_priority(5), Fifo_full => Fifo_full(3),  
South => south_2_north(3)(3), East => east_2_west(3)(3) , Grant => Signal_grant(3)(3)); 

Arbiter_3_4 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(2)(4), West => east_2_west(2)(3), P => Signal_priority(5), Fifo_full => Fifo_full(4),  
South => south_2_north(3)(4), East => east_2_west(3)(4) , Grant => Signal_grant(3)(4)); 

-------------------------- Diagonale n 4 


Arbiter_4_1 : Arbiter

PORT MAP (Request => Request(13), North => south_2_north(3)(1), West => east_2_west(3)(4), P => Signal_priority(4), Fifo_full => Fifo_full(1),  
South => south_2_north(4)(1), East => east_2_west(4)(1) , Grant => Signal_grant(4)(1)); 

Arbiter_4_2 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(3)(2), West => east_2_west(3)(1), P => Signal_priority(4), Fifo_full => Fifo_full(2),  
South => south_2_north(4)(2), East => east_2_west(4)(2) , Grant => Signal_grant(4)(2)); 

Arbiter_4_3 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(3)(3), West => east_2_west(3)(2), P => Signal_priority(4), Fifo_full => Fifo_full(3),  
South => south_2_north(4)(3), East => east_2_west(4)(3) , Grant => Signal_grant(4)(3)); 

Arbiter_4_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(3)(4), West => east_2_west(3)(3), P => Signal_priority(4), Fifo_full => Fifo_full(4),  
South => south_2_north(4)(4), East => east_2_west(4)(4) , Grant => Signal_grant(4)(4)); 

-------------------------- Diagonale n 5 


Arbiter_5_1 : Arbiter

PORT MAP (Request => Request(1), North => south_2_north(4)(1), West => east_2_west(4)(4), P => Signal_priority(3), Fifo_full => Fifo_full(1),  
South => south_2_north(5)(1), East => east_2_west(5)(1) , Grant => Signal_grant(5)(1)); 

Arbiter_5_2 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(4)(2), West => east_2_west(4)(1), P => Signal_priority(3), Fifo_full => Fifo_full(2),  
South => south_2_north(5)(2), East => east_2_west(5)(2) , Grant => Signal_grant(5)(2)); 

Arbiter_5_3 : Arbiter

PORT MAP (Request => Request(11), North => south_2_north(4)(3), West => east_2_west(4)(2), P => Signal_priority(3), Fifo_full => Fifo_full(3),  
South => south_2_north(5)(3), East => east_2_west(5)(3) , Grant => Signal_grant(5)(3)); 

Arbiter_5_4 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(4)(4), West => east_2_west(4)(3), P => Signal_priority(3), Fifo_full => Fifo_full(4),  
South => south_2_north(5)(4), East => east_2_west(5)(4) , Grant => Signal_grant(5)(4)); 

-------------------------- Diagonale n 6 


Arbiter_6_1 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(5)(1), West => east_2_west(5)(4), P => Signal_priority(2), Fifo_full => Fifo_full(1),  
South => south_2_north(6)(1), East => east_2_west(6)(1) , Grant => Signal_grant(6)(1)); 

Arbiter_6_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(5)(2), West => east_2_west(5)(1), P => Signal_priority(2), Fifo_full => Fifo_full(2),  
South => south_2_north(6)(2), East => east_2_west(6)(2) , Grant => Signal_grant(6)(2)); 

Arbiter_6_3 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(5)(3), West => east_2_west(5)(2), P => Signal_priority(2), Fifo_full => Fifo_full(3),  
South => south_2_north(6)(3), East => east_2_west(6)(3) , Grant => Signal_grant(6)(3)); 

Arbiter_6_4 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(5)(4), West => east_2_west(5)(3), P => Signal_priority(2), Fifo_full => Fifo_full(4),  
South => south_2_north(6)(4), East => east_2_west(6)(4) , Grant => Signal_grant(6)(4)); 

-------------------------- Diagonale n 7 


Arbiter_7_1 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(6)(1), West => east_2_west(6)(4), P => Signal_priority(1), Fifo_full => Fifo_full(1),  
South => south_2_north(7)(1), East => east_2_west(7)(1) , Grant => Signal_grant(7)(1)); 

Arbiter_7_2 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(6)(2), West => east_2_west(6)(1), P => Signal_priority(1), Fifo_full => Fifo_full(2),  
South => south_2_north(7)(2), East => east_2_west(7)(2) , Grant => Signal_grant(7)(2)); 

Arbiter_7_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(6)(3), West => east_2_west(6)(2), P => Signal_priority(1), Fifo_full => Fifo_full(3),  
South => south_2_north(7)(3), East => east_2_west(7)(3) , Grant => Signal_grant(7)(3)); 

Arbiter_7_4 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(6)(4), West => east_2_west(6)(3), P => Signal_priority(1), Fifo_full => Fifo_full(4),  
South => south_2_north(7)(4), East => east_2_west(7)(4) , Grant => Signal_grant(7)(4)); 


--processus permettant de roter la priorit des diagonales  chaque front d'horloge
 -- rotation round robin
	 round_robin : process(clk)
	begin
		if rising_edge(clk) then
		 if reset ='1' then
		    Signal_priority <= "1111000";
		  elsif priority_rotation_en = '1' then 
 		    case Signal_priority is
		       when "1111000" => Signal_priority <= "0111100";
		       when "0111100" => Signal_priority <= "0011110";
		       when "0011110" => Signal_priority <= "0001111";
		       when "0001111" => Signal_priority <= "1111000";
		       when others    => Signal_priority <= "1111000";
		  end case;
		 end if;
	     end if;
	 end process;

end Behavioral;

