----------------------------------------------------------------------------------
-- Company: 
-- Engineer: EMMANUEL KIEGAING EN 5
-- 
-- Create Date:    08:12:29 06/16/2011 
-- Design Name: 
-- Module Name:    EX1_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use Work.Packet_type.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity EX1_FSM is
    -- parametres generiques du module : 
	generic (
				 pid : std_logic_vector(3 downto 0) :="0001"; -- id du processeur
				nprocs : std_logic_vector(3 downto 0):="1111"-- nombre de processeur du MPSOC - 1
			);
	     
    Port ( 
	        --instruction_available : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           fifo_empty : in  STD_LOGIC;
           fifo_data_out : in  STD_LOGIC_VECTOR (7 downto 0);
			  switch_port_in_full : in std_logic;
			  ram_data : in std_logic_vector(7 downto 0);
			  ram_address : out std_logic_vector(15 downto 0);
           priority_rotation : out  STD_LOGIC;
           fifo_rd_en : out  STD_LOGIC;
           switch_port_in_data : out  STD_LOGIC_VECTOR (7 downto 0);
           switch_port_in_wr_en : out  STD_LOGIC;
           dma_request : out  STD_LOGIC;
           dma_grant : in  STD_LOGIC);
end EX1_FSM;

architecture Behavioral of EX1_FSM is
-- definition du type etat pour le codage des etats des fsm
type fsm_states is (fifo_select, fetch_packet_type, decode_packet_type, fetch_addresses, decode_packet_type2, execute_barrier1, execute_barrier2, execute_barrier3, execute_barrier4, execute_get1, execute_get2, execute_put1, execute_put2, execute_put3, execute_put4);
-- machine a etat du module
signal ex1_state_mach : fsm_states;

-- les variables utilises dans la fsm
signal data_to_send : std_logic_vector(7 downto 0);
signal packet_type : std_logic_vector(3 downto 0);
--signal dpid : std_logic_vector(3 downto 0);
signal pid_counter : std_logic_vector(3 downto 0);
signal packet_length : std_logic_vector(7 downto 0);
signal src_address : std_logic_vector(15 downto 0);
signal dest_address : std_logic_vector(15 downto 0);
signal n : std_logic_vector(3 downto 0);
signal len : std_logic_vector(7 downto 0);

begin
-- connection des signaux avec les ports
ram_address <= src_address;

-- processus de transistion entre les etats 
fsm_nst_logic : process(clk)
begin
 if rising_edge(clk) then
	if reset = '1' then
	ex1_state_mach <= fifo_select;
	 else
		  case ex1_state_mach is
			 when fifo_select => if fifo_empty  ='0' then 								
											ex1_state_mach  <= fetch_packet_type;
									   else
											ex1_state_mach <= fifo_select;
								end if;
			when fetch_packet_type => if fifo_empty ='1' then
										ex1_state_mach <= fetch_packet_type;
									 else
									   packet_type <= fifo_data_out(7 downto 4);
										data_to_send <= fifo_data_out;
										ex1_state_mach <= decode_packet_type;
							      end if;
			when decode_packet_type => if fifo_empty = '1' then
													ex1_state_mach <= decode_packet_type;
												else
												 if packet_type = MPI_PUT then
												    packet_length <= fifo_data_out + 4; 
													 n <= "0000";
													 ex1_state_mach <= fetch_addresses;
												  elsif packet_type = MPI_GET then
												    len <= fifo_data_out;
													 n <= "0000";	 
												    ex1_state_mach <= fetch_addresses;
												  elsif packet_type = MPI_BARRIER_REACHED or packet_type = MPI_BARRIER_COMPLETED then
												    packet_length <= "00000011"; --  = 3
													 pid_counter <= "0000";
													 ex1_state_mach <= execute_barrier1;
													 else ex1_state_mach <= decode_packet_type;-- pas necessaire mais plus sure
											     end if;												  
							             end if;        									
         when fetch_addresses => if fifo_empty = '0' and n = 0 then
												  src_address(15 downto 8) <= fifo_data_out;
												  n <= n + 1;
												  ex1_state_mach <= fetch_addresses;
												elsif fifo_empty = '0' and n = 1 then
												  src_address(7 downto 0) <= fifo_data_out;
												  n <= n + 1;
												  ex1_state_mach <= fetch_addresses;
												elsif fifo_empty = '0' and n = 2 then
												  dest_address(15 downto 8) <= fifo_data_out;
												  n <= n + 1;
												  ex1_state_mach <= fetch_addresses;
												elsif fifo_empty = '0' and n = 3 then
												  dest_address(7 downto 0) <= fifo_data_out;
												  n <= "0000";
												  ex1_state_mach <= decode_packet_type2;
												   else
													 ex1_state_mach <= fetch_addresses;										
								         end if;		
			when decode_packet_type2 => if packet_type = MPI_PUT  then
												    ex1_state_mach <= execute_put1;
												   else
												    ex1_state_mach <= execute_get1;										
								             end if;	
												 -- execution du mpi put
			when execute_put1 => if dma_grant = '1' then
										  ex1_state_mach <= execute_put2;
										 else
										  ex1_state_mach <= execute_put1;
								      end if;	
			when execute_put2 => if switch_port_in_full = '0' and n = 0 then
										  data_to_send <= packet_length;
										  n <= n + 1;
										  ex1_state_mach <= execute_put2;
										elsif switch_port_in_full = '0' and n = 1 then
										  data_to_send <= dest_address(15 downto 8);
										  n <= n + 1;
										  ex1_state_mach <= execute_put2;
										elsif switch_port_in_full = '0' and n = 2 then
										  data_to_send <= dest_address(7 downto 0);
										  n <= n +1;
										  ex1_state_mach <= execute_put2;
										elsif switch_port_in_full = '0' and  n = 3 then
										  packet_length <= packet_length - 4;
										  ex1_state_mach <= execute_put3;
										 else
										  ex1_state_mach <= execute_put2;										
								     end if;								
			when execute_put3 => if switch_port_in_full = '0' and packet_length > 0 then
										   packet_length <= packet_length - 1;
										   src_address <= src_address + 1;
										   ex1_state_mach <= execute_put3;
										 else
										   ex1_state_mach <= execute_put4;
								      end if;	
			when execute_put4 => if packet_length = 0 then -- fin du mpi_put
										   ex1_state_mach <= fifo_select;
										  else
											ex1_state_mach <= execute_put3;
								      end if;	
			when execute_get1 => if switch_port_in_full = '0' and n = 0 then  -- execution du mpi get
										      data_to_send <= "00001000";
											   n <= n + 1;
											   ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 1 then
											   data_to_send <= "0000"&pid;
												n <= n + 1;
											   ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 2 then
											   data_to_send <= len;
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 3 then
											   data_to_send <= src_address(15 downto 8);
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 4 then
											   data_to_send <= src_address(7 downto 0);
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 5 then
											   data_to_send <= dest_address(15 downto 8);
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 6 then
											   data_to_send <= dest_address(7 downto 0);
												n <= n + 1;
												ex1_state_mach <= execute_get2;
												 else
												  ex1_state_mach <= execute_get1;
								      end if;	
			when execute_get2 => if switch_port_in_full = '0' then
										 ex1_state_mach <= fifo_select;
										else
										 ex1_state_mach <= execute_get2;
								end if;	
								-- execution du barrier
			when execute_barrier1 => if switch_port_in_full = '0' then
												 ex1_state_mach <= execute_barrier2;	
											  else
											    ex1_state_mach <= execute_barrier1;	
											 end if;	
			when execute_barrier2 => if switch_port_in_full = '0' then
												 ex1_state_mach <= execute_barrier3;	
											  else
											    ex1_state_mach <= execute_barrier2;	
											 end if;	
			when execute_barrier3 => if switch_port_in_full = '0' then
												 ex1_state_mach <= execute_barrier4;	
											  else
											    ex1_state_mach <= execute_barrier3;	
											 end if;	
			when execute_barrier4 => if packet_type = MPI_BARRIER_COMPLETED and pid_counter < nprocs then
												 pid_counter <= pid_counter + 1;
												 ex1_state_mach <= execute_barrier1;	
											  else
											    ex1_state_mach <= fifo_select;	
											 end if;												
			
			when others => ex1_state_mach <= fifo_select;
		   end case;
    end if;
  end if;
 end process;
 
 -- sortie de la machine  etat
 ex1_fsm_action : process(ex1_state_mach, fifo_empty, switch_port_in_full, packet_length, pid_counter, ram_data, packet_length, data_to_send, packet_type)
  begin   
-- code fonctionnel	
	case ex1_state_mach is
		when fifo_select => priority_rotation <='1';
								  fifo_rd_en <= '0';
								  switch_port_in_data <= "00000000";
								  switch_port_in_wr_en <= '0';
								  dma_request <= '0';
								  
		when fetch_packet_type => priority_rotation <='0';
								  fifo_rd_en <= not(fifo_empty);
								  switch_port_in_data <= "00000000";
								  switch_port_in_wr_en <= '0';
								  dma_request <= '0';
		
		when decode_packet_type => priority_rotation <='0';
											fifo_rd_en <= not(fifo_empty);
											switch_port_in_data <= "00000000";
											switch_port_in_wr_en <= '0';
											dma_request <= '0';											
		
		when fetch_addresses => priority_rotation <='0';
										fifo_rd_en <= not(fifo_empty);
										switch_port_in_data <= "00000000";
										switch_port_in_wr_en <= '0';
										dma_request <= '0';
		
		when decode_packet_type2 =>priority_rotation <='0';
								         fifo_rd_en <= '0';
								         switch_port_in_data <= "00000000";
											switch_port_in_wr_en <= '0';
											dma_request <= '0';
		
		when  execute_barrier1 => priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= packet_type & pid_counter;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '0';
		
		when execute_barrier2 =>  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= packet_length;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '0';	
										  
		when execute_barrier3 => priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= "0000" & pid;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '0';
		
		when execute_barrier4 => priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= "0000" & pid;
								        switch_port_in_wr_en <= '0';
								        dma_request <= '0';
		
		when execute_get1 =>      priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '0';
										  
		when execute_get2 =>      priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '0';
										  
		when execute_put1 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= '0';
								        dma_request <= '1';	
		
		when execute_put2 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '1';
										  
		when execute_put3 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_data;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        dma_request <= '1';	
		
		when execute_put4 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_data;
								        switch_port_in_wr_en <= '0';
								        dma_request <= '1';	
								
		when others => 	        priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= "00000000";
								        switch_port_in_wr_en <= '0';
								        dma_request <= '0';	
	end case;
	
 end process;

end Behavioral;

