----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    14:44:36 03/07/2012 
-- Design Name: 
-- Module Name:    EX4_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity EX4_FSM is
    Port ( Instruction : in  STD_LOGIC_VECTOR (7 downto 0);
           Instruction_En : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           ResultOut : out  STD_LOGIC_VECTOR (7 downto 0);
           Result_En : out  STD_LOGIC;
           NocSizeId : out  STD_LOGIC;
           AppRank : out  STD_LOGIC;
           AppSize : out  STD_LOGIC;
           IsMain : out  STD_LOGIC;
           AdrRam : out  STD_LOGIC_VECTOR (3 downto 0); --accs au stockage
           WeRam : out  STD_LOGIC; --activation de l'criture en RAM
           DataRam : out  STD_LOGIC_VECTOR (7 downto 0);--donnes des ports
           AppAck : in  STD_LOGIC;
           AppReq : in  STD_LOGIC;
			  port_in_cmd_en : out  STD_LOGIC;
			  port_in_wr_en : out  STD_LOGIC;
			  port_in_empty : in  STD_LOGIC;
           port_in_full : in  STD_LOGIC;
           port_in_data : out  STD_LOGIC_VECTOR (7 downto 0);
			  port_out_data : in  STD_LOGIC_VECTOR (7 downto 0);
           port_out_rd_en : out  STD_LOGIC;
           port_out_data_available : in  STD_LOGIC);
end EX4_FSM;

architecture Behavioral of EX4_FSM is

	--MAE pour emission de init
   type init1_type is (init,NocSize,InitToNoc,NextPort,EndBCast); 
	--	MAE pour affectation des rangs aux diffrentes librairies MPI
	type init2_type is (init,GetPortNum,PortIsZero,ASkMain,StoreMain,SetMainFlag,StoreRank,NewRank,SendRank,RegRank,SendApp,EndInit);
   -- MAE pour rception de init depuis le rseau;
	type init3_type is  (init,GetNocSize,ReadInitHead,StorePort,EndInit); 
	type typ_send is (s_init,s_head,s_len,s_len2,s_data,s_end);
	type typ_receiv is (r_wait,r_dlen,r_glen,r_start,r_end);
	type typ_cmd is (cmdstart,cmdpost,cmdpostidle,cmdread,cmdlen,cmdglen,cmddata,cmdend,cmdtimeout);

		signal etsnd,etsnd2,etsnd3 : typ_send;
		signal etrec:typ_receiv;   --pour la machine  tat de rception
		signal etcmd :typ_cmd;     --pour la machine  tat de commande
	signal stInit1, next_stInit1 : init1_type; 
	signal stInit2, next_stInit2 : init2_type; 
	signal stInit3, next_stInit3 : init3_type; 
	
	--signaux pour les tats des MAE
	signal AppReq, NocSizeOk,PortCountFlag : std_logic;
	signal AppAck,PortNumFlag,EquFlag,MainResp,RankAsked,RankSent:std_logic;
   
	--Declare internal signals for all outputs of the state-machine
   signal PortNum_i : std_logic_vector;  -- 
	signal NextRank : std_logic_vector(3 downto 0):=(others=>'0'); --utiliser pour grer les affectations de rangs MPI
   signal DataToSend : Typ_PortIo(0 to 3):=(others=>'0'); -- permet d'empiler les donnes  envoyer
	signal DataReceived : Typ_PortIO(0 to 3):=(others=>'0');
	signal Datalen : natural range 0 to 3 :=0; --indique la longueur des donnes
	--other outputs
begin

Init1_PROC: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (reset = '1') then
            stInit1 <= Init;
            --<output> <= '0';
         else
            stInit1 <= next_stInit1;
           -- <output> <= <output>_i;
         -- assign other outputs to internal signals
         end if;        
      end if;
   end process;
 
   --MOORE State-Machine - Outputs based on state only
   Init1_DECODE: process (state)
   begin
      --insert statements to decode internal output signals
      --below is simple example
      Case stInit1 is
		When Init =>
		When NocSize =>
		When InitToNoc =>
		When NextPort =>
		When EndBCast =>
		end case;
   end process;
 
   NEXT_STInit1_DECODE: process (stinit1,AppReq, NocSizeOk,PortCountFlag)
   begin
      --declare default state for next_state to avoid latches
      next_stInit1 <= stInit1;  --default is to stay in current state
      --insert statements to decode next_state
      --below is a simple example
      case (stinit1) is
         When Init =>
				If AppReq='1' then
					Next_stInit1 <=NocSize;
				end if;
		When NocSize =>
			if NocSizeOk='1' then
				Next_stInit<=InitToNoc;
			end if;
		When InitToNoc =>
			if SendAck='1' then
				Next_stInit<=InitToNoc;
			end if;
		When NextPort =>
			if PortCountFlg='1' then
				Next_stInit<=InitToNoc;
			else
				Next_stInit<=EndBCast;
			end if;
		When EndBCast =>
			Next_stInit<=Init;
      end case;      
   end process;
	
Init2_PROC: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (reset = '1') then
            stInit2 <= Init;
            --<output> <= '0';
         else
            stInit2 <= next_stInit2;
           -- <output> <= <output>_i;
         -- assign other outputs to internal signals
         end if;        
      end if;
   end process;
 
   --MOORE State-Machine - Outputs based on state only
   Init2_DECODE: process (state)
   begin
      --insert statements to decode internal output signals
      --below is simple example
      Case stInit2 is
		When Init =>
		When GetPortNum =>
			CTS_cmd<='1';
			
		When PortIsZero =>
			CTS_cmd<='0';
			CTS_dat<='0';
			NextRank<="0000";
			IsMain<=1;
			MainAdr<="0000";   -- le port 0 est le main Lib par dfaut;
		When ASkMain =>
				CTS_cmd<='0';
		      CTS_DAT<='1';
				DataToSend(0)<=INIT_ASKMAIN & PortNUm ;
				DataLen<=1;
		When StoreMain =>
				CTS_cmd<='0';
		      CTS_DAT<='1';
		When SetMainFlag =>
				CTS_cmd<='0';
		      CTS_DAT<='0';
		
		When NewRank =>
				
				NextRank<=incr_vec(NextRank);
				
		When SendRank =>
				DataToSend(0)<=INIT_SETRANK & PortNUm ;
				DataToSend(1)<=NextRank;
				DataLen<=2;
				Cts<=1;
		When RegRank =>
				WeRam<='1';
				AdrRam<=NextRank;
				AdrData<="0000" & QryPort;
		When StoreRank => --le processus qui coute le Port et qui 
								--stoke les adresses des autres bib va grer le stockage du rang
				MyRank<=DataReceived(2);
				MainAdr<=DataReceived(0);
		When SendApp =>
		When EndInit=>
				CTS_cmd<='0';
		      CTS_DAT<='0';
		end case;
   end process;
 
   NEXT_STInit2_DECODE: process (stInit2,AppReq, AppAck,PortNumFlag,EquFlag,MainResp,RankAsked,RankSent)
   begin
      --declare default state for next_state to avoid latches
      next_stInit2 <= stInit2;  --default is to stay in current state
      --insert statements to decode next_state
      --below is a simple example
      case (stInit2) is
         
			
		When Init =>If AppReq='1' then
					Next_stInit2 <=GetPortNum;
				end if;
		When GetPortNum => if PortNumFlag='1' then
						Next_stInit2 <=GetPortNum;
						End if;
		When PortIsZero => if EquFlag='1'  then
							Next_stInit2 <=AskMain;
						else 
							Next_stInit2<=StoreMain;
						End if;
		
		When ASkMain =>if MainResp='1' then  -- il faut enregistrer galement l'adresse 
						Next_stInit2 <=StoreRank; -- de la librairie pricipale
						End if;
			
		When StoreMain =>
					Next_stInit2 <=SetMainFlag;
		When SetMainFlag =>
					if RankAsked then
						Next_stInit2 <=NewRank;
					else
						Next_stInit2 <=SendApp;
					end if;
		When NewRank =>
				Next_stInit2 <=SendRank;
		When SendRank =>
					if RankSent='1' then
						Next_stInit2 <=RegRank;
					end if;
		When RegRank =>
					if RankAsked then
						Next_stInit2 <=NewRank;
					else
						Next_stInit2 <=SendApp;
					end if;
		When StoreRank =>
				Next_stInit2<=SendApp;
		When SendApp =>
					If AppAck='1' then
						Next_stInit2 <=EndInt;
					end if;
		
		
		When EndInit=>
		
			
			Next_stInit<=Init;
      end case;      
   end process;
	
	Init3_PROC: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (reset = '1') then
            stInit3 <= Init;
            --<output> <= '0';
         else
            stInit3 <= next_stInit3;
           -- <output> <= <output>_i;
         -- assign other outputs to internal signals
         end if;        
      end if;
   end process;
 
   --MOORE State-Machine - Outputs based on state only
   Init3_DECODE: process (state)
   begin
      --insert statements to decode internal output signals
      --below is simple example
      Case stInit3 is
		When Init =>
		
		When GetNocSize =>
		
		When GetInitHead =>
			
		When StorePort =>
		
		When EndInit =>
		
		end case;
   end process;
 
   NEXT_STInit3_DECODE: process (stInit3,NocInitReq,NocSizeOk,PacketRdy,StoreFlag)
   begin
      --declare default state for next_state to avoid latches
      next_stInit3 <= stInit3;  --default is to stay in current state
      --insert statements to decode next_state
      --below is a simple example
      case (stInit3) is
         When Init =>
				If NocInitReq='1' then
					Next_stInit3 <=GetNocSize;
				end if;
		When GetNocSize =>
			if NocSizeOk='1' then
				Next_stInit3<=GetInitHead;
			end if;
		When GetInitHead =>
			if PacketRdy='1' then
				Next_stInit3<=StorePort;
			end if;
		When StorePort =>
			if StoreFlag='1' then
				Next_stInit3<=EndInit;
			
			end if;
		When EndInit =>
			Next_stInit3<=Init;
      end case;      
   end process;
	--===============================================================
	--processus d'accs au rseau
	--===============================================================
	preceiv:process(clk,reset)
	
	variable origport,destport,ptype : natural range 0 to 15;
	variable datalen,dcount ,timeout:natural range 0 to 255;
	begin
--				
	if reset='1' then
		etrec<=r_wait;
		destport:=1;
		timeout:=0;
	elsif rising_edge(clk) then
			case  etrec is
			when r_wait =>
				
				timeout:=0;
				time_out(destport)<='0';
			if Port_out_data_available='1' and AppReq='1'  then 
				ptype:=to_integer(unsigned(port_out_data(7 downto 4)));
				origport:=to_integer(unsigned(port_out_data(3 downto 0)));
				port_out_rd_en <='1';
				if ptype=MPI_INIT then 
						etrec<=r_dlen; --identification de la signature d'en tte valide
					else
					etrec<=r_wait;
					end if;
			elsif Port_out_data_available='1' and AppReq='0' then
					etrec<=r_drop;
			else
				
				etrec<=r_wait;
			end if;
			
			When r_drop => -- ignorer les messages qui arrivent  ce noeud tant que 
								--l'application n'a pas t initialise
						if port_out_data_available='0' then 
							etrec<=r_end;
						end if;
						port_out_rd_en<='1'; --lire les donnes qui sont dans le tampon de sortie		
			
			when r_Dlen =>   --positionnement du mot de longueur des donnes
			if Port_out_data_available ='1' then 
			
			port_out_rd_en<='1';
			etrec<=r_glen;
			timeout:=0;
			else
				timeout:=timeout+1;
					if timeout>=30 then 
					RNtime_out<='1';  --read Noc time out
						etrec<=r_end;             -- donnes pas prtes
					end if;
			
			
			end if;
			--  
			when r_glen =>   --lecture effective de la longueur des donnes
			if port_out_data_available='1' then 
			datalen:=to_integer(unsigned(port_out_data(7 downto 0)))-3;
			Port_out_rd_en<='1';
			etrec<=r_start;
			dcount:=0;  -- initialisation du compteur de reception
			else
				timeout:=timeout+1;
					if timeout>=30 then 
					RNtime_out<='1';
						etrec<=r_end;             -- donnes pas prtes
					end if;
			
			end if;
			
			when r_start =>
			if port_out_data_available='1'  then 
					
					
					DataReceived(dcount)<=Port_out_data; --rcupration des donnes
					assert true report "Donne lue :"; --& string(unsigned(port4_out(7 downto 0)))
					Port_out_rd_en<='1';
					dcount:=dcount+1;
					--severity note;
					if datalen<=dcount then 
						etrec<=r_end;
						ReceivOk<='1';
					elsif dcount=255 then   --dpassement de la capacit
						etrec<=r_end;
					end if;
			else
					timeout:=timeout+1;
					if timeout>=30 then 
					   RNtime_out<='1';
						etrec<=r_end;             -- donnes pas prtes
					end if;
				
					
			end if;
			when r_end =>
			
			
			Port_out_Data_en <='0';
			
			etrec<=r_wait;
			
			end case;
		end if;   --reset='1'
  end process preceiv;
  
  psend:process(clk,reset)
		--gnration des paquets  partir du  port courant
		variable pactype :natural range 0 to 15;
		variable destport : natural range 0 to 15:=0;
		variable realdlen, i,i_pair : natural range 0 to 255;
		
		
		
				begin
				if reset='1' then 
				 etsnd<=s_head;
				 
				else  --reset ='0'
						 
						if rising_edge(clk) then -- le process s'excute sur chaque front 
															-- montant de l'horloge
						case etsnd is
						when s_init =>
							if port_in_full='0' and Cts_dat='1' then   --on peut aussi tester si le port est vide
							        etsnd<=s_head;
							end if;
						when s_head  =>    -- construction et envoie de l'en-tte
						pactype:=to_integer(MPI_INIT);--
						realdlen:=to_integer(Datalen)+2;
						--? destport:=MAXPORT; -- le port de destination
						
						--header<=STD_LOGIC_VECTOR(to_unsigned(pactype,4)) & STD_LOGIC_VECTOR(to_unsigned(destport,4));
						 tosend<=MPI_INIT & PortNum_i;
						 Port_in_wr_en<='1';   -- 
						 din<='1';
						 i:=1;i_pair:=i /2;
						 etsnd<=s_len;  -- passer  l'tat suivant
						 --port1_in<=tosend1;
						when s_len => 
							tosend<=(STD_LOGIC_VECTOR(to_unsigned(Realdlen,8)));
							Port_in_wr_en <='1';
							din<='1';

							--port1_in<=tosend1; --copie directe sur le port 
							etsnd3<=s_len2;
						when s_len2 => 
							tosend<=(STD_LOGIC_VECTOR(to_unsigned(realdlen,8)));
							Port_in_wr_en<='1';
							din<='1';

							--port1_in<=tosend1; --copie directe sur le port 
							etsnd3<=s_data;	
	
						when s_data =>
							
							if Port_in_full='0'and CTS_data='1' then
								Port_in_wr_en<='1';
								din<='1';
								     --envoie des donnes sur le port   
									tosend<=DataToSend(i);
								
								i:=i+1;
								if i>datalen then
									etsnd3<=s_end;
								end if;
							else
								Port_in_wr_en<='0';
								din<='0';
							end if;
						when s_end  =>
						tosend3<="--------";
							din3(origport)<='0';
							if fifo_in_empty(origport)='1' then
								etsnd3<=s_head;
							else
								etsnd3<=s_end;
							end if;
						end case;	
						
						end if;				
						
					end if; --reset='1'
		end process psend;		
pcmd:process(clk,reset)
	
	variable origport,destport,pid,mport : natural range 0 to 15;
	variable datalen,dcount ,timeout:natural range 0 to 255;
	begin
	
	if reset='1' then
		etcmd<=cmdstart;
		destport:=0;
		timeout:=0;
		origport:=1;
		sorigport<=origport;
	elsif rising_edge(clk) then
			case  etcmd is
			when cmdstart =>
				if Port_in_empty='1' and RTS_init='1' then 
							etcmd<=cmdpost;
				
				end if;
		 when cmdpost =>
			if Port_in_empty='1' then 
				etcmd<=cmdpostidle;
			end if;
		when cmdpostidle  =>   --permet juste la prise en compte de la commande
				etcmd<=cmdread;
		 when cmdread =>
				
				
				timeout:=0;
				
			if Port_out_data_available='1' then 
				mport:=to_integer(unsigned(port_out_data(7 downto 4)));
				pid:=to_integer(unsigned(port_out_data(3 downto 0)))+1;
				--cdata_out_en(origport)<='1';
				if pid=origport then --le port a t bien identifi
						etcmd<=cmdlen; --
					else
					etcmd<=cmdtimeout;
				end if;
			else

				etcmd<=cmdread;
			end if;
			
			
			when cmdlen =>   --positionnement du mot de longueur des donnes
			if Port_out_data_available='1' then 
			
			etcmd<=cmdglen;
			timeout:=0;
			else
				timeout:=timeout+1;
					if timeout>=30 then 
						etcmd<=cmdtimeout;             -- donnes pas prtes
					end if;
			
			
			end if;
			when cmdglen =>   --lecture effective de la longueur des donnes
			if Port_out_data_available='1' then 
			datalen:=to_integer(unsigned(portout(origport)(7 downto 0)))-3;
			
			etcmd<=cmddata;
			dcount:=0;  -- initialisation du compteur de reception
			else
				timeout:=timeout+1;
					if timeout>=30 then 
					--time_out(destport)<='1';
						etcmd<=cmdtimeout;             -- donnes pas prtes
					end if;
			
			end if;
			
			when cmddata =>
			if port_out_data_available='1' and timeout<30 then 
					
					--cdata_out_en(origport)<='1';
					mport:=to_integer(unsigned(port_out_data(7 downto 4)));
					--attention les ports sont numrots  partir de 0
					pid:=to_integer(unsigned(port_out_data(3 downto 0)))+1;
					etcmd<=cmdend;
					
			else
					
					if timeout>=30 then 
					   time_out(destport)<='1';
						etcmd<=cmdtimeout;             -- donnes pas prtes
					end if;
				   timeout:=timeout+1;
					
			end if;
			when cmdend =>
		
					etcmd<=cmdstart;

			when cmdtimeout =>

			  etcmd<=cmdstart;
			end case;
		sorigport<=origport;	
		end if;   --reset='1'
		
  end process pcmd;	

majetcmd:process (etcmd)
variable origport : natural:=sorigport ;
	begin
			case  etcmd is
		when cmdstart =>
			
				Port_in_cmd_en<='1';

		 when cmdpost | cmdpostidle =>
				din4(origport)<='1';
				tosend4<="00000001"; ---code pour getportid
				Port_in_cmd_en<='1';
				cdata_out_en(origport)<='0';
		 when cmdread =>
				din4<='0';
				cdata_out_en<=port_out_data_available;
				Port_in_cmd_en<='1';
	
		when cmdlen |cmdglen =>   --positionnement du mot de longueur des donnes
	
					din4<='0';
					cdata_out_en<=port_out_data_available;
					Port_in_cmd_en<='1';

		when cmddata =>
			
					din4<='0';
					cdata_out_en<=Port_out_data_available;
					Port_in_cmd_en<='1';
						
			
			when cmdend =>
			
				din4<='0';
				cdata_out_en<='0';
				Port_in_cmd_en<='0';
			
			when cmdtimeout =>
				  din4<='0';
				  cdata_out_en<='0';
				  Port_in_cmd_en<='0';
			 
			end case;
		
end process majetcmd ; 
end Behavioral;

