----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:53:00 06/13/2011 
-- Design Name: 
-- Module Name:    round_robbin_machine - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity round_robbin_machine is
    Port ( get_request_fifo_empty : in  STD_LOGIC;
           instruction_fifo_empty : in  STD_LOGIC;
           priority_rotation : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           fifo_selected : out  STD_LOGIC;
           instruction_available : out  STD_LOGIC;
           reset : in  STD_LOGIC;
           mux_sel : out  STD_LOGIC);
end round_robbin_machine;

architecture Behavioral of round_robbin_machine is
signal priority : std_logic;
signal fifo_selected_signal : std_logic;

begin
-- instruction disponible si au moins un fifo n'est pas vide
instruction_available <= '0' when instruction_fifo_empty = '1' and get_request_fifo_empty = '1' else
								 '1';
--signal  indiquant a EX1_FSM le fifo selectionne
fifo_selected <= fifo_selected_signal;
mux_sel <= fifo_selected_signal;	
						 
rr_machine_process : process(clk)
begin
	if rising_edge(clk) then
		if reset  = '1' then
		   priority <= '0';
			fifo_selected_signal <= '0';
		 elsif priority_rotation = '1' then
		    if priority = '0' then
			    if instruction_fifo_empty = '0' then
				    fifo_selected_signal  <= '0';
					elsif get_request_fifo_empty = '0' then
					 fifo_selected_signal  <= '1';
				  end if;
			    priority <= '1';
           else 
				if get_request_fifo_empty = '0' then
				    fifo_selected_signal  <= '1';
					 elsif instruction_fifo_empty = '0' then
					 fifo_selected_signal  <= '0';
				  end if;
			    priority <= '0';
			  end if;
		end if;
	end if;
 end process;
end Behavioral;

