----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    12:16:03 06/13/2011 
-- Design Name: 
-- Module Name:    MPI_CORE_SCHEDULER - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity MPI_CORE_SCHEDULER is
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           priority_rotation : in  STD_LOGIC;
           instruction_fifo_empty : in  STD_LOGIC;
           get_request_fifo_empty : in  STD_LOGIC;
           instruction_fifo_rd_en : out  STD_LOGIC;
           get_request_fifo_rd_en : out  STD_LOGIC;
           instruction_fifo_data : in  STD_LOGIC_VECTOR (7 downto 0);
           get_request_fifo_data : in  STD_LOGIC_VECTOR (7 downto 0);
           fifo_selected : out  STD_LOGIC;
           instruction_available : out  STD_LOGIC;
           fifo_empty : out  STD_LOGIC;
           fifo_rd_en : in  STD_LOGIC;
           data_out : out  STD_LOGIC_VECTOR (7 downto 0));
end MPI_CORE_SCHEDULER;

architecture Behavioral of MPI_CORE_SCHEDULER is

signal sel_signal : std_logic;
-- declaration des composants du scheduler
COMPONENT DEMUX1
	PORT(
		di : IN std_logic;
		sel : IN std_logic;          
		do1 : OUT std_logic;
		do2 : OUT std_logic
		);
	END COMPONENT;
	
COMPONENT MUX1
	PORT(
		di1 : IN std_logic;
		di2 : IN std_logic;
		sel : IN std_logic;          
		do : OUT std_logic
		);
	END COMPONENT;

COMPONENT MUX8
	PORT(
		di1 : IN std_logic_vector(7 downto 0);
		di2 : IN std_logic_vector(7 downto 0);
		sel : IN std_logic;          
		do : OUT std_logic_vector(7 downto 0)
		);
	END COMPONENT;
	
COMPONENT round_robbin_machine
	PORT(
		get_request_fifo_empty : IN std_logic;
		instruction_fifo_empty : IN std_logic;
		priority_rotation : IN std_logic;
		clk : IN std_logic;
		reset : IN std_logic;          
		fifo_selected : OUT std_logic;
		instruction_available : OUT std_logic;
		mux_sel : OUT std_logic
		);
END COMPONENT;
begin
-- instances des composants


mpi_core_rr_machine: round_robbin_machine PORT MAP(
		get_request_fifo_empty => get_request_fifo_empty,
		instruction_fifo_empty => instruction_fifo_empty,
		priority_rotation => priority_rotation ,
		clk => clk,
		fifo_selected => fifo_selected,
		instruction_available => instruction_available ,
		reset => reset,
		mux_sel => sel_signal
	);


Fifo_empty_MUX: MUX1 PORT MAP(
		di1 => instruction_fifo_empty ,
		di2 => get_request_fifo_empty,
		do => fifo_empty,
		sel => sel_signal 
	);
	
	

rd_en_demux: DEMUX1 PORT MAP(
		di => fifo_rd_en ,
		sel => sel_signal,
		do1 => instruction_fifo_rd_en,
		do2 => get_request_fifo_rd_en
	);
	
data_MUX8: MUX8 PORT MAP(
		di1 => instruction_fifo_data ,
		di2 => get_request_fifo_data,
		sel => sel_signal,
		do => data_out
	);



end Behavioral;

