----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL
-- 			 GAMOM ROLAND CHRISTIAN
-- 
-- Create Date:    04:39:43 05/21/2011 
-- Design Name: 
-- Module Name:    DMA_ARBITER - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- gestionnaire DMA pour le port secodaire de la RAM true dual port des mmoire 
-- prive de chaque noeud
-- Dependencies: 
-- 
-- Revision: 25/04/2012
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity DMA_ARBITER is
    Port ( dma_rd_request : in  STD_LOGIC;
           data_wr_in : in  STD_LOGIC_VECTOR (7 downto 0);
           data_rd_in : in  STD_LOGIC_VECTOR (7 downto 0);
           address_rd : in  STD_LOGIC_VECTOR (15 downto 0);
           address_wr : in  STD_LOGIC_VECTOR (15 downto 0);
           address_out : out  STD_LOGIC_VECTOR (15 downto 0);
           ram_en : out  STD_LOGIC;
           ram_we : out  STD_LOGIC;
           data_wr_out : out  STD_LOGIC_VECTOR (7 downto 0);
           data_rd_out : out  STD_LOGIC_VECTOR (7 downto 0);
           dma_wr_grant : out  STD_LOGIC;
			  dma_req       : out STD_Logic;  --requete vers application
			  dma_ack       : in  STD_Logic;  --autorisation par l'application
			  clk           : in std_logic;
			  reset		    : in std_logic;
           dma_rd_grant : out  STD_LOGIC;
           dma_wr_request : in  STD_LOGIC);
end DMA_ARBITER;

architecture Behavioral of DMA_ARBITER is
type fsm_states is (idle,wait_ack,arbiter_ack, writing,reading);-- definition du type etat pour le codage des etats des fsm
signal dmac_state : fsm_states;
signal priority : std_logic;
signal dma_rd_logic : std_logic;
signal dma_wr_logic : std_logic;
begin
data_rd_out <= data_rd_in;
data_wr_out <= data_wr_in;
dma_wr_logic <= (dma_wr_request and priority) or (not(dma_rd_request) and dma_wr_request);
dma_rd_logic <= (dma_rd_request and not(priority)) or (not(dma_wr_request) and dma_rd_request); 
dma_req<=dma_wr_request or dma_rd_request;  -- construire le signal request vers l'extrieur

-- machine  etat du DMAC
dmac_process : process(clk)
begin 
	if rising_edge(clk) then 
	 if reset = '1' then
		dmac_state<= idle;
		priority <= '0'; -- au debut priorit  la lecture
	  else 
		  case dmac_state is
		   when idle => if dma_rd_request='1' or dma_wr_request='1' then
									dmac_state<=wait_ack;
								end if;
			when wait_ack =>
						if dma_ack='1' then
							dmac_state<=arbiter_ack;
						end if;
				
			when arbiter_ack => if dma_wr_logic ='1' then -- pile pas vide on doit dpiler
									dmac_state <= writing;
								 elsif dma_rd_logic ='1' then
								   dmac_state <= reading;
								end if;
			when Writing => if dma_wr_request ='0' then
									dmac_state <= idle;
							    end if;
			when Reading => if dma_rd_request ='0' then
									dmac_state <= idle;
							    end if;
			when others => dmac_state <= idle;
		   end case;
	 end if;
	end if;
end process;
-- action_asocies
ol: process(dmac_state, address_rd, address_wr)
begin
case dmac_state is
		when idle => 
							ram_en <='0';
							ram_we <='0';
							dma_wr_grant <='0';
							dma_rd_grant <='0';
							address_out <= address_rd;
							dma_req<='0';
		when wait_ack =>
							ram_en <='0';
							ram_we <='0';
							dma_wr_grant <='0';
							dma_rd_grant <='0';
							address_out <= address_rd;
							dma_req<='1';
		when arbiter_ack =>  -- optimiser pour gagner un cycle
							ram_en <='1';
							ram_we <='0';
							dma_wr_grant <='0';
							dma_rd_grant <='0';
							address_out <= address_rd ;
		when writing => -- ecriture dans la ram
		               ram_en <='1';
							ram_we <='1';
							dma_wr_grant <='1';
							dma_rd_grant <='0';
							address_out <= address_wr;
							dma_req<='1';							
							
							
		when Reading => -- lecture dans la ram
							ram_en <='1';
							ram_we <='0';
							dma_wr_grant <='0';
							dma_rd_grant <='1';
							address_out <= address_rd;
							dma_req<='1';
		when others => 
						   ram_en <='0';
							ram_we <='0';
							dma_wr_grant <='0';
							dma_rd_grant <='0';
							address_out <= address_rd;
							dma_req<='0';
		end case;
end process;
end Behavioral;

