----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUELL GEL EN 5
-- 
-- Create Date:    01:02:10 06/17/2011 
-- Design Name: 
-- Module Name:    EX2_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- machine a etat qui execute la reception des packet dans le core mpi
-- Dependencies: 
--ss
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use Work.Packet_type.ALL;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity EX2_FSM is

   generic (
				 pid : std_logic_vector(3 downto 0) :="0001"; -- id du processeur
				 nprocs : std_logic_vector(3 downto 0):="0100"-- nombre de processeur du MPSOC - 1
			 );
    Port ( dma_grant : in  STD_LOGIC;
           fifo_full : in  STD_LOGIC;
           switch_data_available : in  STD_LOGIC;
           switch_port_out_data : in  STD_LOGIC_VECTOR (7 downto 0);
           dma_request : out  STD_LOGIC;
			  ram_address : out std_logic_vector(15 downto 0);
           fifo_data : out  STD_LOGIC_VECTOR (7 downto 0);
           fifo_wr_en : out  STD_LOGIC;
           packet_received : out  STD_LOGIC;
           packet_ack : in  STD_LOGIC;
           barrier_completed : out  STD_LOGIC;
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           switch_port_out_rd_en : out  STD_LOGIC);
end EX2_FSM;

architecture Behavioral of EX2_FSM is
-- dfinition du type etat de la machine  etat
type fsm_states is (fetch_packet_type, decode_packet_type, decode_packet_type2, fetch_addresses, execute_put1,execute_put2,execute_put3, execute_get1, execute_get2, execute_barrier1, execute_barrier2, execute_barrier3, execute_barrier4, execute_barrier5, execute_barrier6, execute_barrier7);
signal ex2_state_mach :fsm_states;
-- machine a etat du module
signal packet_type : std_logic_vector(3 downto 0);
signal packet_length : std_logic_vector(7 downto 0);
signal barrier_counter : std_logic_vector(3 downto 0);
signal pading_data :  std_logic_vector(7 downto 0);
signal n : std_logic_vector(3 downto 0);
signal dest_address : std_logic_vector(15 downto 0);
signal data_to_write_fifo :  std_logic_vector(7 downto 0);


begin
ram_address <= dest_address;
fifo_data <= data_to_write_fifo;

-- processus de transistion entre les etats 
fsm_nst_logic : process(clk)
begin
 if rising_edge(clk) then
	if reset = '1' then
	ex2_state_mach <= fetch_packet_type;
	barrier_counter <= "0000";
	 else
		  case ex2_state_mach is
			 when fetch_packet_type => if switch_data_available ='1' then 								
											      ex2_state_mach  <= decode_packet_type;
									         else
											      ex2_state_mach <= fetch_packet_type;
								           end if;
			when decode_packet_type => if switch_data_available ='0' then
													ex2_state_mach <= decode_packet_type;
												else
													 if packet_type = MPI_PUT then
													    packet_length <= switch_port_out_data - 2;
														 n <="0000";
														 ex2_state_mach <= decode_packet_type2;
													  elsif packet_type = MPI_GET then
													    packet_length <= packet_length - 2 ;
														 ex2_state_mach <= decode_packet_type2;
													  elsif packet_type = MPI_BARRIER_REACHED or packet_type = MPI_BARRIER_COMPLETED then
													    packet_length <= switch_port_out_data;
														 n <= "0000";
														 ex2_state_mach <= execute_barrier1;
													  else
														  ex2_state_mach <= decode_packet_type;
													 end if;
												end if;
			when decode_packet_type2 => if packet_type = MPI_PUT then
													ex2_state_mach <= fetch_addresses;
												  else
												 	ex2_state_mach <= execute_get1;							  
							               end if;        									
         when fetch_addresses => if  switch_data_available = '1' and n = 0 then
												  dest_address(15 downto 8) <= switch_port_out_data;
												  n <= n + 1;
												  ex2_state_mach <= fetch_addresses;
												elsif switch_data_available = '1' and n = 1 then
												  dest_address(7 downto 0) <= switch_port_out_data;
												  packet_length <= packet_length - 2;	
												  ex2_state_mach <= execute_put1;
												else
												  ex2_state_mach <= fetch_addresses;
								         end if;				
												 -- execution du mpi put
			when execute_put1 => if dma_grant = '1' then
										  ex2_state_mach <= execute_put2;
										 else
										  ex2_state_mach <= execute_put1;
								      end if;	
			when execute_put2 => if switch_data_available = '1' and packet_length > 0 then
										    packet_length <= packet_length - 1;
										    dest_address <= dest_address + 1;
											 ex2_state_mach <= execute_put2;
										elsif packet_length = 0 then
										    ex2_state_mach <= execute_put3;
									    else
										   ex2_state_mach <= execute_put2;	 
									    end if;								
			when execute_put3 => if packet_ack = '1'  then
										   ex2_state_mach <= fetch_packet_type;
										 else
										   ex2_state_mach <= execute_put3;
								      end if;	
			when execute_get1 =>  if switch_data_available = '1' then  -- conversion du get en put en empilement dans le fifo
										     data_to_write_fifo <= MPI_PUT & switch_port_out_data(3 downto 0);
											  packet_length <= packet_length - 1;
											  ex2_state_mach <= execute_get2;
								      end if;	
			when execute_get2 => if fifo_full = '0'and switch_data_available ='1' and packet_length > 0 then
										   data_to_write_fifo <= switch_port_out_data;
											packet_length <= packet_length - 1;
										   ex2_state_mach <= execute_get2;
										elsif packet_length = 0 and  switch_data_available ='1' then--
										   ex2_state_mach <= fetch_packet_type;
										  else
										   ex2_state_mach <= execute_get2;
								    end if;	
								-- execution du barrier
			when execute_barrier1 => if switch_data_available = '1' then
												 pading_data <= switch_port_out_data;
												 ex2_state_mach <= execute_barrier2;
											  else
											    ex2_state_mach <= execute_barrier1;	
											 end if;	
			when execute_barrier2 => if packet_type = MPI_BARRIER_REACHED then
												 barrier_counter <= barrier_counter + 1;
												 ex2_state_mach <= execute_barrier4;	
											  else
											    ex2_state_mach <= execute_barrier3;	
											 end if;	
			when execute_barrier3 => if n < 10 then
												 n <= n + 1;
												 ex2_state_mach <= execute_barrier3;	
											  else
											    ex2_state_mach <= fetch_packet_type;	
											 end if;	
			when execute_barrier4 => if barrier_counter = nprocs then -- entete du packet MPI_BARRIER_COMPLETED 
												 data_to_write_fifo <= MPI_BARRIER_COMPLETED & "0000";
												 ex2_state_mach <= execute_barrier5;	
											  else
											    ex2_state_mach <= fetch_packet_type;	
											 end if;	
			when execute_barrier5 => if fifo_full = '0' then  -- taille du packet MPI_BARRIER_COMPLETED
												 data_to_write_fifo <= "00000011";
												 ex2_state_mach <= execute_barrier6;	
											  else
											    ex2_state_mach <= execute_barrier5;	
											 end if;		
			when execute_barrier6 => if fifo_full ='0' then -- troisime octet du packet MPI_BARRIER_COMPLETED
												 data_to_write_fifo <= "00000000";
												 ex2_state_mach <= execute_barrier7;	
											  else
											    ex2_state_mach <= execute_barrier6;	
											 end if;				
			when execute_barrier7 => if fifo_full = '0' then
												 barrier_counter <= "0000";
												 ex2_state_mach <= fetch_packet_type;	
											  else
											    ex2_state_mach <= execute_barrier7;	
											 end if;				
			
			when others => ex2_state_mach <= fetch_packet_type;
		   end case;
    end if;
  end if;
 end process;
 
 -- sortie de la machine  etat
 ex1_fsm_action : process(ex2_state_mach, fifo_full, switch_port_out_data, packet_length, data_to_write_fifo, packet_type, switch_data_available)
  begin   
-- code fonctionnel	
	case ex2_state_mach is
	
		when fetch_packet_type => fifo_wr_en <= '0';
										  switch_port_out_rd_en <= switch_data_available;
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';										
								  
		when decode_packet_type => fifo_wr_en <= '0';
										  switch_port_out_rd_en <= switch_data_available;
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';	
		
		when decode_packet_type2 => fifo_wr_en <= '0';
										    switch_port_out_rd_en <= '0';
										    packet_received <= '0'; 
										    dma_request <= '0';
										    barrier_completed <= '0';	
		
		when fetch_addresses =>  fifo_wr_en <= '0';
										  switch_port_out_rd_en <= switch_data_available;
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';	
		
		when execute_put1 =>      fifo_wr_en <= '0';
										  switch_port_out_rd_en <= '0';
										  packet_received <= '0'; 
										  dma_request <= '1';
										  barrier_completed <= '0';	
		
		when  execute_put2 =>     fifo_wr_en <= '0';
										   if switch_data_available = '1' and packet_length > 0 then
											 switch_port_out_rd_en <='1';
											else
										    switch_port_out_rd_en <='0';
											end if;
										  packet_received <= '0'; 
										  dma_request <= '1';
										  barrier_completed <= '0';	
		
		when execute_put3 =>      fifo_wr_en <= '0';
										  switch_port_out_rd_en <= '0';
										  packet_received <= '1'; 
										  dma_request <= '0';
										  barrier_completed <= '0';	
										  
		when execute_get1=>       fifo_wr_en <= '0';
										  switch_port_out_rd_en <= switch_data_available;
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';	
		
		when execute_get2 =>	     if fifo_full = '0' and switch_data_available = '1'  and packet_length > 0 then
										    fifo_wr_en <= '1';
											 switch_port_out_rd_en <='1';
										  else
										    fifo_wr_en <= '0';
											 switch_port_out_rd_en <='0';
										  end if;
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';   
		
		when execute_barrier1 =>  fifo_wr_en <= '0';
										  switch_port_out_rd_en <= switch_data_available;
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';   
										  
		when execute_barrier2 =>  fifo_wr_en <= '0';
										  switch_port_out_rd_en <='0';
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';    
										  
		when execute_barrier3 =>	fifo_wr_en <= '0';
										  switch_port_out_rd_en <='0';
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '1';	 
		
		when execute_barrier4 =>   fifo_wr_en <= '0';
										  switch_port_out_rd_en <='0';
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';
										  
		when execute_barrier5 =>  fifo_wr_en <= not(fifo_full);
										  switch_port_out_rd_en <='0';
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';										  
										  
		when execute_barrier6 =>  fifo_wr_en <= not(fifo_full);										 
										  switch_port_out_rd_en <= '0';
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';	 	
		
		when execute_barrier7 =>  fifo_wr_en <= not(fifo_full); 
										  switch_port_out_rd_en <= '0';
										  packet_received <= '0'; 
										  dma_request <= '0';
										  barrier_completed <= '0';		 	
								
		when others => 	
									
	end case;
	
 end process;

end Behavioral;

