--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions
-- package definissant le codage des fonctions MPI 
-- dans le champs packet type des instructions MPI 

-- Ce fichier dfinit les trames des instruction MPI qui sont utilisables
library IEEE;
use IEEE.STD_LOGIC_1164.all;

package Packet_type is
 constant MPI_COMM_WORLD							:natural:=1;
 constant MPI_DEFAULT								:natural:=0;
 constant MPI_INT										:natural:=1;
 constant MPI_INFO_NULL								:natural:=0;
 constant Default_Win								:natural:=1;
 constant MPI_GET_RANK								: std_logic_vector(3 downto 0) := "0000";
 constant MPI_GET_SIZE								: std_logic_vector(3 downto 0) := "0001";
 constant MPI_BARRIER								: std_logic_vector(3 downto 0) := "0010";
 constant MPI_BARRIER_REACHED						: std_logic_vector(3 downto 0) := "0011";
 constant MPI_BARRIER_COMPLETED					: std_logic_vector(3 downto 0) := "0100";
 constant MPI_PUT   									: std_logic_vector(3 downto 0) := "0101";
 constant MPI_GET  									: std_logic_vector(3 downto 0) := "0110";
 constant MPI_BROADCAST								: std_logic_vector(3 downto 0) := "0111";
 constant MPI_INIT     								: std_logic_vector(3 downto 0) := "1000";
 constant MPI_SPWAN									: std_logic_vector(3 downto 0) := "1001";
 
 constant MPI_WINCREATE								: std_logic_vector(3 downto 0) := "1010";
 constant MPI_WINCOMPLETE							: std_logic_vector(3 downto 0) := "1011";
 constant MPI_WINPOST								: std_logic_vector(3 downto 0) := "1100";
 constant MPI_WINWAIT								: std_logic_vector(3 downto 0) := "1101";
 
 
 
 constant MPI_WTIME
 constantMPI_WTICK 
 constant MPI_CONFIG								   : std_logic_vector(3 downto 0) := "1101";
 --paramtres des commandes
 Constant INIT_SEEKMAIN								: std_logic_vector(3 downto 0) := "0001";
 Constant INIT_SETRANK								: std_logic_vector(3 downto 0) := "0010";
 Constant INIT_REGISTER								: std_logic_vector(3 downto 0) := "0011";
-- constantes pour le NoC								
 Constant NOC_GETPORTID								: std_logic_vector(7 downto 0) := "00000001";


Type MPI_Datatype is (MPI_BYTE,MPI_INTEGER,MPI_REAL,MPI_PACKET, MPI_pointer);
SUBType MPI_COMM is  natural range 0 to 2**ADRLEN-1 ; --pointeur sur la structure du communicateur
subType Mpi_AInt is natural range 0 to 2**ADRLEN-1 ;

Type MPI_COMM_struc is record
   id : natural range 0 to 3; -- id du communicateur
	grp : std_logic_vector(15 downto 0);     --groupe associ au communicateur
	nproc : natural range 0 to 15;   -- nombre de membres du groupe de ce communicateur
	AddrLib : std_logic_vector(15 downto 0); -- adresse dans la mmoire de la Lib 
														  -- des registres GStart et GPost
	C_open,C_close : std_logic;  -- tat du communciateur (Inistialis ou finalis)
end record;

Type Mpi_Win is record 
	status : std_logic_vector(7 downto 0); --tat de la fentre (create,Start,Complete,Post,WaitSync, etc.)
	id : natural range 0 to 15 ; -- numro de la fentre
	
	Addr : std_logic_vector(15 downto 0); -- adresse dans la mmoire locale du PE
	Size : natural range 0 to 65535; -- taille de la fentre en octets 
	
	comm : MPI_COMM; -- communicateur associ  la fentre
end record;
Type Mpi_group is record
	grp : std_logic_vector(15 downto 0); --( vecteur de la liste des processus du groupe)
	nb : natural range 0 to 15; -- nombre de membres(processus du groupe)
	comm_id : natural range 0 to 3; -- refrence du communicateur
end record;
end Packet_type;  

package body Packet_type is


end Packet_type;
