--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.numeric_std.all;
Library NocLib;
use NocLib.CoreTypes.all;
use work.PACKET_TYPE.all;

package Mpi_Rma is
--procedure pMPI_INIT(signal clkin:std_logic;signal SysRam :out typ_dpram);
procedure pMPI_PUT(signal clkin:std_logic;DestRank : natural;SrcAddr,DestAddr:std_logic_vector;Datalen : natural ;signal sysram :out typ_dpram;count: out natural);
procedure pMPI_GET(signal clkin:std_logic;DestRank : natural;SrcAddr,DestAddr:std_logic_vector;Datalen : natural ;signal sysram :out typ_dpram;count: out natural);
-- declare functions and procedure	 
  
end MPI_Rma;


package body MPI_Rma is

-- Example 1
procedure pMPI_PUT(signal clkin:std_logic; DestRank : natural; SrcAddr , DestAddr:std_logic_vector; Datalen : natural ;signal sysram :out Typ_dpram;count: inout natural) is
variable i,dcount : natural:=0;	
variable adresse :natural;
variable addr1 :std_logic_vector(srcaddr'length-1 downto 0):=srcaddr;
variable addr2 :std_logic_vector(destaddr'length-1 downto 0):=Destaddr;
constant LeftZero: std_logic_vector(2*Word-ADRLEN to 0):=(others=>'0');
	begin   
				if count /=0 then --prserver la valeur de count entre les appels
				dcount:=count;
				end if;
--					while (dcount<=6) loop
					if dcount <=6 then	
						if rising_edge(clkin) then
							if dcount=0 then 
							adresse:=core_put_adr;
							sysRam.Data_in<=MPI_PUT & std_logic_vector(to_unsigned(DestRank,4));
							elsif dcount=1 then 
							adresse:=core_put_adr+dcount;
							sysRam.Data_in<=std_logic_vector(to_unsigned(Datalen,8)) ;
							elsif dcount=2 then
							adresse:=core_put_adr+dcount;
							sysRam.Data_in<= Addr1(ADRLEN-1 downto Word) ;
							elsif dcount=3 then
							adresse:=core_put_adr+dcount;
							sysRam.Data_in<=Addr1(Word-1 downto 0);
							elsif dcount=4 then
							adresse:=core_put_adr+dcount;
							sysRam.Data_in<= Addr2(ADRLEN-1 downto Word) ;
							elsif dcount=5 then
							adresse:=core_put_adr+dcount;
							sysRam.Data_in<=Addr2(Word-1 downto 0);
							elsif dcount=6 then
							adresse:=core_base_adr+1;
--							
							sysRam.Data_in<=x"01"; --instruction pulse enable;
--							
--							
							end if;
							sysRam.Addr_wr<=Std_logic_vector(to_unsigned(adresse,ADRLEN));
							dcount:=dcount+1;
							end if;
							
						else
							dcount:=0;
						end if;
						  count:=dcount;
	end procedure;

--
 procedure pMPI_GET(signal clkin:std_logic;DestRank : natural;SrcAddr,DestAddr:std_logic_vector;Datalen : natural ;signal sysram :out typ_dpram;count: inout natural) is
  variable i,dcount : natural:=0;	
variable adresse :natural;
variable addr1 :std_logic_vector(srcaddr'length-1 downto 0):=srcaddr;
variable addr2 :std_logic_vector(destaddr'length-1 downto 0):=Destaddr;
constant LeftZero: std_logic_vector(2*Word-ADRLEN to 0):=(others=>'0');
	begin   
				if count /=0 then --prserver la valeur de count entre les appels
				dcount:=count;
				end if;
--					while (dcount<=6) loop
					if dcount <=6 then	
						if rising_edge(clkin) then
							if dcount=0 then 
							adresse:=core_get_adr;
							sysRam.Data_in<=MPI_PUT & std_logic_vector(to_unsigned(DestRank,4));
							elsif dcount=1 then 
							adresse:=core_get_adr+dcount;
							sysRam.Data_in<=std_logic_vector(to_unsigned(Datalen,8)) ;
							elsif dcount=2 then
							adresse:=core_get_adr+dcount;
							sysRam.Data_in<= Addr1(ADRLEN-1 downto Word) ;
							elsif dcount=3 then
							adresse:=core_get_adr+dcount;
							sysRam.Data_in<=Addr1(Word-1 downto 0);
							elsif dcount=4 then
							adresse:=core_get_adr+dcount;
							sysRam.Data_in<= Addr2(ADRLEN-1 downto Word) ;
							elsif dcount=5 then
							adresse:=core_get_adr+dcount;
							sysRam.Data_in<=Addr2(Word-1 downto 0);
							elsif dcount=6 then
							adresse:=core_base_adr+1;
--							
							sysRam.Data_in<=x"01"; --instruction pulse enable;
--							
--							
							end if;
							sysRam.Addr_wr<=Std_logic_vector(to_unsigned(adresse,ADRLEN));
							dcount:=dcount+1;
							end if;
							
						else
							dcount:=0;
						end if;
						  count:=dcount;
	end procedure;

end MPI_Rma;
