----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    21:20:54 07/16/2012 
-- Design Name: 
-- Module Name:    PE - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library NocLib ;
--use IEEE.STD_LOGIC_ARITH.ALL;
--use IEEE.STD_LOGIC_UNSIGNED.ALL;
use NocLib.CoreTypes.all;
use work.Packet_type.all;

use IEEE.NUMERIC_STD.ALL;


entity PE is
	Generic (DestId : natural );
    Port ( Instruction : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : out  STD_LOGIC;
			  Core_PushOut : in STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           Core_RAM_Data_Out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_In : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_WE : in  STD_LOGIC;
           Core_RAM_EN : in  STD_LOGIC;
           --Core_RAM_ENB : in  STD_LOGIC;
           Core_RAM_ADDRESS_WR : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_RAM_ADDRESS_RD : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_Hold_req : in  STD_LOGIC;
           Core_Hold_Ack : out  STD_LOGIC);
end PE;

architecture Behavioral of PE is
COMPONENT RAM_v
  generic (width : positive;size :positive);
	PORT(
		clka : IN std_logic;
		clkb : IN std_logic;
		wea : IN std_logic;
		ena : IN std_logic;
		enb : IN std_logic;
		addra : IN std_logic_vector;
		addrb : IN std_logic_vector;
		dia : IN std_logic_vector;          
		dob : OUT std_logic_vector
		);
	END COMPONENT;
--donnes du programme PE
	   --signaux pour l'interconnexionsignal datain :std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_we ,ram_ena,ram_enb,ramsel: std_logic:='0';
	signal pe_ram_we ,pe_ram_ena,pe_ram_enb: std_logic;
	signal pe_instr_en: std_logic:='0';
	signal ram_do,ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal pe_ram_do,pe_ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_addra,ram_addrb :std_logic_vector(ADRLEN-1 downto 0);
	signal pe_ram_addra,pe_ram_addrb :std_logic_vector(ADRLEN-1 downto 0);
	
	
	signal SrcAdr0,SrcAdr1,destAdr0,destAdr1,Datalen:std_logic_vector(word-1 downto 0);
	signal dpid,dpid_i : natural range 0 to 15:=DestId;
	
	
	signal Lib_Ready:std_logic; --indique que l'excution de la fonction est termine
	signal Lib_instr_ack : std_logic; -- l'instruction est copie dans le tampon FIFO
	signal Lib_Init : std_logic; -- l'initialisation est termine 
 --signaux pour la gestion de la MAE
 type typ_mae is (start,Fillmem,NextFill,InitApp,InitCompleted,writeptr,InstrCopy, 
 putdata,putdata2,putcompleted,getdata,getdata2,getcompleted,terminate,st_timeout);
signal dcount : natural range 0 to 255:=0; --permet de compter le packet de donnes envoyes
signal count,count_i : natural range 0 to 15:=0;


		signal etPutGet : typ_mae;
		signal Ram_busy :std_logic:='0';
begin
Inst_RAM_v: RAM_v generic map(width=>word,size=>ADRLEN)
	PORT MAP(
		clka =>clk,
		clkb => clk,
		wea => ram_we,
		ena => ram_ena,
		enb => ram_enb,
		addra => ram_addra,
		addrb =>ram_addrb,
		dia => ram_din,
		dob => ram_do 
	);
--================================================================
	--MUX de la RAM
                             	
 ram_addrb <= Core_ram_address_rd WHEN ramsel ='1' ELSE 
            pe_ram_addrb; 
 ram_addra <= Core_ram_address_wr WHEN ramsel ='1' ELSE 
            pe_ram_addra; 


ram_ena <= Core_ram_en WHEN ramsel ='1' ELSE 
            pe_ram_ena; 
ram_enb <= Core_ram_en WHEN ramsel ='1' ELSE 
            pe_ram_enb; 

		
ram_we<= Core_ram_we WHEN ramsel ='1' ELSE 
            pe_ram_we; 

ram_din <= Core_ram_data_in WHEN ramsel ='1' ELSE 
            pe_ram_din;
				

Core_ram_data_out<=ram_do when ramsel='1' else (others=>'Z');
pe_ram_do<=ram_do when ramsel='0' else (others=>'Z');
Instruction_En<=PE_instr_EN;
--=== !!!!! attention la suppression de la ligne ci-dessous empche ce 
-- composant de bien fonctionner !!! !!!!!!!!!!!!!!!!!!!!!!!
instruction<=std_logic_vector(to_unsigned(Core_upper_adr,8));
dpid<=dpid_i;

Lib_Instr_ack<=Core_Pushout(0); --l'instruction a t copi
Lib_init<=Core_Pushout(4); -- Initialized
-- pe_hold_req<=Core_hold_req;
--Core_hold_ack<=pe_hold_ack;

 hold:process (Core_Hold_Req,clk,reset)
 begin
 if rising_edge(clk) then
	if reset='1' then
		Core_Hold_Ack<='0';
	else
		if Core_Hold_Req='1' then
			ramsel<=not(ram_busy);
			Core_Hold_Ack<=not(ram_busy); --si la mmoire est occup, forc une libration
		else
			Core_Hold_Ack<='0';
			ramsel<='0';
		end if;
	end if;
 end if;
 end process hold;
--=======================================================================



--=======================================================================
--MAE du PE
--=======================================================================

 pPutGet:process(clk)
	
	variable bfill,destrank,pid,mport : natural range 0 to 15;
	variable fsrc,ret : natural range 0 to 15:=0;
	variable timeout : natural range 0 to 255;
	variable adrToset : std_logic_vector(ADRLEN-1 downto 0);
	variable iack : std_logic:='0';
	variable  adresse,adresse_rd :natural range 0 to 65536;
	variable status_reg,config_reg :std_logic_vector(Word-1 downto 0):=(others=>'0');
	begin
	
	if (clk'event and clk='1') then 
		if reset='1' then
					etputget<=start;
					
					
					dcount<=0;
			
		else
	
			case  etputget is
			when start =>
				if bfill=0 then -- si le nombre de bloc de mmoire remplis est vide
						etputget<=Fillmem;
				 end if;
				 Ram_busy<='0';
				 PE_Instr_En<='0';
				iack:='0';
				adresse:=256;
				adresse_rd:=0;
				timeout:=0;
				dcount<=0;
			 when Fillmem =>
				if Ramsel='0' then 
					
					
					
					PE_Ram_din<=std_logic_vector(to_unsigned(dcount,8)); -- x"0f";
					PE_Instr_En<='0';
					dcount<=dcount+1;
					
					if dcount=50 then
						 bfill:=bfill+1;
						 
						 if bfill=4 then
						  etputget<=InitApp;
						 else
							etputget<=nextfill;
						end if;
					else
						adresse:=adresse+1;
						etputget<=Fillmem;
					end if;
			else -- attente de la libraion de la mmoire
			        timeout:=timeout+1;
					  if timeout=100 then
						etputget<=st_timeout;
					  end if;
							
			end if;
		when nextfill  =>   --prpare le prochain bloc mmoire qui sera rempli
				adresse:=100*bfill;
				dcount<=0;
				etputget<=Fillmem;
				PE_Instr_En<='0';
		when InitApp =>
				--code pour Init ici
				--mettre mpi_init  l'adresse mpi 
				
				PE_Ram_din<=MPI_INIT & x"0" ;
				adresse:=core_init_adr;
				
				PE_Instr_En<='0';
				fsrc:=1;
				adrToSet:=std_logic_vector(to_unsigned(core_init_adr,16));
				if ret/=fsrc then
				dcount<=0;
					etputget<=writeptr;
					adresse:=core_base_adr+2;
					PE_Instr_En<='0';
				else
				if Lib_instr_ack='1' then  -- attente de la prise en compte de l'instruction
					etputget<=InitCompleted;
					PE_instr_en<='0';
				
				else
					PE_Instr_en<='1';
				end if;
				   
				end if;
		
		when writeptr =>
				PE_Instr_En<='0';
				if Ramsel= '0' then --s'assurer que le bus est disponible
					
					if dcount=0 then 
						PE_RAM_Din<=AdrToSet(Word-1 downto 0);
						dcount <=dcount+1;
						--adresse:=adresse+1; --prpare la prochaine criture
					elsif dcount=1 then
						dcount <=dcount+1;
						adresse:=adresse+1; --prpare la prochaine criture
						PE_RAM_Din<=AdrToSet(15 downto 8);
					elsif dcount=2 then -- ce cycle permet juste de vider le tampon d'criture en RAM
						ret:=fsrc;
						dcount<=0;
						timeout:=0;
						
								if fsrc=1 then
								etputget <= InitApp;
								elsif fsrc=2 then
								etputget <= putdata;
								elsif fsrc=3 then
								etputget <= getdata;
								else
								etputget <= start;
								end if;
							
					end if;
					
				end if;
		When InstrCopy =>
				if Lib_instr_ack='1' then
					etputget<=Writeptr;
					PE_instr_en<='0';
					iack:='1';
					
				else
					PE_Instr_en<='1';
				end if;
		
		when InitCompleted =>
				adresse:=CORE_BASE_ADR;
				status_reg:=status_reg or x"10";
				PE_Ram_din<=status_reg ;
				if Lib_Init='1' then
					etputget<=putdata;
					PE_Instr_En<='0';
					--instruction(5)<='1';
				else
					PE_Instr_En<='0';
				end if;
		when putdata => --construire le packet pour le Put
				DestRank:=1;
				adresse_rd:=core_base_adr+Core_Rank2port_base+DestRank;
				
				PE_Instr_En<='0';
				timeout:=0;
				dcount<=0;
				fsrc:=2;
				adrToSet:=std_logic_vector(to_unsigned(core_put_adr,16));
				if ret/=fsrc then
				  adresse:=core_base_adr+2;
					etputget<=writeptr;
					ret:=0;
				else
					if Lib_instr_ack/='1' then 
						etputget<= putdata2;
					end if;
				end if;
				
		when putdata2 =>
		
			if ramsel = '0' then  --si le PE a accs  la RAM
		      if dcount<=6 then
						
							PE_Instr_En<='0';
							if dcount=0 then 
							adresse:=core_put_adr;
							PE_Ram_din<=MPI_PUT & std_logic_vector(to_unsigned(Dpid,4));
							elsif dcount=1 then 
							adresse:=core_put_adr+dcount;
							PE_Ram_din<=Datalen ;
							elsif dcount=2 then
							adresse:=core_put_adr+dcount;
							PE_Ram_din<=SrcAdr1 ;
							elsif dcount=3 then
							adresse:=core_put_adr+dcount;
							PE_Ram_din<=SrcAdr0 ;
							elsif dcount=4 then
							adresse:=core_put_adr+dcount;
							PE_Ram_din<=DestAdr1 ;
							elsif dcount=5 then
							adresse:=core_put_adr+dcount;
							PE_Ram_din<=DestAdr0 ;
							elsif dcount=6 then
							adresse:=core_base_adr+1;
							adresse_rd:=core_base_adr;
							config_reg:=config_reg or x"01";
							PE_Ram_din<=config_reg; --instruction pulse enable;
							PE_Instr_En<='1';
							
							end if;
						dcount<=dcount+1;
					end if;
			elsif PE_instr_En='0' then
					timeout:=timeout+1;
					if timeout>=10 then -- reprendre le contrle du Bus de force si ncessaire
						ram_busy<='1';
						timeout:=0;
						PE_Instr_En<='0';
					end if;
			end if;
				if dcount >=6 then
						Ram_busy<='0';--librer le bus et attendre la rponse du Core MPI
						if Lib_instr_ack='1' then -- Instruction ack
						  PE_Instr_En<='0'; 
							if Ramsel='0' then
								adresse:=core_base_adr+1;
								config_reg:=config_reg and x"f6";
								PE_Ram_din<=config_reg ; --ramener le IPulse  0;
								Ram_busy<='0';
								etPutGet<=putcompleted;
							else
								
								Ram_busy<='1';  --force la prise du bus
							end if;
						else
						
						  timeout:=timeout+1; 
						  if timeout=150 then 
								etputget<=st_timeout;
							end if;
						end if;
				end if;
			
			
			when putcompleted =>
				adresse_rd:=core_put_adr+6;
				if PE_Ram_do(0)='1' then  --Put completed
					etPutGet<=GetData;
				end if;
				PE_Instr_En<='0';
			when getdata =>   --positionnement du mot de longueur des donnes
			   
				DestRank:=1;
				timeout:=0;
				dcount<=0;
					fsrc:=3;
				adrToSet:=std_logic_vector(to_unsigned(core_get_adr,16));
				if ret/=fsrc then
					adresse:=core_base_adr+2;
					etputget<=writeptr;
					ret:=0;
				else
					adresse:=core_get_adr;
					etputget<= getdata2;
				end if;
			    PE_Instr_En<='0';
				when getdata2 =>
					
					if ramsel='0' then
						if dcount<=6 then
							
							if dcount=0 then 
								adresse:=core_get_adr;
							PE_Ram_din<=MPI_GET & std_logic_vector(to_unsigned(Dpid,4));
							elsif dcount=1 then
							adresse:=core_get_adr+dcount;
							PE_Ram_din<=Datalen ;
							elsif dcount=2 then
							adresse:=core_get_adr+dcount;
							PE_Ram_din<=SrcAdr1 ;
							elsif dcount=3 then
							adresse:=core_get_adr+dcount;
							PE_Ram_din<=SrcAdr0 ;
							elsif dcount=4 then
							adresse:=core_get_adr+dcount;
							PE_Ram_din<=DestAdr1 ;
							elsif dcount=5 then
							adresse:=core_get_adr+dcount;
							PE_Ram_din<=DestAdr0 ;
							
							elsif dcount=6 then
							adresse:=core_base_adr+1;
							adresse_rd:=core_base_adr;
							PE_Instr_En<='1';
							config_reg:=config_reg or x"01";
							PE_Ram_din<=config_reg ; --instruction pulse enable;
							
							timeout:=0;
							end if;
							dcount<=dcount+1;
					 end if;
					elsif  PE_Instr_En='0'then
						timeout:=timeout+1;
						if timeout>=10 then -- reprendre le contrle du Bus de force si ncessaire
							ram_busy<='1';
							timeout:=0;
							PE_Instr_En<='0';
						end if;
					end if;
			
				  if dcount >=6 then
						  Ram_busy<='0';--librer le bus et attendre la rponse du Core MPI
								if Lib_instr_ack='1' then -- Instruction ack
								  PE_Instr_En<='0'; 
									if Ramsel='0' then
										adresse:=core_base_adr+1;
									config_reg:=config_reg and x"f6";
									PE_Ram_din<=config_reg ; --ramener le IPulse  0;
										 
										Ram_busy<='0';
										etPutGet<=getcompleted;
									else
										
										Ram_busy<='1';  --force la prise du bus
									end if;
								else
								
									  timeout:=timeout+1; 
									  if timeout=150 then 
											etputget<=st_timeout;
										end if;
								end if;
								
								
						end if;
						
				
					
				when getcompleted =>
				adresse_rd:=core_get_adr+6;
				PE_Instr_En<='0';
				if PE_Ram_do(0)='1' then  --get completed
				   if Ramsel='0' then
					adresse:=core_base_adr+1;
					config_reg:=config_reg and x"f6";
					PE_Ram_din<=config_reg ; --ramener le IPulse  0;
					 
					etPutGet<=Terminate;
					else
						timeout:=timeout+1;
					end if;
				end if;	
					
						
			when terminate =>
			
		
					etputget<=start;
					
			when st_timeout =>
			  
			  --if ram_busy='1' then
				 etputget<=start;
			  --end if
		
			  etputget<=start;
			end case;
			pe_Ram_addra<=STD_LOGIC_VECTOR(to_unsigned(adresse,16));
			pe_Ram_addrb<=STD_LOGIC_VECTOR(to_unsigned(adresse_rd,16));
		end if;   --reset='1'
	end if;
  end process pPutGet;	

majPutGet:process (etputget,pe_ram_do)

	begin
			case  etputget is
			when start =>
			
				   PE_Ram_we<='0';
					PE_Ram_ena<='0';
					PE_Ram_enb<='0';
					--PE_Instr_En<='0';

		 when fillmem =>
				   PE_Ram_we<='1';
					PE_Ram_ena<='1';
					
					PE_Ram_enb<='0';
					--PE_Instr_En<='0';
		 when nextfill =>
					PE_Ram_we<='1';
					PE_Ram_ena<='1';
					PE_Ram_enb<='0';
					--PE_Instr_En<='0';
	    when InitApp =>
				   PE_Ram_we<='1';
					PE_Ram_ena<='1';
					PE_Ram_enb<='0';
					--PE_Instr_En<='0';
		 when Initcompleted =>
			      
					PE_Ram_ena<='1';
					PE_Ram_we<='1';
					PE_Ram_enb<='0';

		 when writeptr =>
					PE_Ram_we  <='1';   --criture dans la RAM
					PE_Ram_ena <='1';
					
					PE_Ram_enb <='0';
			--		dcount<=dcount+1;
					
					--PE_Instr_En<='0';
		when InstrCopy =>  --instruction copy
				   PE_Ram_we<='0';
					PE_Ram_ena<='0';
					PE_Ram_enb<='0';

		
		when putdata =>   --positionnement du mot de longueur des donnes
				--dcount<=0;
				srcadr0<=X"00";
				srcadr1<=X"01";
				destadr0<=X"00";
				destadr1<=X"02";
				   PE_Ram_we<='0';
					PE_Ram_ena<='0';
					   --lecture du n de port de destination
					PE_Ram_enb<='1';
				datalen<=std_logic_vector(to_unsigned(50,8));
				dpid_i<=to_integer(unsigned(PE_ram_do(3 downto 0))); --le port est situ ur les 4 bits de poids faible
				--PE_Instr_En<='0';
			when putdata2 =>
					PE_Ram_we  <='1';   --criture dans la RAM
					PE_Ram_ena <='1';
					
					PE_Ram_enb <='0';
			
					
			when putcompleted =>			
					PE_Ram_we  <='1';
					PE_Ram_ena <='1';
					  -- lecture du rsultat
					PE_Ram_enb  <='1';
					--PE_Instr_En<='1';
			when getdata =>
				--dcount<=0;
				PE_Ram_we<='1';
				PE_Ram_ena<='1';
				PE_Ram_enb<='0';

				srcadr0<=X"00";
				srcadr1<=X"02";
				destadr0<=X"00";
				destadr1<=X"03";
				datalen<=std_logic_vector(to_unsigned(50,8));
				--PE_Instr_En<='0';	
			when getdata2 =>
				   PE_Ram_we  <='1';   --criture dans la RAM
					PE_Ram_ena <='1';
					
					PE_Ram_enb <='0';
				--dcount<=dcount+1;
				   if dcount=5 then
						--PE_Instr_En<='1';
					else
						--PE_Instr_En<='0';
					end if;
			when getcompleted =>				
					PE_Ram_we  <='1';
					PE_Ram_ena <='1';
					  -- lecture du rsultat
					PE_Ram_enb  <='1';
					--PE_Instr_En<='1';
			when terminate =>
			
				   PE_Ram_we<='0';
					PE_Ram_ena<='0';
					PE_Ram_enb<='0';
					--PE_Instr_En<='0';
			
			when st_timeout =>
				  PE_Ram_we<='0';
					PE_Ram_ena<='0';
					PE_Ram_enb<='0';
					--PE_Instr_En<='0';
			  
			end case;
		
end process majPutGet ; 
end Behavioral;

