----------------------------------------------------------------------------------
-- Company: 
-- Engineer:GAMOM /KIEGAING
-- 
-- Create Date:    08:12:29 06/16/2011 
-- Design Name: 
-- Module Name:    EX1_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Ce module est charg de recevoir les instructions du programme MPI et 
-- de les excuter (PUT) il coopre avec EX2 qui reoit les instructions venant du NoC
-- (GET)
--
-- Dependencies: 
--
-- Revision: 09/07/2012
-- Revision 0.03 - File updated
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library NocLib ;
use Work.Packet_type.ALL;
USE ieee.numeric_std.ALL;


use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity EX1_FSM is
    -- parametres generiques du module : 
				
	     
    Port ( 
	        --instruction_available : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           			  
			  instruction_en : in std_logic:='0';  -- active le module instruction
			   pid : in std_logic_vector(3 downto 0) ; -- id du processeur
				nprocs : in std_logic_vector(3 downto 0);-- nombre de processeur du MPSOC - 1
			  Result : out STD_LOGIC_VECTOR (7 downto 0):=(others=>'0'); -- le rsultat de l'excution de ce module
			  AppInitReq :out  STD_LOGIC:='0'; -- requte d'initialisation de l'application
			  AppInitAck :in  STD_LOGIC; -- Acquitement d'initialisation
			  Initialized:in std_logic ; -- tat de la Lib
                                 -- Accs au Fifo d'instructions
           priority_rotation : out  STD_LOGIC:='0';
           fifo_rd_en : out  STD_LOGIC:='0';
			  fifo_empty : in  STD_LOGIC;
           fifo_data_out : in  STD_LOGIC_VECTOR (7 downto 0);

												-- Accs au rseau sur puce
			  switch_port_in_full : in std_logic;
           switch_port_in_data : out  STD_LOGIC_VECTOR (7 downto 0):=(others=>'Z');
           switch_port_in_wr_en : out  STD_LOGIC:='0';
			                               -- Accs  la mmoire RAM du PE
			  ram_data_in : in std_logic_vector(7 downto 0);
			  ram_data_out : out std_logic_vector(7 downto 0):=(others=>'0');
			  ram_rd,ram_wr : out std_logic:='0';
			  ram_address : out std_logic_vector(15 downto 0):=(others=>'Z');
			  
			  dma_wr_request : OUT std_logic:='0';
				dma_rd_request : OUT std_logic:='0';
				dma_wr_grant : in  STD_LOGIC;
           dma_rd_grant : in  STD_LOGIC);
end EX1_FSM;

architecture Behavioral of EX1_FSM is
-- definition du type etat pour le codage des etats des fsm
type fsm_states is (fifo_select, fetch_packet_type, decode_packet_type, fetch_addresses,
 decode_packet_type2, read_status1,read_status2,execute_barrier1, execute_barrier2, execute_barrier3, execute_barrier4,
 execute_get1, execute_get2,execute_get3,execute_get4, execute_put1, execute_put2, execute_put3, execute_put4,execute_put5,
 execute_init1,execute_init2,execute_init3);
-- machine a etat du module
signal ex1_state_mach : fsm_states;

-- les variables utilises dans la fsm

signal data_to_send : std_logic_vector(Word-1 downto 0);
signal packet_type : std_logic_vector(3 downto 0);
--signal dpid : std_logic_vector(3 downto 0);
signal pid_counter : std_logic_vector(3 downto 0);
signal packet_length : std_logic_vector(Word-1 downto 0);
signal src_address : std_logic_vector(ADRLEN-1 downto 0);
signal Wr_ok,rd_ok:std_logic:='0';
--signal res_address : std_logic_vector(15 downto 0);
signal dest_address : std_logic_vector(ADRLEN-1 downto 0);
signal n : std_logic_vector(3 downto 0);
signal len : std_logic_vector(Word-1 downto 0);

begin
-- connection des signaux avec les ports
ram_address <= src_address;

-- processus de transistion entre les etats 
fsm_nst_logic : process(clk)
variable tempval : std_logic_vector(Word-1 downto 0);
begin
 if rising_edge(clk) then
	if reset = '1' then
	ex1_state_mach <= fifo_select;
	 else
		  case ex1_state_mach is
			 when fifo_select => if instruction_en='1' and fifo_empty  ='0' then 								
											ex1_state_mach  <= fetch_packet_type;
									   else
											ex1_state_mach <= fifo_select;
								      end if;
										--lecture du registre status de la mib MPI
			 when read_status1 => if dma_rd_grant = '1' then -- fin du mpi_put
										   ex1_state_mach <= read_status2;
										  else
											ex1_state_mach <= read_status1;
								      end if;
										src_address<=std_logic_vector(to_unsigned(core_base_adr,16));
			when read_status2 =>
										 ex1_state_mach <= fifo_select;
			when fetch_packet_type => if fifo_empty ='1' then
										ex1_state_mach <= fifo_select;
									 else
									   packet_type <= fifo_data_out(7 downto 4);
										data_to_send <= fifo_data_out;
										ex1_state_mach <= decode_packet_type;
							      end if;
			when decode_packet_type => 
												 if packet_type = MPI_PUT then
												    packet_length <= fifo_data_out + 4; 
													 n <= "0000";
													 ex1_state_mach <= fetch_addresses;
												  elsif packet_type = MPI_GET then
												    len <= fifo_data_out;
													 n <= "0000";	 
												    ex1_state_mach <= fetch_addresses;
												  elsif packet_type = MPI_BARRIER_REACHED or packet_type = MPI_BARRIER_COMPLETED then
												    packet_length <= "00000011"; --  = 3
													 pid_counter <= "0000";
													 ex1_state_mach <= execute_barrier1;
													elsif packet_type = MPI_INIT then
														ex1_state_mach<=execute_init1;
													 else -- packet non reconnu
													   if fifo_empty = '1' then
															ex1_state_mach <= fifo_select;
														else
															packet_type <= fifo_data_out(7 downto 4); --lire le prochain paquet
															data_to_send <= fifo_data_out;
															ex1_state_mach <= decode_packet_type;-- pas necessaire mais plus sure
														end if;
											     end if;												  
							                     									
         when fetch_addresses => if fifo_empty = '0' and n = 0 then
												  src_address(15 downto 8) <= fifo_data_out;
												  n <= n + 1;
												  ex1_state_mach <= fetch_addresses;
												elsif fifo_empty = '0' and n = 1 then
												  src_address(7 downto 0) <= fifo_data_out;
												  n <= n + 1;
												  ex1_state_mach <= fetch_addresses;
												elsif fifo_empty = '0' and n = 2 then
												  dest_address(15 downto 8) <= fifo_data_out;
												  n <= n + 1;
												  ex1_state_mach <= fetch_addresses;
												elsif fifo_empty = '0' and n = 3 then
												  dest_address(7 downto 0) <= fifo_data_out;
												  n <= "0000";
												  ex1_state_mach <= decode_packet_type2;
												 elsif fifo_empty='1' then
													ex1_state_mach <= fetch_addresses; --attendre les donnes manquantes
												 else
													 ex1_state_mach <= fifo_select;										
												end if;		
			when decode_packet_type2 => if packet_type = MPI_PUT  then
												    ex1_state_mach <= execute_put1;
												   elsif packet_type = MPI_GET then 
												    ex1_state_mach <= execute_get1;										
								             end if;	
												 -- execution du mpi put
			when execute_put1 => if dma_rd_grant = '1' then
										  ex1_state_mach <= execute_put2;
										 else
										  ex1_state_mach <= execute_put1;
								      end if;	
										Wr_ok<='0';
			when execute_put2 => if switch_port_in_full = '0' and n = 0 then
										  data_to_send <= packet_length;
										  n <= n + 1;
										  ex1_state_mach <= execute_put2;
										elsif switch_port_in_full = '0' and n = 1 then
										  data_to_send <= dest_address(15 downto 8);
										  n <= n + 1;
										  ex1_state_mach <= execute_put2;
										elsif switch_port_in_full = '0' and n = 2 then
										  data_to_send <= dest_address(7 downto 0);
										  n <= n +1;
										  ex1_state_mach <= execute_put2;
										elsif switch_port_in_full = '0' and  n = 3 then
										  packet_length <= packet_length - 4;
										  ex1_state_mach <= execute_put3;
										  Wr_ok<='0';
										 else
										  ex1_state_mach <= execute_put2;										
								     end if;								
			when execute_put3 => if unsigned(packet_length)>0 then
												if switch_port_in_full = '0'  then
													packet_length <= packet_length - 1;
													src_address <= src_address + 1;
													ex1_state_mach <= execute_put3;
													Wr_Ok<='1';
												else
													Wr_Ok<='0';
												end if;
										 else
											ex1_state_mach <= execute_put4;
										end if;	
			when execute_put4 => if dma_wr_grant = '1' then -- fin du mpi_put
										   ex1_state_mach <= execute_put5;
											n<="0000";
											data_to_send<="00000001";
											rd_ok<='1';
											wr_ok<='0';
										  else
											ex1_state_mach <= execute_put4;
								      end if;
										src_address<=std_logic_vector(to_unsigned(core_base_adr+4,16));
			when execute_put5 => 
											if n=0 then
												if dma_rd_grant='1' then
													n<=n+1;
													tempval:=Ram_data_in;
													src_address<=std_logic_vector(to_unsigned(core_base_adr+4,16));
													tempval(5):='1';			-- SET du bit DSENT
													data_to_send<=tempval;
													
												end if;
												rd_ok<='1';
												wr_ok<='0';
											elsif n=1 then
												if dma_wr_grant = '1'  then
													n<=n+1;
													
													src_address<=std_logic_vector(to_unsigned(core_base_adr+4,16));
												end if;
													rd_ok<='0';
													wr_ok<='1';
											elsif n=2 then
												if dma_wr_grant = '1'  then
													n<=n+1;
																								
													src_address<=std_logic_vector(to_unsigned(core_put_adr+6,16));

												end if;
													rd_ok<='0';
													wr_ok<='1';	
											elsif n=3 then
													if dma_wr_grant = '1'  then
														n<=n+1;
														
																-- SET du bit DSENT
														data_to_send<="00000001";
													end if;
														rd_ok<='0';
														wr_ok<='1';
											elsif n=4 then
														n<="0000";
														ex1_state_mach <= fifo_select;
														rd_ok<='0';
														wr_ok<='0';
											end if;
										 
			
			when execute_get1 => 	if switch_port_in_full = '0' and n = 0 then  -- execution du mpi get
										      data_to_send <= "00001000"; -- longueur du paquet sur le rseau ?
											   n <= n + 1;
											   ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 1 then
											   data_to_send <= "0000"&pid; -- Rang source
												n <= n + 1;
											   ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 2 then
											   data_to_send <= len;
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 3 then
											   data_to_send <= src_address(15 downto 8);
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 4 then
											   data_to_send <= src_address(7 downto 0);
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 5 then
											   data_to_send <= dest_address(15 downto 8);
												n <= n + 1;
												ex1_state_mach <= execute_get1;
											 elsif switch_port_in_full = '0' and n = 6 then
											   data_to_send <= dest_address(7 downto 0);
												n <= n + 1;
												ex1_state_mach <= execute_get2;
												 else
												  ex1_state_mach <= execute_get1;
								      end if;	
			when execute_get2 => if switch_port_in_full = '0' then
										 ex1_state_mach <= execute_get3;
										else
										 ex1_state_mach <= execute_get2;
								end if;	
			when execute_get3 => if dma_wr_grant = '1' then -- fin du post de mpi_get
										   ex1_state_mach <= execute_get4;
											n<="0000";
											data_to_send<="00000001";
										  else
											ex1_state_mach <= execute_get3;
								      end if;
										src_address<=std_logic_vector(to_unsigned(core_get_adr+6,16));
			when execute_get4 => 
											if n=0 then
												if  dma_rd_grant='1' then
													n<=n+1;
													tempval:=Ram_data_in;
													src_address<=std_logic_vector(to_unsigned(core_base_adr+4,16));
												end if;
												elsif n=1 then
													n<=n+1;
													src_address<=std_logic_vector(to_unsigned(core_base_adr+4,16));
												elsif n=2 then
													if dma_wr_grant = '1'  then
													n<=n+1;
													
													tempval(4):='0';			--RESET du bit DReceived
													tempval(1):='1';			-- SET du bit DReceiving
													data_to_send<=tempval;
													end if;
												elsif n=3 then
													n<="0000";
												ex1_state_mach <= fifo_select;
												end if;
										
								-- execution du barrier
			when execute_barrier1 => if switch_port_in_full = '0' then
												 ex1_state_mach <= execute_barrier2;	
											  else
											    ex1_state_mach <= execute_barrier1;	
											 end if;	
			when execute_barrier2 => if switch_port_in_full = '0' then
												 ex1_state_mach <= execute_barrier3;	
											  else
											    ex1_state_mach <= execute_barrier2;	
											 end if;	
			when execute_barrier3 => if switch_port_in_full = '0' then
												 ex1_state_mach <= execute_barrier4;	
											  else
											    ex1_state_mach <= execute_barrier3;	
											 end if;	
			when execute_barrier4 => if packet_type = MPI_BARRIER_COMPLETED and pid_counter < nprocs then
												 pid_counter <= pid_counter + 1;
												 ex1_state_mach <= execute_barrier1;	
											  else
											    ex1_state_mach <= fifo_select;	
											 end if;												
			when execute_init1 => if Initialized='1' then
											ex1_state_mach<=execute_init2;
										end if;
			
			when execute_init2 => if dma_wr_grant = '1' then -- fin du mpi_init
										   ex1_state_mach <= execute_init3;
										  else
											ex1_state_mach <= execute_init2;
								      end if;
										-- criture dans le registre  status reg.
										src_address<=std_logic_vector(to_unsigned(core_base_adr,16));
			when execute_init3 =>if AppInitAck='1' then
										 ex1_state_mach <= fifo_select;
										 end if;
			when others => ex1_state_mach <= fifo_select;
		   end case;
    end if;
  end if;
 end process;
 
 -- sortie de la machine  etat
 ex1_fsm_action : process(ex1_state_mach, fifo_empty, switch_port_in_full, packet_length,pid, 
 pid_counter, ram_data_in,AppInitAck,  data_to_send, packet_type, wr_ok)
 variable status_reg : std_logic_vector(word-1 downto 0):=(others=>'0');
  begin   
-- code fonctionnel	
	case ex1_state_mach is
		when fifo_select => priority_rotation <='1';  -- on peut changer la priorit
								  fifo_rd_en <= '0';
								  switch_port_in_data <= (others =>'Z');
								  switch_port_in_wr_en <= '0';
								  dma_rd_request <= '0';
								  dma_wr_request <= '0';
								  Ram_rd<='0';
								  Ram_wr<='0';
								  Ram_data_out<=(others=>'0');
								  AppInitReq<='0';
								  Result <=(others=>'0');
		when read_status1 => priority_rotation <='0';
									fifo_rd_en <= '0';
								  switch_port_in_data <= (others =>'Z');
								  switch_port_in_wr_en <= '0';
								  dma_rd_request <= '1';
								  dma_wr_request <= '0';
								  Ram_rd<='0';
								  Ram_wr<='0';
								  Ram_data_out<=(others=>'0');
								  AppInitReq<='0';
								  Result <=(others=>'0');
		when read_status2 => priority_rotation <='0';
									fifo_rd_en <= '0';
								  switch_port_in_data <= (others =>'Z');
								  switch_port_in_wr_en <= '0';
								  dma_rd_request <= '1';
								  dma_wr_request <= '0';
								  Ram_rd<='1';
								  Ram_wr<='0';
								  Ram_data_out<=(others=>'0');
								  AppInitReq<='0';
								  status_reg:=Ram_data_in;
								  Result <=(others=>'0');
		when fetch_packet_type => priority_rotation <='0';
								  fifo_rd_en <= not(fifo_empty);
								  switch_port_in_data <= (others =>'Z');
								  AppInitReq<='0';
								  switch_port_in_wr_en <= '0';
								  Ram_rd<='0';
								  Ram_wr<='0';
								  dma_rd_request <= '0';
								  dma_wr_request <= '0';
								  Ram_data_out<=(others=>'0');
								  Result <=(others=>'0');
		
		when decode_packet_type => priority_rotation <='0';
											fifo_rd_en <= not(fifo_empty);
											switch_port_in_data <= (others =>'Z');
											switch_port_in_wr_en <= '0';
											AppInitReq<='0';
											Ram_rd<='0';
											Ram_wr<='0';
											dma_rd_request <= '0';
											dma_wr_request <= '0';
											Ram_data_out<=(others=>'0');
											Result <=(others=>'0');											
		
		when fetch_addresses => priority_rotation <='0';
										fifo_rd_en <= not(fifo_empty);
										switch_port_in_data <= (others =>'Z');
										switch_port_in_wr_en <= '0';
										AppInitReq<='0';
										Ram_rd<='0';
										Ram_wr<='0';
										dma_rd_request <= '0';
										dma_wr_request <= '0';
										Ram_data_out<=(others=>'0');
										Result <=(others=>'0');
		
		when decode_packet_type2 =>priority_rotation <='0';
								         fifo_rd_en <= '0';
								         switch_port_in_data <= data_to_send;
											switch_port_in_wr_en <= '0';
											AppInitReq<='0';
											Ram_rd<='0';
											Ram_wr<='0';
											dma_rd_request <= '0';
											dma_wr_request <= '0';
											Ram_data_out<=(others=>'0');
											Result <=(others=>'0');
		
		when  execute_barrier1 => priority_rotation <='0';
										  fifo_rd_en <= '0';
											switch_port_in_data <= packet_type & pid_counter;
											switch_port_in_wr_en <= not(switch_port_in_full);
											AppInitReq<='0';
											Ram_rd<='0';
											Ram_wr<='0';
											dma_rd_request <= '0';
										  dma_wr_request <= '0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
		
		when execute_barrier2 =>  priority_rotation <='0';
										  fifo_rd_en <= '0';
											switch_port_in_data <= packet_length;
											switch_port_in_wr_en <= not(switch_port_in_full);
											AppInitReq<='0';
											Ram_rd<='0';
											Ram_wr<='0';
											dma_rd_request <= '0';
											dma_wr_request <= '0';
											Ram_data_out<=(others=>'0');	
											Result <=(others=>'0');									  
										  
		when execute_barrier3 => priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= "0000" & pid;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        AppInitReq<='0';
								        Ram_rd<='0';
										Ram_wr<='0';
								        dma_rd_request <= '0';
										  dma_wr_request <= '0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
		
		when execute_barrier4 => priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= "0000" & pid;
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='0';
								        dma_rd_request <= '0';
								        Ram_rd<='0';
										Ram_wr<='0';
										  dma_wr_request <= '0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
		
		when execute_get1 =>      priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        AppInitReq<='0';
								        Ram_rd<='0';
										Ram_wr<='0';
								        dma_rd_request <= '0';
										  dma_wr_request <= '0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
										  
		when execute_get2 =>      priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        AppInitReq<='0';
								        Ram_rd<='0';
										Ram_wr<='0';
								        dma_rd_request <= '0';
										  dma_wr_request <= '0';
										  Ram_rd<='0';
										  Ram_wr<='0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
										 
										  
			when execute_get3 =>	  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_data_in;---???
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='0';
								        dma_rd_request <= '0';
										  dma_wr_request <= '1';
											Ram_rd<='0';
											Ram_wr<='1';
											Ram_data_out<=data_to_send; -- le rsultat de l'excution 
											--result(1)<='1'; 
											Result <=(2=>'1',others=>'0');--Get completed
		when execute_get4 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_Data_in;
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='0';
								        dma_rd_request <= '1';
										  dma_wr_request <= '1';
											Ram_rd<='1';
											Ram_wr<='1';
											Ram_data_out<=data_to_send; --"00000001";
											Result <=(2=>'1',others=>'0'); --get completed
		when execute_put1 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='0';
								        dma_rd_request <= '1';
										  dma_wr_request <= '0';
											Ram_rd<='0';
											Ram_wr<='0';
											Ram_data_out<=(others=>'0');
											Result <=(others=>'0');
											
		
		when execute_put2 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= data_to_send;
								        switch_port_in_wr_en <= not(switch_port_in_full);
								        AppInitReq<='0';
								        Ram_rd<='1';
										Ram_wr<='0';
								        dma_rd_request <= '1';
										  dma_wr_request <= '0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
										  
		when execute_put3 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_data_in;
								        switch_port_in_wr_en <= not(switch_port_in_full) and wr_ok;
								        AppInitReq<='0';
								        dma_rd_request <= '1';
										  dma_wr_request <= '0';
										  Ram_rd<='1';
										  Ram_wr<='0';
										  Ram_data_out<=(others=>'0');
										  Result <=(others=>'0');
		
		when execute_put4 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_data_in;---???
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='0';
								        dma_rd_request <= '0';
										  dma_wr_request <= '1';
											Ram_rd<='0';
											Ram_wr<='1';
											Ram_data_out<=data_to_send; --"00000001"; -- le rsultat de l'excution 
											--result(1)<='1'; 
											Result <=(1=>'1',others=>'0');--put completed
		when execute_put5 =>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_Data_in;
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='0';
								        dma_rd_request <= rd_ok;
										  dma_wr_request <= wr_ok;
											Ram_rd<=rd_ok;
											Ram_wr<=wr_ok;
											Ram_data_out<=data_to_send; --"00000001";
											Result <=(1=>'1',others=>'0'); --put completed
		when execute_init1 =>    priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <=  (others =>'Z');
								        switch_port_in_wr_en <= '0';
								        dma_rd_request <= '0';
										  dma_wr_request <= '0';
											Ram_rd<='0';
											Ram_wr<='0';
											Ram_data_out<=(others=>'0');
											AppInitReq<='1';
											Result <=(others=>'0');
											
		when execute_init2=>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= (others =>'Z');
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='1';
								        dma_rd_request <= '0';
										  dma_wr_request <= '1';
											Ram_rd<='0';
											Ram_wr<='1';
											Ram_data_out<="00010000"; -- le rsultat de l'excution 
																			  -- dans le registre status
											Result <=(others=>'0');--
		when execute_init3=>		  priority_rotation <='0';
										  fifo_rd_en <= '0';
								        switch_port_in_data <= ram_Data_in;
								        switch_port_in_wr_en <= '0';
								        AppInitReq<='1';
								        dma_rd_request <= '0';
										  dma_wr_request <= '1';
											Ram_rd<='0';
											Ram_wr<='1';
											Ram_data_out<="00010000";
											Result<=(0=>'1',others=>'0'); --le rsultat de l'initialisation est crit
												
		when others => 	        priority_rotation <='0';
											fifo_rd_en <= '0';
											switch_port_in_data <= (others =>'Z');
											switch_port_in_wr_en <= '0';
											dma_rd_request <= '0';
											dma_wr_request <= '0';
											Ram_rd<='0';
											Ram_wr<='0';
											Ram_data_out<=(others=>'0');
											AppInitReq<='0';
											Result <=(others=>'0');
	end case;
	
 end process;

end Behavioral;

