----------------------------------------------------------------------------------
-- Company: 
-- Engineer: EMMANUEL KIEGAING
-- 
-- Create Date:    09:22:58 05/20/2011 
-- Design Name: 
-- Module Name:    EX3_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- module du core mpi charg d'excuter les fonctions mpi_get_size et mpi_get_rank
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
--package Packet_type
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use Work.Packet_type.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity EX3_FSM is
 generic (
				pid : unsigned(3 downto 0) :="0001"; -- id du processeur
				nprocs : unsigned(3 downto 0):="0011"-- nombre de processeur du MPSOC
			);
    Port ( instruction : in  STD_LOGIC_VECTOR (7 downto 0);
           pid_nprocs : out  STD_LOGIC_VECTOR (3 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC);
end EX3_FSM;


architecture Behavioral of EX3_FSM is

signal instruction_signal : std_logic_vector(3 downto 0);
signal rank : unsigned(3 downto 0) := pid;
signal size : unsigned(3 downto 0) := nprocs;
begin
ex3_fsm_process : process(clk)
begin

instruction_signal <= instruction(3 downto 0);
if rising_edge(clk) then
 if reset ='1' then
   pid_nprocs <= "0000";
 else
  if instruction_signal = MPI_GET_RANK then
   pid_nprocs <=  std_logic_vector(rank);
  elsif instruction_signal = MPI_GET_SIZE then
   pid_nprocs <=  std_logic_vector(size);
 end if;
 end if; 
end if;
end process;
end Behavioral;

