----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL
-- 			 GAMOM ROLAND CHRISTIAN
-- 
-- Create Date:    04:39:43 05/21/2011 
-- Design Name: 
-- Module Name:    DMA_ARBITER - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- gestionnaire DMA pour le port secodaire de la RAM true dual port des mmoire 
-- prive de chaque noeud
-- Dependencies: 
-- 
-- Revision: 09/07/2012
-- Revision 1.01 - File Created
-- Additional Comments: Ce module pourra tre optimis pour gnrer les adresses automatiquement
-- par le controleur DMA lorsqu'il est sollicit par la priphrie
--
----------------------------------------------------------------------------------
library IEEE;
library NocLib;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.numeric_std.all; 
use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity DMA_ARBITER is
    Port ( dma_rd_request : in  STD_LOGIC_VEctor (3 downto 0):=(others=>'0');
           data_wr_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           data_rd_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           address_rd : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0); --adresse pour lecture
           address_wr : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0); -- adresse pour criture
           address_out_wr : out  STD_LOGIC_VECTOR (ADRLEN-1 downto 0); -- adresse de sortie du DMA Arbiter
			  address_out_rd : out  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           ram_en : out  STD_LOGIC; -- 
           ram_we : out  STD_LOGIC;
           data_wr_mem : out  STD_LOGIC_VECTOR (Word-1 downto 0); -- donne en sortie criture
           data_rd_mem : in  STD_LOGIC_VECTOR (Word-1 downto 0); -- donnes en sortie lecture
           dma_wr_grant : out  STD_LOGIC_vector(3 downto 0):=(others=>'0'); -- autorisation d'criture
			  hold_req       : out STD_Logic;  --requete vers application
			  hold_ack       : in  STD_Logic;  --autorisation par l'application
			  clk           : in std_logic;
			  reset		    : in std_logic;
           dma_rd_grant : out  STD_LOGIC_vector(3 downto 0):=(others=>'0');  -- autorisation de lecture
           dma_wr_request : in  STD_LOGIC_vector(3 downto 0):=(others=>'0')); -- demande de lecture
end DMA_ARBITER;

architecture Behavioral of DMA_ARBITER is
type fsm_states is (idle,wait_ack,arbiter_ack, writing,ReadWrite,reading);-- definition du type etat pour le codage des etats des fsm
signal dmac_state : fsm_states;

signal prio_rd,prio_wr:std_logic_vector(3 downto 0);--vecteur de bits de priorit
signal pri_rd,pri_wr : natural range 0 to 3; -- stocke le numro du module qui a la priorit
signal dma_rd_logic : std_logic_vector(3 downto 0):=(others=>'0');
signal dma_wr_logic : std_logic_vector(3 downto 0):=(others=>'0');
signal dma_req_wr, dma_req_rd : std_logic;
signal tmp :std_logic_vector(3 downto 0):="0000";

begin
--==========================================================================
---le MUX qui contrle les adresses est gr  l'extrieur du contrleur DMA
data_rd_out<=data_rd_mem ;
data_wr_mem <= data_wr_in;
address_out_rd <= address_rd;
address_out_wr <= address_wr;
--==========================================================================

--Dterminer si une requte HOLD doit tre mise vers l'application pour la libration du 
--bus mmoire
tmp<=(others =>'0');

--for  i in 0 to 3 loop 
--dma_req_wr<=dma_req_wr or dma_wr_request(i);
--loop;

--for  i in 0 to 3 loop
-- dma_req_rd<=dma_req_rd or dma_rd_request(i);  -- construire le signal request vers l'extrieur
--loop;
hold_req<=dma_req_rd or dma_req_wr; --envoyer un Hold vers l'application


-- machine  etat du DMAC
dmac_process : process(clk)
--variable tmp : natural range 0 to 15;
variable tmp_rd,tmp_wr: std_logic_vector(3 downto 0);
variable  req_rd,req_wr : std_logic:='0' ;

begin 
	if rising_edge(clk) then 
	 if reset = '1' then
				dmac_state<= idle;
				
				prio_rd <="0001"; -- au debut priorit lecture au premier module
				prio_wr <="0010"; -- au debut priorit ecriture au deuxime module
				pri_rd<=0;--index de la priorit
				pri_wr<=1;
				req_rd:='0';
				req_wr:='0';
	  else 
				if req_wr='0' or dma_wr_request="0000" then --tant que le Ctrl DMA est libre alors faire bouger la priorit en criture
				case dma_wr_request is
				when "0001" => pri_wr<=0;
									prio_wr<="0001";
									req_wr:='1';
									dma_req_wr<= '1';
									dma_wr_logic <="0001";
				when "0010" => pri_wr<=1;
									prio_wr<="0010";
									req_wr:='1';
									dma_req_wr<= '1';
									dma_wr_logic <="0010";
				when "0100" => pri_wr<=2;
									prio_wr<="0100";
									req_wr:='1';
									dma_req_wr<= '1';
									dma_wr_logic <="0100";
				when "1000" => pri_wr<=3;
									prio_wr<="1000";
									req_wr:='1';
									dma_req_wr<= '1';
									dma_wr_logic <="1000";
									
				when others => 
									
									tmp_wr:= (dma_wr_request and prio_wr) ;
									dma_wr_logic <=tmp_wr;
									
									req_wr:= not(All_zeros(tmp_wr)); 
									dma_req_wr<= not(All_zeros(tmp_wr)); 					
									-- la priorit est circulaire et dcale  chaque coup d'horloge
									if req_wr='0' then
										prio_wr<=rol_vec(prio_wr); 
										if pri_wr=3 then
											pri_wr<=0;
											Prio_wr<="0001";
										else
											pri_wr<=pri_wr+1;
										end if;
								 end if;
				end case;
					
				end if;
				
				if req_rd='0' or dma_rd_request="0000" then --tant que le Ctrl DMA est libre alors faire bouger la priorit
				case dma_rd_request is
				when "0001" => pri_rd<=0;
									prio_rd<="0001";
									req_rd:='1';
									dma_req_rd<= '1';
									dma_rd_logic<="0001";
				when "0010" => pri_rd<=1;
									prio_rd<="0010";
									req_rd:='1';
									dma_req_rd<= '1';
									dma_rd_logic<="0010";
									
				when "0100" => pri_rd<=2;
									prio_rd<="0100";
									req_rd:='1';
									dma_req_rd<= '1';
									dma_rd_logic<="0100";
									
				when "1000" => pri_rd<=3;
									prio_rd<="1000";
									req_rd:='1';
									dma_req_rd<= '1';
									dma_rd_logic<="1000";
									
				when others => 
									
									tmp_rd:= (dma_rd_request and prio_rd) ; 
									dma_rd_logic<=tmp_rd;
									dma_req_rd<= not (All_Zeros(tmp_rd));
									req_rd:= not (All_Zeros(tmp_rd));
									
								-- la priorit est circulaire et dcale  chaque coup d'horloge
									if req_rd='0' then
										prio_rd<=rol_vec(prio_rd);
										if pri_rd =3 then
											pri_rd<=0;
											prio_rd<="0001";
										else
											
											pri_rd<=pri_rd+1;
										end if;
									end if;
				end case;
				
			   end if;
	   
		  case dmac_state is
		   when idle => if req_rd='1' or req_wr='1' then
									dmac_state<=wait_ack; 
							else -- initialiser la priorit
									
									
									req_rd:='0';
									dma_req_rd<= '0';
									dma_rd_logic <="0000";
									
									
									req_wr:='0';
									dma_req_wr<= '0';
									dma_wr_logic <="0000";
											
							end if;
			when wait_ack =>  -- l'application doit autoriser l'utilisation de la RAM par le Core
						if dma_wr_request(pri_wr) ='1' or dma_rd_request(pri_rd) ='1' then
							if hold_ack='1' then
								dmac_state<=arbiter_ack;
							end if;
						else
							
							if dma_wr_request(pri_wr) ='0' then
							req_wr:='0';-- forcer une nouvelle recherche de priorit
							end if;
							
							if dma_rd_request(pri_rd) ='0' then
								req_rd:='0';
							end if;
							dmac_state<=Idle;
						end if;
						
				
			when arbiter_ack => if dma_wr_request(pri_wr) ='1' and dma_rd_request(pri_rd) ='1' then -- 
									dmac_state <= Readwrite;
								 elsif dma_wr_request(pri_wr) ='0' and dma_rd_request(pri_rd) ='1' then
											dmac_state <= Reading;
								elsif dma_wr_request(pri_wr) ='1' and dma_rd_request(pri_rd) ='0' then
											dmac_state <= Writing;
								else
											dmac_state<=Idle;
								end if;
								
			when Writing => if dma_wr_request(pri_wr) ='1' then
										if hold_ack='1' then 
										    -- on reste dans cet tat
										 if dma_rd_request(pri_rd)='1' then
												dmac_state<=ReadWrite;
										 else
												req_rd:='0';
										 end if;
										else
											dmac_state<=wait_ack; 
										end if;
								 elsif dma_rd_request(pri_rd) ='1' then
										dmac_state <= Reading;
								 else
										dmac_state <= idle;
								end if;
			
			
			when ReadWrite => if hold_ack='1' then
										  if dma_wr_request(pri_wr)='1' and dma_rd_request(pri_rd)='1' then
												dmac_state <= ReadWrite;
											elsif dma_wr_request(pri_wr)='1' and dma_rd_request(pri_rd)='0' then 
												dmac_state <= Writing;
												req_rd:='0';
											elsif dma_wr_request(pri_wr)='0' and dma_rd_request(pri_rd)='1' then
												dmac_state <= Reading;
												req_wr:='0';
											else
												dmac_state <= Idle;
												req_rd:='0';req_wr:='0';
											end if;
									 else 
											if (dma_wr_request(pri_wr)='1') or (dma_rd_request(pri_rd)='1') then
													dmac_state <= Wait_ack;
											else
												dmac_state <= Idle;
											end if;
									end if;
			when Reading => 
								 if dma_rd_request(pri_rd) ='1' then
										if hold_ack='1' then 
										    -- on reste dans cet tat
											 if dma_wr_request(pri_wr)='1' then
												dmac_state<=ReadWrite;
											else
												req_wr:='0';
											end if;
										else
											dmac_state<=wait_ack; 
										end if;
								 elsif dma_wr_request(pri_wr) ='1' then
										dmac_state<=writing;
								 else
										dmac_state <= idle;
								end if;
			when others => dmac_state <= idle;
		   end case;
	 end if;
	end if;
end process;
-- action_asocies
ol: process(dmac_state, address_rd, address_wr,pri_wr,pri_rd,prio_wr,prio_rd,dma_wr_request,dma_rd_request)

begin
--tester les requtes DMA en lecture ou en criture

case dmac_state is
		when idle => 
							ram_en <='0';
							ram_we <='0';
							dma_wr_grant <=(others=>'0');
							dma_rd_grant <=(others=>'0');
							--address_out_rd <= address_rd;
							--hold_req<='0';
		when wait_ack =>
							ram_en <='0';
							ram_we <='0';
							dma_wr_grant<=(others=>'0');
							dma_rd_grant<=(others=>'0');
							--address_out_rd <= (others=>'Z');
							--address_out_wr <= (others=>'Z');
							--hold_req<='1';
		when arbiter_ack =>  -- optimiser pour gagner un cycle
							ram_en <='1';
							ram_we <='0';
							dma_wr_grant<=(others=>'0');
							dma_rd_grant<=(others=>'0');
							--address_out_rd <= (others=>'Z');
							--address_out_wr <= (others=>'Z');
		when writing => -- ecriture dans la ram
							ram_en <='1';
							ram_we <='1';
							dma_wr_grant<=(others=>'0');
							dma_wr_grant(pri_wr) <='1';
							dma_rd_grant <=(others=>'0');
							--address_out_rd <= (others=>'Z');
							--address_out_wr <= address_wr;
							--hold_req<='1';							
							
		when ReadWrite => -- Lecture et criture simultanne dans la Dual Port RAM
							ram_en <='1';
							ram_we <='1';
							dma_wr_grant<=(others=>'0');
							dma_wr_grant(pri_wr) <='1';
							dma_rd_grant<=(others=>'0');
							dma_rd_grant(pri_rd)<='1';
							
							--address_out_rd <= address_rd;
							--address_out_wr <= address_wr;
							--hold_req<='1';							
		when Reading => -- lecture dans la ram
							ram_en <='1';
							ram_we <='0';
							dma_wr_grant<=(others=>'0');
							dma_rd_grant<=(others=>'0');
							dma_rd_grant(pri_rd)<='1';
							
							--address_out_rd <= address_rd;
							--address_out_wr <= (others=>'Z');
							--hold_req<='1';
		when others => 
						   ram_en <='0';
							ram_we <='0';
							dma_wr_grant <=(others=>'0');
							dma_rd_grant <=(others=>'0');
							--address_out_rd <= (others=>'Z');
							--address_out_wr <= (others=>'Z');
							--hold_req<='0';
		end case;
end process;


end Behavioral;

