----------------------------------------------------------------------------------
-- Company: 
-- Engineer:  GAMOM NGOUNOU 
-- 
-- Create Date:    18:33:31 03/05/2012 
-- Design Name: 
-- Module Name:    RAM_32_32 - Behavioral 
-- Project Name: MPI_Core
-- Target Devices: 
-- Tool versions: 
-- Description: permet de stocker les donnes locales de la librairie MPI
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity RAM_v is
generic(width : positive:=32; Size:positive:=16);
Port ( clka, clkb : in std_logic;
			  wea : in std_logic;
			  ena, enb : in std_logic;
			  addra, addrb : in std_logic_vector(size-1 downto 0); --cinq lignes d'adresse
			  dia : in std_logic_vector(width-1 downto 0);
			  dob : out std_logic_vector(width-1 downto 0));
end RAM_v;

architecture Behavioral of RAM_v is
	signal Lra,Lrb :std_logic:='0';
	signal sel : std_logic_vector(1 downto 0);
	signal doa,dout : std_logic_vector(width-1 downto 0);
	type ram_type is array (2**(size-3)-1 downto 0) of std_logic_vector (width-1 downto 0);
	signal RAM: ram_type;
begin
 process (clka)
	begin
		if clka'event and clka = '1' then
			if ena = '1' then
				if wea = '1' then
					RAM(conv_integer(addra)) <= dia;
				end if;
					
				doa<=RAM(conv_integer(addrb));
				Lra<='1';
			else 
				if lrb='1' then
						Lra<='0';
				end if;
			end if;
		 end if;
 end process;

 
 process (clkb)	
 begin
		if clkb'event and clkb = '1' then
			if enb = '1' then
				Lrb<='1';	
				dout <= RAM(conv_integer(addrb)) ;
			else
				if Lra='1' then
					Lrb<='0';
				end if;
			end if;
		end if;
 end process;
 
 sel<=(Lra,Lrb);
 With  sel select
 dob <=dout when "11",
      doa  when "10",
		dout when "01",
		dout when "00",
		dout when others;
		
end Behavioral;

