----------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM 
-- 
-- Create Date:    05:37:34 03/06/2012 
-- Design Name: 
-- Module Name:    Ex0_Fsm - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Fournit le temps en s depuis l'initialisation de la bibliothque
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library NocLib ;

use NocLib.CoreTypes.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Ex0_Fsm is
    Port ( Initialised : in  STD_LOGIC;
           
           Instruction : in  STD_LOGIC_VECTOR (7 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           ClkRate : in  STD_LOGIC_VECTOR;
			uTimeResult : out  STD_LOGIC_VECTOR; 
			TickResult : out STD_LOGIC_VECTOR
			  );
end Ex0_Fsm;

architecture Behavioral of Ex0_Fsm is
 
 --Use descriptive names for the states, like st1_reset, st2_search
   type state_type is (Init,COunt,UsOut,OverFlow); 
   signal state, next_state : state_type; 
   --Declare internal signals for all outputs of the state-machine
   signal Tick_Count: std_logic_vector(31 downto 0):=(others=>'0');
	signal Time_Ucount :std_logic_vector(31 downto 0):=(others=>'0');
	signal OvF,Ovf_us,ovF_i,zero :std_logic;   -- overflow flag
   signal ClkR_Count : std_logic_vector(ClkRate'high downto ClkRate'low):=(others=>'0');
	signal en : std_logic:='1';
	--other outputs
begin
utime_PROC: process (clk)
   begin
      if (rising_edge(clk)) then
         if (reset = '1') or Initialised='0' then
            state <= init;
          --  Time_UCount<= (others=>'0');
			--	Tick_Count <=(others=>'0');
         else
            state <= next_state;
			TickResult<= Tick_Count;
			uTimeResult <=Time_ucount;
           -- <output> <= <output>_i;
         -- assign other outputs to internal signals
         end if;        
      end if;
   end process;
 
   --MOORE State-Machine - Outputs based on state only
   OUTPUT_DECODE: process (state)
   begin
      --insert statements to decode internal output signals
      --below is simple example
      case state is
		When Init =>
			Clkr_Count<=ClkRate;  --initialiser le dcompte
			Time_uCount<=( others =>'0'); -- mettre  0 le compteur des S
			Tick_Count<=(others =>'0');  --mettre  0 les ticks
		When Count =>
		  Tick_count<=incr_vec(Tick_Count,en);
		  ClkR_Count<=dcr_vec(Clkr_Count,en);
		  zero<=all_zeros(ClkR_Count);
		  OvF_i<=All_ones(Tick_count);
		when UsOut =>
			Time_Ucount<=incr_vec(time_ucount,en);
			Clkr_Count<=ClkRate;
			Tick_count<=incr_vec(Tick_Count,en);
			OvF_i<=All_ones(Tick_count);
			zero<='0';
         OvF_us<=All_ones(Time_Ucount);
      when OverFlow =>
         --<output>_i <= '0';
			OvF<=OvF_i;
		
     end case;
   end process;
 
   NEXT_STATE_DECODE: process (state, Initialised, zero, OvF)
   begin
      --declare default state for next_state to avoid latches
      next_state <= state;  --default is to stay in current state
      --insert statements to decode next_state
      --below is a simple example
      case (state) is
         when Init =>
            if Initialised = '1' then
				   
               next_state <= count;
            end if;
         when Count =>
            if Zero = '0'  then
               next_state <= Count;
				elsif Zero = '1'  then
					next_state <=Usout;
			
            end if;
         when UsOut =>
				If OvF='0'  then
					next_state <= count;
				elsif OvF='1' then
					next_state <= OverFlow;
				end if;
			When OverFlow =>
					next_state<=Count;
--         when others =>
--            next_state <= Init;
      end case;      
   end process;


end Behavioral;

