---------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    03:56:34 05/06/2011 
-- Design Name: 
-- Module Name:    Sheduler - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Module de l'ordonnanceur du switch crossbar
-- l'algorithme utilise est le DPA (diagonal propagation arbiter)
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use Work.Sheduler_package.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity Scheduler6_6 is
    Port ( Request : in  STD_LOGIC_VECTOR (36 downto 1);
		   Fifo_full : in STD_LOGIC_VECTOR (6 downto 1);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
            priority_rotation : in  STD_LOGIC_VECTOR (6 downto 1);
           port_grant : out  STD_LOGIC_VECTOR (36 downto 1));
end Scheduler6_6;

architecture Behavioral of Scheduler6_6 is
--Declaration du types
--tableau de signaux de connexion des cellules arbitres
TYPE C_Bar_Signal_Array IS ARRAY(11 downto 1) of STD_LOGIC_VECTOR(6 downto 1);
-- declaration du composant cellule d'arbitrage
Component Arbiter 
  PORT (P, Fifo_full,Request, West,North : in  STD_LOGIC;
        Grant,East,South : out  STD_LOGIC );
End Component;--Signaux de connexion des cellues
SIGNAL south_2_north :  C_Bar_Signal_Array; -- connexion south north 
SIGNAL east_2_west   :  C_Bar_Signal_Array; -- connexion east west 
SIGNAL Signal_mask      : C_Bar_Signal_Array;-- connexion des masques de priorit
SIGNAL Signal_grant     : C_Bar_Signal_Array;-- connexion des signaux de validation
SIGNAL Signal_priority  : STD_LOGIC_VECTOR (11 DOWNTO 1);--signal pour la connection des vecteur de priorit
SIGNAL High         : std_logic;--niveau pour les cellules des extremits nord et ouest 
 signal grant_latch : std_logic_vector(36 downto 1); 
 signal priority_rotation_en : std_logic; 
 signal Grant :  std_logic_vector(36 downto 1);
 begin

--validation de la rotation de priorit lorsque aucun port n'emet 
 priority_rotation_en <= '1' when unsigned(priority_rotation) = 63 else 	'0'; 
--latch servant qui memorise le signal grant pendant a transmission 
grant_latch_process : process(clk)
 begin 
  if rising_edge(clk) then 
   if reset = '1' then 
 		grant_latch <= (others => '0'); 
 	 elsif priority_rotation_en = '1' then 
	   grant_latch <= Grant; 
   end if; 
   end if; 
 end process; 
 port_grant <= Grant and grant_latch; 
 Grant(1)  <= Signal_grant(1)(1) or Signal_grant(7)(1); --  Grant(1,1)
Grant(2)  <= Signal_grant(2)(2) or Signal_grant(8)(2); --  Grant(1,2)
Grant(3)  <= Signal_grant(3)(3) or Signal_grant(9)(3); --  Grant(1,3)
Grant(4)  <= Signal_grant(4)(4) or Signal_grant(10)(4); --  Grant(1,4)
Grant(5)  <= Signal_grant(5)(5) or Signal_grant(11)(5); --  Grant(1,5)
Grant(6)  <= Signal_grant(6)(6) ;                      --  Grant(1,6)
Grant(7)  <= Signal_grant(2)(1) or Signal_grant(8)(1); --  Grant(2,1)
Grant(8)  <= Signal_grant(3)(2) or Signal_grant(9)(2); --  Grant(2,2)
Grant(9)  <= Signal_grant(4)(3) or Signal_grant(10)(3); --  Grant(2,3)
Grant(10)  <= Signal_grant(5)(4) or Signal_grant(11)(4); --  Grant(2,4)
Grant(11)  <= Signal_grant(6)(5) ;                      --  Grant(2,5)
Grant(12)  <= Signal_grant(1)(6) or Signal_grant(7)(6); --  Grant(2,6)
Grant(13)  <= Signal_grant(3)(1) or Signal_grant(9)(1); --  Grant(3,1)
Grant(14)  <= Signal_grant(4)(2) or Signal_grant(10)(2); --  Grant(3,2)
Grant(15)  <= Signal_grant(5)(3) or Signal_grant(11)(3); --  Grant(3,3)
Grant(16)  <= Signal_grant(6)(4) ;                      --  Grant(3,4)
Grant(17)  <= Signal_grant(1)(5) or Signal_grant(7)(5); --  Grant(3,5)
Grant(18)  <= Signal_grant(2)(6) or Signal_grant(8)(6); --  Grant(3,6)
Grant(19)  <= Signal_grant(4)(1) or Signal_grant(10)(1); --  Grant(4,1)
Grant(20)  <= Signal_grant(5)(2) or Signal_grant(11)(2); --  Grant(4,2)
Grant(21)  <= Signal_grant(6)(3) ;                      --  Grant(4,3)
Grant(22)  <= Signal_grant(1)(4) or Signal_grant(7)(4); --  Grant(4,4)
Grant(23)  <= Signal_grant(2)(5) or Signal_grant(8)(5); --  Grant(4,5)
Grant(24)  <= Signal_grant(3)(6) or Signal_grant(9)(6); --  Grant(4,6)
Grant(25)  <= Signal_grant(5)(1) or Signal_grant(11)(1); --  Grant(5,1)
Grant(26)  <= Signal_grant(6)(2) ;                      --  Grant(5,2)
Grant(27)  <= Signal_grant(1)(3) or Signal_grant(7)(3); --  Grant(5,3)
Grant(28)  <= Signal_grant(2)(4) or Signal_grant(8)(4); --  Grant(5,4)
Grant(29)  <= Signal_grant(3)(5) or Signal_grant(9)(5); --  Grant(5,5)
Grant(30)  <= Signal_grant(4)(6) or Signal_grant(10)(6); --  Grant(5,6)
Grant(31)  <= Signal_grant(6)(1) ;                      --  Grant(6,1)
Grant(32)  <= Signal_grant(1)(2) or Signal_grant(7)(2); --  Grant(6,2)
Grant(33)  <= Signal_grant(2)(3) or Signal_grant(8)(3); --  Grant(6,3)
Grant(34)  <= Signal_grant(3)(4) or Signal_grant(9)(4); --  Grant(6,4)
Grant(35)  <= Signal_grant(4)(5) or Signal_grant(10)(5); --  Grant(6,5)
Grant(36)  <= Signal_grant(5)(6) or Signal_grant(11)(6); --  Grant(6,6)
High <= '1';

----instantiations des cellules arbitres et interconnection

-------------------------- Diagonale n 1 


Arbiter_1_1 : Arbiter

PORT MAP (Request => Request(1), North => High, West => High, P => Signal_priority(11), Fifo_full => Fifo_full(1),  
South => south_2_north(1)(1), East => east_2_west(1)(1) , Grant => Signal_grant(1)(1)); 

Arbiter_1_2 : Arbiter

PORT MAP (Request => Request(32), North => High, West => High, P => Signal_priority(11), Fifo_full => Fifo_full(2),  
South => south_2_north(1)(2), East => east_2_west(1)(2) , Grant => Signal_grant(1)(2)); 

Arbiter_1_3 : Arbiter

PORT MAP (Request => Request(27), North => High, West => High, P => Signal_priority(11), Fifo_full => Fifo_full(3),  
South => south_2_north(1)(3), East => east_2_west(1)(3) , Grant => Signal_grant(1)(3)); 

Arbiter_1_4 : Arbiter

PORT MAP (Request => Request(22), North => High, West => High, P => Signal_priority(11), Fifo_full => Fifo_full(4),  
South => south_2_north(1)(4), East => east_2_west(1)(4) , Grant => Signal_grant(1)(4)); 

Arbiter_1_5 : Arbiter

PORT MAP (Request => Request(17), North => High, West => High, P => Signal_priority(11), Fifo_full => Fifo_full(5),  
South => south_2_north(1)(5), East => east_2_west(1)(5) , Grant => Signal_grant(1)(5)); 

Arbiter_1_6 : Arbiter

PORT MAP (Request => Request(12), North => High, West => High, P => Signal_priority(11), Fifo_full => Fifo_full(6),  
South => south_2_north(1)(6), East => east_2_west(1)(6) , Grant => Signal_grant(1)(6)); 

-------------------------- Diagonale n 2 


Arbiter_2_1 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(1)(1), West => east_2_west(1)(6), P => Signal_priority(10), Fifo_full => Fifo_full(1),  
South => south_2_north(2)(1), East => east_2_west(2)(1) , Grant => Signal_grant(2)(1)); 

Arbiter_2_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(1)(2), West => east_2_west(1)(1), P => Signal_priority(10), Fifo_full => Fifo_full(2),  
South => south_2_north(2)(2), East => east_2_west(2)(2) , Grant => Signal_grant(2)(2)); 

Arbiter_2_3 : Arbiter

PORT MAP (Request => Request(33), North => south_2_north(1)(3), West => east_2_west(1)(2), P => Signal_priority(10), Fifo_full => Fifo_full(3),  
South => south_2_north(2)(3), East => east_2_west(2)(3) , Grant => Signal_grant(2)(3)); 

Arbiter_2_4 : Arbiter

PORT MAP (Request => Request(28), North => south_2_north(1)(4), West => east_2_west(1)(3), P => Signal_priority(10), Fifo_full => Fifo_full(4),  
South => south_2_north(2)(4), East => east_2_west(2)(4) , Grant => Signal_grant(2)(4)); 

Arbiter_2_5 : Arbiter

PORT MAP (Request => Request(23), North => south_2_north(1)(5), West => east_2_west(1)(4), P => Signal_priority(10), Fifo_full => Fifo_full(5),  
South => south_2_north(2)(5), East => east_2_west(2)(5) , Grant => Signal_grant(2)(5)); 

Arbiter_2_6 : Arbiter

PORT MAP (Request => Request(18), North => south_2_north(1)(6), West => east_2_west(1)(5), P => Signal_priority(10), Fifo_full => Fifo_full(6),  
South => south_2_north(2)(6), East => east_2_west(2)(6) , Grant => Signal_grant(2)(6)); 

-------------------------- Diagonale n 3 


Arbiter_3_1 : Arbiter

PORT MAP (Request => Request(13), North => south_2_north(2)(1), West => east_2_west(2)(6), P => Signal_priority(9), Fifo_full => Fifo_full(1),  
South => south_2_north(3)(1), East => east_2_west(3)(1) , Grant => Signal_grant(3)(1)); 

Arbiter_3_2 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(2)(2), West => east_2_west(2)(1), P => Signal_priority(9), Fifo_full => Fifo_full(2),  
South => south_2_north(3)(2), East => east_2_west(3)(2) , Grant => Signal_grant(3)(2)); 

Arbiter_3_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(2)(3), West => east_2_west(2)(2), P => Signal_priority(9), Fifo_full => Fifo_full(3),  
South => south_2_north(3)(3), East => east_2_west(3)(3) , Grant => Signal_grant(3)(3)); 

Arbiter_3_4 : Arbiter

PORT MAP (Request => Request(34), North => south_2_north(2)(4), West => east_2_west(2)(3), P => Signal_priority(9), Fifo_full => Fifo_full(4),  
South => south_2_north(3)(4), East => east_2_west(3)(4) , Grant => Signal_grant(3)(4)); 

Arbiter_3_5 : Arbiter

PORT MAP (Request => Request(29), North => south_2_north(2)(5), West => east_2_west(2)(4), P => Signal_priority(9), Fifo_full => Fifo_full(5),  
South => south_2_north(3)(5), East => east_2_west(3)(5) , Grant => Signal_grant(3)(5)); 

Arbiter_3_6 : Arbiter

PORT MAP (Request => Request(24), North => south_2_north(2)(6), West => east_2_west(2)(5), P => Signal_priority(9), Fifo_full => Fifo_full(6),  
South => south_2_north(3)(6), East => east_2_west(3)(6) , Grant => Signal_grant(3)(6)); 

-------------------------- Diagonale n 4 


Arbiter_4_1 : Arbiter

PORT MAP (Request => Request(19), North => south_2_north(3)(1), West => east_2_west(3)(6), P => Signal_priority(8), Fifo_full => Fifo_full(1),  
South => south_2_north(4)(1), East => east_2_west(4)(1) , Grant => Signal_grant(4)(1)); 

Arbiter_4_2 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(3)(2), West => east_2_west(3)(1), P => Signal_priority(8), Fifo_full => Fifo_full(2),  
South => south_2_north(4)(2), East => east_2_west(4)(2) , Grant => Signal_grant(4)(2)); 

Arbiter_4_3 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(3)(3), West => east_2_west(3)(2), P => Signal_priority(8), Fifo_full => Fifo_full(3),  
South => south_2_north(4)(3), East => east_2_west(4)(3) , Grant => Signal_grant(4)(3)); 

Arbiter_4_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(3)(4), West => east_2_west(3)(3), P => Signal_priority(8), Fifo_full => Fifo_full(4),  
South => south_2_north(4)(4), East => east_2_west(4)(4) , Grant => Signal_grant(4)(4)); 

Arbiter_4_5 : Arbiter

PORT MAP (Request => Request(35), North => south_2_north(3)(5), West => east_2_west(3)(4), P => Signal_priority(8), Fifo_full => Fifo_full(5),  
South => south_2_north(4)(5), East => east_2_west(4)(5) , Grant => Signal_grant(4)(5)); 

Arbiter_4_6 : Arbiter

PORT MAP (Request => Request(30), North => south_2_north(3)(6), West => east_2_west(3)(5), P => Signal_priority(8), Fifo_full => Fifo_full(6),  
South => south_2_north(4)(6), East => east_2_west(4)(6) , Grant => Signal_grant(4)(6)); 

-------------------------- Diagonale n 5 


Arbiter_5_1 : Arbiter

PORT MAP (Request => Request(25), North => south_2_north(4)(1), West => east_2_west(4)(6), P => Signal_priority(7), Fifo_full => Fifo_full(1),  
South => south_2_north(5)(1), East => east_2_west(5)(1) , Grant => Signal_grant(5)(1)); 

Arbiter_5_2 : Arbiter

PORT MAP (Request => Request(20), North => south_2_north(4)(2), West => east_2_west(4)(1), P => Signal_priority(7), Fifo_full => Fifo_full(2),  
South => south_2_north(5)(2), East => east_2_west(5)(2) , Grant => Signal_grant(5)(2)); 

Arbiter_5_3 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(4)(3), West => east_2_west(4)(2), P => Signal_priority(7), Fifo_full => Fifo_full(3),  
South => south_2_north(5)(3), East => east_2_west(5)(3) , Grant => Signal_grant(5)(3)); 

Arbiter_5_4 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(4)(4), West => east_2_west(4)(3), P => Signal_priority(7), Fifo_full => Fifo_full(4),  
South => south_2_north(5)(4), East => east_2_west(5)(4) , Grant => Signal_grant(5)(4)); 

Arbiter_5_5 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(4)(5), West => east_2_west(4)(4), P => Signal_priority(7), Fifo_full => Fifo_full(5),  
South => south_2_north(5)(5), East => east_2_west(5)(5) , Grant => Signal_grant(5)(5)); 

Arbiter_5_6 : Arbiter

PORT MAP (Request => Request(36), North => south_2_north(4)(6), West => east_2_west(4)(5), P => Signal_priority(7), Fifo_full => Fifo_full(6),  
South => south_2_north(5)(6), East => east_2_west(5)(6) , Grant => Signal_grant(5)(6)); 

-------------------------- Diagonale n 6 


Arbiter_6_1 : Arbiter

PORT MAP (Request => Request(31), North => south_2_north(5)(1), West => east_2_west(5)(6), P => Signal_priority(6), Fifo_full => Fifo_full(1),  
South => south_2_north(6)(1), East => east_2_west(6)(1) , Grant => Signal_grant(6)(1)); 

Arbiter_6_2 : Arbiter

PORT MAP (Request => Request(26), North => south_2_north(5)(2), West => east_2_west(5)(1), P => Signal_priority(6), Fifo_full => Fifo_full(2),  
South => south_2_north(6)(2), East => east_2_west(6)(2) , Grant => Signal_grant(6)(2)); 

Arbiter_6_3 : Arbiter

PORT MAP (Request => Request(21), North => south_2_north(5)(3), West => east_2_west(5)(2), P => Signal_priority(6), Fifo_full => Fifo_full(3),  
South => south_2_north(6)(3), East => east_2_west(6)(3) , Grant => Signal_grant(6)(3)); 

Arbiter_6_4 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(5)(4), West => east_2_west(5)(3), P => Signal_priority(6), Fifo_full => Fifo_full(4),  
South => south_2_north(6)(4), East => east_2_west(6)(4) , Grant => Signal_grant(6)(4)); 

Arbiter_6_5 : Arbiter

PORT MAP (Request => Request(11), North => south_2_north(5)(5), West => east_2_west(5)(4), P => Signal_priority(6), Fifo_full => Fifo_full(5),  
South => south_2_north(6)(5), East => east_2_west(6)(5) , Grant => Signal_grant(6)(5)); 

Arbiter_6_6 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(5)(6), West => east_2_west(5)(5), P => Signal_priority(6), Fifo_full => Fifo_full(6),  
South => south_2_north(6)(6), East => east_2_west(6)(6) , Grant => Signal_grant(6)(6)); 

-------------------------- Diagonale n 7 


Arbiter_7_1 : Arbiter

PORT MAP (Request => Request(1), North => south_2_north(6)(1), West => east_2_west(6)(6), P => Signal_priority(5), Fifo_full => Fifo_full(1),  
South => south_2_north(7)(1), East => east_2_west(7)(1) , Grant => Signal_grant(7)(1)); 

Arbiter_7_2 : Arbiter

PORT MAP (Request => Request(32), North => south_2_north(6)(2), West => east_2_west(6)(1), P => Signal_priority(5), Fifo_full => Fifo_full(2),  
South => south_2_north(7)(2), East => east_2_west(7)(2) , Grant => Signal_grant(7)(2)); 

Arbiter_7_3 : Arbiter

PORT MAP (Request => Request(27), North => south_2_north(6)(3), West => east_2_west(6)(2), P => Signal_priority(5), Fifo_full => Fifo_full(3),  
South => south_2_north(7)(3), East => east_2_west(7)(3) , Grant => Signal_grant(7)(3)); 

Arbiter_7_4 : Arbiter

PORT MAP (Request => Request(22), North => south_2_north(6)(4), West => east_2_west(6)(3), P => Signal_priority(5), Fifo_full => Fifo_full(4),  
South => south_2_north(7)(4), East => east_2_west(7)(4) , Grant => Signal_grant(7)(4)); 

Arbiter_7_5 : Arbiter

PORT MAP (Request => Request(17), North => south_2_north(6)(5), West => east_2_west(6)(4), P => Signal_priority(5), Fifo_full => Fifo_full(5),  
South => south_2_north(7)(5), East => east_2_west(7)(5) , Grant => Signal_grant(7)(5)); 

Arbiter_7_6 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(6)(6), West => east_2_west(6)(5), P => Signal_priority(5), Fifo_full => Fifo_full(6),  
South => south_2_north(7)(6), East => east_2_west(7)(6) , Grant => Signal_grant(7)(6)); 

-------------------------- Diagonale n 8 


Arbiter_8_1 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(7)(1), West => east_2_west(7)(6), P => Signal_priority(4), Fifo_full => Fifo_full(1),  
South => south_2_north(8)(1), East => east_2_west(8)(1) , Grant => Signal_grant(8)(1)); 

Arbiter_8_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(7)(2), West => east_2_west(7)(1), P => Signal_priority(4), Fifo_full => Fifo_full(2),  
South => south_2_north(8)(2), East => east_2_west(8)(2) , Grant => Signal_grant(8)(2)); 

Arbiter_8_3 : Arbiter

PORT MAP (Request => Request(33), North => south_2_north(7)(3), West => east_2_west(7)(2), P => Signal_priority(4), Fifo_full => Fifo_full(3),  
South => south_2_north(8)(3), East => east_2_west(8)(3) , Grant => Signal_grant(8)(3)); 

Arbiter_8_4 : Arbiter

PORT MAP (Request => Request(28), North => south_2_north(7)(4), West => east_2_west(7)(3), P => Signal_priority(4), Fifo_full => Fifo_full(4),  
South => south_2_north(8)(4), East => east_2_west(8)(4) , Grant => Signal_grant(8)(4)); 

Arbiter_8_5 : Arbiter

PORT MAP (Request => Request(23), North => south_2_north(7)(5), West => east_2_west(7)(4), P => Signal_priority(4), Fifo_full => Fifo_full(5),  
South => south_2_north(8)(5), East => east_2_west(8)(5) , Grant => Signal_grant(8)(5)); 

Arbiter_8_6 : Arbiter

PORT MAP (Request => Request(18), North => south_2_north(7)(6), West => east_2_west(7)(5), P => Signal_priority(4), Fifo_full => Fifo_full(6),  
South => south_2_north(8)(6), East => east_2_west(8)(6) , Grant => Signal_grant(8)(6)); 

-------------------------- Diagonale n 9 


Arbiter_9_1 : Arbiter

PORT MAP (Request => Request(13), North => south_2_north(8)(1), West => east_2_west(8)(6), P => Signal_priority(3), Fifo_full => Fifo_full(1),  
South => south_2_north(9)(1), East => east_2_west(9)(1) , Grant => Signal_grant(9)(1)); 

Arbiter_9_2 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(8)(2), West => east_2_west(8)(1), P => Signal_priority(3), Fifo_full => Fifo_full(2),  
South => south_2_north(9)(2), East => east_2_west(9)(2) , Grant => Signal_grant(9)(2)); 

Arbiter_9_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(8)(3), West => east_2_west(8)(2), P => Signal_priority(3), Fifo_full => Fifo_full(3),  
South => south_2_north(9)(3), East => east_2_west(9)(3) , Grant => Signal_grant(9)(3)); 

Arbiter_9_4 : Arbiter

PORT MAP (Request => Request(34), North => south_2_north(8)(4), West => east_2_west(8)(3), P => Signal_priority(3), Fifo_full => Fifo_full(4),  
South => south_2_north(9)(4), East => east_2_west(9)(4) , Grant => Signal_grant(9)(4)); 

Arbiter_9_5 : Arbiter

PORT MAP (Request => Request(29), North => south_2_north(8)(5), West => east_2_west(8)(4), P => Signal_priority(3), Fifo_full => Fifo_full(5),  
South => south_2_north(9)(5), East => east_2_west(9)(5) , Grant => Signal_grant(9)(5)); 

Arbiter_9_6 : Arbiter

PORT MAP (Request => Request(24), North => south_2_north(8)(6), West => east_2_west(8)(5), P => Signal_priority(3), Fifo_full => Fifo_full(6),  
South => south_2_north(9)(6), East => east_2_west(9)(6) , Grant => Signal_grant(9)(6)); 

-------------------------- Diagonale n 10 


Arbiter_10_1 : Arbiter

PORT MAP (Request => Request(19), North => south_2_north(9)(1), West => east_2_west(9)(6), P => Signal_priority(2), Fifo_full => Fifo_full(1),  
South => south_2_north(10)(1), East => east_2_west(10)(1) , Grant => Signal_grant(10)(1)); 

Arbiter_10_2 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(9)(2), West => east_2_west(9)(1), P => Signal_priority(2), Fifo_full => Fifo_full(2),  
South => south_2_north(10)(2), East => east_2_west(10)(2) , Grant => Signal_grant(10)(2)); 

Arbiter_10_3 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(9)(3), West => east_2_west(9)(2), P => Signal_priority(2), Fifo_full => Fifo_full(3),  
South => south_2_north(10)(3), East => east_2_west(10)(3) , Grant => Signal_grant(10)(3)); 

Arbiter_10_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(9)(4), West => east_2_west(9)(3), P => Signal_priority(2), Fifo_full => Fifo_full(4),  
South => south_2_north(10)(4), East => east_2_west(10)(4) , Grant => Signal_grant(10)(4)); 

Arbiter_10_5 : Arbiter

PORT MAP (Request => Request(35), North => south_2_north(9)(5), West => east_2_west(9)(4), P => Signal_priority(2), Fifo_full => Fifo_full(5),  
South => south_2_north(10)(5), East => east_2_west(10)(5) , Grant => Signal_grant(10)(5)); 

Arbiter_10_6 : Arbiter

PORT MAP (Request => Request(30), North => south_2_north(9)(6), West => east_2_west(9)(5), P => Signal_priority(2), Fifo_full => Fifo_full(6),  
South => south_2_north(10)(6), East => east_2_west(10)(6) , Grant => Signal_grant(10)(6)); 

-------------------------- Diagonale n 11 


Arbiter_11_1 : Arbiter

PORT MAP (Request => Request(25), North => south_2_north(10)(1), West => east_2_west(10)(6), P => Signal_priority(1), Fifo_full => Fifo_full(1),  
South => south_2_north(11)(1), East => east_2_west(11)(1) , Grant => Signal_grant(11)(1)); 

Arbiter_11_2 : Arbiter

PORT MAP (Request => Request(20), North => south_2_north(10)(2), West => east_2_west(10)(1), P => Signal_priority(1), Fifo_full => Fifo_full(2),  
South => south_2_north(11)(2), East => east_2_west(11)(2) , Grant => Signal_grant(11)(2)); 

Arbiter_11_3 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(10)(3), West => east_2_west(10)(2), P => Signal_priority(1), Fifo_full => Fifo_full(3),  
South => south_2_north(11)(3), East => east_2_west(11)(3) , Grant => Signal_grant(11)(3)); 

Arbiter_11_4 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(10)(4), West => east_2_west(10)(3), P => Signal_priority(1), Fifo_full => Fifo_full(4),  
South => south_2_north(11)(4), East => east_2_west(11)(4) , Grant => Signal_grant(11)(4)); 

Arbiter_11_5 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(10)(5), West => east_2_west(10)(4), P => Signal_priority(1), Fifo_full => Fifo_full(5),  
South => south_2_north(11)(5), East => east_2_west(11)(5) , Grant => Signal_grant(11)(5)); 

Arbiter_11_6 : Arbiter

PORT MAP (Request => Request(36), North => south_2_north(10)(6), West => east_2_west(10)(5), P => Signal_priority(1), Fifo_full => Fifo_full(6),  
South => south_2_north(11)(6), East => east_2_west(11)(6) , Grant => Signal_grant(11)(6)); 


--processus permettant de roter la priorit des diagonales  chaque front d'horloge
 -- rotation round robin
	 round_robin : process(clk)
	begin
		if rising_edge(clk) then
		 if reset ='1' then
		    Signal_priority <= "11111100000";
		  elsif priority_rotation_en = '1' then 
 		    case Signal_priority is
		       when "11111100000" => Signal_priority <= "01111110000";
		       when "01111110000" => Signal_priority <= "00111111000";
		       when "00111111000" => Signal_priority <= "00011111100";
		       when "00011111100" => Signal_priority <= "00001111110";
		       when "00001111110" => Signal_priority <= "00000111111";
		       when "00000111111" => Signal_priority <= "11111100000";
		       when others    => Signal_priority <= "11111100000";
		  end case;
		 end if;
	     end if;
	 end process;

end Behavioral;

