----------------------------------------------------------------------------------
-- Company: 
-- Engineer:  GAMOM NGOUNOU
-- 
-- Create Date:    05:52:25 06/21/2011 
-- Design Name: 
-- Module Name:    CORE_MPI - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity CORE_MPI is
    Port ( instruction : in  STD_LOGIC_VECTOR (7 downto 0);
           instruction_en : in  STD_LOGIC;
           ram_data_in : in  STD_LOGIC_VECTOR (7 downto 0);
           barrier_completed : out  STD_LOGIC;
           packet_received : out  STD_LOGIC;
			  packet_ack : in std_logic;
           PushOut : out  STD_LOGIC_VECTOR (7 downto 0);
           ram_we : out  STD_LOGIC;
           ram_address : out  STD_LOGIC_VECTOR (15 downto 0);
           ram_data_out : out  STD_LOGIC_VECTOR (7 downto 0);
			  dma_req       : out STD_Logic;  --requete vers application
			  dma_ack       : in  STD_Logic;  --autorisation par l'application
           --switch_port_in_cmd_en : in std_logic;
			  switch_port_in_wr_en : out  STD_LOGIC;
           switch_port_in_full : in  STD_LOGIC;
           switch_port_in_data : out  STD_LOGIC_VECTOR (7 downto 0);
           switch_port_out_rd_en : out  STD_LOGIC;
           switch_port_out_data_vailaible : in  STD_LOGIC;
			  clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           ram_en : out  STD_LOGIC;
           instruction_fifo_full : out  STD_LOGIC;
           switch_port_out_data : in  STD_LOGIC_VECTOR (7 downto 0));
end CORE_MPI;

architecture Structural of CORE_MPI is

-- dclaration des composants MPI

COMPONENT FIFO_64_FWFT
	PORT(
		clk : IN std_logic;
		din : IN std_logic_vector(7 downto 0);
		rd_en : IN std_logic;
		srst : IN std_logic;
		wr_en : IN std_logic;          
		dout : OUT std_logic_vector(7 downto 0);
		empty : OUT std_logic;
		full : OUT std_logic
		);
END COMPONENT;

COMPONENT DMA_ARBITER
	PORT(
		dma_rd_request : IN std_logic;
		data_wr_in : IN std_logic_vector(7 downto 0);
		data_rd_in : IN std_logic_vector(7 downto 0);
		address_rd : IN std_logic_vector(15 downto 0);
		address_wr : IN std_logic_vector(15 downto 0);
		clk : IN std_logic;
		reset : IN std_logic;
		dma_wr_request : IN std_logic;          
		address_out : OUT std_logic_vector(15 downto 0);
		ram_en : OUT std_logic;
		ram_we : OUT std_logic;
		dma_req       : out STD_Logic;  --requete vers application
		dma_ack       : in  STD_Logic;  --autorisation par l'application
		data_wr_out : OUT std_logic_vector(7 downto 0);
		data_rd_out : OUT std_logic_vector(7 downto 0);
		dma_wr_grant : OUT std_logic;
		dma_rd_grant : OUT std_logic
		);
END COMPONENT;

COMPONENT EX1_FSM
	PORT(
		clk : IN std_logic;
		reset : IN std_logic;
		fifo_empty : IN std_logic;
		fifo_data_out : IN std_logic_vector(7 downto 0);
		switch_port_in_full : IN std_logic;
		ram_data : IN std_logic_vector(7 downto 0);
		dma_grant : IN std_logic;          
		ram_address : OUT std_logic_vector(15 downto 0);
		priority_rotation : OUT std_logic;
		fifo_rd_en : OUT std_logic;
		switch_port_in_data : OUT std_logic_vector(7 downto 0);
		switch_port_in_wr_en : OUT std_logic;
		dma_request : OUT std_logic
		);
	END COMPONENT;	
	
COMPONENT EX2_FSM
	PORT(
		dma_grant : IN std_logic;
		fifo_full : IN std_logic;
		switch_data_available : IN std_logic;
		switch_port_out_data : IN std_logic_vector(7 downto 0);
		packet_ack : IN std_logic;
		clk : IN std_logic;
		reset : IN std_logic;          
		dma_request : OUT std_logic;
		ram_address : OUT std_logic_vector(15 downto 0);
		fifo_data : OUT std_logic_vector(7 downto 0);
		fifo_wr_en : OUT std_logic;
		packet_received : OUT std_logic;
		barrier_completed : OUT std_logic;
		switch_port_out_rd_en : OUT std_logic
		);
	END COMPONENT;


	COMPONENT EX3_FSM
	PORT(
		instruction : IN std_logic_vector(7 downto 0);
		clk : IN std_logic;
		reset : IN std_logic;     
		Ismain :in std_logic;
		ResOut : OUT std_logic_vector(7 downto 0)
		
		);
	END COMPONENT;
	COMPONENT EX0_FSM
	PORT(	Initialised : in  STD_LOGIC;
         Instruction : in  STD_LOGIC_VECTOR (7 downto 0);
         clk : in  STD_LOGIC;
         reset : in  STD_LOGIC;
         ClkRate : in  STD_LOGIC_VECTOR ;
			uTimeResult : out  STD_LOGIC_VECTOR; 
			TickResult : out STD_LOGIC_VECTOR
			  );
	END COMPONENT;


COMPONENT MPI_CORE_SCHEDULER
	PORT(
		clk : IN std_logic;
		reset : IN std_logic;
		priority_rotation : IN std_logic;
		instruction_fifo_empty : IN std_logic;
		get_request_fifo_empty : IN std_logic;
		instruction_fifo_data : IN std_logic_vector(7 downto 0);
		get_request_fifo_data : IN std_logic_vector(7 downto 0);
		fifo_rd_en : IN std_logic;          
		instruction_fifo_rd_en : OUT std_logic;
		get_request_fifo_rd_en : OUT std_logic;
		fifo_selected : OUT std_logic;
		instruction_available : OUT std_logic;
		fifo_empty : OUT std_logic;
		data_out : OUT std_logic_vector(7 downto 0)
		);
	END COMPONENT;
	
-- declaration des signaux d'interconnexion entre les modules du core
signal instruction_fifo1_rd_en : std_logic;
signal instruction_fifo1_full : std_logic;
signal instruction_fifo1_empty : std_logic;
signal instruction_fifo1_data_out : std_logic_vector(7 downto 0);
signal instruction_fifo2_rd_en : std_logic;
signal instruction_fifo2_data_out : std_logic_vector(7 downto 0);
signal instruction_fifo2_data_in : std_logic_vector(7 downto 0);
signal instruction_fifo2_wr_en : std_logic;
signal instruction_fifo2_empty : std_logic;
signal instruction_fifo2_full : std_logic;
signal ram_address_ex1_fsm : std_logic_vector(15 downto 0);
signal ram_data_ex1_fsm : std_logic_vector(7 downto 0);
signal scheduler_fifo_empty : std_logic;
signal scheduler_data_out : std_logic_vector(7 downto 0);
signal dma_arbiter_data_rd_out : std_logic_vector(7 downto 0);
signal ex1_fsm_ram_address : std_logic_vector(15 downto 0);
signal scheduler_priority_rotation : std_logic;
signal scheduler_rd_en : std_logic;
signal ex1_dma_request : std_logic;
signal ex1_dma_grant : std_logic;

signal ex2_dma_grant : std_logic;
signal ex2_dma_request : std_logic;
signal ex2_ram_address : std_logic_vector(15 downto 0);
signal switch_port_in_data_signal : std_logic_vector(7 downto 0);
signal ram_data_out_signal : std_logic_vector(7 downto 0);
signal instruction_fifo2_signal : std_logic_vector(7 downto 0);
--
--dclaration des signaux d'tat du Core
signal IsMain,SizeSet,RankSet,Initialised:std_logic;
signal LibState: std_logic_vector(7 downto 0); --ready,receiving,sending,spawning,rwaiting,swaiting,...
signal NocSize :std_logic_vector(3 downto 0);
Signal PortId : std_logic_vector(3 downto 0);
Signal uClkRate : std_logic_vector(31 downto 0);
signal uTimeCount :std_logic_vector(31 downto 0);
signal TickCount : std_logic_vector(31 downto 0);
signal RankSize: std_logic_vector(7 downto 0);
--signal PushOut_d,RankSize,TickUsOut:std_logic_vector; --rsultat de l'execution des commandes mpi
begin
--switch_port_in_data_signal <= ;
--switch_port_out_data_signal <= ;
-- istanciation des composants du core MPI
Instruction_Fifo1: FIFO_64_FWFT PORT MAP(
		clk =>clk,
		din =>instruction,
		rd_en => instruction_fifo1_rd_en,
		srst => reset,
		wr_en => instruction_en,
		dout =>instruction_fifo1_data_out,
		empty => instruction_fifo1_empty,
		full => instruction_fifo1_full
	);

Instruction_Fifo2: FIFO_64_FWFT PORT MAP(
		clk =>clk,
		din => instruction_fifo2_data_in ,
		rd_en =>instruction_fifo2_rd_en,
		srst =>reset,
		wr_en =>instruction_fifo2_wr_en,
		dout =>instruction_fifo2_data_out,
		empty =>instruction_fifo2_empty,
		full => instruction_fifo2_full 
	);
MPI_CORE_EX0_FSM: EX0_FSM PORT MAP(
		instruction => instruction,
		uTimeResult => uTimeCount,
		TickResult => TickCount,
		Initialised => Initialised,  -- indique si la l'appel  init a t concluant
		ClkRate => uClkRate,
		clk =>clk ,
		reset => reset 
	);
MPI_CORE_EX1_FSM: EX1_FSM PORT MAP(
		clk =>clk ,
		reset =>reset,
		fifo_empty => scheduler_fifo_empty ,
		fifo_data_out =>scheduler_data_out,
		switch_port_in_full =>switch_port_in_full,
		ram_data =>dma_arbiter_data_rd_out,
		ram_address =>ex1_fsm_ram_address,
		priority_rotation =>scheduler_priority_rotation,
		fifo_rd_en =>scheduler_rd_en,
		switch_port_in_data =>switch_port_in_data ,
		switch_port_in_wr_en =>switch_port_in_wr_en ,
		dma_request =>ex1_dma_request,
		dma_grant =>ex1_dma_grant 
	);
	
MPI_CORE_EX2_FSM: EX2_FSM PORT MAP(
		dma_grant =>ex2_dma_grant ,
		fifo_full =>instruction_fifo2_full,
		switch_data_available =>switch_port_out_data_vailaible,
		switch_port_out_data =>switch_port_out_data ,
		dma_request =>ex2_dma_request,
		ram_address =>ex2_ram_address,
		fifo_data =>instruction_fifo2_signal,
		fifo_wr_en => instruction_fifo2_wr_en,
		packet_received =>packet_received,
		packet_ack => packet_ack,
		barrier_completed =>barrier_completed,
		clk =>clk,
		reset =>reset,
		switch_port_out_rd_en => switch_port_out_rd_en 
	);
	
ICI_MPI_CORE_EX3_FSM: EX3_FSM PORT MAP(
		instruction => instruction,
		ResOut => RankSize,
		clk =>clk ,
		IsMain=>IsMain,
		reset => reset 
	);

MPI_CORE_DMA_ARBITER: DMA_ARBITER PORT MAP(
		dma_rd_request => ex1_dma_request,
		data_wr_in =>switch_port_out_data ,
		data_rd_in => dma_arbiter_data_rd_out,
		address_rd =>ex1_fsm_ram_address,
		address_wr =>ex2_ram_address,
		address_out =>ram_address,
		ram_en => ram_en,
		ram_we =>ram_we,
		dma_req=>dma_req,
		dma_ack=>dma_ack,
		data_wr_out => ram_data_out,
		data_rd_out => ram_data_out_signal,
		dma_wr_grant =>ex2_dma_grant,
		clk =>clk,
		reset =>reset,
		dma_rd_grant => ex1_dma_grant,
		dma_wr_request => ex1_dma_grant 
	);
	

CORE_SCHEDULER: MPI_CORE_SCHEDULER PORT MAP(
		clk => clk,
		reset => reset,
		priority_rotation =>scheduler_priority_rotation,
		instruction_fifo_empty =>instruction_fifo1_empty,
		get_request_fifo_empty => instruction_fifo2_empty,
		instruction_fifo_rd_en =>instruction_fifo1_rd_en,
		get_request_fifo_rd_en =>instruction_fifo2_rd_en ,
		instruction_fifo_data =>instruction_fifo1_data_out,
		get_request_fifo_data =>instruction_fifo2_data_out,
		fifo_selected =>open,
		instruction_available => open ,
		fifo_empty => scheduler_fifo_empty,
		fifo_rd_en =>scheduler_rd_en,
		data_out => scheduler_data_out
	);

end structural;

