--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   01:27:32 04/20/2012
-- Design Name:   
-- Module Name:   C:/Core MPI/CORE_MPI/MPICORETEST.vhd
-- Project Name:  MPI_CORE_COMPONENTS
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: MPI_NOC
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
library NocLib ;

use NocLib.CoreTypes.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY MPICORETEST IS
END MPICORETEST;
 
ARCHITECTURE behavior OF MPICORETEST IS 
constant WORD :positive:=8;
constant MEMSIZE:positive:=16;
 -- Components declaration
 COMPONENT RAM_v
  generic (width : positive;size :positive);
	PORT(
		clka : IN std_logic;
		clkb : IN std_logic;
		wea : IN std_logic;
		ena : IN std_logic;
		enb : IN std_logic;
		addra : IN std_logic_vector;
		addrb : IN std_logic_vector;
		dia : IN std_logic_vector;          
		dob : OUT std_logic_vector
		);
	END COMPONENT;

	
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT MPI_NOC
    PORT(
         MPI_Node_in : IN  std_logic_vector(1 to 4);
         MPI_Node_Out : OUT  std_logic_vector(1 to 4)
        );
    END COMPONENT;
    
   --signaux pour l'interconnexion
	signal clk : std_logic := '0';
	signal adresse :std_logic_vector(MEMSIZE-1 downto 0):= (others => '0');
	signal datain :std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_we ,ram_ena,ram_enb,ramsel: std_logic;
	signal pe_ram_we ,pe_ram_ena,pe_ram_enb: std_logic;
	signal ram_do,ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal pe_ram_do,pe_ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_adra,ram_adrb :std_logic_vector(MEMSIZE-1 downto 0);
	signal pe_ram_adra,pe_ram_adrb :std_logic_vector(MEMSIZE-1 downto 0);
   --Inputs
   signal MPI_Node_in : Typ_MPIPort_in(1 to 4) ;
-- Port details
--			instruction :   STD_LOGIC_VECTOR (Word -1 downto 0);
--           instruction_en :  STD_LOGIC;
--           packet_ack : std_logic;
--           ram_data_in :  STD_LOGIC_VECTOR (Word-1 downto 0);
--			  clk :  STD_LOGIC;
--           reset :  STD_LOGIC;
 	--Outputs
   signal MPI_Node_Out : Typ_MPIPort_out(1 to 4);
--	dtails des champs de Typ_MPIPORT_Out		  
--          
--			  
--           ram_we :  STD_LOGIC;
--			  ram_en :  STD_LOGIC;
--			  packet_received : STD_LOGIC;
--			  barrier_completed : STD_LOGIC;
--         instruction_fifo_full : STD_LOGIC;
--			  PushOut :  STD_LOGIC_VECTOR (WORD-1 downto 0);
--			  ram_data_out : STD_LOGIC_VECTOR (WORD-1 downto 0);
--           ram_address :  STD_LOGIC_VECTOR (ADRLEN-1 downto 0); 
--           		  
--end record;
   -- No clocks detected in port list. Replace <clock> below with 
   -- appropriate port name 
 
   constant clk_period : time := 10 ns;
 --signaux pour la gestion de la MAE
 type typ_mae is (start,Fillmem,NextFill,putdata,getdata,displaydata,terminate,timeout);

		signal etPutGet : typ_mae;
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: MPI_NOC PORT MAP (
          MPI_Node_in => MPI_Node_in,
          MPI_Node_Out => MPI_Node_Out
        );
Inst_RAM_v: RAM_v generic map(width=>word,size=>memsize)
	PORT MAP(
		clka =>clk,
		clkb => clk,
		wea => ram_we,
		ena => ram_ena,
		enb => ram_enb,
		addra => ram_adra,
		addrb =>ram_adrb,
		dia => ram_din,
		dob => ram_do 
	);
	
	--MUX de la RAM
	
ram_adra <= MPI_Node_out.ram_address WHEN ramsel ='1' ELSE 
            pe_ram_adra; 



	
   -- Clock process definitions
   clk_process :process
   begin
		clk <= '0';
		wait for clk_period/2;
		clk <= '1';
		wait for clk_period/2;
   end process;
 
 pPutGet:process(clk,reset)
	
	variable origport,destport,pid,mport : natural range 0 to 15;
	variable datalen,dcount ,timeout:natural range 0 to 255;
	begin
	
	if reset='1' then
		etputget<=cmdstart;
		destport:=0;
		timeout:=0;
		origport:=1;
		sorigport<=origport;
	elsif rising_edge(clk) then
			case  etputget is
			when start =>
				if bfill=0 and apprdy<='1' then -- si le nombre de bloc de mmoire remplis est vide
						etputget<=Fillmem;
				 end if;
				 
			
		 when Fillmem =>
			if mpi_node_in.dma_req='0' then 
					Ram_we<='1';
					Ram_ena<='1';
					Ram_din<=x"0f";
					RAm_addra<=STD_LOGIC_VECTOR(to_unsigned(adresse,16));
					
					dcount:=dcount+1;
					
					if dcount=50 then
					 bfill:=bfill+1;
					 etputget<=putdata;
					 if bfill=4 then
					  etputget<=getdata;
					 else
						etputget<=nextfill;
					end if;
					else
					adresse:=adresse+1;
					etputget<=Fillmem;
					end if;
			else -- attente de la libraion de la mmoire
			
			end if;
		when nextfill  =>   --prpare le prochain bloc mmoire qui sera rempli
				adresse:=50*bfill;
				dcount:=0;
				etputget<=Fillmem;
		 when putdata =>
				
				
				timeout:=0;
				--time_out(destport)<='0';
			if data_available(origport)='1' then 
				mport:=to_integer(unsigned(portout(origport)(7 downto 4)));
				pid:=to_integer(unsigned(portout(origport)(3 downto 0)))+1;
				--cdata_out_en(origport)<='1';
				if pid=origport then --le port a t bien identifi
						etcmd<=cmdlen; --
					else
					etcmd<=cmdtimeout;
				end if;
			else
--				if destport>=MAXPORT then 
--					destport:=1;
--					else 
--						destport:=destport+1;
--					end if;
				etcmd<=cmdread;
			end if;
			
			
			when cmdlen =>   --positionnement du mot de longueur des donnes
			if data_available(origport)='1' then 
			
			--cdata_out_en(origport)<='1';
			etcmd<=cmdglen;
			timeout:=0;
			else
				timeout:=timeout+1;
					if timeout>=30 then 
					--time_out(destport)<='1';
						etcmd<=cmdtimeout;             -- donnes pas prtes
					end if;
			
			
			end if;
			when cmdglen =>   --lecture effective de la longueur des donnes
			if data_available(origport)='1' then 
			datalen:=to_integer(unsigned(portout(origport)(7 downto 0)))-3;
			
			etcmd<=cmddata;
			dcount:=0;  -- initialisation du compteur de reception
			else
				timeout:=timeout+1;
					if timeout>=30 then 
					--time_out(destport)<='1';
						etcmd<=cmdtimeout;             -- donnes pas prtes
					end if;
			
			end if;
			
			when cmddata =>
			if data_available(origport)='1' and timeout<30 then 
					
					--cdata_out_en(origport)<='1';
					mport:=to_integer(unsigned(portout(origport)(7 downto 4)));
					--attention les ports sont numrots  partir de 0
					pid:=to_integer(unsigned(portout(origport)(3 downto 0)))+1;
					
					--severity note;
					if Pid=origport then 
						etcmd<=cmdend;
						
					else   --dpassement de la capacit
						
						timeout:=timeout+1;
						if timeout>=30 then 
							etcmd<=cmdtimeout;
						end if;
						
					end if;
			else
					
					if timeout>=30 then 
					   time_out(destport)<='1';
						etcmd<=cmdtimeout;             -- donnes pas prtes
					end if;
				   timeout:=timeout+1;
					
			end if;
			when cmdend =>
			
			
			--cdata_out_en(origport)<='0';
			
--					if origport>=mport then -- provoquer le passage au prochain port de rception
--						origport:=1;
--					else 
--						origport:=origport+1;
--					end if;
					etcmd<=cmdstart;
					--cmd_in_en(origport)<='0';
			when cmdtimeout =>
			  etcmd<=cmdtimeout;
			  --cmd_in_en(origport)<='0';
			  etcmd<=cmdstart;
			end case;
		sorigport<=origport;	
		end if;   --reset='1'
		
  end process pPutGet;	

majPutGet:process (etcmd)
variable origport : natural:=sorigport ;
	begin
			case  etcmd is
			when cmdstart =>
			
				cmd_in_en(origport)<='1';

		 when cmdpost | cmdpostidle =>
				din4(origport)<='1';
				tosend4<="00000001"; ---code pour getportid
				cmd_in_en(origport)<='1';
				cdata_out_en(origport)<='0';
		 when cmdread =>
				din4(origport)<='0';
				cdata_out_en(origport)<=data_available(origport);
				cmd_in_en(origport)<='1';
	
			when cmdlen |cmdglen =>   --positionnement du mot de longueur des donnes
	
					din4(origport)<='0';
					cdata_out_en(origport)<=data_available(origport);
					cmd_in_en(origport)<='1';

			when cmddata =>
			
					din4(origport)<='0';
					cdata_out_en(origport)<=data_available(origport);
					cmd_in_en(origport)<='1';
						
			
			when cmdend =>
			
				din4(origport)<='0';
				cdata_out_en(origport)<='0';
				cmd_in_en(origport)<='0';
			
			when cmdtimeout =>
				  din4(origport)<='0';
				  cdata_out_en(origport)<='0';
				  cmd_in_en(origport)<='0';
			 
			end case;
		
end process majPutGet ;  

 

END;
