----------------------------------------------------------------------------------
-- Company: 
-- Engineer: Kiegaing Emmanuel GEL EN 5
-- 
-- Create Date:    01:47 05/06/2011
-- Design Name: 
-- Module Name:    Crossbar - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: module implmentant un crosbar d'un bit
-- ces modules seront instancis pour faire le switch
-- module generique
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Crossbit is
    generic
	      (
			  number_of_ports: positive := 4
			);
    Port ( Control : in  STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1);
			  Data_In : in  STD_LOGIC_VECTOR (number_of_ports downto 1);
           Data_out : out  STD_LOGIC_VECTOR (number_of_ports downto 1)
			  );
end Crossbit;

architecture Behavioral of Crossbit is

begin
-- element de commutation utilisee dans la matrice interconnecte
-- le circuit genere depend du parametre generique nombre de ports
--======================crossbit 2 ports=======================

crossbit2x2 : if number_of_ports = 2 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(3)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(4)));
end generate crossbit2x2;


--======================crossbit 3 ports=======================

crossbit3x3 : if number_of_ports = 3 generate

 
  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(4)) OR (Data_in(3) And Control(7)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(5)) OR (Data_in(3) And Control(8)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(6)) OR (Data_in(3) And Control(9)));
end generate crossbit3x3;


--======================crossbit 4 ports=======================

crossbit4x4 : if number_of_ports = 4 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(5)) OR (Data_in(3) And Control(9)) OR (Data_in(4) And Control(13)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(6)) OR (Data_in(3) And Control(10)) OR (Data_in(4) And Control(14)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(7)) OR (Data_in(3) And Control(11)) OR (Data_in(4) And Control(15)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(8)) OR (Data_in(3) And Control(12)) OR (Data_in(4) And Control(16)));
end generate crossbit4x4;


--======================crossbit 5 ports=======================

crossbit5x5 : if number_of_ports = 5 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(6)) OR (Data_in(3) And Control(11)) OR (Data_in(4) And Control(16)) OR (Data_in(5) And Control(21)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(7)) OR (Data_in(3) And Control(12)) OR (Data_in(4) And Control(17)) OR (Data_in(5) And Control(22)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(8)) OR (Data_in(3) And Control(13)) OR (Data_in(4) And Control(18)) OR (Data_in(5) And Control(23)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(9)) OR (Data_in(3) And Control(14)) OR (Data_in(4) And Control(19)) OR (Data_in(5) And Control(24)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(10)) OR (Data_in(3) And Control(15)) OR (Data_in(4) And Control(20)) OR (Data_in(5) And Control(25)));
end generate crossbit5x5;


--======================crossbit 6 ports=======================

crossbit6x6 : if number_of_ports = 6 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(7)) OR (Data_in(3) And Control(13)) OR (Data_in(4) And Control(19)) OR (Data_in(5) And Control(25)) OR (Data_in(6) And Control(31)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(8)) OR (Data_in(3) And Control(14)) OR (Data_in(4) And Control(20)) OR (Data_in(5) And Control(26)) OR (Data_in(6) And Control(32)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(9)) OR (Data_in(3) And Control(15)) OR (Data_in(4) And Control(21)) OR (Data_in(5) And Control(27)) OR (Data_in(6) And Control(33)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(10)) OR (Data_in(3) And Control(16)) OR (Data_in(4) And Control(22)) OR (Data_in(5) And Control(28)) OR (Data_in(6) And Control(34)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(11)) OR (Data_in(3) And Control(17)) OR (Data_in(4) And Control(23)) OR (Data_in(5) And Control(29)) OR (Data_in(6) And Control(35)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(12)) OR (Data_in(3) And Control(18)) OR (Data_in(4) And Control(24)) OR (Data_in(5) And Control(30)) OR (Data_in(6) And Control(36)));
end generate crossbit6x6;


--======================crossbit 7 ports=======================

crossbit7x7 : if number_of_ports = 7 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(8)) OR (Data_in(3) And Control(15)) OR (Data_in(4) And Control(22)) OR (Data_in(5) And Control(29)) OR (Data_in(6) And Control(36)) OR (Data_in(7) And Control(43)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(9)) OR (Data_in(3) And Control(16)) OR (Data_in(4) And Control(23)) OR (Data_in(5) And Control(30)) OR (Data_in(6) And Control(37)) OR (Data_in(7) And Control(44)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(10)) OR (Data_in(3) And Control(17)) OR (Data_in(4) And Control(24)) OR (Data_in(5) And Control(31)) OR (Data_in(6) And Control(38)) OR (Data_in(7) And Control(45)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(11)) OR (Data_in(3) And Control(18)) OR (Data_in(4) And Control(25)) OR (Data_in(5) And Control(32)) OR (Data_in(6) And Control(39)) OR (Data_in(7) And Control(46)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(12)) OR (Data_in(3) And Control(19)) OR (Data_in(4) And Control(26)) OR (Data_in(5) And Control(33)) OR (Data_in(6) And Control(40)) OR (Data_in(7) And Control(47)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(13)) OR (Data_in(3) And Control(20)) OR (Data_in(4) And Control(27)) OR (Data_in(5) And Control(34)) OR (Data_in(6) And Control(41)) OR (Data_in(7) And Control(48)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(21)) OR (Data_in(4) And Control(28)) OR (Data_in(5) And Control(35)) OR (Data_in(6) And Control(42)) OR (Data_in(7) And Control(49)));
end generate crossbit7x7;


--======================crossbit 8 ports=======================

crossbit8x8 : if number_of_ports = 8 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(9)) OR (Data_in(3) And Control(17)) OR (Data_in(4) And Control(25)) OR (Data_in(5) And Control(33)) OR (Data_in(6) And Control(41)) OR (Data_in(7) And Control(49)) OR (Data_in(8) And Control(57)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(10)) OR (Data_in(3) And Control(18)) OR (Data_in(4) And Control(26)) OR (Data_in(5) And Control(34)) OR (Data_in(6) And Control(42)) OR (Data_in(7) And Control(50)) OR (Data_in(8) And Control(58)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(11)) OR (Data_in(3) And Control(19)) OR (Data_in(4) And Control(27)) OR (Data_in(5) And Control(35)) OR (Data_in(6) And Control(43)) OR (Data_in(7) And Control(51)) OR (Data_in(8) And Control(59)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(12)) OR (Data_in(3) And Control(20)) OR (Data_in(4) And Control(28)) OR (Data_in(5) And Control(36)) OR (Data_in(6) And Control(44)) OR (Data_in(7) And Control(52)) OR (Data_in(8) And Control(60)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(13)) OR (Data_in(3) And Control(21)) OR (Data_in(4) And Control(29)) OR (Data_in(5) And Control(37)) OR (Data_in(6) And Control(45)) OR (Data_in(7) And Control(53)) OR (Data_in(8) And Control(61)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(22)) OR (Data_in(4) And Control(30)) OR (Data_in(5) And Control(38)) OR (Data_in(6) And Control(46)) OR (Data_in(7) And Control(54)) OR (Data_in(8) And Control(62)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(23)) OR (Data_in(4) And Control(31)) OR (Data_in(5) And Control(39)) OR (Data_in(6) And Control(47)) OR (Data_in(7) And Control(55)) OR (Data_in(8) And Control(63)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(24)) OR (Data_in(4) And Control(32)) OR (Data_in(5) And Control(40)) OR (Data_in(6) And Control(48)) OR (Data_in(7) And Control(56)) OR (Data_in(8) And Control(64)));
end generate crossbit8x8;


--======================crossbit 9 ports=======================

crossbit9x9 : if number_of_ports = 9 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(10)) OR (Data_in(3) And Control(19)) OR (Data_in(4) And Control(28)) OR (Data_in(5) And Control(37)) OR (Data_in(6) And Control(46)) OR (Data_in(7) And Control(55)) OR (Data_in(8) And Control(64)) OR (Data_in(9) And Control(73)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(11)) OR (Data_in(3) And Control(20)) OR (Data_in(4) And Control(29)) OR (Data_in(5) And Control(38)) OR (Data_in(6) And Control(47)) OR (Data_in(7) And Control(56)) OR (Data_in(8) And Control(65)) OR (Data_in(9) And Control(74)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(12)) OR (Data_in(3) And Control(21)) OR (Data_in(4) And Control(30)) OR (Data_in(5) And Control(39)) OR (Data_in(6) And Control(48)) OR (Data_in(7) And Control(57)) OR (Data_in(8) And Control(66)) OR (Data_in(9) And Control(75)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(13)) OR (Data_in(3) And Control(22)) OR (Data_in(4) And Control(31)) OR (Data_in(5) And Control(40)) OR (Data_in(6) And Control(49)) OR (Data_in(7) And Control(58)) OR (Data_in(8) And Control(67)) OR (Data_in(9) And Control(76)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(23)) OR (Data_in(4) And Control(32)) OR (Data_in(5) And Control(41)) OR (Data_in(6) And Control(50)) OR (Data_in(7) And Control(59)) OR (Data_in(8) And Control(68)) OR (Data_in(9) And Control(77)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(24)) OR (Data_in(4) And Control(33)) OR (Data_in(5) And Control(42)) OR (Data_in(6) And Control(51)) OR (Data_in(7) And Control(60)) OR (Data_in(8) And Control(69)) OR (Data_in(9) And Control(78)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(25)) OR (Data_in(4) And Control(34)) OR (Data_in(5) And Control(43)) OR (Data_in(6) And Control(52)) OR (Data_in(7) And Control(61)) OR (Data_in(8) And Control(70)) OR (Data_in(9) And Control(79)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(26)) OR (Data_in(4) And Control(35)) OR (Data_in(5) And Control(44)) OR (Data_in(6) And Control(53)) OR (Data_in(7) And Control(62)) OR (Data_in(8) And Control(71)) OR (Data_in(9) And Control(80)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(27)) OR (Data_in(4) And Control(36)) OR (Data_in(5) And Control(45)) OR (Data_in(6) And Control(54)) OR (Data_in(7) And Control(63)) OR (Data_in(8) And Control(72)) OR (Data_in(9) And Control(81)));
end generate crossbit9x9;


--======================crossbit 10 ports=======================

crossbit10x10 : if number_of_ports = 10 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(11)) OR (Data_in(3) And Control(21)) OR (Data_in(4) And Control(31)) OR (Data_in(5) And Control(41)) OR (Data_in(6) And Control(51)) OR (Data_in(7) And Control(61)) OR (Data_in(8) And Control(71)) OR (Data_in(9) And Control(81)) OR (Data_in(10) And Control(91)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(12)) OR (Data_in(3) And Control(22)) OR (Data_in(4) And Control(32)) OR (Data_in(5) And Control(42)) OR (Data_in(6) And Control(52)) OR (Data_in(7) And Control(62)) OR (Data_in(8) And Control(72)) OR (Data_in(9) And Control(82)) OR (Data_in(10) And Control(92)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(13)) OR (Data_in(3) And Control(23)) OR (Data_in(4) And Control(33)) OR (Data_in(5) And Control(43)) OR (Data_in(6) And Control(53)) OR (Data_in(7) And Control(63)) OR (Data_in(8) And Control(73)) OR (Data_in(9) And Control(83)) OR (Data_in(10) And Control(93)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(24)) OR (Data_in(4) And Control(34)) OR (Data_in(5) And Control(44)) OR (Data_in(6) And Control(54)) OR (Data_in(7) And Control(64)) OR (Data_in(8) And Control(74)) OR (Data_in(9) And Control(84)) OR (Data_in(10) And Control(94)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(25)) OR (Data_in(4) And Control(35)) OR (Data_in(5) And Control(45)) OR (Data_in(6) And Control(55)) OR (Data_in(7) And Control(65)) OR (Data_in(8) And Control(75)) OR (Data_in(9) And Control(85)) OR (Data_in(10) And Control(95)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(26)) OR (Data_in(4) And Control(36)) OR (Data_in(5) And Control(46)) OR (Data_in(6) And Control(56)) OR (Data_in(7) And Control(66)) OR (Data_in(8) And Control(76)) OR (Data_in(9) And Control(86)) OR (Data_in(10) And Control(96)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(27)) OR (Data_in(4) And Control(37)) OR (Data_in(5) And Control(47)) OR (Data_in(6) And Control(57)) OR (Data_in(7) And Control(67)) OR (Data_in(8) And Control(77)) OR (Data_in(9) And Control(87)) OR (Data_in(10) And Control(97)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(28)) OR (Data_in(4) And Control(38)) OR (Data_in(5) And Control(48)) OR (Data_in(6) And Control(58)) OR (Data_in(7) And Control(68)) OR (Data_in(8) And Control(78)) OR (Data_in(9) And Control(88)) OR (Data_in(10) And Control(98)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(29)) OR (Data_in(4) And Control(39)) OR (Data_in(5) And Control(49)) OR (Data_in(6) And Control(59)) OR (Data_in(7) And Control(69)) OR (Data_in(8) And Control(79)) OR (Data_in(9) And Control(89)) OR (Data_in(10) And Control(99)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(30)) OR (Data_in(4) And Control(40)) OR (Data_in(5) And Control(50)) OR (Data_in(6) And Control(60)) OR (Data_in(7) And Control(70)) OR (Data_in(8) And Control(80)) OR (Data_in(9) And Control(90)) OR (Data_in(10) And Control(100)));
end generate crossbit10x10;


--======================crossbit 11 ports=======================

crossbit11x11 : if number_of_ports = 11 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(12)) OR (Data_in(3) And Control(23)) OR (Data_in(4) And Control(34)) OR (Data_in(5) And Control(45)) OR (Data_in(6) And Control(56)) OR (Data_in(7) And Control(67)) OR (Data_in(8) And Control(78)) OR (Data_in(9) And Control(89)) OR (Data_in(10) And Control(100)) OR (Data_in(11) And Control(111)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(13)) OR (Data_in(3) And Control(24)) OR (Data_in(4) And Control(35)) OR (Data_in(5) And Control(46)) OR (Data_in(6) And Control(57)) OR (Data_in(7) And Control(68)) OR (Data_in(8) And Control(79)) OR (Data_in(9) And Control(90)) OR (Data_in(10) And Control(101)) OR (Data_in(11) And Control(112)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(25)) OR (Data_in(4) And Control(36)) OR (Data_in(5) And Control(47)) OR (Data_in(6) And Control(58)) OR (Data_in(7) And Control(69)) OR (Data_in(8) And Control(80)) OR (Data_in(9) And Control(91)) OR (Data_in(10) And Control(102)) OR (Data_in(11) And Control(113)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(26)) OR (Data_in(4) And Control(37)) OR (Data_in(5) And Control(48)) OR (Data_in(6) And Control(59)) OR (Data_in(7) And Control(70)) OR (Data_in(8) And Control(81)) OR (Data_in(9) And Control(92)) OR (Data_in(10) And Control(103)) OR (Data_in(11) And Control(114)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(27)) OR (Data_in(4) And Control(38)) OR (Data_in(5) And Control(49)) OR (Data_in(6) And Control(60)) OR (Data_in(7) And Control(71)) OR (Data_in(8) And Control(82)) OR (Data_in(9) And Control(93)) OR (Data_in(10) And Control(104)) OR (Data_in(11) And Control(115)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(28)) OR (Data_in(4) And Control(39)) OR (Data_in(5) And Control(50)) OR (Data_in(6) And Control(61)) OR (Data_in(7) And Control(72)) OR (Data_in(8) And Control(83)) OR (Data_in(9) And Control(94)) OR (Data_in(10) And Control(105)) OR (Data_in(11) And Control(116)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(29)) OR (Data_in(4) And Control(40)) OR (Data_in(5) And Control(51)) OR (Data_in(6) And Control(62)) OR (Data_in(7) And Control(73)) OR (Data_in(8) And Control(84)) OR (Data_in(9) And Control(95)) OR (Data_in(10) And Control(106)) OR (Data_in(11) And Control(117)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(30)) OR (Data_in(4) And Control(41)) OR (Data_in(5) And Control(52)) OR (Data_in(6) And Control(63)) OR (Data_in(7) And Control(74)) OR (Data_in(8) And Control(85)) OR (Data_in(9) And Control(96)) OR (Data_in(10) And Control(107)) OR (Data_in(11) And Control(118)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(31)) OR (Data_in(4) And Control(42)) OR (Data_in(5) And Control(53)) OR (Data_in(6) And Control(64)) OR (Data_in(7) And Control(75)) OR (Data_in(8) And Control(86)) OR (Data_in(9) And Control(97)) OR (Data_in(10) And Control(108)) OR (Data_in(11) And Control(119)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(21)) OR (Data_in(3) And Control(32)) OR (Data_in(4) And Control(43)) OR (Data_in(5) And Control(54)) OR (Data_in(6) And Control(65)) OR (Data_in(7) And Control(76)) OR (Data_in(8) And Control(87)) OR (Data_in(9) And Control(98)) OR (Data_in(10) And Control(109)) OR (Data_in(11) And Control(120)));
  Data_out(11) <= ((Data_in(1) And Control(11)) OR (Data_in(2) And Control(22)) OR (Data_in(3) And Control(33)) OR (Data_in(4) And Control(44)) OR (Data_in(5) And Control(55)) OR (Data_in(6) And Control(66)) OR (Data_in(7) And Control(77)) OR (Data_in(8) And Control(88)) OR (Data_in(9) And Control(99)) OR (Data_in(10) And Control(110)) OR (Data_in(11) And Control(121)));
end generate crossbit11x11;


--======================crossbit 12 ports=======================

crossbit12x12 : if number_of_ports = 12 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(13)) OR (Data_in(3) And Control(25)) OR (Data_in(4) And Control(37)) OR (Data_in(5) And Control(49)) OR (Data_in(6) And Control(61)) OR (Data_in(7) And Control(73)) OR (Data_in(8) And Control(85)) OR (Data_in(9) And Control(97)) OR (Data_in(10) And Control(109)) OR (Data_in(11) And Control(121)) OR (Data_in(12) And Control(133)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(26)) OR (Data_in(4) And Control(38)) OR (Data_in(5) And Control(50)) OR (Data_in(6) And Control(62)) OR (Data_in(7) And Control(74)) OR (Data_in(8) And Control(86)) OR (Data_in(9) And Control(98)) OR (Data_in(10) And Control(110)) OR (Data_in(11) And Control(122)) OR (Data_in(12) And Control(134)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(27)) OR (Data_in(4) And Control(39)) OR (Data_in(5) And Control(51)) OR (Data_in(6) And Control(63)) OR (Data_in(7) And Control(75)) OR (Data_in(8) And Control(87)) OR (Data_in(9) And Control(99)) OR (Data_in(10) And Control(111)) OR (Data_in(11) And Control(123)) OR (Data_in(12) And Control(135)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(28)) OR (Data_in(4) And Control(40)) OR (Data_in(5) And Control(52)) OR (Data_in(6) And Control(64)) OR (Data_in(7) And Control(76)) OR (Data_in(8) And Control(88)) OR (Data_in(9) And Control(100)) OR (Data_in(10) And Control(112)) OR (Data_in(11) And Control(124)) OR (Data_in(12) And Control(136)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(29)) OR (Data_in(4) And Control(41)) OR (Data_in(5) And Control(53)) OR (Data_in(6) And Control(65)) OR (Data_in(7) And Control(77)) OR (Data_in(8) And Control(89)) OR (Data_in(9) And Control(101)) OR (Data_in(10) And Control(113)) OR (Data_in(11) And Control(125)) OR (Data_in(12) And Control(137)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(30)) OR (Data_in(4) And Control(42)) OR (Data_in(5) And Control(54)) OR (Data_in(6) And Control(66)) OR (Data_in(7) And Control(78)) OR (Data_in(8) And Control(90)) OR (Data_in(9) And Control(102)) OR (Data_in(10) And Control(114)) OR (Data_in(11) And Control(126)) OR (Data_in(12) And Control(138)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(31)) OR (Data_in(4) And Control(43)) OR (Data_in(5) And Control(55)) OR (Data_in(6) And Control(67)) OR (Data_in(7) And Control(79)) OR (Data_in(8) And Control(91)) OR (Data_in(9) And Control(103)) OR (Data_in(10) And Control(115)) OR (Data_in(11) And Control(127)) OR (Data_in(12) And Control(139)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(32)) OR (Data_in(4) And Control(44)) OR (Data_in(5) And Control(56)) OR (Data_in(6) And Control(68)) OR (Data_in(7) And Control(80)) OR (Data_in(8) And Control(92)) OR (Data_in(9) And Control(104)) OR (Data_in(10) And Control(116)) OR (Data_in(11) And Control(128)) OR (Data_in(12) And Control(140)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(21)) OR (Data_in(3) And Control(33)) OR (Data_in(4) And Control(45)) OR (Data_in(5) And Control(57)) OR (Data_in(6) And Control(69)) OR (Data_in(7) And Control(81)) OR (Data_in(8) And Control(93)) OR (Data_in(9) And Control(105)) OR (Data_in(10) And Control(117)) OR (Data_in(11) And Control(129)) OR (Data_in(12) And Control(141)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(22)) OR (Data_in(3) And Control(34)) OR (Data_in(4) And Control(46)) OR (Data_in(5) And Control(58)) OR (Data_in(6) And Control(70)) OR (Data_in(7) And Control(82)) OR (Data_in(8) And Control(94)) OR (Data_in(9) And Control(106)) OR (Data_in(10) And Control(118)) OR (Data_in(11) And Control(130)) OR (Data_in(12) And Control(142)));
  Data_out(11) <= ((Data_in(1) And Control(11)) OR (Data_in(2) And Control(23)) OR (Data_in(3) And Control(35)) OR (Data_in(4) And Control(47)) OR (Data_in(5) And Control(59)) OR (Data_in(6) And Control(71)) OR (Data_in(7) And Control(83)) OR (Data_in(8) And Control(95)) OR (Data_in(9) And Control(107)) OR (Data_in(10) And Control(119)) OR (Data_in(11) And Control(131)) OR (Data_in(12) And Control(143)));
  Data_out(12) <= ((Data_in(1) And Control(12)) OR (Data_in(2) And Control(24)) OR (Data_in(3) And Control(36)) OR (Data_in(4) And Control(48)) OR (Data_in(5) And Control(60)) OR (Data_in(6) And Control(72)) OR (Data_in(7) And Control(84)) OR (Data_in(8) And Control(96)) OR (Data_in(9) And Control(108)) OR (Data_in(10) And Control(120)) OR (Data_in(11) And Control(132)) OR (Data_in(12) And Control(144)));
end generate crossbit12x12;


--======================crossbit 13 ports=======================

crossbit13x13 : if number_of_ports = 13 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(14)) OR (Data_in(3) And Control(27)) OR (Data_in(4) And Control(40)) OR (Data_in(5) And Control(53)) OR (Data_in(6) And Control(66)) OR (Data_in(7) And Control(79)) OR (Data_in(8) And Control(92)) OR (Data_in(9) And Control(105)) OR (Data_in(10) And Control(118)) OR (Data_in(11) And Control(131)) OR (Data_in(12) And Control(144)) OR (Data_in(13) And Control(157)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(28)) OR (Data_in(4) And Control(41)) OR (Data_in(5) And Control(54)) OR (Data_in(6) And Control(67)) OR (Data_in(7) And Control(80)) OR (Data_in(8) And Control(93)) OR (Data_in(9) And Control(106)) OR (Data_in(10) And Control(119)) OR (Data_in(11) And Control(132)) OR (Data_in(12) And Control(145)) OR (Data_in(13) And Control(158)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(29)) OR (Data_in(4) And Control(42)) OR (Data_in(5) And Control(55)) OR (Data_in(6) And Control(68)) OR (Data_in(7) And Control(81)) OR (Data_in(8) And Control(94)) OR (Data_in(9) And Control(107)) OR (Data_in(10) And Control(120)) OR (Data_in(11) And Control(133)) OR (Data_in(12) And Control(146)) OR (Data_in(13) And Control(159)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(30)) OR (Data_in(4) And Control(43)) OR (Data_in(5) And Control(56)) OR (Data_in(6) And Control(69)) OR (Data_in(7) And Control(82)) OR (Data_in(8) And Control(95)) OR (Data_in(9) And Control(108)) OR (Data_in(10) And Control(121)) OR (Data_in(11) And Control(134)) OR (Data_in(12) And Control(147)) OR (Data_in(13) And Control(160)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(31)) OR (Data_in(4) And Control(44)) OR (Data_in(5) And Control(57)) OR (Data_in(6) And Control(70)) OR (Data_in(7) And Control(83)) OR (Data_in(8) And Control(96)) OR (Data_in(9) And Control(109)) OR (Data_in(10) And Control(122)) OR (Data_in(11) And Control(135)) OR (Data_in(12) And Control(148)) OR (Data_in(13) And Control(161)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(32)) OR (Data_in(4) And Control(45)) OR (Data_in(5) And Control(58)) OR (Data_in(6) And Control(71)) OR (Data_in(7) And Control(84)) OR (Data_in(8) And Control(97)) OR (Data_in(9) And Control(110)) OR (Data_in(10) And Control(123)) OR (Data_in(11) And Control(136)) OR (Data_in(12) And Control(149)) OR (Data_in(13) And Control(162)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(33)) OR (Data_in(4) And Control(46)) OR (Data_in(5) And Control(59)) OR (Data_in(6) And Control(72)) OR (Data_in(7) And Control(85)) OR (Data_in(8) And Control(98)) OR (Data_in(9) And Control(111)) OR (Data_in(10) And Control(124)) OR (Data_in(11) And Control(137)) OR (Data_in(12) And Control(150)) OR (Data_in(13) And Control(163)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(21)) OR (Data_in(3) And Control(34)) OR (Data_in(4) And Control(47)) OR (Data_in(5) And Control(60)) OR (Data_in(6) And Control(73)) OR (Data_in(7) And Control(86)) OR (Data_in(8) And Control(99)) OR (Data_in(9) And Control(112)) OR (Data_in(10) And Control(125)) OR (Data_in(11) And Control(138)) OR (Data_in(12) And Control(151)) OR (Data_in(13) And Control(164)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(22)) OR (Data_in(3) And Control(35)) OR (Data_in(4) And Control(48)) OR (Data_in(5) And Control(61)) OR (Data_in(6) And Control(74)) OR (Data_in(7) And Control(87)) OR (Data_in(8) And Control(100)) OR (Data_in(9) And Control(113)) OR (Data_in(10) And Control(126)) OR (Data_in(11) And Control(139)) OR (Data_in(12) And Control(152)) OR (Data_in(13) And Control(165)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(23)) OR (Data_in(3) And Control(36)) OR (Data_in(4) And Control(49)) OR (Data_in(5) And Control(62)) OR (Data_in(6) And Control(75)) OR (Data_in(7) And Control(88)) OR (Data_in(8) And Control(101)) OR (Data_in(9) And Control(114)) OR (Data_in(10) And Control(127)) OR (Data_in(11) And Control(140)) OR (Data_in(12) And Control(153)) OR (Data_in(13) And Control(166)));
  Data_out(11) <= ((Data_in(1) And Control(11)) OR (Data_in(2) And Control(24)) OR (Data_in(3) And Control(37)) OR (Data_in(4) And Control(50)) OR (Data_in(5) And Control(63)) OR (Data_in(6) And Control(76)) OR (Data_in(7) And Control(89)) OR (Data_in(8) And Control(102)) OR (Data_in(9) And Control(115)) OR (Data_in(10) And Control(128)) OR (Data_in(11) And Control(141)) OR (Data_in(12) And Control(154)) OR (Data_in(13) And Control(167)));
  Data_out(12) <= ((Data_in(1) And Control(12)) OR (Data_in(2) And Control(25)) OR (Data_in(3) And Control(38)) OR (Data_in(4) And Control(51)) OR (Data_in(5) And Control(64)) OR (Data_in(6) And Control(77)) OR (Data_in(7) And Control(90)) OR (Data_in(8) And Control(103)) OR (Data_in(9) And Control(116)) OR (Data_in(10) And Control(129)) OR (Data_in(11) And Control(142)) OR (Data_in(12) And Control(155)) OR (Data_in(13) And Control(168)));
  Data_out(13) <= ((Data_in(1) And Control(13)) OR (Data_in(2) And Control(26)) OR (Data_in(3) And Control(39)) OR (Data_in(4) And Control(52)) OR (Data_in(5) And Control(65)) OR (Data_in(6) And Control(78)) OR (Data_in(7) And Control(91)) OR (Data_in(8) And Control(104)) OR (Data_in(9) And Control(117)) OR (Data_in(10) And Control(130)) OR (Data_in(11) And Control(143)) OR (Data_in(12) And Control(156)) OR (Data_in(13) And Control(169)));
end generate crossbit13x13;


--======================crossbit 14 ports=======================

crossbit14x14 : if number_of_ports = 14 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(15)) OR (Data_in(3) And Control(29)) OR (Data_in(4) And Control(43)) OR (Data_in(5) And Control(57)) OR (Data_in(6) And Control(71)) OR (Data_in(7) And Control(85)) OR (Data_in(8) And Control(99)) OR (Data_in(9) And Control(113)) OR (Data_in(10) And Control(127)) OR (Data_in(11) And Control(141)) OR (Data_in(12) And Control(155)) OR (Data_in(13) And Control(169)) OR (Data_in(14) And Control(183)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(30)) OR (Data_in(4) And Control(44)) OR (Data_in(5) And Control(58)) OR (Data_in(6) And Control(72)) OR (Data_in(7) And Control(86)) OR (Data_in(8) And Control(100)) OR (Data_in(9) And Control(114)) OR (Data_in(10) And Control(128)) OR (Data_in(11) And Control(142)) OR (Data_in(12) And Control(156)) OR (Data_in(13) And Control(170)) OR (Data_in(14) And Control(184)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(31)) OR (Data_in(4) And Control(45)) OR (Data_in(5) And Control(59)) OR (Data_in(6) And Control(73)) OR (Data_in(7) And Control(87)) OR (Data_in(8) And Control(101)) OR (Data_in(9) And Control(115)) OR (Data_in(10) And Control(129)) OR (Data_in(11) And Control(143)) OR (Data_in(12) And Control(157)) OR (Data_in(13) And Control(171)) OR (Data_in(14) And Control(185)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(32)) OR (Data_in(4) And Control(46)) OR (Data_in(5) And Control(60)) OR (Data_in(6) And Control(74)) OR (Data_in(7) And Control(88)) OR (Data_in(8) And Control(102)) OR (Data_in(9) And Control(116)) OR (Data_in(10) And Control(130)) OR (Data_in(11) And Control(144)) OR (Data_in(12) And Control(158)) OR (Data_in(13) And Control(172)) OR (Data_in(14) And Control(186)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(33)) OR (Data_in(4) And Control(47)) OR (Data_in(5) And Control(61)) OR (Data_in(6) And Control(75)) OR (Data_in(7) And Control(89)) OR (Data_in(8) And Control(103)) OR (Data_in(9) And Control(117)) OR (Data_in(10) And Control(131)) OR (Data_in(11) And Control(145)) OR (Data_in(12) And Control(159)) OR (Data_in(13) And Control(173)) OR (Data_in(14) And Control(187)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(34)) OR (Data_in(4) And Control(48)) OR (Data_in(5) And Control(62)) OR (Data_in(6) And Control(76)) OR (Data_in(7) And Control(90)) OR (Data_in(8) And Control(104)) OR (Data_in(9) And Control(118)) OR (Data_in(10) And Control(132)) OR (Data_in(11) And Control(146)) OR (Data_in(12) And Control(160)) OR (Data_in(13) And Control(174)) OR (Data_in(14) And Control(188)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(21)) OR (Data_in(3) And Control(35)) OR (Data_in(4) And Control(49)) OR (Data_in(5) And Control(63)) OR (Data_in(6) And Control(77)) OR (Data_in(7) And Control(91)) OR (Data_in(8) And Control(105)) OR (Data_in(9) And Control(119)) OR (Data_in(10) And Control(133)) OR (Data_in(11) And Control(147)) OR (Data_in(12) And Control(161)) OR (Data_in(13) And Control(175)) OR (Data_in(14) And Control(189)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(22)) OR (Data_in(3) And Control(36)) OR (Data_in(4) And Control(50)) OR (Data_in(5) And Control(64)) OR (Data_in(6) And Control(78)) OR (Data_in(7) And Control(92)) OR (Data_in(8) And Control(106)) OR (Data_in(9) And Control(120)) OR (Data_in(10) And Control(134)) OR (Data_in(11) And Control(148)) OR (Data_in(12) And Control(162)) OR (Data_in(13) And Control(176)) OR (Data_in(14) And Control(190)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(23)) OR (Data_in(3) And Control(37)) OR (Data_in(4) And Control(51)) OR (Data_in(5) And Control(65)) OR (Data_in(6) And Control(79)) OR (Data_in(7) And Control(93)) OR (Data_in(8) And Control(107)) OR (Data_in(9) And Control(121)) OR (Data_in(10) And Control(135)) OR (Data_in(11) And Control(149)) OR (Data_in(12) And Control(163)) OR (Data_in(13) And Control(177)) OR (Data_in(14) And Control(191)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(24)) OR (Data_in(3) And Control(38)) OR (Data_in(4) And Control(52)) OR (Data_in(5) And Control(66)) OR (Data_in(6) And Control(80)) OR (Data_in(7) And Control(94)) OR (Data_in(8) And Control(108)) OR (Data_in(9) And Control(122)) OR (Data_in(10) And Control(136)) OR (Data_in(11) And Control(150)) OR (Data_in(12) And Control(164)) OR (Data_in(13) And Control(178)) OR (Data_in(14) And Control(192)));
  Data_out(11) <= ((Data_in(1) And Control(11)) OR (Data_in(2) And Control(25)) OR (Data_in(3) And Control(39)) OR (Data_in(4) And Control(53)) OR (Data_in(5) And Control(67)) OR (Data_in(6) And Control(81)) OR (Data_in(7) And Control(95)) OR (Data_in(8) And Control(109)) OR (Data_in(9) And Control(123)) OR (Data_in(10) And Control(137)) OR (Data_in(11) And Control(151)) OR (Data_in(12) And Control(165)) OR (Data_in(13) And Control(179)) OR (Data_in(14) And Control(193)));
  Data_out(12) <= ((Data_in(1) And Control(12)) OR (Data_in(2) And Control(26)) OR (Data_in(3) And Control(40)) OR (Data_in(4) And Control(54)) OR (Data_in(5) And Control(68)) OR (Data_in(6) And Control(82)) OR (Data_in(7) And Control(96)) OR (Data_in(8) And Control(110)) OR (Data_in(9) And Control(124)) OR (Data_in(10) And Control(138)) OR (Data_in(11) And Control(152)) OR (Data_in(12) And Control(166)) OR (Data_in(13) And Control(180)) OR (Data_in(14) And Control(194)));
  Data_out(13) <= ((Data_in(1) And Control(13)) OR (Data_in(2) And Control(27)) OR (Data_in(3) And Control(41)) OR (Data_in(4) And Control(55)) OR (Data_in(5) And Control(69)) OR (Data_in(6) And Control(83)) OR (Data_in(7) And Control(97)) OR (Data_in(8) And Control(111)) OR (Data_in(9) And Control(125)) OR (Data_in(10) And Control(139)) OR (Data_in(11) And Control(153)) OR (Data_in(12) And Control(167)) OR (Data_in(13) And Control(181)) OR (Data_in(14) And Control(195)));
  Data_out(14) <= ((Data_in(1) And Control(14)) OR (Data_in(2) And Control(28)) OR (Data_in(3) And Control(42)) OR (Data_in(4) And Control(56)) OR (Data_in(5) And Control(70)) OR (Data_in(6) And Control(84)) OR (Data_in(7) And Control(98)) OR (Data_in(8) And Control(112)) OR (Data_in(9) And Control(126)) OR (Data_in(10) And Control(140)) OR (Data_in(11) And Control(154)) OR (Data_in(12) And Control(168)) OR (Data_in(13) And Control(182)) OR (Data_in(14) And Control(196)));
end generate crossbit14x14;


--======================crossbit 15 ports=======================

crossbit15x15 : if number_of_ports = 15 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(16)) OR (Data_in(3) And Control(31)) OR (Data_in(4) And Control(46)) OR (Data_in(5) And Control(61)) OR (Data_in(6) And Control(76)) OR (Data_in(7) And Control(91)) OR (Data_in(8) And Control(106)) OR (Data_in(9) And Control(121)) OR (Data_in(10) And Control(136)) OR (Data_in(11) And Control(151)) OR (Data_in(12) And Control(166)) OR (Data_in(13) And Control(181)) OR (Data_in(14) And Control(196)) OR (Data_in(15) And Control(211)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(32)) OR (Data_in(4) And Control(47)) OR (Data_in(5) And Control(62)) OR (Data_in(6) And Control(77)) OR (Data_in(7) And Control(92)) OR (Data_in(8) And Control(107)) OR (Data_in(9) And Control(122)) OR (Data_in(10) And Control(137)) OR (Data_in(11) And Control(152)) OR (Data_in(12) And Control(167)) OR (Data_in(13) And Control(182)) OR (Data_in(14) And Control(197)) OR (Data_in(15) And Control(212)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(33)) OR (Data_in(4) And Control(48)) OR (Data_in(5) And Control(63)) OR (Data_in(6) And Control(78)) OR (Data_in(7) And Control(93)) OR (Data_in(8) And Control(108)) OR (Data_in(9) And Control(123)) OR (Data_in(10) And Control(138)) OR (Data_in(11) And Control(153)) OR (Data_in(12) And Control(168)) OR (Data_in(13) And Control(183)) OR (Data_in(14) And Control(198)) OR (Data_in(15) And Control(213)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(34)) OR (Data_in(4) And Control(49)) OR (Data_in(5) And Control(64)) OR (Data_in(6) And Control(79)) OR (Data_in(7) And Control(94)) OR (Data_in(8) And Control(109)) OR (Data_in(9) And Control(124)) OR (Data_in(10) And Control(139)) OR (Data_in(11) And Control(154)) OR (Data_in(12) And Control(169)) OR (Data_in(13) And Control(184)) OR (Data_in(14) And Control(199)) OR (Data_in(15) And Control(214)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(35)) OR (Data_in(4) And Control(50)) OR (Data_in(5) And Control(65)) OR (Data_in(6) And Control(80)) OR (Data_in(7) And Control(95)) OR (Data_in(8) And Control(110)) OR (Data_in(9) And Control(125)) OR (Data_in(10) And Control(140)) OR (Data_in(11) And Control(155)) OR (Data_in(12) And Control(170)) OR (Data_in(13) And Control(185)) OR (Data_in(14) And Control(200)) OR (Data_in(15) And Control(215)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(21)) OR (Data_in(3) And Control(36)) OR (Data_in(4) And Control(51)) OR (Data_in(5) And Control(66)) OR (Data_in(6) And Control(81)) OR (Data_in(7) And Control(96)) OR (Data_in(8) And Control(111)) OR (Data_in(9) And Control(126)) OR (Data_in(10) And Control(141)) OR (Data_in(11) And Control(156)) OR (Data_in(12) And Control(171)) OR (Data_in(13) And Control(186)) OR (Data_in(14) And Control(201)) OR (Data_in(15) And Control(216)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(22)) OR (Data_in(3) And Control(37)) OR (Data_in(4) And Control(52)) OR (Data_in(5) And Control(67)) OR (Data_in(6) And Control(82)) OR (Data_in(7) And Control(97)) OR (Data_in(8) And Control(112)) OR (Data_in(9) And Control(127)) OR (Data_in(10) And Control(142)) OR (Data_in(11) And Control(157)) OR (Data_in(12) And Control(172)) OR (Data_in(13) And Control(187)) OR (Data_in(14) And Control(202)) OR (Data_in(15) And Control(217)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(23)) OR (Data_in(3) And Control(38)) OR (Data_in(4) And Control(53)) OR (Data_in(5) And Control(68)) OR (Data_in(6) And Control(83)) OR (Data_in(7) And Control(98)) OR (Data_in(8) And Control(113)) OR (Data_in(9) And Control(128)) OR (Data_in(10) And Control(143)) OR (Data_in(11) And Control(158)) OR (Data_in(12) And Control(173)) OR (Data_in(13) And Control(188)) OR (Data_in(14) And Control(203)) OR (Data_in(15) And Control(218)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(24)) OR (Data_in(3) And Control(39)) OR (Data_in(4) And Control(54)) OR (Data_in(5) And Control(69)) OR (Data_in(6) And Control(84)) OR (Data_in(7) And Control(99)) OR (Data_in(8) And Control(114)) OR (Data_in(9) And Control(129)) OR (Data_in(10) And Control(144)) OR (Data_in(11) And Control(159)) OR (Data_in(12) And Control(174)) OR (Data_in(13) And Control(189)) OR (Data_in(14) And Control(204)) OR (Data_in(15) And Control(219)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(25)) OR (Data_in(3) And Control(40)) OR (Data_in(4) And Control(55)) OR (Data_in(5) And Control(70)) OR (Data_in(6) And Control(85)) OR (Data_in(7) And Control(100)) OR (Data_in(8) And Control(115)) OR (Data_in(9) And Control(130)) OR (Data_in(10) And Control(145)) OR (Data_in(11) And Control(160)) OR (Data_in(12) And Control(175)) OR (Data_in(13) And Control(190)) OR (Data_in(14) And Control(205)) OR (Data_in(15) And Control(220)));
  Data_out(11) <= ((Data_in(1) And Control(11)) OR (Data_in(2) And Control(26)) OR (Data_in(3) And Control(41)) OR (Data_in(4) And Control(56)) OR (Data_in(5) And Control(71)) OR (Data_in(6) And Control(86)) OR (Data_in(7) And Control(101)) OR (Data_in(8) And Control(116)) OR (Data_in(9) And Control(131)) OR (Data_in(10) And Control(146)) OR (Data_in(11) And Control(161)) OR (Data_in(12) And Control(176)) OR (Data_in(13) And Control(191)) OR (Data_in(14) And Control(206)) OR (Data_in(15) And Control(221)));
  Data_out(12) <= ((Data_in(1) And Control(12)) OR (Data_in(2) And Control(27)) OR (Data_in(3) And Control(42)) OR (Data_in(4) And Control(57)) OR (Data_in(5) And Control(72)) OR (Data_in(6) And Control(87)) OR (Data_in(7) And Control(102)) OR (Data_in(8) And Control(117)) OR (Data_in(9) And Control(132)) OR (Data_in(10) And Control(147)) OR (Data_in(11) And Control(162)) OR (Data_in(12) And Control(177)) OR (Data_in(13) And Control(192)) OR (Data_in(14) And Control(207)) OR (Data_in(15) And Control(222)));
  Data_out(13) <= ((Data_in(1) And Control(13)) OR (Data_in(2) And Control(28)) OR (Data_in(3) And Control(43)) OR (Data_in(4) And Control(58)) OR (Data_in(5) And Control(73)) OR (Data_in(6) And Control(88)) OR (Data_in(7) And Control(103)) OR (Data_in(8) And Control(118)) OR (Data_in(9) And Control(133)) OR (Data_in(10) And Control(148)) OR (Data_in(11) And Control(163)) OR (Data_in(12) And Control(178)) OR (Data_in(13) And Control(193)) OR (Data_in(14) And Control(208)) OR (Data_in(15) And Control(223)));
  Data_out(14) <= ((Data_in(1) And Control(14)) OR (Data_in(2) And Control(29)) OR (Data_in(3) And Control(44)) OR (Data_in(4) And Control(59)) OR (Data_in(5) And Control(74)) OR (Data_in(6) And Control(89)) OR (Data_in(7) And Control(104)) OR (Data_in(8) And Control(119)) OR (Data_in(9) And Control(134)) OR (Data_in(10) And Control(149)) OR (Data_in(11) And Control(164)) OR (Data_in(12) And Control(179)) OR (Data_in(13) And Control(194)) OR (Data_in(14) And Control(209)) OR (Data_in(15) And Control(224)));
  Data_out(15) <= ((Data_in(1) And Control(15)) OR (Data_in(2) And Control(30)) OR (Data_in(3) And Control(45)) OR (Data_in(4) And Control(60)) OR (Data_in(5) And Control(75)) OR (Data_in(6) And Control(90)) OR (Data_in(7) And Control(105)) OR (Data_in(8) And Control(120)) OR (Data_in(9) And Control(135)) OR (Data_in(10) And Control(150)) OR (Data_in(11) And Control(165)) OR (Data_in(12) And Control(180)) OR (Data_in(13) And Control(195)) OR (Data_in(14) And Control(210)) OR (Data_in(15) And Control(225)));
end generate crossbit15x15;


--======================crossbit 16 ports=======================

crossbit16x16 : if number_of_ports = 16 generate

  Data_out(1) <= ((Data_in(1) And Control(1)) OR (Data_in(2) And Control(17)) OR (Data_in(3) And Control(33)) OR (Data_in(4) And Control(49)) OR (Data_in(5) And Control(65)) OR (Data_in(6) And Control(81)) OR (Data_in(7) And Control(97)) OR (Data_in(8) And Control(113)) OR (Data_in(9) And Control(129)) OR (Data_in(10) And Control(145)) OR (Data_in(11) And Control(161)) OR (Data_in(12) And Control(177)) OR (Data_in(13) And Control(193)) OR (Data_in(14) And Control(209)) OR (Data_in(15) And Control(225)) OR (Data_in(16) And Control(241)));
  Data_out(2) <= ((Data_in(1) And Control(2)) OR (Data_in(2) And Control(18)) OR (Data_in(3) And Control(34)) OR (Data_in(4) And Control(50)) OR (Data_in(5) And Control(66)) OR (Data_in(6) And Control(82)) OR (Data_in(7) And Control(98)) OR (Data_in(8) And Control(114)) OR (Data_in(9) And Control(130)) OR (Data_in(10) And Control(146)) OR (Data_in(11) And Control(162)) OR (Data_in(12) And Control(178)) OR (Data_in(13) And Control(194)) OR (Data_in(14) And Control(210)) OR (Data_in(15) And Control(226)) OR (Data_in(16) And Control(242)));
  Data_out(3) <= ((Data_in(1) And Control(3)) OR (Data_in(2) And Control(19)) OR (Data_in(3) And Control(35)) OR (Data_in(4) And Control(51)) OR (Data_in(5) And Control(67)) OR (Data_in(6) And Control(83)) OR (Data_in(7) And Control(99)) OR (Data_in(8) And Control(115)) OR (Data_in(9) And Control(131)) OR (Data_in(10) And Control(147)) OR (Data_in(11) And Control(163)) OR (Data_in(12) And Control(179)) OR (Data_in(13) And Control(195)) OR (Data_in(14) And Control(211)) OR (Data_in(15) And Control(227)) OR (Data_in(16) And Control(243)));
  Data_out(4) <= ((Data_in(1) And Control(4)) OR (Data_in(2) And Control(20)) OR (Data_in(3) And Control(36)) OR (Data_in(4) And Control(52)) OR (Data_in(5) And Control(68)) OR (Data_in(6) And Control(84)) OR (Data_in(7) And Control(100)) OR (Data_in(8) And Control(116)) OR (Data_in(9) And Control(132)) OR (Data_in(10) And Control(148)) OR (Data_in(11) And Control(164)) OR (Data_in(12) And Control(180)) OR (Data_in(13) And Control(196)) OR (Data_in(14) And Control(212)) OR (Data_in(15) And Control(228)) OR (Data_in(16) And Control(244)));
  Data_out(5) <= ((Data_in(1) And Control(5)) OR (Data_in(2) And Control(21)) OR (Data_in(3) And Control(37)) OR (Data_in(4) And Control(53)) OR (Data_in(5) And Control(69)) OR (Data_in(6) And Control(85)) OR (Data_in(7) And Control(101)) OR (Data_in(8) And Control(117)) OR (Data_in(9) And Control(133)) OR (Data_in(10) And Control(149)) OR (Data_in(11) And Control(165)) OR (Data_in(12) And Control(181)) OR (Data_in(13) And Control(197)) OR (Data_in(14) And Control(213)) OR (Data_in(15) And Control(229)) OR (Data_in(16) And Control(245)));
  Data_out(6) <= ((Data_in(1) And Control(6)) OR (Data_in(2) And Control(22)) OR (Data_in(3) And Control(38)) OR (Data_in(4) And Control(54)) OR (Data_in(5) And Control(70)) OR (Data_in(6) And Control(86)) OR (Data_in(7) And Control(102)) OR (Data_in(8) And Control(118)) OR (Data_in(9) And Control(134)) OR (Data_in(10) And Control(150)) OR (Data_in(11) And Control(166)) OR (Data_in(12) And Control(182)) OR (Data_in(13) And Control(198)) OR (Data_in(14) And Control(214)) OR (Data_in(15) And Control(230)) OR (Data_in(16) And Control(246)));
  Data_out(7) <= ((Data_in(1) And Control(7)) OR (Data_in(2) And Control(23)) OR (Data_in(3) And Control(39)) OR (Data_in(4) And Control(55)) OR (Data_in(5) And Control(71)) OR (Data_in(6) And Control(87)) OR (Data_in(7) And Control(103)) OR (Data_in(8) And Control(119)) OR (Data_in(9) And Control(135)) OR (Data_in(10) And Control(151)) OR (Data_in(11) And Control(167)) OR (Data_in(12) And Control(183)) OR (Data_in(13) And Control(199)) OR (Data_in(14) And Control(215)) OR (Data_in(15) And Control(231)) OR (Data_in(16) And Control(247)));
  Data_out(8) <= ((Data_in(1) And Control(8)) OR (Data_in(2) And Control(24)) OR (Data_in(3) And Control(40)) OR (Data_in(4) And Control(56)) OR (Data_in(5) And Control(72)) OR (Data_in(6) And Control(88)) OR (Data_in(7) And Control(104)) OR (Data_in(8) And Control(120)) OR (Data_in(9) And Control(136)) OR (Data_in(10) And Control(152)) OR (Data_in(11) And Control(168)) OR (Data_in(12) And Control(184)) OR (Data_in(13) And Control(200)) OR (Data_in(14) And Control(216)) OR (Data_in(15) And Control(232)) OR (Data_in(16) And Control(248)));
  Data_out(9) <= ((Data_in(1) And Control(9)) OR (Data_in(2) And Control(25)) OR (Data_in(3) And Control(41)) OR (Data_in(4) And Control(57)) OR (Data_in(5) And Control(73)) OR (Data_in(6) And Control(89)) OR (Data_in(7) And Control(105)) OR (Data_in(8) And Control(121)) OR (Data_in(9) And Control(137)) OR (Data_in(10) And Control(153)) OR (Data_in(11) And Control(169)) OR (Data_in(12) And Control(185)) OR (Data_in(13) And Control(201)) OR (Data_in(14) And Control(217)) OR (Data_in(15) And Control(233)) OR (Data_in(16) And Control(249)));
  Data_out(10) <= ((Data_in(1) And Control(10)) OR (Data_in(2) And Control(26)) OR (Data_in(3) And Control(42)) OR (Data_in(4) And Control(58)) OR (Data_in(5) And Control(74)) OR (Data_in(6) And Control(90)) OR (Data_in(7) And Control(106)) OR (Data_in(8) And Control(122)) OR (Data_in(9) And Control(138)) OR (Data_in(10) And Control(154)) OR (Data_in(11) And Control(170)) OR (Data_in(12) And Control(186)) OR (Data_in(13) And Control(202)) OR (Data_in(14) And Control(218)) OR (Data_in(15) And Control(234)) OR (Data_in(16) And Control(250)));
  Data_out(11) <= ((Data_in(1) And Control(11)) OR (Data_in(2) And Control(27)) OR (Data_in(3) And Control(43)) OR (Data_in(4) And Control(59)) OR (Data_in(5) And Control(75)) OR (Data_in(6) And Control(91)) OR (Data_in(7) And Control(107)) OR (Data_in(8) And Control(123)) OR (Data_in(9) And Control(139)) OR (Data_in(10) And Control(155)) OR (Data_in(11) And Control(171)) OR (Data_in(12) And Control(187)) OR (Data_in(13) And Control(203)) OR (Data_in(14) And Control(219)) OR (Data_in(15) And Control(235)) OR (Data_in(16) And Control(251)));
  Data_out(12) <= ((Data_in(1) And Control(12)) OR (Data_in(2) And Control(28)) OR (Data_in(3) And Control(44)) OR (Data_in(4) And Control(60)) OR (Data_in(5) And Control(76)) OR (Data_in(6) And Control(92)) OR (Data_in(7) And Control(108)) OR (Data_in(8) And Control(124)) OR (Data_in(9) And Control(140)) OR (Data_in(10) And Control(156)) OR (Data_in(11) And Control(172)) OR (Data_in(12) And Control(188)) OR (Data_in(13) And Control(204)) OR (Data_in(14) And Control(220)) OR (Data_in(15) And Control(236)) OR (Data_in(16) And Control(252)));
  Data_out(13) <= ((Data_in(1) And Control(13)) OR (Data_in(2) And Control(29)) OR (Data_in(3) And Control(45)) OR (Data_in(4) And Control(61)) OR (Data_in(5) And Control(77)) OR (Data_in(6) And Control(93)) OR (Data_in(7) And Control(109)) OR (Data_in(8) And Control(125)) OR (Data_in(9) And Control(141)) OR (Data_in(10) And Control(157)) OR (Data_in(11) And Control(173)) OR (Data_in(12) And Control(189)) OR (Data_in(13) And Control(205)) OR (Data_in(14) And Control(221)) OR (Data_in(15) And Control(237)) OR (Data_in(16) And Control(253)));
  Data_out(14) <= ((Data_in(1) And Control(14)) OR (Data_in(2) And Control(30)) OR (Data_in(3) And Control(46)) OR (Data_in(4) And Control(62)) OR (Data_in(5) And Control(78)) OR (Data_in(6) And Control(94)) OR (Data_in(7) And Control(110)) OR (Data_in(8) And Control(126)) OR (Data_in(9) And Control(142)) OR (Data_in(10) And Control(158)) OR (Data_in(11) And Control(174)) OR (Data_in(12) And Control(190)) OR (Data_in(13) And Control(206)) OR (Data_in(14) And Control(222)) OR (Data_in(15) And Control(238)) OR (Data_in(16) And Control(254)));
  Data_out(15) <= ((Data_in(1) And Control(15)) OR (Data_in(2) And Control(31)) OR (Data_in(3) And Control(47)) OR (Data_in(4) And Control(63)) OR (Data_in(5) And Control(79)) OR (Data_in(6) And Control(95)) OR (Data_in(7) And Control(111)) OR (Data_in(8) And Control(127)) OR (Data_in(9) And Control(143)) OR (Data_in(10) And Control(159)) OR (Data_in(11) And Control(175)) OR (Data_in(12) And Control(191)) OR (Data_in(13) And Control(207)) OR (Data_in(14) And Control(223)) OR (Data_in(15) And Control(239)) OR (Data_in(16) And Control(255)));
  Data_out(16) <= ((Data_in(1) And Control(16)) OR (Data_in(2) And Control(32)) OR (Data_in(3) And Control(48)) OR (Data_in(4) And Control(64)) OR (Data_in(5) And Control(80)) OR (Data_in(6) And Control(96)) OR (Data_in(7) And Control(112)) OR (Data_in(8) And Control(128)) OR (Data_in(9) And Control(144)) OR (Data_in(10) And Control(160)) OR (Data_in(11) And Control(176)) OR (Data_in(12) And Control(192)) OR (Data_in(13) And Control(208)) OR (Data_in(14) And Control(224)) OR (Data_in(15) And Control(240)) OR (Data_in(16) And Control(256)));
end generate crossbit16x16;

end Behavioral;

