---------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    03:56:34 05/06/2011 
-- Design Name: 
-- Module Name:    Sheduler - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Module de l'ordonnanceur du switch crossbar
-- l'algorithme utilise est le DPA (diagonal propagation arbiter)
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use Work.Sheduler_package.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
entity Scheduler13_13 is
    Port ( Request : in  STD_LOGIC_VECTOR (169 downto 1);
		   Fifo_full : in STD_LOGIC_VECTOR (13 downto 1);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
            priority_rotation : in  STD_LOGIC_VECTOR (13 downto 1);
           port_grant : out  STD_LOGIC_VECTOR (169 downto 1));
end Scheduler13_13;

architecture Behavioral of Scheduler13_13 is
--Declaration du types
--tableau de signaux de connexion des cellules arbitres
TYPE C_Bar_Signal_Array IS ARRAY(25 downto 1) of STD_LOGIC_VECTOR(13 downto 1);
-- declaration du composant cellule d'arbitrage
Component Arbiter 
  PORT (P, Fifo_full,Request, West,North : in  STD_LOGIC;
        Grant,East,South : out  STD_LOGIC );
End Component;--Signaux de connexion des cellues
SIGNAL south_2_north :  C_Bar_Signal_Array; -- connexion south north 
SIGNAL east_2_west   :  C_Bar_Signal_Array; -- connexion east west 
SIGNAL Signal_mask      : C_Bar_Signal_Array;-- connexion des masques de priorit
SIGNAL Signal_grant     : C_Bar_Signal_Array;-- connexion des signaux de validation
SIGNAL Signal_priority  : STD_LOGIC_VECTOR (25 DOWNTO 1);--signal pour la connection des vecteur de priorit
SIGNAL High         : std_logic;--niveau pour les cellules des extremits nord et ouest 
 signal grant_latch : std_logic_vector(169 downto 1); 
 signal priority_rotation_en : std_logic; 
 signal Grant :  std_logic_vector(169 downto 1);
 begin

--validation de la rotation de priorit lorsque aucun port n'emet 
 priority_rotation_en <= '1' when unsigned(priority_rotation) = 8191 else 	'0'; 
--latch servant qui memorise le signal grant pendant a transmission 
grant_latch_process : process(clk)
 begin 
  if rising_edge(clk) then 
   if reset = '1' then 
 		grant_latch <= (others => '0'); 
 	 elsif priority_rotation_en = '1' then 
	   grant_latch <= Grant; 
   end if; 
   end if; 
 end process; 
 port_grant <= Grant and grant_latch; 
 Grant(1)  <= Signal_grant(1)(1) or Signal_grant(14)(1); --  Grant(1,1)
Grant(2)  <= Signal_grant(2)(2) or Signal_grant(15)(2); --  Grant(1,2)
Grant(3)  <= Signal_grant(3)(3) or Signal_grant(16)(3); --  Grant(1,3)
Grant(4)  <= Signal_grant(4)(4) or Signal_grant(17)(4); --  Grant(1,4)
Grant(5)  <= Signal_grant(5)(5) or Signal_grant(18)(5); --  Grant(1,5)
Grant(6)  <= Signal_grant(6)(6) or Signal_grant(19)(6); --  Grant(1,6)
Grant(7)  <= Signal_grant(7)(7) or Signal_grant(20)(7); --  Grant(1,7)
Grant(8)  <= Signal_grant(8)(8) or Signal_grant(21)(8); --  Grant(1,8)
Grant(9)  <= Signal_grant(9)(9) or Signal_grant(22)(9); --  Grant(1,9)
Grant(10)  <= Signal_grant(10)(10) or Signal_grant(23)(10); --  Grant(1,10)
Grant(11)  <= Signal_grant(11)(11) or Signal_grant(24)(11); --  Grant(1,11)
Grant(12)  <= Signal_grant(12)(12) or Signal_grant(25)(12); --  Grant(1,12)
Grant(13)  <= Signal_grant(13)(13) ;                      --  Grant(1,13)
Grant(14)  <= Signal_grant(2)(1) or Signal_grant(15)(1); --  Grant(2,1)
Grant(15)  <= Signal_grant(3)(2) or Signal_grant(16)(2); --  Grant(2,2)
Grant(16)  <= Signal_grant(4)(3) or Signal_grant(17)(3); --  Grant(2,3)
Grant(17)  <= Signal_grant(5)(4) or Signal_grant(18)(4); --  Grant(2,4)
Grant(18)  <= Signal_grant(6)(5) or Signal_grant(19)(5); --  Grant(2,5)
Grant(19)  <= Signal_grant(7)(6) or Signal_grant(20)(6); --  Grant(2,6)
Grant(20)  <= Signal_grant(8)(7) or Signal_grant(21)(7); --  Grant(2,7)
Grant(21)  <= Signal_grant(9)(8) or Signal_grant(22)(8); --  Grant(2,8)
Grant(22)  <= Signal_grant(10)(9) or Signal_grant(23)(9); --  Grant(2,9)
Grant(23)  <= Signal_grant(11)(10) or Signal_grant(24)(10); --  Grant(2,10)
Grant(24)  <= Signal_grant(12)(11) or Signal_grant(25)(11); --  Grant(2,11)
Grant(25)  <= Signal_grant(13)(12) ;                      --  Grant(2,12)
Grant(26)  <= Signal_grant(1)(13) or Signal_grant(14)(13); --  Grant(2,13)
Grant(27)  <= Signal_grant(3)(1) or Signal_grant(16)(1); --  Grant(3,1)
Grant(28)  <= Signal_grant(4)(2) or Signal_grant(17)(2); --  Grant(3,2)
Grant(29)  <= Signal_grant(5)(3) or Signal_grant(18)(3); --  Grant(3,3)
Grant(30)  <= Signal_grant(6)(4) or Signal_grant(19)(4); --  Grant(3,4)
Grant(31)  <= Signal_grant(7)(5) or Signal_grant(20)(5); --  Grant(3,5)
Grant(32)  <= Signal_grant(8)(6) or Signal_grant(21)(6); --  Grant(3,6)
Grant(33)  <= Signal_grant(9)(7) or Signal_grant(22)(7); --  Grant(3,7)
Grant(34)  <= Signal_grant(10)(8) or Signal_grant(23)(8); --  Grant(3,8)
Grant(35)  <= Signal_grant(11)(9) or Signal_grant(24)(9); --  Grant(3,9)
Grant(36)  <= Signal_grant(12)(10) or Signal_grant(25)(10); --  Grant(3,10)
Grant(37)  <= Signal_grant(13)(11) ;                      --  Grant(3,11)
Grant(38)  <= Signal_grant(1)(12) or Signal_grant(14)(12); --  Grant(3,12)
Grant(39)  <= Signal_grant(2)(13) or Signal_grant(15)(13); --  Grant(3,13)
Grant(40)  <= Signal_grant(4)(1) or Signal_grant(17)(1); --  Grant(4,1)
Grant(41)  <= Signal_grant(5)(2) or Signal_grant(18)(2); --  Grant(4,2)
Grant(42)  <= Signal_grant(6)(3) or Signal_grant(19)(3); --  Grant(4,3)
Grant(43)  <= Signal_grant(7)(4) or Signal_grant(20)(4); --  Grant(4,4)
Grant(44)  <= Signal_grant(8)(5) or Signal_grant(21)(5); --  Grant(4,5)
Grant(45)  <= Signal_grant(9)(6) or Signal_grant(22)(6); --  Grant(4,6)
Grant(46)  <= Signal_grant(10)(7) or Signal_grant(23)(7); --  Grant(4,7)
Grant(47)  <= Signal_grant(11)(8) or Signal_grant(24)(8); --  Grant(4,8)
Grant(48)  <= Signal_grant(12)(9) or Signal_grant(25)(9); --  Grant(4,9)
Grant(49)  <= Signal_grant(13)(10) ;                      --  Grant(4,10)
Grant(50)  <= Signal_grant(1)(11) or Signal_grant(14)(11); --  Grant(4,11)
Grant(51)  <= Signal_grant(2)(12) or Signal_grant(15)(12); --  Grant(4,12)
Grant(52)  <= Signal_grant(3)(13) or Signal_grant(16)(13); --  Grant(4,13)
Grant(53)  <= Signal_grant(5)(1) or Signal_grant(18)(1); --  Grant(5,1)
Grant(54)  <= Signal_grant(6)(2) or Signal_grant(19)(2); --  Grant(5,2)
Grant(55)  <= Signal_grant(7)(3) or Signal_grant(20)(3); --  Grant(5,3)
Grant(56)  <= Signal_grant(8)(4) or Signal_grant(21)(4); --  Grant(5,4)
Grant(57)  <= Signal_grant(9)(5) or Signal_grant(22)(5); --  Grant(5,5)
Grant(58)  <= Signal_grant(10)(6) or Signal_grant(23)(6); --  Grant(5,6)
Grant(59)  <= Signal_grant(11)(7) or Signal_grant(24)(7); --  Grant(5,7)
Grant(60)  <= Signal_grant(12)(8) or Signal_grant(25)(8); --  Grant(5,8)
Grant(61)  <= Signal_grant(13)(9) ;                      --  Grant(5,9)
Grant(62)  <= Signal_grant(1)(10) or Signal_grant(14)(10); --  Grant(5,10)
Grant(63)  <= Signal_grant(2)(11) or Signal_grant(15)(11); --  Grant(5,11)
Grant(64)  <= Signal_grant(3)(12) or Signal_grant(16)(12); --  Grant(5,12)
Grant(65)  <= Signal_grant(4)(13) or Signal_grant(17)(13); --  Grant(5,13)
Grant(66)  <= Signal_grant(6)(1) or Signal_grant(19)(1); --  Grant(6,1)
Grant(67)  <= Signal_grant(7)(2) or Signal_grant(20)(2); --  Grant(6,2)
Grant(68)  <= Signal_grant(8)(3) or Signal_grant(21)(3); --  Grant(6,3)
Grant(69)  <= Signal_grant(9)(4) or Signal_grant(22)(4); --  Grant(6,4)
Grant(70)  <= Signal_grant(10)(5) or Signal_grant(23)(5); --  Grant(6,5)
Grant(71)  <= Signal_grant(11)(6) or Signal_grant(24)(6); --  Grant(6,6)
Grant(72)  <= Signal_grant(12)(7) or Signal_grant(25)(7); --  Grant(6,7)
Grant(73)  <= Signal_grant(13)(8) ;                      --  Grant(6,8)
Grant(74)  <= Signal_grant(1)(9) or Signal_grant(14)(9); --  Grant(6,9)
Grant(75)  <= Signal_grant(2)(10) or Signal_grant(15)(10); --  Grant(6,10)
Grant(76)  <= Signal_grant(3)(11) or Signal_grant(16)(11); --  Grant(6,11)
Grant(77)  <= Signal_grant(4)(12) or Signal_grant(17)(12); --  Grant(6,12)
Grant(78)  <= Signal_grant(5)(13) or Signal_grant(18)(13); --  Grant(6,13)
Grant(79)  <= Signal_grant(7)(1) or Signal_grant(20)(1); --  Grant(7,1)
Grant(80)  <= Signal_grant(8)(2) or Signal_grant(21)(2); --  Grant(7,2)
Grant(81)  <= Signal_grant(9)(3) or Signal_grant(22)(3); --  Grant(7,3)
Grant(82)  <= Signal_grant(10)(4) or Signal_grant(23)(4); --  Grant(7,4)
Grant(83)  <= Signal_grant(11)(5) or Signal_grant(24)(5); --  Grant(7,5)
Grant(84)  <= Signal_grant(12)(6) or Signal_grant(25)(6); --  Grant(7,6)
Grant(85)  <= Signal_grant(13)(7) ;                      --  Grant(7,7)
Grant(86)  <= Signal_grant(1)(8) or Signal_grant(14)(8); --  Grant(7,8)
Grant(87)  <= Signal_grant(2)(9) or Signal_grant(15)(9); --  Grant(7,9)
Grant(88)  <= Signal_grant(3)(10) or Signal_grant(16)(10); --  Grant(7,10)
Grant(89)  <= Signal_grant(4)(11) or Signal_grant(17)(11); --  Grant(7,11)
Grant(90)  <= Signal_grant(5)(12) or Signal_grant(18)(12); --  Grant(7,12)
Grant(91)  <= Signal_grant(6)(13) or Signal_grant(19)(13); --  Grant(7,13)
Grant(92)  <= Signal_grant(8)(1) or Signal_grant(21)(1); --  Grant(8,1)
Grant(93)  <= Signal_grant(9)(2) or Signal_grant(22)(2); --  Grant(8,2)
Grant(94)  <= Signal_grant(10)(3) or Signal_grant(23)(3); --  Grant(8,3)
Grant(95)  <= Signal_grant(11)(4) or Signal_grant(24)(4); --  Grant(8,4)
Grant(96)  <= Signal_grant(12)(5) or Signal_grant(25)(5); --  Grant(8,5)
Grant(97)  <= Signal_grant(13)(6) ;                      --  Grant(8,6)
Grant(98)  <= Signal_grant(1)(7) or Signal_grant(14)(7); --  Grant(8,7)
Grant(99)  <= Signal_grant(2)(8) or Signal_grant(15)(8); --  Grant(8,8)
Grant(100)  <= Signal_grant(3)(9) or Signal_grant(16)(9); --  Grant(8,9)
Grant(101)  <= Signal_grant(4)(10) or Signal_grant(17)(10); --  Grant(8,10)
Grant(102)  <= Signal_grant(5)(11) or Signal_grant(18)(11); --  Grant(8,11)
Grant(103)  <= Signal_grant(6)(12) or Signal_grant(19)(12); --  Grant(8,12)
Grant(104)  <= Signal_grant(7)(13) or Signal_grant(20)(13); --  Grant(8,13)
Grant(105)  <= Signal_grant(9)(1) or Signal_grant(22)(1); --  Grant(9,1)
Grant(106)  <= Signal_grant(10)(2) or Signal_grant(23)(2); --  Grant(9,2)
Grant(107)  <= Signal_grant(11)(3) or Signal_grant(24)(3); --  Grant(9,3)
Grant(108)  <= Signal_grant(12)(4) or Signal_grant(25)(4); --  Grant(9,4)
Grant(109)  <= Signal_grant(13)(5) ;                      --  Grant(9,5)
Grant(110)  <= Signal_grant(1)(6) or Signal_grant(14)(6); --  Grant(9,6)
Grant(111)  <= Signal_grant(2)(7) or Signal_grant(15)(7); --  Grant(9,7)
Grant(112)  <= Signal_grant(3)(8) or Signal_grant(16)(8); --  Grant(9,8)
Grant(113)  <= Signal_grant(4)(9) or Signal_grant(17)(9); --  Grant(9,9)
Grant(114)  <= Signal_grant(5)(10) or Signal_grant(18)(10); --  Grant(9,10)
Grant(115)  <= Signal_grant(6)(11) or Signal_grant(19)(11); --  Grant(9,11)
Grant(116)  <= Signal_grant(7)(12) or Signal_grant(20)(12); --  Grant(9,12)
Grant(117)  <= Signal_grant(8)(13) or Signal_grant(21)(13); --  Grant(9,13)
Grant(118)  <= Signal_grant(10)(1) or Signal_grant(23)(1); --  Grant(10,1)
Grant(119)  <= Signal_grant(11)(2) or Signal_grant(24)(2); --  Grant(10,2)
Grant(120)  <= Signal_grant(12)(3) or Signal_grant(25)(3); --  Grant(10,3)
Grant(121)  <= Signal_grant(13)(4) ;                      --  Grant(10,4)
Grant(122)  <= Signal_grant(1)(5) or Signal_grant(14)(5); --  Grant(10,5)
Grant(123)  <= Signal_grant(2)(6) or Signal_grant(15)(6); --  Grant(10,6)
Grant(124)  <= Signal_grant(3)(7) or Signal_grant(16)(7); --  Grant(10,7)
Grant(125)  <= Signal_grant(4)(8) or Signal_grant(17)(8); --  Grant(10,8)
Grant(126)  <= Signal_grant(5)(9) or Signal_grant(18)(9); --  Grant(10,9)
Grant(127)  <= Signal_grant(6)(10) or Signal_grant(19)(10); --  Grant(10,10)
Grant(128)  <= Signal_grant(7)(11) or Signal_grant(20)(11); --  Grant(10,11)
Grant(129)  <= Signal_grant(8)(12) or Signal_grant(21)(12); --  Grant(10,12)
Grant(130)  <= Signal_grant(9)(13) or Signal_grant(22)(13); --  Grant(10,13)
Grant(131)  <= Signal_grant(11)(1) or Signal_grant(24)(1); --  Grant(11,1)
Grant(132)  <= Signal_grant(12)(2) or Signal_grant(25)(2); --  Grant(11,2)
Grant(133)  <= Signal_grant(13)(3) ;                      --  Grant(11,3)
Grant(134)  <= Signal_grant(1)(4) or Signal_grant(14)(4); --  Grant(11,4)
Grant(135)  <= Signal_grant(2)(5) or Signal_grant(15)(5); --  Grant(11,5)
Grant(136)  <= Signal_grant(3)(6) or Signal_grant(16)(6); --  Grant(11,6)
Grant(137)  <= Signal_grant(4)(7) or Signal_grant(17)(7); --  Grant(11,7)
Grant(138)  <= Signal_grant(5)(8) or Signal_grant(18)(8); --  Grant(11,8)
Grant(139)  <= Signal_grant(6)(9) or Signal_grant(19)(9); --  Grant(11,9)
Grant(140)  <= Signal_grant(7)(10) or Signal_grant(20)(10); --  Grant(11,10)
Grant(141)  <= Signal_grant(8)(11) or Signal_grant(21)(11); --  Grant(11,11)
Grant(142)  <= Signal_grant(9)(12) or Signal_grant(22)(12); --  Grant(11,12)
Grant(143)  <= Signal_grant(10)(13) or Signal_grant(23)(13); --  Grant(11,13)
Grant(144)  <= Signal_grant(12)(1) or Signal_grant(25)(1); --  Grant(12,1)
Grant(145)  <= Signal_grant(13)(2) ;                      --  Grant(12,2)
Grant(146)  <= Signal_grant(1)(3) or Signal_grant(14)(3); --  Grant(12,3)
Grant(147)  <= Signal_grant(2)(4) or Signal_grant(15)(4); --  Grant(12,4)
Grant(148)  <= Signal_grant(3)(5) or Signal_grant(16)(5); --  Grant(12,5)
Grant(149)  <= Signal_grant(4)(6) or Signal_grant(17)(6); --  Grant(12,6)
Grant(150)  <= Signal_grant(5)(7) or Signal_grant(18)(7); --  Grant(12,7)
Grant(151)  <= Signal_grant(6)(8) or Signal_grant(19)(8); --  Grant(12,8)
Grant(152)  <= Signal_grant(7)(9) or Signal_grant(20)(9); --  Grant(12,9)
Grant(153)  <= Signal_grant(8)(10) or Signal_grant(21)(10); --  Grant(12,10)
Grant(154)  <= Signal_grant(9)(11) or Signal_grant(22)(11); --  Grant(12,11)
Grant(155)  <= Signal_grant(10)(12) or Signal_grant(23)(12); --  Grant(12,12)
Grant(156)  <= Signal_grant(11)(13) or Signal_grant(24)(13); --  Grant(12,13)
Grant(157)  <= Signal_grant(13)(1) ;                      --  Grant(13,1)
Grant(158)  <= Signal_grant(1)(2) or Signal_grant(14)(2); --  Grant(13,2)
Grant(159)  <= Signal_grant(2)(3) or Signal_grant(15)(3); --  Grant(13,3)
Grant(160)  <= Signal_grant(3)(4) or Signal_grant(16)(4); --  Grant(13,4)
Grant(161)  <= Signal_grant(4)(5) or Signal_grant(17)(5); --  Grant(13,5)
Grant(162)  <= Signal_grant(5)(6) or Signal_grant(18)(6); --  Grant(13,6)
Grant(163)  <= Signal_grant(6)(7) or Signal_grant(19)(7); --  Grant(13,7)
Grant(164)  <= Signal_grant(7)(8) or Signal_grant(20)(8); --  Grant(13,8)
Grant(165)  <= Signal_grant(8)(9) or Signal_grant(21)(9); --  Grant(13,9)
Grant(166)  <= Signal_grant(9)(10) or Signal_grant(22)(10); --  Grant(13,10)
Grant(167)  <= Signal_grant(10)(11) or Signal_grant(23)(11); --  Grant(13,11)
Grant(168)  <= Signal_grant(11)(12) or Signal_grant(24)(12); --  Grant(13,12)
Grant(169)  <= Signal_grant(12)(13) or Signal_grant(25)(13); --  Grant(13,13)
High <= '1';

----instantiations des cellules arbitres et interconnection

-------------------------- Diagonale n 1 


Arbiter_1_1 : Arbiter

PORT MAP (Request => Request(1), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(1),  
South => south_2_north(1)(1), East => east_2_west(1)(1) , Grant => Signal_grant(1)(1)); 

Arbiter_1_2 : Arbiter

PORT MAP (Request => Request(158), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(2),  
South => south_2_north(1)(2), East => east_2_west(1)(2) , Grant => Signal_grant(1)(2)); 

Arbiter_1_3 : Arbiter

PORT MAP (Request => Request(146), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(3),  
South => south_2_north(1)(3), East => east_2_west(1)(3) , Grant => Signal_grant(1)(3)); 

Arbiter_1_4 : Arbiter

PORT MAP (Request => Request(134), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(4),  
South => south_2_north(1)(4), East => east_2_west(1)(4) , Grant => Signal_grant(1)(4)); 

Arbiter_1_5 : Arbiter

PORT MAP (Request => Request(122), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(5),  
South => south_2_north(1)(5), East => east_2_west(1)(5) , Grant => Signal_grant(1)(5)); 

Arbiter_1_6 : Arbiter

PORT MAP (Request => Request(110), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(6),  
South => south_2_north(1)(6), East => east_2_west(1)(6) , Grant => Signal_grant(1)(6)); 

Arbiter_1_7 : Arbiter

PORT MAP (Request => Request(98), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(7),  
South => south_2_north(1)(7), East => east_2_west(1)(7) , Grant => Signal_grant(1)(7)); 

Arbiter_1_8 : Arbiter

PORT MAP (Request => Request(86), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(8),  
South => south_2_north(1)(8), East => east_2_west(1)(8) , Grant => Signal_grant(1)(8)); 

Arbiter_1_9 : Arbiter

PORT MAP (Request => Request(74), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(9),  
South => south_2_north(1)(9), East => east_2_west(1)(9) , Grant => Signal_grant(1)(9)); 

Arbiter_1_10 : Arbiter

PORT MAP (Request => Request(62), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(10),  
South => south_2_north(1)(10), East => east_2_west(1)(10) , Grant => Signal_grant(1)(10)); 

Arbiter_1_11 : Arbiter

PORT MAP (Request => Request(50), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(11),  
South => south_2_north(1)(11), East => east_2_west(1)(11) , Grant => Signal_grant(1)(11)); 

Arbiter_1_12 : Arbiter

PORT MAP (Request => Request(38), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(12),  
South => south_2_north(1)(12), East => east_2_west(1)(12) , Grant => Signal_grant(1)(12)); 

Arbiter_1_13 : Arbiter

PORT MAP (Request => Request(26), North => High, West => High, P => Signal_priority(25), Fifo_full => Fifo_full(13),  
South => south_2_north(1)(13), East => east_2_west(1)(13) , Grant => Signal_grant(1)(13)); 

-------------------------- Diagonale n 2 


Arbiter_2_1 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(1)(1), West => east_2_west(1)(13), P => Signal_priority(24), Fifo_full => Fifo_full(1),  
South => south_2_north(2)(1), East => east_2_west(2)(1) , Grant => Signal_grant(2)(1)); 

Arbiter_2_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(1)(2), West => east_2_west(1)(1), P => Signal_priority(24), Fifo_full => Fifo_full(2),  
South => south_2_north(2)(2), East => east_2_west(2)(2) , Grant => Signal_grant(2)(2)); 

Arbiter_2_3 : Arbiter

PORT MAP (Request => Request(159), North => south_2_north(1)(3), West => east_2_west(1)(2), P => Signal_priority(24), Fifo_full => Fifo_full(3),  
South => south_2_north(2)(3), East => east_2_west(2)(3) , Grant => Signal_grant(2)(3)); 

Arbiter_2_4 : Arbiter

PORT MAP (Request => Request(147), North => south_2_north(1)(4), West => east_2_west(1)(3), P => Signal_priority(24), Fifo_full => Fifo_full(4),  
South => south_2_north(2)(4), East => east_2_west(2)(4) , Grant => Signal_grant(2)(4)); 

Arbiter_2_5 : Arbiter

PORT MAP (Request => Request(135), North => south_2_north(1)(5), West => east_2_west(1)(4), P => Signal_priority(24), Fifo_full => Fifo_full(5),  
South => south_2_north(2)(5), East => east_2_west(2)(5) , Grant => Signal_grant(2)(5)); 

Arbiter_2_6 : Arbiter

PORT MAP (Request => Request(123), North => south_2_north(1)(6), West => east_2_west(1)(5), P => Signal_priority(24), Fifo_full => Fifo_full(6),  
South => south_2_north(2)(6), East => east_2_west(2)(6) , Grant => Signal_grant(2)(6)); 

Arbiter_2_7 : Arbiter

PORT MAP (Request => Request(111), North => south_2_north(1)(7), West => east_2_west(1)(6), P => Signal_priority(24), Fifo_full => Fifo_full(7),  
South => south_2_north(2)(7), East => east_2_west(2)(7) , Grant => Signal_grant(2)(7)); 

Arbiter_2_8 : Arbiter

PORT MAP (Request => Request(99), North => south_2_north(1)(8), West => east_2_west(1)(7), P => Signal_priority(24), Fifo_full => Fifo_full(8),  
South => south_2_north(2)(8), East => east_2_west(2)(8) , Grant => Signal_grant(2)(8)); 

Arbiter_2_9 : Arbiter

PORT MAP (Request => Request(87), North => south_2_north(1)(9), West => east_2_west(1)(8), P => Signal_priority(24), Fifo_full => Fifo_full(9),  
South => south_2_north(2)(9), East => east_2_west(2)(9) , Grant => Signal_grant(2)(9)); 

Arbiter_2_10 : Arbiter

PORT MAP (Request => Request(75), North => south_2_north(1)(10), West => east_2_west(1)(9), P => Signal_priority(24), Fifo_full => Fifo_full(10),  
South => south_2_north(2)(10), East => east_2_west(2)(10) , Grant => Signal_grant(2)(10)); 

Arbiter_2_11 : Arbiter

PORT MAP (Request => Request(63), North => south_2_north(1)(11), West => east_2_west(1)(10), P => Signal_priority(24), Fifo_full => Fifo_full(11),  
South => south_2_north(2)(11), East => east_2_west(2)(11) , Grant => Signal_grant(2)(11)); 

Arbiter_2_12 : Arbiter

PORT MAP (Request => Request(51), North => south_2_north(1)(12), West => east_2_west(1)(11), P => Signal_priority(24), Fifo_full => Fifo_full(12),  
South => south_2_north(2)(12), East => east_2_west(2)(12) , Grant => Signal_grant(2)(12)); 

Arbiter_2_13 : Arbiter

PORT MAP (Request => Request(39), North => south_2_north(1)(13), West => east_2_west(1)(12), P => Signal_priority(24), Fifo_full => Fifo_full(13),  
South => south_2_north(2)(13), East => east_2_west(2)(13) , Grant => Signal_grant(2)(13)); 

-------------------------- Diagonale n 3 


Arbiter_3_1 : Arbiter

PORT MAP (Request => Request(27), North => south_2_north(2)(1), West => east_2_west(2)(13), P => Signal_priority(23), Fifo_full => Fifo_full(1),  
South => south_2_north(3)(1), East => east_2_west(3)(1) , Grant => Signal_grant(3)(1)); 

Arbiter_3_2 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(2)(2), West => east_2_west(2)(1), P => Signal_priority(23), Fifo_full => Fifo_full(2),  
South => south_2_north(3)(2), East => east_2_west(3)(2) , Grant => Signal_grant(3)(2)); 

Arbiter_3_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(2)(3), West => east_2_west(2)(2), P => Signal_priority(23), Fifo_full => Fifo_full(3),  
South => south_2_north(3)(3), East => east_2_west(3)(3) , Grant => Signal_grant(3)(3)); 

Arbiter_3_4 : Arbiter

PORT MAP (Request => Request(160), North => south_2_north(2)(4), West => east_2_west(2)(3), P => Signal_priority(23), Fifo_full => Fifo_full(4),  
South => south_2_north(3)(4), East => east_2_west(3)(4) , Grant => Signal_grant(3)(4)); 

Arbiter_3_5 : Arbiter

PORT MAP (Request => Request(148), North => south_2_north(2)(5), West => east_2_west(2)(4), P => Signal_priority(23), Fifo_full => Fifo_full(5),  
South => south_2_north(3)(5), East => east_2_west(3)(5) , Grant => Signal_grant(3)(5)); 

Arbiter_3_6 : Arbiter

PORT MAP (Request => Request(136), North => south_2_north(2)(6), West => east_2_west(2)(5), P => Signal_priority(23), Fifo_full => Fifo_full(6),  
South => south_2_north(3)(6), East => east_2_west(3)(6) , Grant => Signal_grant(3)(6)); 

Arbiter_3_7 : Arbiter

PORT MAP (Request => Request(124), North => south_2_north(2)(7), West => east_2_west(2)(6), P => Signal_priority(23), Fifo_full => Fifo_full(7),  
South => south_2_north(3)(7), East => east_2_west(3)(7) , Grant => Signal_grant(3)(7)); 

Arbiter_3_8 : Arbiter

PORT MAP (Request => Request(112), North => south_2_north(2)(8), West => east_2_west(2)(7), P => Signal_priority(23), Fifo_full => Fifo_full(8),  
South => south_2_north(3)(8), East => east_2_west(3)(8) , Grant => Signal_grant(3)(8)); 

Arbiter_3_9 : Arbiter

PORT MAP (Request => Request(100), North => south_2_north(2)(9), West => east_2_west(2)(8), P => Signal_priority(23), Fifo_full => Fifo_full(9),  
South => south_2_north(3)(9), East => east_2_west(3)(9) , Grant => Signal_grant(3)(9)); 

Arbiter_3_10 : Arbiter

PORT MAP (Request => Request(88), North => south_2_north(2)(10), West => east_2_west(2)(9), P => Signal_priority(23), Fifo_full => Fifo_full(10),  
South => south_2_north(3)(10), East => east_2_west(3)(10) , Grant => Signal_grant(3)(10)); 

Arbiter_3_11 : Arbiter

PORT MAP (Request => Request(76), North => south_2_north(2)(11), West => east_2_west(2)(10), P => Signal_priority(23), Fifo_full => Fifo_full(11),  
South => south_2_north(3)(11), East => east_2_west(3)(11) , Grant => Signal_grant(3)(11)); 

Arbiter_3_12 : Arbiter

PORT MAP (Request => Request(64), North => south_2_north(2)(12), West => east_2_west(2)(11), P => Signal_priority(23), Fifo_full => Fifo_full(12),  
South => south_2_north(3)(12), East => east_2_west(3)(12) , Grant => Signal_grant(3)(12)); 

Arbiter_3_13 : Arbiter

PORT MAP (Request => Request(52), North => south_2_north(2)(13), West => east_2_west(2)(12), P => Signal_priority(23), Fifo_full => Fifo_full(13),  
South => south_2_north(3)(13), East => east_2_west(3)(13) , Grant => Signal_grant(3)(13)); 

-------------------------- Diagonale n 4 


Arbiter_4_1 : Arbiter

PORT MAP (Request => Request(40), North => south_2_north(3)(1), West => east_2_west(3)(13), P => Signal_priority(22), Fifo_full => Fifo_full(1),  
South => south_2_north(4)(1), East => east_2_west(4)(1) , Grant => Signal_grant(4)(1)); 

Arbiter_4_2 : Arbiter

PORT MAP (Request => Request(28), North => south_2_north(3)(2), West => east_2_west(3)(1), P => Signal_priority(22), Fifo_full => Fifo_full(2),  
South => south_2_north(4)(2), East => east_2_west(4)(2) , Grant => Signal_grant(4)(2)); 

Arbiter_4_3 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(3)(3), West => east_2_west(3)(2), P => Signal_priority(22), Fifo_full => Fifo_full(3),  
South => south_2_north(4)(3), East => east_2_west(4)(3) , Grant => Signal_grant(4)(3)); 

Arbiter_4_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(3)(4), West => east_2_west(3)(3), P => Signal_priority(22), Fifo_full => Fifo_full(4),  
South => south_2_north(4)(4), East => east_2_west(4)(4) , Grant => Signal_grant(4)(4)); 

Arbiter_4_5 : Arbiter

PORT MAP (Request => Request(161), North => south_2_north(3)(5), West => east_2_west(3)(4), P => Signal_priority(22), Fifo_full => Fifo_full(5),  
South => south_2_north(4)(5), East => east_2_west(4)(5) , Grant => Signal_grant(4)(5)); 

Arbiter_4_6 : Arbiter

PORT MAP (Request => Request(149), North => south_2_north(3)(6), West => east_2_west(3)(5), P => Signal_priority(22), Fifo_full => Fifo_full(6),  
South => south_2_north(4)(6), East => east_2_west(4)(6) , Grant => Signal_grant(4)(6)); 

Arbiter_4_7 : Arbiter

PORT MAP (Request => Request(137), North => south_2_north(3)(7), West => east_2_west(3)(6), P => Signal_priority(22), Fifo_full => Fifo_full(7),  
South => south_2_north(4)(7), East => east_2_west(4)(7) , Grant => Signal_grant(4)(7)); 

Arbiter_4_8 : Arbiter

PORT MAP (Request => Request(125), North => south_2_north(3)(8), West => east_2_west(3)(7), P => Signal_priority(22), Fifo_full => Fifo_full(8),  
South => south_2_north(4)(8), East => east_2_west(4)(8) , Grant => Signal_grant(4)(8)); 

Arbiter_4_9 : Arbiter

PORT MAP (Request => Request(113), North => south_2_north(3)(9), West => east_2_west(3)(8), P => Signal_priority(22), Fifo_full => Fifo_full(9),  
South => south_2_north(4)(9), East => east_2_west(4)(9) , Grant => Signal_grant(4)(9)); 

Arbiter_4_10 : Arbiter

PORT MAP (Request => Request(101), North => south_2_north(3)(10), West => east_2_west(3)(9), P => Signal_priority(22), Fifo_full => Fifo_full(10),  
South => south_2_north(4)(10), East => east_2_west(4)(10) , Grant => Signal_grant(4)(10)); 

Arbiter_4_11 : Arbiter

PORT MAP (Request => Request(89), North => south_2_north(3)(11), West => east_2_west(3)(10), P => Signal_priority(22), Fifo_full => Fifo_full(11),  
South => south_2_north(4)(11), East => east_2_west(4)(11) , Grant => Signal_grant(4)(11)); 

Arbiter_4_12 : Arbiter

PORT MAP (Request => Request(77), North => south_2_north(3)(12), West => east_2_west(3)(11), P => Signal_priority(22), Fifo_full => Fifo_full(12),  
South => south_2_north(4)(12), East => east_2_west(4)(12) , Grant => Signal_grant(4)(12)); 

Arbiter_4_13 : Arbiter

PORT MAP (Request => Request(65), North => south_2_north(3)(13), West => east_2_west(3)(12), P => Signal_priority(22), Fifo_full => Fifo_full(13),  
South => south_2_north(4)(13), East => east_2_west(4)(13) , Grant => Signal_grant(4)(13)); 

-------------------------- Diagonale n 5 


Arbiter_5_1 : Arbiter

PORT MAP (Request => Request(53), North => south_2_north(4)(1), West => east_2_west(4)(13), P => Signal_priority(21), Fifo_full => Fifo_full(1),  
South => south_2_north(5)(1), East => east_2_west(5)(1) , Grant => Signal_grant(5)(1)); 

Arbiter_5_2 : Arbiter

PORT MAP (Request => Request(41), North => south_2_north(4)(2), West => east_2_west(4)(1), P => Signal_priority(21), Fifo_full => Fifo_full(2),  
South => south_2_north(5)(2), East => east_2_west(5)(2) , Grant => Signal_grant(5)(2)); 

Arbiter_5_3 : Arbiter

PORT MAP (Request => Request(29), North => south_2_north(4)(3), West => east_2_west(4)(2), P => Signal_priority(21), Fifo_full => Fifo_full(3),  
South => south_2_north(5)(3), East => east_2_west(5)(3) , Grant => Signal_grant(5)(3)); 

Arbiter_5_4 : Arbiter

PORT MAP (Request => Request(17), North => south_2_north(4)(4), West => east_2_west(4)(3), P => Signal_priority(21), Fifo_full => Fifo_full(4),  
South => south_2_north(5)(4), East => east_2_west(5)(4) , Grant => Signal_grant(5)(4)); 

Arbiter_5_5 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(4)(5), West => east_2_west(4)(4), P => Signal_priority(21), Fifo_full => Fifo_full(5),  
South => south_2_north(5)(5), East => east_2_west(5)(5) , Grant => Signal_grant(5)(5)); 

Arbiter_5_6 : Arbiter

PORT MAP (Request => Request(162), North => south_2_north(4)(6), West => east_2_west(4)(5), P => Signal_priority(21), Fifo_full => Fifo_full(6),  
South => south_2_north(5)(6), East => east_2_west(5)(6) , Grant => Signal_grant(5)(6)); 

Arbiter_5_7 : Arbiter

PORT MAP (Request => Request(150), North => south_2_north(4)(7), West => east_2_west(4)(6), P => Signal_priority(21), Fifo_full => Fifo_full(7),  
South => south_2_north(5)(7), East => east_2_west(5)(7) , Grant => Signal_grant(5)(7)); 

Arbiter_5_8 : Arbiter

PORT MAP (Request => Request(138), North => south_2_north(4)(8), West => east_2_west(4)(7), P => Signal_priority(21), Fifo_full => Fifo_full(8),  
South => south_2_north(5)(8), East => east_2_west(5)(8) , Grant => Signal_grant(5)(8)); 

Arbiter_5_9 : Arbiter

PORT MAP (Request => Request(126), North => south_2_north(4)(9), West => east_2_west(4)(8), P => Signal_priority(21), Fifo_full => Fifo_full(9),  
South => south_2_north(5)(9), East => east_2_west(5)(9) , Grant => Signal_grant(5)(9)); 

Arbiter_5_10 : Arbiter

PORT MAP (Request => Request(114), North => south_2_north(4)(10), West => east_2_west(4)(9), P => Signal_priority(21), Fifo_full => Fifo_full(10),  
South => south_2_north(5)(10), East => east_2_west(5)(10) , Grant => Signal_grant(5)(10)); 

Arbiter_5_11 : Arbiter

PORT MAP (Request => Request(102), North => south_2_north(4)(11), West => east_2_west(4)(10), P => Signal_priority(21), Fifo_full => Fifo_full(11),  
South => south_2_north(5)(11), East => east_2_west(5)(11) , Grant => Signal_grant(5)(11)); 

Arbiter_5_12 : Arbiter

PORT MAP (Request => Request(90), North => south_2_north(4)(12), West => east_2_west(4)(11), P => Signal_priority(21), Fifo_full => Fifo_full(12),  
South => south_2_north(5)(12), East => east_2_west(5)(12) , Grant => Signal_grant(5)(12)); 

Arbiter_5_13 : Arbiter

PORT MAP (Request => Request(78), North => south_2_north(4)(13), West => east_2_west(4)(12), P => Signal_priority(21), Fifo_full => Fifo_full(13),  
South => south_2_north(5)(13), East => east_2_west(5)(13) , Grant => Signal_grant(5)(13)); 

-------------------------- Diagonale n 6 


Arbiter_6_1 : Arbiter

PORT MAP (Request => Request(66), North => south_2_north(5)(1), West => east_2_west(5)(13), P => Signal_priority(20), Fifo_full => Fifo_full(1),  
South => south_2_north(6)(1), East => east_2_west(6)(1) , Grant => Signal_grant(6)(1)); 

Arbiter_6_2 : Arbiter

PORT MAP (Request => Request(54), North => south_2_north(5)(2), West => east_2_west(5)(1), P => Signal_priority(20), Fifo_full => Fifo_full(2),  
South => south_2_north(6)(2), East => east_2_west(6)(2) , Grant => Signal_grant(6)(2)); 

Arbiter_6_3 : Arbiter

PORT MAP (Request => Request(42), North => south_2_north(5)(3), West => east_2_west(5)(2), P => Signal_priority(20), Fifo_full => Fifo_full(3),  
South => south_2_north(6)(3), East => east_2_west(6)(3) , Grant => Signal_grant(6)(3)); 

Arbiter_6_4 : Arbiter

PORT MAP (Request => Request(30), North => south_2_north(5)(4), West => east_2_west(5)(3), P => Signal_priority(20), Fifo_full => Fifo_full(4),  
South => south_2_north(6)(4), East => east_2_west(6)(4) , Grant => Signal_grant(6)(4)); 

Arbiter_6_5 : Arbiter

PORT MAP (Request => Request(18), North => south_2_north(5)(5), West => east_2_west(5)(4), P => Signal_priority(20), Fifo_full => Fifo_full(5),  
South => south_2_north(6)(5), East => east_2_west(6)(5) , Grant => Signal_grant(6)(5)); 

Arbiter_6_6 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(5)(6), West => east_2_west(5)(5), P => Signal_priority(20), Fifo_full => Fifo_full(6),  
South => south_2_north(6)(6), East => east_2_west(6)(6) , Grant => Signal_grant(6)(6)); 

Arbiter_6_7 : Arbiter

PORT MAP (Request => Request(163), North => south_2_north(5)(7), West => east_2_west(5)(6), P => Signal_priority(20), Fifo_full => Fifo_full(7),  
South => south_2_north(6)(7), East => east_2_west(6)(7) , Grant => Signal_grant(6)(7)); 

Arbiter_6_8 : Arbiter

PORT MAP (Request => Request(151), North => south_2_north(5)(8), West => east_2_west(5)(7), P => Signal_priority(20), Fifo_full => Fifo_full(8),  
South => south_2_north(6)(8), East => east_2_west(6)(8) , Grant => Signal_grant(6)(8)); 

Arbiter_6_9 : Arbiter

PORT MAP (Request => Request(139), North => south_2_north(5)(9), West => east_2_west(5)(8), P => Signal_priority(20), Fifo_full => Fifo_full(9),  
South => south_2_north(6)(9), East => east_2_west(6)(9) , Grant => Signal_grant(6)(9)); 

Arbiter_6_10 : Arbiter

PORT MAP (Request => Request(127), North => south_2_north(5)(10), West => east_2_west(5)(9), P => Signal_priority(20), Fifo_full => Fifo_full(10),  
South => south_2_north(6)(10), East => east_2_west(6)(10) , Grant => Signal_grant(6)(10)); 

Arbiter_6_11 : Arbiter

PORT MAP (Request => Request(115), North => south_2_north(5)(11), West => east_2_west(5)(10), P => Signal_priority(20), Fifo_full => Fifo_full(11),  
South => south_2_north(6)(11), East => east_2_west(6)(11) , Grant => Signal_grant(6)(11)); 

Arbiter_6_12 : Arbiter

PORT MAP (Request => Request(103), North => south_2_north(5)(12), West => east_2_west(5)(11), P => Signal_priority(20), Fifo_full => Fifo_full(12),  
South => south_2_north(6)(12), East => east_2_west(6)(12) , Grant => Signal_grant(6)(12)); 

Arbiter_6_13 : Arbiter

PORT MAP (Request => Request(91), North => south_2_north(5)(13), West => east_2_west(5)(12), P => Signal_priority(20), Fifo_full => Fifo_full(13),  
South => south_2_north(6)(13), East => east_2_west(6)(13) , Grant => Signal_grant(6)(13)); 

-------------------------- Diagonale n 7 


Arbiter_7_1 : Arbiter

PORT MAP (Request => Request(79), North => south_2_north(6)(1), West => east_2_west(6)(13), P => Signal_priority(19), Fifo_full => Fifo_full(1),  
South => south_2_north(7)(1), East => east_2_west(7)(1) , Grant => Signal_grant(7)(1)); 

Arbiter_7_2 : Arbiter

PORT MAP (Request => Request(67), North => south_2_north(6)(2), West => east_2_west(6)(1), P => Signal_priority(19), Fifo_full => Fifo_full(2),  
South => south_2_north(7)(2), East => east_2_west(7)(2) , Grant => Signal_grant(7)(2)); 

Arbiter_7_3 : Arbiter

PORT MAP (Request => Request(55), North => south_2_north(6)(3), West => east_2_west(6)(2), P => Signal_priority(19), Fifo_full => Fifo_full(3),  
South => south_2_north(7)(3), East => east_2_west(7)(3) , Grant => Signal_grant(7)(3)); 

Arbiter_7_4 : Arbiter

PORT MAP (Request => Request(43), North => south_2_north(6)(4), West => east_2_west(6)(3), P => Signal_priority(19), Fifo_full => Fifo_full(4),  
South => south_2_north(7)(4), East => east_2_west(7)(4) , Grant => Signal_grant(7)(4)); 

Arbiter_7_5 : Arbiter

PORT MAP (Request => Request(31), North => south_2_north(6)(5), West => east_2_west(6)(4), P => Signal_priority(19), Fifo_full => Fifo_full(5),  
South => south_2_north(7)(5), East => east_2_west(7)(5) , Grant => Signal_grant(7)(5)); 

Arbiter_7_6 : Arbiter

PORT MAP (Request => Request(19), North => south_2_north(6)(6), West => east_2_west(6)(5), P => Signal_priority(19), Fifo_full => Fifo_full(6),  
South => south_2_north(7)(6), East => east_2_west(7)(6) , Grant => Signal_grant(7)(6)); 

Arbiter_7_7 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(6)(7), West => east_2_west(6)(6), P => Signal_priority(19), Fifo_full => Fifo_full(7),  
South => south_2_north(7)(7), East => east_2_west(7)(7) , Grant => Signal_grant(7)(7)); 

Arbiter_7_8 : Arbiter

PORT MAP (Request => Request(164), North => south_2_north(6)(8), West => east_2_west(6)(7), P => Signal_priority(19), Fifo_full => Fifo_full(8),  
South => south_2_north(7)(8), East => east_2_west(7)(8) , Grant => Signal_grant(7)(8)); 

Arbiter_7_9 : Arbiter

PORT MAP (Request => Request(152), North => south_2_north(6)(9), West => east_2_west(6)(8), P => Signal_priority(19), Fifo_full => Fifo_full(9),  
South => south_2_north(7)(9), East => east_2_west(7)(9) , Grant => Signal_grant(7)(9)); 

Arbiter_7_10 : Arbiter

PORT MAP (Request => Request(140), North => south_2_north(6)(10), West => east_2_west(6)(9), P => Signal_priority(19), Fifo_full => Fifo_full(10),  
South => south_2_north(7)(10), East => east_2_west(7)(10) , Grant => Signal_grant(7)(10)); 

Arbiter_7_11 : Arbiter

PORT MAP (Request => Request(128), North => south_2_north(6)(11), West => east_2_west(6)(10), P => Signal_priority(19), Fifo_full => Fifo_full(11),  
South => south_2_north(7)(11), East => east_2_west(7)(11) , Grant => Signal_grant(7)(11)); 

Arbiter_7_12 : Arbiter

PORT MAP (Request => Request(116), North => south_2_north(6)(12), West => east_2_west(6)(11), P => Signal_priority(19), Fifo_full => Fifo_full(12),  
South => south_2_north(7)(12), East => east_2_west(7)(12) , Grant => Signal_grant(7)(12)); 

Arbiter_7_13 : Arbiter

PORT MAP (Request => Request(104), North => south_2_north(6)(13), West => east_2_west(6)(12), P => Signal_priority(19), Fifo_full => Fifo_full(13),  
South => south_2_north(7)(13), East => east_2_west(7)(13) , Grant => Signal_grant(7)(13)); 

-------------------------- Diagonale n 8 


Arbiter_8_1 : Arbiter

PORT MAP (Request => Request(92), North => south_2_north(7)(1), West => east_2_west(7)(13), P => Signal_priority(18), Fifo_full => Fifo_full(1),  
South => south_2_north(8)(1), East => east_2_west(8)(1) , Grant => Signal_grant(8)(1)); 

Arbiter_8_2 : Arbiter

PORT MAP (Request => Request(80), North => south_2_north(7)(2), West => east_2_west(7)(1), P => Signal_priority(18), Fifo_full => Fifo_full(2),  
South => south_2_north(8)(2), East => east_2_west(8)(2) , Grant => Signal_grant(8)(2)); 

Arbiter_8_3 : Arbiter

PORT MAP (Request => Request(68), North => south_2_north(7)(3), West => east_2_west(7)(2), P => Signal_priority(18), Fifo_full => Fifo_full(3),  
South => south_2_north(8)(3), East => east_2_west(8)(3) , Grant => Signal_grant(8)(3)); 

Arbiter_8_4 : Arbiter

PORT MAP (Request => Request(56), North => south_2_north(7)(4), West => east_2_west(7)(3), P => Signal_priority(18), Fifo_full => Fifo_full(4),  
South => south_2_north(8)(4), East => east_2_west(8)(4) , Grant => Signal_grant(8)(4)); 

Arbiter_8_5 : Arbiter

PORT MAP (Request => Request(44), North => south_2_north(7)(5), West => east_2_west(7)(4), P => Signal_priority(18), Fifo_full => Fifo_full(5),  
South => south_2_north(8)(5), East => east_2_west(8)(5) , Grant => Signal_grant(8)(5)); 

Arbiter_8_6 : Arbiter

PORT MAP (Request => Request(32), North => south_2_north(7)(6), West => east_2_west(7)(5), P => Signal_priority(18), Fifo_full => Fifo_full(6),  
South => south_2_north(8)(6), East => east_2_west(8)(6) , Grant => Signal_grant(8)(6)); 

Arbiter_8_7 : Arbiter

PORT MAP (Request => Request(20), North => south_2_north(7)(7), West => east_2_west(7)(6), P => Signal_priority(18), Fifo_full => Fifo_full(7),  
South => south_2_north(8)(7), East => east_2_west(8)(7) , Grant => Signal_grant(8)(7)); 

Arbiter_8_8 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(7)(8), West => east_2_west(7)(7), P => Signal_priority(18), Fifo_full => Fifo_full(8),  
South => south_2_north(8)(8), East => east_2_west(8)(8) , Grant => Signal_grant(8)(8)); 

Arbiter_8_9 : Arbiter

PORT MAP (Request => Request(165), North => south_2_north(7)(9), West => east_2_west(7)(8), P => Signal_priority(18), Fifo_full => Fifo_full(9),  
South => south_2_north(8)(9), East => east_2_west(8)(9) , Grant => Signal_grant(8)(9)); 

Arbiter_8_10 : Arbiter

PORT MAP (Request => Request(153), North => south_2_north(7)(10), West => east_2_west(7)(9), P => Signal_priority(18), Fifo_full => Fifo_full(10),  
South => south_2_north(8)(10), East => east_2_west(8)(10) , Grant => Signal_grant(8)(10)); 

Arbiter_8_11 : Arbiter

PORT MAP (Request => Request(141), North => south_2_north(7)(11), West => east_2_west(7)(10), P => Signal_priority(18), Fifo_full => Fifo_full(11),  
South => south_2_north(8)(11), East => east_2_west(8)(11) , Grant => Signal_grant(8)(11)); 

Arbiter_8_12 : Arbiter

PORT MAP (Request => Request(129), North => south_2_north(7)(12), West => east_2_west(7)(11), P => Signal_priority(18), Fifo_full => Fifo_full(12),  
South => south_2_north(8)(12), East => east_2_west(8)(12) , Grant => Signal_grant(8)(12)); 

Arbiter_8_13 : Arbiter

PORT MAP (Request => Request(117), North => south_2_north(7)(13), West => east_2_west(7)(12), P => Signal_priority(18), Fifo_full => Fifo_full(13),  
South => south_2_north(8)(13), East => east_2_west(8)(13) , Grant => Signal_grant(8)(13)); 

-------------------------- Diagonale n 9 


Arbiter_9_1 : Arbiter

PORT MAP (Request => Request(105), North => south_2_north(8)(1), West => east_2_west(8)(13), P => Signal_priority(17), Fifo_full => Fifo_full(1),  
South => south_2_north(9)(1), East => east_2_west(9)(1) , Grant => Signal_grant(9)(1)); 

Arbiter_9_2 : Arbiter

PORT MAP (Request => Request(93), North => south_2_north(8)(2), West => east_2_west(8)(1), P => Signal_priority(17), Fifo_full => Fifo_full(2),  
South => south_2_north(9)(2), East => east_2_west(9)(2) , Grant => Signal_grant(9)(2)); 

Arbiter_9_3 : Arbiter

PORT MAP (Request => Request(81), North => south_2_north(8)(3), West => east_2_west(8)(2), P => Signal_priority(17), Fifo_full => Fifo_full(3),  
South => south_2_north(9)(3), East => east_2_west(9)(3) , Grant => Signal_grant(9)(3)); 

Arbiter_9_4 : Arbiter

PORT MAP (Request => Request(69), North => south_2_north(8)(4), West => east_2_west(8)(3), P => Signal_priority(17), Fifo_full => Fifo_full(4),  
South => south_2_north(9)(4), East => east_2_west(9)(4) , Grant => Signal_grant(9)(4)); 

Arbiter_9_5 : Arbiter

PORT MAP (Request => Request(57), North => south_2_north(8)(5), West => east_2_west(8)(4), P => Signal_priority(17), Fifo_full => Fifo_full(5),  
South => south_2_north(9)(5), East => east_2_west(9)(5) , Grant => Signal_grant(9)(5)); 

Arbiter_9_6 : Arbiter

PORT MAP (Request => Request(45), North => south_2_north(8)(6), West => east_2_west(8)(5), P => Signal_priority(17), Fifo_full => Fifo_full(6),  
South => south_2_north(9)(6), East => east_2_west(9)(6) , Grant => Signal_grant(9)(6)); 

Arbiter_9_7 : Arbiter

PORT MAP (Request => Request(33), North => south_2_north(8)(7), West => east_2_west(8)(6), P => Signal_priority(17), Fifo_full => Fifo_full(7),  
South => south_2_north(9)(7), East => east_2_west(9)(7) , Grant => Signal_grant(9)(7)); 

Arbiter_9_8 : Arbiter

PORT MAP (Request => Request(21), North => south_2_north(8)(8), West => east_2_west(8)(7), P => Signal_priority(17), Fifo_full => Fifo_full(8),  
South => south_2_north(9)(8), East => east_2_west(9)(8) , Grant => Signal_grant(9)(8)); 

Arbiter_9_9 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(8)(9), West => east_2_west(8)(8), P => Signal_priority(17), Fifo_full => Fifo_full(9),  
South => south_2_north(9)(9), East => east_2_west(9)(9) , Grant => Signal_grant(9)(9)); 

Arbiter_9_10 : Arbiter

PORT MAP (Request => Request(166), North => south_2_north(8)(10), West => east_2_west(8)(9), P => Signal_priority(17), Fifo_full => Fifo_full(10),  
South => south_2_north(9)(10), East => east_2_west(9)(10) , Grant => Signal_grant(9)(10)); 

Arbiter_9_11 : Arbiter

PORT MAP (Request => Request(154), North => south_2_north(8)(11), West => east_2_west(8)(10), P => Signal_priority(17), Fifo_full => Fifo_full(11),  
South => south_2_north(9)(11), East => east_2_west(9)(11) , Grant => Signal_grant(9)(11)); 

Arbiter_9_12 : Arbiter

PORT MAP (Request => Request(142), North => south_2_north(8)(12), West => east_2_west(8)(11), P => Signal_priority(17), Fifo_full => Fifo_full(12),  
South => south_2_north(9)(12), East => east_2_west(9)(12) , Grant => Signal_grant(9)(12)); 

Arbiter_9_13 : Arbiter

PORT MAP (Request => Request(130), North => south_2_north(8)(13), West => east_2_west(8)(12), P => Signal_priority(17), Fifo_full => Fifo_full(13),  
South => south_2_north(9)(13), East => east_2_west(9)(13) , Grant => Signal_grant(9)(13)); 

-------------------------- Diagonale n 10 


Arbiter_10_1 : Arbiter

PORT MAP (Request => Request(118), North => south_2_north(9)(1), West => east_2_west(9)(13), P => Signal_priority(16), Fifo_full => Fifo_full(1),  
South => south_2_north(10)(1), East => east_2_west(10)(1) , Grant => Signal_grant(10)(1)); 

Arbiter_10_2 : Arbiter

PORT MAP (Request => Request(106), North => south_2_north(9)(2), West => east_2_west(9)(1), P => Signal_priority(16), Fifo_full => Fifo_full(2),  
South => south_2_north(10)(2), East => east_2_west(10)(2) , Grant => Signal_grant(10)(2)); 

Arbiter_10_3 : Arbiter

PORT MAP (Request => Request(94), North => south_2_north(9)(3), West => east_2_west(9)(2), P => Signal_priority(16), Fifo_full => Fifo_full(3),  
South => south_2_north(10)(3), East => east_2_west(10)(3) , Grant => Signal_grant(10)(3)); 

Arbiter_10_4 : Arbiter

PORT MAP (Request => Request(82), North => south_2_north(9)(4), West => east_2_west(9)(3), P => Signal_priority(16), Fifo_full => Fifo_full(4),  
South => south_2_north(10)(4), East => east_2_west(10)(4) , Grant => Signal_grant(10)(4)); 

Arbiter_10_5 : Arbiter

PORT MAP (Request => Request(70), North => south_2_north(9)(5), West => east_2_west(9)(4), P => Signal_priority(16), Fifo_full => Fifo_full(5),  
South => south_2_north(10)(5), East => east_2_west(10)(5) , Grant => Signal_grant(10)(5)); 

Arbiter_10_6 : Arbiter

PORT MAP (Request => Request(58), North => south_2_north(9)(6), West => east_2_west(9)(5), P => Signal_priority(16), Fifo_full => Fifo_full(6),  
South => south_2_north(10)(6), East => east_2_west(10)(6) , Grant => Signal_grant(10)(6)); 

Arbiter_10_7 : Arbiter

PORT MAP (Request => Request(46), North => south_2_north(9)(7), West => east_2_west(9)(6), P => Signal_priority(16), Fifo_full => Fifo_full(7),  
South => south_2_north(10)(7), East => east_2_west(10)(7) , Grant => Signal_grant(10)(7)); 

Arbiter_10_8 : Arbiter

PORT MAP (Request => Request(34), North => south_2_north(9)(8), West => east_2_west(9)(7), P => Signal_priority(16), Fifo_full => Fifo_full(8),  
South => south_2_north(10)(8), East => east_2_west(10)(8) , Grant => Signal_grant(10)(8)); 

Arbiter_10_9 : Arbiter

PORT MAP (Request => Request(22), North => south_2_north(9)(9), West => east_2_west(9)(8), P => Signal_priority(16), Fifo_full => Fifo_full(9),  
South => south_2_north(10)(9), East => east_2_west(10)(9) , Grant => Signal_grant(10)(9)); 

Arbiter_10_10 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(9)(10), West => east_2_west(9)(9), P => Signal_priority(16), Fifo_full => Fifo_full(10),  
South => south_2_north(10)(10), East => east_2_west(10)(10) , Grant => Signal_grant(10)(10)); 

Arbiter_10_11 : Arbiter

PORT MAP (Request => Request(167), North => south_2_north(9)(11), West => east_2_west(9)(10), P => Signal_priority(16), Fifo_full => Fifo_full(11),  
South => south_2_north(10)(11), East => east_2_west(10)(11) , Grant => Signal_grant(10)(11)); 

Arbiter_10_12 : Arbiter

PORT MAP (Request => Request(155), North => south_2_north(9)(12), West => east_2_west(9)(11), P => Signal_priority(16), Fifo_full => Fifo_full(12),  
South => south_2_north(10)(12), East => east_2_west(10)(12) , Grant => Signal_grant(10)(12)); 

Arbiter_10_13 : Arbiter

PORT MAP (Request => Request(143), North => south_2_north(9)(13), West => east_2_west(9)(12), P => Signal_priority(16), Fifo_full => Fifo_full(13),  
South => south_2_north(10)(13), East => east_2_west(10)(13) , Grant => Signal_grant(10)(13)); 

-------------------------- Diagonale n 11 


Arbiter_11_1 : Arbiter

PORT MAP (Request => Request(131), North => south_2_north(10)(1), West => east_2_west(10)(13), P => Signal_priority(15), Fifo_full => Fifo_full(1),  
South => south_2_north(11)(1), East => east_2_west(11)(1) , Grant => Signal_grant(11)(1)); 

Arbiter_11_2 : Arbiter

PORT MAP (Request => Request(119), North => south_2_north(10)(2), West => east_2_west(10)(1), P => Signal_priority(15), Fifo_full => Fifo_full(2),  
South => south_2_north(11)(2), East => east_2_west(11)(2) , Grant => Signal_grant(11)(2)); 

Arbiter_11_3 : Arbiter

PORT MAP (Request => Request(107), North => south_2_north(10)(3), West => east_2_west(10)(2), P => Signal_priority(15), Fifo_full => Fifo_full(3),  
South => south_2_north(11)(3), East => east_2_west(11)(3) , Grant => Signal_grant(11)(3)); 

Arbiter_11_4 : Arbiter

PORT MAP (Request => Request(95), North => south_2_north(10)(4), West => east_2_west(10)(3), P => Signal_priority(15), Fifo_full => Fifo_full(4),  
South => south_2_north(11)(4), East => east_2_west(11)(4) , Grant => Signal_grant(11)(4)); 

Arbiter_11_5 : Arbiter

PORT MAP (Request => Request(83), North => south_2_north(10)(5), West => east_2_west(10)(4), P => Signal_priority(15), Fifo_full => Fifo_full(5),  
South => south_2_north(11)(5), East => east_2_west(11)(5) , Grant => Signal_grant(11)(5)); 

Arbiter_11_6 : Arbiter

PORT MAP (Request => Request(71), North => south_2_north(10)(6), West => east_2_west(10)(5), P => Signal_priority(15), Fifo_full => Fifo_full(6),  
South => south_2_north(11)(6), East => east_2_west(11)(6) , Grant => Signal_grant(11)(6)); 

Arbiter_11_7 : Arbiter

PORT MAP (Request => Request(59), North => south_2_north(10)(7), West => east_2_west(10)(6), P => Signal_priority(15), Fifo_full => Fifo_full(7),  
South => south_2_north(11)(7), East => east_2_west(11)(7) , Grant => Signal_grant(11)(7)); 

Arbiter_11_8 : Arbiter

PORT MAP (Request => Request(47), North => south_2_north(10)(8), West => east_2_west(10)(7), P => Signal_priority(15), Fifo_full => Fifo_full(8),  
South => south_2_north(11)(8), East => east_2_west(11)(8) , Grant => Signal_grant(11)(8)); 

Arbiter_11_9 : Arbiter

PORT MAP (Request => Request(35), North => south_2_north(10)(9), West => east_2_west(10)(8), P => Signal_priority(15), Fifo_full => Fifo_full(9),  
South => south_2_north(11)(9), East => east_2_west(11)(9) , Grant => Signal_grant(11)(9)); 

Arbiter_11_10 : Arbiter

PORT MAP (Request => Request(23), North => south_2_north(10)(10), West => east_2_west(10)(9), P => Signal_priority(15), Fifo_full => Fifo_full(10),  
South => south_2_north(11)(10), East => east_2_west(11)(10) , Grant => Signal_grant(11)(10)); 

Arbiter_11_11 : Arbiter

PORT MAP (Request => Request(11), North => south_2_north(10)(11), West => east_2_west(10)(10), P => Signal_priority(15), Fifo_full => Fifo_full(11),  
South => south_2_north(11)(11), East => east_2_west(11)(11) , Grant => Signal_grant(11)(11)); 

Arbiter_11_12 : Arbiter

PORT MAP (Request => Request(168), North => south_2_north(10)(12), West => east_2_west(10)(11), P => Signal_priority(15), Fifo_full => Fifo_full(12),  
South => south_2_north(11)(12), East => east_2_west(11)(12) , Grant => Signal_grant(11)(12)); 

Arbiter_11_13 : Arbiter

PORT MAP (Request => Request(156), North => south_2_north(10)(13), West => east_2_west(10)(12), P => Signal_priority(15), Fifo_full => Fifo_full(13),  
South => south_2_north(11)(13), East => east_2_west(11)(13) , Grant => Signal_grant(11)(13)); 

-------------------------- Diagonale n 12 


Arbiter_12_1 : Arbiter

PORT MAP (Request => Request(144), North => south_2_north(11)(1), West => east_2_west(11)(13), P => Signal_priority(14), Fifo_full => Fifo_full(1),  
South => south_2_north(12)(1), East => east_2_west(12)(1) , Grant => Signal_grant(12)(1)); 

Arbiter_12_2 : Arbiter

PORT MAP (Request => Request(132), North => south_2_north(11)(2), West => east_2_west(11)(1), P => Signal_priority(14), Fifo_full => Fifo_full(2),  
South => south_2_north(12)(2), East => east_2_west(12)(2) , Grant => Signal_grant(12)(2)); 

Arbiter_12_3 : Arbiter

PORT MAP (Request => Request(120), North => south_2_north(11)(3), West => east_2_west(11)(2), P => Signal_priority(14), Fifo_full => Fifo_full(3),  
South => south_2_north(12)(3), East => east_2_west(12)(3) , Grant => Signal_grant(12)(3)); 

Arbiter_12_4 : Arbiter

PORT MAP (Request => Request(108), North => south_2_north(11)(4), West => east_2_west(11)(3), P => Signal_priority(14), Fifo_full => Fifo_full(4),  
South => south_2_north(12)(4), East => east_2_west(12)(4) , Grant => Signal_grant(12)(4)); 

Arbiter_12_5 : Arbiter

PORT MAP (Request => Request(96), North => south_2_north(11)(5), West => east_2_west(11)(4), P => Signal_priority(14), Fifo_full => Fifo_full(5),  
South => south_2_north(12)(5), East => east_2_west(12)(5) , Grant => Signal_grant(12)(5)); 

Arbiter_12_6 : Arbiter

PORT MAP (Request => Request(84), North => south_2_north(11)(6), West => east_2_west(11)(5), P => Signal_priority(14), Fifo_full => Fifo_full(6),  
South => south_2_north(12)(6), East => east_2_west(12)(6) , Grant => Signal_grant(12)(6)); 

Arbiter_12_7 : Arbiter

PORT MAP (Request => Request(72), North => south_2_north(11)(7), West => east_2_west(11)(6), P => Signal_priority(14), Fifo_full => Fifo_full(7),  
South => south_2_north(12)(7), East => east_2_west(12)(7) , Grant => Signal_grant(12)(7)); 

Arbiter_12_8 : Arbiter

PORT MAP (Request => Request(60), North => south_2_north(11)(8), West => east_2_west(11)(7), P => Signal_priority(14), Fifo_full => Fifo_full(8),  
South => south_2_north(12)(8), East => east_2_west(12)(8) , Grant => Signal_grant(12)(8)); 

Arbiter_12_9 : Arbiter

PORT MAP (Request => Request(48), North => south_2_north(11)(9), West => east_2_west(11)(8), P => Signal_priority(14), Fifo_full => Fifo_full(9),  
South => south_2_north(12)(9), East => east_2_west(12)(9) , Grant => Signal_grant(12)(9)); 

Arbiter_12_10 : Arbiter

PORT MAP (Request => Request(36), North => south_2_north(11)(10), West => east_2_west(11)(9), P => Signal_priority(14), Fifo_full => Fifo_full(10),  
South => south_2_north(12)(10), East => east_2_west(12)(10) , Grant => Signal_grant(12)(10)); 

Arbiter_12_11 : Arbiter

PORT MAP (Request => Request(24), North => south_2_north(11)(11), West => east_2_west(11)(10), P => Signal_priority(14), Fifo_full => Fifo_full(11),  
South => south_2_north(12)(11), East => east_2_west(12)(11) , Grant => Signal_grant(12)(11)); 

Arbiter_12_12 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(11)(12), West => east_2_west(11)(11), P => Signal_priority(14), Fifo_full => Fifo_full(12),  
South => south_2_north(12)(12), East => east_2_west(12)(12) , Grant => Signal_grant(12)(12)); 

Arbiter_12_13 : Arbiter

PORT MAP (Request => Request(169), North => south_2_north(11)(13), West => east_2_west(11)(12), P => Signal_priority(14), Fifo_full => Fifo_full(13),  
South => south_2_north(12)(13), East => east_2_west(12)(13) , Grant => Signal_grant(12)(13)); 

-------------------------- Diagonale n 13 


Arbiter_13_1 : Arbiter

PORT MAP (Request => Request(157), North => south_2_north(12)(1), West => east_2_west(12)(13), P => Signal_priority(13), Fifo_full => Fifo_full(1),  
South => south_2_north(13)(1), East => east_2_west(13)(1) , Grant => Signal_grant(13)(1)); 

Arbiter_13_2 : Arbiter

PORT MAP (Request => Request(145), North => south_2_north(12)(2), West => east_2_west(12)(1), P => Signal_priority(13), Fifo_full => Fifo_full(2),  
South => south_2_north(13)(2), East => east_2_west(13)(2) , Grant => Signal_grant(13)(2)); 

Arbiter_13_3 : Arbiter

PORT MAP (Request => Request(133), North => south_2_north(12)(3), West => east_2_west(12)(2), P => Signal_priority(13), Fifo_full => Fifo_full(3),  
South => south_2_north(13)(3), East => east_2_west(13)(3) , Grant => Signal_grant(13)(3)); 

Arbiter_13_4 : Arbiter

PORT MAP (Request => Request(121), North => south_2_north(12)(4), West => east_2_west(12)(3), P => Signal_priority(13), Fifo_full => Fifo_full(4),  
South => south_2_north(13)(4), East => east_2_west(13)(4) , Grant => Signal_grant(13)(4)); 

Arbiter_13_5 : Arbiter

PORT MAP (Request => Request(109), North => south_2_north(12)(5), West => east_2_west(12)(4), P => Signal_priority(13), Fifo_full => Fifo_full(5),  
South => south_2_north(13)(5), East => east_2_west(13)(5) , Grant => Signal_grant(13)(5)); 

Arbiter_13_6 : Arbiter

PORT MAP (Request => Request(97), North => south_2_north(12)(6), West => east_2_west(12)(5), P => Signal_priority(13), Fifo_full => Fifo_full(6),  
South => south_2_north(13)(6), East => east_2_west(13)(6) , Grant => Signal_grant(13)(6)); 

Arbiter_13_7 : Arbiter

PORT MAP (Request => Request(85), North => south_2_north(12)(7), West => east_2_west(12)(6), P => Signal_priority(13), Fifo_full => Fifo_full(7),  
South => south_2_north(13)(7), East => east_2_west(13)(7) , Grant => Signal_grant(13)(7)); 

Arbiter_13_8 : Arbiter

PORT MAP (Request => Request(73), North => south_2_north(12)(8), West => east_2_west(12)(7), P => Signal_priority(13), Fifo_full => Fifo_full(8),  
South => south_2_north(13)(8), East => east_2_west(13)(8) , Grant => Signal_grant(13)(8)); 

Arbiter_13_9 : Arbiter

PORT MAP (Request => Request(61), North => south_2_north(12)(9), West => east_2_west(12)(8), P => Signal_priority(13), Fifo_full => Fifo_full(9),  
South => south_2_north(13)(9), East => east_2_west(13)(9) , Grant => Signal_grant(13)(9)); 

Arbiter_13_10 : Arbiter

PORT MAP (Request => Request(49), North => south_2_north(12)(10), West => east_2_west(12)(9), P => Signal_priority(13), Fifo_full => Fifo_full(10),  
South => south_2_north(13)(10), East => east_2_west(13)(10) , Grant => Signal_grant(13)(10)); 

Arbiter_13_11 : Arbiter

PORT MAP (Request => Request(37), North => south_2_north(12)(11), West => east_2_west(12)(10), P => Signal_priority(13), Fifo_full => Fifo_full(11),  
South => south_2_north(13)(11), East => east_2_west(13)(11) , Grant => Signal_grant(13)(11)); 

Arbiter_13_12 : Arbiter

PORT MAP (Request => Request(25), North => south_2_north(12)(12), West => east_2_west(12)(11), P => Signal_priority(13), Fifo_full => Fifo_full(12),  
South => south_2_north(13)(12), East => east_2_west(13)(12) , Grant => Signal_grant(13)(12)); 

Arbiter_13_13 : Arbiter

PORT MAP (Request => Request(13), North => south_2_north(12)(13), West => east_2_west(12)(12), P => Signal_priority(13), Fifo_full => Fifo_full(13),  
South => south_2_north(13)(13), East => east_2_west(13)(13) , Grant => Signal_grant(13)(13)); 

-------------------------- Diagonale n 14 


Arbiter_14_1 : Arbiter

PORT MAP (Request => Request(1), North => south_2_north(13)(1), West => east_2_west(13)(13), P => Signal_priority(12), Fifo_full => Fifo_full(1),  
South => south_2_north(14)(1), East => east_2_west(14)(1) , Grant => Signal_grant(14)(1)); 

Arbiter_14_2 : Arbiter

PORT MAP (Request => Request(158), North => south_2_north(13)(2), West => east_2_west(13)(1), P => Signal_priority(12), Fifo_full => Fifo_full(2),  
South => south_2_north(14)(2), East => east_2_west(14)(2) , Grant => Signal_grant(14)(2)); 

Arbiter_14_3 : Arbiter

PORT MAP (Request => Request(146), North => south_2_north(13)(3), West => east_2_west(13)(2), P => Signal_priority(12), Fifo_full => Fifo_full(3),  
South => south_2_north(14)(3), East => east_2_west(14)(3) , Grant => Signal_grant(14)(3)); 

Arbiter_14_4 : Arbiter

PORT MAP (Request => Request(134), North => south_2_north(13)(4), West => east_2_west(13)(3), P => Signal_priority(12), Fifo_full => Fifo_full(4),  
South => south_2_north(14)(4), East => east_2_west(14)(4) , Grant => Signal_grant(14)(4)); 

Arbiter_14_5 : Arbiter

PORT MAP (Request => Request(122), North => south_2_north(13)(5), West => east_2_west(13)(4), P => Signal_priority(12), Fifo_full => Fifo_full(5),  
South => south_2_north(14)(5), East => east_2_west(14)(5) , Grant => Signal_grant(14)(5)); 

Arbiter_14_6 : Arbiter

PORT MAP (Request => Request(110), North => south_2_north(13)(6), West => east_2_west(13)(5), P => Signal_priority(12), Fifo_full => Fifo_full(6),  
South => south_2_north(14)(6), East => east_2_west(14)(6) , Grant => Signal_grant(14)(6)); 

Arbiter_14_7 : Arbiter

PORT MAP (Request => Request(98), North => south_2_north(13)(7), West => east_2_west(13)(6), P => Signal_priority(12), Fifo_full => Fifo_full(7),  
South => south_2_north(14)(7), East => east_2_west(14)(7) , Grant => Signal_grant(14)(7)); 

Arbiter_14_8 : Arbiter

PORT MAP (Request => Request(86), North => south_2_north(13)(8), West => east_2_west(13)(7), P => Signal_priority(12), Fifo_full => Fifo_full(8),  
South => south_2_north(14)(8), East => east_2_west(14)(8) , Grant => Signal_grant(14)(8)); 

Arbiter_14_9 : Arbiter

PORT MAP (Request => Request(74), North => south_2_north(13)(9), West => east_2_west(13)(8), P => Signal_priority(12), Fifo_full => Fifo_full(9),  
South => south_2_north(14)(9), East => east_2_west(14)(9) , Grant => Signal_grant(14)(9)); 

Arbiter_14_10 : Arbiter

PORT MAP (Request => Request(62), North => south_2_north(13)(10), West => east_2_west(13)(9), P => Signal_priority(12), Fifo_full => Fifo_full(10),  
South => south_2_north(14)(10), East => east_2_west(14)(10) , Grant => Signal_grant(14)(10)); 

Arbiter_14_11 : Arbiter

PORT MAP (Request => Request(50), North => south_2_north(13)(11), West => east_2_west(13)(10), P => Signal_priority(12), Fifo_full => Fifo_full(11),  
South => south_2_north(14)(11), East => east_2_west(14)(11) , Grant => Signal_grant(14)(11)); 

Arbiter_14_12 : Arbiter

PORT MAP (Request => Request(38), North => south_2_north(13)(12), West => east_2_west(13)(11), P => Signal_priority(12), Fifo_full => Fifo_full(12),  
South => south_2_north(14)(12), East => east_2_west(14)(12) , Grant => Signal_grant(14)(12)); 

Arbiter_14_13 : Arbiter

PORT MAP (Request => Request(26), North => south_2_north(13)(13), West => east_2_west(13)(12), P => Signal_priority(12), Fifo_full => Fifo_full(13),  
South => south_2_north(14)(13), East => east_2_west(14)(13) , Grant => Signal_grant(14)(13)); 

-------------------------- Diagonale n 15 


Arbiter_15_1 : Arbiter

PORT MAP (Request => Request(14), North => south_2_north(14)(1), West => east_2_west(14)(13), P => Signal_priority(11), Fifo_full => Fifo_full(1),  
South => south_2_north(15)(1), East => east_2_west(15)(1) , Grant => Signal_grant(15)(1)); 

Arbiter_15_2 : Arbiter

PORT MAP (Request => Request(2), North => south_2_north(14)(2), West => east_2_west(14)(1), P => Signal_priority(11), Fifo_full => Fifo_full(2),  
South => south_2_north(15)(2), East => east_2_west(15)(2) , Grant => Signal_grant(15)(2)); 

Arbiter_15_3 : Arbiter

PORT MAP (Request => Request(159), North => south_2_north(14)(3), West => east_2_west(14)(2), P => Signal_priority(11), Fifo_full => Fifo_full(3),  
South => south_2_north(15)(3), East => east_2_west(15)(3) , Grant => Signal_grant(15)(3)); 

Arbiter_15_4 : Arbiter

PORT MAP (Request => Request(147), North => south_2_north(14)(4), West => east_2_west(14)(3), P => Signal_priority(11), Fifo_full => Fifo_full(4),  
South => south_2_north(15)(4), East => east_2_west(15)(4) , Grant => Signal_grant(15)(4)); 

Arbiter_15_5 : Arbiter

PORT MAP (Request => Request(135), North => south_2_north(14)(5), West => east_2_west(14)(4), P => Signal_priority(11), Fifo_full => Fifo_full(5),  
South => south_2_north(15)(5), East => east_2_west(15)(5) , Grant => Signal_grant(15)(5)); 

Arbiter_15_6 : Arbiter

PORT MAP (Request => Request(123), North => south_2_north(14)(6), West => east_2_west(14)(5), P => Signal_priority(11), Fifo_full => Fifo_full(6),  
South => south_2_north(15)(6), East => east_2_west(15)(6) , Grant => Signal_grant(15)(6)); 

Arbiter_15_7 : Arbiter

PORT MAP (Request => Request(111), North => south_2_north(14)(7), West => east_2_west(14)(6), P => Signal_priority(11), Fifo_full => Fifo_full(7),  
South => south_2_north(15)(7), East => east_2_west(15)(7) , Grant => Signal_grant(15)(7)); 

Arbiter_15_8 : Arbiter

PORT MAP (Request => Request(99), North => south_2_north(14)(8), West => east_2_west(14)(7), P => Signal_priority(11), Fifo_full => Fifo_full(8),  
South => south_2_north(15)(8), East => east_2_west(15)(8) , Grant => Signal_grant(15)(8)); 

Arbiter_15_9 : Arbiter

PORT MAP (Request => Request(87), North => south_2_north(14)(9), West => east_2_west(14)(8), P => Signal_priority(11), Fifo_full => Fifo_full(9),  
South => south_2_north(15)(9), East => east_2_west(15)(9) , Grant => Signal_grant(15)(9)); 

Arbiter_15_10 : Arbiter

PORT MAP (Request => Request(75), North => south_2_north(14)(10), West => east_2_west(14)(9), P => Signal_priority(11), Fifo_full => Fifo_full(10),  
South => south_2_north(15)(10), East => east_2_west(15)(10) , Grant => Signal_grant(15)(10)); 

Arbiter_15_11 : Arbiter

PORT MAP (Request => Request(63), North => south_2_north(14)(11), West => east_2_west(14)(10), P => Signal_priority(11), Fifo_full => Fifo_full(11),  
South => south_2_north(15)(11), East => east_2_west(15)(11) , Grant => Signal_grant(15)(11)); 

Arbiter_15_12 : Arbiter

PORT MAP (Request => Request(51), North => south_2_north(14)(12), West => east_2_west(14)(11), P => Signal_priority(11), Fifo_full => Fifo_full(12),  
South => south_2_north(15)(12), East => east_2_west(15)(12) , Grant => Signal_grant(15)(12)); 

Arbiter_15_13 : Arbiter

PORT MAP (Request => Request(39), North => south_2_north(14)(13), West => east_2_west(14)(12), P => Signal_priority(11), Fifo_full => Fifo_full(13),  
South => south_2_north(15)(13), East => east_2_west(15)(13) , Grant => Signal_grant(15)(13)); 

-------------------------- Diagonale n 16 


Arbiter_16_1 : Arbiter

PORT MAP (Request => Request(27), North => south_2_north(15)(1), West => east_2_west(15)(13), P => Signal_priority(10), Fifo_full => Fifo_full(1),  
South => south_2_north(16)(1), East => east_2_west(16)(1) , Grant => Signal_grant(16)(1)); 

Arbiter_16_2 : Arbiter

PORT MAP (Request => Request(15), North => south_2_north(15)(2), West => east_2_west(15)(1), P => Signal_priority(10), Fifo_full => Fifo_full(2),  
South => south_2_north(16)(2), East => east_2_west(16)(2) , Grant => Signal_grant(16)(2)); 

Arbiter_16_3 : Arbiter

PORT MAP (Request => Request(3), North => south_2_north(15)(3), West => east_2_west(15)(2), P => Signal_priority(10), Fifo_full => Fifo_full(3),  
South => south_2_north(16)(3), East => east_2_west(16)(3) , Grant => Signal_grant(16)(3)); 

Arbiter_16_4 : Arbiter

PORT MAP (Request => Request(160), North => south_2_north(15)(4), West => east_2_west(15)(3), P => Signal_priority(10), Fifo_full => Fifo_full(4),  
South => south_2_north(16)(4), East => east_2_west(16)(4) , Grant => Signal_grant(16)(4)); 

Arbiter_16_5 : Arbiter

PORT MAP (Request => Request(148), North => south_2_north(15)(5), West => east_2_west(15)(4), P => Signal_priority(10), Fifo_full => Fifo_full(5),  
South => south_2_north(16)(5), East => east_2_west(16)(5) , Grant => Signal_grant(16)(5)); 

Arbiter_16_6 : Arbiter

PORT MAP (Request => Request(136), North => south_2_north(15)(6), West => east_2_west(15)(5), P => Signal_priority(10), Fifo_full => Fifo_full(6),  
South => south_2_north(16)(6), East => east_2_west(16)(6) , Grant => Signal_grant(16)(6)); 

Arbiter_16_7 : Arbiter

PORT MAP (Request => Request(124), North => south_2_north(15)(7), West => east_2_west(15)(6), P => Signal_priority(10), Fifo_full => Fifo_full(7),  
South => south_2_north(16)(7), East => east_2_west(16)(7) , Grant => Signal_grant(16)(7)); 

Arbiter_16_8 : Arbiter

PORT MAP (Request => Request(112), North => south_2_north(15)(8), West => east_2_west(15)(7), P => Signal_priority(10), Fifo_full => Fifo_full(8),  
South => south_2_north(16)(8), East => east_2_west(16)(8) , Grant => Signal_grant(16)(8)); 

Arbiter_16_9 : Arbiter

PORT MAP (Request => Request(100), North => south_2_north(15)(9), West => east_2_west(15)(8), P => Signal_priority(10), Fifo_full => Fifo_full(9),  
South => south_2_north(16)(9), East => east_2_west(16)(9) , Grant => Signal_grant(16)(9)); 

Arbiter_16_10 : Arbiter

PORT MAP (Request => Request(88), North => south_2_north(15)(10), West => east_2_west(15)(9), P => Signal_priority(10), Fifo_full => Fifo_full(10),  
South => south_2_north(16)(10), East => east_2_west(16)(10) , Grant => Signal_grant(16)(10)); 

Arbiter_16_11 : Arbiter

PORT MAP (Request => Request(76), North => south_2_north(15)(11), West => east_2_west(15)(10), P => Signal_priority(10), Fifo_full => Fifo_full(11),  
South => south_2_north(16)(11), East => east_2_west(16)(11) , Grant => Signal_grant(16)(11)); 

Arbiter_16_12 : Arbiter

PORT MAP (Request => Request(64), North => south_2_north(15)(12), West => east_2_west(15)(11), P => Signal_priority(10), Fifo_full => Fifo_full(12),  
South => south_2_north(16)(12), East => east_2_west(16)(12) , Grant => Signal_grant(16)(12)); 

Arbiter_16_13 : Arbiter

PORT MAP (Request => Request(52), North => south_2_north(15)(13), West => east_2_west(15)(12), P => Signal_priority(10), Fifo_full => Fifo_full(13),  
South => south_2_north(16)(13), East => east_2_west(16)(13) , Grant => Signal_grant(16)(13)); 

-------------------------- Diagonale n 17 


Arbiter_17_1 : Arbiter

PORT MAP (Request => Request(40), North => south_2_north(16)(1), West => east_2_west(16)(13), P => Signal_priority(9), Fifo_full => Fifo_full(1),  
South => south_2_north(17)(1), East => east_2_west(17)(1) , Grant => Signal_grant(17)(1)); 

Arbiter_17_2 : Arbiter

PORT MAP (Request => Request(28), North => south_2_north(16)(2), West => east_2_west(16)(1), P => Signal_priority(9), Fifo_full => Fifo_full(2),  
South => south_2_north(17)(2), East => east_2_west(17)(2) , Grant => Signal_grant(17)(2)); 

Arbiter_17_3 : Arbiter

PORT MAP (Request => Request(16), North => south_2_north(16)(3), West => east_2_west(16)(2), P => Signal_priority(9), Fifo_full => Fifo_full(3),  
South => south_2_north(17)(3), East => east_2_west(17)(3) , Grant => Signal_grant(17)(3)); 

Arbiter_17_4 : Arbiter

PORT MAP (Request => Request(4), North => south_2_north(16)(4), West => east_2_west(16)(3), P => Signal_priority(9), Fifo_full => Fifo_full(4),  
South => south_2_north(17)(4), East => east_2_west(17)(4) , Grant => Signal_grant(17)(4)); 

Arbiter_17_5 : Arbiter

PORT MAP (Request => Request(161), North => south_2_north(16)(5), West => east_2_west(16)(4), P => Signal_priority(9), Fifo_full => Fifo_full(5),  
South => south_2_north(17)(5), East => east_2_west(17)(5) , Grant => Signal_grant(17)(5)); 

Arbiter_17_6 : Arbiter

PORT MAP (Request => Request(149), North => south_2_north(16)(6), West => east_2_west(16)(5), P => Signal_priority(9), Fifo_full => Fifo_full(6),  
South => south_2_north(17)(6), East => east_2_west(17)(6) , Grant => Signal_grant(17)(6)); 

Arbiter_17_7 : Arbiter

PORT MAP (Request => Request(137), North => south_2_north(16)(7), West => east_2_west(16)(6), P => Signal_priority(9), Fifo_full => Fifo_full(7),  
South => south_2_north(17)(7), East => east_2_west(17)(7) , Grant => Signal_grant(17)(7)); 

Arbiter_17_8 : Arbiter

PORT MAP (Request => Request(125), North => south_2_north(16)(8), West => east_2_west(16)(7), P => Signal_priority(9), Fifo_full => Fifo_full(8),  
South => south_2_north(17)(8), East => east_2_west(17)(8) , Grant => Signal_grant(17)(8)); 

Arbiter_17_9 : Arbiter

PORT MAP (Request => Request(113), North => south_2_north(16)(9), West => east_2_west(16)(8), P => Signal_priority(9), Fifo_full => Fifo_full(9),  
South => south_2_north(17)(9), East => east_2_west(17)(9) , Grant => Signal_grant(17)(9)); 

Arbiter_17_10 : Arbiter

PORT MAP (Request => Request(101), North => south_2_north(16)(10), West => east_2_west(16)(9), P => Signal_priority(9), Fifo_full => Fifo_full(10),  
South => south_2_north(17)(10), East => east_2_west(17)(10) , Grant => Signal_grant(17)(10)); 

Arbiter_17_11 : Arbiter

PORT MAP (Request => Request(89), North => south_2_north(16)(11), West => east_2_west(16)(10), P => Signal_priority(9), Fifo_full => Fifo_full(11),  
South => south_2_north(17)(11), East => east_2_west(17)(11) , Grant => Signal_grant(17)(11)); 

Arbiter_17_12 : Arbiter

PORT MAP (Request => Request(77), North => south_2_north(16)(12), West => east_2_west(16)(11), P => Signal_priority(9), Fifo_full => Fifo_full(12),  
South => south_2_north(17)(12), East => east_2_west(17)(12) , Grant => Signal_grant(17)(12)); 

Arbiter_17_13 : Arbiter

PORT MAP (Request => Request(65), North => south_2_north(16)(13), West => east_2_west(16)(12), P => Signal_priority(9), Fifo_full => Fifo_full(13),  
South => south_2_north(17)(13), East => east_2_west(17)(13) , Grant => Signal_grant(17)(13)); 

-------------------------- Diagonale n 18 


Arbiter_18_1 : Arbiter

PORT MAP (Request => Request(53), North => south_2_north(17)(1), West => east_2_west(17)(13), P => Signal_priority(8), Fifo_full => Fifo_full(1),  
South => south_2_north(18)(1), East => east_2_west(18)(1) , Grant => Signal_grant(18)(1)); 

Arbiter_18_2 : Arbiter

PORT MAP (Request => Request(41), North => south_2_north(17)(2), West => east_2_west(17)(1), P => Signal_priority(8), Fifo_full => Fifo_full(2),  
South => south_2_north(18)(2), East => east_2_west(18)(2) , Grant => Signal_grant(18)(2)); 

Arbiter_18_3 : Arbiter

PORT MAP (Request => Request(29), North => south_2_north(17)(3), West => east_2_west(17)(2), P => Signal_priority(8), Fifo_full => Fifo_full(3),  
South => south_2_north(18)(3), East => east_2_west(18)(3) , Grant => Signal_grant(18)(3)); 

Arbiter_18_4 : Arbiter

PORT MAP (Request => Request(17), North => south_2_north(17)(4), West => east_2_west(17)(3), P => Signal_priority(8), Fifo_full => Fifo_full(4),  
South => south_2_north(18)(4), East => east_2_west(18)(4) , Grant => Signal_grant(18)(4)); 

Arbiter_18_5 : Arbiter

PORT MAP (Request => Request(5), North => south_2_north(17)(5), West => east_2_west(17)(4), P => Signal_priority(8), Fifo_full => Fifo_full(5),  
South => south_2_north(18)(5), East => east_2_west(18)(5) , Grant => Signal_grant(18)(5)); 

Arbiter_18_6 : Arbiter

PORT MAP (Request => Request(162), North => south_2_north(17)(6), West => east_2_west(17)(5), P => Signal_priority(8), Fifo_full => Fifo_full(6),  
South => south_2_north(18)(6), East => east_2_west(18)(6) , Grant => Signal_grant(18)(6)); 

Arbiter_18_7 : Arbiter

PORT MAP (Request => Request(150), North => south_2_north(17)(7), West => east_2_west(17)(6), P => Signal_priority(8), Fifo_full => Fifo_full(7),  
South => south_2_north(18)(7), East => east_2_west(18)(7) , Grant => Signal_grant(18)(7)); 

Arbiter_18_8 : Arbiter

PORT MAP (Request => Request(138), North => south_2_north(17)(8), West => east_2_west(17)(7), P => Signal_priority(8), Fifo_full => Fifo_full(8),  
South => south_2_north(18)(8), East => east_2_west(18)(8) , Grant => Signal_grant(18)(8)); 

Arbiter_18_9 : Arbiter

PORT MAP (Request => Request(126), North => south_2_north(17)(9), West => east_2_west(17)(8), P => Signal_priority(8), Fifo_full => Fifo_full(9),  
South => south_2_north(18)(9), East => east_2_west(18)(9) , Grant => Signal_grant(18)(9)); 

Arbiter_18_10 : Arbiter

PORT MAP (Request => Request(114), North => south_2_north(17)(10), West => east_2_west(17)(9), P => Signal_priority(8), Fifo_full => Fifo_full(10),  
South => south_2_north(18)(10), East => east_2_west(18)(10) , Grant => Signal_grant(18)(10)); 

Arbiter_18_11 : Arbiter

PORT MAP (Request => Request(102), North => south_2_north(17)(11), West => east_2_west(17)(10), P => Signal_priority(8), Fifo_full => Fifo_full(11),  
South => south_2_north(18)(11), East => east_2_west(18)(11) , Grant => Signal_grant(18)(11)); 

Arbiter_18_12 : Arbiter

PORT MAP (Request => Request(90), North => south_2_north(17)(12), West => east_2_west(17)(11), P => Signal_priority(8), Fifo_full => Fifo_full(12),  
South => south_2_north(18)(12), East => east_2_west(18)(12) , Grant => Signal_grant(18)(12)); 

Arbiter_18_13 : Arbiter

PORT MAP (Request => Request(78), North => south_2_north(17)(13), West => east_2_west(17)(12), P => Signal_priority(8), Fifo_full => Fifo_full(13),  
South => south_2_north(18)(13), East => east_2_west(18)(13) , Grant => Signal_grant(18)(13)); 

-------------------------- Diagonale n 19 


Arbiter_19_1 : Arbiter

PORT MAP (Request => Request(66), North => south_2_north(18)(1), West => east_2_west(18)(13), P => Signal_priority(7), Fifo_full => Fifo_full(1),  
South => south_2_north(19)(1), East => east_2_west(19)(1) , Grant => Signal_grant(19)(1)); 

Arbiter_19_2 : Arbiter

PORT MAP (Request => Request(54), North => south_2_north(18)(2), West => east_2_west(18)(1), P => Signal_priority(7), Fifo_full => Fifo_full(2),  
South => south_2_north(19)(2), East => east_2_west(19)(2) , Grant => Signal_grant(19)(2)); 

Arbiter_19_3 : Arbiter

PORT MAP (Request => Request(42), North => south_2_north(18)(3), West => east_2_west(18)(2), P => Signal_priority(7), Fifo_full => Fifo_full(3),  
South => south_2_north(19)(3), East => east_2_west(19)(3) , Grant => Signal_grant(19)(3)); 

Arbiter_19_4 : Arbiter

PORT MAP (Request => Request(30), North => south_2_north(18)(4), West => east_2_west(18)(3), P => Signal_priority(7), Fifo_full => Fifo_full(4),  
South => south_2_north(19)(4), East => east_2_west(19)(4) , Grant => Signal_grant(19)(4)); 

Arbiter_19_5 : Arbiter

PORT MAP (Request => Request(18), North => south_2_north(18)(5), West => east_2_west(18)(4), P => Signal_priority(7), Fifo_full => Fifo_full(5),  
South => south_2_north(19)(5), East => east_2_west(19)(5) , Grant => Signal_grant(19)(5)); 

Arbiter_19_6 : Arbiter

PORT MAP (Request => Request(6), North => south_2_north(18)(6), West => east_2_west(18)(5), P => Signal_priority(7), Fifo_full => Fifo_full(6),  
South => south_2_north(19)(6), East => east_2_west(19)(6) , Grant => Signal_grant(19)(6)); 

Arbiter_19_7 : Arbiter

PORT MAP (Request => Request(163), North => south_2_north(18)(7), West => east_2_west(18)(6), P => Signal_priority(7), Fifo_full => Fifo_full(7),  
South => south_2_north(19)(7), East => east_2_west(19)(7) , Grant => Signal_grant(19)(7)); 

Arbiter_19_8 : Arbiter

PORT MAP (Request => Request(151), North => south_2_north(18)(8), West => east_2_west(18)(7), P => Signal_priority(7), Fifo_full => Fifo_full(8),  
South => south_2_north(19)(8), East => east_2_west(19)(8) , Grant => Signal_grant(19)(8)); 

Arbiter_19_9 : Arbiter

PORT MAP (Request => Request(139), North => south_2_north(18)(9), West => east_2_west(18)(8), P => Signal_priority(7), Fifo_full => Fifo_full(9),  
South => south_2_north(19)(9), East => east_2_west(19)(9) , Grant => Signal_grant(19)(9)); 

Arbiter_19_10 : Arbiter

PORT MAP (Request => Request(127), North => south_2_north(18)(10), West => east_2_west(18)(9), P => Signal_priority(7), Fifo_full => Fifo_full(10),  
South => south_2_north(19)(10), East => east_2_west(19)(10) , Grant => Signal_grant(19)(10)); 

Arbiter_19_11 : Arbiter

PORT MAP (Request => Request(115), North => south_2_north(18)(11), West => east_2_west(18)(10), P => Signal_priority(7), Fifo_full => Fifo_full(11),  
South => south_2_north(19)(11), East => east_2_west(19)(11) , Grant => Signal_grant(19)(11)); 

Arbiter_19_12 : Arbiter

PORT MAP (Request => Request(103), North => south_2_north(18)(12), West => east_2_west(18)(11), P => Signal_priority(7), Fifo_full => Fifo_full(12),  
South => south_2_north(19)(12), East => east_2_west(19)(12) , Grant => Signal_grant(19)(12)); 

Arbiter_19_13 : Arbiter

PORT MAP (Request => Request(91), North => south_2_north(18)(13), West => east_2_west(18)(12), P => Signal_priority(7), Fifo_full => Fifo_full(13),  
South => south_2_north(19)(13), East => east_2_west(19)(13) , Grant => Signal_grant(19)(13)); 

-------------------------- Diagonale n 20 


Arbiter_20_1 : Arbiter

PORT MAP (Request => Request(79), North => south_2_north(19)(1), West => east_2_west(19)(13), P => Signal_priority(6), Fifo_full => Fifo_full(1),  
South => south_2_north(20)(1), East => east_2_west(20)(1) , Grant => Signal_grant(20)(1)); 

Arbiter_20_2 : Arbiter

PORT MAP (Request => Request(67), North => south_2_north(19)(2), West => east_2_west(19)(1), P => Signal_priority(6), Fifo_full => Fifo_full(2),  
South => south_2_north(20)(2), East => east_2_west(20)(2) , Grant => Signal_grant(20)(2)); 

Arbiter_20_3 : Arbiter

PORT MAP (Request => Request(55), North => south_2_north(19)(3), West => east_2_west(19)(2), P => Signal_priority(6), Fifo_full => Fifo_full(3),  
South => south_2_north(20)(3), East => east_2_west(20)(3) , Grant => Signal_grant(20)(3)); 

Arbiter_20_4 : Arbiter

PORT MAP (Request => Request(43), North => south_2_north(19)(4), West => east_2_west(19)(3), P => Signal_priority(6), Fifo_full => Fifo_full(4),  
South => south_2_north(20)(4), East => east_2_west(20)(4) , Grant => Signal_grant(20)(4)); 

Arbiter_20_5 : Arbiter

PORT MAP (Request => Request(31), North => south_2_north(19)(5), West => east_2_west(19)(4), P => Signal_priority(6), Fifo_full => Fifo_full(5),  
South => south_2_north(20)(5), East => east_2_west(20)(5) , Grant => Signal_grant(20)(5)); 

Arbiter_20_6 : Arbiter

PORT MAP (Request => Request(19), North => south_2_north(19)(6), West => east_2_west(19)(5), P => Signal_priority(6), Fifo_full => Fifo_full(6),  
South => south_2_north(20)(6), East => east_2_west(20)(6) , Grant => Signal_grant(20)(6)); 

Arbiter_20_7 : Arbiter

PORT MAP (Request => Request(7), North => south_2_north(19)(7), West => east_2_west(19)(6), P => Signal_priority(6), Fifo_full => Fifo_full(7),  
South => south_2_north(20)(7), East => east_2_west(20)(7) , Grant => Signal_grant(20)(7)); 

Arbiter_20_8 : Arbiter

PORT MAP (Request => Request(164), North => south_2_north(19)(8), West => east_2_west(19)(7), P => Signal_priority(6), Fifo_full => Fifo_full(8),  
South => south_2_north(20)(8), East => east_2_west(20)(8) , Grant => Signal_grant(20)(8)); 

Arbiter_20_9 : Arbiter

PORT MAP (Request => Request(152), North => south_2_north(19)(9), West => east_2_west(19)(8), P => Signal_priority(6), Fifo_full => Fifo_full(9),  
South => south_2_north(20)(9), East => east_2_west(20)(9) , Grant => Signal_grant(20)(9)); 

Arbiter_20_10 : Arbiter

PORT MAP (Request => Request(140), North => south_2_north(19)(10), West => east_2_west(19)(9), P => Signal_priority(6), Fifo_full => Fifo_full(10),  
South => south_2_north(20)(10), East => east_2_west(20)(10) , Grant => Signal_grant(20)(10)); 

Arbiter_20_11 : Arbiter

PORT MAP (Request => Request(128), North => south_2_north(19)(11), West => east_2_west(19)(10), P => Signal_priority(6), Fifo_full => Fifo_full(11),  
South => south_2_north(20)(11), East => east_2_west(20)(11) , Grant => Signal_grant(20)(11)); 

Arbiter_20_12 : Arbiter

PORT MAP (Request => Request(116), North => south_2_north(19)(12), West => east_2_west(19)(11), P => Signal_priority(6), Fifo_full => Fifo_full(12),  
South => south_2_north(20)(12), East => east_2_west(20)(12) , Grant => Signal_grant(20)(12)); 

Arbiter_20_13 : Arbiter

PORT MAP (Request => Request(104), North => south_2_north(19)(13), West => east_2_west(19)(12), P => Signal_priority(6), Fifo_full => Fifo_full(13),  
South => south_2_north(20)(13), East => east_2_west(20)(13) , Grant => Signal_grant(20)(13)); 

-------------------------- Diagonale n 21 


Arbiter_21_1 : Arbiter

PORT MAP (Request => Request(92), North => south_2_north(20)(1), West => east_2_west(20)(13), P => Signal_priority(5), Fifo_full => Fifo_full(1),  
South => south_2_north(21)(1), East => east_2_west(21)(1) , Grant => Signal_grant(21)(1)); 

Arbiter_21_2 : Arbiter

PORT MAP (Request => Request(80), North => south_2_north(20)(2), West => east_2_west(20)(1), P => Signal_priority(5), Fifo_full => Fifo_full(2),  
South => south_2_north(21)(2), East => east_2_west(21)(2) , Grant => Signal_grant(21)(2)); 

Arbiter_21_3 : Arbiter

PORT MAP (Request => Request(68), North => south_2_north(20)(3), West => east_2_west(20)(2), P => Signal_priority(5), Fifo_full => Fifo_full(3),  
South => south_2_north(21)(3), East => east_2_west(21)(3) , Grant => Signal_grant(21)(3)); 

Arbiter_21_4 : Arbiter

PORT MAP (Request => Request(56), North => south_2_north(20)(4), West => east_2_west(20)(3), P => Signal_priority(5), Fifo_full => Fifo_full(4),  
South => south_2_north(21)(4), East => east_2_west(21)(4) , Grant => Signal_grant(21)(4)); 

Arbiter_21_5 : Arbiter

PORT MAP (Request => Request(44), North => south_2_north(20)(5), West => east_2_west(20)(4), P => Signal_priority(5), Fifo_full => Fifo_full(5),  
South => south_2_north(21)(5), East => east_2_west(21)(5) , Grant => Signal_grant(21)(5)); 

Arbiter_21_6 : Arbiter

PORT MAP (Request => Request(32), North => south_2_north(20)(6), West => east_2_west(20)(5), P => Signal_priority(5), Fifo_full => Fifo_full(6),  
South => south_2_north(21)(6), East => east_2_west(21)(6) , Grant => Signal_grant(21)(6)); 

Arbiter_21_7 : Arbiter

PORT MAP (Request => Request(20), North => south_2_north(20)(7), West => east_2_west(20)(6), P => Signal_priority(5), Fifo_full => Fifo_full(7),  
South => south_2_north(21)(7), East => east_2_west(21)(7) , Grant => Signal_grant(21)(7)); 

Arbiter_21_8 : Arbiter

PORT MAP (Request => Request(8), North => south_2_north(20)(8), West => east_2_west(20)(7), P => Signal_priority(5), Fifo_full => Fifo_full(8),  
South => south_2_north(21)(8), East => east_2_west(21)(8) , Grant => Signal_grant(21)(8)); 

Arbiter_21_9 : Arbiter

PORT MAP (Request => Request(165), North => south_2_north(20)(9), West => east_2_west(20)(8), P => Signal_priority(5), Fifo_full => Fifo_full(9),  
South => south_2_north(21)(9), East => east_2_west(21)(9) , Grant => Signal_grant(21)(9)); 

Arbiter_21_10 : Arbiter

PORT MAP (Request => Request(153), North => south_2_north(20)(10), West => east_2_west(20)(9), P => Signal_priority(5), Fifo_full => Fifo_full(10),  
South => south_2_north(21)(10), East => east_2_west(21)(10) , Grant => Signal_grant(21)(10)); 

Arbiter_21_11 : Arbiter

PORT MAP (Request => Request(141), North => south_2_north(20)(11), West => east_2_west(20)(10), P => Signal_priority(5), Fifo_full => Fifo_full(11),  
South => south_2_north(21)(11), East => east_2_west(21)(11) , Grant => Signal_grant(21)(11)); 

Arbiter_21_12 : Arbiter

PORT MAP (Request => Request(129), North => south_2_north(20)(12), West => east_2_west(20)(11), P => Signal_priority(5), Fifo_full => Fifo_full(12),  
South => south_2_north(21)(12), East => east_2_west(21)(12) , Grant => Signal_grant(21)(12)); 

Arbiter_21_13 : Arbiter

PORT MAP (Request => Request(117), North => south_2_north(20)(13), West => east_2_west(20)(12), P => Signal_priority(5), Fifo_full => Fifo_full(13),  
South => south_2_north(21)(13), East => east_2_west(21)(13) , Grant => Signal_grant(21)(13)); 

-------------------------- Diagonale n 22 


Arbiter_22_1 : Arbiter

PORT MAP (Request => Request(105), North => south_2_north(21)(1), West => east_2_west(21)(13), P => Signal_priority(4), Fifo_full => Fifo_full(1),  
South => south_2_north(22)(1), East => east_2_west(22)(1) , Grant => Signal_grant(22)(1)); 

Arbiter_22_2 : Arbiter

PORT MAP (Request => Request(93), North => south_2_north(21)(2), West => east_2_west(21)(1), P => Signal_priority(4), Fifo_full => Fifo_full(2),  
South => south_2_north(22)(2), East => east_2_west(22)(2) , Grant => Signal_grant(22)(2)); 

Arbiter_22_3 : Arbiter

PORT MAP (Request => Request(81), North => south_2_north(21)(3), West => east_2_west(21)(2), P => Signal_priority(4), Fifo_full => Fifo_full(3),  
South => south_2_north(22)(3), East => east_2_west(22)(3) , Grant => Signal_grant(22)(3)); 

Arbiter_22_4 : Arbiter

PORT MAP (Request => Request(69), North => south_2_north(21)(4), West => east_2_west(21)(3), P => Signal_priority(4), Fifo_full => Fifo_full(4),  
South => south_2_north(22)(4), East => east_2_west(22)(4) , Grant => Signal_grant(22)(4)); 

Arbiter_22_5 : Arbiter

PORT MAP (Request => Request(57), North => south_2_north(21)(5), West => east_2_west(21)(4), P => Signal_priority(4), Fifo_full => Fifo_full(5),  
South => south_2_north(22)(5), East => east_2_west(22)(5) , Grant => Signal_grant(22)(5)); 

Arbiter_22_6 : Arbiter

PORT MAP (Request => Request(45), North => south_2_north(21)(6), West => east_2_west(21)(5), P => Signal_priority(4), Fifo_full => Fifo_full(6),  
South => south_2_north(22)(6), East => east_2_west(22)(6) , Grant => Signal_grant(22)(6)); 

Arbiter_22_7 : Arbiter

PORT MAP (Request => Request(33), North => south_2_north(21)(7), West => east_2_west(21)(6), P => Signal_priority(4), Fifo_full => Fifo_full(7),  
South => south_2_north(22)(7), East => east_2_west(22)(7) , Grant => Signal_grant(22)(7)); 

Arbiter_22_8 : Arbiter

PORT MAP (Request => Request(21), North => south_2_north(21)(8), West => east_2_west(21)(7), P => Signal_priority(4), Fifo_full => Fifo_full(8),  
South => south_2_north(22)(8), East => east_2_west(22)(8) , Grant => Signal_grant(22)(8)); 

Arbiter_22_9 : Arbiter

PORT MAP (Request => Request(9), North => south_2_north(21)(9), West => east_2_west(21)(8), P => Signal_priority(4), Fifo_full => Fifo_full(9),  
South => south_2_north(22)(9), East => east_2_west(22)(9) , Grant => Signal_grant(22)(9)); 

Arbiter_22_10 : Arbiter

PORT MAP (Request => Request(166), North => south_2_north(21)(10), West => east_2_west(21)(9), P => Signal_priority(4), Fifo_full => Fifo_full(10),  
South => south_2_north(22)(10), East => east_2_west(22)(10) , Grant => Signal_grant(22)(10)); 

Arbiter_22_11 : Arbiter

PORT MAP (Request => Request(154), North => south_2_north(21)(11), West => east_2_west(21)(10), P => Signal_priority(4), Fifo_full => Fifo_full(11),  
South => south_2_north(22)(11), East => east_2_west(22)(11) , Grant => Signal_grant(22)(11)); 

Arbiter_22_12 : Arbiter

PORT MAP (Request => Request(142), North => south_2_north(21)(12), West => east_2_west(21)(11), P => Signal_priority(4), Fifo_full => Fifo_full(12),  
South => south_2_north(22)(12), East => east_2_west(22)(12) , Grant => Signal_grant(22)(12)); 

Arbiter_22_13 : Arbiter

PORT MAP (Request => Request(130), North => south_2_north(21)(13), West => east_2_west(21)(12), P => Signal_priority(4), Fifo_full => Fifo_full(13),  
South => south_2_north(22)(13), East => east_2_west(22)(13) , Grant => Signal_grant(22)(13)); 

-------------------------- Diagonale n 23 


Arbiter_23_1 : Arbiter

PORT MAP (Request => Request(118), North => south_2_north(22)(1), West => east_2_west(22)(13), P => Signal_priority(3), Fifo_full => Fifo_full(1),  
South => south_2_north(23)(1), East => east_2_west(23)(1) , Grant => Signal_grant(23)(1)); 

Arbiter_23_2 : Arbiter

PORT MAP (Request => Request(106), North => south_2_north(22)(2), West => east_2_west(22)(1), P => Signal_priority(3), Fifo_full => Fifo_full(2),  
South => south_2_north(23)(2), East => east_2_west(23)(2) , Grant => Signal_grant(23)(2)); 

Arbiter_23_3 : Arbiter

PORT MAP (Request => Request(94), North => south_2_north(22)(3), West => east_2_west(22)(2), P => Signal_priority(3), Fifo_full => Fifo_full(3),  
South => south_2_north(23)(3), East => east_2_west(23)(3) , Grant => Signal_grant(23)(3)); 

Arbiter_23_4 : Arbiter

PORT MAP (Request => Request(82), North => south_2_north(22)(4), West => east_2_west(22)(3), P => Signal_priority(3), Fifo_full => Fifo_full(4),  
South => south_2_north(23)(4), East => east_2_west(23)(4) , Grant => Signal_grant(23)(4)); 

Arbiter_23_5 : Arbiter

PORT MAP (Request => Request(70), North => south_2_north(22)(5), West => east_2_west(22)(4), P => Signal_priority(3), Fifo_full => Fifo_full(5),  
South => south_2_north(23)(5), East => east_2_west(23)(5) , Grant => Signal_grant(23)(5)); 

Arbiter_23_6 : Arbiter

PORT MAP (Request => Request(58), North => south_2_north(22)(6), West => east_2_west(22)(5), P => Signal_priority(3), Fifo_full => Fifo_full(6),  
South => south_2_north(23)(6), East => east_2_west(23)(6) , Grant => Signal_grant(23)(6)); 

Arbiter_23_7 : Arbiter

PORT MAP (Request => Request(46), North => south_2_north(22)(7), West => east_2_west(22)(6), P => Signal_priority(3), Fifo_full => Fifo_full(7),  
South => south_2_north(23)(7), East => east_2_west(23)(7) , Grant => Signal_grant(23)(7)); 

Arbiter_23_8 : Arbiter

PORT MAP (Request => Request(34), North => south_2_north(22)(8), West => east_2_west(22)(7), P => Signal_priority(3), Fifo_full => Fifo_full(8),  
South => south_2_north(23)(8), East => east_2_west(23)(8) , Grant => Signal_grant(23)(8)); 

Arbiter_23_9 : Arbiter

PORT MAP (Request => Request(22), North => south_2_north(22)(9), West => east_2_west(22)(8), P => Signal_priority(3), Fifo_full => Fifo_full(9),  
South => south_2_north(23)(9), East => east_2_west(23)(9) , Grant => Signal_grant(23)(9)); 

Arbiter_23_10 : Arbiter

PORT MAP (Request => Request(10), North => south_2_north(22)(10), West => east_2_west(22)(9), P => Signal_priority(3), Fifo_full => Fifo_full(10),  
South => south_2_north(23)(10), East => east_2_west(23)(10) , Grant => Signal_grant(23)(10)); 

Arbiter_23_11 : Arbiter

PORT MAP (Request => Request(167), North => south_2_north(22)(11), West => east_2_west(22)(10), P => Signal_priority(3), Fifo_full => Fifo_full(11),  
South => south_2_north(23)(11), East => east_2_west(23)(11) , Grant => Signal_grant(23)(11)); 

Arbiter_23_12 : Arbiter

PORT MAP (Request => Request(155), North => south_2_north(22)(12), West => east_2_west(22)(11), P => Signal_priority(3), Fifo_full => Fifo_full(12),  
South => south_2_north(23)(12), East => east_2_west(23)(12) , Grant => Signal_grant(23)(12)); 

Arbiter_23_13 : Arbiter

PORT MAP (Request => Request(143), North => south_2_north(22)(13), West => east_2_west(22)(12), P => Signal_priority(3), Fifo_full => Fifo_full(13),  
South => south_2_north(23)(13), East => east_2_west(23)(13) , Grant => Signal_grant(23)(13)); 

-------------------------- Diagonale n 24 


Arbiter_24_1 : Arbiter

PORT MAP (Request => Request(131), North => south_2_north(23)(1), West => east_2_west(23)(13), P => Signal_priority(2), Fifo_full => Fifo_full(1),  
South => south_2_north(24)(1), East => east_2_west(24)(1) , Grant => Signal_grant(24)(1)); 

Arbiter_24_2 : Arbiter

PORT MAP (Request => Request(119), North => south_2_north(23)(2), West => east_2_west(23)(1), P => Signal_priority(2), Fifo_full => Fifo_full(2),  
South => south_2_north(24)(2), East => east_2_west(24)(2) , Grant => Signal_grant(24)(2)); 

Arbiter_24_3 : Arbiter

PORT MAP (Request => Request(107), North => south_2_north(23)(3), West => east_2_west(23)(2), P => Signal_priority(2), Fifo_full => Fifo_full(3),  
South => south_2_north(24)(3), East => east_2_west(24)(3) , Grant => Signal_grant(24)(3)); 

Arbiter_24_4 : Arbiter

PORT MAP (Request => Request(95), North => south_2_north(23)(4), West => east_2_west(23)(3), P => Signal_priority(2), Fifo_full => Fifo_full(4),  
South => south_2_north(24)(4), East => east_2_west(24)(4) , Grant => Signal_grant(24)(4)); 

Arbiter_24_5 : Arbiter

PORT MAP (Request => Request(83), North => south_2_north(23)(5), West => east_2_west(23)(4), P => Signal_priority(2), Fifo_full => Fifo_full(5),  
South => south_2_north(24)(5), East => east_2_west(24)(5) , Grant => Signal_grant(24)(5)); 

Arbiter_24_6 : Arbiter

PORT MAP (Request => Request(71), North => south_2_north(23)(6), West => east_2_west(23)(5), P => Signal_priority(2), Fifo_full => Fifo_full(6),  
South => south_2_north(24)(6), East => east_2_west(24)(6) , Grant => Signal_grant(24)(6)); 

Arbiter_24_7 : Arbiter

PORT MAP (Request => Request(59), North => south_2_north(23)(7), West => east_2_west(23)(6), P => Signal_priority(2), Fifo_full => Fifo_full(7),  
South => south_2_north(24)(7), East => east_2_west(24)(7) , Grant => Signal_grant(24)(7)); 

Arbiter_24_8 : Arbiter

PORT MAP (Request => Request(47), North => south_2_north(23)(8), West => east_2_west(23)(7), P => Signal_priority(2), Fifo_full => Fifo_full(8),  
South => south_2_north(24)(8), East => east_2_west(24)(8) , Grant => Signal_grant(24)(8)); 

Arbiter_24_9 : Arbiter

PORT MAP (Request => Request(35), North => south_2_north(23)(9), West => east_2_west(23)(8), P => Signal_priority(2), Fifo_full => Fifo_full(9),  
South => south_2_north(24)(9), East => east_2_west(24)(9) , Grant => Signal_grant(24)(9)); 

Arbiter_24_10 : Arbiter

PORT MAP (Request => Request(23), North => south_2_north(23)(10), West => east_2_west(23)(9), P => Signal_priority(2), Fifo_full => Fifo_full(10),  
South => south_2_north(24)(10), East => east_2_west(24)(10) , Grant => Signal_grant(24)(10)); 

Arbiter_24_11 : Arbiter

PORT MAP (Request => Request(11), North => south_2_north(23)(11), West => east_2_west(23)(10), P => Signal_priority(2), Fifo_full => Fifo_full(11),  
South => south_2_north(24)(11), East => east_2_west(24)(11) , Grant => Signal_grant(24)(11)); 

Arbiter_24_12 : Arbiter

PORT MAP (Request => Request(168), North => south_2_north(23)(12), West => east_2_west(23)(11), P => Signal_priority(2), Fifo_full => Fifo_full(12),  
South => south_2_north(24)(12), East => east_2_west(24)(12) , Grant => Signal_grant(24)(12)); 

Arbiter_24_13 : Arbiter

PORT MAP (Request => Request(156), North => south_2_north(23)(13), West => east_2_west(23)(12), P => Signal_priority(2), Fifo_full => Fifo_full(13),  
South => south_2_north(24)(13), East => east_2_west(24)(13) , Grant => Signal_grant(24)(13)); 

-------------------------- Diagonale n 25 


Arbiter_25_1 : Arbiter

PORT MAP (Request => Request(144), North => south_2_north(24)(1), West => east_2_west(24)(13), P => Signal_priority(1), Fifo_full => Fifo_full(1),  
South => south_2_north(25)(1), East => east_2_west(25)(1) , Grant => Signal_grant(25)(1)); 

Arbiter_25_2 : Arbiter

PORT MAP (Request => Request(132), North => south_2_north(24)(2), West => east_2_west(24)(1), P => Signal_priority(1), Fifo_full => Fifo_full(2),  
South => south_2_north(25)(2), East => east_2_west(25)(2) , Grant => Signal_grant(25)(2)); 

Arbiter_25_3 : Arbiter

PORT MAP (Request => Request(120), North => south_2_north(24)(3), West => east_2_west(24)(2), P => Signal_priority(1), Fifo_full => Fifo_full(3),  
South => south_2_north(25)(3), East => east_2_west(25)(3) , Grant => Signal_grant(25)(3)); 

Arbiter_25_4 : Arbiter

PORT MAP (Request => Request(108), North => south_2_north(24)(4), West => east_2_west(24)(3), P => Signal_priority(1), Fifo_full => Fifo_full(4),  
South => south_2_north(25)(4), East => east_2_west(25)(4) , Grant => Signal_grant(25)(4)); 

Arbiter_25_5 : Arbiter

PORT MAP (Request => Request(96), North => south_2_north(24)(5), West => east_2_west(24)(4), P => Signal_priority(1), Fifo_full => Fifo_full(5),  
South => south_2_north(25)(5), East => east_2_west(25)(5) , Grant => Signal_grant(25)(5)); 

Arbiter_25_6 : Arbiter

PORT MAP (Request => Request(84), North => south_2_north(24)(6), West => east_2_west(24)(5), P => Signal_priority(1), Fifo_full => Fifo_full(6),  
South => south_2_north(25)(6), East => east_2_west(25)(6) , Grant => Signal_grant(25)(6)); 

Arbiter_25_7 : Arbiter

PORT MAP (Request => Request(72), North => south_2_north(24)(7), West => east_2_west(24)(6), P => Signal_priority(1), Fifo_full => Fifo_full(7),  
South => south_2_north(25)(7), East => east_2_west(25)(7) , Grant => Signal_grant(25)(7)); 

Arbiter_25_8 : Arbiter

PORT MAP (Request => Request(60), North => south_2_north(24)(8), West => east_2_west(24)(7), P => Signal_priority(1), Fifo_full => Fifo_full(8),  
South => south_2_north(25)(8), East => east_2_west(25)(8) , Grant => Signal_grant(25)(8)); 

Arbiter_25_9 : Arbiter

PORT MAP (Request => Request(48), North => south_2_north(24)(9), West => east_2_west(24)(8), P => Signal_priority(1), Fifo_full => Fifo_full(9),  
South => south_2_north(25)(9), East => east_2_west(25)(9) , Grant => Signal_grant(25)(9)); 

Arbiter_25_10 : Arbiter

PORT MAP (Request => Request(36), North => south_2_north(24)(10), West => east_2_west(24)(9), P => Signal_priority(1), Fifo_full => Fifo_full(10),  
South => south_2_north(25)(10), East => east_2_west(25)(10) , Grant => Signal_grant(25)(10)); 

Arbiter_25_11 : Arbiter

PORT MAP (Request => Request(24), North => south_2_north(24)(11), West => east_2_west(24)(10), P => Signal_priority(1), Fifo_full => Fifo_full(11),  
South => south_2_north(25)(11), East => east_2_west(25)(11) , Grant => Signal_grant(25)(11)); 

Arbiter_25_12 : Arbiter

PORT MAP (Request => Request(12), North => south_2_north(24)(12), West => east_2_west(24)(11), P => Signal_priority(1), Fifo_full => Fifo_full(12),  
South => south_2_north(25)(12), East => east_2_west(25)(12) , Grant => Signal_grant(25)(12)); 

Arbiter_25_13 : Arbiter

PORT MAP (Request => Request(169), North => south_2_north(24)(13), West => east_2_west(24)(12), P => Signal_priority(1), Fifo_full => Fifo_full(13),  
South => south_2_north(25)(13), East => east_2_west(25)(13) , Grant => Signal_grant(25)(13)); 


--processus permettant de roter la priorit des diagonales  chaque front d'horloge
 -- rotation round robin
	 round_robin : process(clk)
	begin
		if rising_edge(clk) then
		 if reset ='1' then
		    Signal_priority <= "1111111111111000000000000";
		  elsif priority_rotation_en = '1' then 
 		    case Signal_priority is
		       when "1111111111111000000000000" => Signal_priority <= "0111111111111100000000000";
		       when "0111111111111100000000000" => Signal_priority <= "0011111111111110000000000";
		       when "0011111111111110000000000" => Signal_priority <= "0001111111111111000000000";
		       when "0001111111111111000000000" => Signal_priority <= "0000111111111111100000000";
		       when "0000111111111111100000000" => Signal_priority <= "0000011111111111110000000";
		       when "0000011111111111110000000" => Signal_priority <= "0000001111111111111000000";
		       when "0000001111111111111000000" => Signal_priority <= "0000000111111111111100000";
		       when "0000000111111111111100000" => Signal_priority <= "0000000011111111111110000";
		       when "0000000011111111111110000" => Signal_priority <= "0000000001111111111111000";
		       when "0000000001111111111111000" => Signal_priority <= "0000000000111111111111100";
		       when "0000000000111111111111100" => Signal_priority <= "0000000000011111111111110";
		       when "0000000000011111111111110" => Signal_priority <= "0000000000001111111111111";
		       when "0000000000001111111111111" => Signal_priority <= "1111111111111000000000000";
		       when others    => Signal_priority <= "1111111111111000000000000";
		  end case;
		 end if;
	     end if;
	 end process;

end Behavioral;

