----------------------------------------------------------------------------------
-- Company: ENSET 2011
-- Engineer: GAMOM NGOUNOU
-- 
-- Create Date:    03:40:47 11/19/2011 
-- Design Name: 
-- Module Name:    SWITCH_GEN - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- fichier principal du switch gnrique; en fonction du parametre generique le 
-- les directive de generation conditionnelle permettent de ne gnrer et synthtiser uniquement  la logique 
-- ncessaire  l'implmentation  du switch de la dimension voulue
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.Coretypes.all ;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity SWITCH_GEN is 
 --type portio is array(positive range) of std_logic_vector (7 downto 0);    
 generic(number_of_ports : positive := 4);
     port(
	        -- ports d'entree
           Port_in : in typ_portIO(1 to number_of_ports) ;
--			  Port1_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port2_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port3_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port4_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--			  Port5_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port6_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port7_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port8_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--			  Port9_in : in  STD_LOGIC_VECTOR  (7 downto 0);
--           Port10_in : in  STD_LOGIC_VECTOR (7 downto 0);
--           Port11_in : in  STD_LOGIC_VECTOR (7 downto 0);
--           Port12_in : in  STD_LOGIC_VECTOR (7 downto 0);
--			  Port13_in : in  STD_LOGIC_VECTOR (7 downto 0);
--           Port14_in : in  STD_LOGIC_VECTOR (7 downto 0);
--           Port15_in : in  STD_LOGIC_VECTOR (7 downto 0);
--           Port16_in : in  STD_LOGIC_VECTOR (7 downto 0);
			 
			  -- port de sortie
			  Port_out : out  typ_portIO(1 to number_of_ports);
--			  Port1_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port2_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port3_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port4_out : out  STD_LOGIC_VECTOR (7 downto 0);
--			  Port5_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port6_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port7_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port8_out : out  STD_LOGIC_VECTOR (7 downto 0);
--			  Port9_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port10_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port11_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port12_out : out  STD_LOGIC_VECTOR (7 downto 0);
--			  Port13_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port14_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port15_out : out  STD_LOGIC_VECTOR (7 downto 0);
--           Port16_out : out  STD_LOGIC_VECTOR (7 downto 0);
			  -- signaux de controle
			  data_in_en : in std_logic_vector(number_of_ports downto 1);
			  cmd_in_en :  in std_logic_vector(number_of_ports downto 1);
			  data_out_en : in std_logic_vector(number_of_ports downto 1);
			  fifo_in_full : out std_logic_vector(number_of_ports downto 1);
			  fifo_in_empty : out std_logic_vector(number_of_ports downto 1);
			  data_available : out std_logic_vector(number_of_ports downto 1);
			  clk       : in   STD_LOGIC;
			  reset     : in   STD_LOGIC);
end SWITCH_GEN;

architecture Behavioral of SWITCH_GEN is
-- declaration des modules du switch generique
-- le module de gestion des ports d'entre

COMPONENT INPUT_PORT_MODULE
  generic(number_of_ports : positive := 4;
			Port_num: natural);
    Port ( data_in : in  STD_LOGIC_VECTOR (7 downto 0);
           data_in_en : in  STD_LOGIC;
			  cmd_in_en : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  clk   : in  STD_LOGIC;
			  request : out  STD_LOGIC_VECTOR (number_of_ports downto 1);
           grant : in  STD_LOGIC_VECTOR (number_of_ports  downto 1);			  
           fifo_full : out  STD_LOGIC;
			  fifo_empty : out  STD_LOGIC;
			  priority_rotation : out std_logic;
           data_out : out  STD_LOGIC_VECTOR (7 downto 0);
			  data_out_pulse : out std_logic);
END COMPONENT;

-- le module des ports de sortie

COMPONENT OUTPUT_PORT_MODULE
	PORT(
		data_in : IN std_logic_vector(7 downto 0);
		reset : IN std_logic;
		clk : IN std_logic;
		wr_en : IN std_logic;
		rd_out_en : IN std_logic;          
		data_out : OUT std_logic_vector(7 downto 0);
		fifo_full : OUT std_logic;
		data_avalaible : OUT std_logic
		);
END COMPONENT;
	
-- le module du crossbar
COMPONENT Crossbar
 generic
	      (
			  number_of_crossbar_ports: positive := 4
			);
    Port ( 
	        --Port_in : in Typ_PortIO(1 to number_of_crossbar_ports);
			  Port1_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port2_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port3_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port4_in : in  STD_LOGIC_VECTOR (7 downto 0);
			  Port5_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port6_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port7_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port8_in : in  STD_LOGIC_VECTOR (7 downto 0);
			  Port9_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port10_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port11_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port12_in : in  STD_LOGIC_VECTOR (7 downto 0);
			  Port13_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port14_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port15_in : in  STD_LOGIC_VECTOR (7 downto 0);
           Port16_in : in  STD_LOGIC_VECTOR (7 downto 0);
			  
			  --Port_pulse_in : in std_logic_vector(1 to number_of_ports);
			  Port1_pulse_in : in std_logic;
			  Port2_pulse_in : in std_logic;
			  Port3_pulse_in : in std_logic;
			  Port4_pulse_in : in std_logic;
			  Port5_pulse_in : in std_logic;
			  Port6_pulse_in : in std_logic;
			  Port7_pulse_in : in std_logic;
			  Port8_pulse_in : in std_logic;
			  Port9_pulse_in : in std_logic;
			  Port10_pulse_in : in std_logic;
			  Port11_pulse_in : in std_logic;
			  Port12_pulse_in : in std_logic;
			  Port13_pulse_in : in std_logic;
			  Port14_pulse_in : in std_logic;
			  Port15_pulse_in : in std_logic;
			  Port16_pulse_in : in std_logic;
			  
			  --Port_pulse_out : in std_logic_vector(1 to number_of_ports);
			  Port1_pulse_out : out std_logic;
			  Port2_pulse_out : out std_logic;
			  Port3_pulse_out : out std_logic;
			  Port4_pulse_out : out std_logic;
			  Port5_pulse_out : out std_logic;
			  Port6_pulse_out : out std_logic;
			  Port7_pulse_out : out std_logic;
			  Port8_pulse_out : out std_logic;
			  Port9_pulse_out : out std_logic;
			  Port10_pulse_out : out std_logic;
			  Port11_pulse_out : out std_logic;
			  Port12_pulse_out : out std_logic;
			  Port13_pulse_out : out std_logic;
			  Port14_pulse_out : out std_logic;
			  Port15_pulse_out : out std_logic;
			  Port16_pulse_out : out std_logic;
			  
			  --Port_out : out Typ_PortIO(1 to number_of_crossbar_ports);
			  Port1_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port2_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port3_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port4_out : out  STD_LOGIC_VECTOR (7 downto 0); 
			  Port5_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port6_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port7_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port8_out : out  STD_LOGIC_VECTOR (7 downto 0); 
			  Port9_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port10_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port11_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port12_out : out  STD_LOGIC_VECTOR (7 downto 0); 
			  Port13_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port14_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port15_out : out  STD_LOGIC_VECTOR (7 downto 0);
           Port16_out : out  STD_LOGIC_VECTOR (7 downto 0); 
			  
           Ctrl : in  STD_LOGIC_VECTOR (number_of_crossbar_ports*number_of_crossbar_ports downto 1)
       ); 
 END COMPONENT;

-- dclaration du  scheduler
COMPONENT Scheduler
	generic(number_of_ports : positive := 4);
    Port ( Request : in  STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1);
			  Fifo_full : in STD_LOGIC_VECTOR (number_of_ports downto 1);
           clk : in  STD_LOGIC;
	        reset : in  STD_LOGIC;
			  priority_rotation : in  STD_LOGIC_VECTOR (number_of_ports downto 1);
           port_grant : out  STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1));
END COMPONENT;

--declaration des signaux de connection entre les modules du switch
--type port_connection_type is array(16 downto 1) of std_logic_vector(7 downto 1);
--signal crossbar_port_in_connetion : port_connection_type;
--signal crossbar_port_out_connetion :port_connection_type;
--signal request_connection : std_logic_vector(number_of_ports*number_of_ports downto 1);
--signal grant_connection : std_logic_vector(number_of_ports*number_of_ports downto 1);
--signal priority_rotation_connection : std_logic_vector(number_of_ports downto 1);
--signal fifo_out_full_connection : std_logic_vector(1 to number_of_ports);
--signal crossbar_in_pulse(_connection : std_logic_vector(number_of_ports downto 1);
--signal crossbar_out_pulse_connection : std_logic_vector(number_of_ports downto 1);
--variable i,j : integer;

Signal Request_signal : STD_LOGIC_VECTOR(number_of_ports*number_of_ports downto 1);
Signal grant_signal : STD_LOGIC_VECTOR(number_of_ports*number_of_ports downto 1);
Signal priority_rotation_signal : STD_LOGIC_VECTOR(number_of_ports downto 1);
signal fifo_out_full_signal : std_logic_vector(number_of_ports downto 1);

signal crossbar_in_port :  Typ_PortIO(1 to number_of_ports);

--signal crossbar_in_port1 : std_logic_vector(7 downto 0);
--signal crossbar_in_port2 : std_logic_vector(7 downto 0);
--signal crossbar_in_port3 : std_logic_vector(7 downto 0);
--signal crossbar_in_port4 : std_logic_vector(7 downto 0);
--signal crossbar_in_port5 : std_logic_vector(7 downto 0);
--signal crossbar_in_port6 : std_logic_vector(7 downto 0);
--signal crossbar_in_port7 : std_logic_vector(7 downto 0);
--signal crossbar_in_port8 : std_logic_vector(7 downto 0);
--signal crossbar_in_port9 : std_logic_vector(7 downto 0);
--signal crossbar_in_port10 : std_logic_vector(7 downto 0);
--signal crossbar_in_port11 : std_logic_vector(7 downto 0);
--signal crossbar_in_port12 : std_logic_vector(7 downto 0);
--signal crossbar_in_port13 : std_logic_vector(7 downto 0);
--signal crossbar_in_port14 : std_logic_vector(7 downto 0);
--signal crossbar_in_port15 : std_logic_vector(7 downto 0);
--signal crossbar_in_port16 : std_logic_vector(7 downto 0);

signal crossbar_out_port  :  Typ_PortIO(1 to number_of_ports);
--signal crossbar_out_port1 : std_logic_vector(7 downto 0);
--signal crossbar_out_port2 : std_logic_vector(7 downto 0);
--signal crossbar_out_port3 : std_logic_vector(7 downto 0);
--signal crossbar_out_port4 : std_logic_vector(7 downto 0);
--signal crossbar_out_port5 : std_logic_vector(7 downto 0);
--signal crossbar_out_port6 : std_logic_vector(7 downto 0);
--signal crossbar_out_port7 : std_logic_vector(7 downto 0);
--signal crossbar_out_port8 : std_logic_vector(7 downto 0);
--signal crossbar_out_port9 : std_logic_vector(7 downto 0);
--signal crossbar_out_port10 : std_logic_vector(7 downto 0);
--signal crossbar_out_port11 : std_logic_vector(7 downto 0);
--signal crossbar_out_port12 : std_logic_vector(7 downto 0);
--signal crossbar_out_port13 : std_logic_vector(7 downto 0);
--signal crossbar_out_port14 : std_logic_vector(7 downto 0);
--signal crossbar_out_port15 : std_logic_vector(7 downto 0);
--signal crossbar_out_port16 : std_logic_vector(7 downto 0);

signal crossbar_in_pulse  : std_logic_vector(number_of_ports downto 1);
--signal crossbar_in_pulse1 : std_logic;
--signal crossbar_in_pulse2 : std_logic;
--signal crossbar_in_pulse3 : std_logic;
--signal crossbar_in_pulse4 : std_logic;
--signal crossbar_in_pulse5 : std_logic;
--signal crossbar_in_pulse6 : std_logic;
--signal crossbar_in_pulse7 : std_logic;
--signal crossbar_in_pulse8 : std_logic;
--signal crossbar_in_pulse9 : std_logic;
--signal crossbar_in_pulse10 : std_logic;
--signal crossbar_in_pulse11 : std_logic;
--signal crossbar_in_pulse12 : std_logic;
--signal crossbar_in_pulse13 : std_logic;
--signal crossbar_in_pulse14 : std_logic;
--signal crossbar_in_pulse15 : std_logic;
--signal crossbar_in_pulse16 : std_logic;

signal crossbar_out_pulse  : std_logic_vector(number_of_ports downto 1);
--signal crossbar_out_pulse1 : std_logic;
--signal crossbar_out_pulse2 : std_logic;
--signal crossbar_out_pulse3 : std_logic;
--signal crossbar_out_pulse4 : std_logic;
--signal crossbar_out_pulse5 : std_logic;
--signal crossbar_out_pulse6 : std_logic;
--signal crossbar_out_pulse7 : std_logic;
--signal crossbar_out_pulse8 : std_logic;
--signal crossbar_out_pulse9 : std_logic;
--signal crossbar_out_pulse10 : std_logic;
--signal crossbar_out_pulse11 : std_logic;
--signal crossbar_out_pulse12 : std_logic;
--signal crossbar_out_pulse13 : std_logic;
--signal crossbar_out_pulse14 : std_logic;
--signal crossbar_out_pulse15 : std_logic;
--signal crossbar_out_pulse16 : std_logic;


begin
-- intstanciation et connexion des modules du switch en fonction du nombre de ports
-- le circuit genere depend du parametre generique nombre de ports
-- switch 2 ports
switch2x2 : if number_of_ports = 2 generate

PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>2,Port_num=>1)
PORT MAP(
   data_in => Port_in(1),
   data_in_en => data_in_en(1),
	cmd_in_en => cmd_in_en(1),
   reset => reset,
   clk =>clk,
   grant(1) => grant_signal(1),
   grant(2) => grant_signal(2),
   fifo_full =>fifo_in_full(1),
   priority_rotation =>  priority_rotation_signal(1),
   fifo_empty => fifo_in_empty(1),
   data_out =>crossbar_in_port(1),
   data_out_pulse =>crossbar_in_pulse(1),
   request(1) =>request_signal(1),
   request(2) =>request_signal(2)
);

PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>2,Port_num=>2)
PORT MAP(
   data_in => Port_in(2),
   data_in_en => data_in_en(2),
	cmd_in_en => cmd_in_en(2),
   reset => reset,
   clk =>clk,
   grant(1) => grant_signal(3),
   grant(2) => grant_signal(4),
   fifo_full =>fifo_in_full(2),
   priority_rotation =>  priority_rotation_signal(2),
   fifo_empty => fifo_in_empty(2),
   data_out =>crossbar_in_port(2),
   data_out_pulse =>crossbar_in_pulse(2),
   request(1) =>request_signal(3),
   request(2) =>request_signal(4)
);

end generate switch2x2;


-- switch 3 ports
switch3x3 : if number_of_ports = 3 generate

PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>3,Port_num=>1)
PORT MAP(
   data_in => Port_in(1),
   data_in_en => data_in_en(1),
	cmd_in_en => cmd_in_en(1),
   reset => reset,
   clk =>clk,
   grant(1) => grant_signal(1),
   grant(2) => grant_signal(2),
   grant(3) => grant_signal(3),
   fifo_full =>fifo_in_full(1),
   priority_rotation =>  priority_rotation_signal(1),
   fifo_empty => fifo_in_empty(1),
   data_out =>crossbar_in_port(1),
   data_out_pulse =>crossbar_in_pulse(1),
   request(1) =>request_signal(1),
   request(2) =>request_signal(2),
   request(3) =>request_signal(3)
);

PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>3,Port_num=>2)
PORT MAP(
   data_in => Port_in(2),
   data_in_en => data_in_en(2),
	cmd_in_en => cmd_in_en(2),
   reset => reset,
   clk =>clk,
   grant(4) => grant_signal(4),
   grant(5) => grant_signal(5),
   grant(6) => grant_signal(6),
   fifo_full =>fifo_in_full(2),
   priority_rotation =>  priority_rotation_signal(2),
   fifo_empty => fifo_in_empty(2),
   data_out =>crossbar_in_port(2),
   data_out_pulse =>crossbar_in_pulse(2),
   request(4) =>request_signal(4),
   request(5) =>request_signal(5),
   request(6) =>request_signal(6)
);

PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>3,Port_num=>3)
PORT MAP(
   data_in => Port_in(3),
   data_in_en => data_in_en(3),
	cmd_in_en => cmd_in_en(3),
   reset => reset,
   clk =>clk,
   grant(7) => grant_signal(7),
   grant(8) => grant_signal(8),
   grant(9) => grant_signal(9),
   fifo_full =>fifo_in_full(3),
   priority_rotation =>  priority_rotation_signal(3),
   fifo_empty => fifo_in_empty(3),
   data_out =>crossbar_in_port(3),
   data_out_pulse =>crossbar_in_pulse(3),
   request(7) =>request_signal(7),
   request(8) =>request_signal(8),
   request(9) =>request_signal(9)
);

end generate switch3x3;


-- switch 4  7 ports
switch4x4_7x7 : if number_of_ports >= 4 and number_of_ports <=7 generate

switch_4x4_7x7:for i in 1 to number_of_ports generate

constant j: natural:=number_of_ports*(i-1);
begin
--j=number_of_ports*(i-1);
PORTx4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>4,Port_num=>i)
PORT MAP(
   data_in => Port_in(i),
   data_in_en => data_in_en(i),
	cmd_in_en => cmd_in_en(i),
   reset => reset,
   clk =>clk,
	grant =>grant_signal(j+NUMBER_OF_PORTS downto j+1),
 
   fifo_full =>fifo_in_full(i),
   priority_rotation =>  priority_rotation_signal(i),
   fifo_empty => fifo_in_empty(i),
   data_out =>crossbar_in_port(i),
   data_out_pulse =>crossbar_in_pulse(i),
	request =>request_signal(j+NUMBER_OF_PORTS downto j+1)
   
);
end generate switch_4x4_7x7;
end generate switch4x4_7x7;


---- switch 5 ports
--switch5x5 : if number_of_ports = 5 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>5)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>5)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(6),
--   grant(2) => grant_signal(7),
--   grant(3) => grant_signal(8),
--   grant(4) => grant_signal(9),
--   grant(5) => grant_signal(10),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>5)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(11) => grant_signal(11),
--   grant(12) => grant_signal(12),
--   grant(13) => grant_signal(13),
--   grant(14) => grant_signal(14),
--   grant(15) => grant_signal(15),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(11) =>request_signal(11),
--   request(12) =>request_signal(12),
--   request(13) =>request_signal(13),
--   request(14) =>request_signal(14),
--   request(15) =>request_signal(15)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>5)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(16) => grant_signal(16),
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(16) =>request_signal(16),
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>5)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(21) => grant_signal(21),
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   grant(25) => grant_signal(25),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(21) =>request_signal(21),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24),
--   request(25) =>request_signal(25)
--);
--
--end generate switch5x5;
--
--
---- switch 6 ports
--switch6x6 : if number_of_ports = 6 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>6)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--	cmd_in_en => cmd_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>6)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(7),
--   grant(2) => grant_signal(8),
--   grant(3) => grant_signal(9),
--   grant(4) => grant_signal(10),
--   grant(5) => grant_signal(11),
--   grant(6) => grant_signal(12),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(1) =>request_signal(7),
--   request(2) =>request_signal(8),
--   request(3) =>request_signal(9),
--   request(4) =>request_signal(10),
--   request(5) =>request_signal(11),
--   request(6) =>request_signal(12)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>6)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(13) => grant_signal(13),
--   grant(14) => grant_signal(14),
--   grant(15) => grant_signal(15),
--   grant(16) => grant_signal(16),
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(13) =>request_signal(13),
--   request(14) =>request_signal(14),
--   request(15) =>request_signal(15),
--   request(16) =>request_signal(16),
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>6)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--	cmd_in_en => cmd_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   grant(21) => grant_signal(21),
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20),
--   request(21) =>request_signal(21),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>6)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--	cmd_in_en => cmd_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(25) => grant_signal(25),
--   grant(26) => grant_signal(26),
--   grant(27) => grant_signal(27),
--   grant(28) => grant_signal(28),
--   grant(29) => grant_signal(29),
--   grant(30) => grant_signal(30),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(25) =>request_signal(25),
--   request(26) =>request_signal(26),
--   request(27) =>request_signal(27),
--   request(28) =>request_signal(28),
--   request(29) =>request_signal(29),
--   request(30) =>request_signal(30)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>6)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(31) => grant_signal(31),
--   grant(32) => grant_signal(32),
--   grant(33) => grant_signal(33),
--   grant(34) => grant_signal(34),
--   grant(35) => grant_signal(35),
--   grant(36) => grant_signal(36),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(31) =>request_signal(31),
--   request(32) =>request_signal(32),
--   request(33) =>request_signal(33),
--   request(34) =>request_signal(34),
--   request(35) =>request_signal(35),
--   request(36) =>request_signal(36)
--);
--
--end generate switch6x6;
--
--
---- switch 7 ports
--switch7x7 : if number_of_ports = 7 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--	cmd_in_en => cmd_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(8),
--   grant(2) => grant_signal(9),
--   grant(3) => grant_signal(10),
--   grant(4) => grant_signal(11),
--   grant(5) => grant_signal(12),
--   grant(6) => grant_signal(13),
--   grant(7) => grant_signal(14),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10),
--   request(11) =>request_signal(11),
--   request(12) =>request_signal(12),
--   request(13) =>request_signal(13),
--   request(14) =>request_signal(14)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(15) => grant_signal(15),
--   grant(16) => grant_signal(16),
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   grant(21) => grant_signal(21),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(15) =>request_signal(15),
--   request(16) =>request_signal(16),
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20),
--   request(21) =>request_signal(21)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   grant(25) => grant_signal(25),
--   grant(26) => grant_signal(26),
--   grant(27) => grant_signal(27),
--   grant(28) => grant_signal(28),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24),
--   request(25) =>request_signal(25),
--   request(26) =>request_signal(26),
--   request(27) =>request_signal(27),
--   request(28) =>request_signal(28)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(29) => grant_signal(29),
--   grant(30) => grant_signal(30),
--   grant(31) => grant_signal(31),
--   grant(32) => grant_signal(32),
--   grant(33) => grant_signal(33),
--   grant(34) => grant_signal(34),
--   grant(35) => grant_signal(35),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(29) =>request_signal(29),
--   request(30) =>request_signal(30),
--   request(31) =>request_signal(31),
--   request(32) =>request_signal(32),
--   request(33) =>request_signal(33),
--   request(34) =>request_signal(34),
--   request(35) =>request_signal(35)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(36) => grant_signal(36),
--   grant(37) => grant_signal(37),
--   grant(38) => grant_signal(38),
--   grant(39) => grant_signal(39),
--   grant(40) => grant_signal(40),
--   grant(41) => grant_signal(41),
--   grant(42) => grant_signal(42),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(36) =>request_signal(36),
--   request(37) =>request_signal(37),
--   request(38) =>request_signal(38),
--   request(39) =>request_signal(39),
--   request(40) =>request_signal(40),
--   request(41) =>request_signal(41),
--   request(42) =>request_signal(42)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>7)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(43) => grant_signal(43),
--   grant(44) => grant_signal(44),
--   grant(45) => grant_signal(45),
--   grant(46) => grant_signal(46),
--   grant(47) => grant_signal(47),
--   grant(48) => grant_signal(48),
--   grant(49) => grant_signal(49),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(43) =>request_signal(43),
--   request(44) =>request_signal(44),
--   request(45) =>request_signal(45),
--   request(46) =>request_signal(46),
--   request(47) =>request_signal(47),
--   request(48) =>request_signal(48),
--   request(49) =>request_signal(49)
--);
--
--end generate switch7x7;


-- switch 8 ports
switch8x8 : if number_of_ports = 8 generate
switch_8x8:for i in 1 to number_of_ports generate
constant j: natural:=number_of_ports*(i-1);
begin
--j<=number_of_ports*(i-1);
PORTx8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>8,Port_num=>i)
PORT MAP(
   data_in => Port_in(i),
   data_in_en => data_in_en(i),
	cmd_in_en => cmd_in_en(i),
   reset => reset,
   clk =>clk,
	grant =>grant_signal(j+NUMBER_OF_PORTS downto j+1),
   fifo_full =>fifo_in_full(i),
   priority_rotation =>  priority_rotation_signal(i),
   fifo_empty => fifo_in_empty(i),
   data_out =>crossbar_in_port(i),
   data_out_pulse =>crossbar_in_pulse(i),

	request =>request_signal(j+NUMBER_OF_PORTS downto j+1)
);
end generate switch_8x8;
end generate switch8x8;

-- switch 9 ports
switch9x9_to_15 : if (number_of_ports >= 9)and (number_of_ports <= 15) generate

switch_9x9_to_15:for i in 1 to number_of_ports generate

constant j: natural:=number_of_ports*(i-1);
begin

PORTx9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>NUMBER_OF_PORTS,Port_num=>i)
PORT MAP(
   data_in => Port_in(i),
   data_in_en => data_in_en(i),
	cmd_in_en => cmd_in_en(i),
   reset => reset,
   clk =>clk,
   grant => grant_signal(j+NUMBER_OF_PORTS downto j+1),
   fifo_full =>fifo_in_full(i),
   priority_rotation =>  priority_rotation_signal(i),
   fifo_empty => fifo_in_empty(i),
   data_out =>crossbar_in_port(i),
   data_out_pulse =>crossbar_in_pulse(i),

	request =>request_signal(j+NUMBER_OF_PORTS downto j+1)
);
end generate switch_9x9_to_15;
end generate switch9x9_to_15;



-- switch 10 ports
--switch10x10 : if number_of_ports = 10 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   grant(8) => grant_signal(8),
--   grant(9) => grant_signal(9),
--   grant(10) => grant_signal(10),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(11),
--   grant(2) => grant_signal(12),
--   grant(3) => grant_signal(13),
--   grant(4) => grant_signal(14),
--   grant(5) => grant_signal(15),
--   grant(6) => grant_signal(16),
--   grant(7) => grant_signal(17),
--   grant(8) => grant_signal(18),
--   grant(9) => grant_signal(19),
--   grant(10) => grant_signal(20),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(1) =>request_signal(11),
--   request(2) =>request_signal(12),
--   request(3) =>request_signal(13),
--   request(4) =>request_signal(14),
--   request(5) =>request_signal(15),
--   request(6) =>request_signal(16),
--   request(7) =>request_signal(17),
--   request(8) =>request_signal(18),
--   request(9) =>request_signal(19),
--   request(10) =>request_signal(20)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(21),
--   grant(2) => grant_signal(22),
--   grant(3) => grant_signal(23),
--   grant(4) => grant_signal(24),
--   grant(5) => grant_signal(25),
--   grant(6) => grant_signal(26),
--   grant(7) => grant_signal(27),
--   grant(8) => grant_signal(28),
--   grant(9) => grant_signal(29),
--   grant(10) => grant_signal(30),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(1) =>request_signal(21),
--   request(2) =>request_signal(22),
--   request(3) =>request_signal(23),
--   request(4) =>request_signal(24),
--   request(5) =>request_signal(25),
--   request(6) =>request_signal(26),
--   request(7) =>request_signal(27),
--   request(8) =>request_signal(28),
--   request(9) =>request_signal(29),
--   request(10) =>request_signal(30)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(31),
--   grant(2) => grant_signal(32),
--   grant(3) => grant_signal(33),
--   grant(4) => grant_signal(34),
--   grant(5) => grant_signal(35),
--   grant(6) => grant_signal(36),
--   grant(7) => grant_signal(37),
--   grant(8) => grant_signal(38),
--   grant(9) => grant_signal(39),
--   grant(10) => grant_signal(40),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(1) =>request_signal(31),
--   request(2) =>request_signal(32),
--   request(3) =>request_signal(33),
--   request(4) =>request_signal(34),
--   request(5) =>request_signal(35),
--   request(6) =>request_signal(36),
--   request(7) =>request_signal(37),
--   request(8) =>request_signal(38),
--   request(9) =>request_signal(39),
--   request(10) =>request_signal(40)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(41),
--   grant(2) => grant_signal(42),
--   grant(3) => grant_signal(43),
--   grant(4) => grant_signal(44),
--   grant(5) => grant_signal(45),
--   grant(6) => grant_signal(46),
--   grant(7) => grant_signal(47),
--   grant(8) => grant_signal(48),
--   grant(9) => grant_signal(49),
--   grant(10) => grant_signal(50),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(1) =>request_signal(41),
--   request(2) =>request_signal(42),
--   request(3) =>request_signal(43),
--   request(4) =>request_signal(44),
--   request(5) =>request_signal(45),
--   request(6) =>request_signal(46),
--   request(7) =>request_signal(47),
--   request(8) =>request_signal(48),
--   request(9) =>request_signal(49),
--   request(10) =>request_signal(50)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(51),
--   grant(2) => grant_signal(52),
--   grant(3) => grant_signal(53),
--   grant(4) => grant_signal(54),
--   grant(5) => grant_signal(55),
--   grant(6) => grant_signal(56),
--   grant(7) => grant_signal(57),
--   grant(8) => grant_signal(58),
--   grant(9) => grant_signal(59),
--   grant(10) => grant_signal(60),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(1) =>request_signal(51),
--   request(2) =>request_signal(52),
--   request(3) =>request_signal(53),
--   request(4) =>request_signal(54),
--   request(5) =>request_signal(55),
--   request(6) =>request_signal(56),
--   request(7) =>request_signal(57),
--   request(8) =>request_signal(58),
--   request(9) =>request_signal(59),
--   request(10) =>request_signal(60)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(61),
--   grant(2) => grant_signal(62),
--   grant(3) => grant_signal(63),
--   grant(4) => grant_signal(64),
--   grant(5) => grant_signal(65),
--   grant(6) => grant_signal(66),
--   grant(7) => grant_signal(67),
--   grant(8) => grant_signal(68),
--   grant(9) => grant_signal(69),
--   grant(10) => grant_signal(70),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(7),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(1) =>request_signal(61),
--   request(2) =>request_signal(62),
--   request(3) =>request_signal(63),
--   request(4) =>request_signal(64),
--   request(5) =>request_signal(65),
--   request(6) =>request_signal(66),
--   request(7) =>request_signal(67),
--   request(8) =>request_signal(68),
--   request(9) =>request_signal(69),
--   request(10) =>request_signal(70)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(71),
--   grant(2) => grant_signal(72),
--   grant(3) => grant_signal(73),
--   grant(4) => grant_signal(74),
--   grant(5) => grant_signal(75),
--   grant(6) => grant_signal(76),
--   grant(7) => grant_signal(77),
--   grant(8) => grant_signal(78),
--   grant(9) => grant_signal(79),
--   grant(10) => grant_signal(80),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(8),
--   request(1) =>request_signal(71),
--   request(2) =>request_signal(72),
--   request(3) =>request_signal(73),
--   request(4) =>request_signal(74),
--   request(5) =>request_signal(75),
--   request(6) =>request_signal(76),
--   request(7) =>request_signal(77),
--   request(8) =>request_signal(78),
--   request(9) =>request_signal(79),
--   request(10) =>request_signal(80)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(81),
--   grant(2) => grant_signal(82),
--   grant(3) => grant_signal(83),
--   grant(4) => grant_signal(84),
--   grant(5) => grant_signal(85),
--   grant(6) => grant_signal(86),
--   grant(7) => grant_signal(87),
--   grant(8) => grant_signal(88),
--   grant(9) => grant_signal(89),
--   grant(10) => grant_signal(90),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port(9),
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(1) =>request_signal(81),
--   request(2) =>request_signal(82),
--   request(3) =>request_signal(83),
--   request(4) =>request_signal(84),
--   request(5) =>request_signal(85),
--   request(6) =>request_signal(86),
--   request(7) =>request_signal(87),
--   request(8) =>request_signal(88),
--   request(9) =>request_signal(89),
--   request(10) =>request_signal(90)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>10)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(91),
--   grant(2) => grant_signal(92),
--   grant(3) => grant_signal(93),
--   grant(4) => grant_signal(94),
--   grant(5) => grant_signal(95),
--   grant(6) => grant_signal(96),
--   grant(7) => grant_signal(97),
--   grant(8) => grant_signal(98),
--   grant(9) => grant_signal(99),
--   grant(10) => grant_signal(100),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(1) =>request_signal(91),
--   request(2) =>request_signal(92),
--   request(3) =>request_signal(93),
--   request(4) =>request_signal(94),
--   request(5) =>request_signal(95),
--   request(6) =>request_signal(96),
--   request(7) =>request_signal(97),
--   request(8) =>request_signal(98),
--   request(9) =>request_signal(99),
--   request(10) =>request_signal(100)
--);
--
--end generate switch10x10;
--
--
---- switch 11 ports
--switch11x11 : if number_of_ports = 11 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   grant(8) => grant_signal(8),
--   grant(9) => grant_signal(9),
--   grant(10) => grant_signal(10),
--   grant(11) => grant_signal(11),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10),
--   request(11) =>request_signal(11)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(12),
--   grant(02) => grant_signal(13),
--   grant(03) => grant_signal(14),
--   grant(04) => grant_signal(15),
--   grant(05) => grant_signal(16),
--   grant(06) => grant_signal(17),
--   grant(07) => grant_signal(18),
--   grant(08) => grant_signal(19),
--   grant(09) => grant_signal(20),
--   grant(10) => grant_signal(21),
--   grant(11) => grant_signal(22),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(01) =>request_signal(12),
--   request(02) =>request_signal(13),
--   request(03) =>request_signal(14),
--   request(04) =>request_signal(15),
--   request(05) =>request_signal(16),
--   request(06) =>request_signal(17),
--   request(07) =>request_signal(18),
--   request(08) =>request_signal(19),
--   request(09) =>request_signal(20),
--   request(10) =>request_signal(21),
--   request(11) =>request_signal(22)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(23),
--   grant(02) => grant_signal(24),
--   grant(03) => grant_signal(25),
--   grant(04) => grant_signal(26),
--   grant(05) => grant_signal(27),
--   grant(06) => grant_signal(28),
--   grant(07) => grant_signal(29),
--   grant(08) => grant_signal(30),
--   grant(09) => grant_signal(31),
--   grant(10) => grant_signal(32),
--   grant(11) => grant_signal(33),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(01) =>request_signal(23),
--   request(02) =>request_signal(24),
--   request(03) =>request_signal(25),
--   request(04) =>request_signal(26),
--   request(05) =>request_signal(27),
--   request(06) =>request_signal(28),
--   request(07) =>request_signal(29),
--   request(08) =>request_signal(30),
--   request(09) =>request_signal(31),
--   request(10) =>request_signal(32),
--   request(11) =>request_signal(33)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(34),
--   grant(02) => grant_signal(35),
--   grant(03) => grant_signal(36),
--   grant(04) => grant_signal(37),
--   grant(05) => grant_signal(38),
--   grant(06) => grant_signal(39),
--   grant(07) => grant_signal(40),
--   grant(08) => grant_signal(41),
--   grant(09) => grant_signal(42),
--   grant(10) => grant_signal(43),
--   grant(11) => grant_signal(44),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(01) =>request_signal(34),
--   request(02) =>request_signal(35),
--   request(03) =>request_signal(36),
--   request(04) =>request_signal(37),
--   request(05) =>request_signal(38),
--   request(06) =>request_signal(39),
--   request(07) =>request_signal(40),
--   request(08) =>request_signal(41),
--   request(09) =>request_signal(42),
--   request(10) =>request_signal(43),
--   request(11) =>request_signal(44)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(45) => grant_signal(45),
--   grant(46) => grant_signal(46),
--   grant(47) => grant_signal(47),
--   grant(48) => grant_signal(48),
--   grant(49) => grant_signal(49),
--   grant(50) => grant_signal(50),
--   grant(51) => grant_signal(51),
--   grant(52) => grant_signal(52),
--   grant(53) => grant_signal(53),
--   grant(54) => grant_signal(54),
--   grant(55) => grant_signal(55),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(45) =>request_signal(45),
--   request(46) =>request_signal(46),
--   request(47) =>request_signal(47),
--   request(48) =>request_signal(48),
--   request(49) =>request_signal(49),
--   request(50) =>request_signal(50),
--   request(51) =>request_signal(51),
--   request(52) =>request_signal(52),
--   request(53) =>request_signal(53),
--   request(54) =>request_signal(54),
--   request(55) =>request_signal(55)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(56) => grant_signal(56),
--   grant(57) => grant_signal(57),
--   grant(58) => grant_signal(58),
--   grant(59) => grant_signal(59),
--   grant(60) => grant_signal(60),
--   grant(61) => grant_signal(61),
--   grant(62) => grant_signal(62),
--   grant(63) => grant_signal(63),
--   grant(64) => grant_signal(64),
--   grant(65) => grant_signal(65),
--   grant(66) => grant_signal(66),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(56) =>request_signal(56),
--   request(57) =>request_signal(57),
--   request(58) =>request_signal(58),
--   request(59) =>request_signal(59),
--   request(60) =>request_signal(60),
--   request(61) =>request_signal(61),
--   request(62) =>request_signal(62),
--   request(63) =>request_signal(63),
--   request(64) =>request_signal(64),
--   request(65) =>request_signal(65),
--   request(66) =>request_signal(66)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(67) => grant_signal(67),
--   grant(68) => grant_signal(68),
--   grant(69) => grant_signal(69),
--   grant(70) => grant_signal(70),
--   grant(71) => grant_signal(71),
--   grant(72) => grant_signal(72),
--   grant(73) => grant_signal(73),
--   grant(74) => grant_signal(74),
--   grant(75) => grant_signal(75),
--   grant(76) => grant_signal(76),
--   grant(77) => grant_signal(77),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(67) =>request_signal(67),
--   request(68) =>request_signal(68),
--   request(69) =>request_signal(69),
--   request(70) =>request_signal(70),
--   request(71) =>request_signal(71),
--   request(72) =>request_signal(72),
--   request(73) =>request_signal(73),
--   request(74) =>request_signal(74),
--   request(75) =>request_signal(75),
--   request(76) =>request_signal(76),
--   request(77) =>request_signal(77)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(78) => grant_signal(78),
--   grant(79) => grant_signal(79),
--   grant(80) => grant_signal(80),
--   grant(81) => grant_signal(81),
--   grant(82) => grant_signal(82),
--   grant(83) => grant_signal(83),
--   grant(84) => grant_signal(84),
--   grant(85) => grant_signal(85),
--   grant(86) => grant_signal(86),
--   grant(87) => grant_signal(87),
--   grant(88) => grant_signal(88),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(8),
--   request(78) =>request_signal(78),
--   request(79) =>request_signal(79),
--   request(80) =>request_signal(80),
--   request(81) =>request_signal(81),
--   request(82) =>request_signal(82),
--   request(83) =>request_signal(83),
--   request(84) =>request_signal(84),
--   request(85) =>request_signal(85),
--   request(86) =>request_signal(86),
--   request(87) =>request_signal(87),
--   request(88) =>request_signal(88)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(89) => grant_signal(89),
--   grant(90) => grant_signal(90),
--   grant(91) => grant_signal(91),
--   grant(92) => grant_signal(92),
--   grant(93) => grant_signal(93),
--   grant(94) => grant_signal(94),
--   grant(95) => grant_signal(95),
--   grant(96) => grant_signal(96),
--   grant(97) => grant_signal(97),
--   grant(98) => grant_signal(98),
--   grant(99) => grant_signal(99),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port(9),
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(89) =>request_signal(89),
--   request(90) =>request_signal(90),
--   request(91) =>request_signal(91),
--   request(92) =>request_signal(92),
--   request(93) =>request_signal(93),
--   request(94) =>request_signal(94),
--   request(95) =>request_signal(95),
--   request(96) =>request_signal(96),
--   request(97) =>request_signal(97),
--   request(98) =>request_signal(98),
--   request(99) =>request_signal(99)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(100),
--   grant(2) => grant_signal(101),
--   grant(3) => grant_signal(102),
--   grant(4) => grant_signal(103),
--   grant(5) => grant_signal(104),
--   grant(6) => grant_signal(105),
--   grant(7) => grant_signal(106),
--   grant(8) => grant_signal(107),
--   grant(9) => grant_signal(108),
--   grant(10) => grant_signal(109),
--   grant(11) => grant_signal(110),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(1) =>request_signal(100),
--   request(2) =>request_signal(101),
--   request(3) =>request_signal(102),
--   request(4) =>request_signal(103),
--   request(5) =>request_signal(104),
--   request(6) =>request_signal(105),
--   request(7) =>request_signal(106),
--   request(8) =>request_signal(107),
--   request(9) =>request_signal(108),
--   request(10) =>request_signal(109),
--   request(11) =>request_signal(110)
--);
--
--PORT11_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>11)
--PORT MAP(
--   data_in => Port_in(11),
--   data_in_en => data_in_en(11),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(111),
--   grant(2) => grant_signal(112),
--   grant(3) => grant_signal(113),
--   grant(4) => grant_signal(114),
--   grant(5) => grant_signal(115),
--   grant(6) => grant_signal(116),
--   grant(7) => grant_signal(117),
--   grant(8) => grant_signal(118),
--   grant(9) => grant_signal(119),
--   grant(10) => grant_signal(120),
--   grant(11) => grant_signal(121),
--   fifo_full =>fifo_in_full(11),
--   priority_rotation =>  priority_rotation_signal(11),
--   fifo_empty => fifo_in_empty(11),
--   data_out =>crossbar_in_port(11),
--   data_out_pulse =>crossbar_in_pulse(11),
--   request(1) =>request_signal(111),
--   request(2) =>request_signal(112),
--   request(3) =>request_signal(113),
--   request(4) =>request_signal(114),
--   request(5) =>request_signal(115),
--   request(6) =>request_signal(116),
--   request(7) =>request_signal(117),
--   request(8) =>request_signal(118),
--   request(9) =>request_signal(119),
--   request(10) =>request_signal(120),
--   request(11) =>request_signal(121)
--);
--
--end generate switch11x11;
--
--
---- switch 12 ports
--switch12x12 : if number_of_ports = 12 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   grant(8) => grant_signal(8),
--   grant(9) => grant_signal(9),
--   grant(10) => grant_signal(10),
--   grant(11) => grant_signal(11),
--   grant(12) => grant_signal(12),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10),
--   request(11) =>request_signal(11),
--   request(12) =>request_signal(12)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(13) => grant_signal(13),
--   grant(14) => grant_signal(14),
--   grant(15) => grant_signal(15),
--   grant(16) => grant_signal(16),
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   grant(21) => grant_signal(21),
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(13) =>request_signal(13),
--   request(14) =>request_signal(14),
--   request(15) =>request_signal(15),
--   request(16) =>request_signal(16),
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20),
--   request(21) =>request_signal(21),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(25) => grant_signal(25),
--   grant(26) => grant_signal(26),
--   grant(27) => grant_signal(27),
--   grant(28) => grant_signal(28),
--   grant(29) => grant_signal(29),
--   grant(30) => grant_signal(30),
--   grant(31) => grant_signal(31),
--   grant(32) => grant_signal(32),
--   grant(33) => grant_signal(33),
--   grant(34) => grant_signal(34),
--   grant(35) => grant_signal(35),
--   grant(36) => grant_signal(36),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(25) =>request_signal(25),
--   request(26) =>request_signal(26),
--   request(27) =>request_signal(27),
--   request(28) =>request_signal(28),
--   request(29) =>request_signal(29),
--   request(30) =>request_signal(30),
--   request(31) =>request_signal(31),
--   request(32) =>request_signal(32),
--   request(33) =>request_signal(33),
--   request(34) =>request_signal(34),
--   request(35) =>request_signal(35),
--   request(36) =>request_signal(36)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(37) => grant_signal(37),
--   grant(38) => grant_signal(38),
--   grant(39) => grant_signal(39),
--   grant(40) => grant_signal(40),
--   grant(41) => grant_signal(41),
--   grant(42) => grant_signal(42),
--   grant(43) => grant_signal(43),
--   grant(44) => grant_signal(44),
--   grant(45) => grant_signal(45),
--   grant(46) => grant_signal(46),
--   grant(47) => grant_signal(47),
--   grant(48) => grant_signal(48),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(37) =>request_signal(37),
--   request(38) =>request_signal(38),
--   request(39) =>request_signal(39),
--   request(40) =>request_signal(40),
--   request(41) =>request_signal(41),
--   request(42) =>request_signal(42),
--   request(43) =>request_signal(43),
--   request(44) =>request_signal(44),
--   request(45) =>request_signal(45),
--   request(46) =>request_signal(46),
--   request(47) =>request_signal(47),
--   request(48) =>request_signal(48)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(49) => grant_signal(49),
--   grant(50) => grant_signal(50),
--   grant(51) => grant_signal(51),
--   grant(52) => grant_signal(52),
--   grant(53) => grant_signal(53),
--   grant(54) => grant_signal(54),
--   grant(55) => grant_signal(55),
--   grant(56) => grant_signal(56),
--   grant(57) => grant_signal(57),
--   grant(58) => grant_signal(58),
--   grant(59) => grant_signal(59),
--   grant(60) => grant_signal(60),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(49) =>request_signal(49),
--   request(50) =>request_signal(50),
--   request(51) =>request_signal(51),
--   request(52) =>request_signal(52),
--   request(53) =>request_signal(53),
--   request(54) =>request_signal(54),
--   request(55) =>request_signal(55),
--   request(56) =>request_signal(56),
--   request(57) =>request_signal(57),
--   request(58) =>request_signal(58),
--   request(59) =>request_signal(59),
--   request(60) =>request_signal(60)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(61) => grant_signal(61),
--   grant(62) => grant_signal(62),
--   grant(63) => grant_signal(63),
--   grant(64) => grant_signal(64),
--   grant(65) => grant_signal(65),
--   grant(66) => grant_signal(66),
--   grant(67) => grant_signal(67),
--   grant(68) => grant_signal(68),
--   grant(69) => grant_signal(69),
--   grant(70) => grant_signal(70),
--   grant(71) => grant_signal(71),
--   grant(72) => grant_signal(72),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(61) =>request_signal(61),
--   request(62) =>request_signal(62),
--   request(63) =>request_signal(63),
--   request(64) =>request_signal(64),
--   request(65) =>request_signal(65),
--   request(66) =>request_signal(66),
--   request(67) =>request_signal(67),
--   request(68) =>request_signal(68),
--   request(69) =>request_signal(69),
--   request(70) =>request_signal(70),
--   request(71) =>request_signal(71),
--   request(72) =>request_signal(72)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(73) => grant_signal(73),
--   grant(74) => grant_signal(74),
--   grant(75) => grant_signal(75),
--   grant(76) => grant_signal(76),
--   grant(77) => grant_signal(77),
--   grant(78) => grant_signal(78),
--   grant(79) => grant_signal(79),
--   grant(80) => grant_signal(80),
--   grant(81) => grant_signal(81),
--   grant(82) => grant_signal(82),
--   grant(83) => grant_signal(83),
--   grant(84) => grant_signal(84),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(7),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(73) =>request_signal(73),
--   request(74) =>request_signal(74),
--   request(75) =>request_signal(75),
--   request(76) =>request_signal(76),
--   request(77) =>request_signal(77),
--   request(78) =>request_signal(78),
--   request(79) =>request_signal(79),
--   request(80) =>request_signal(80),
--   request(81) =>request_signal(81),
--   request(82) =>request_signal(82),
--   request(83) =>request_signal(83),
--   request(84) =>request_signal(84)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(85) => grant_signal(85),
--   grant(86) => grant_signal(86),
--   grant(87) => grant_signal(87),
--   grant(88) => grant_signal(88),
--   grant(89) => grant_signal(89),
--   grant(90) => grant_signal(90),
--   grant(91) => grant_signal(91),
--   grant(92) => grant_signal(92),
--   grant(93) => grant_signal(93),
--   grant(94) => grant_signal(94),
--   grant(95) => grant_signal(95),
--   grant(96) => grant_signal(96),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(8),
--   request(85) =>request_signal(85),
--   request(86) =>request_signal(86),
--   request(87) =>request_signal(87),
--   request(88) =>request_signal(88),
--   request(89) =>request_signal(89),
--   request(90) =>request_signal(90),
--   request(91) =>request_signal(91),
--   request(92) =>request_signal(92),
--   request(93) =>request_signal(93),
--   request(94) =>request_signal(94),
--   request(95) =>request_signal(95),
--   request(96) =>request_signal(96)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(97) => grant_signal(97),
--   grant(98) => grant_signal(98),
--   grant(99) => grant_signal(99),
--   grant(100) => grant_signal(100),
--   grant(101) => grant_signal(101),
--   grant(102) => grant_signal(102),
--   grant(103) => grant_signal(103),
--   grant(104) => grant_signal(104),
--   grant(105) => grant_signal(105),
--   grant(106) => grant_signal(106),
--   grant(107) => grant_signal(107),
--   grant(108) => grant_signal(108),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port(9),
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(97) =>request_signal(97),
--   request(98) =>request_signal(98),
--   request(99) =>request_signal(99),
--   request(100) =>request_signal(100),
--   request(101) =>request_signal(101),
--   request(102) =>request_signal(102),
--   request(103) =>request_signal(103),
--   request(104) =>request_signal(104),
--   request(105) =>request_signal(105),
--   request(106) =>request_signal(106),
--   request(107) =>request_signal(107),
--   request(108) =>request_signal(108)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(109),
--   grant(2) => grant_signal(110),
--   grant(3) => grant_signal(111),
--   grant(4) => grant_signal(112),
--   grant(5) => grant_signal(113),
--   grant(6) => grant_signal(114),
--   grant(7) => grant_signal(115),
--   grant(8) => grant_signal(116),
--   grant(9) => grant_signal(117),
--   grant(10) => grant_signal(118),
--   grant(11) => grant_signal(119),
--   grant(12) => grant_signal(120),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(109) =>request_signal(109),
--   request(110) =>request_signal(110),
--   request(111) =>request_signal(111),
--   request(112) =>request_signal(112),
--   request(113) =>request_signal(113),
--   request(114) =>request_signal(114),
--   request(115) =>request_signal(115),
--   request(116) =>request_signal(116),
--   request(117) =>request_signal(117),
--   request(118) =>request_signal(118),
--   request(119) =>request_signal(119),
--   request(120) =>request_signal(120)
--);
--
--PORT11_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(11),
--   data_in_en => data_in_en(11),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(121),
--   grant(2) => grant_signal(122),
--   grant(3) => grant_signal(123),
--   grant(4) => grant_signal(124),
--   grant(5) => grant_signal(125),
--   grant(6) => grant_signal(126),
--   grant(7) => grant_signal(127),
--   grant(8) => grant_signal(128),
--   grant(9) => grant_signal(129),
--   grant(10) => grant_signal(130),
--   grant(11) => grant_signal(131),
--   grant(12) => grant_signal(132),
--   fifo_full =>fifo_in_full(11),
--   priority_rotation =>  priority_rotation_signal(11),
--   fifo_empty => fifo_in_empty(11),
--   data_out =>crossbar_in_port(11),
--   data_out_pulse =>crossbar_in_pulse(11),
--   request(121) =>request_signal(121),
--   request(122) =>request_signal(122),
--   request(123) =>request_signal(123),
--   request(124) =>request_signal(124),
--   request(125) =>request_signal(125),
--   request(126) =>request_signal(126),
--   request(127) =>request_signal(127),
--   request(128) =>request_signal(128),
--   request(129) =>request_signal(129),
--   request(130) =>request_signal(130),
--   request(131) =>request_signal(131),
--   request(132) =>request_signal(132)
--);
--
--PORT12_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>12)
--PORT MAP(
--   data_in => Port_in(12),
--   data_in_en => data_in_en(12),
--   reset => reset,
--   clk =>clk,
--   grant(133) => grant_signal(133),
--   grant(134) => grant_signal(134),
--   grant(135) => grant_signal(135),
--   grant(136) => grant_signal(136),
--   grant(137) => grant_signal(137),
--   grant(138) => grant_signal(138),
--   grant(139) => grant_signal(139),
--   grant(140) => grant_signal(140),
--   grant(141) => grant_signal(141),
--   grant(142) => grant_signal(142),
--   grant(143) => grant_signal(143),
--   grant(144) => grant_signal(144),
--   fifo_full =>fifo_in_full(12),
--   priority_rotation =>  priority_rotation_signal(12),
--   fifo_empty => fifo_in_empty(12),
--   data_out =>crossbar_in_port(12),
--   data_out_pulse =>crossbar_in_pulse(12),
--   request(133) =>request_signal(133),
--   request(134) =>request_signal(134),
--   request(135) =>request_signal(135),
--   request(136) =>request_signal(136),
--   request(137) =>request_signal(137),
--   request(138) =>request_signal(138),
--   request(139) =>request_signal(139),
--   request(140) =>request_signal(140),
--   request(141) =>request_signal(141),
--   request(142) =>request_signal(142),
--   request(143) =>request_signal(143),
--   request(144) =>request_signal(144)
--);
--
--end generate switch12x12;
--
--
---- switch 13 ports
--switch13x13 : if number_of_ports = 13 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   grant(8) => grant_signal(8),
--   grant(9) => grant_signal(9),
--   grant(10) => grant_signal(10),
--   grant(11) => grant_signal(11),
--   grant(12) => grant_signal(12),
--   grant(13) => grant_signal(13),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10),
--   request(11) =>request_signal(11),
--   request(12) =>request_signal(12),
--   request(13) =>request_signal(13)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(14) => grant_signal(14),
--   grant(15) => grant_signal(15),
--   grant(16) => grant_signal(16),
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   grant(21) => grant_signal(21),
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   grant(25) => grant_signal(25),
--   grant(26) => grant_signal(26),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(14) =>request_signal(14),
--   request(15) =>request_signal(15),
--   request(16) =>request_signal(16),
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20),
--   request(21) =>request_signal(21),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24),
--   request(25) =>request_signal(25),
--   request(26) =>request_signal(26)
--);

--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(27) => grant_signal(27),
--   grant(28) => grant_signal(28),
--   grant(29) => grant_signal(29),
--   grant(30) => grant_signal(30),
--   grant(31) => grant_signal(31),
--   grant(32) => grant_signal(32),
--   grant(33) => grant_signal(33),
--   grant(34) => grant_signal(34),
--   grant(35) => grant_signal(35),
--   grant(36) => grant_signal(36),
--   grant(37) => grant_signal(37),
--   grant(38) => grant_signal(38),
--   grant(39) => grant_signal(39),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(27) =>request_signal(27),
--   request(28) =>request_signal(28),
--   request(29) =>request_signal(29),
--   request(30) =>request_signal(30),
--   request(31) =>request_signal(31),
--   request(32) =>request_signal(32),
--   request(33) =>request_signal(33),
--   request(34) =>request_signal(34),
--   request(35) =>request_signal(35),
--   request(36) =>request_signal(36),
--   request(37) =>request_signal(37),
--   request(38) =>request_signal(38),
--   request(39) =>request_signal(39)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(40) => grant_signal(40),
--   grant(41) => grant_signal(41),
--   grant(42) => grant_signal(42),
--   grant(43) => grant_signal(43),
--   grant(44) => grant_signal(44),
--   grant(45) => grant_signal(45),
--   grant(46) => grant_signal(46),
--   grant(47) => grant_signal(47),
--   grant(48) => grant_signal(48),
--   grant(49) => grant_signal(49),
--   grant(50) => grant_signal(50),
--   grant(51) => grant_signal(51),
--   grant(52) => grant_signal(52),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(40) =>request_signal(40),
--   request(41) =>request_signal(41),
--   request(42) =>request_signal(42),
--   request(43) =>request_signal(43),
--   request(44) =>request_signal(44),
--   request(45) =>request_signal(45),
--   request(46) =>request_signal(46),
--   request(47) =>request_signal(47),
--   request(48) =>request_signal(48),
--   request(49) =>request_signal(49),
--   request(50) =>request_signal(50),
--   request(51) =>request_signal(51),
--   request(52) =>request_signal(52)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(53) => grant_signal(53),
--   grant(54) => grant_signal(54),
--   grant(55) => grant_signal(55),
--   grant(56) => grant_signal(56),
--   grant(57) => grant_signal(57),
--   grant(58) => grant_signal(58),
--   grant(59) => grant_signal(59),
--   grant(60) => grant_signal(60),
--   grant(61) => grant_signal(61),
--   grant(62) => grant_signal(62),
--   grant(63) => grant_signal(63),
--   grant(64) => grant_signal(64),
--   grant(65) => grant_signal(65),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(53) =>request_signal(53),
--   request(54) =>request_signal(54),
--   request(55) =>request_signal(55),
--   request(56) =>request_signal(56),
--   request(57) =>request_signal(57),
--   request(58) =>request_signal(58),
--   request(59) =>request_signal(59),
--   request(60) =>request_signal(60),
--   request(61) =>request_signal(61),
--   request(62) =>request_signal(62),
--   request(63) =>request_signal(63),
--   request(64) =>request_signal(64),
--   request(65) =>request_signal(65)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(66) => grant_signal(66),
--   grant(67) => grant_signal(67),
--   grant(68) => grant_signal(68),
--   grant(69) => grant_signal(69),
--   grant(70) => grant_signal(70),
--   grant(71) => grant_signal(71),
--   grant(72) => grant_signal(72),
--   grant(73) => grant_signal(73),
--   grant(74) => grant_signal(74),
--   grant(75) => grant_signal(75),
--   grant(76) => grant_signal(76),
--   grant(77) => grant_signal(77),
--   grant(78) => grant_signal(78),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(66) =>request_signal(66),
--   request(67) =>request_signal(67),
--   request(68) =>request_signal(68),
--   request(69) =>request_signal(69),
--   request(70) =>request_signal(70),
--   request(71) =>request_signal(71),
--   request(72) =>request_signal(72),
--   request(73) =>request_signal(73),
--   request(74) =>request_signal(74),
--   request(75) =>request_signal(75),
--   request(76) =>request_signal(76),
--   request(77) =>request_signal(77),
--   request(78) =>request_signal(78)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(79) => grant_signal(79),
--   grant(80) => grant_signal(80),
--   grant(81) => grant_signal(81),
--   grant(82) => grant_signal(82),
--   grant(83) => grant_signal(83),
--   grant(84) => grant_signal(84),
--   grant(85) => grant_signal(85),
--   grant(86) => grant_signal(86),
--   grant(87) => grant_signal(87),
--   grant(88) => grant_signal(88),
--   grant(89) => grant_signal(89),
--   grant(90) => grant_signal(90),
--   grant(91) => grant_signal(91),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(7),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(79) =>request_signal(79),
--   request(80) =>request_signal(80),
--   request(81) =>request_signal(81),
--   request(82) =>request_signal(82),
--   request(83) =>request_signal(83),
--   request(84) =>request_signal(84),
--   request(85) =>request_signal(85),
--   request(86) =>request_signal(86),
--   request(87) =>request_signal(87),
--   request(88) =>request_signal(88),
--   request(89) =>request_signal(89),
--   request(90) =>request_signal(90),
--   request(91) =>request_signal(91)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(92) => grant_signal(92),
--   grant(93) => grant_signal(93),
--   grant(94) => grant_signal(94),
--   grant(95) => grant_signal(95),
--   grant(96) => grant_signal(96),
--   grant(97) => grant_signal(97),
--   grant(98) => grant_signal(98),
--   grant(99) => grant_signal(99),
--   grant(100) => grant_signal(100),
--   grant(101) => grant_signal(101),
--   grant(102) => grant_signal(102),
--   grant(103) => grant_signal(103),
--   grant(104) => grant_signal(104),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(8),
--   request(92) =>request_signal(92),
--   request(93) =>request_signal(93),
--   request(94) =>request_signal(94),
--   request(95) =>request_signal(95),
--   request(96) =>request_signal(96),
--   request(97) =>request_signal(97),
--   request(98) =>request_signal(98),
--   request(99) =>request_signal(99),
--   request(100) =>request_signal(100),
--   request(101) =>request_signal(101),
--   request(102) =>request_signal(102),
--   request(103) =>request_signal(103),
--   request(104) =>request_signal(104)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(105),
--   grant(2) => grant_signal(106),
--   grant(3) => grant_signal(107),
--   grant(4) => grant_signal(108),
--   grant(5) => grant_signal(109),
--   grant(6) => grant_signal(110),
--   grant(7) => grant_signal(111),
--   grant(8) => grant_signal(112),
--   grant(9) => grant_signal(113),
--   grant(10) => grant_signal(114),
--   grant(11) => grant_signal(115),
--   grant(12) => grant_signal(116),
--   grant(13) => grant_signal(117),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port(9),
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(105) =>request_signal(105),
--   request(106) =>request_signal(106),
--   request(107) =>request_signal(107),
--   request(108) =>request_signal(108),
--   request(109) =>request_signal(109),
--   request(110) =>request_signal(110),
--   request(111) =>request_signal(111),
--   request(112) =>request_signal(112),
--   request(113) =>request_signal(113),
--   request(114) =>request_signal(114),
--   request(115) =>request_signal(115),
--   request(116) =>request_signal(116),
--   request(117) =>request_signal(117)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(118),
--   grant(2) => grant_signal(119),
--   grant(3) => grant_signal(120),
--   grant(4) => grant_signal(121),
--   grant(5) => grant_signal(122),
--   grant(6) => grant_signal(123),
--   grant(7) => grant_signal(124),
--   grant(8) => grant_signal(125),
--   grant(9) => grant_signal(126),
--   grant(10) => grant_signal(127),
--   grant(11) => grant_signal(128),
--   grant(12) => grant_signal(129),
--   grant(13) => grant_signal(130),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(1) =>request_signal(118),
--   request(2) =>request_signal(119),
--   request(3) =>request_signal(120),
--   request(4) =>request_signal(121),
--   request(5) =>request_signal(122),
--   request(6) =>request_signal(123),
--   request(7) =>request_signal(124),
--   request(8) =>request_signal(125),
--   request(9) =>request_signal(126),
--   request(10) =>request_signal(127),
--   request(11) =>request_signal(128),
--   request(12) =>request_signal(129),
--   request(13) =>request_signal(130)
--);
--
--PORT11_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(11),
--   data_in_en => data_in_en(11),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(131),
--   grant(2) => grant_signal(132),
--   grant(3) => grant_signal(133),
--   grant(4) => grant_signal(134),
--   grant(5) => grant_signal(135),
--   grant(6) => grant_signal(136),
--   grant(7) => grant_signal(137),
--   grant(8) => grant_signal(138),
--   grant(9) => grant_signal(139),
--   grant(10) => grant_signal(140),
--   grant(11) => grant_signal(141),
--   grant(12) => grant_signal(142),
--   grant(13) => grant_signal(143),
--   fifo_full =>fifo_in_full(11),
--   priority_rotation =>  priority_rotation_signal(11),
--   fifo_empty => fifo_in_empty(11),
--   data_out =>crossbar_in_port(11),
--   data_out_pulse =>crossbar_in_pulse(11),
--   request(1) =>request_signal(131),
--   request(2) =>request_signal(132),
--   request(3) =>request_signal(133),
--   request(4) =>request_signal(134),
--   request(5) =>request_signal(135),
--   request(6) =>request_signal(136),
--   request(7) =>request_signal(137),
--   request(8) =>request_signal(138),
--   request(9) =>request_signal(139),
--   request(10) =>request_signal(140),
--   request(11) =>request_signal(141),
--   request(12) =>request_signal(142),
--   request(13) =>request_signal(143)
--);
--
--PORT12_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(12),
--   data_in_en => data_in_en(12),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(144),
--   grant(2) => grant_signal(145),
--   grant(3) => grant_signal(146),
--   grant(4) => grant_signal(147),
--   grant(5) => grant_signal(148),
--   grant(6) => grant_signal(149),
--   grant(7) => grant_signal(150),
--   grant(8) => grant_signal(151),
--   grant(9) => grant_signal(152),
--   grant(10) => grant_signal(153),
--   grant(11) => grant_signal(154),
--   grant(12) => grant_signal(155),
--   grant(13) => grant_signal(156),
--   fifo_full =>fifo_in_full(12),
--   priority_rotation =>  priority_rotation_signal(12),
--   fifo_empty => fifo_in_empty(12),
--   data_out =>crossbar_in_port(12),
--   data_out_pulse =>crossbar_in_pulse(12),
--   request(1) =>request_signal(144),
--   request(2) =>request_signal(145),
--   request(3) =>request_signal(146),
--   request(4) =>request_signal(147),
--   request(5) =>request_signal(148),
--   request(6) =>request_signal(149),
--   request(7) =>request_signal(150),
--   request(8) =>request_signal(151),
--   request(9) =>request_signal(152),
--   request(10) =>request_signal(153),
--   request(11) =>request_signal(154),
--   request(12) =>request_signal(155),
--   request(13) =>request_signal(156)
--);
--
--PORT13_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>13)
--PORT MAP(
--   data_in => Port_in(13),
--   data_in_en => data_in_en(13),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(157),
--   grant(2) => grant_signal(158),
--   grant(3) => grant_signal(159),
--   grant(4) => grant_signal(160),
--   grant(5) => grant_signal(161),
--   grant(6) => grant_signal(162),
--   grant(7) => grant_signal(163),
--   grant(8) => grant_signal(164),
--   grant(9) => grant_signal(165),
--   grant(10) => grant_signal(166),
--   grant(11) => grant_signal(167),
--   grant(12) => grant_signal(168),
--   grant(13) => grant_signal(169),
--   fifo_full =>fifo_in_full(13),
--   priority_rotation =>  priority_rotation_signal(13),
--   fifo_empty => fifo_in_empty(13),
--   data_out =>crossbar_in_port(13),
--   data_out_pulse =>crossbar_in_pulse(13),
--   request(1) =>request_signal(157),
--   request(2) =>request_signal(158),
--   request(3) =>request_signal(159),
--   request(4) =>request_signal(160),
--   request(5) =>request_signal(161),
--   request(6) =>request_signal(162),
--   request(7) =>request_signal(163),
--   request(8) =>request_signal(164),
--   request(9) =>request_signal(165),
--   request(10) =>request_signal(166),
--   request(11) =>request_signal(167),
--   request(12) =>request_signal(168),
--   request(13) =>request_signal(169)
--);
--
--end generate switch13x13;
--
--
---- switch 14 ports
--switch14x14 : if number_of_ports = 14 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   grant(8) => grant_signal(8),
--   grant(9) => grant_signal(9),
--   grant(10) => grant_signal(10),
--   grant(11) => grant_signal(11),
--   grant(12) => grant_signal(12),
--   grant(13) => grant_signal(13),
--   grant(14) => grant_signal(14),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10),
--   request(11) =>request_signal(11),
--   request(12) =>request_signal(12),
--   request(13) =>request_signal(13),
--   request(14) =>request_signal(14)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(15),
--   grant(2) => grant_signal(16),
--   grant(3) => grant_signal(17),
--   grant(4) => grant_signal(18),
--   grant(5) => grant_signal(19),
--   grant(6) => grant_signal(20),
--   grant(7) => grant_signal(21),
--   grant(8) => grant_signal(22),
--   grant(9) => grant_signal(23),
--   grant(10) => grant_signal(24),
--   grant(11) => grant_signal(25),
--   grant(12) => grant_signal(26),
--   grant(13) => grant_signal(27),
--   grant(14) => grant_signal(28),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(1) =>request_signal(15),
--   request(2) =>request_signal(16),
--   request(3) =>request_signal(17),
--   request(4) =>request_signal(18),
--   request(5) =>request_signal(19),
--   request(6) =>request_signal(20),
--   request(7) =>request_signal(21),
--   request(8) =>request_signal(22),
--   request(9) =>request_signal(23),
--   request(10) =>request_signal(24),
--   request(11) =>request_signal(25),
--   request(12) =>request_signal(26),
--   request(13) =>request_signal(27),
--   request(14) =>request_signal(28)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(29),
--   grant(2) => grant_signal(30),
--   grant(3) => grant_signal(31),
--   grant(4) => grant_signal(32),
--   grant(5) => grant_signal(33),
--   grant(6) => grant_signal(34),
--   grant(7) => grant_signal(35),
--   grant(8) => grant_signal(36),
--   grant(9) => grant_signal(37),
--   grant(10)=> grant_signal(38),
--   grant(11) => grant_signal(39),
--   grant(12) => grant_signal(40),
--   grant(13) => grant_signal(41),
--   grant(14) => grant_signal(42),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(01) =>request_signal(29),
--   request(02) =>request_signal(30),
--   request(03) =>request_signal(31),
--   request(04) =>request_signal(32),
--   request(05) =>request_signal(33),
--   request(06) =>request_signal(34),
--   request(07) =>request_signal(35),
--   request(08) =>request_signal(36),
--   request(09) =>request_signal(37),
--   request(10) =>request_signal(38),
--   request(11) =>request_signal(39),
--   request(12) =>request_signal(40),
--   request(13) =>request_signal(41),
--   request(14) =>request_signal(42)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(43),
--   grant(02) => grant_signal(44),
--   grant(03) => grant_signal(45),
--   grant(04) => grant_signal(46),
--   grant(05) => grant_signal(47),
--   grant(06) => grant_signal(48),
--   grant(07) => grant_signal(49),
--   grant(08) => grant_signal(50),
--   grant(09) => grant_signal(51),
--   grant(10) => grant_signal(52),
--   grant(11) => grant_signal(53),
--   grant(12) => grant_signal(54),
--   grant(13) => grant_signal(55),
--   grant(14) => grant_signal(56),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(01) =>request_signal(43),
--   request(02) =>request_signal(44),
--   request(03) =>request_signal(45),
--   request(04) =>request_signal(46),
--   request(05) =>request_signal(47),
--   request(06) =>request_signal(48),
--   request(07) =>request_signal(49),
--   request(08) =>request_signal(50),
--   request(09) =>request_signal(51),
--   request(10) =>request_signal(52),
--   request(11) =>request_signal(53),
--   request(12) =>request_signal(54),
--   request(13) =>request_signal(55),
--   request(14) =>request_signal(56)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(57),
--   grant(02) => grant_signal(58),
--   grant(03) => grant_signal(59),
--   grant(04) => grant_signal(60),
--   grant(05) => grant_signal(61),
--   grant(06) => grant_signal(62),
--   grant(07) => grant_signal(63),
--   grant(08) => grant_signal(64),
--   grant(09) => grant_signal(65),
--   grant(10) => grant_signal(66),
--   grant(11) => grant_signal(67),
--   grant(12) => grant_signal(68),
--   grant(13) => grant_signal(69),
--   grant(14) => grant_signal(70),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(01) =>request_signal(57),
--   request(02) =>request_signal(58),
--   request(03) =>request_signal(59),
--   request(04) =>request_signal(60),
--   request(05) =>request_signal(61),
--   request(06) =>request_signal(62),
--   request(07) =>request_signal(63),
--   request(08) =>request_signal(64),
--   request(09) =>request_signal(65),
--   request(10) =>request_signal(66),
--   request(11) =>request_signal(67),
--   request(12) =>request_signal(68),
--   request(13) =>request_signal(69),
--   request(14) =>request_signal(70)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(71),
--   grant(02) => grant_signal(72),
--   grant(03) => grant_signal(73),
--   grant(04) => grant_signal(74),
--   grant(05) => grant_signal(75),
--   grant(06) => grant_signal(76),
--   grant(07) => grant_signal(77),
--   grant(08) => grant_signal(78),
--   grant(09) => grant_signal(79),
--   grant(10) => grant_signal(80),
--   grant(11) => grant_signal(81),
--   grant(12) => grant_signal(82),
--   grant(13) => grant_signal(83),
--   grant(14) => grant_signal(84),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(01) =>request_signal(71),
--   request(02) =>request_signal(72),
--   request(03) =>request_signal(73),
--   request(04) =>request_signal(74),
--   request(05) =>request_signal(75),
--   request(06) =>request_signal(76),
--   request(07) =>request_signal(77),
--   request(08) =>request_signal(78),
--   request(09) =>request_signal(79),
--   request(10) =>request_signal(80),
--   request(11) =>request_signal(81),
--   request(12) =>request_signal(82),
--   request(13) =>request_signal(83),
--   request(14) =>request_signal(84)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(85),
--   grant(02) => grant_signal(86),
--   grant(03) => grant_signal(87),
--   grant(04) => grant_signal(88),
--   grant(05) => grant_signal(89),
--   grant(06) => grant_signal(90),
--   grant(07) => grant_signal(91),
--   grant(08) => grant_signal(92),
--   grant(09) => grant_signal(93),
--   grant(10) => grant_signal(94),
--   grant(11) => grant_signal(95),
--   grant(12) => grant_signal(96),
--   grant(13) => grant_signal(97),
--   grant(14) => grant_signal(98),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(7),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(01) =>request_signal(85),
--   request(02) =>request_signal(86),
--   request(03) =>request_signal(87),
--   request(04) =>request_signal(88),
--   request(05) =>request_signal(89),
--   request(06) =>request_signal(90),
--   request(07) =>request_signal(91),
--   request(08) =>request_signal(92),
--   request(09) =>request_signal(93),
--   request(10) =>request_signal(94),
--   request(11) =>request_signal(95),
--   request(12) =>request_signal(96),
--   request(13) =>request_signal(97),
--   request(14) =>request_signal(98)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(01) => grant_signal(99),
--   grant(02) => grant_signal(100),
--   grant(03) => grant_signal(101),
--   grant(04) => grant_signal(102),
--   grant(05) => grant_signal(103),
--   grant(06) => grant_signal(104),
--   grant(07) => grant_signal(105),
--   grant(08) => grant_signal(106),
--   grant(09) => grant_signal(107),
--   grant(10) => grant_signal(108),
--   grant(11) => grant_signal(109),
--   grant(12) => grant_signal(110),
--   grant(13) => grant_signal(111),
--   grant(14) => grant_signal(112),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(8),
--   request(1) =>request_signal(99),
--   request(2) =>request_signal(100),
--   request(3) =>request_signal(101),
--   request(4) =>request_signal(102),
--   request(5) =>request_signal(103),
--   request(6) =>request_signal(104),
--   request(7) =>request_signal(105),
--   request(8) =>request_signal(106),
--   request(9) =>request_signal(107),
--   request(10) =>request_signal(108),
--   request(11) =>request_signal(109),
--   request(12) =>request_signal(110),
--   request(13) =>request_signal(111),
--   request(14) =>request_signal(112)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(113),
--   grant(2) => grant_signal(114),
--   grant(3) => grant_signal(115),
--   grant(4) => grant_signal(116),
--   grant(5) => grant_signal(117),
--   grant(6) => grant_signal(118),
--   grant(7) => grant_signal(119),
--   grant(8) => grant_signal(120),
--   grant(9) => grant_signal(121),
--   grant(10) => grant_signal(122),
--   grant(11) => grant_signal(123),
--   grant(12) => grant_signal(124),
--   grant(13) => grant_signal(125),
--   grant(14) => grant_signal(126),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port(9),
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(1) =>request_signal(113),
--   request(2) =>request_signal(114),
--   request(3) =>request_signal(115),
--   request(4) =>request_signal(116),
--   request(5) =>request_signal(117),
--   request(6) =>request_signal(118),
--   request(7) =>request_signal(119),
--   request(8) =>request_signal(120),
--   request(9) =>request_signal(121),
--   request(10) =>request_signal(122),
--   request(11) =>request_signal(123),
--   request(12) =>request_signal(124),
--   request(13) =>request_signal(125),
--   request(14) =>request_signal(126)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(127),
--   grant(2) => grant_signal(128),
--   grant(3) => grant_signal(129),
--   grant(4) => grant_signal(130),
--   grant(5) => grant_signal(131),
--   grant(6) => grant_signal(132),
--   grant(7) => grant_signal(133),
--   grant(8) => grant_signal(134),
--   grant(9) => grant_signal(135),
--   grant(10) => grant_signal(136),
--   grant(11) => grant_signal(137),
--   grant(12) => grant_signal(138),
--   grant(13) => grant_signal(139),
--   grant(14) => grant_signal(140),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(1) =>request_signal(127),
--   request(2) =>request_signal(128),
--   request(3) =>request_signal(129),
--   request(4) =>request_signal(130),
--   request(5) =>request_signal(131),
--   request(6) =>request_signal(132),
--   request(7) =>request_signal(133),
--   request(8) =>request_signal(134),
--   request(9) =>request_signal(135),
--   request(10) =>request_signal(136),
--   request(11) =>request_signal(137),
--   request(12) =>request_signal(138),
--   request(13) =>request_signal(139),
--   request(14) =>request_signal(140)
--);
--
--PORT11_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(11),
--   data_in_en => data_in_en(11),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(141),
--   grant(2) => grant_signal(142),
--   grant(3) => grant_signal(143),
--   grant(4) => grant_signal(144),
--   grant(5) => grant_signal(145),
--   grant(6) => grant_signal(146),
--   grant(7) => grant_signal(147),
--   grant(8) => grant_signal(148),
--   grant(9) => grant_signal(149),
--   grant(10) => grant_signal(150),
--   grant(11) => grant_signal(151),
--   grant(12) => grant_signal(152),
--   grant(13) => grant_signal(153),
--   grant(14) => grant_signal(154),
--   fifo_full =>fifo_in_full(11),
--   priority_rotation =>  priority_rotation_signal(11),
--   fifo_empty => fifo_in_empty(11),
--   data_out =>crossbar_in_port(11),
--   data_out_pulse =>crossbar_in_pulse(11),
--   request(1) =>request_signal(141),
--   request(2) =>request_signal(142),
--   request(3) =>request_signal(143),
--   request(4) =>request_signal(144),
--   request(5) =>request_signal(145),
--   request(6) =>request_signal(146),
--   request(7) =>request_signal(147),
--   request(8) =>request_signal(148),
--   request(9) =>request_signal(149),
--   request(10) =>request_signal(150),
--   request(11) =>request_signal(151),
--   request(12) =>request_signal(152),
--   request(13) =>request_signal(153),
--   request(14) =>request_signal(154)
--);
--
--PORT12_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(12),
--   data_in_en => data_in_en(12),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(155),
--   grant(2) => grant_signal(156),
--   grant(3) => grant_signal(157),
--   grant(4) => grant_signal(158),
--   grant(5) => grant_signal(159),
--   grant(6) => grant_signal(160),
--   grant(7) => grant_signal(161),
--   grant(8) => grant_signal(162),
--   grant(9) => grant_signal(163),
--   grant(10) => grant_signal(164),
--   grant(11) => grant_signal(165),
--   grant(12) => grant_signal(166),
--   grant(13) => grant_signal(167),
--   grant(14) => grant_signal(168),
--   fifo_full =>fifo_in_full(12),
--   priority_rotation =>  priority_rotation_signal(12),
--   fifo_empty => fifo_in_empty(12),
--   data_out =>crossbar_in_port(12),
--   data_out_pulse =>crossbar_in_pulse(12),
--   request(1) =>request_signal(155),
--   request(2) =>request_signal(156),
--   request(3) =>request_signal(157),
--   request(4) =>request_signal(158),
--   request(5) =>request_signal(159),
--   request(6) =>request_signal(160),
--   request(7) =>request_signal(161),
--   request(8) =>request_signal(162),
--   request(9) =>request_signal(163),
--   request(10) =>request_signal(164),
--   request(11) =>request_signal(165),
--   request(12) =>request_signal(166),
--   request(13) =>request_signal(167),
--   request(14) =>request_signal(168)
--);
--
--PORT13_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(13),
--   data_in_en => data_in_en(13),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(169),
--   grant(2) => grant_signal(170),
--   grant(3) => grant_signal(171),
--   grant(4) => grant_signal(172),
--   grant(5) => grant_signal(173),
--   grant(6) => grant_signal(174),
--   grant(7) => grant_signal(175),
--   grant(8) => grant_signal(176),
--   grant(9) => grant_signal(177),
--   grant(10) => grant_signal(178),
--   grant(11) => grant_signal(179),
--   grant(12) => grant_signal(180),
--   grant(13) => grant_signal(181),
--   grant(14) => grant_signal(182),
--   fifo_full =>fifo_in_full(13),
--   priority_rotation =>  priority_rotation_signal(13),
--   fifo_empty => fifo_in_empty(13),
--   data_out =>crossbar_in_port(13),
--   data_out_pulse =>crossbar_in_pulse(13),
--   request(1) =>request_signal(169),
--   request(2) =>request_signal(170),
--   request(3) =>request_signal(171),
--   request(4) =>request_signal(172),
--   request(5) =>request_signal(173),
--   request(6) =>request_signal(174),
--   request(7) =>request_signal(175),
--   request(8) =>request_signal(176),
--   request(9) =>request_signal(177),
--   request(10) =>request_signal(178),
--   request(11) =>request_signal(179),
--   request(12) =>request_signal(180),
--   request(13) =>request_signal(181),
--   request(14) =>request_signal(182)
--);
--
--PORT14_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>14)
--PORT MAP(
--   data_in => Port_in(14),
--   data_in_en => data_in_en(14),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(183),
--   grant(2) => grant_signal(184),
--   grant(3) => grant_signal(185),
--   grant(4) => grant_signal(186),
--   grant(5) => grant_signal(187),
--   grant(6) => grant_signal(188),
--   grant(7) => grant_signal(189),
--   grant(8) => grant_signal(190),
--   grant(9) => grant_signal(191),
--   grant(10) => grant_signal(192),
--   grant(11) => grant_signal(193),
--   grant(12) => grant_signal(194),
--   grant(13) => grant_signal(195),
--   grant(14) => grant_signal(196),
--   fifo_full =>fifo_in_full(14),
--   priority_rotation =>  priority_rotation_signal(14),
--   fifo_empty => fifo_in_empty(14),
--   data_out =>crossbar_in_port(14),
--   data_out_pulse =>crossbar_in_pulse(14),
--   request(1) =>request_signal(183),
--   request(2) =>request_signal(184),
--   request(3) =>request_signal(185),
--   request(4) =>request_signal(186),
--   request(5) =>request_signal(187),
--   request(6) =>request_signal(188),
--   request(7) =>request_signal(189),
--   request(8) =>request_signal(190),
--   request(9) =>request_signal(191),
--   request(10) =>request_signal(192),
--   request(11) =>request_signal(193),
--   request(12) =>request_signal(194),
--   request(13) =>request_signal(195),
--   request(14) =>request_signal(196)
--);
--
--end generate switch14x14;
--
--
---- switch 15 ports
--switch15x15 : if number_of_ports = 15 generate
--
--PORT1_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(1),
--   data_in_en => data_in_en(1),
--   reset => reset,
--   clk =>clk,
--   grant(1) => grant_signal(1),
--   grant(2) => grant_signal(2),
--   grant(3) => grant_signal(3),
--   grant(4) => grant_signal(4),
--   grant(5) => grant_signal(5),
--   grant(6) => grant_signal(6),
--   grant(7) => grant_signal(7),
--   grant(8) => grant_signal(8),
--   grant(9) => grant_signal(9),
--   grant(10) => grant_signal(10),
--   grant(11) => grant_signal(11),
--   grant(12) => grant_signal(12),
--   grant(13) => grant_signal(13),
--   grant(14) => grant_signal(14),
--   grant(15) => grant_signal(15),
--   fifo_full =>fifo_in_full(1),
--   priority_rotation =>  priority_rotation_signal(1),
--   fifo_empty => fifo_in_empty(1),
--   data_out =>crossbar_in_port(1),
--   data_out_pulse =>crossbar_in_pulse(1),
--   request(1) =>request_signal(1),
--   request(2) =>request_signal(2),
--   request(3) =>request_signal(3),
--   request(4) =>request_signal(4),
--   request(5) =>request_signal(5),
--   request(6) =>request_signal(6),
--   request(7) =>request_signal(7),
--   request(8) =>request_signal(8),
--   request(9) =>request_signal(9),
--   request(10) =>request_signal(10),
--   request(11) =>request_signal(11),
--   request(12) =>request_signal(12),
--   request(13) =>request_signal(13),
--   request(14) =>request_signal(14),
--   request(15) =>request_signal(15)
--);
--
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(16) => grant_signal(16),
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   grant(21) => grant_signal(21),
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   grant(25) => grant_signal(25),
--   grant(26) => grant_signal(26),
--   grant(27) => grant_signal(27),
--   grant(28) => grant_signal(28),
--   grant(29) => grant_signal(29),
--   grant(30) => grant_signal(30),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port(2),
--   data_out_pulse =>crossbar_in_pulse(2),
--   request(16) =>request_signal(16),
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20),
--   request(21) =>request_signal(21),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24),
--   request(25) =>request_signal(25),
--   request(26) =>request_signal(26),
--   request(27) =>request_signal(27),
--   request(28) =>request_signal(28),
--   request(29) =>request_signal(29),
--   request(30) =>request_signal(30)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(31) => grant_signal(31),
--   grant(32) => grant_signal(32),
--   grant(33) => grant_signal(33),
--   grant(34) => grant_signal(34),
--   grant(35) => grant_signal(35),
--   grant(36) => grant_signal(36),
--   grant(37) => grant_signal(37),
--   grant(38) => grant_signal(38),
--   grant(39) => grant_signal(39),
--   grant(40) => grant_signal(40),
--   grant(41) => grant_signal(41),
--   grant(42) => grant_signal(42),
--   grant(43) => grant_signal(43),
--   grant(44) => grant_signal(44),
--   grant(45) => grant_signal(45),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port(3),
--   data_out_pulse =>crossbar_in_pulse(3),
--   request(31) =>request_signal(31),
--   request(32) =>request_signal(32),
--   request(33) =>request_signal(33),
--   request(34) =>request_signal(34),
--   request(35) =>request_signal(35),
--   request(36) =>request_signal(36),
--   request(37) =>request_signal(37),
--   request(38) =>request_signal(38),
--   request(39) =>request_signal(39),
--   request(40) =>request_signal(40),
--   request(41) =>request_signal(41),
--   request(42) =>request_signal(42),
--   request(43) =>request_signal(43),
--   request(44) =>request_signal(44),
--   request(45) =>request_signal(45)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(46) => grant_signal(46),
--   grant(47) => grant_signal(47),
--   grant(48) => grant_signal(48),
--   grant(49) => grant_signal(49),
--   grant(50) => grant_signal(50),
--   grant(51) => grant_signal(51),
--   grant(52) => grant_signal(52),
--   grant(53) => grant_signal(53),
--   grant(54) => grant_signal(54),
--   grant(55) => grant_signal(55),
--   grant(56) => grant_signal(56),
--   grant(57) => grant_signal(57),
--   grant(58) => grant_signal(58),
--   grant(59) => grant_signal(59),
--   grant(60) => grant_signal(60),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4),
--   request(46) =>request_signal(46),
--   request(47) =>request_signal(47),
--   request(48) =>request_signal(48),
--   request(49) =>request_signal(49),
--   request(50) =>request_signal(50),
--   request(51) =>request_signal(51),
--   request(52) =>request_signal(52),
--   request(53) =>request_signal(53),
--   request(54) =>request_signal(54),
--   request(55) =>request_signal(55),
--   request(56) =>request_signal(56),
--   request(57) =>request_signal(57),
--   request(58) =>request_signal(58),
--   request(59) =>request_signal(59),
--   request(60) =>request_signal(60)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(61) => grant_signal(61),
--   grant(62) => grant_signal(62),
--   grant(63) => grant_signal(63),
--   grant(64) => grant_signal(64),
--   grant(65) => grant_signal(65),
--   grant(66) => grant_signal(66),
--   grant(67) => grant_signal(67),
--   grant(68) => grant_signal(68),
--   grant(69) => grant_signal(69),
--   grant(70) => grant_signal(70),
--   grant(71) => grant_signal(71),
--   grant(72) => grant_signal(72),
--   grant(73) => grant_signal(73),
--   grant(74) => grant_signal(74),
--   grant(75) => grant_signal(75),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5),
--   request(61) =>request_signal(61),
--   request(62) =>request_signal(62),
--   request(63) =>request_signal(63),
--   request(64) =>request_signal(64),
--   request(65) =>request_signal(65),
--   request(66) =>request_signal(66),
--   request(67) =>request_signal(67),
--   request(68) =>request_signal(68),
--   request(69) =>request_signal(69),
--   request(70) =>request_signal(70),
--   request(71) =>request_signal(71),
--   request(72) =>request_signal(72),
--   request(73) =>request_signal(73),
--   request(74) =>request_signal(74),
--   request(75) =>request_signal(75)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(76) => grant_signal(76),
--   grant(77) => grant_signal(77),
--   grant(78) => grant_signal(78),
--   grant(79) => grant_signal(79),
--   grant(80) => grant_signal(80),
--   grant(81) => grant_signal(81),
--   grant(82) => grant_signal(82),
--   grant(83) => grant_signal(83),
--   grant(84) => grant_signal(84),
--   grant(85) => grant_signal(85),
--   grant(86) => grant_signal(86),
--   grant(87) => grant_signal(87),
--   grant(88) => grant_signal(88),
--   grant(89) => grant_signal(89),
--   grant(90) => grant_signal(90),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6),
--   request(76) =>request_signal(76),
--   request(77) =>request_signal(77),
--   request(78) =>request_signal(78),
--   request(79) =>request_signal(79),
--   request(80) =>request_signal(80),
--   request(81) =>request_signal(81),
--   request(82) =>request_signal(82),
--   request(83) =>request_signal(83),
--   request(84) =>request_signal(84),
--   request(85) =>request_signal(85),
--   request(86) =>request_signal(86),
--   request(87) =>request_signal(87),
--   request(88) =>request_signal(88),
--   request(89) =>request_signal(89),
--   request(90) =>request_signal(90)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(91) => grant_signal(91),
--   grant(92) => grant_signal(92),
--   grant(93) => grant_signal(93),
--   grant(94) => grant_signal(94),
--   grant(95) => grant_signal(95),
--   grant(96) => grant_signal(96),
--   grant(97) => grant_signal(97),
--   grant(98) => grant_signal(98),
--   grant(99) => grant_signal(99),
--   grant(100) => grant_signal(100),
--   grant(101) => grant_signal(101),
--   grant(102) => grant_signal(102),
--   grant(103) => grant_signal(103),
--   grant(104) => grant_signal(104),
--   grant(105) => grant_signal(105),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(7),
--   data_out_pulse =>crossbar_in_pulse(7),
--   request(91) =>request_signal(91),
--   request(92) =>request_signal(92),
--   request(93) =>request_signal(93),
--   request(94) =>request_signal(94),
--   request(95) =>request_signal(95),
--   request(96) =>request_signal(96),
--   request(97) =>request_signal(97),
--   request(98) =>request_signal(98),
--   request(99) =>request_signal(99),
--   request(100) =>request_signal(100),
--   request(101) =>request_signal(101),
--   request(102) =>request_signal(102),
--   request(103) =>request_signal(103),
--   request(104) =>request_signal(104),
--   request(105) =>request_signal(105)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(106) => grant_signal(106),
--   grant(107) => grant_signal(107),
--   grant(108) => grant_signal(108),
--   grant(109) => grant_signal(109),
--   grant(110) => grant_signal(110),
--   grant(111) => grant_signal(111),
--   grant(112) => grant_signal(112),
--   grant(113) => grant_signal(113),
--   grant(114) => grant_signal(114),
--   grant(115) => grant_signal(115),
--   grant(116) => grant_signal(116),
--   grant(117) => grant_signal(117),
--   grant(118) => grant_signal(118),
--   grant(119) => grant_signal(119),
--   grant(120) => grant_signal(120),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(8),
--   request(106) =>request_signal(106),
--   request(107) =>request_signal(107),
--   request(108) =>request_signal(108),
--   request(109) =>request_signal(109),
--   request(110) =>request_signal(110),
--   request(111) =>request_signal(111),
--   request(112) =>request_signal(112),
--   request(113) =>request_signal(113),
--   request(114) =>request_signal(114),
--   request(115) =>request_signal(115),
--   request(116) =>request_signal(116),
--   request(117) =>request_signal(117),
--   request(118) =>request_signal(118),
--   request(119) =>request_signal(119),
--   request(120) =>request_signal(120)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(121) => grant_signal(121),
--   grant(122) => grant_signal(122),
--   grant(123) => grant_signal(123),
--   grant(124) => grant_signal(124),
--   grant(125) => grant_signal(125),
--   grant(126) => grant_signal(126),
--   grant(127) => grant_signal(127),
--   grant(128) => grant_signal(128),
--   grant(129) => grant_signal(129),
--   grant(130) => grant_signal(130),
--   grant(131) => grant_signal(131),
--   grant(132) => grant_signal(132),
--   grant(133) => grant_signal(133),
--   grant(134) => grant_signal(134),
--   grant(135) => grant_signal(135),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port(9),
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(121) =>request_signal(121),
--   request(122) =>request_signal(122),
--   request(123) =>request_signal(123),
--   request(124) =>request_signal(124),
--   request(125) =>request_signal(125),
--   request(126) =>request_signal(126),
--   request(127) =>request_signal(127),
--   request(128) =>request_signal(128),
--   request(129) =>request_signal(129),
--   request(130) =>request_signal(130),
--   request(131) =>request_signal(131),
--   request(132) =>request_signal(132),
--   request(133) =>request_signal(133),
--   request(134) =>request_signal(134),
--   request(135) =>request_signal(135)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(136) => grant_signal(136),
--   grant(137) => grant_signal(137),
--   grant(138) => grant_signal(138),
--   grant(139) => grant_signal(139),
--   grant(140) => grant_signal(140),
--   grant(141) => grant_signal(141),
--   grant(142) => grant_signal(142),
--   grant(143) => grant_signal(143),
--   grant(144) => grant_signal(144),
--   grant(145) => grant_signal(145),
--   grant(146) => grant_signal(146),
--   grant(147) => grant_signal(147),
--   grant(148) => grant_signal(148),
--   grant(149) => grant_signal(149),
--   grant(150) => grant_signal(150),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(136) =>request_signal(136),
--   request(137) =>request_signal(137),
--   request(138) =>request_signal(138),
--   request(139) =>request_signal(139),
--   request(140) =>request_signal(140),
--   request(141) =>request_signal(141),
--   request(142) =>request_signal(142),
--   request(143) =>request_signal(143),
--   request(144) =>request_signal(144),
--   request(145) =>request_signal(145),
--   request(146) =>request_signal(146),
--   request(147) =>request_signal(147),
--   request(148) =>request_signal(148),
--   request(149) =>request_signal(149),
--   request(150) =>request_signal(150)
--);
--
--PORT11_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(11),
--   data_in_en => data_in_en(11),
--   reset => reset,
--   clk =>clk,
--   grant(151) => grant_signal(151),
--   grant(152) => grant_signal(152),
--   grant(153) => grant_signal(153),
--   grant(154) => grant_signal(154),
--   grant(155) => grant_signal(155),
--   grant(156) => grant_signal(156),
--   grant(157) => grant_signal(157),
--   grant(158) => grant_signal(158),
--   grant(159) => grant_signal(159),
--   grant(160) => grant_signal(160),
--   grant(161) => grant_signal(161),
--   grant(162) => grant_signal(162),
--   grant(163) => grant_signal(163),
--   grant(164) => grant_signal(164),
--   grant(165) => grant_signal(165),
--   fifo_full =>fifo_in_full(11),
--   priority_rotation =>  priority_rotation_signal(11),
--   fifo_empty => fifo_in_empty(11),
--   data_out =>crossbar_in_port(11),
--   data_out_pulse =>crossbar_in_pulse(11),
--   request(151) =>request_signal(151),
--   request(152) =>request_signal(152),
--   request(153) =>request_signal(153),
--   request(154) =>request_signal(154),
--   request(155) =>request_signal(155),
--   request(156) =>request_signal(156),
--   request(157) =>request_signal(157),
--   request(158) =>request_signal(158),
--   request(159) =>request_signal(159),
--   request(160) =>request_signal(160),
--   request(161) =>request_signal(161),
--   request(162) =>request_signal(162),
--   request(163) =>request_signal(163),
--   request(164) =>request_signal(164),
--   request(165) =>request_signal(165)
--);
--
--PORT12_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(12),
--   data_in_en => data_in_en(12),
--   reset => reset,
--   clk =>clk,
--   grant(166) => grant_signal(166),
--   grant(167) => grant_signal(167),
--   grant(168) => grant_signal(168),
--   grant(169) => grant_signal(169),
--   grant(170) => grant_signal(170),
--   grant(171) => grant_signal(171),
--   grant(172) => grant_signal(172),
--   grant(173) => grant_signal(173),
--   grant(174) => grant_signal(174),
--   grant(175) => grant_signal(175),
--   grant(176) => grant_signal(176),
--   grant(177) => grant_signal(177),
--   grant(178) => grant_signal(178),
--   grant(179) => grant_signal(179),
--   grant(180) => grant_signal(180),
--   fifo_full =>fifo_in_full(12),
--   priority_rotation =>  priority_rotation_signal(12),
--   fifo_empty => fifo_in_empty(12),
--   data_out =>crossbar_in_port(12),
--   data_out_pulse =>crossbar_in_pulse(12),
--   request(166) =>request_signal(166),
--   request(167) =>request_signal(167),
--   request(168) =>request_signal(168),
--   request(169) =>request_signal(169),
--   request(170) =>request_signal(170),
--   request(171) =>request_signal(171),
--   request(172) =>request_signal(172),
--   request(173) =>request_signal(173),
--   request(174) =>request_signal(174),
--   request(175) =>request_signal(175),
--   request(176) =>request_signal(176),
--   request(177) =>request_signal(177),
--   request(178) =>request_signal(178),
--   request(179) =>request_signal(179),
--   request(180) =>request_signal(180)
--);
--
--PORT13_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(13),
--   data_in_en => data_in_en(13),
--   reset => reset,
--   clk =>clk,
--   grant(181) => grant_signal(181),
--   grant(182) => grant_signal(182),
--   grant(183) => grant_signal(183),
--   grant(184) => grant_signal(184),
--   grant(185) => grant_signal(185),
--   grant(186) => grant_signal(186),
--   grant(187) => grant_signal(187),
--   grant(188) => grant_signal(188),
--   grant(189) => grant_signal(189),
--   grant(190) => grant_signal(190),
--   grant(191) => grant_signal(191),
--   grant(192) => grant_signal(192),
--   grant(193) => grant_signal(193),
--   grant(194) => grant_signal(194),
--   grant(195) => grant_signal(195),
--   fifo_full =>fifo_in_full(13),
--   priority_rotation =>  priority_rotation_signal(13),
--   fifo_empty => fifo_in_empty(13),
--   data_out =>crossbar_in_port(13),
--   data_out_pulse =>crossbar_in_pulse(13),
--   request(181) =>request_signal(181),
--   request(182) =>request_signal(182),
--   request(183) =>request_signal(183),
--   request(184) =>request_signal(184),
--   request(185) =>request_signal(185),
--   request(186) =>request_signal(186),
--   request(187) =>request_signal(187),
--   request(188) =>request_signal(188),
--   request(189) =>request_signal(189),
--   request(190) =>request_signal(190),
--   request(191) =>request_signal(191),
--   request(192) =>request_signal(192),
--   request(193) =>request_signal(193),
--   request(194) =>request_signal(194),
--   request(195) =>request_signal(195)
--);
--
--PORT14_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(14),
--   data_in_en => data_in_en(14),
--   reset => reset,
--   clk =>clk,
--   grant(196) => grant_signal(196),
--   grant(197) => grant_signal(197),
--   grant(198) => grant_signal(198),
--   grant(199) => grant_signal(199),
--   grant(200) => grant_signal(200),
--   grant(201) => grant_signal(201),
--   grant(202) => grant_signal(202),
--   grant(203) => grant_signal(203),
--   grant(204) => grant_signal(204),
--   grant(205) => grant_signal(205),
--   grant(206) => grant_signal(206),
--   grant(207) => grant_signal(207),
--   grant(208) => grant_signal(208),
--   grant(209) => grant_signal(209),
--   grant(210) => grant_signal(210),
--   fifo_full =>fifo_in_full(14),
--   priority_rotation =>  priority_rotation_signal(14),
--   fifo_empty => fifo_in_empty(14),
--   data_out =>crossbar_in_port(14),
--   data_out_pulse =>crossbar_in_pulse(14),
--   request(196) =>request_signal(196),
--   request(197) =>request_signal(197),
--   request(198) =>request_signal(198),
--   request(199) =>request_signal(199),
--   request(200) =>request_signal(200),
--   request(201) =>request_signal(201),
--   request(202) =>request_signal(202),
--   request(203) =>request_signal(203),
--   request(204) =>request_signal(204),
--   request(205) =>request_signal(205),
--   request(206) =>request_signal(206),
--   request(207) =>request_signal(207),
--   request(208) =>request_signal(208),
--   request(209) =>request_signal(209),
--   request(210) =>request_signal(210)
--);
--
--PORT15_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>15)
--PORT MAP(
--   data_in => Port_in(15),
--   data_in_en => data_in_en(15),
--   reset => reset,
--   clk =>clk,
--   grant(211) => grant_signal(211),
--   grant(212) => grant_signal(212),
--   grant(213) => grant_signal(213),
--   grant(214) => grant_signal(214),
--   grant(215) => grant_signal(215),
--   grant(216) => grant_signal(216),
--   grant(217) => grant_signal(217),
--   grant(218) => grant_signal(218),
--   grant(219) => grant_signal(219),
--   grant(220) => grant_signal(220),
--   grant(221) => grant_signal(221),
--   grant(222) => grant_signal(222),
--   grant(223) => grant_signal(223),
--   grant(224) => grant_signal(224),
--   grant(225) => grant_signal(225),
--   fifo_full =>fifo_in_full(15),
--   priority_rotation =>  priority_rotation_signal(15),
--   fifo_empty => fifo_in_empty(15),
--   data_out =>crossbar_in_port(15),
--   data_out_pulse =>crossbar_in_pulse(15),
--   request(211) =>request_signal(211),
--   request(212) =>request_signal(212),
--   request(213) =>request_signal(213),
--   request(214) =>request_signal(214),
--   request(215) =>request_signal(215),
--   request(216) =>request_signal(216),
--   request(217) =>request_signal(217),
--   request(218) =>request_signal(218),
--   request(219) =>request_signal(219),
--   request(220) =>request_signal(220),
--   request(221) =>request_signal(221),
--   request(222) =>request_signal(222),
--   request(223) =>request_signal(223),
--   request(224) =>request_signal(224),
--   request(225) =>request_signal(225)
--);
--
--end generate switch15x15;


-- switch 16 ports
switch16x16 : if number_of_ports = 16 generate
switch_16x16 :for i in 1 to number_of_ports generate
Constant j : natural:=number_of_ports*(i-1);
begin
--j<=number_of_ports*(i-1);
PORTx16_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
GENERIC MAP(number_of_ports =>16,port_num=>i)
PORT MAP(
   data_in => Port_in(i),
   data_in_en => data_in_en(i),
	cmd_in_en => cmd_in_en(i),
   reset => reset,
   clk =>clk,
   grant(1) => grant_signal(j+1),
   grant(2) => grant_signal(j+2),
   grant(3) => grant_signal(j+3),
   grant(4) => grant_signal(j+4),
   grant(5) => grant_signal(j+5),
   grant(6) => grant_signal(j+6),
   grant(7) => grant_signal(j+7),
   grant(8) => grant_signal(j+8),
   grant(9) => grant_signal(j+9),
   grant(10) => grant_signal(j+10),
   grant(11) => grant_signal(j+11),
   grant(12) => grant_signal(j+12),
   grant(13) => grant_signal(j+13),
   grant(14) => grant_signal(j+14),
   grant(15) => grant_signal(j+15),
   grant(16) => grant_signal(j+16),
   fifo_full =>fifo_in_full(i),
   priority_rotation => priority_rotation_signal(i),
   fifo_empty => fifo_in_empty(i),
   data_out =>crossbar_in_port(i),
   data_out_pulse =>crossbar_in_pulse(i),
   request(1) =>request_signal(j+1),
   request(2) =>request_signal(j+2),
   request(3) =>request_signal(j+3),
   request(4) =>request_signal(j+4),
   request(5) =>request_signal(j+5),
   request(6) =>request_signal(j+6),
   request(7) =>request_signal(j+7),
   request(8) =>request_signal(j+8),
   request(9) =>request_signal(j+9),
   request(10) =>request_signal(j+10),
   request(11) =>request_signal(j+11),
   request(12) =>request_signal(j+12),
   request(13) =>request_signal(j+13),
   request(14) =>request_signal(j+14),
   request(15) =>request_signal(j+15),
   request(16) =>request_signal(j+16)
);
end generate switch_16x16;
end generate switch16x16;
--PORT2_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(2),
--   data_in_en => data_in_en(2),
--   reset => reset,
--   clk =>clk,
--   grant(17) => grant_signal(17),
--   grant(18) => grant_signal(18),
--   grant(19) => grant_signal(19),
--   grant(20) => grant_signal(20),
--   grant(21) => grant_signal(21),
--   grant(22) => grant_signal(22),
--   grant(23) => grant_signal(23),
--   grant(24) => grant_signal(24),
--   grant(25) => grant_signal(25),
--   grant(26) => grant_signal(26),
--   grant(27) => grant_signal(27),
--   grant(28) => grant_signal(28),
--   grant(29) => grant_signal(29),
--   grant(30) => grant_signal(30),
--   grant(31) => grant_signal(31),
--   grant(32) => grant_signal(32),
--   fifo_full =>fifo_in_full(2),
--   priority_rotation =>  priority_rotation_signal(2),
--   fifo_empty => fifo_in_empty(2),
--   data_out =>crossbar_in_port2,
--   data_out_pulse =>crossbar_in_pulse(2,
--   request(17) =>request_signal(17),
--   request(18) =>request_signal(18),
--   request(19) =>request_signal(19),
--   request(20) =>request_signal(20),
--   request(21) =>request_signal(21),
--   request(22) =>request_signal(22),
--   request(23) =>request_signal(23),
--   request(24) =>request_signal(24),
--   request(25) =>request_signal(25),
--   request(26) =>request_signal(26),
--   request(27) =>request_signal(27),
--   request(28) =>request_signal(28),
--   request(29) =>request_signal(29),
--   request(30) =>request_signal(30),
--   request(31) =>request_signal(31),
--   request(32) =>request_signal(32)
--);
--
--PORT3_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(3),
--   data_in_en => data_in_en(3),
--   reset => reset,
--   clk =>clk,
--   grant(33) => grant_signal(33),
--   grant(34) => grant_signal(34),
--   grant(35) => grant_signal(35),
--   grant(36) => grant_signal(36),
--   grant(37) => grant_signal(37),
--   grant(38) => grant_signal(38),
--   grant(39) => grant_signal(39),
--   grant(40) => grant_signal(40),
--   grant(41) => grant_signal(41),
--   grant(42) => grant_signal(42),
--   grant(43) => grant_signal(43),
--   grant(44) => grant_signal(44),
--   grant(45) => grant_signal(45),
--   grant(46) => grant_signal(46),
--   grant(47) => grant_signal(47),
--   grant(48) => grant_signal(48),
--   fifo_full =>fifo_in_full(3),
--   priority_rotation =>  priority_rotation_signal(3),
--   fifo_empty => fifo_in_empty(3),
--   data_out =>crossbar_in_port3,
--   data_out_pulse =>crossbar_in_pulse(3,
--   request(33) =>request_signal(33),
--   request(34) =>request_signal(34),
--   request(35) =>request_signal(35),
--   request(36) =>request_signal(36),
--   request(37) =>request_signal(37),
--   request(38) =>request_signal(38),
--   request(39) =>request_signal(39),
--   request(40) =>request_signal(40),
--   request(41) =>request_signal(41),
--   request(42) =>request_signal(42),
--   request(43) =>request_signal(43),
--   request(44) =>request_signal(44),
--   request(45) =>request_signal(45),
--   request(46) =>request_signal(46),
--   request(47) =>request_signal(47),
--   request(48) =>request_signal(48)
--);
--
--PORT4_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(4),
--   data_in_en => data_in_en(4),
--   reset => reset,
--   clk =>clk,
--   grant(49) => grant_signal(49),
--   grant(50) => grant_signal(50),
--   grant(51) => grant_signal(51),
--   grant(52) => grant_signal(52),
--   grant(53) => grant_signal(53),
--   grant(54) => grant_signal(54),
--   grant(55) => grant_signal(55),
--   grant(56) => grant_signal(56),
--   grant(57) => grant_signal(57),
--   grant(58) => grant_signal(58),
--   grant(59) => grant_signal(59),
--   grant(60) => grant_signal(60),
--   grant(61) => grant_signal(61),
--   grant(62) => grant_signal(62),
--   grant(63) => grant_signal(63),
--   grant(64) => grant_signal(64),
--   fifo_full =>fifo_in_full(4),
--   priority_rotation =>  priority_rotation_signal(4),
--   fifo_empty => fifo_in_empty(4),
--   data_out =>crossbar_in_port(4),
--   data_out_pulse =>crossbar_in_pulse(4,
--   request(49) =>request_signal(49),
--   request(50) =>request_signal(50),
--   request(51) =>request_signal(51),
--   request(52) =>request_signal(52),
--   request(53) =>request_signal(53),
--   request(54) =>request_signal(54),
--   request(55) =>request_signal(55),
--   request(56) =>request_signal(56),
--   request(57) =>request_signal(57),
--   request(58) =>request_signal(58),
--   request(59) =>request_signal(59),
--   request(60) =>request_signal(60),
--   request(61) =>request_signal(61),
--   request(62) =>request_signal(62),
--   request(63) =>request_signal(63),
--   request(64) =>request_signal(64)
--);
--
--PORT5_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(5),
--   data_in_en => data_in_en(5),
--   reset => reset,
--   clk =>clk,
--   grant(65) => grant_signal(65),
--   grant(66) => grant_signal(66),
--   grant(67) => grant_signal(67),
--   grant(68) => grant_signal(68),
--   grant(69) => grant_signal(69),
--   grant(70) => grant_signal(70),
--   grant(71) => grant_signal(71),
--   grant(72) => grant_signal(72),
--   grant(73) => grant_signal(73),
--   grant(74) => grant_signal(74),
--   grant(75) => grant_signal(75),
--   grant(76) => grant_signal(76),
--   grant(77) => grant_signal(77),
--   grant(78) => grant_signal(78),
--   grant(79) => grant_signal(79),
--   grant(80) => grant_signal(80),
--   fifo_full =>fifo_in_full(5),
--   priority_rotation =>  priority_rotation_signal(5),
--   fifo_empty => fifo_in_empty(5),
--   data_out =>crossbar_in_port(5),
--   data_out_pulse =>crossbar_in_pulse(5,
--   request(65) =>request_signal(65),
--   request(66) =>request_signal(66),
--   request(67) =>request_signal(67),
--   request(68) =>request_signal(68),
--   request(69) =>request_signal(69),
--   request(70) =>request_signal(70),
--   request(71) =>request_signal(71),
--   request(72) =>request_signal(72),
--   request(73) =>request_signal(73),
--   request(74) =>request_signal(74),
--   request(75) =>request_signal(75),
--   request(76) =>request_signal(76),
--   request(77) =>request_signal(77),
--   request(78) =>request_signal(78),
--   request(79) =>request_signal(79),
--   request(80) =>request_signal(80)
--);
--
--PORT6_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(6),
--   data_in_en => data_in_en(6),
--   reset => reset,
--   clk =>clk,
--   grant(81) => grant_signal(81),
--   grant(82) => grant_signal(82),
--   grant(83) => grant_signal(83),
--   grant(84) => grant_signal(84),
--   grant(85) => grant_signal(85),
--   grant(86) => grant_signal(86),
--   grant(87) => grant_signal(87),
--   grant(88) => grant_signal(88),
--   grant(89) => grant_signal(89),
--   grant(90) => grant_signal(90),
--   grant(91) => grant_signal(91),
--   grant(92) => grant_signal(92),
--   grant(93) => grant_signal(93),
--   grant(94) => grant_signal(94),
--   grant(95) => grant_signal(95),
--   grant(96) => grant_signal(96),
--   fifo_full =>fifo_in_full(6),
--   priority_rotation =>  priority_rotation_signal(6),
--   fifo_empty => fifo_in_empty(6),
--   data_out =>crossbar_in_port(6),
--   data_out_pulse =>crossbar_in_pulse(6,
--   request(81) =>request_signal(81),
--   request(82) =>request_signal(82),
--   request(83) =>request_signal(83),
--   request(84) =>request_signal(84),
--   request(85) =>request_signal(85),
--   request(86) =>request_signal(86),
--   request(87) =>request_signal(87),
--   request(88) =>request_signal(88),
--   request(89) =>request_signal(89),
--   request(90) =>request_signal(90),
--   request(91) =>request_signal(91),
--   request(92) =>request_signal(92),
--   request(93) =>request_signal(93),
--   request(94) =>request_signal(94),
--   request(95) =>request_signal(95),
--   request(96) =>request_signal(96)
--);
--
--PORT7_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(7),
--   data_in_en => data_in_en(7),
--   reset => reset,
--   clk =>clk,
--   grant(97) => grant_signal(97),
--   grant(98) => grant_signal(98),
--   grant(99) => grant_signal(99),
--   grant(0) => grant_signal(100),
--   grant(1) => grant_signal(101),
--   grant(2) => grant_signal(102),
--   grant(3) => grant_signal(103),
--   grant(4) => grant_signal(104),
--   grant(5) => grant_signal(105),
--   grant(6) => grant_signal(106),
--   grant(7) => grant_signal(107),
--   grant(8) => grant_signal(108),
--   grant(9) => grant_signal(109),
--   grant(110) => grant_signal(110),
--   grant(111) => grant_signal(111),
--   grant(112) => grant_signal(112),
--   fifo_full =>fifo_in_full(7),
--   priority_rotation =>  priority_rotation_signal(7),
--   fifo_empty => fifo_in_empty(7),
--   data_out =>crossbar_in_port(8),
--   data_out_pulse =>crossbar_in_pulse(7,
--   request(97) =>request_signal(97),
--   request(98) =>request_signal(98),
--   request(99) =>request_signal(99),
--   request(100) =>request_signal(100),
--   request(101) =>request_signal(101),
--   request(102) =>request_signal(102),
--   request(103) =>request_signal(103),
--   request(104) =>request_signal(104),
--   request(105) =>request_signal(105),
--   request(106) =>request_signal(106),
--   request(107) =>request_signal(107),
--   request(108) =>request_signal(108),
--   request(109) =>request_signal(109),
--   request(110) =>request_signal(110),
--   request(111) =>request_signal(111),
--   request(112) =>request_signal(112)
--);
--
--PORT8_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(8),
--   data_in_en => data_in_en(8),
--   reset => reset,
--   clk =>clk,
--   grant(113) => grant_signal(113),
--   grant(114) => grant_signal(114),
--   grant(115) => grant_signal(115),
--   grant(116) => grant_signal(116),
--   grant(117) => grant_signal(117),
--   grant(118) => grant_signal(118),
--   grant(119) => grant_signal(119),
--   grant(120) => grant_signal(120),
--   grant(121) => grant_signal(121),
--   grant(122) => grant_signal(122),
--   grant(123) => grant_signal(123),
--   grant(124) => grant_signal(124),
--   grant(125) => grant_signal(125),
--   grant(126) => grant_signal(126),
--   grant(127) => grant_signal(127),
--   grant(128) => grant_signal(128),
--   fifo_full =>fifo_in_full(8),
--   priority_rotation =>  priority_rotation_signal(8),
--   fifo_empty => fifo_in_empty(8),
--   data_out =>crossbar_in_port8,
--   data_out_pulse =>crossbar_in_pulse(8,
--   request(113) =>request_signal(113),
--   request(114) =>request_signal(114),
--   request(115) =>request_signal(115),
--   request(116) =>request_signal(116),
--   request(117) =>request_signal(117),
--   request(118) =>request_signal(118),
--   request(119) =>request_signal(119),
--   request(120) =>request_signal(120),
--   request(121) =>request_signal(121),
--   request(122) =>request_signal(122),
--   request(123) =>request_signal(123),
--   request(124) =>request_signal(124),
--   request(125) =>request_signal(125),
--   request(126) =>request_signal(126),
--   request(127) =>request_signal(127),
--   request(128) =>request_signal(128)
--);
--
--PORT9_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(9),
--   data_in_en => data_in_en(9),
--   reset => reset,
--   clk =>clk,
--   grant(129) => grant_signal(129),
--   grant(130) => grant_signal(130),
--   grant(131) => grant_signal(131),
--   grant(132) => grant_signal(132),
--   grant(133) => grant_signal(133),
--   grant(134) => grant_signal(134),
--   grant(135) => grant_signal(135),
--   grant(136) => grant_signal(136),
--   grant(137) => grant_signal(137),
--   grant(138) => grant_signal(138),
--   grant(139) => grant_signal(139),
--   grant(140) => grant_signal(140),
--   grant(141) => grant_signal(141),
--   grant(142) => grant_signal(142),
--   grant(143) => grant_signal(143),
--   grant(144) => grant_signal(144),
--   fifo_full =>fifo_in_full(9),
--   priority_rotation =>  priority_rotation_signal(9),
--   fifo_empty => fifo_in_empty(9),
--   data_out =>crossbar_in_port9,
--   data_out_pulse =>crossbar_in_pulse(9),
--   request(129) =>request_signal(129),
--   request(130) =>request_signal(130),
--   request(131) =>request_signal(131),
--   request(132) =>request_signal(132),
--   request(133) =>request_signal(133),
--   request(134) =>request_signal(134),
--   request(135) =>request_signal(135),
--   request(136) =>request_signal(136),
--   request(137) =>request_signal(137),
--   request(138) =>request_signal(138),
--   request(139) =>request_signal(139),
--   request(140) =>request_signal(140),
--   request(141) =>request_signal(141),
--   request(142) =>request_signal(142),
--   request(143) =>request_signal(143),
--   request(144) =>request_signal(144)
--);
--
--PORT10_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(10),
--   data_in_en => data_in_en(10),
--   reset => reset,
--   clk =>clk,
--   grant(145) => grant_signal(145),
--   grant(146) => grant_signal(146),
--   grant(147) => grant_signal(147),
--   grant(148) => grant_signal(148),
--   grant(149) => grant_signal(149),
--   grant(150) => grant_signal(150),
--   grant(151) => grant_signal(151),
--   grant(152) => grant_signal(152),
--   grant(153) => grant_signal(153),
--   grant(154) => grant_signal(154),
--   grant(155) => grant_signal(155),
--   grant(156) => grant_signal(156),
--   grant(157) => grant_signal(157),
--   grant(158) => grant_signal(158),
--   grant(159) => grant_signal(159),
--   grant(160) => grant_signal(160),
--   fifo_full =>fifo_in_full(10),
--   priority_rotation =>  priority_rotation_signal(10),
--   fifo_empty => fifo_in_empty(10),
--   data_out =>crossbar_in_port(10),
--   data_out_pulse =>crossbar_in_pulse(10),
--   request(145) =>request_signal(145),
--   request(146) =>request_signal(146),
--   request(147) =>request_signal(147),
--   request(148) =>request_signal(148),
--   request(149) =>request_signal(149),
--   request(150) =>request_signal(150),
--   request(151) =>request_signal(151),
--   request(152) =>request_signal(152),
--   request(153) =>request_signal(153),
--   request(154) =>request_signal(154),
--   request(155) =>request_signal(155),
--   request(156) =>request_signal(156),
--   request(157) =>request_signal(157),
--   request(158) =>request_signal(158),
--   request(159) =>request_signal(159),
--   request(160) =>request_signal(160)
--);
--
--PORT11_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(11),
--   data_in_en => data_in_en(11),
--   reset => reset,
--   clk =>clk,
--   grant(161) => grant_signal(161),
--   grant(162) => grant_signal(162),
--   grant(163) => grant_signal(163),
--   grant(164) => grant_signal(164),
--   grant(165) => grant_signal(165),
--   grant(166) => grant_signal(166),
--   grant(167) => grant_signal(167),
--   grant(168) => grant_signal(168),
--   grant(169) => grant_signal(169),
--   grant(170) => grant_signal(170),
--   grant(171) => grant_signal(171),
--   grant(172) => grant_signal(172),
--   grant(173) => grant_signal(173),
--   grant(174) => grant_signal(174),
--   grant(175) => grant_signal(175),
--   grant(176) => grant_signal(176),
--   fifo_full =>fifo_in_full(11),
--   priority_rotation =>  priority_rotation_signal(11),
--   fifo_empty => fifo_in_empty(11),
--   data_out =>crossbar_in_port(11),
--   data_out_pulse =>crossbar_in_pulse(11),
--   request(161) =>request_signal(161),
--   request(162) =>request_signal(162),
--   request(163) =>request_signal(163),
--   request(164) =>request_signal(164),
--   request(165) =>request_signal(165),
--   request(166) =>request_signal(166),
--   request(167) =>request_signal(167),
--   request(168) =>request_signal(168),
--   request(169) =>request_signal(169),
--   request(170) =>request_signal(170),
--   request(171) =>request_signal(171),
--   request(172) =>request_signal(172),
--   request(173) =>request_signal(173),
--   request(174) =>request_signal(174),
--   request(175) =>request_signal(175),
--   request(176) =>request_signal(176)
--);
--
--PORT12_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(12),
--   data_in_en => data_in_en(12),
--   reset => reset,
--   clk =>clk,
--   grant(177) => grant_signal(177),
--   grant(178) => grant_signal(178),
--   grant(179) => grant_signal(179),
--   grant(180) => grant_signal(180),
--   grant(181) => grant_signal(181),
--   grant(182) => grant_signal(182),
--   grant(183) => grant_signal(183),
--   grant(184) => grant_signal(184),
--   grant(185) => grant_signal(185),
--   grant(186) => grant_signal(186),
--   grant(187) => grant_signal(187),
--   grant(188) => grant_signal(188),
--   grant(189) => grant_signal(189),
--   grant(190) => grant_signal(190),
--   grant(191) => grant_signal(191),
--   grant(192) => grant_signal(192),
--   fifo_full =>fifo_in_full(12),
--   priority_rotation =>  priority_rotation_signal(12),
--   fifo_empty => fifo_in_empty(12),
--   data_out =>crossbar_in_port(12),
--   data_out_pulse =>crossbar_in_pulse(12),
--   request(177) =>request_signal(177),
--   request(178) =>request_signal(178),
--   request(179) =>request_signal(179),
--   request(180) =>request_signal(180),
--   request(181) =>request_signal(181),
--   request(182) =>request_signal(182),
--   request(183) =>request_signal(183),
--   request(184) =>request_signal(184),
--   request(185) =>request_signal(185),
--   request(186) =>request_signal(186),
--   request(187) =>request_signal(187),
--   request(188) =>request_signal(188),
--   request(189) =>request_signal(189),
--   request(190) =>request_signal(190),
--   request(191) =>request_signal(191),
--   request(192) =>request_signal(192)
--);
--
--PORT13_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(13),
--   data_in_en => data_in_en(13),
--   reset => reset,
--   clk =>clk,
--   grant(193) => grant_signal(193),
--   grant(194) => grant_signal(194),
--   grant(195) => grant_signal(195),
--   grant(196) => grant_signal(196),
--   grant(197) => grant_signal(197),
--   grant(198) => grant_signal(198),
--   grant(199) => grant_signal(199),
--   grant(200) => grant_signal(200),
--   grant(201) => grant_signal(201),
--   grant(202) => grant_signal(202),
--   grant(203) => grant_signal(203),
--   grant(204) => grant_signal(204),
--   grant(205) => grant_signal(205),
--   grant(206) => grant_signal(206),
--   grant(207) => grant_signal(207),
--   grant(208) => grant_signal(208),
--   fifo_full =>fifo_in_full(13),
--   priority_rotation =>  priority_rotation_signal(13),
--   fifo_empty => fifo_in_empty(13),
--   data_out =>crossbar_in_port13,
--   data_out_pulse =>crossbar_in_pulse(13,
--   request(193) =>request_signal(193),
--   request(194) =>request_signal(194),
--   request(195) =>request_signal(195),
--   request(196) =>request_signal(196),
--   request(197) =>request_signal(197),
--   request(198) =>request_signal(198),
--   request(199) =>request_signal(199),
--   request(200) =>request_signal(200),
--   request(201) =>request_signal(201),
--   request(202) =>request_signal(202),
--   request(203) =>request_signal(203),
--   request(204) =>request_signal(204),
--   request(205) =>request_signal(205),
--   request(206) =>request_signal(206),
--   request(207) =>request_signal(207),
--   request(208) =>request_signal(208)
--);
--
--PORT14_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(14),
--   data_in_en => data_in_en(14),
--   reset => reset,
--   clk =>clk,
--   grant(209) => grant_signal(209),
--   grant(210) => grant_signal(210),
--   grant(211) => grant_signal(211),
--   grant(212) => grant_signal(212),
--   grant(213) => grant_signal(213),
--   grant(214) => grant_signal(214),
--   grant(215) => grant_signal(215),
--   grant(216) => grant_signal(216),
--   grant(217) => grant_signal(217),
--   grant(218) => grant_signal(218),
--   grant(219) => grant_signal(219),
--   grant(220) => grant_signal(220),
--   grant(221) => grant_signal(221),
--   grant(222) => grant_signal(222),
--   grant(223) => grant_signal(223),
--   grant(224) => grant_signal(224),
--   fifo_full =>fifo_in_full(14),
--   priority_rotation =>  priority_rotation_signal(14),
--   fifo_empty => fifo_in_empty(14),
--   data_out =>crossbar_in_port(14),
--   data_out_pulse =>crossbar_in_pulse(14),
--   request(209) =>request_signal(209),
--   request(210) =>request_signal(210),
--   request(211) =>request_signal(211),
--   request(212) =>request_signal(212),
--   request(213) =>request_signal(213),
--   request(214) =>request_signal(214),
--   request(215) =>request_signal(215),
--   request(216) =>request_signal(216),
--   request(217) =>request_signal(217),
--   request(218) =>request_signal(218),
--   request(219) =>request_signal(219),
--   request(220) =>request_signal(220),
--   request(221) =>request_signal(221),
--   request(222) =>request_signal(222),
--   request(223) =>request_signal(223),
--   request(224) =>request_signal(224)
--);
--
--PORT15_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(15),
--   data_in_en => data_in_en(15),
--   reset => reset,
--   clk =>clk,
--   grant(225) => grant_signal(225),
--   grant(226) => grant_signal(226),
--   grant(227) => grant_signal(227),
--   grant(228) => grant_signal(228),
--   grant(229) => grant_signal(229),
--   grant(230) => grant_signal(230),
--   grant(231) => grant_signal(231),
--   grant(232) => grant_signal(232),
--   grant(233) => grant_signal(233),
--   grant(234) => grant_signal(234),
--   grant(235) => grant_signal(235),
--   grant(236) => grant_signal(236),
--   grant(237) => grant_signal(237),
--   grant(238) => grant_signal(238),
--   grant(239) => grant_signal(239),
--   grant(240) => grant_signal(240),
--   fifo_full =>fifo_in_full(15),
--   priority_rotation =>  priority_rotation_signal(15),
--   fifo_empty => fifo_in_empty(15),
--   data_out =>crossbar_in_port(15),
--   data_out_pulse =>crossbar_in_pulse(15),
--   request(225) =>request_signal(225),
--   request(226) =>request_signal(226),
--   request(227) =>request_signal(227),
--   request(228) =>request_signal(228),
--   request(229) =>request_signal(229),
--   request(230) =>request_signal(230),
--   request(231) =>request_signal(231),
--   request(232) =>request_signal(232),
--   request(233) =>request_signal(233),
--   request(234) =>request_signal(234),
--   request(235) =>request_signal(235),
--   request(236) =>request_signal(236),
--   request(237) =>request_signal(237),
--   request(238) =>request_signal(238),
--   request(239) =>request_signal(239),
--   request(240) =>request_signal(240)
--);
--
--PORT16_INPUT_PORT_MODULE: INPUT_PORT_MODULE 
--GENERIC MAP(number_of_ports =>16)
--PORT MAP(
--   data_in => Port_in(16),
--   data_in_en => data_in_en(16),
--   reset => reset,
--   clk =>clk,
--   grant(241) => grant_signal(241),
--   grant(242) => grant_signal(242),
--   grant(243) => grant_signal(243),
--   grant(244) => grant_signal(244),
--   grant(245) => grant_signal(245),
--   grant(246) => grant_signal(246),
--   grant(247) => grant_signal(247),
--   grant(248) => grant_signal(248),
--   grant(249) => grant_signal(249),
--   grant(250) => grant_signal(250),
--   grant(251) => grant_signal(251),
--   grant(252) => grant_signal(252),
--   grant(253) => grant_signal(253),
--   grant(254) => grant_signal(254),
--   grant(255) => grant_signal(255),
--   grant(256) => grant_signal(256),
--   fifo_full =>fifo_in_full(16),
--   priority_rotation =>  priority_rotation_signal(16),
--   fifo_empty => fifo_in_empty(16),
--   data_out =>crossbar_in_port(16),
--   data_out_pulse =>crossbar_in_pulse(16),
--   request(241) =>request_signal(241),
--   request(242) =>request_signal(242),
--   request(243) =>request_signal(243),
--   request(244) =>request_signal(244),
--   request(245) =>request_signal(245),
--   request(246) =>request_signal(246),
--   request(247) =>request_signal(247),
--   request(248) =>request_signal(248),
--   request(249) =>request_signal(249),
--   request(250) =>request_signal(250),
--   request(251) =>request_signal(251),
--   request(252) =>request_signal(252),
--   request(253) =>request_signal(253),
--   request(254) =>request_signal(254),
--   request(255) =>request_signal(255),
--   request(256) =>request_signal(256)
--);
--
--end generate switch16x16;
-- intstanciation et connexion des modules des ports de sorties fonction du nombre de ports
-- le circuit genere depend du parametre generique nombre de ports
-- switch 2 ports
port_out_switch2x2 : if number_of_ports = 2 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

end generate port_out_switch2x2;


-- switch 3 ports
port_out_switch3x3 : if number_of_ports = 3 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

end generate port_out_switch3x3;


-- switch 4 ports
port_out_switch4x4 : if number_of_ports = 4 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

end generate port_out_switch4x4;


-- switch 5 ports
port_out_switch5x5 : if number_of_ports = 5 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

end generate port_out_switch5x5;


-- switch 6 ports
port_out_switch6x6 : if number_of_ports = 6 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

end generate port_out_switch6x6;


-- switch 7 ports
port_out_switch7x7 : if number_of_ports = 7 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

end generate port_out_switch7x7;


-- switch 8 ports
port_out_switch8x8 : if number_of_ports = 8 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

end generate port_out_switch8x8;


-- switch 9 ports
port_out_switch9x9 : if number_of_ports = 9 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

end generate port_out_switch9x9;


-- switch 10 ports
port_out_switch10x10 : if number_of_ports = 10 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

PORT10_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(10),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(10),
     data_out =>Port_out(10),
     fifo_full =>fifo_out_full_signal(10),
     data_avalaible => data_available(10),
     rd_out_en => data_out_en(10)
    );

end generate port_out_switch10x10;


-- switch 11 ports
port_out_switch11x11 : if number_of_ports = 11 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

PORT10_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(10),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(10),
     data_out =>Port_out(10),
     fifo_full =>fifo_out_full_signal(10),
     data_avalaible => data_available(10),
     rd_out_en => data_out_en(10)
    );

PORT11_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(11),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(11),
     data_out =>Port_out(11),
     fifo_full =>fifo_out_full_signal(11),
     data_avalaible => data_available(11),
     rd_out_en => data_out_en(11)
    );

end generate port_out_switch11x11;


-- switch 12 ports
port_out_switch12x12 : if number_of_ports = 12 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

PORT10_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(10),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(10),
     data_out =>Port_out(10),
     fifo_full =>fifo_out_full_signal(10),
     data_avalaible => data_available(10),
     rd_out_en => data_out_en(10)
    );

PORT11_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(11),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(11),
     data_out =>Port_out(11),
     fifo_full =>fifo_out_full_signal(11),
     data_avalaible => data_available(11),
     rd_out_en => data_out_en(11)
    );

PORT12_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(12),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(12),
     data_out =>Port_out(12),
     fifo_full =>fifo_out_full_signal(12),
     data_avalaible => data_available(12),
     rd_out_en => data_out_en(12)
    );

end generate port_out_switch12x12;


-- switch 13 ports
port_out_switch13x13 : if number_of_ports = 13 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

PORT10_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(10),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(10),
     data_out =>Port_out(10),
     fifo_full =>fifo_out_full_signal(10),
     data_avalaible => data_available(10),
     rd_out_en => data_out_en(10)
    );

PORT11_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(11),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(11),
     data_out =>Port_out(11),
     fifo_full =>fifo_out_full_signal(11),
     data_avalaible => data_available(11),
     rd_out_en => data_out_en(11)
    );

PORT12_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(12),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(12),
     data_out =>Port_out(12),
     fifo_full =>fifo_out_full_signal(12),
     data_avalaible => data_available(12),
     rd_out_en => data_out_en(12)
    );

PORT13_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(13),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(13),
     data_out =>Port_out(13),
     fifo_full =>fifo_out_full_signal(13),
     data_avalaible => data_available(13),
     rd_out_en => data_out_en(13)
    );

end generate port_out_switch13x13;


-- switch 14 ports
port_out_switch14x14 : if number_of_ports = 14 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

PORT10_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(10),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(10),
     data_out =>Port_out(10),
     fifo_full =>fifo_out_full_signal(10),
     data_avalaible => data_available(10),
     rd_out_en => data_out_en(10)
    );

PORT11_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(11),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(11),
     data_out =>Port_out(11),
     fifo_full =>fifo_out_full_signal(11),
     data_avalaible => data_available(11),
     rd_out_en => data_out_en(11)
    );

PORT12_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(12),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(12),
     data_out =>Port_out(12),
     fifo_full =>fifo_out_full_signal(12),
     data_avalaible => data_available(12),
     rd_out_en => data_out_en(12)
    );

PORT13_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(13),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(13),
     data_out =>Port_out(13),
     fifo_full =>fifo_out_full_signal(13),
     data_avalaible => data_available(13),
     rd_out_en => data_out_en(13)
    );

PORT14_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(14),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(14),
     data_out =>Port_out(14),
     fifo_full =>fifo_out_full_signal(14),
     data_avalaible => data_available(14),
     rd_out_en => data_out_en(14)
    );

end generate port_out_switch14x14;


-- switch 15 ports
port_out_switch15x15 : if number_of_ports = 15 generate

PORT1_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(1),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(1),
     data_out =>Port_out(1),
     fifo_full =>fifo_out_full_signal(1),
     data_avalaible => data_available(1),
     rd_out_en => data_out_en(1)
    );

PORT2_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(2),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(2),
     data_out =>Port_out(2),
     fifo_full =>fifo_out_full_signal(2),
     data_avalaible => data_available(2),
     rd_out_en => data_out_en(2)
    );

PORT3_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(3),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(3),
     data_out =>Port_out(3),
     fifo_full =>fifo_out_full_signal(3),
     data_avalaible => data_available(3),
     rd_out_en => data_out_en(3)
    );

PORT4_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(4),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(4),
     data_out =>Port_out(4),
     fifo_full =>fifo_out_full_signal(4),
     data_avalaible => data_available(4),
     rd_out_en => data_out_en(4)
    );

PORT5_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(5),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(5),
     data_out =>Port_out(5),
     fifo_full =>fifo_out_full_signal(5),
     data_avalaible => data_available(5),
     rd_out_en => data_out_en(5)
    );

PORT6_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(6),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(6),
     data_out =>Port_out(6),
     fifo_full =>fifo_out_full_signal(6),
     data_avalaible => data_available(6),
     rd_out_en => data_out_en(6)
    );

PORT7_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(7),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(7),
     data_out =>Port_out(7),
     fifo_full =>fifo_out_full_signal(7),
     data_avalaible => data_available(7),
     rd_out_en => data_out_en(7)
    );

PORT8_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(8),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(8),
     data_out =>Port_out(8),
     fifo_full =>fifo_out_full_signal(8),
     data_avalaible => data_available(8),
     rd_out_en => data_out_en(8)
    );

PORT9_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(9),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(9),
     data_out =>Port_out(9),
     fifo_full =>fifo_out_full_signal(9),
     data_avalaible => data_available(9),
     rd_out_en => data_out_en(9)
    );

PORT10_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(10),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(10),
     data_out =>Port_out(10),
     fifo_full =>fifo_out_full_signal(10),
     data_avalaible => data_available(10),
     rd_out_en => data_out_en(10)
    );

PORT11_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(11),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(11),
     data_out =>Port_out(11),
     fifo_full =>fifo_out_full_signal(11),
     data_avalaible => data_available(11),
     rd_out_en => data_out_en(11)
    );

PORT12_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(12),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(12),
     data_out =>Port_out(12),
     fifo_full =>fifo_out_full_signal(12),
     data_avalaible => data_available(12),
     rd_out_en => data_out_en(12)
    );

PORT13_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(13),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(13),
     data_out =>Port_out(13),
     fifo_full =>fifo_out_full_signal(13),
     data_avalaible => data_available(13),
     rd_out_en => data_out_en(13)
    );

PORT14_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(14),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(14),
     data_out =>Port_out(14),
     fifo_full =>fifo_out_full_signal(14),
     data_avalaible => data_available(14),
     rd_out_en => data_out_en(14)
    );

PORT15_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(15),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(15),
     data_out =>Port_out(15),
     fifo_full =>fifo_out_full_signal(15),
     data_avalaible => data_available(15),
     rd_out_en => data_out_en(15)
    );

end generate port_out_switch15x15;


-- switch 16 ports
port_out_switch16x16 : if number_of_ports = 16 generate
port_out_switch_16x16:for i in 1 to number_of_ports generate
  begin
  PORTx16_OUTPUT_PORT_MODULE: OUTPUT_PORT_MODULE 
   PORT MAP(
     data_in => crossbar_out_port(i),
     reset => reset,
     clk => clk,
     wr_en =>crossbar_out_pulse(i),
     data_out =>Port_out(i),
     fifo_full =>fifo_out_full_signal(i),
     data_avalaible => data_available(i),
     rd_out_en => data_out_en(i)
    );
end generate port_out_switch_16x16;

end generate port_out_switch16x16;

-- intstanciation et connexion des crossbars du  switch en fonction du nombre de ports
-- le circuit genere depend du parametre generique nombre de ports
-- switch 2 ports
crossbar_switch2x2 : if number_of_ports = 2 generate

Switch_Crossbar2_2: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>2)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => "00000000",
   Port4_in => "00000000",
   Port5_in => "00000000",
   Port6_in => "00000000",
   Port7_in => "00000000",
   Port8_in => "00000000",
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in =>'0' ,
   Port4_pulse_in =>'0' ,
   Port5_pulse_in =>'0' ,
   Port6_pulse_in =>'0' ,
   Port7_pulse_in =>'0' ,
   Port8_pulse_in =>'0' ,
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
   Ctrl => Grant_signal);
end generate crossbar_switch2x2;


-- switch 3 ports
crossbar_switch3x3 : if number_of_ports = 3 generate

Switch_Crossbar3_3: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>3)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => "00000000",
   Port5_in => "00000000",
   Port6_in => "00000000",
   Port7_in => "00000000",
   Port8_in => "00000000",
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in =>'0' ,
   Port5_pulse_in =>'0' ,
   Port6_pulse_in =>'0' ,
   Port7_pulse_in =>'0' ,
   Port8_pulse_in =>'0' ,
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
   Ctrl => Grant_signal);
end generate crossbar_switch3x3;


-- switch 4 ports
crossbar_switch4x4 : if number_of_ports = 4 generate

Switch_Crossbar4_4: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>4)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => "00000000",
   Port6_in => "00000000",
   Port7_in => "00000000",
   Port8_in => "00000000",
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in =>'0' ,
   Port6_pulse_in =>'0' ,
   Port7_pulse_in =>'0' ,
   Port8_pulse_in =>'0' ,
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
   Ctrl => Grant_signal);
end generate crossbar_switch4x4;


-- switch 5 ports
crossbar_switch5x5 : if number_of_ports = 5 generate

Switch_Crossbar5_5: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>5)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => "00000000",
   Port7_in => "00000000",
   Port8_in => "00000000",
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in =>'0' ,
   Port7_pulse_in =>'0' ,
   Port8_pulse_in =>'0' ,
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
   Ctrl => Grant_signal);
end generate crossbar_switch5x5;


-- switch 6 ports
crossbar_switch6x6 : if number_of_ports = 6 generate

Switch_Crossbar6_6: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>6)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => "00000000",
   Port8_in => "00000000",
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in =>'0' ,
   Port8_pulse_in =>'0' ,
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
   Ctrl => Grant_signal);
end generate crossbar_switch6x6;


-- switch 7 ports
crossbar_switch7x7 : if number_of_ports = 7 generate

Switch_Crossbar7_7: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>7)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => "00000000",
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in =>'0' ,
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
   Ctrl => Grant_signal);
end generate crossbar_switch7x7;


-- switch 8 ports
crossbar_switch8x8 : if number_of_ports = 8 generate

Switch_Crossbar8_8: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>8)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => "00000000",
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in =>'0' ,
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
   Ctrl => Grant_signal);
end generate crossbar_switch8x8;


-- switch 9 ports
crossbar_switch9x9 : if number_of_ports = 9 generate

Switch_Crossbar9_9: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>9)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => "00000000",
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in =>'0' ,
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
   Ctrl => Grant_signal);
end generate crossbar_switch9x9;


-- switch 10 ports
crossbar_switch10x10 : if number_of_ports = 10 generate

Switch_Crossbar10_10: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>10)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => "00000000",
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in =>'0' ,
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
   Ctrl => Grant_signal);
end generate crossbar_switch10x10;


-- switch 11 ports
crossbar_switch11x11 : if number_of_ports = 11 generate

Switch_Crossbar11_11: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>11)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => crossbar_in_port(11),
   Port12_in => "00000000",
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in => crossbar_in_pulse(11),
   Port12_pulse_in =>'0' ,
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
   Port11_pulse_out => crossbar_out_pulse(11),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
  Port11_out => crossbar_out_port(11),
   Ctrl => Grant_signal);
end generate crossbar_switch11x11;


-- switch 12 ports
crossbar_switch12x12 : if number_of_ports = 12 generate

Switch_Crossbar12_12: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>12)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => crossbar_in_port(11),
   Port12_in => crossbar_in_port(12),
   Port13_in => "00000000",
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in => crossbar_in_pulse(11),
   Port12_pulse_in => crossbar_in_pulse(12),
   Port13_pulse_in =>'0' ,
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
   Port11_pulse_out => crossbar_out_pulse(11),
   Port12_pulse_out => crossbar_out_pulse(12),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
  Port11_out => crossbar_out_port(11),
  Port12_out => crossbar_out_port(12),
   Ctrl => Grant_signal);
end generate crossbar_switch12x12;


-- switch 13 ports
crossbar_switch13x13 : if number_of_ports = 13 generate

Switch_Crossbar13_13: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>13)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => crossbar_in_port(11),
   Port12_in => crossbar_in_port(12),
   Port13_in => crossbar_in_port(13),
   Port14_in => "00000000",
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in => crossbar_in_pulse(11),
   Port12_pulse_in => crossbar_in_pulse(12),
   Port13_pulse_in => crossbar_in_pulse(13),
   Port14_pulse_in =>'0' ,
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
   Port11_pulse_out => crossbar_out_pulse(11),
   Port12_pulse_out => crossbar_out_pulse(12),
   Port13_pulse_out => crossbar_out_pulse(13),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
  Port11_out => crossbar_out_port(11),
  Port12_out => crossbar_out_port(12),
  Port13_out => crossbar_out_port(13),
   Ctrl => Grant_signal);
end generate crossbar_switch13x13;


-- switch 14 ports
crossbar_switch14x14 : if number_of_ports = 14 generate

Switch_Crossbar14_14: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>14)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => crossbar_in_port(11),
   Port12_in => crossbar_in_port(12),
   Port13_in => crossbar_in_port(13),
   Port14_in => crossbar_in_port(14),
   Port15_in => "00000000",
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in => crossbar_in_pulse(11),
   Port12_pulse_in => crossbar_in_pulse(12),
   Port13_pulse_in => crossbar_in_pulse(13),
   Port14_pulse_in => crossbar_in_pulse(14),
   Port15_pulse_in =>'0' ,
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
   Port11_pulse_out => crossbar_out_pulse(11),
   Port12_pulse_out => crossbar_out_pulse(12),
   Port13_pulse_out => crossbar_out_pulse(13),
   Port14_pulse_out => crossbar_out_pulse(14),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
  Port11_out => crossbar_out_port(11),
  Port12_out => crossbar_out_port(12),
  Port13_out => crossbar_out_port(13),
  Port14_out => crossbar_out_port(14),
   Ctrl => Grant_signal);
end generate crossbar_switch14x14;


-- switch 15 ports
crossbar_switch15x15 : if number_of_ports = 15 generate

Switch_Crossbar15_15: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>15)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => crossbar_in_port(11),
   Port12_in => crossbar_in_port(12),
   Port13_in => crossbar_in_port(13),
   Port14_in => crossbar_in_port(14),
   Port15_in => crossbar_in_port(15),
   Port16_in => "00000000",
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in => crossbar_in_pulse(11),
   Port12_pulse_in => crossbar_in_pulse(12),
   Port13_pulse_in => crossbar_in_pulse(13),
   Port14_pulse_in => crossbar_in_pulse(14),
   Port15_pulse_in => crossbar_in_pulse(15),
   Port16_pulse_in =>'0' ,
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
   Port11_pulse_out => crossbar_out_pulse(11),
   Port12_pulse_out => crossbar_out_pulse(12),
   Port13_pulse_out => crossbar_out_pulse(13),
   Port14_pulse_out => crossbar_out_pulse(14),
   Port15_pulse_out => crossbar_out_pulse(15),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
  Port11_out => crossbar_out_port(11),
  Port12_out => crossbar_out_port(12),
  Port13_out => crossbar_out_port(13),
  Port14_out => crossbar_out_port(14),
  Port15_out => crossbar_out_port(15),
   Ctrl => Grant_signal);
end generate crossbar_switch15x15;


-- switch 16 ports
crossbar_switch16x16 : if number_of_ports = 16 generate

Switch_Crossbar16_16: Crossbar 
GENERIC MAP(number_of_crossbar_ports =>16)
  PORT MAP(
   Port1_in => crossbar_in_port(1),
   Port2_in => crossbar_in_port(2),
   Port3_in => crossbar_in_port(3),
   Port4_in => crossbar_in_port(4),
   Port5_in => crossbar_in_port(5),
   Port6_in => crossbar_in_port(6),
   Port7_in => crossbar_in_port(7),
   Port8_in => crossbar_in_port(8),
   Port9_in => crossbar_in_port(9),
   Port10_in => crossbar_in_port(10),
   Port11_in => crossbar_in_port(11),
   Port12_in => crossbar_in_port(12),
   Port13_in => crossbar_in_port(13),
   Port14_in => crossbar_in_port(14),
   Port15_in => crossbar_in_port(15),
   Port16_in => crossbar_in_port(16),
   Port1_pulse_in => crossbar_in_pulse(1),
   Port2_pulse_in => crossbar_in_pulse(2),
   Port3_pulse_in => crossbar_in_pulse(3),
   Port4_pulse_in => crossbar_in_pulse(4),
   Port5_pulse_in => crossbar_in_pulse(5),
   Port6_pulse_in => crossbar_in_pulse(6),
   Port7_pulse_in => crossbar_in_pulse(7),
   Port8_pulse_in => crossbar_in_pulse(8),
   Port9_pulse_in => crossbar_in_pulse(9),
   Port10_pulse_in => crossbar_in_pulse(10),
   Port11_pulse_in => crossbar_in_pulse(11),
   Port12_pulse_in => crossbar_in_pulse(12),
   Port13_pulse_in => crossbar_in_pulse(13),
   Port14_pulse_in => crossbar_in_pulse(14),
   Port15_pulse_in => crossbar_in_pulse(15),
   Port16_pulse_in => crossbar_in_pulse(16),
   Port1_pulse_out => crossbar_out_pulse(1),
   Port2_pulse_out => crossbar_out_pulse(2),
   Port3_pulse_out => crossbar_out_pulse(3),
   Port4_pulse_out => crossbar_out_pulse(4),
   Port5_pulse_out => crossbar_out_pulse(5),
   Port6_pulse_out => crossbar_out_pulse(6),
   Port7_pulse_out => crossbar_out_pulse(7),
   Port8_pulse_out => crossbar_out_pulse(8),
   Port9_pulse_out => crossbar_out_pulse(9),
   Port10_pulse_out => crossbar_out_pulse(10),
   Port11_pulse_out => crossbar_out_pulse(11),
   Port12_pulse_out => crossbar_out_pulse(12),
   Port13_pulse_out => crossbar_out_pulse(13),
   Port14_pulse_out => crossbar_out_pulse(14),
   Port15_pulse_out => crossbar_out_pulse(15),
   Port16_pulse_out => crossbar_out_pulse(16),
  Port1_out => crossbar_out_port(1),
  Port2_out => crossbar_out_port(2),
  Port3_out => crossbar_out_port(3),
  Port4_out => crossbar_out_port(4),
  Port5_out => crossbar_out_port(5),
  Port6_out => crossbar_out_port(6),
  Port7_out => crossbar_out_port(7),
  Port8_out => crossbar_out_port(8),
  Port9_out => crossbar_out_port(9),
  Port10_out => crossbar_out_port(10),
  Port11_out => crossbar_out_port(11),
  Port12_out => crossbar_out_port(12),
  Port13_out => crossbar_out_port(13),
  Port14_out => crossbar_out_port(14),
  Port15_out => crossbar_out_port(15),
  Port16_out => crossbar_out_port(16),
   Ctrl => Grant_signal);
end generate crossbar_switch16x16;
-- intstanciation et connexion du scheduler en fonction du nombre de ports
-- le circuit genere depend du parametre generique nombre de ports
-- switch 2 ports
scheduler_switch2x2 : if number_of_ports = 2 generate

Scheduler2_2: Scheduler 
   GENERIC MAP(number_of_ports => 2 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch2x2;


-- switch 3 ports
scheduler_switch3x3 : if number_of_ports = 3 generate

Scheduler3_3: Scheduler 
   GENERIC MAP(number_of_ports => 3 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch3x3;


-- switch 4 ports
scheduler_switch4x4 : if number_of_ports = 4 generate

Scheduler4_4: Scheduler 
   GENERIC MAP(number_of_ports => 4 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch4x4;


-- switch 5 ports
scheduler_switch5x5 : if number_of_ports = 5 generate

Scheduler5_5: Scheduler 
   GENERIC MAP(number_of_ports => 5 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch5x5;


-- switch 6 ports
scheduler_switch6x6 : if number_of_ports = 6 generate

Scheduler6_6: Scheduler 
   GENERIC MAP(number_of_ports => 6 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch6x6;


-- switch 7 ports
scheduler_switch7x7 : if number_of_ports = 7 generate

Scheduler7_7: Scheduler 
   GENERIC MAP(number_of_ports => 7 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch7x7;


-- switch 8 ports
scheduler_switch8x8 : if number_of_ports = 8 generate

Scheduler8_8: Scheduler 
   GENERIC MAP(number_of_ports => 8 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch8x8;


-- switch 9 ports
scheduler_switch9x9 : if number_of_ports = 9 generate

Scheduler9_9: Scheduler 
   GENERIC MAP(number_of_ports => 9 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch9x9;


-- switch 10 ports
scheduler_switch10x10 : if number_of_ports = 10 generate

Scheduler10_10: Scheduler 
   GENERIC MAP(number_of_ports => 10 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch10x10;


-- switch 11 ports
scheduler_switch11x11 : if number_of_ports = 11 generate

Scheduler11_11: Scheduler 
   GENERIC MAP(number_of_ports => 11 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch11x11;


-- switch 12 ports
scheduler_switch12x12 : if number_of_ports = 12 generate

Scheduler12_12: Scheduler 
   GENERIC MAP(number_of_ports => 12 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch12x12;


-- switch 13 ports
scheduler_switch13x13 : if number_of_ports = 13 generate

Scheduler13_13: Scheduler 
   GENERIC MAP(number_of_ports => 13 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch13x13;


-- switch 14 ports
scheduler_switch14x14 : if number_of_ports = 14 generate

Scheduler14_14: Scheduler 
   GENERIC MAP(number_of_ports => 14 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch14x14;


-- switch 15 ports
scheduler_switch15x15 : if number_of_ports = 15 generate

Scheduler15_15: Scheduler 
   GENERIC MAP(number_of_ports => 15 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch15x15;


-- switch 16 ports
scheduler_switch16x16 : if number_of_ports = 16 generate

Scheduler16_16: Scheduler 
   GENERIC MAP(number_of_ports => 16 ) 
   PORT MAP(
     Request => Request_signal,
     Fifo_full => fifo_out_full_signal,
     clk => clk,
     priority_rotation =>priority_rotation_signal,
     reset => reset,
     port_grant => grant_signal
    );

end generate scheduler_switch16x16;


end Behavioral;