----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    18:01:21 10/23/2012 
-- Design Name: 
-- Module Name:    proto_send - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
USE ieee.numeric_std.ALL;
use work.CoreTypes.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity proto_send is
generic (sizemem : natural := 64);
 port (
 clk,reset : in std_logic;
 fifo_empty,fifo_full : in std_logic;
  push : out std_logic:='0';
 fifo_in : out std_logic_vector(Word-1 downto 0);
 snd_start : in std_logic; --dbut de la rception
 snd_ack :in std_logic;   -- acquittement de la rception
 snd_comp : out std_logic; -- fin de la rception
 mem :in memory(0 to sizemem-1));

end proto_send;

architecture Behavioral of proto_send is
type typ_send is (s_head,s_len,s_len2,s_data,s_pulse,s_end);
 signal etsnd : typ_send;
 signal sfifo_in : std_logic_vector(Word-1 downto 0);
 signal spush : std_logic:='0';
 signal err : std_logic_vector(Word-1 downto 0):=(others =>'0');
begin

proc_send : process (clk,reset)
variable dlen,i: natural range 0 to 255 :=0;
	begin
	if reset='1' then 
				 etsnd<=s_head;
				 err<=(others =>'0');
				else  
						if rising_edge(clk) then -- le process s'excute sur chaque front 
															-- montant de l'horloge
						case etsnd is
						when s_head  =>
							sfifo_in<=mem(0);
							snd_comp<='0';
							i:=0;
							
							if fifo_empty='1' and snd_start='1' then
							spush<='1';
							snd_comp<='0';
							etsnd<=s_len;
							end if;
						when s_pulse =>
							spush<='1';
							etsnd<=s_len;
						when s_len  =>
							sfifo_in<=mem(1); --8 donnes
							i:=i+1;
							dlen:=to_integer(unsigned(mem(i)));
							if dlen > 2 then
								spush<='1';
								snd_comp<='0';
								etsnd<=s_data;
							else
								spush<='1';
								snd_comp<='1';
								etsnd<=s_end;
							
							end if;
						when s_len2 =>
							snd_comp<='0';
								etsnd<=s_data;
								
						when s_data  =>
								if (fifo_full='0') and (dlen >2) then 
								i:=i+1;
								sfifo_in<=mem(i);
									if i>=dlen-1 then --les indices 0 et 1 tant rservs
															--les donnes sont compts  partir de 2
										etsnd<=s_end;
										snd_comp<='1';
										spush<='1';
									else
										spush<='1';
									end if;
									
								else
								spush<='0';
								end if;
						
						when s_end  =>
								spush<='0';
								etsnd<=s_head;
								sfifo_in<=(others=>'-');
								if snd_ack='1' then
									etsnd<=s_head;
								end if;
						when others =>
								spush<='0';
								etsnd<=s_head;
								sfifo_in<=(others=>'0');
						end case;
						end if;
				end if;
	end process;
	
	-- affectation concurentes
	
	push<=spush;
	fifo_in<=sfifo_in;
end Behavioral;

