----------------------------------------------------------------------------------
-- Company: 
-- Engineer: KIEGAING EMMANUEL GEL EN 5
-- 
-- Create Date:    19:56:34 05/06/2011 
-- Design Name: 
-- Module Name:    Sheduler - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Module de l'ordonnanceur du switch crossbar
-- l'algorithme utilis est le DPA (diagonal propagation arbiter)
-- intencie un scheduler particulier en fonction du nombre de port
-- Dependencies: 
--
-- Revision: 1.0
-- reconstruction du dpa
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use Work.Sheduler_package.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity Scheduler is
   generic(number_of_ports : positive := 4);
    Port ( Request : in  STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1);
			  Fifo_full : in STD_LOGIC_VECTOR (number_of_ports downto 1);
           clk : in  STD_LOGIC;
	        reset : in  STD_LOGIC;
			  priority_rotation : in  STD_LOGIC_VECTOR (number_of_ports downto 1);
           port_grant : out  STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1));
      end Scheduler;
		
architecture Behavioral of Scheduler is
-- signaux pour le pipeline;
signal Request_latch :STD_LOGIC_VECTOR (number_of_ports*number_of_ports downto 1):=(others=>'0');
signal Fifo_full_latch : STD_LOGIC_VECTOR (number_of_ports downto 1):=(others=>'0');
signal priority_rotation_latch : STD_LOGIC_VECTOR (number_of_ports downto 1):=(others=>'1');
         
-- composants du scheduler
COMPONENT Scheduler2_2
   PORT(
      Request : IN std_logic_vector(4 downto 1);
      Fifo_full : IN std_logic_vector(2 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(4 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (2 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler3_3
   PORT(
      Request : IN std_logic_vector(9 downto 1);
      Fifo_full : IN std_logic_vector(3 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(9 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (3 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler4_4
   PORT(
      Request : IN std_logic_vector(16 downto 1);
      Fifo_full : IN std_logic_vector(4 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(16 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (4 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler5_5
   PORT(
      Request : IN std_logic_vector(25 downto 1);
      Fifo_full : IN std_logic_vector(5 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(25 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (5 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler6_6
   PORT(
      Request : IN std_logic_vector(36 downto 1);
      Fifo_full : IN std_logic_vector(6 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(36 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (6 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler7_7
   PORT(
      Request : IN std_logic_vector(49 downto 1);
      Fifo_full : IN std_logic_vector(7 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(49 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (7 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler8_8
   PORT(
      Request : IN std_logic_vector(64 downto 1);
      Fifo_full : IN std_logic_vector(8 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(64 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (8 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler9_9
   PORT(
      Request : IN std_logic_vector(81 downto 1);
      Fifo_full : IN std_logic_vector(9 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(81 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (9 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler10_10
   PORT(
      Request : IN std_logic_vector(100 downto 1);
      Fifo_full : IN std_logic_vector(10 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(100 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (10 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler11_11
   PORT(
      Request : IN std_logic_vector(121 downto 1);
      Fifo_full : IN std_logic_vector(11 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(121 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (11 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler12_12
   PORT(
      Request : IN std_logic_vector(144 downto 1);
      Fifo_full : IN std_logic_vector(12 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(144 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (12 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler13_13
   PORT(
      Request : IN std_logic_vector(169 downto 1);
      Fifo_full : IN std_logic_vector(13 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(169 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (13 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler14_14
   PORT(
      Request : IN std_logic_vector(196 downto 1);
      Fifo_full : IN std_logic_vector(14 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(196 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (14 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler15_15
   PORT(
      Request : IN std_logic_vector(225 downto 1);
      Fifo_full : IN std_logic_vector(15 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(225 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (15 downto 1)
   );
 END COMPONENT;

COMPONENT Scheduler16_16
   PORT(
      Request : IN std_logic_vector(256 downto 1);
      Fifo_full : IN std_logic_vector(16 downto 1);
      clk : IN std_logic;
      reset : IN std_logic;
      port_grant : OUT std_logic_vector(256 downto 1);
      priority_rotation : in  STD_LOGIC_VECTOR (16 downto 1)
   );
 END COMPONENT;


-- instanciation des scheduler
--======================scheduler 2 ports=======================

begin

-- instanciation des scheduler
--======================scheduler 2 ports=======================

scheduler2x2 : if number_of_ports = 2 generate

  Inst_Scheduler2_2 : Scheduler2_2
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler2x2; 

--======================scheduler 3 ports=======================

scheduler3x3 : if number_of_ports = 3 generate

  Inst_Scheduler3_3 : Scheduler3_3
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler3x3; 

--======================scheduler 4 ports=======================

scheduler4x4 : if number_of_ports = 4 generate

  Inst_Scheduler4_4 : Scheduler4_4
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler4x4; 

--======================scheduler 5 ports=======================

scheduler5x5 : if number_of_ports = 5 generate

  Inst_Scheduler5_5 : Scheduler5_5
   PORT MAP(
     Request => Request, 
     Fifo_full => Fifo_full,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation,
     port_grant =>port_grant);
end generate scheduler5x5; 

--======================scheduler 6 ports=======================

scheduler6x6 : if number_of_ports = 6 generate

  Inst_Scheduler6_6 : Scheduler6_6
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler6x6; 

--======================scheduler 7 ports=======================

scheduler7x7 : if number_of_ports = 7 generate

  Inst_Scheduler7_7 : Scheduler7_7
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler7x7; 

--======================scheduler 8 ports=======================

scheduler8x8 : if number_of_ports = 8 generate

  Inst_Scheduler8_8 : Scheduler8_8
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler8x8; 

--======================scheduler 9 ports=======================

scheduler9x9 : if number_of_ports = 9 generate

  Inst_Scheduler9_9 : Scheduler9_9
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler9x9; 

--======================scheduler 10 ports=======================

scheduler10x10 : if number_of_ports = 10 generate

  Inst_Scheduler10_10 : Scheduler10_10
   PORT MAP(
     Request => Request, 
     Fifo_full => Fifo_full,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation,
     port_grant =>port_grant);
end generate scheduler10x10; 

--======================scheduler 11 ports=======================

scheduler11x11 : if number_of_ports = 11 generate

  Inst_Scheduler11_11 : Scheduler11_11
   PORT MAP(
     Request => Request, 
     Fifo_full => Fifo_full,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation,
     port_grant =>port_grant);
end generate scheduler11x11; 

--======================scheduler 12 ports=======================

scheduler12x12 : if number_of_ports = 12 generate

  Inst_Scheduler12_12 : Scheduler12_12
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler12x12; 

--======================scheduler 13 ports=======================

scheduler13x13 : if number_of_ports = 13 generate

  Inst_Scheduler13_13 : Scheduler13_13
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler13x13; 

--======================scheduler 14 ports=======================

scheduler14x14 : if number_of_ports = 14 generate

  Inst_Scheduler14_14 : Scheduler14_14
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler14x14; 

--======================scheduler 15 ports=======================

scheduler15x15 : if number_of_ports = 15 generate

  Inst_Scheduler15_15 : Scheduler15_15
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler15x15; 

--======================scheduler 16 ports=======================

scheduler16x16 : if number_of_ports = 16 generate

  Inst_Scheduler16_16 : Scheduler16_16
   PORT MAP(
     Request => Request_latch, 
     Fifo_full => Fifo_full_latch,
     clk => clk ,
     reset =>reset,
     priority_rotation =>priority_rotation_latch,
     port_grant =>port_grant);
end generate scheduler16x16; 
Sched:process (clk,reset)
begin
if rising_edge(clk) then
	if reset='1' then
		request_latch<=(others=>'0');
		Fifo_full_latch<=(others=>'0');
		priority_rotation_latch<=(others=>'1');
	else
		request_latch<=request;
		Fifo_full_latch<=fifo_full;
		priority_rotation_latch<=priority_rotation;
	end if;
end if;
end process sched;
end Behavioral;

